(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17476,        644]
NotebookOptionsPosition[     13307,        502]
NotebookOutlinePosition[     14618,        539]
CellTagsIndexPosition[     14533,        534]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/Evaluation"], 
          "Non\[Hyphen]Standard Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonStandardEvaluation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Evaluation\"\>", 
       2->"\<\"Non\[Hyphen]Standard Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hold" :> Documentation`HelpLookup["paclet:ref/Hold"], 
          "HoldFirst" :> Documentation`HelpLookup["paclet:ref/HoldFirst"], 
          "HoldAll" :> Documentation`HelpLookup["paclet:ref/HoldAll"], 
          "HoldComplete" :> 
          Documentation`HelpLookup["paclet:ref/HoldComplete"], "ReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/ReplacePart"], "MapAt" :> 
          Documentation`HelpLookup["paclet:ref/MapAt"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Hold\"\>", 2->"\<\"HoldFirst\"\>", 
       3->"\<\"HoldAll\"\>", 4->"\<\"HoldComplete\"\>", 
       5->"\<\"ReplacePart\"\>", 6->"\<\"MapAt\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Evaluation Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Unevaluated", "ObjectName",
 CellID->31465],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Unevaluated",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Unevaluated"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the unevaluated form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " when it appears as the argument to a function. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27372]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{"Unevaluated", "[", 
    StyleBox["expr", "TI"], "]"}], "]"}]], "InlineFormula"],
 " effectively works by temporarily setting attributes so that ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " holds its argument unevaluated, then evaluating ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32031]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26212085],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->34591634],

Cell[TextData[{
 "Feed an unevaluated expression to ",
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->142474993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"5", "+", "6", "+", "7", "+", "8"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184151957],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->908307476]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1381],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " to suppress evaluation of symbols wherever it would occur:"
}], "ExampleText",
 CellID->647493465],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"symbolLength", ",", "HoldAll"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"symbolLength", "[", "s_Symbol", "]"}], ":=", 
  RowBox[{"StringLength", "[", 
   RowBox[{"SymbolName", "[", 
    RowBox[{"Unevaluated", "[", "s", "]"}], "]"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->102661486],

Cell["Find the length of a symbol's name even if it has a value:", \
"ExampleText",
 CellID->484084944],

Cell[BoxData[
 RowBox[{
  RowBox[{"xyzzy", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->392605825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"symbolLength", "[", "xyzzy", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->393731316],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->194896695]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28910],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " works only where it appears; it is not propagated:"
}], "ExampleText",
 CellID->109235286],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"g", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103606251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"1", "+", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->350010870],

Cell[BoxData[
 RowBox[{"g", "[", "2", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55824516]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43105934],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " stops ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->148761024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"1", "+", "2"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32540140],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147506849]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83274893],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " inside a held function remains:"
}], "ExampleText",
 CellID->231111757],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "HoldAll"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46140616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12018141],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->344643062]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20823],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldFirst",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldFirst"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldComplete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldComplete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAt"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5018]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21588],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "Tutorials",
 CellID->959752411],

Cell[TextData[ButtonBox["Non\[Hyphen]Standard Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonStandardEvaluation"]], "Tutorials",
 CellID->12955]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->442564274],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->239555810]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Unevaluated - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 15.5223338}", "context" -> "System`", 
    "keywords" -> {
     "preventing evaluation of arguments", "held expressions", "literal"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Unevaluated[expr] represents the unevaluated form of expr when it \
appears as the argument to a function. ", "synonyms" -> {}, "title" -> 
    "Unevaluated", "type" -> "Symbol", "uri" -> "ref/Unevaluated"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4700, 146, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->26212085]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14391, 527}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2377, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3000, 82, 49, 1, 70, "ObjectName",
 CellID->31465],
Cell[3052, 85, 611, 18, 70, "Usage",
 CellID->27372]
}, Open  ]],
Cell[CellGroupData[{
Cell[3700, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4178, 125, 485, 16, 70, "Notes",
 CellID->32031]
}, Closed]],
Cell[CellGroupData[{
Cell[4700, 146, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26212085],
Cell[CellGroupData[{
Cell[5084, 160, 147, 5, 70, "ExampleSection",
 CellID->34591634],
Cell[5234, 167, 214, 8, 70, "ExampleText",
 CellID->142474993],
Cell[CellGroupData[{
Cell[5473, 179, 184, 5, 28, "Input",
 CellID->184151957],
Cell[5660, 186, 158, 5, 36, "Output",
 CellID->908307476]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5867, 197, 222, 7, 70, "ExampleSection",
 CellID->1381],
Cell[6092, 206, 378, 13, 70, "ExampleText",
 CellID->647493465],
Cell[6473, 221, 367, 10, 70, "Input",
 CellID->102661486],
Cell[6843, 233, 103, 2, 70, "ExampleText",
 CellID->484084944],
Cell[6949, 237, 114, 4, 70, "Input",
 CellID->392605825],
Cell[CellGroupData[{
Cell[7088, 245, 112, 3, 70, "Input",
 CellID->393731316],
Cell[7203, 250, 158, 5, 36, "Output",
 CellID->194896695]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7410, 261, 233, 7, 70, "ExampleSection",
 CellID->28910],
Cell[7646, 270, 234, 7, 70, "ExampleText",
 CellID->109235286],
Cell[7883, 279, 150, 5, 70, "Input",
 CellID->103606251],
Cell[CellGroupData[{
Cell[8058, 288, 159, 5, 70, "Input",
 CellID->350010870],
Cell[8220, 295, 184, 6, 36, "Output",
 CellID->55824516]
}, Open  ]],
Cell[8419, 304, 124, 3, 70, "ExampleDelimiter",
 CellID->43105934],
Cell[8546, 309, 315, 12, 70, "ExampleText",
 CellID->148761024],
Cell[CellGroupData[{
Cell[8886, 325, 198, 6, 70, "Input",
 CellID->32540140],
Cell[9087, 333, 251, 8, 36, "Output",
 CellID->147506849]
}, Open  ]],
Cell[9353, 344, 124, 3, 70, "ExampleDelimiter",
 CellID->83274893],
Cell[9480, 349, 215, 7, 70, "ExampleText",
 CellID->231111757],
Cell[9698, 358, 137, 4, 70, "Input",
 CellID->46140616],
Cell[CellGroupData[{
Cell[9860, 366, 158, 5, 70, "Input",
 CellID->12018141],
Cell[10021, 373, 248, 8, 36, "Output",
 CellID->344643062]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10330, 388, 311, 9, 70, "SeeAlsoSection",
 CellID->20823],
Cell[10644, 399, 1430, 53, 70, "SeeAlso",
 CellID->5018]
}, Open  ]],
Cell[CellGroupData[{
Cell[12111, 457, 314, 9, 70, "TutorialsSection",
 CellID->21588],
Cell[12428, 468, 135, 3, 70, "Tutorials",
 CellID->959752411],
Cell[12566, 473, 163, 3, 70, "Tutorials",
 CellID->12955]
}, Open  ]],
Cell[CellGroupData[{
Cell[12766, 481, 319, 9, 70, "MoreAboutSection",
 CellID->442564274],
Cell[13088, 492, 147, 3, 70, "MoreAbout",
 CellID->239555810]
}, Open  ]],
Cell[13250, 498, 27, 0, 70, "History"],
Cell[13280, 500, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

