(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41467,       1587]
NotebookOptionsPosition[     32542,       1273]
NotebookOutlinePosition[     34064,       1314]
CellTagsIndexPosition[     33978,       1309]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combining Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/CombiningLists"], 
          "Lists as Sets" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsAsSets"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Combining Lists\"\>", 
       2->"\<\"Lists as Sets\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Join" :> Documentation`HelpLookup["paclet:ref/Join"], 
          "Intersection" :> 
          Documentation`HelpLookup["paclet:ref/Intersection"], "Complement" :> 
          Documentation`HelpLookup["paclet:ref/Complement"], "Tally" :> 
          Documentation`HelpLookup["paclet:ref/Tally"], "BinLists" :> 
          Documentation`HelpLookup["paclet:ref/BinLists"], "Split" :> 
          Documentation`HelpLookup["paclet:ref/Split"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Join\"\>", 2->"\<\"Intersection\"\>", 
       3->"\<\"Complement\"\>", 4->"\<\"Tally\"\>", 5->"\<\"BinLists\"\>", 
       6->"\<\"Split\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"Discrete Mathematics\"\>", 
       3->"\<\"Numerical Data\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Union ",
 StyleBox["(\[Union])", "OperatorCharacter"]
}], "ObjectName",
 CellID->5311],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Union",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Union"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a sorted list of all the distinct elements that \
appear in any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Union",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Union"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a sorted version of a list, in which all \
duplicated elements have been dropped. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14904]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are considered as sets, ",
 Cell[BoxData[
  ButtonBox["Union",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Union"]], "InlineFormula"],
 " gives their union. "
}], "Notes",
 CellID->1445],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Union",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Union"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " can be input in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["list", "TI"], 
    StyleBox["1", "TR"]], "\[Union]", 
   SubscriptBox[
    StyleBox["list", "TI"], 
    StyleBox["2", "TR"]], "\[Union]", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 ". The character ",
 Cell[BoxData["\[Union]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]un\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Union]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Union"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->24452],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " must have the same head, but it need not be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3681],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Union",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Union"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{
     ButtonBox["SameTest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SameTest"], "->", 
     StyleBox["test", "TI"]}]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " to each pair of elements in the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " to determine whether they should be considered the same. "
}], "Notes",
 CellID->14733]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->64637385],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->4075169],

Cell["Give a sorted list of distinct elements:", "ExampleText",
 CellID->5233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "1", ",", "3", ",", "6", ",", "2", ",", "2"}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22754],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "6"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8549]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12806],

Cell["Give a sorted list of distinct elements from all the lists:", \
"ExampleText",
 CellID->32404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "a", ",", "e", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9929],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10495]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1166],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]un\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->4925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "\[Union]", 
  RowBox[{"{", 
   RowBox[{"b", ",", "c", ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27468],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24125]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->361907120],

Cell["Give a list of the distinct lists:", "ExampleText",
 CellID->166464319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->278851726],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->337047662]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5251],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Union",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Union"]], "InlineFormula"],
 " works with any head, not just ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "b", ",", "a"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4562],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191307710]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32597],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SameTest",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->61468182],

Cell["Use equivalence classes based on absolute value: ", "ExampleText",
 CellID->5189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "2"}], ",", "1", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"SameTest", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", "#1", "]"}], "==", 
       RowBox[{"Abs", "[", "#2", "]"}]}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8544],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", "1", ",", "3"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126481302]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129774648],

Cell[TextData[{
 "Use equivalence classes based on ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->125388906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.1", ",", "3.4", ",", ".5", ",", "7.6", ",", "7.1", ",", "1.9"}], "}"}],
    ",", 
   RowBox[{"SameTest", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Floor", "[", "#1", "]"}], "\[Equal]", 
       RowBox[{"Floor", "[", "#2", "]"}]}], "&"}], ")"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->90794138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5`", ",", "1.1`", ",", "3.4`", ",", "7.1`"}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37543319]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1015277198],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Total",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Total"]], "InlineFormula"],
 " of list elements:"
}], "ExampleText",
 CellID->234558790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"SameTest", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Total", "[", "#1", "]"}], "\[Equal]", 
       RowBox[{"Total", "[", "#2", "]"}]}], "&"}], ")"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->12346999],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124223096]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291821094],

Cell["Use equality of last and first elements:", "ExampleText",
 CellID->405498523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4", ",", "3", ",", "2", ",", "1"}], "}"}]}], "}"}], 
   ",", " ", 
   RowBox[{"SameTest", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"First", "[", "#1", "]"}], "\[Equal]", 
       RowBox[{"Last", "[", "#2", "]"}]}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218838716],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157908051]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->73886500],

Cell["Find divisors that occur in any of 10, 12 and 20:", "ExampleText",
 CellID->98579031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"Divisors", "[", "10", "]"}], ",", 
   RowBox[{"Divisors", "[", "12", "]"}], ",", 
   RowBox[{"Divisors", "[", "20", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14979],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "10", ",", "12",
    ",", "20"}], "}"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136480651]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97337172],

Cell["\<\
Find all the triples of bits that occur in the binary decomposition of 10!:\
\>", "ExampleText",
 CellID->426460747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"IntegerDigits", "[", 
     RowBox[{
      RowBox[{"10", "!"}], ",", "2"}], "]"}], ",", "3", ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21540],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{487, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159031557]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71841146],

Cell["Find the distinct elements in the iteration:", "ExampleText",
 CellID->140406112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"5", "#"}], ",", "11"}], "]"}], "&"}], ",", "1", ",", "100"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5996],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "9"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220588257]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23414562],

Cell["Find what options are used by a list a functions:", "ExampleText",
 CellID->522873835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Options", "[", "#", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}], "&"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"FindFit", ",", " ", "FindMinimum", ",", " ", "FindRoot"}], 
      "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143610826],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "AccuracyGoal", ",", "Compiled", ",", "DampingFactor", ",", "Evaluated", 
   ",", "EvaluationMonitor", ",", "Gradient", ",", "Jacobian", ",", 
   "MaxIterations", ",", "Method", ",", "NormFunction", ",", "PrecisionGoal", 
   ",", "StepMonitor", ",", "WorkingPrecision"}], "}"}]], "Output",
 ImageSize->{427, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48990115]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->183256967],

Cell["Split on the sorted set gives lists of the same elements:", \
"ExampleText",
 CellID->10773002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ints", " ", "=", " ", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"9", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26536698],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "3", ",", "1", ",", "7", ",", "1", ",", "4", ",", "7", ",", "0", 
   ",", "9", ",", "5"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76771862]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"splits", " ", "=", " ", 
  RowBox[{"Split", "[", 
   RowBox[{"Sort", "[", "ints", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->138653422],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "7"}], "}"}], ",", 
   RowBox[{"{", "9", "}"}]}], "}"}]], "Output",
 ImageSize->{287, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70842981]
}, Open  ]],

Cell["\<\
The union is equivalent to the first elements of these lists:\
\>", "ExampleText",
 CellID->467994104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Union", "[", "ints", "]"}], " ", "===", " ", 
  RowBox[{"splits", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->95581509],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->79051613]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120982756],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tally",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tally"]], "InlineFormula"],
 " gets the count of identical elements and returns in original order:"
}], "ExampleText",
 CellID->7533698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ints", " ", "=", " ", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"9", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46079933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "4", ",", "7", ",", "0", ",", "6", ",", "1", ",", "3", ",", "0", 
   ",", "1", ",", "5"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->561735163]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tally", "=", " ", 
  RowBox[{"Tally", "[", "ints", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->146221924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{360, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141574150]
}, Open  ]],

Cell[TextData[{
 "The union is the sorted list of the elements returned by ",
 Cell[BoxData[
  ButtonBox["Tally",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tally"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->248573649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Union", "[", "ints", "]"}], " ", "===", " ", 
  RowBox[{"Sort", "[", 
   RowBox[{"tally", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->105098289],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->627486689]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->116962418],

Cell[TextData[{
 "For large sets Union may be slow with ",
 Cell[BoxData[
  ButtonBox["SameTest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SameTest"]], "InlineFormula"],
 " since it requires all pairwise comparisons:"
}], "ExampleText",
 CellID->83479783],

Cell[BoxData[
 RowBox[{
  RowBox[{"ints", " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1000", ",", "1000"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106138168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "[", 
   RowBox[{"u", "=", 
    RowBox[{"Union", "[", 
     RowBox[{"ints", ",", " ", 
      RowBox[{"SameTest", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Floor", "[", 
           RowBox[{"#1", "/", "2"}], "]"}], "\[Equal]", 
          RowBox[{"Floor", "[", 
           RowBox[{"#2", "/", "2"}], "]"}]}], "&"}], ")"}]}]}], "]"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111911607],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.7189999999999953`", ",", "429"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->79127722]
}, Open  ]],

Cell[TextData[{
 "When equivalence class representatives can be found, it may be faster to \
use ",
 Cell[BoxData[
  ButtonBox["Union",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Union"]], "InlineFormula"],
 " on these:"
}], "ExampleText",
 CellID->209664164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "[", 
   RowBox[{"fu", "=", 
    RowBox[{"2", "*", 
     RowBox[{"Union", "[", 
      RowBox[{"Floor", "[", 
       RowBox[{"ints", "/", "2"}], "]"}], "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->513955860],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "429"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->41593085]
}, Open  ]],

Cell["\<\
The results are the same except for the choice of representative:\
\>", "ExampleText",
 CellID->72231049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"u", "-", "fu"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->599924789],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->362441983]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5561],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Join",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Join"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Intersection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Intersection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Complement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complement"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tally",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tally"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinLists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinLists"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Split",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Split"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5756]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2350],

Cell[TextData[ButtonBox["Combining Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombiningLists"]], "Tutorials",
 CellID->32138],

Cell[TextData[ButtonBox["Lists as Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsAsSets"]], "Tutorials",
 CellID->12972]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->36498927],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->240496763],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->317277944],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->334381493]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Union (\[Union]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 17.5848866}", "context" -> "System`", 
    "keywords" -> {
     "combining lists", "distinct elements in lists", "merging lists", 
      "remove duplicates", "union of sets", "unique elements in lists", 
      "distinct elements in lists"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Union[list_1, list_2, ...] gives a sorted list of all the distinct \
elements that appear in any of the list_i. Union[list] gives a sorted version \
of a list, in which all duplicated elements have been dropped. ", 
    "synonyms" -> {}, "title" -> "Union", "type" -> "Symbol", "uri" -> 
    "ref/Union"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7758, 261, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->64637385]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33836, 1302}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2593, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3216, 86, 104, 4, 70, "ObjectName",
 CellID->5311],
Cell[3323, 92, 1201, 38, 70, "Usage",
 CellID->14904]
}, Open  ]],
Cell[CellGroupData[{
Cell[4561, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5039, 152, 325, 13, 70, "Notes",
 CellID->1445],
Cell[5367, 167, 1284, 46, 70, "Notes",
 CellID->24452],
Cell[6654, 215, 322, 13, 70, "Notes",
 CellID->3681],
Cell[6979, 230, 742, 26, 70, "Notes",
 CellID->14733]
}, Closed]],
Cell[CellGroupData[{
Cell[7758, 261, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->64637385],
Cell[CellGroupData[{
Cell[8142, 275, 146, 5, 70, "ExampleSection",
 CellID->4075169],
Cell[8291, 282, 78, 1, 70, "ExampleText",
 CellID->5233],
Cell[CellGroupData[{
Cell[8394, 287, 198, 6, 28, "Input",
 CellID->22754],
Cell[8595, 295, 218, 7, 36, "Output",
 CellID->8549]
}, Open  ]],
Cell[8828, 305, 121, 3, 70, "ExampleDelimiter",
 CellID->12806],
Cell[8952, 310, 100, 2, 70, "ExampleText",
 CellID->32404],
Cell[CellGroupData[{
Cell[9077, 316, 316, 10, 70, "Input",
 CellID->9929],
Cell[9396, 328, 229, 7, 36, "Output",
 CellID->10495]
}, Open  ]],
Cell[9640, 338, 120, 3, 70, "ExampleDelimiter",
 CellID->1166],
Cell[9763, 343, 186, 7, 70, "ExampleText",
 CellID->4925],
Cell[CellGroupData[{
Cell[9974, 354, 209, 7, 70, "Input",
 CellID->27468],
Cell[10186, 363, 219, 7, 36, "Output",
 CellID->24125]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10454, 376, 220, 7, 70, "ExampleSection",
 CellID->361907120],
Cell[10677, 385, 77, 1, 70, "ExampleText",
 CellID->166464319],
Cell[CellGroupData[{
Cell[10779, 390, 629, 22, 70, "Input",
 CellID->278851726],
Cell[11411, 414, 440, 15, 36, "Output",
 CellID->337047662]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11900, 435, 238, 7, 70, "ExampleSection",
 CellID->5251],
Cell[12141, 444, 314, 12, 70, "ExampleText",
 CellID->1234],
Cell[CellGroupData[{
Cell[12480, 460, 301, 10, 70, "Input",
 CellID->4562],
Cell[12784, 472, 218, 7, 36, "Output",
 CellID->191307710]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13051, 485, 218, 7, 70, "ExampleSection",
 CellID->32597],
Cell[CellGroupData[{
Cell[13294, 496, 228, 7, 70, "ExampleSubsection",
 CellID->61468182],
Cell[13525, 505, 87, 1, 70, "ExampleText",
 CellID->5189],
Cell[CellGroupData[{
Cell[13637, 510, 397, 13, 70, "Input",
 CellID->8544],
Cell[14037, 525, 232, 8, 36, "Output",
 CellID->126481302]
}, Open  ]],
Cell[14284, 536, 125, 3, 70, "ExampleDelimiter",
 CellID->129774648],
Cell[14412, 541, 210, 8, 70, "ExampleText",
 CellID->125388906],
Cell[CellGroupData[{
Cell[14647, 553, 427, 15, 70, "Input",
 CellID->90794138],
Cell[15077, 570, 235, 7, 36, "Output",
 CellID->37543319]
}, Open  ]],
Cell[15327, 580, 126, 3, 70, "ExampleDelimiter",
 CellID->1015277198],
Cell[15456, 585, 198, 8, 70, "ExampleText",
 CellID->234558790],
Cell[CellGroupData[{
Cell[15679, 597, 587, 20, 70, "Input",
 CellID->12346999],
Cell[16269, 619, 276, 10, 36, "Output",
 CellID->124223096]
}, Open  ]],
Cell[16560, 632, 125, 3, 70, "ExampleDelimiter",
 CellID->291821094],
Cell[16688, 637, 83, 1, 70, "ExampleText",
 CellID->405498523],
Cell[CellGroupData[{
Cell[16796, 642, 745, 24, 70, "Input",
 CellID->218838716],
Cell[17544, 668, 336, 12, 36, "Output",
 CellID->157908051]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[17941, 687, 226, 7, 70, "ExampleSection",
 CellID->73886500],
Cell[18170, 696, 91, 1, 70, "ExampleText",
 CellID->98579031],
Cell[CellGroupData[{
Cell[18286, 701, 241, 7, 70, "Input",
 CellID->14979],
Cell[18530, 710, 284, 9, 36, "Output",
 CellID->136480651]
}, Open  ]],
Cell[18829, 722, 124, 3, 70, "ExampleDelimiter",
 CellID->97337172],
Cell[18956, 727, 126, 3, 70, "ExampleText",
 CellID->426460747],
Cell[CellGroupData[{
Cell[19107, 734, 261, 9, 70, "Input",
 CellID->21540],
Cell[19371, 745, 667, 21, 36, "Output",
 CellID->159031557]
}, Open  ]],
Cell[20053, 769, 124, 3, 70, "ExampleDelimiter",
 CellID->71841146],
Cell[20180, 774, 87, 1, 70, "ExampleText",
 CellID->140406112],
Cell[CellGroupData[{
Cell[20292, 779, 275, 10, 70, "Input",
 CellID->5996],
Cell[20570, 791, 233, 7, 36, "Output",
 CellID->220588257]
}, Open  ]],
Cell[20818, 801, 124, 3, 70, "ExampleDelimiter",
 CellID->23414562],
Cell[20945, 806, 92, 1, 70, "ExampleText",
 CellID->522873835],
Cell[CellGroupData[{
Cell[21062, 811, 450, 14, 70, "Input",
 CellID->143610826],
Cell[21515, 827, 461, 11, 71, "Output",
 CellID->48990115]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22025, 844, 237, 7, 70, "ExampleSection",
 CellID->183256967],
Cell[22265, 853, 101, 2, 70, "ExampleText",
 CellID->10773002],
Cell[CellGroupData[{
Cell[22391, 859, 169, 5, 70, "Input",
 CellID->26536698],
Cell[22563, 866, 290, 9, 36, "Output",
 CellID->76771862]
}, Open  ]],
Cell[CellGroupData[{
Cell[22890, 880, 174, 5, 70, "Input",
 CellID->138653422],
Cell[23067, 887, 496, 17, 36, "Output",
 CellID->70842981]
}, Open  ]],
Cell[23578, 907, 112, 3, 70, "ExampleText",
 CellID->467994104],
Cell[CellGroupData[{
Cell[23715, 914, 222, 7, 70, "Input",
 CellID->95581509],
Cell[23940, 923, 160, 5, 36, "Output",
 CellID->79051613]
}, Open  ]],
Cell[24115, 931, 125, 3, 70, "ExampleDelimiter",
 CellID->120982756],
Cell[24243, 936, 237, 7, 70, "ExampleText",
 CellID->7533698],
Cell[CellGroupData[{
Cell[24505, 947, 169, 5, 70, "Input",
 CellID->46079933],
Cell[24677, 954, 291, 9, 36, "Output",
 CellID->561735163]
}, Open  ]],
Cell[CellGroupData[{
Cell[25005, 968, 136, 4, 70, "Input",
 CellID->146221924],
Cell[25144, 974, 597, 21, 36, "Output",
 CellID->141574150]
}, Open  ]],
Cell[25756, 998, 234, 8, 70, "ExampleText",
 CellID->248573649],
Cell[CellGroupData[{
Cell[26015, 1010, 256, 8, 70, "Input",
 CellID->105098289],
Cell[26274, 1020, 161, 5, 36, "Output",
 CellID->627486689]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26484, 1031, 230, 7, 70, "ExampleSection",
 CellID->116962418],
Cell[26717, 1040, 263, 8, 70, "ExampleText",
 CellID->83479783],
Cell[26983, 1050, 195, 6, 70, "Input",
 CellID->106138168],
Cell[CellGroupData[{
Cell[27203, 1060, 506, 16, 70, "Input",
 CellID->111911607],
Cell[27712, 1078, 222, 7, 36, "Output",
 CellID->79127722]
}, Open  ]],
Cell[27949, 1088, 265, 9, 70, "ExampleText",
 CellID->209664164],
Cell[CellGroupData[{
Cell[28239, 1101, 287, 9, 70, "Input",
 CellID->513955860],
Cell[28529, 1112, 206, 7, 36, "Output",
 CellID->41593085]
}, Open  ]],
Cell[28750, 1122, 115, 3, 70, "ExampleText",
 CellID->72231049],
Cell[CellGroupData[{
Cell[28890, 1129, 125, 4, 70, "Input",
 CellID->599924789],
Cell[29018, 1135, 203, 7, 36, "Output",
 CellID->362441983]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29282, 1149, 310, 9, 70, "SeeAlsoSection",
 CellID->5561],
Cell[29595, 1160, 1422, 53, 70, "SeeAlso",
 CellID->5756]
}, Open  ]],
Cell[CellGroupData[{
Cell[31054, 1218, 313, 9, 70, "TutorialsSection",
 CellID->2350],
Cell[31370, 1229, 140, 3, 70, "Tutorials",
 CellID->32138],
Cell[31513, 1234, 135, 3, 70, "Tutorials",
 CellID->12972]
}, Open  ]],
Cell[CellGroupData[{
Cell[31685, 1242, 318, 9, 70, "MoreAboutSection",
 CellID->36498927],
Cell[32006, 1253, 145, 3, 70, "MoreAbout",
 CellID->240496763],
Cell[32154, 1258, 151, 3, 70, "MoreAbout",
 CellID->317277944],
Cell[32308, 1263, 139, 3, 70, "MoreAbout",
 CellID->334381493]
}, Open  ]],
Cell[32462, 1269, 50, 0, 70, "History"],
Cell[32515, 1271, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

