(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21660,        801]
NotebookOptionsPosition[     16768,        636]
NotebookOutlinePosition[     18288,        677]
CellTagsIndexPosition[     18203,        672]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"How Modules Work" :> 
          Documentation`HelpLookup["paclet:tutorial/HowModulesWork"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"How Modules Work\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbol" :> Documentation`HelpLookup["paclet:ref/Symbol"], 
          "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"], "Names" :> 
          Documentation`HelpLookup["paclet:ref/Names"], "GeneratedParameters" :> 
          Documentation`HelpLookup["paclet:ref/GeneratedParameters"], 
          "Module" :> Documentation`HelpLookup["paclet:ref/Module"], 
          "CharacterRange" :> 
          Documentation`HelpLookup["paclet:ref/CharacterRange"], "Hash" :> 
          Documentation`HelpLookup["paclet:ref/Hash"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Symbol\"\>", 2->"\<\"ToExpression\"\>", 
       3->"\<\"Names\"\>", 4->"\<\"GeneratedParameters\"\>", 
       5->"\<\"Module\"\>", 6->"\<\"CharacterRange\"\>", 
       7->"\<\"Hash\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Namespace Management" :> 
          Documentation`HelpLookup["paclet:guide/NamespaceManagement"], 
          "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Namespace Management\"\>", 
       2->"\<\"Symbol Handling\"\>", 
       3->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Unique", "ObjectName",
 CellID->14294],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Unique",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Unique"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a new symbol, whose name is of the form ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"$", 
        StyleBox["nnn", "TI"]}]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Unique",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Unique"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a new symbol, with a name of the form ",
     Cell[BoxData[
      StyleBox[
       RowBox[{
        StyleBox["x", "TI"], "$", 
        StyleBox["nnn", "TI"]}]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Unique",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Unique"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list of new symbols. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Unique",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Unique"], "[", "\"\<\!\(\*
StyleBox[\"xxx\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a new symbol, with a name of the form ",
     Cell[BoxData[
      StyleBox["xxxnnn", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->12798]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Unique",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unique"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " numbers the symbols it creates using ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 ", and increments ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 " every time it is called. "
}], "Notes",
 CellID->1694],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Unique",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unique"], "[", "\"\<\!\(\*
StyleBox[\"xxx\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " numbers the symbols it creates sequentially, starting at 1 for each string \
",
 Cell[BoxData[
  StyleBox["xxx", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16744],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Unique",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unique"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["attr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["attr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " generates a symbol which has the attributes ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["attr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8511]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->74528502],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->874186583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unique", "[", "\"\<x\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35683577],

Cell[BoxData["x1"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220787353]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unique", "[", "sym", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->441974532],

Cell[BoxData["sym$149"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->175164858]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8098],

Cell["Create a unique symbol with no particular name:", "ExampleText",
 CellID->63846865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unique", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74189755],

Cell[BoxData["$1"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->674536551]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95371557],

Cell[TextData[{
 "Create a unique symbol whose name begins with ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->202697362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unique", "[", "\"\<x\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13049390],

Cell[BoxData["x1"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14636726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91932532],

Cell[TextData[{
 "Create a unique symbol in the way ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " does:"
}], "ExampleText",
 CellID->1000551520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unique", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->439381641],

Cell[BoxData["x$160"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114154911]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19882],

Cell[TextData[{
 "Each use of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Unique",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unique"], "[", 
   StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
 " increments ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->571083004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"$ModuleNumber", ",", 
   RowBox[{"Unique", "[", "x", "]"}], ",", "$ModuleNumber"}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->559802953],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"171", ",", "x$171", ",", "172"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4955635]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->199034147],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Unique",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unique"], "[", 
   StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
 " creates symbols in the same way ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " does:"
}], "ExampleText",
 CellID->116425668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", "x"}], "]"}], ",", 
   RowBox[{"Unique", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44044819],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x$1672", ",", "x$1673"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17514724]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->779301576],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Unique",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unique"], "[", "\"\<\!\(\*
StyleBox[\"x\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " uses the first unused symbol of the form ",
 Cell[BoxData[
  StyleBox["xnnn", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9516319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x1", ",", "x2", ",", "x4"}], "}"}], ";", 
  RowBox[{"Unique", "[", "\"\<x\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->428894502],

Cell[BoxData["x3"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174197171]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17975],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Symbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Symbol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Names",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Names"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneratedParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeneratedParameters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacterRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hash"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20440]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25223],

Cell[TextData[ButtonBox["How Modules Work",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/HowModulesWork"]], "Tutorials",
 CellID->2034]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Namespace Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "MoreAbout",
 CellID->366775479],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->776048382],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->514689148]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Unique - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 22.6787670}", "context" -> "System`", 
    "keywords" -> {
     "automatic unique names", "generate unique names", 
      "generating unique-named symbols", "gensym", 
      "names for dummy variables"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unique[] generates a new symbol, whose name is of the form $nnn. \
Unique[x] generates a new symbol, with a name of the form x$nnn. Unique[{x, \
y, ...}] generates a list of new symbols. Unique[\"xxx\"] generates a new \
symbol, with a name of the form xxxnnn. ", "synonyms" -> {}, "title" -> 
    "Unique", "type" -> "Symbol", "uri" -> "ref/Unique"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7326, 237, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->74528502]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18061, 665}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2640, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3263, 87, 44, 1, 70, "ObjectName",
 CellID->14294],
Cell[3310, 90, 1849, 59, 70, "Usage",
 CellID->12798]
}, Open  ]],
Cell[CellGroupData[{
Cell[5196, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5674, 171, 562, 19, 70, "Notes",
 CellID->1694],
Cell[6239, 192, 379, 13, 70, "Notes",
 CellID->16744],
Cell[6621, 207, 668, 25, 70, "Notes",
 CellID->8511]
}, Closed]],
Cell[CellGroupData[{
Cell[7326, 237, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->74528502],
Cell[CellGroupData[{
Cell[7710, 251, 148, 5, 70, "ExampleSection",
 CellID->874186583],
Cell[CellGroupData[{
Cell[7883, 260, 109, 3, 28, "Input",
 CellID->35683577],
Cell[7995, 265, 159, 5, 36, "Output",
 CellID->220787353]
}, Open  ]],
Cell[CellGroupData[{
Cell[8191, 275, 104, 3, 28, "Input",
 CellID->441974532],
Cell[8298, 280, 164, 5, 36, "Output",
 CellID->175164858]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8511, 291, 215, 7, 70, "ExampleSection",
 CellID->8098],
Cell[8729, 300, 89, 1, 70, "ExampleText",
 CellID->63846865],
Cell[CellGroupData[{
Cell[8843, 305, 96, 3, 70, "Input",
 CellID->74189755],
Cell[8942, 310, 159, 5, 36, "Output",
 CellID->674536551]
}, Open  ]],
Cell[9116, 318, 124, 3, 70, "ExampleDelimiter",
 CellID->95371557],
Cell[9243, 323, 167, 6, 70, "ExampleText",
 CellID->202697362],
Cell[CellGroupData[{
Cell[9435, 333, 109, 3, 70, "Input",
 CellID->13049390],
Cell[9547, 338, 158, 5, 36, "Output",
 CellID->14636726]
}, Open  ]],
Cell[9720, 346, 124, 3, 70, "ExampleDelimiter",
 CellID->91932532],
Cell[9847, 351, 219, 8, 70, "ExampleText",
 CellID->1000551520],
Cell[CellGroupData[{
Cell[10091, 363, 102, 3, 70, "Input",
 CellID->439381641],
Cell[10196, 368, 162, 5, 36, "Output",
 CellID->114154911]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10407, 379, 233, 7, 70, "ExampleSection",
 CellID->19882],
Cell[10643, 388, 393, 15, 70, "ExampleText",
 CellID->571083004],
Cell[CellGroupData[{
Cell[11061, 407, 185, 6, 70, "Input",
 CellID->559802953],
Cell[11249, 415, 220, 7, 36, "Output",
 CellID->4955635]
}, Open  ]],
Cell[11484, 425, 125, 3, 70, "ExampleDelimiter",
 CellID->199034147],
Cell[11612, 430, 388, 14, 70, "ExampleText",
 CellID->116425668],
Cell[CellGroupData[{
Cell[12025, 448, 233, 8, 70, "Input",
 CellID->44044819],
Cell[12261, 458, 213, 7, 36, "Output",
 CellID->17514724]
}, Open  ]],
Cell[12489, 468, 125, 3, 70, "ExampleDelimiter",
 CellID->779301576],
Cell[12617, 473, 349, 12, 70, "ExampleText",
 CellID->9516319],
Cell[CellGroupData[{
Cell[12991, 489, 193, 6, 70, "Input",
 CellID->428894502],
Cell[13187, 497, 159, 5, 36, "Output",
 CellID->174197171]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13407, 509, 311, 9, 70, "SeeAlsoSection",
 CellID->17975],
Cell[13721, 520, 1696, 62, 70, "SeeAlso",
 CellID->20440]
}, Open  ]],
Cell[CellGroupData[{
Cell[15454, 587, 314, 9, 70, "TutorialsSection",
 CellID->25223],
Cell[15771, 598, 140, 3, 70, "Tutorials",
 CellID->2034]
}, Open  ]],
Cell[CellGroupData[{
Cell[15948, 606, 299, 8, 70, "MoreAboutSection"],
Cell[16250, 616, 151, 3, 70, "MoreAbout",
 CellID->366775479],
Cell[16404, 621, 141, 3, 70, "MoreAbout",
 CellID->776048382],
Cell[16548, 626, 148, 3, 70, "MoreAbout",
 CellID->514689148]
}, Open  ]],
Cell[16711, 632, 27, 0, 70, "History"],
Cell[16741, 634, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

