(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32070,       1189]
NotebookOptionsPosition[     24837,        936]
NotebookOutlinePosition[     26188,        973]
CellTagsIndexPosition[     26103,        968]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IdentityMatrix" :> 
          Documentation`HelpLookup["paclet:ref/IdentityMatrix"], 
          "KroneckerDelta" :> 
          Documentation`HelpLookup["paclet:ref/KroneckerDelta"], "Normalize" :> 
          Documentation`HelpLookup["paclet:ref/Normalize"], "RotationMatrix" :> 
          Documentation`HelpLookup["paclet:ref/RotationMatrix"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IdentityMatrix\"\>", 
       2->"\<\"KroneckerDelta\"\>", 3->"\<\"Normalize\"\>", 
       4->"\<\"RotationMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"], 
          "New in 6.0: Matrix & Linear Algebra Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Operations on Vectors\"\>", 
       2->"\<\"New in 6.0: Matrix & Linear Algebra Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["UnitVector", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["UnitVector",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/UnitVector"], "[", 
       StyleBox["k", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the two-dimensional unit vector in the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " direction."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["UnitVector",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/UnitVector"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "-dimensional unit vector in the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " direction."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["UnitVector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnitVector"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " is a list of length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " with a 1 in position ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " and 0s elsewhere."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->457629559],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->53383173],

Cell[TextData[{
 "The unit vector in the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " direction in 2 dimensions:"
}], "ExampleText",
 CellID->61758313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitVector", "[", "1", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->427467185],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->558108404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6547445],

Cell[TextData[{
 "The unit vector in the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " direction in 3 dimensions:"
}], "ExampleText",
 CellID->53608997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitVector", "[", 
  RowBox[{"3", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51469336],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253682805]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["A unit vector in dimension 100:", "ExampleText",
 CellID->454348391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitVector", "[", 
  RowBox[{"100", ",", " ", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50598956],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW11LwzAUvV2dc4JuAxVBH/akvuifEPTJH1GGsD2IMvdz9bfEfNAhl6md
7Zqb2zNomibhnnOXk7Q7dE/Fav78UqwWs2L6uCze5ovZ+/ThdWmb8owo+yCi
+3OydWNr/nCfT3uEaqiNXZmXvYZGDV83HV96vKbj56acpR5VP08ijftr/IRl
1/PZDW3pGvusdxCp/QC4qr//oDqHQv11q28j2jNBqQORvTI5g1XKnKuujKNW
W4+BliQHvtdmBorShtYuB+xR+tGgKP1zDEVpyrh7aBIUVTolo4rncaRxVcfz
LIPb5arcp9y+Jt3ZSy1e3fin61nR4GSeme/rsSvOGXDb4XPiCjhYYCWud3ec
w/0Bz8ya0HbF4cJAK9rQoBWgxeYArehDg1aAFptD0IoW9+7SZ+Nyg0snLR5c
Orh0wG2HD1w6sOra/MKl04eGX0hAi80BWtGHBq0ALTYHaEUfGly6tl06/p7e
kF3Hdq1Sj7dt/Gs/KzlrPTRpu3Y3G7Ny1024Nfu2cEueazkVN6truE3xuTKb
VOXfp/6nB/J7L98bZfs5YCWhtw7ncC/wema7Zr2nIX7Pkfs8qBmtPodbU33/
gz5SQ4M+Upsx6AP6kIMGfaQ2Y2nqY9P/WX9ytUpPQLLLduezcqlU8c8o+wII
89/2\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{476, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388690642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->68524263],

Cell[TextData[{
 "A machine\[Hyphen]precision unit vector in the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " direction in 2 dimensions:"
}], "ExampleText",
 CellID->225472379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"UnitVector", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->393357417],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "1.`"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330270080]
}, Open  ]],

Cell[TextData[{
 "A 50\[Hyphen]digit precision unit vector in the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " direction in 2 dimensions:"
}], "ExampleText",
 CellID->524311533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"UnitVector", "[", "2", "]"}], ",", " ", "50"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->275180571],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1.`50."}], "}"}]], "Output",
 ImageSize->{394, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39219626]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Find the matrix for a \"black box\" linear operator:", "ExampleText",
 CellID->79273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"FourierDST", "[", 
     RowBox[{
      RowBox[{"UnitVector", "[", 
       RowBox[{"4", ",", " ", "i"}], "]"}], ",", " ", "\"\<IV\>\""}], "]"}], 
    ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25216112],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.13794968964147158`", ",", "0.3928474791935511`", ",", 
     "0.5879378012096794`", ",", "0.6935199226610738`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.39284747919355123`", ",", "0.6935199226610738`", ",", 
     "0.13794968964147153`", ",", 
     RowBox[{"-", "0.5879378012096794`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5879378012096795`", ",", "0.13794968964147147`", ",", 
     RowBox[{"-", "0.6935199226610739`"}], ",", "0.3928474791935512`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6935199226610741`", ",", 
     RowBox[{"-", "0.5879378012096796`"}], ",", "0.39284747919355123`", ",", 
     RowBox[{"-", "0.13794968964147156`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{568, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312263282]
}, Open  ]],

Cell["\<\
The matrix is equivalent to (though perhaps less efficient than) the \"black \
box\":\
\>", "ExampleText",
 CellID->97769869],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", " ", "4"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28467844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierDST", "[", 
  RowBox[{"r", ",", " ", "\"\<IV\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->232960727],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.1736721997760253`", ",", "0.7310666128614556`", ",", 
   "0.17977958940767158`", ",", "0.5281733518659625`"}], "}"}]], "Output",
 ImageSize->{262, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->112312219]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", "r"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->142045697],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.173672199776025`", ",", "0.7310666128614557`", ",", 
   "0.1797795894076715`", ",", "0.5281733518659627`"}], "}"}]], "Output",
 ImageSize->{262, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->165407118]
}, Open  ]],

Cell["\<\
The matrix form allows you to use typical linear algebra functions:\
\>", "ExampleText",
 CellID->71645179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "m", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->429324685],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.0000000000000002`"}], ",", "1.0000000000000002`", ",", 
   RowBox[{"-", "0.9999999999999999`"}], ",", "0.9999999999999999`"}], 
  "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->881546669]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->408103209],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " is a random permutation:"
}], "ExampleText",
 CellID->69625670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", " ", "=", " ", 
  RowBox[{"RandomSample", "[", 
   RowBox[{"Range", "[", "5", "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30805903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "2", ",", "5", ",", "1", ",", "3"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->441858062]
}, Open  ]],

Cell["Get the permutation matrix:", "ExampleText",
 CellID->420778173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mp", " ", "=", " ", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"UnitVector", "[", 
      RowBox[{"5", ",", " ", "#"}], "]"}], "&"}], ",", " ", "p"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->787062865],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->502151920]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mp", ".", 
  RowBox[{"Range", "[", "5", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->113306862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "2", ",", "5", ",", "1", ",", "3"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->110287242]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255900763],

Cell["Compute the unit matrices: ", "ExampleText",
 CellID->287645611],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i_", ",", "j_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m_", ",", "n_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"KroneckerProduct", "[", 
   RowBox[{
    RowBox[{"UnitVector", "[", 
     RowBox[{"m", ",", "i"}], "]"}], ",", 
    RowBox[{"UnitVector", "[", 
     RowBox[{"n", ",", "j"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520288879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->61074824],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwWAKxtgQDkP0fyAJj
y///gTQyyQoimefPn/8fDBi0wfz6+noonxmsigXMvH79+vbt20FMEJ8ZaCAP
Gs0OM+38+fPouqdPn45sJivIPTAAZDNwkSDKBjbm+/fvFRUVCHuYYaIQqyD2
UmQPxD/t7e1AQ0FMJrg9TMePH2elkvnAQAUGLar54PB6/vw5Nf2BiD9kexBx
TS17gIEFSVA0s4cDFkJQIUas9oDiB1sq5URTh123/qgqHOHIDaRZ4bFASDcp
sc0D1gsXHbVh1AaCOZoJZscgzDnUV9Xf30+EKkR9jqwKWF6+f/8eVzgyw3P0
/fv3169fD2Iil9/AqgNaq1Ornti/fz+Weg/oRKjt1LIHGGYo9Tf12yPsaLGA
sIcJGGaU+wPU3mEChgrYJGibDeF+JqqYjxEiUHsgjRBq2oMwEWIPqD7Blhp5
wbKQdioDIwCYzlLo\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->233704192]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["A random unit vector:", "ExampleText",
 CellID->314427998],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", " ", "1000"}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"k", " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "n"}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", " ", "=", " ", 
   RowBox[{"UnitVector", "[", 
    RowBox[{"n", ",", " ", "k"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->416452187],

Cell[TextData[{
 "The length is equal to ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->111648353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", "v", "]"}], " ", "\[Equal]", " ", "n"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->824815948],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->222310365]
}, Open  ]],

Cell[TextData[{
 "There is a 1 in position ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->128410579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Position", "[", 
   RowBox[{"v", ",", " ", "1"}], "]"}], " ", "\[Equal]", " ", 
  RowBox[{"{", 
   RowBox[{"{", "k", "}"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->273148805],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->306504161]
}, Open  ]],

Cell["All other components are zero:", "ExampleText",
 CellID->217735145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n", " ", "-", " ", 
  RowBox[{"Count", "[", 
   RowBox[{"v", ",", " ", "0"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->224098237],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->539477583]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 "For very large dimensions, ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", the vector given by ",
 Cell[BoxData[
  ButtonBox["UnitVector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitVector"]], "InlineFormula"],
 " may use a lot of memory:"
}], "ExampleText",
 CellID->241308705],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", " ", "=", " ", 
   RowBox[{"UnitVector", "[", 
    RowBox[{"1000000", ",", "21"}], "]"}]}], ";"}], "\n", 
 RowBox[{"ByteCount", "[", "v", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->546843562],

Cell[BoxData["4000076"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->257295742]
}, Open  ]],

Cell[TextData[{
 "An alternative is to use a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " to represent the same thing:"
}], "ExampleText",
 CellID->35655230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", "21", "}"}], "\[Rule]", "1"}], ",", " ", "1000000"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->761174591],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 1, ">"],
     Editable->False], ",", 
    RowBox[{"{", "1000000", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22194857]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "[", "s", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25438809],

Cell[BoxData["480"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->314801923]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IdentityMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IdentityMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KroneckerDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Normalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normalize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotationMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotationMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->769672259],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->265980075],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "MoreAbout",
 CellID->5767606]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UnitVector - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 24.3819356}", "context" -> "System`", 
    "keywords" -> {"direction vector", "normalized vector"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "UnitVector[k] gives the two-dimensional unit vector in the k\\[Null]^th \
direction. UnitVector[n, k] gives the n-dimensional unit vector in the \
k\\[Null]^th direction.", "synonyms" -> {"unit vector"}, "title" -> 
    "UnitVector", "type" -> "Symbol", "uri" -> "ref/UnitVector"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6253, 191, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->457629559]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25960, 961}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1756, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2379, 67, 1575, 37, 70, "ObjectNameGrid"],
Cell[3957, 106, 1286, 41, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5280, 152, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5758, 169, 458, 17, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[6253, 191, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->457629559],
Cell[CellGroupData[{
Cell[6638, 205, 147, 5, 70, "ExampleSection",
 CellID->53383173],
Cell[6788, 212, 169, 6, 70, "ExampleText",
 CellID->61758313],
Cell[CellGroupData[{
Cell[6982, 222, 106, 3, 28, "Input",
 CellID->427467185],
Cell[7091, 227, 203, 7, 36, "Output",
 CellID->558108404]
}, Open  ]],
Cell[7309, 237, 123, 3, 70, "ExampleDelimiter",
 CellID->6547445],
Cell[7435, 242, 169, 6, 70, "ExampleText",
 CellID->53608997],
Cell[CellGroupData[{
Cell[7629, 252, 128, 4, 70, "Input",
 CellID->51469336],
Cell[7760, 258, 213, 7, 36, "Output",
 CellID->253682805]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8022, 271, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8246, 280, 74, 1, 70, "ExampleText",
 CellID->454348391],
Cell[CellGroupData[{
Cell[8345, 285, 135, 4, 70, "Input",
 CellID->50598956],
Cell[8483, 291, 887, 19, 70, "Output",
 Evaluatable->False,
 CellID->388690642]
}, Open  ]],
Cell[9385, 313, 124, 3, 70, "ExampleDelimiter",
 CellID->68524263],
Cell[9512, 318, 194, 6, 70, "ExampleText",
 CellID->225472379],
Cell[CellGroupData[{
Cell[9731, 328, 134, 4, 70, "Input",
 CellID->393357417],
Cell[9868, 334, 207, 7, 36, "Output",
 CellID->330270080]
}, Open  ]],
Cell[10090, 344, 195, 6, 70, "ExampleText",
 CellID->524311533],
Cell[CellGroupData[{
Cell[10310, 354, 164, 5, 70, "Input",
 CellID->275180571],
Cell[10477, 361, 208, 7, 36, "Output",
 CellID->39219626]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10734, 374, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[10964, 383, 91, 1, 70, "ExampleText",
 CellID->79273],
Cell[CellGroupData[{
Cell[11080, 388, 376, 12, 70, "Input",
 CellID->25216112],
Cell[11459, 402, 905, 24, 54, "Output",
 CellID->312263282]
}, Open  ]],
Cell[12379, 429, 135, 4, 70, "ExampleText",
 CellID->97769869],
Cell[12517, 435, 187, 6, 70, "Input",
 CellID->28467844],
Cell[CellGroupData[{
Cell[12729, 445, 143, 4, 70, "Input",
 CellID->232960727],
Cell[12875, 451, 304, 9, 36, "Output",
 CellID->112312219]
}, Open  ]],
Cell[CellGroupData[{
Cell[13216, 465, 92, 3, 70, "Input",
 CellID->142045697],
Cell[13311, 470, 302, 9, 36, "Output",
 CellID->165407118]
}, Open  ]],
Cell[13628, 482, 117, 3, 70, "ExampleText",
 CellID->71645179],
Cell[CellGroupData[{
Cell[13770, 489, 107, 3, 70, "Input",
 CellID->429324685],
Cell[13880, 494, 337, 10, 36, "Output",
 CellID->881546669]
}, Open  ]],
Cell[14232, 507, 125, 3, 70, "ExampleDelimiter",
 CellID->408103209],
Cell[14360, 512, 139, 5, 70, "ExampleText",
 CellID->69625670],
Cell[CellGroupData[{
Cell[14524, 521, 173, 5, 70, "Input",
 CellID->30805903],
Cell[14700, 528, 233, 7, 36, "Output",
 CellID->441858062]
}, Open  ]],
Cell[14948, 538, 70, 1, 70, "ExampleText",
 CellID->420778173],
Cell[CellGroupData[{
Cell[15043, 543, 258, 9, 70, "Input",
 CellID->787062865],
Cell[15304, 554, 632, 18, 36, "Output",
 CellID->502151920]
}, Open  ]],
Cell[CellGroupData[{
Cell[15973, 577, 125, 4, 70, "Input",
 CellID->113306862],
Cell[16101, 583, 233, 7, 36, "Output",
 CellID->110287242]
}, Open  ]],
Cell[16349, 593, 125, 3, 70, "ExampleDelimiter",
 CellID->255900763],
Cell[16477, 598, 70, 1, 70, "ExampleText",
 CellID->287645611],
Cell[16550, 601, 457, 15, 70, "Input",
 CellID->520288879],
Cell[CellGroupData[{
Cell[17032, 620, 264, 9, 70, "Input",
 CellID->61074824],
Cell[17299, 631, 727, 16, 70, "Output",
 Evaluatable->False,
 CellID->233704192]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18075, 653, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[18316, 662, 64, 1, 70, "ExampleText",
 CellID->314427998],
Cell[18383, 665, 504, 16, 70, "Input",
 CellID->416452187],
Cell[18890, 683, 144, 6, 70, "ExampleText",
 CellID->111648353],
Cell[CellGroupData[{
Cell[19059, 693, 142, 4, 70, "Input",
 CellID->824815948],
Cell[19204, 699, 161, 5, 36, "Output",
 CellID->222310365]
}, Open  ]],
Cell[19380, 707, 146, 6, 70, "ExampleText",
 CellID->128410579],
Cell[CellGroupData[{
Cell[19551, 717, 220, 7, 70, "Input",
 CellID->273148805],
Cell[19774, 726, 161, 5, 36, "Output",
 CellID->306504161]
}, Open  ]],
Cell[19950, 734, 73, 1, 70, "ExampleText",
 CellID->217735145],
Cell[CellGroupData[{
Cell[20048, 739, 163, 5, 70, "Input",
 CellID->224098237],
Cell[20214, 746, 158, 5, 36, "Output",
 CellID->539477583]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20421, 757, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[20655, 766, 322, 11, 70, "ExampleText",
 CellID->241308705],
Cell[CellGroupData[{
Cell[21002, 781, 238, 7, 70, "Input",
 CellID->546843562],
Cell[21243, 790, 164, 5, 36, "Output",
 CellID->257295742]
}, Open  ]],
Cell[21422, 798, 243, 8, 70, "ExampleText",
 CellID->35655230],
Cell[CellGroupData[{
Cell[21690, 810, 237, 8, 70, "Input",
 CellID->761174591],
Cell[21930, 820, 458, 16, 36, "Output",
 CellID->22194857]
}, Open  ]],
Cell[CellGroupData[{
Cell[22425, 841, 104, 3, 70, "Input",
 CellID->25438809],
Cell[22532, 846, 160, 5, 36, "Output",
 CellID->314801923]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22753, 858, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[23072, 869, 983, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[24092, 909, 319, 9, 70, "MoreAboutSection",
 CellID->769672259],
Cell[24414, 920, 152, 3, 70, "MoreAbout",
 CellID->265980075],
Cell[24569, 925, 196, 4, 70, "MoreAbout",
 CellID->5767606]
}, Open  ]],
Cell[24780, 932, 27, 0, 70, "History"],
Cell[24810, 934, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

