(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24227,        937]
NotebookOptionsPosition[     17734,        715]
NotebookOutlinePosition[     19182,        755]
CellTagsIndexPosition[     19097,        750]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modifying Built\[Hyphen]in Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModifyingBuiltInFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Modifying Built\[Hyphen]in Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Protect" :> Documentation`HelpLookup["paclet:ref/Protect"], 
          "Locked" :> Documentation`HelpLookup["paclet:ref/Locked"], 
          "SetOptions" :> Documentation`HelpLookup["paclet:ref/SetOptions"], 
          "ClearAttributes" :> 
          Documentation`HelpLookup["paclet:ref/ClearAttributes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Protect\"\>", 2->"\<\"Locked\"\>", 
       3->"\<\"SetOptions\"\>", 
       4->"\<\"ClearAttributes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Attributes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Unprotect", "ObjectName",
 CellID->11643],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Unprotect",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Unprotect"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]removes the attribute ",
     Cell[BoxData[
      ButtonBox["Protected",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
     " for the symbols ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Unprotect",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Unprotect"], "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"form\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"form\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]unprotects all symbols whose names textually match any \
of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->26390]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A typical sequence in adding your own rules for built\[Hyphen]in functions \
is ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Unprotect", "[", 
    StyleBox["f", "TI"], "]"}], ";", 
   StyleBox["definition", "TI"], ";", 
   RowBox[{
    ButtonBox["Protect",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Protect"], "[", 
    StyleBox["f", "TI"], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31061]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->350948930],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->855547128],

Cell["Default behavior: ", "ExampleText",
 CellID->210663271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"x", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->477450311],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox["x", "2"]]], "Output",
 ImageSize->{36, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->755570616]
}, Open  ]],

Cell["Unprotect and modify the definition: ", "ExampleText",
 CellID->106380067],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", "Sqrt", "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3996249],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", 
   RowBox[{"x_", "^", "2"}], "]"}], ":=", "x"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->78069531],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "Sqrt", "]"}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->607048115],

Cell["New behavior: ", "ExampleText",
 CellID->437281074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"x", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->125032245],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->632662752]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->277937382],

Cell["Unprotect several symbols:", "ExampleText",
 CellID->462503159],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", 
   RowBox[{"f", ",", "g", ",", "h"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->473077628],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->486996115],

Cell["Unprotect all symbols in the current context:", "ExampleText",
 CellID->64101543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unprotect", "[", "\"\<`*\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408078213],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102794209]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->409682296],

Cell["Unprotect a system symbol to make a definition for it:", "ExampleText",
 CellID->84564791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"protected", "=", 
  RowBox[{"Unprotect", "[", "Sqrt", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->906585307],

Cell[BoxData[
 RowBox[{"{", "\<\"Sqrt\"\>", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->381261637]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", 
   RowBox[{"x_", "^", "2"}], "]"}], ":=", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->220282351],

Cell["Restore protection:", "ExampleText",
 CellID->150820276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Protect", "[", 
  RowBox[{"Evaluate", "[", "protected", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->84421882],

Cell[BoxData[
 RowBox[{"{", "\<\"Sqrt\"\>", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->618014553]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->405700832],

Cell["\<\
Unprotect and clear all symbols in a package, to allow it to be read twice:\
\>", "ExampleText",
 CellID->409801524],

Cell[BoxData[
 RowBox[{
  RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418054590],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Unprotect", "[", "\"\<`*\>\"", "]"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<`*\>\"", "]"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->367669465],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->561199423],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "f", "]"}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->196473886],

Cell[BoxData[
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->101762440]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->89451509],

Cell[TextData[{
 "Unprotecting a symbol is equivalent to clearing the ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->96204006],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"f", ",", "g"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186250009],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "f", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ClearAttributes", "[", 
   RowBox[{"g", ",", "Protected"}], "]"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->105125778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"{", 
   RowBox[{"f", ",", "g"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->78016570],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11691868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->330053039],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Unprotect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unprotect"]], "InlineFormula"],
 " returns the list of symbols actually unprotected:"
}], "ExampleText",
 CellID->307713138],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "f", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74178790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unprotect", "[", 
  RowBox[{"f", ",", "g"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41764131],

Cell[BoxData[
 RowBox[{"{", "\<\"f\"\>", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->407185509]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->164526888],

Cell["\<\
To modify definitions of a protected symbol, unprotect it first:\
\>", "ExampleText",
 CellID->360162091],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "f", "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->330197432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->788416547],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDelayed", "::", "\<\"write\"\>"}], ":", 
  " ", "\<\"Tag \\!\\(f\\) in \\!\\(f[x_]\\) is Protected.\"\>"}]], "Message",\
 "MSG",
 CellID->10846229],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1397031]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", "f", "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->603177675],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->123212235],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->277874558],

Cell[TextData[{
 "To unprotect all symbols given in a variable, use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->58277774],

Cell[BoxData[
 RowBox[{
  RowBox[{"syms", "=", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g", ",", "h"}], "}"}]}], ";", 
  RowBox[{"Protect", "/@", "syms"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520700977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unprotect", "[", 
  RowBox[{"Evaluate", "[", "syms", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->601487310],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"f\"\>", ",", "\<\"g\"\>", ",", "\<\"h\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52936780]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->261815148],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->80647171]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3470],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Protect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Protect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Locked",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locked"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClearAttributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearAttributes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9549]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30487],

Cell[TextData[ButtonBox["Modifying Built\[Hyphen]in Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ModifyingBuiltInFunctions"]], "Tutorials",
 CellID->19271]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->37695041]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Unprotect - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 24.7569452}", "context" -> "System`", 
    "keywords" -> {
     "redefine system function", "remove protected attribute", 
      "unprotect definitions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unprotect[s_1, s_2, ...] removes the attribute Protected for the symbols \
s_i. Unprotect[\"SubscriptBox[ form, 1]\", \"SubscriptBox[ form, 2]\", ...] \
unprotects all symbols whose names textually match any of the form_i. ", 
    "synonyms" -> {}, "title" -> "Unprotect", "type" -> "Symbol", "uri" -> 
    "ref/Unprotect"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5359, 176, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->350948930]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18954, 743}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2074, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2697, 79, 47, 1, 70, "ObjectName",
 CellID->11643],
Cell[2747, 82, 1632, 52, 70, "Usage",
 CellID->26390]
}, Open  ]],
Cell[CellGroupData[{
Cell[4416, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4894, 156, 428, 15, 70, "Notes",
 CellID->31061]
}, Closed]],
Cell[CellGroupData[{
Cell[5359, 176, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->350948930],
Cell[CellGroupData[{
Cell[5744, 190, 148, 5, 70, "ExampleSection",
 CellID->855547128],
Cell[5895, 197, 61, 1, 70, "ExampleText",
 CellID->210663271],
Cell[CellGroupData[{
Cell[5981, 202, 123, 4, 28, "Input",
 CellID->477450311],
Cell[6107, 208, 193, 7, 45, "Output",
 CellID->755570616]
}, Open  ]],
Cell[6315, 218, 80, 1, 70, "ExampleText",
 CellID->106380067],
Cell[6398, 221, 124, 4, 70, "Input",
 CellID->3996249],
Cell[6525, 227, 148, 5, 70, "Input",
 CellID->78069531],
Cell[6676, 234, 124, 4, 70, "Input",
 CellID->607048115],
Cell[6803, 240, 57, 1, 70, "ExampleText",
 CellID->437281074],
Cell[CellGroupData[{
Cell[6885, 245, 123, 4, 70, "Input",
 CellID->125032245],
Cell[7011, 251, 158, 5, 36, "Output",
 CellID->632662752]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7218, 262, 220, 7, 70, "ExampleSection",
 CellID->277937382],
Cell[7441, 271, 69, 1, 70, "ExampleText",
 CellID->462503159],
Cell[7513, 274, 157, 5, 70, "Input",
 CellID->473077628],
Cell[7673, 281, 125, 3, 70, "ExampleDelimiter",
 CellID->486996115],
Cell[7801, 286, 87, 1, 70, "ExampleText",
 CellID->64101543],
Cell[CellGroupData[{
Cell[7913, 291, 114, 3, 70, "Input",
 CellID->408078213],
Cell[8030, 296, 175, 6, 36, "Output",
 CellID->102794209]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8254, 308, 227, 7, 70, "ExampleSection",
 CellID->409682296],
Cell[8484, 317, 96, 1, 70, "ExampleText",
 CellID->84564791],
Cell[CellGroupData[{
Cell[8605, 322, 139, 4, 70, "Input",
 CellID->906585307],
Cell[8747, 328, 191, 6, 36, "Output",
 CellID->381261637]
}, Open  ]],
Cell[8953, 337, 149, 5, 70, "Input",
 CellID->220282351],
Cell[9105, 344, 62, 1, 70, "ExampleText",
 CellID->150820276],
Cell[CellGroupData[{
Cell[9192, 349, 145, 4, 70, "Input",
 CellID->84421882],
Cell[9340, 355, 191, 6, 36, "Output",
 CellID->618014553]
}, Open  ]],
Cell[9546, 364, 125, 3, 70, "ExampleDelimiter",
 CellID->405700832],
Cell[9674, 369, 126, 3, 70, "ExampleText",
 CellID->409801524],
Cell[9803, 374, 135, 4, 70, "Input",
 CellID->418054590],
Cell[9941, 380, 245, 8, 70, "Input",
 CellID->367669465],
Cell[10189, 390, 145, 5, 70, "Input",
 CellID->561199423],
Cell[10337, 397, 121, 4, 70, "Input",
 CellID->196473886],
Cell[10461, 403, 112, 4, 70, "Input",
 CellID->101762440]
}, Closed]],
Cell[CellGroupData[{
Cell[10610, 412, 236, 7, 70, "ExampleSection",
 CellID->89451509],
Cell[10849, 421, 246, 8, 70, "ExampleText",
 CellID->96204006],
Cell[11098, 431, 145, 5, 70, "Input",
 CellID->186250009],
Cell[11246, 438, 227, 7, 70, "Input",
 CellID->105125778],
Cell[CellGroupData[{
Cell[11498, 449, 152, 5, 70, "Input",
 CellID->78016570],
Cell[11653, 456, 240, 9, 36, "Output",
 CellID->11691868]
}, Open  ]],
Cell[11908, 468, 125, 3, 70, "ExampleDelimiter",
 CellID->330053039],
Cell[12036, 473, 229, 7, 70, "ExampleText",
 CellID->307713138],
Cell[12268, 482, 120, 4, 70, "Input",
 CellID->74178790],
Cell[CellGroupData[{
Cell[12413, 490, 127, 4, 70, "Input",
 CellID->41764131],
Cell[12543, 496, 188, 6, 36, "Output",
 CellID->407185509]
}, Open  ]],
Cell[12746, 505, 125, 3, 70, "ExampleDelimiter",
 CellID->164526888],
Cell[12874, 510, 115, 3, 70, "ExampleText",
 CellID->360162091],
Cell[12992, 515, 229, 8, 70, "Input",
 CellID->330197432],
Cell[CellGroupData[{
Cell[13246, 527, 145, 5, 70, "Input",
 CellID->788416547],
Cell[13394, 534, 185, 5, 70, "Message",
 CellID->10846229],
Cell[13582, 541, 162, 5, 36, "Output",
 CellID->1397031]
}, Open  ]],
Cell[13759, 549, 123, 4, 70, "Input",
 CellID->603177675],
Cell[13885, 555, 145, 5, 70, "Input",
 CellID->123212235],
Cell[14033, 562, 125, 3, 70, "ExampleDelimiter",
 CellID->277874558],
Cell[14161, 567, 232, 8, 70, "ExampleText",
 CellID->58277774],
Cell[14396, 577, 215, 7, 70, "Input",
 CellID->520700977],
Cell[CellGroupData[{
Cell[14636, 588, 143, 4, 70, "Input",
 CellID->601487310],
Cell[14782, 594, 238, 8, 36, "Output",
 CellID->52936780]
}, Open  ]],
Cell[CellGroupData[{
Cell[15057, 607, 106, 3, 70, "Input",
 CellID->261815148],
Cell[15166, 612, 174, 6, 36, "Output",
 CellID->80647171]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15401, 625, 310, 9, 70, "SeeAlsoSection",
 CellID->3470],
Cell[15714, 636, 952, 35, 70, "SeeAlso",
 CellID->9549]
}, Open  ]],
Cell[CellGroupData[{
Cell[16703, 676, 314, 9, 70, "TutorialsSection",
 CellID->30487],
Cell[17020, 687, 172, 3, 70, "Tutorials",
 CellID->19271]
}, Open  ]],
Cell[CellGroupData[{
Cell[17229, 695, 299, 8, 70, "MoreAboutSection"],
Cell[17531, 705, 131, 3, 70, "MoreAbout",
 CellID->37695041]
}, Open  ]],
Cell[17677, 711, 27, 0, 70, "History"],
Cell[17707, 713, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

