(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18265,        695]
NotebookOptionsPosition[     13194,        521]
NotebookOutlinePosition[     14576,        559]
CellTagsIndexPosition[     14491,        554]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Values for Symbols" :> 
          Documentation`HelpLookup["paclet:tutorial/ValuesForSymbols"], 
          "Making Definitions" :> 
          Documentation`HelpLookup["paclet:tutorial/MakingDefinitions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Values for Symbols\"\>", 
       2->"\<\"Making Definitions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Clear" :> Documentation`HelpLookup["paclet:ref/Clear"], 
          "TagUnset" :> Documentation`HelpLookup["paclet:ref/TagUnset"], 
          "Set" :> Documentation`HelpLookup["paclet:ref/Set"], "SetDelayed" :> 
          Documentation`HelpLookup["paclet:ref/SetDelayed"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Clear\"\>", 2->"\<\"TagUnset\"\>", 
       3->"\<\"Set\"\>", 4->"\<\"SetDelayed\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Variables and Functions" :> 
          Documentation`HelpLookup["paclet:guide/VariablesAndFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Variables and Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Unset ",
 StyleBox["(=.)", "OperatorCharacter"]
}], "ObjectName",
 CellID->10751],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "=."}]], "InlineFormula"],
     "\[LineSeparator]removes any rules defined for ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->872]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Rules are removed only when their left\[Hyphen]hand sides are identical to \
",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 ", and the tests in ",
 Cell[BoxData[
  ButtonBox["Condition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Condition"]], "InlineFormula"],
 " given on the right\[Hyphen]hand side are also identical. "
}], "Notes",
 CellID->25652]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->422438150],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->315394071],

Cell["Undefine a value:", "ExampleText",
 CellID->296470120],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218939752],

Cell[BoxData[
 RowBox[{"x", "=."}]], "Input",
 CellLabel->"In[2]:=",
 CellID->783074262],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellLabel->"In[3]:=",
 CellID->19729699],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->710730437]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->284659401],

Cell["Undefine a function:", "ExampleText",
 CellID->259680274],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96370862],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "=."}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16907967]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2050],

Cell["Clear values of variables:", "ExampleText",
 CellID->301706367],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126604733],

Cell[BoxData[
 RowBox[{"x", "=."}]], "Input",
 CellLabel->"In[2]:=",
 CellID->168486254],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellLabel->"In[3]:=",
 CellID->53040972],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->870438650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->102575277],

Cell["Clear functions (downvalues):", "ExampleText",
 CellID->37454990],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179882384],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "=."}]], "Input",
 CellLabel->"In[2]:=",
 CellID->371484883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "5", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->312638351],

Cell[BoxData[
 RowBox[{"f", "[", "5", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->366169018]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9450],

Cell[TextData[{
 "Use ",
 Cell[BoxData["=."], "InlineFormula"],
 " to clear definitions with a particular left-hand side:"
}], "ExampleText",
 CellID->292515749],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fact", "[", "1", "]"}], "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fact", "[", "n_", "]"}], ":=", 
  RowBox[{"n", " ", 
   RowBox[{"fact", "[", 
    RowBox[{"n", "-", "1"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->751248781],

Cell[BoxData[
 RowBox[{
  RowBox[{"fact", "[", "1", "]"}], "=."}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37722120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "fact", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->43396380],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVcFOwzAM9dIk02B0bJfCZUxIfAfiAD3xEdWEtB0QaOyzEL8YnNYurUnV
dt0gUuLafY7t19R5zvabl9dsv11nq3SXvW+264/V09sOTdEIQD0CwOwK8Nnh
Uz55pDgBbnBVaF6QfCC5JOmRXyUSonIHmOBiUY2E/V7oS6H75TPfsXAtRkSq
QalQet2Q1B6mq7l7a2HmcSaiWMo/DqI1RRoS8YJ8dWN9SrzJyzXVXYFi/7aG
sZLrsO95AxdctQ162X/K9lKgjsJnBWVa9G4cJkM5G5wRf73xwXx5pD4ZQ1PX
53QdN5eTnKHW8xzKTQVqmgid/8dZA15m/xc5xp0ZDHVt7pn8Rcu+WOuhCure
0wZe4gDWup+OfVi0eecKJTeLFk7l+9ue/knnzLj6a1e/te+EPSFpnLzFmZ20
pwajb6rYZrk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->80859010]
}, Open  ]],

Cell["Clear all definitions:", "ExampleText",
 CellID->55533200],

Cell[BoxData[
 RowBox[{"Clear", "[", "fact", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->216930195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "fact", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->317841575],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`fact],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->77401773]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12746],

Cell["To clear an upvalue, the tag has to be given:", "ExampleText",
 CellID->454166266],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"fh", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->392493858],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "x_", "]"}], "]"}], "=."}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->118656949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "h", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13194908],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`h],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->330346992]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14183],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clear",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clear"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagUnset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagUnset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21960]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22189],

Cell[TextData[ButtonBox["Values for Symbols",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ValuesForSymbols"]], "Tutorials",
 CellID->27866],

Cell[TextData[ButtonBox["Making Definitions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingDefinitions"]], "Tutorials",
 CellID->7418]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->58720472],

Cell[TextData[ButtonBox["Variables and Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariablesAndFunctions"]], "MoreAbout",
 CellID->200139640]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Unset (=.) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 25.3038342}", "context" -> "System`", 
    "keywords" -> {
     "clearing values", "clearing values of symbols", "deleting values", 
      "erasing values", "killing values", "removing assignments", 
      "removing values", "undefining symbols", "unset", "unsetting symbols"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "lhs =. removes any rules defined for lhs. ", "synonyms" -> {"=."}, 
    "title" -> "Unset", "type" -> "Symbol", "uri" -> "ref/Unset"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4255, 137, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->422438150]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14348, 547}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2141, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2764, 77, 99, 4, 70, "ObjectName",
 CellID->10751],
Cell[2866, 83, 445, 15, 70, "Usage",
 CellID->872]
}, Open  ]],
Cell[CellGroupData[{
Cell[3348, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3826, 120, 392, 12, 70, "Notes",
 CellID->25652]
}, Closed]],
Cell[CellGroupData[{
Cell[4255, 137, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->422438150],
Cell[CellGroupData[{
Cell[4640, 151, 148, 5, 70, "ExampleSection",
 CellID->315394071],
Cell[4791, 158, 60, 1, 70, "ExampleText",
 CellID->296470120],
Cell[4854, 161, 110, 4, 70, "Input",
 CellID->218939752],
Cell[4967, 167, 88, 3, 70, "Input",
 CellID->783074262],
Cell[CellGroupData[{
Cell[5080, 174, 69, 2, 28, "Input",
 CellID->19729699],
Cell[5152, 178, 158, 5, 36, "Output",
 CellID->710730437]
}, Open  ]],
Cell[5325, 186, 125, 3, 70, "ExampleDelimiter",
 CellID->284659401],
Cell[5453, 191, 63, 1, 70, "ExampleText",
 CellID->259680274],
Cell[5519, 194, 144, 5, 70, "Input",
 CellID->96370862],
Cell[5666, 201, 116, 4, 70, "Input",
 CellID->16907967]
}, Open  ]],
Cell[CellGroupData[{
Cell[5819, 210, 215, 7, 70, "ExampleSection",
 CellID->2050],
Cell[6037, 219, 69, 1, 70, "ExampleText",
 CellID->301706367],
Cell[6109, 222, 110, 4, 70, "Input",
 CellID->126604733],
Cell[6222, 228, 88, 3, 70, "Input",
 CellID->168486254],
Cell[CellGroupData[{
Cell[6335, 235, 69, 2, 70, "Input",
 CellID->53040972],
Cell[6407, 239, 158, 5, 36, "Output",
 CellID->870438650]
}, Open  ]],
Cell[6580, 247, 125, 3, 70, "ExampleDelimiter",
 CellID->102575277],
Cell[6708, 252, 71, 1, 70, "ExampleText",
 CellID->37454990],
Cell[6782, 255, 145, 5, 70, "Input",
 CellID->179882384],
Cell[6930, 262, 117, 4, 70, "Input",
 CellID->371484883],
Cell[CellGroupData[{
Cell[7072, 270, 97, 3, 70, "Input",
 CellID->312638351],
Cell[7172, 275, 185, 6, 36, "Output",
 CellID->366169018]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7406, 287, 232, 7, 70, "ExampleSection",
 CellID->9450],
Cell[7641, 296, 161, 5, 70, "ExampleText",
 CellID->292515749],
Cell[7805, 303, 290, 10, 70, "Input",
 CellID->751248781],
Cell[8098, 315, 118, 4, 70, "Input",
 CellID->37722120],
Cell[CellGroupData[{
Cell[8241, 323, 108, 3, 70, "Input",
 CellID->43396380],
Cell[8352, 328, 650, 15, 70, "Output",
 Evaluatable->False,
 CellID->80859010]
}, Open  ]],
Cell[9017, 346, 64, 1, 70, "ExampleText",
 CellID->55533200],
Cell[9084, 349, 104, 3, 70, "Input",
 CellID->216930195],
Cell[CellGroupData[{
Cell[9213, 356, 109, 3, 70, "Input",
 CellID->317841575],
Cell[9325, 361, 233, 8, 36, "Output",
 CellID->77401773]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9607, 375, 226, 7, 70, "ExampleSection",
 CellID->12746],
Cell[9836, 384, 88, 1, 70, "ExampleText",
 CellID->454166266],
Cell[9927, 387, 191, 6, 70, "Input",
 CellID->392493858],
Cell[10121, 395, 172, 6, 70, "Input",
 CellID->118656949],
Cell[CellGroupData[{
Cell[10318, 405, 105, 3, 70, "Input",
 CellID->13194908],
Cell[10426, 410, 231, 8, 36, "Output",
 CellID->330346992]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10718, 425, 311, 9, 70, "SeeAlsoSection",
 CellID->14183],
Cell[11032, 436, 929, 35, 70, "SeeAlso",
 CellID->21960]
}, Open  ]],
Cell[CellGroupData[{
Cell[11998, 476, 314, 9, 70, "TutorialsSection",
 CellID->22189],
Cell[12315, 487, 145, 3, 70, "Tutorials",
 CellID->27866],
Cell[12463, 492, 145, 3, 70, "Tutorials",
 CellID->7418]
}, Open  ]],
Cell[CellGroupData[{
Cell[12645, 500, 318, 9, 70, "MoreAboutSection",
 CellID->58720472],
Cell[12966, 511, 156, 3, 70, "MoreAbout",
 CellID->200139640]
}, Open  ]],
Cell[13137, 517, 27, 0, 70, "History"],
Cell[13167, 519, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

