(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22213,        825]
NotebookOptionsPosition[     17007,        644]
NotebookOutlinePosition[     18453,        684]
CellTagsIndexPosition[     18368,        679]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Associating Definitions with Different Symbols" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AssociatingDefinitionsWithDifferentSymbols"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Associating Definitions with Different Symbols\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TagSet" :> Documentation`HelpLookup["paclet:ref/TagSet"], 
          "UpSetDelayed" :> 
          Documentation`HelpLookup["paclet:ref/UpSetDelayed"], "UpValues" :> 
          Documentation`HelpLookup["paclet:ref/UpValues"], "Unset" :> 
          Documentation`HelpLookup["paclet:ref/Unset"], "ClearAll" :> 
          Documentation`HelpLookup["paclet:ref/ClearAll"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TagSet\"\>", 
       2->"\<\"UpSetDelayed\"\>", 3->"\<\"UpValues\"\>", 4->"\<\"Unset\"\>", 
       5->"\<\"ClearAll\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Package Development\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "UpSet ",
 StyleBox["(^=)", "OperatorCharacter"]
}], "ObjectName",
 CellID->18380],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "^=", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]assigns ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " to be the value of ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ", and associates the assignment with symbols that occur at level one in \
",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28145]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    RowBox[{
     StyleBox["g", "TI"], "[", 
     StyleBox["x", "TI"], "]"}], "]"}], "=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 " makes an assignment associated with ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    RowBox[{
     StyleBox["g", "TI"], "[", 
     StyleBox["x", "TI"], "]"}], "]"}], "^=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 " makes an assignment associated instead with ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5672],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UpSet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpSet"]], "InlineFormula"],
 " associates an assignment with ",
 Cell[BoxData[
  StyleBox["all", "TI"]], "InlineFormula"],
 " the distinct symbols that occur either directly as arguments of ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 ", or as the heads of arguments of ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13311]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->363494255],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->177124986],

Cell["Define a symbolic property of a symbol:", "ExampleText",
 CellID->87490164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"area", "[", "square", "]"}], "^=", 
  RowBox[{"s", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493040914],

Cell[BoxData[
 SuperscriptBox["s", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9362699]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->83880245],

Cell[TextData[{
 Cell[BoxData["^="], "InlineFormula"],
 " defines upvalues:"
}], "ExampleText",
 CellID->657251282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"area", "[", "square", "]"}], "^=", 
  RowBox[{"s", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11321373],

Cell[BoxData[
 SuperscriptBox["s", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->826481116]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpValues", "[", "square", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57398660],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"area", "[", "square", "]"}], "]"}], "\[RuleDelayed]", 
   SuperscriptBox["s", "2"]}], "}"}]], "Output",
 ImageSize->{222, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->200291316]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->352834724],

Cell["\<\
If several symbols appear in the left-hand side, upvalues for all of them are \
defined:\
\>", "ExampleText",
 CellID->66580961],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"prop", "[", 
    RowBox[{"a", ",", 
     RowBox[{"b", "[", "c", "]"}]}], "]"}], "^=", "value"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182692304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->262710777],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVktOwzAQde2k4duUqgsWLMIS7gFZcYioQmoXCFR6IuAAiKsgzhNsx5NO
H+OGUFVYiifzZjy/jO3cVav5/UO1WsyqolxWT/PF7Lm4fVxayAyU0jdKqfxc
2ffavvmHRmkfpS7sbCw8CTSzVFt67KSm1VdjhjuaBuqEX97SCawYAT8Bfgj8
UbB4BjhGkgDvpk8fgbZzGmLDFc7ygaWJpSbomZCzCTiu43ocTyN+yJ7kf1sl
yE/jqBkUlwZch1jdwpcGDlI3ayFS9ESVUCnvBiXkaUQtLaKYY1xLhy7bxca2
6tLXyRjeZvc7n5ynjKHj3nrX/vSfai777cobdyfq813as7pydmJ9qdsz0Nh/
LelM2E/1qEeH0TySXtUjsPtEwMicnE6EttcT7kNTJKJnaX+IvNiXf1/ddQqM
oxHv1KU/0HXVndwZOYxUmG7WjVM+ghlWXS6L3Tgj9tXimlJPIZ8Hi42ABuWW
Mj/N0CxSisbhr345/gNcAz8FHruz6+4vgHfTu/ecg+QqxDitN/sd/2cu6/V/
zYe3RJmWPTk1+AZMKwIs\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74773249]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "b", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->600089318],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVVs1OwzAMzpJ2/G9j2oEDh3KE94CdeIhqQtoOCDT2RMADIF4F8Twlae3i
fnUoZUKISo3rL05sf3GSXueb5c1tvlkt8my+zu+Xq8VDdnW39pAbGGMvjTHj
E+O/C/9VvvzM/WvMqW+dh6ckd7y0Xh6EXlfbm4nAg0xJhs73cqZDGDECfQr6
EPR9mvEYcIwkAT00b2UEKcWP1mHWXS8TL52XKUlHMqF85DhpJ/GUcM3eKThG
iyywn8pR9XBcFnBLsYaBjxVMvaG1SqToiZkoqaorwSh5OtXKqijmGLeyvEJb
zPEVu7w6sgrq7L7nU+qcMVTbc2/uj/6Ic91vV964M9Fe7tCe7OrZ/QN++Zz4
HUa5bofRPJJejDLYPCU0vjGy0M+nRF3/ifRhORLVs7ZnVF2t1Z+P7joZJtGI
t6rcFtpmvaCTZC/CNN+4jRsggjnBsuyL3UYjsXpxS622UB/TjFUHP7YQt16r
SjhSjibgTy1u8H6/AH0GOlZs1/9BBnpoXkr3lvez6D2nmGdFcx/gf89Z8fn/
81rOxpnPe2pm8AHTjhEd\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->214200539]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->342009706],

Cell["Build a database of exchange rates:", "ExampleText",
 CellID->760968492],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rate", "[", "chf", "]"}], "^=", "0.812"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"rate", "[", "eur", "]"}], "^=", "1.317"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"rate", "[", "gbp", "]"}], "^=", "1.963"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->246367948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"rate", "[", "chf", "]"}], "/", 
  RowBox[{"rate", "[", "eur", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16819144],

Cell[BoxData["0.6165527714502659`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49838403]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->35210276],

Cell[TextData[{
 Cell[BoxData["^="], "InlineFormula"],
 " defines upvalues in the same way as using a tag does:"
}], "ExampleText",
 CellID->66289569],

Cell[BoxData[{
 RowBox[{
  RowBox[{"square", "/:", 
   RowBox[{"area", "[", "square", "]"}], "=", 
   RowBox[{"a", "^", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"area", "[", "rectangle", "]"}], "^=", 
   RowBox[{"a", "*", "b"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->429617745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"UpValues", "[", "square", "]"}], ",", 
   RowBox[{"UpValues", "[", "rectangle", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10330739],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"area", "[", "square", "]"}], "]"}], "\[RuleDelayed]", 
     SuperscriptBox["a", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"area", "[", "rectangle", "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"a", " ", "b"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{490, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->582869544]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->82579173],

Cell[TextData[{
 Cell[BoxData["^="], "InlineFormula"],
 " defines upvalues, ",
 Cell[BoxData["="], "InlineFormula"],
 " defines downvalues:"
}], "ExampleText",
 CellID->469743807],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"area", "[", "square", "]"}], "^=", 
   RowBox[{"s", "^", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"area", "[", "rectangle", "]"}], "=", 
   RowBox[{"a", "*", "b"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->141041949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpValues", "[", "square", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->197240808],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"area", "[", "square", "]"}], "]"}], "\[RuleDelayed]", 
   SuperscriptBox["s", "2"]}], "}"}]], "Output",
 ImageSize->{222, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->374897083]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpValues", "[", "rectangle", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->377653292],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11894906]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "area", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->880623525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"area", "[", "rectangle", "]"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"a", " ", "b"}]}], "}"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->6107070]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9142],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagSet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagSet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpSetDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpSetDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpValues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpValues"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClearAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearAll"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25452]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9143],

Cell[TextData[ButtonBox["Associating Definitions with Different Symbols",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AssociatingDefinitionsWithDifferentSymbols"]], "Tutorials",\

 CellID->4807]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->383231463],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->127435963]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UpSet (^=) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 46.0074892}", "context" -> "System`", 
    "keywords" -> {
     "associated assignment", "function definition", "associating values", 
      "setting values", "associating values with types", 
      "generic programming", "object programming"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "lhs ^= rhs assigns rhs to be the value of lhs, and associates the \
assignment with symbols that occur at level one in lhs. ", 
    "synonyms" -> {"up set", "^="}, "title" -> "UpSet", "type" -> "Symbol", 
    "uri" -> "ref/UpSet"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5363, 180, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->363494255]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18225, 672}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2215, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2838, 80, 99, 4, 70, "ObjectName",
 CellID->18380],
Cell[2940, 86, 702, 23, 70, "Usage",
 CellID->28145]
}, Open  ]],
Cell[CellGroupData[{
Cell[3679, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4157, 131, 681, 26, 70, "Notes",
 CellID->5672],
Cell[4841, 159, 485, 16, 70, "Notes",
 CellID->13311]
}, Closed]],
Cell[CellGroupData[{
Cell[5363, 180, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->363494255],
Cell[CellGroupData[{
Cell[5748, 194, 148, 5, 70, "ExampleSection",
 CellID->177124986],
Cell[5899, 201, 81, 1, 70, "ExampleText",
 CellID->87490164],
Cell[CellGroupData[{
Cell[6005, 206, 152, 5, 28, "Input",
 CellID->493040914],
Cell[6160, 213, 179, 6, 36, "Output",
 CellID->9362699]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6388, 225, 219, 7, 70, "ExampleSection",
 CellID->83880245],
Cell[6610, 234, 115, 4, 70, "ExampleText",
 CellID->657251282],
Cell[CellGroupData[{
Cell[6750, 242, 151, 5, 70, "Input",
 CellID->11321373],
Cell[6904, 249, 181, 6, 36, "Output",
 CellID->826481116]
}, Open  ]],
Cell[CellGroupData[{
Cell[7122, 260, 108, 3, 70, "Input",
 CellID->57398660],
Cell[7233, 265, 319, 10, 39, "Output",
 CellID->200291316]
}, Open  ]],
Cell[7567, 278, 125, 3, 70, "ExampleDelimiter",
 CellID->352834724],
Cell[7695, 283, 138, 4, 70, "ExampleText",
 CellID->66580961],
Cell[7836, 289, 203, 7, 70, "Input",
 CellID->182692304],
Cell[CellGroupData[{
Cell[8064, 300, 106, 3, 70, "Input",
 CellID->262710777],
Cell[8173, 305, 780, 17, 70, "Output",
 Evaluatable->False,
 CellID->74773249]
}, Open  ]],
Cell[CellGroupData[{
Cell[8990, 327, 106, 3, 70, "Input",
 CellID->600089318],
Cell[9099, 332, 781, 17, 70, "Output",
 Evaluatable->False,
 CellID->214200539]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9929, 355, 227, 7, 70, "ExampleSection",
 CellID->342009706],
Cell[10159, 364, 78, 1, 70, "ExampleText",
 CellID->760968492],
Cell[10240, 367, 331, 11, 70, "Input",
 CellID->246367948],
Cell[CellGroupData[{
Cell[10596, 382, 157, 5, 70, "Input",
 CellID->16819144],
Cell[10756, 389, 175, 5, 36, "Output",
 CellID->49838403]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10980, 400, 236, 7, 70, "ExampleSection",
 CellID->35210276],
Cell[11219, 409, 150, 4, 70, "ExampleText",
 CellID->66289569],
Cell[11372, 415, 305, 10, 70, "Input",
 CellID->429617745],
Cell[CellGroupData[{
Cell[11702, 429, 199, 6, 70, "Input",
 CellID->10330739],
Cell[11904, 437, 546, 17, 39, "Output",
 CellID->582869544]
}, Open  ]],
Cell[12465, 457, 124, 3, 70, "ExampleDelimiter",
 CellID->82579173],
Cell[12592, 462, 179, 6, 70, "ExampleText",
 CellID->469743807],
Cell[12774, 470, 289, 10, 70, "Input",
 CellID->141041949],
Cell[CellGroupData[{
Cell[13088, 484, 109, 3, 70, "Input",
 CellID->197240808],
Cell[13200, 489, 319, 10, 39, "Output",
 CellID->374897083]
}, Open  ]],
Cell[CellGroupData[{
Cell[13556, 504, 112, 3, 70, "Input",
 CellID->377653292],
Cell[13671, 509, 174, 6, 36, "Output",
 CellID->11894906]
}, Open  ]],
Cell[CellGroupData[{
Cell[13882, 520, 109, 3, 70, "Input",
 CellID->880623525],
Cell[13994, 525, 319, 10, 36, "Output",
 CellID->6107070]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14374, 542, 310, 9, 70, "SeeAlsoSection",
 CellID->9142],
Cell[14687, 553, 1184, 44, 70, "SeeAlso",
 CellID->25452]
}, Open  ]],
Cell[CellGroupData[{
Cell[15908, 602, 313, 9, 70, "TutorialsSection",
 CellID->9143],
Cell[16224, 613, 203, 5, 70, "Tutorials",
 CellID->4807]
}, Open  ]],
Cell[CellGroupData[{
Cell[16464, 623, 319, 9, 70, "MoreAboutSection",
 CellID->383231463],
Cell[16786, 634, 149, 3, 70, "MoreAbout",
 CellID->127435963]
}, Open  ]],
Cell[16950, 640, 27, 0, 70, "History"],
Cell[16980, 642, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

