(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35279,       1321]
NotebookOptionsPosition[     26671,       1024]
NotebookOutlinePosition[     28395,       1071]
CellTagsIndexPosition[     28267,       1065]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Associating Definitions with Different Symbols" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AssociatingDefinitionsWithDifferentSymbols"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Associating Definitions with Different Symbols\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UpSet" :> Documentation`HelpLookup["paclet:ref/UpSet"], 
          "TagSetDelayed" :> 
          Documentation`HelpLookup["paclet:ref/TagSetDelayed"], "SetDelayed" :> 
          Documentation`HelpLookup["paclet:ref/SetDelayed"], "Unset" :> 
          Documentation`HelpLookup["paclet:ref/Unset"], "ClearAll" :> 
          Documentation`HelpLookup["paclet:ref/ClearAll"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"UpSet\"\>", 
       2->"\<\"TagSetDelayed\"\>", 3->"\<\"SetDelayed\"\>", 
       4->"\<\"Unset\"\>", 5->"\<\"ClearAll\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "UpSetDelayed ",
 StyleBox["(^:=)", "OperatorCharacter"]
}], "ObjectName",
 CellID->10233],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "^:=", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]assigns ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " to be the delayed value of ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ", and associates the assignment with symbols that occur at level one in \
",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29004]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->541866828],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], "^:=", 
  RowBox[{"fg", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66289853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"g", "[", "2", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "2", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->705566126],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"fg", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "2", "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->67618969]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->959328108],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Left-Hand Sides",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->214715367],

Cell["\<\
An expression with a delayed definition is evaluated every time it is used:\
\>", "ExampleText",
 CellID->14205805],

Cell[BoxData[
 RowBox[{
  RowBox[{"rand", "[", "int", "]"}], "^:=", 
  RowBox[{"Random", "[", "Integer", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66248155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"rand", "[", "int", "]"}], ",", 
   RowBox[{"{", "5", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->68775699],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->68408419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->694248362],

Cell["\<\
Make definitions for special and general cases using immediate and delayed \
assignments:\
\>", "ExampleText",
 CellID->849799875],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "0", "]"}], "]"}], "^=", "h0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], "^:=", 
  RowBox[{"2", 
   RowBox[{"f", "[", 
    RowBox[{"h", "[", 
     RowBox[{"x", "-", "1"}], "]"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1855274059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"h", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1897187131],

Cell[BoxData[
 RowBox[{"1024", " ", "h0"}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->359547240]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13442544],

Cell["\<\
The definition can be associated with a symbol appearing as an argument of \
the left side:\
\>", "ExampleText",
 CellID->127941899],

Cell[BoxData[
 RowBox[{
  RowBox[{"area", "[", 
   RowBox[{"sq", ",", "s_"}], "]"}], "^:=", 
  RowBox[{"s", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->528585766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"area", "[", 
  RowBox[{"sq", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102382228],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->413420335]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28324586],

Cell["\<\
The definition can be associated with the head of an argument of the left \
side:\
\>", "ExampleText",
 CellID->406225470],

Cell[BoxData[
 RowBox[{
  RowBox[{"area", "[", 
   RowBox[{"sq", "[", "s_", "]"}], "]"}], "^:=", 
  RowBox[{"s", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->961758164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"area", "[", 
  RowBox[{"sq", "[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98200665],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->297192203]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->483401482],

Cell["\<\
If several symbols appear in the left-hand side, upvalues for all of them are \
defined:\
\>", "ExampleText",
 CellID->83160814],

Cell[BoxData[
 RowBox[{
  RowBox[{"meth", "[", 
   RowBox[{
    RowBox[{"g", "[", "x_", "]"}], ",", 
    RowBox[{"h", "[", "y_", "]"}]}], "]"}], "^:=", 
  RowBox[{"fgh", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4411866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "g", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->536650192],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVztvgzAQdoyBvEhopkhR1LRz545VpnbqXnVDUaVkqFql+f/Uhjswx2GT
KJWKhM2Ze353nM1rdtp/fGanwy7bvByz7/1h97N5/jrqpWAghHwSQsyXQj/n
+qm48drqW3PoMdDLj3qWelZAh0AvYDa0CCp5kcJ6oGel54nFZ+Y70DMFekLk
Y5BT8N4svhceUUuK0A+EjggtCT3SQwSe2usBWL7x2JMd8pTvnrFr02OwN/bo
McNblRuDEY0QMTMYxqLmw9yVEOKFwlz8KCWUXRkSdHJ5o96GaFPZNn1Y+bRG
YH2u59CqMkdknRFQ3cPe+JeKSzu0qmiVYjUV2kMQwpGXjm2Pa16KHZWVloVK
lq1aCxP4EruqyK8PuTktXOYUZC5mcGpbuzQm7DajnO9SZjg/l4nljSeH3sjY
GLxcWE2JwzO3NNKiR86WV8wRep4SH/46M9gl/nFGGpXr64DT/PrfTyM3DW8c
PVBVUOdWhyP4eTpfy7OuvZjtdS76os6XnGOt5XvfvSvN2zFS3xG7Xp40Ypqx
vrnPErKCvrxobSGPWQ8sXvQe99oQPVZ1nttfeMBYdO/UFNmEt9GQb589fOcr
7mxR+BlVWqqwJWvT9nnK+kBzXedhRt6sGNRcp1uK0YLDzCFP+X17AUWT6lt3
Rjonb27zuk8gcvYfxoy8t/88zLwCpIeEb53TPwjM0/ZMSgx+AbJHywA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{574, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4254457]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "h", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->202326396],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV0tPwzAM9po+9mjH2GnSNDE48w+Q0E5w4o64VRPSdkCgsf9fks7uUsdL
OjQkKjWu09j+/IjTvpT7zftHud+uy+XzrvzabNffy6fPnZ5SPYDoEQCuZqCf
K/1U33St9A3woMdIT8eaKk0T5KdIDQ+qkYMJzitNY01H1jpDb1FPjvyIyWco
F+N7M/lWI8nZynvGp4yPGD/QQ4rI7HmFlq7ZfCzok+T5ujvBrs0P0d4woMcM
r7XnZvLwmi4edYqWiV6maWRFUTUCdJGwFAmSgtiuhQh1ShnjuBOy2UIcilpI
a4rWrzRNrPryeHbSA6673zkTB8UHO7y+eE6ormrtCQrRKEtnNuLjWh47LhtZ
FhpZsX6tmIC7o+wqCuuj1ZIWKXMxZi4T4uRa+61P1GcGldyfzHB+LgsLTSCH
Qc9EH4KrqJoKDzK/NPHQIWezC+aIkE8Yhr/ODHWJf5yRVuWGOmBeXX7/tHLT
QhPugdIOkM7gQA90MJ46n8Wu5+M79Qu+E4pzrDnYu55ik8r1kWOn2HVC0vJp
LGLreKoBOF8shMRUnoL2eoVzhiaENj7m2N3nlE+7jvznNY9qIdtoybtfIKHv
LekLo8aZNloatyPRpo05FzHwPMs54P7OhQj6dh2Xn0rx88jz9aHTgUeW61uc
9FrqnzfVsWdQJO0/jjF7b/+JGDrHyPfZukXF/ygob6szOej9AJLMyAM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{574, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->158807502]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Different Kinds of Values",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->438015421],

Cell["^:= defines upvalues:", "ExampleText",
 CellID->716732190],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], "^:=", 
  RowBox[{"f1", "[", "x", "]"}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"f2", "[", "x", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->4271581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"UpValues", "[", "g", "]"}], ",", 
   RowBox[{"DownValues", "[", "f", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->180075138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"f", "[", 
       RowBox[{"g", "[", "x_", "]"}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"f1", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"f", "[", 
       RowBox[{"h", "[", "x_", "]"}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"f2", "[", "x", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{454, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->224614809]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->648785641],

Cell[TextData[{
 Cell[BoxData["^:="], "InlineFormula"],
 " defines upvalues in the same way as using a tag does:"
}], "ExampleText",
 CellID->66289569],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"f1", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->757332850],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], "^:=", 
  RowBox[{"f2", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->152746548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"UpValues", "[", "g", "]"}], ",", 
   RowBox[{"UpValues", "[", "h", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17921066],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"f", "[", 
       RowBox[{"g", "[", "x_", "]"}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"f1", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"f", "[", 
       RowBox[{"h", "[", "x_", "]"}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"f2", "[", "x", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{454, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->458653267]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3595022],

Cell[TextData[{
 "A tag defines only one upvalue; ",
 Cell[BoxData["^:="], "InlineFormula"],
 " makes definitions for all symbols:"
}], "ExampleText",
 CellID->181338931],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"f1", "[", 
   RowBox[{
    RowBox[{"g", "[", "x_", "]"}], ",", 
    RowBox[{"h", "[", "y_", "]"}]}], "]"}], ":=", 
  RowBox[{"gh", "[", 
   RowBox[{"x", " ", "y"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270589337],

Cell[BoxData[
 RowBox[{
  RowBox[{"f2", "[", 
   RowBox[{
    RowBox[{"g", "[", "x_", "]"}], ",", 
    RowBox[{"h", "[", "y_", "]"}]}], "]"}], "^:=", 
  RowBox[{"gh", "[", 
   RowBox[{"x", " ", "y"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->117560780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"UpValues", "[", "g", "]"}], ",", 
   RowBox[{"UpValues", "[", "h", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1009224116],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"f1", "[", 
        RowBox[{
         RowBox[{"g", "[", "x_", "]"}], ",", 
         RowBox[{"h", "[", "y_", "]"}]}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"gh", "[", 
       RowBox[{"x", " ", "y"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"f2", "[", 
        RowBox[{
         RowBox[{"g", "[", "x_", "]"}], ",", 
         RowBox[{"h", "[", "y_", "]"}]}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"gh", "[", 
       RowBox[{"x", " ", "y"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"f2", "[", 
       RowBox[{
        RowBox[{"g", "[", "x_", "]"}], ",", 
        RowBox[{"h", "[", "y_", "]"}]}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"gh", "[", 
      RowBox[{"x", " ", "y"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{566, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->317380744]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->236664455],

Cell["\<\
The right side of an immediate definition is evaluated when the definition is \
made: \
\>", "ExampleText",
 CellID->250240923],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rand", "[", "int", "]"}], "^=", 
   RowBox[{"Random", "[", "Integer", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->425316542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"rand", "[", "int", "]"}], ",", 
   RowBox[{"rand", "[", "int", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->713048083],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->621389936]
}, Open  ]],

Cell["\<\
The right side of a delayed definition is evaluated each time the definition \
is used: \
\>", "ExampleText",
 CellID->579487176],

Cell[BoxData[
 RowBox[{
  RowBox[{"rand", "[", "real", "]"}], "^:=", 
  RowBox[{"Random", "[", "Real", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->114998281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"rand", "[", "real", "]"}], ",", 
   RowBox[{"rand", "[", "real", "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->206362787],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.40939252589103914`", ",", "0.7306881182100253`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->140483504]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->203419735],

Cell["Definitions with the same left side overwrite earlier ones:", \
"ExampleText",
 CellID->568194695],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], "^:=", 
  RowBox[{"f1", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60469846],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], "^:=", 
  RowBox[{"f2", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->105325452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "h", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->583637389],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVVFuwjAMNUnDxgYCMW3ib5xg2iWgXxyiQkjwMYEYB524UOekNgQ3bSjl
g0iN68R+9kssZ5Ed1quf7LBZZtN0n+3Wm+XvdL7d45LuAKgZAAwngP85/rmP
R4ofwAvOCpf7JMckDclvkq8krefx5An6hOgsfL2HUxdVLdYToX9FcOz05yIW
UMWwBg4p8TnZ1WKZhy7ZWBbKY1WX24DshigN+ZlgZB9VopwZKLFjhO72jY8L
ATx1GZ1u7xoeCeX/JPb1jXFl/vdmqinvQYTfZ2RfRmfc7oPk/1ZxLzJqFX47
Hly7JX6tas4ET4gzHglryUB2jSa1F+wTFViFlblEz5t1CT93rgK/a0huqjZa
y+5Rc6bjCA9Zfe+hO4nWfHX/tv7aOx9m/JyH356eQPogf8Zhu/LbxPmlDTXo
/AM7fOAx\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->366184339]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104499893],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " prints definitions associated with a symbol:"
}], "ExampleText",
 CellID->1693501],

Cell[BoxData[
 RowBox[{
  RowBox[{"a_mod", "+", "b_mod"}], "^:=", 
  RowBox[{"modPlus", "[", 
   RowBox[{"a", ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38967361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "mod", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->283680345],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Vl9PgzAQv7VlbCosGh58ccFEH/wgypMfgixLtgejmfsCxm/iF8W2tOM8
riJCIKHt/W9/d1d4Lo+77Ut53G/KvDiUb7v95j1/ej1olpwBiEcAWF2DXld6
ZV//FPoF+NKj0OxzQ8mTHFaOb4hPq7nQ41xzHty8JRZnzuKS8M3wYT0IPUZa
EOs5hpo2isrxI2Lp+cuAfuIiJgG5XYB/PFc6KyTVC8XEl8gC86PAfpuT1iZW
YHeFtWLrwgn9WGtFOD9h7pzZT1trOThO6pD6kZ9BHjkkMU2xEkFPirNktYSr
uG4fZpgifxyeY+ZtPU2eOuuylU3WKumZG+NFjYLTVH2UVWP2j4T2zdNPWzoE
+yI/aleQLudyIRjdUeKwSBlpOtC7BUg1vL/eU0PuOP8VZLst2EHSVbY8tXt9
XF8z/ubEsgSdDgD+4QFnGZBO0tOP4HFuOAgTnxfFIOpjpK2Thb/tt0RyQegb
QtPKvg9XwC/ZuyJ01hGl2W+OMDbz2s0LYnGHMPNYGTojc1zRP0N/jqInBbNv
CyhwvQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->305447806]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " prints various information about a symbol, including any definitions:"
}], "ExampleText",
 CellID->204114262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "mod"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->147364646],

Cell[CellGroupData[{

Cell["Cell$$4157`mod", "Print", "PrintUsage",
 CellTags->"Info3381658766-6977887",
 CellID->131455126],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"a_mod", "+", "b_mod"}], "^:=", 
         RowBox[{"modPlus", "[", 
          RowBox[{"a", ",", "b"}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["mod"],
  Editable->False]], "Print",
 CellTags->"Info3381658766-6977887",
 CellID->70578731]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UpValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpValues"]], "InlineFormula"],
 " returns a list of rules corresponding to any upvalues defined:"
}], "ExampleText",
 CellID->34795162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpValues", "[", "mod", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->284210482],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"a_mod", "+", "b_mod"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"modPlus", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->701514835]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123003086],

Cell["\<\
Delayed assignment introduces a scope that is not affected by global \
variables:\
\>", "ExampleText",
 CellID->282029065],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->706075573],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], "^:=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->878464224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "2", "]"}], "]"}], ",", "x"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->77216795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->187764559]
}, Open  ]],

Cell["Immediate assignment does not introduce a scope:", "ExampleText",
 CellID->445660177],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"h", "[", "x_", "]"}], "]"}], "^=", 
   RowBox[{"x", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1194282924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"h", "[", "2", "]"}], "]"}], ",", "x"}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1763169649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"25", ",", "5"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->61942250]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32535],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpSet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpSet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagSetDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagSetDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClearAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearAll"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1416]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5680],

Cell[TextData[ButtonBox["Associating Definitions with Different Symbols",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AssociatingDefinitionsWithDifferentSymbols"]], "Tutorials",\

 CellID->13404]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UpSetDelayed (^:=) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 44.7887080}", "context" -> "System`", 
    "keywords" -> {
     "associated assignment", "associated definition", "delayed assignment", 
      "generic programming", "type based programming", "object programming"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "lhs ^:= rhs assigns rhs to be the delayed value of lhs, and associates \
the assignment with symbols that occur at level one in lhs. ", 
    "synonyms" -> {"up set delayed", "^:="}, "title" -> "UpSetDelayed", 
    "type" -> "Symbol", "uri" -> "ref/UpSetDelayed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3130, 99, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "Info3381658766-6977887"->{
  Cell[21123, 798, 102, 2, 70, "Print",
   CellTags->"Info3381658766-6977887",
   CellID->131455126],
  Cell[21228, 802, 822, 24, 70, "Print",
   CellTags->"Info3381658766-6977887",
   CellID->70578731]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27899, 1051},
 {"Info3381658766-6977887", 28039, 1055}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1649, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2272, 65, 107, 4, 70, "ObjectName",
 CellID->10233],
Cell[2382, 71, 711, 23, 70, "Usage",
 CellID->29004]
}, Open  ]],
Cell[CellGroupData[{
Cell[3130, 99, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3507, 113, 148, 5, 70, "ExampleSection",
 CellID->541866828],
Cell[3658, 120, 180, 6, 70, "Input",
 CellID->66289853],
Cell[CellGroupData[{
Cell[3863, 130, 233, 8, 28, "Input",
 CellID->705566126],
Cell[4099, 140, 292, 10, 36, "Output",
 CellID->67618969]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4440, 156, 220, 7, 70, "ExampleSection",
 CellID->959328108],
Cell[CellGroupData[{
Cell[4685, 167, 236, 7, 70, "ExampleSubsection",
 CellID->214715367],
Cell[4924, 176, 125, 3, 70, "ExampleText",
 CellID->14205805],
Cell[5052, 181, 165, 5, 70, "Input",
 CellID->66248155],
Cell[CellGroupData[{
Cell[5242, 190, 181, 6, 70, "Input",
 CellID->68775699],
Cell[5426, 198, 232, 7, 36, "Output",
 CellID->68408419]
}, Open  ]],
Cell[5673, 208, 125, 3, 70, "ExampleDelimiter",
 CellID->694248362],
Cell[5801, 213, 140, 4, 70, "ExampleText",
 CellID->849799875],
Cell[5944, 219, 370, 13, 70, "Input",
 CellID->1855274059],
Cell[CellGroupData[{
Cell[6339, 236, 127, 4, 70, "Input",
 CellID->1897187131],
Cell[6469, 242, 184, 6, 36, "Output",
 CellID->359547240]
}, Open  ]],
Cell[6668, 251, 124, 3, 70, "ExampleDelimiter",
 CellID->13442544],
Cell[6795, 256, 142, 4, 70, "ExampleText",
 CellID->127941899],
Cell[6940, 262, 174, 6, 70, "Input",
 CellID->528585766],
Cell[CellGroupData[{
Cell[7139, 272, 124, 4, 70, "Input",
 CellID->102382228],
Cell[7266, 278, 158, 5, 36, "Output",
 CellID->413420335]
}, Open  ]],
Cell[7439, 286, 124, 3, 70, "ExampleDelimiter",
 CellID->28324586],
Cell[7566, 291, 132, 4, 70, "ExampleText",
 CellID->406225470],
Cell[7701, 297, 179, 6, 70, "Input",
 CellID->961758164],
Cell[CellGroupData[{
Cell[7905, 307, 128, 4, 70, "Input",
 CellID->98200665],
Cell[8036, 313, 158, 5, 36, "Output",
 CellID->297192203]
}, Open  ]],
Cell[8209, 321, 125, 3, 70, "ExampleDelimiter",
 CellID->483401482],
Cell[8337, 326, 138, 4, 70, "ExampleText",
 CellID->83160814],
Cell[8478, 332, 263, 9, 70, "Input",
 CellID->4411866],
Cell[CellGroupData[{
Cell[8766, 345, 106, 3, 70, "Input",
 CellID->536650192],
Cell[8875, 350, 937, 19, 70, "Output",
 Evaluatable->False,
 CellID->4254457]
}, Open  ]],
Cell[CellGroupData[{
Cell[9849, 374, 106, 3, 70, "Input",
 CellID->202326396],
Cell[9958, 379, 939, 19, 70, "Output",
 Evaluatable->False,
 CellID->158807502]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10946, 404, 246, 7, 70, "ExampleSubsection",
 CellID->438015421],
Cell[11195, 413, 64, 1, 70, "ExampleText",
 CellID->716732190],
Cell[11262, 416, 302, 10, 70, "Input",
 CellID->4271581],
Cell[CellGroupData[{
Cell[11589, 430, 189, 6, 70, "Input",
 CellID->180075138],
Cell[11781, 438, 606, 19, 36, "Output",
 CellID->224614809]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[12448, 464, 237, 7, 70, "ExampleSection",
 CellID->648785641],
Cell[12688, 473, 151, 4, 70, "ExampleText",
 CellID->66289569],
Cell[12842, 479, 191, 6, 70, "Input",
 CellID->757332850],
Cell[13036, 487, 181, 6, 70, "Input",
 CellID->152746548],
Cell[CellGroupData[{
Cell[13242, 497, 186, 6, 70, "Input",
 CellID->17921066],
Cell[13431, 505, 606, 19, 36, "Output",
 CellID->458653267]
}, Open  ]],
Cell[14052, 527, 123, 3, 70, "ExampleDelimiter",
 CellID->3595022],
Cell[14178, 532, 170, 5, 70, "ExampleText",
 CellID->181338931],
Cell[14351, 539, 272, 9, 70, "Input",
 CellID->270589337],
Cell[14626, 550, 262, 9, 70, "Input",
 CellID->117560780],
Cell[CellGroupData[{
Cell[14913, 563, 188, 6, 70, "Input",
 CellID->1009224116],
Cell[15104, 571, 1100, 34, 54, "Output",
 CellID->317380744]
}, Open  ]],
Cell[16219, 608, 125, 3, 70, "ExampleDelimiter",
 CellID->236664455],
Cell[16347, 613, 137, 4, 70, "ExampleText",
 CellID->250240923],
Cell[16487, 619, 185, 6, 70, "Input",
 CellID->425316542],
Cell[CellGroupData[{
Cell[16697, 629, 183, 6, 70, "Input",
 CellID->713048083],
Cell[16883, 637, 203, 7, 36, "Output",
 CellID->621389936]
}, Open  ]],
Cell[17101, 647, 139, 4, 70, "ExampleText",
 CellID->579487176],
Cell[17243, 653, 164, 5, 70, "Input",
 CellID->114998281],
Cell[CellGroupData[{
Cell[17432, 662, 185, 6, 70, "Input",
 CellID->206362787],
Cell[17620, 670, 244, 8, 36, "Output",
 CellID->140483504]
}, Open  ]],
Cell[17879, 681, 125, 3, 70, "ExampleDelimiter",
 CellID->203419735],
Cell[18007, 686, 104, 2, 70, "ExampleText",
 CellID->568194695],
Cell[18114, 690, 180, 6, 70, "Input",
 CellID->60469846],
Cell[18297, 698, 181, 6, 70, "Input",
 CellID->105325452],
Cell[CellGroupData[{
Cell[18503, 708, 106, 3, 70, "Input",
 CellID->583637389],
Cell[18612, 713, 647, 15, 70, "Output",
 Evaluatable->False,
 CellID->366184339]
}, Open  ]],
Cell[19274, 731, 125, 3, 70, "ExampleDelimiter",
 CellID->104499893],
Cell[19402, 736, 224, 7, 70, "ExampleText",
 CellID->1693501],
Cell[19629, 745, 182, 6, 70, "Input",
 CellID->38967361],
Cell[CellGroupData[{
Cell[19836, 755, 108, 3, 70, "Input",
 CellID->283680345],
Cell[19947, 760, 769, 17, 70, "Output",
 Evaluatable->False,
 CellID->305447806]
}, Open  ]],
Cell[20731, 780, 253, 7, 70, "ExampleText",
 CellID->204114262],
Cell[CellGroupData[{
Cell[21009, 791, 89, 3, 70, "Input",
 CellID->147364646],
Cell[CellGroupData[{
Cell[21123, 798, 102, 2, 70, "Print",
 CellTags->"Info3381658766-6977887",
 CellID->131455126],
Cell[21228, 802, 822, 24, 70, "Print",
 CellTags->"Info3381658766-6977887",
 CellID->70578731]
}, Open  ]]
}, Open  ]],
Cell[22077, 830, 239, 7, 70, "ExampleText",
 CellID->34795162],
Cell[CellGroupData[{
Cell[22341, 841, 106, 3, 70, "Input",
 CellID->284210482],
Cell[22450, 846, 349, 11, 36, "Output",
 CellID->701514835]
}, Open  ]],
Cell[22814, 860, 125, 3, 70, "ExampleDelimiter",
 CellID->123003086],
Cell[22942, 865, 132, 4, 70, "ExampleText",
 CellID->282029065],
Cell[23077, 871, 110, 4, 70, "Input",
 CellID->706075573],
Cell[23190, 877, 175, 6, 70, "Input",
 CellID->878464224],
Cell[CellGroupData[{
Cell[23390, 887, 173, 6, 70, "Input",
 CellID->77216795],
Cell[23566, 895, 203, 7, 36, "Output",
 CellID->187764559]
}, Open  ]],
Cell[23784, 905, 91, 1, 70, "ExampleText",
 CellID->445660177],
Cell[23878, 908, 196, 7, 70, "Input",
 CellID->1194282924],
Cell[CellGroupData[{
Cell[24099, 919, 175, 6, 70, "Input",
 CellID->1763169649],
Cell[24277, 927, 203, 7, 36, "Output",
 CellID->61942250]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24541, 941, 311, 9, 70, "SeeAlsoSection",
 CellID->32535],
Cell[24855, 952, 1187, 44, 70, "SeeAlso",
 CellID->1416]
}, Open  ]],
Cell[CellGroupData[{
Cell[26079, 1001, 313, 9, 70, "TutorialsSection",
 CellID->5680],
Cell[26395, 1012, 204, 5, 70, "Tutorials",
 CellID->13404]
}, Open  ]],
Cell[26614, 1020, 27, 0, 70, "History"],
Cell[26644, 1022, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

