(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15004,        562]
NotebookOptionsPosition[     11173,        433]
NotebookOutlinePosition[     12481,        470]
CellTagsIndexPosition[     12396,        465]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Controlling Infinite Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ControllingInfiniteEvaluation"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Controlling Infinite Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Refresh" :> Documentation`HelpLookup["paclet:ref/Refresh"], 
          "TrackedSymbols" :> 
          Documentation`HelpLookup["paclet:ref/TrackedSymbols"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Refresh\"\>", 
       2->"\<\"TrackedSymbols\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "Low-Level System Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelSystemOptimization"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Evaluation Control\"\>", 
       2->"\<\"Low-Level System Optimization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Update", "ObjectName",
 CellID->11928],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Update",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Update"], "[", 
       StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]tells ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " that hidden changes have been made which could affect values \
associated with a symbol. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Update",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Update"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that the value of any symbol could be \
affected. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15357]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Update",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Update"]], "InlineFormula"],
 " manipulates internal optimization features of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It should not need to be called except under special circumstances that \
rarely occur in practice. "
}], "Notes",
 CellID->13760],

Cell[TextData[{
 "One special circumstance is that changes in the value of one symbol can \
affect the value of another symbol by changing the outcome of ",
 Cell[BoxData[
  ButtonBox["Condition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Condition"]], "InlineFormula"],
 " tests. In such cases, you may need to use ",
 Cell[BoxData[
  ButtonBox["Update",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Update"]], "InlineFormula"],
 " on the symbol you think may be affected. "
}], "Notes",
 CellID->17616],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Update",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Update"]], "InlineFormula"],
 " will never give you incorrect results, although it will slow down the \
operation of the system. "
}], "Notes",
 CellID->15369]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->198601728],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->50074711],

Cell[TextData[{
 "Make sure that values that depend on ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " are returned correctly:"
}], "ExampleText",
 CellID->225945110],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "]"}], "/;", "g"}], ":=", "1"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->243218104],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " depends on the definitions for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12158565],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"f", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->274958771],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[3]:=",
 CellID->406876392],

Cell[BoxData[
 RowBox[{"f", "[", "]"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->690660221]
}, Open  ]],

Cell[TextData[{
 "Now change the value of ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " that ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", in turn, depends on:"
}], "ExampleText",
 CellID->304375493],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", " ", "=", "True"}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->339364497],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " is still based on the old value of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " that was correct before ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " was changed:"
}], "ExampleText",
 CellID->272234089],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[5]:=",
 CellID->554936039],

Cell[BoxData[
 RowBox[{"f", "[", "]"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->264244645]
}, Open  ]],

Cell[TextData[{
 "But the value of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", "]"}]], "InlineFormula"],
 " has changed:"
}], "ExampleText",
 CellID->363728381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->69763694],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1240857]
}, Open  ]],

Cell[TextData[{
 "Tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that changes have been made affecting values that depend on ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->194939493],

Cell[BoxData[
 RowBox[{"Update", "[", "f", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->167865532],

Cell[TextData[{
 "Now the value of ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " returns as expected:"
}], "ExampleText",
 CellID->210512348],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[8]:=",
 CellID->70912737],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->55612046]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31467],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Refresh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refresh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrackedSymbols",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrackedSymbols"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18934]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23761],

Cell[TextData[ButtonBox["Controlling Infinite Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ControllingInfiniteEvaluation"]], "Tutorials",
 CellID->19469]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->337426687],

Cell[TextData[ButtonBox["Low-Level System Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemOptimization"]], "MoreAbout",
 CellID->212621815]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Update - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 34.1946868}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Update[symbol] tells Mathematica that hidden changes have been made \
which could affect values associated with a symbol. Update[] specifies that \
the value of any symbol could be affected. ", "synonyms" -> {}, "title" -> 
    "Update", "type" -> "Symbol", "uri" -> "ref/Update"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5337, 174, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->198601728]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12253, 458}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2066, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2689, 78, 44, 1, 70, "ObjectName",
 CellID->11928],
Cell[2736, 81, 890, 28, 70, "Usage",
 CellID->15357]
}, Open  ]],
Cell[CellGroupData[{
Cell[3663, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4141, 131, 366, 11, 70, "Notes",
 CellID->13760],
Cell[4510, 144, 515, 14, 70, "Notes",
 CellID->17616],
Cell[5028, 160, 272, 9, 70, "Notes",
 CellID->15369]
}, Closed]],
Cell[CellGroupData[{
Cell[5337, 174, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->198601728],
Cell[CellGroupData[{
Cell[5722, 188, 147, 5, 70, "ExampleSection",
 CellID->50074711],
Cell[5872, 195, 181, 6, 70, "ExampleText",
 CellID->225945110],
Cell[6056, 203, 161, 6, 70, "Input",
 CellID->243218104],
Cell[6220, 211, 227, 9, 70, "ExampleText",
 CellID->12158565],
Cell[6450, 222, 134, 5, 70, "Input",
 CellID->274958771],
Cell[CellGroupData[{
Cell[6609, 231, 70, 2, 70, "Input",
 CellID->406876392],
Cell[6682, 235, 180, 6, 36, "Output",
 CellID->690660221]
}, Open  ]],
Cell[6877, 244, 234, 9, 70, "ExampleText",
 CellID->304375493],
Cell[7114, 255, 118, 4, 70, "Input",
 CellID->339364497],
Cell[7235, 261, 331, 12, 70, "ExampleText",
 CellID->272234089],
Cell[CellGroupData[{
Cell[7591, 277, 70, 2, 70, "Input",
 CellID->554936039],
Cell[7664, 281, 180, 6, 36, "Output",
 CellID->264244645]
}, Open  ]],
Cell[7859, 290, 174, 7, 70, "ExampleText",
 CellID->363728381],
Cell[CellGroupData[{
Cell[8058, 301, 91, 3, 70, "Input",
 CellID->69763694],
Cell[8152, 306, 156, 5, 36, "Output",
 CellID->1240857]
}, Open  ]],
Cell[8323, 314, 241, 9, 70, "ExampleText",
 CellID->194939493],
Cell[8567, 325, 102, 3, 70, "Input",
 CellID->167865532],
Cell[8672, 330, 158, 6, 70, "ExampleText",
 CellID->210512348],
Cell[CellGroupData[{
Cell[8855, 340, 69, 2, 70, "Input",
 CellID->70912737],
Cell[8927, 344, 157, 5, 36, "Output",
 CellID->55612046]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9145, 356, 311, 9, 70, "SeeAlsoSection",
 CellID->31467],
Cell[9459, 367, 461, 17, 70, "SeeAlso",
 CellID->18934]
}, Open  ]],
Cell[CellGroupData[{
Cell[9957, 389, 314, 9, 70, "TutorialsSection",
 CellID->23761],
Cell[10274, 400, 171, 3, 70, "Tutorials",
 CellID->19469]
}, Open  ]],
Cell[CellGroupData[{
Cell[10482, 408, 299, 8, 70, "MoreAboutSection"],
Cell[10784, 418, 147, 3, 70, "MoreAbout",
 CellID->337426687],
Cell[10934, 423, 167, 3, 70, "MoreAbout",
 CellID->212621815]
}, Open  ]],
Cell[11116, 429, 27, 0, 70, "History"],
Cell[11146, 431, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

