(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14387,        503]
NotebookOptionsPosition[     11214,        399]
NotebookOutlinePosition[     12525,        436]
CellTagsIndexPosition[     12440,        431]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Refresh" :> Documentation`HelpLookup["paclet:ref/Refresh"], 
          "RefreshRate" :> Documentation`HelpLookup["paclet:ref/RefreshRate"],
           "TrackedSymbols" :> 
          Documentation`HelpLookup["paclet:ref/TrackedSymbols"], "Clock" :> 
          Documentation`HelpLookup["paclet:ref/Clock"], "Dynamic" :> 
          Documentation`HelpLookup["paclet:ref/Dynamic"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Refresh\"\>", 2->"\<\"RefreshRate\"\>", 
       3->"\<\"TrackedSymbols\"\>", 4->"\<\"Clock\"\>", 
       5->"\<\"Dynamic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["UpdateInterval", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["UpdateInterval",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/UpdateInterval"]], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["Refresh",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     " that specifies at what time interval to do updates."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24904]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"UpdateInterval", "->", 
   StyleBox["t", "TI"]}]], "InlineFormula"],
 " specifies that updating should, if possible, be done at least every ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " seconds."
}], "Notes",
 CellID->21110],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"UpdateInterval", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " specifies that updating should never be done."
}], "Notes",
 CellID->32480],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"UpdateInterval", "->", "0"}]], "InlineFormula"],
 " specifies that updating should be done as fast as possible."
}], "Notes",
 CellID->31604]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->423807143],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->112134213],

Cell[TextData[{
 "Force ",
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 " to dynamically update every second:"
}], "ExampleText",
 CellID->61817805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Refresh", "[", 
   RowBox[{
    RowBox[{"DateString", "[", "]"}], ",", 
    RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1103179187],

Cell[BoxData[
 DynamicBox[ToBoxes[
   Refresh[
    DateString[], UpdateInterval -> 1], StandardForm],
  ImageSizeCache->{168., {2., 8.}}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306820014]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125883983],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["UpdateInterval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpdateInterval"]], "InlineFormula"],
 " directly in ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->154815808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{
   RowBox[{"DateString", "[", "]"}], ",", 
   RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67149552],

Cell[BoxData[
 DynamicBox[ToBoxes[
   DateString[], StandardForm],
  ImageSizeCache->{168., {2., 8.}},
  UpdateInterval:>1]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121380302]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->558464674],

Cell["Force an update to be done as fast as possible:", "ExampleText",
 CellID->724916526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProgressIndicator", "[", 
  RowBox[{"Dynamic", "[", 
   RowBox[{"x", ",", 
    RowBox[{"UpdateInterval", "\[Rule]", "0"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124713310],

Cell[BoxData[
 ProgressIndicatorBox[Dynamic[$CellContext`x, UpdateInterval -> 0]]], "Output",\

 ImageSize->{204, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147974991]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"x", "<", "1"}], ",", 
    RowBox[{"x", "=", 
     RowBox[{"x", "+", 
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1562791969]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1703],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Refresh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refresh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RefreshRate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RefreshRate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrackedSymbols",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrackedSymbols"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clock",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19499]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->256694473]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UpdateInterval - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 32.5852706}", "context" -> "System`", 
    "keywords" -> {"dynamic update", "dynamic refresh interval"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "UpdateInterval is an option to Refresh and Dynamic that specifies at \
what time interval to do updates.", "synonyms" -> {"update interval"}, 
    "title" -> "UpdateInterval", "type" -> "Symbol", "uri" -> 
    "ref/UpdateInterval"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5798, 178, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->423807143]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12297, 424}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1563, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2186, 63, 1579, 37, 70, "ObjectNameGrid"],
Cell[3768, 102, 753, 23, 70, "Usage",
 CellID->24904]
}, Open  ]],
Cell[CellGroupData[{
Cell[4558, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5036, 147, 283, 9, 70, "Notes",
 CellID->21110],
Cell[5322, 158, 253, 8, 70, "Notes",
 CellID->32480],
Cell[5578, 168, 183, 5, 70, "Notes",
 CellID->31604]
}, Closed]],
Cell[CellGroupData[{
Cell[5798, 178, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->423807143],
Cell[CellGroupData[{
Cell[6183, 192, 148, 5, 70, "ExampleSection",
 CellID->112134213],
Cell[6334, 199, 227, 8, 70, "ExampleText",
 CellID->61817805],
Cell[CellGroupData[{
Cell[6586, 211, 240, 7, 28, "Input",
 CellID->1103179187],
Cell[6829, 220, 280, 9, 36, "Output",
 CellID->306820014]
}, Open  ]],
Cell[7124, 232, 125, 3, 70, "ExampleDelimiter",
 CellID->125883983],
Cell[7252, 237, 335, 13, 70, "ExampleText",
 CellID->154815808],
Cell[CellGroupData[{
Cell[7612, 254, 201, 6, 70, "Input",
 CellID->67149552],
Cell[7816, 262, 266, 9, 70, "Output",
 CellID->121380302]
}, Open  ]],
Cell[8097, 274, 125, 3, 70, "ExampleDelimiter",
 CellID->558464674],
Cell[8225, 279, 90, 1, 70, "ExampleText",
 CellID->724916526],
Cell[CellGroupData[{
Cell[8340, 284, 215, 6, 70, "Input",
 CellID->124713310],
Cell[8558, 292, 226, 7, 70, "Output",
 CellID->147974991]
}, Open  ]],
Cell[8799, 302, 300, 11, 70, "Input",
 CellID->1562791969]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9148, 319, 310, 9, 70, "SeeAlsoSection",
 CellID->1703],
Cell[9461, 330, 1194, 44, 70, "SeeAlso",
 CellID->19499]
}, Open  ]],
Cell[CellGroupData[{
Cell[10692, 379, 299, 8, 70, "MoreAboutSection"],
Cell[10994, 389, 148, 3, 70, "MoreAbout",
 CellID->256694473]
}, Open  ]],
Cell[11157, 395, 27, 0, 70, "History"],
Cell[11187, 397, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

