(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22958,        923]
NotebookOptionsPosition[     16761,        705]
NotebookOutlinePosition[     18100,        743]
CellTagsIndexPosition[     18015,        738]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Putting Constraints on Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Information" :> 
          Documentation`HelpLookup["paclet:ref/Information"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Information\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Symbol Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ValueQ", "ObjectName",
 CellID->1819],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ValueQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ValueQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if a value has been defined for ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", and gives ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32610]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ValueQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ValueQ"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ValueQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ValueQ"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " only if ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " would not change if it were to be entered as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "Notes",
 CellID->21434]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->180452555],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->671727908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ValueQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->577831216],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->724917684]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111510028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ValueQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->785626540],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->20527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->183316423],

Cell[TextData[{
 "Only the one argument form of ",
 Cell[BoxData["f"], "InlineFormula"],
 " has values associated with it: "
}], "ExampleText",
 CellID->34345178],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79112654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ValueQ", "[", 
  RowBox[{"f", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->35327439],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->505467952]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ValueQ", "[", 
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->436624739],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->389359417]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27348],

Cell["Values of symbols:", "ExampleText",
 CellID->538692246],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";", 
  RowBox[{"y", ":=", 
   RowBox[{"Random", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399223490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ValueQ", "[", "x", "]"}], ",", 
   RowBox[{"ValueQ", "[", "y", "]"}], ",", 
   RowBox[{"ValueQ", "[", "z", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13386491],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "False"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->287856593]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->749963592],

Cell["Function definitions:", "ExampleText",
 CellID->233809980],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226535083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ValueQ", "[", 
    RowBox[{"f", "[", "2", "]"}], "]"}], ",", 
   RowBox[{"ValueQ", "[", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49943255],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->605578778]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->209653284],

Cell["Conditional definitions; the result depends on the argument:", \
"ExampleText",
 CellID->281146559],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "/;", 
    RowBox[{"x", ">", "0"}]}], "]"}], ":=", 
  RowBox[{"Sqrt", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360155359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ValueQ", "[", 
    RowBox[{"f", "[", "1", "]"}], "]"}], ",", 
   RowBox[{"ValueQ", "[", 
    RowBox[{"f", "[", 
     RowBox[{"-", "1"}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->866766202],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->124683412]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14190],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ValueQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ValueQ"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->362457179],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "y"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->324984326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ValueQ", "[", "x", "]"}], ",", 
   RowBox[{"ValueQ", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->159637473],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->420932520]
}, Open  ]],

Cell[TextData[{
 "Here ",
 StyleBox["x", "TI"],
 " is evaluated before ",
 Cell[BoxData[
  ButtonBox["ValueQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ValueQ"]], "InlineFormula"],
 " sees it:"
}], "ExampleText",
 CellID->81929079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ValueQ", "/@", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->422694753],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "False"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->809285102]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " to preserve the ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->135272918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ValueQ", "/@", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->260989797],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->704780250]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90197185],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 " evaluates to itself: "
}], "ExampleText",
 CellID->6372231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ValueQ", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->335670128],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164153678]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " to find out whether there is a numerical value defined: "
}], "ExampleText",
 CellID->662633461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->399668319],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->439174401]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28219],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ValueQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ValueQ"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if any evaluation takes place, even though ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " does not match here:"
}], "ExampleText",
 CellID->437949779],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "?", "Positive"}], "]"}], ":=", 
  RowBox[{"Sqrt", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->474267433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ValueQ", "[", 
  RowBox[{"f", "[", 
   RowBox[{"1", "-", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->396429950],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->143405561]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ValueQ", "[", 
  RowBox[{"f", "[", 
   RowBox[{"-", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->134392120],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->209039427]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25231],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->22723]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6935],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->29570]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->375591085]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ValueQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 48.4138008}", "context" -> "System`", 
    "keywords" -> {
     "testing for assignments", "testing for existence of definitions", 
      "testing for values", "testing if defined"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ValueQ[expr] gives True if a value has been defined for expr, and gives \
False otherwise. ", "synonyms" -> {"value q"}, "title" -> "ValueQ", "type" -> 
    "Symbol", "uri" -> "ref/ValueQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4625, 164, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->180452555]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17872, 731}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1771, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2394, 74, 43, 1, 70, "ObjectName",
 CellID->1819],
Cell[2440, 77, 855, 28, 70, "Usage",
 CellID->32610]
}, Open  ]],
Cell[CellGroupData[{
Cell[3332, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3810, 127, 305, 12, 70, "Notes",
 CellID->2829],
Cell[4118, 141, 470, 18, 70, "Notes",
 CellID->21434]
}, Closed]],
Cell[CellGroupData[{
Cell[4625, 164, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->180452555],
Cell[CellGroupData[{
Cell[5010, 178, 148, 5, 70, "ExampleSection",
 CellID->671727908],
Cell[CellGroupData[{
Cell[5183, 187, 102, 3, 28, "Input",
 CellID->577831216],
Cell[5288, 192, 162, 5, 36, "Output",
 CellID->724917684]
}, Open  ]],
Cell[5465, 200, 110, 4, 70, "Input",
 CellID->111510028],
Cell[CellGroupData[{
Cell[5600, 208, 102, 3, 28, "Input",
 CellID->785626540],
Cell[5705, 213, 157, 5, 36, "Output",
 CellID->20527]
}, Open  ]],
Cell[5877, 221, 125, 3, 70, "ExampleDelimiter",
 CellID->183316423],
Cell[6005, 226, 162, 5, 70, "ExampleText",
 CellID->34345178],
Cell[6170, 233, 164, 6, 70, "Input",
 CellID->79112654],
Cell[CellGroupData[{
Cell[6359, 243, 129, 4, 70, "Input",
 CellID->35327439],
Cell[6491, 249, 161, 5, 36, "Output",
 CellID->505467952]
}, Open  ]],
Cell[CellGroupData[{
Cell[6689, 259, 154, 5, 70, "Input",
 CellID->436624739],
Cell[6846, 266, 162, 5, 36, "Output",
 CellID->389359417]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7057, 277, 216, 7, 70, "ExampleSection",
 CellID->27348],
Cell[7276, 286, 61, 1, 70, "ExampleText",
 CellID->538692246],
Cell[7340, 289, 173, 6, 70, "Input",
 CellID->399223490],
Cell[CellGroupData[{
Cell[7538, 299, 226, 7, 70, "Input",
 CellID->13386491],
Cell[7767, 308, 224, 7, 36, "Output",
 CellID->287856593]
}, Open  ]],
Cell[8006, 318, 125, 3, 70, "ExampleDelimiter",
 CellID->749963592],
Cell[8134, 323, 64, 1, 70, "ExampleText",
 CellID->233809980],
Cell[8201, 326, 145, 5, 70, "Input",
 CellID->226535083],
Cell[CellGroupData[{
Cell[8371, 335, 268, 9, 70, "Input",
 CellID->49943255],
Cell[8642, 346, 210, 7, 36, "Output",
 CellID->605578778]
}, Open  ]],
Cell[8867, 356, 125, 3, 70, "ExampleDelimiter",
 CellID->209653284],
Cell[8995, 361, 105, 2, 70, "ExampleText",
 CellID->281146559],
Cell[9103, 365, 203, 7, 70, "Input",
 CellID->360155359],
Cell[CellGroupData[{
Cell[9331, 376, 264, 9, 70, "Input",
 CellID->866766202],
Cell[9598, 387, 210, 7, 36, "Output",
 CellID->124683412]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9857, 400, 233, 7, 70, "ExampleSection",
 CellID->14190],
Cell[10093, 409, 300, 12, 70, "ExampleText",
 CellID->362457179],
Cell[10396, 423, 110, 4, 70, "Input",
 CellID->324984326],
Cell[CellGroupData[{
Cell[10531, 431, 183, 6, 70, "Input",
 CellID->159637473],
Cell[10717, 439, 210, 7, 36, "Output",
 CellID->420932520]
}, Open  ]],
Cell[10942, 449, 239, 10, 70, "ExampleText",
 CellID->81929079],
Cell[CellGroupData[{
Cell[11206, 463, 145, 5, 70, "Input",
 CellID->422694753],
Cell[11354, 470, 212, 7, 36, "Output",
 CellID->809285102]
}, Open  ]],
Cell[11581, 480, 342, 13, 70, "ExampleText",
 CellID->135272918],
Cell[CellGroupData[{
Cell[11948, 497, 185, 6, 70, "Input",
 CellID->260989797],
Cell[12136, 505, 210, 7, 36, "Output",
 CellID->704780250]
}, Open  ]],
Cell[12361, 515, 124, 3, 70, "ExampleDelimiter",
 CellID->90197185],
Cell[12488, 520, 185, 7, 70, "ExampleText",
 CellID->6372231],
Cell[CellGroupData[{
Cell[12698, 531, 103, 3, 70, "Input",
 CellID->335670128],
Cell[12804, 536, 162, 5, 36, "Output",
 CellID->164153678]
}, Open  ]],
Cell[12981, 544, 243, 8, 70, "ExampleText",
 CellID->662633461],
Cell[CellGroupData[{
Cell[13249, 556, 105, 3, 70, "Input",
 CellID->399668319],
Cell[13357, 561, 161, 5, 36, "Output",
 CellID->439174401]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13567, 572, 226, 7, 70, "ExampleSection",
 CellID->28219],
Cell[13796, 581, 432, 15, 70, "ExampleText",
 CellID->437949779],
Cell[14231, 598, 184, 6, 70, "Input",
 CellID->474267433],
Cell[CellGroupData[{
Cell[14440, 608, 154, 5, 70, "Input",
 CellID->396429950],
Cell[14597, 615, 161, 5, 36, "Output",
 CellID->143405561]
}, Open  ]],
Cell[CellGroupData[{
Cell[14795, 625, 149, 5, 70, "Input",
 CellID->134392120],
Cell[14947, 632, 162, 5, 36, "Output",
 CellID->209039427]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15170, 644, 311, 9, 70, "SeeAlsoSection",
 CellID->25231],
Cell[15484, 655, 202, 6, 70, "SeeAlso",
 CellID->22723]
}, Open  ]],
Cell[CellGroupData[{
Cell[15723, 666, 313, 9, 70, "TutorialsSection",
 CellID->6935],
Cell[16039, 677, 170, 3, 70, "Tutorials",
 CellID->29570]
}, Open  ]],
Cell[CellGroupData[{
Cell[16246, 685, 299, 8, 70, "MoreAboutSection"],
Cell[16548, 695, 141, 3, 70, "MoreAbout",
 CellID->375591085]
}, Open  ]],
Cell[16704, 701, 27, 0, 70, "History"],
Cell[16734, 703, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

