(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17764,        694]
NotebookOptionsPosition[     13044,        526]
NotebookOutlinePosition[     14265,        562]
CellTagsIndexPosition[     14180,        557]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finding the Structure of a Polynomial" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingTheStructureOfAPolynomial"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Finding the Structure of a Polynomial\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Coefficient" :> 
          Documentation`HelpLookup["paclet:ref/Coefficient"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Coefficient\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Polynomial Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Variables", "ObjectName",
 CellID->24193],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Variables",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Variables"], "[", 
       StyleBox["poly", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of all independent variables in a \
polynomial. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->143310308],

Cell["Find a list of variables of a polynomial:", "ExampleText",
 CellID->51681915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variables", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "y"}], ")"}], "^", "2"}], "+", 
   RowBox[{"3", 
    RowBox[{"z", "^", "2"}]}], "-", 
   RowBox[{"y", " ", "z"}], "+", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7433475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54526113]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8287],

Cell["A polynomial:", "ExampleText",
 CellID->96092203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variables", "[", 
  RowBox[{
   RowBox[{"x", "^", "4"}], "+", 
   RowBox[{"y", "^", "4"}], "+", 
   RowBox[{"z", "^", "4"}], "-", 
   RowBox[{"3", "x", " ", "y", " ", "z"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->845042295],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200173819]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52109024],

Cell["A list of polynomials:", "ExampleText",
 CellID->378130136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variables", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"a", " ", "y"}]}], ",", 
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"b", " ", "z"}]}], ",", 
    RowBox[{
     RowBox[{"z", "^", "2"}], "-", 
     RowBox[{"c", " ", "x"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->894500392],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "x", ",", "y", ",", "z"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->687592870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->159043628],

Cell["A rational function:", "ExampleText",
 CellID->145882280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variables", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "+", "y"}], ")"}]}], "-", 
   RowBox[{"2", "/", "z"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272794214],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "x", ",", "y", ",", "z"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->705866594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->340977967],

Cell["Find variables in a radical expression:", "ExampleText",
 CellID->31755105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variables", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "+", "y", "-", 
     RowBox[{"z", "^", "2"}]}], "]"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "t"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"2", "/", "3"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237593008],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157800576]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5218],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->992],

Cell["Find variables present after reducing coefficients modulo 2:", \
"ExampleText",
 CellID->406425179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variables", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"2", "y"}], "+", 
    RowBox[{"3", "z"}]}], ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75246565],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92007857]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6653],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["CoefficientList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientList"]], "InlineFormula"],
 " to find coefficients of polynomials:"
}], "ExampleText",
 CellID->295236676],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"2", " ", "x", " ", "y"}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"5", "y"}], "+", "6"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83810882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{"f", ",", 
   RowBox[{"Variables", "[", "f", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->174997392],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52952589]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7085],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Variables",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variables"]], "InlineFormula"],
 " looks for variables only inside sums, products and rational powers:"
}], "ExampleText",
 CellID->498205008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variables", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], "+", 
   RowBox[{"Cos", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18887261],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"Sin", "[", "x", "]"}]}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->181885688]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variables", "[", 
  RowBox[{"E", "^", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->198344102],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->307524161]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26581],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Coefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Coefficient"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->2081]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28189],

Cell[TextData[ButtonBox["Finding the Structure of a Polynomial",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingTheStructureOfAPolynomial"]], "Tutorials",\

 CellID->8892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->49580180],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->495862166]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Variables - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 54.6795862}", "context" -> "System`", 
    "keywords" -> {"variables for polynomials"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Variables[poly] gives a list of all independent variables in a \
polynomial. ", "synonyms" -> {}, "title" -> "Variables", "type" -> "Symbol", 
    "uri" -> "ref/Variables"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3017, 99, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14046, 550}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1799, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2422, 75, 47, 1, 70, "ObjectName",
 CellID->24193],
Cell[2472, 78, 508, 16, 70, "Usage",
 CellID->14990]
}, Open  ]],
Cell[CellGroupData[{
Cell[3017, 99, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3394, 113, 148, 5, 70, "ExampleSection",
 CellID->143310308],
Cell[3545, 120, 83, 1, 70, "ExampleText",
 CellID->51681915],
Cell[CellGroupData[{
Cell[3653, 125, 289, 10, 28, "Input",
 CellID->7433475],
Cell[3945, 137, 212, 7, 36, "Output",
 CellID->54526113]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4206, 150, 215, 7, 70, "ExampleSection",
 CellID->8287],
Cell[4424, 159, 55, 1, 70, "ExampleText",
 CellID->96092203],
Cell[CellGroupData[{
Cell[4504, 164, 259, 8, 70, "Input",
 CellID->845042295],
Cell[4766, 174, 213, 7, 36, "Output",
 CellID->200173819]
}, Open  ]],
Cell[4994, 184, 124, 3, 70, "ExampleDelimiter",
 CellID->52109024],
Cell[5121, 189, 65, 1, 70, "ExampleText",
 CellID->378130136],
Cell[CellGroupData[{
Cell[5211, 194, 393, 14, 70, "Input",
 CellID->894500392],
Cell[5607, 210, 247, 8, 36, "Output",
 CellID->687592870]
}, Open  ]],
Cell[5869, 221, 125, 3, 70, "ExampleDelimiter",
 CellID->159043628],
Cell[5997, 226, 63, 1, 70, "ExampleText",
 CellID->145882280],
Cell[CellGroupData[{
Cell[6085, 231, 278, 10, 70, "Input",
 CellID->272794214],
Cell[6366, 243, 233, 7, 36, "Output",
 CellID->705866594]
}, Open  ]],
Cell[6614, 253, 125, 3, 70, "ExampleDelimiter",
 CellID->340977967],
Cell[6742, 258, 81, 1, 70, "ExampleText",
 CellID->31755105],
Cell[CellGroupData[{
Cell[6848, 263, 369, 13, 70, "Input",
 CellID->237593008],
Cell[7220, 278, 223, 7, 36, "Output",
 CellID->157800576]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7492, 291, 217, 7, 70, "ExampleSection",
 CellID->5218],
Cell[CellGroupData[{
Cell[7734, 302, 222, 7, 70, "ExampleSubsection",
 CellID->992],
Cell[7959, 311, 105, 2, 70, "ExampleText",
 CellID->406425179],
Cell[CellGroupData[{
Cell[8089, 317, 237, 8, 70, "Input",
 CellID->75246565],
Cell[8329, 327, 202, 7, 36, "Output",
 CellID->92007857]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[8592, 341, 232, 7, 70, "ExampleSection",
 CellID->6653],
Cell[8827, 350, 237, 8, 70, "ExampleText",
 CellID->295236676],
Cell[9067, 360, 329, 11, 70, "Input",
 CellID->83810882],
Cell[CellGroupData[{
Cell[9421, 375, 171, 5, 70, "Input",
 CellID->174997392],
Cell[9595, 382, 411, 14, 36, "Output",
 CellID->52952589]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10055, 402, 225, 7, 70, "ExampleSection",
 CellID->7085],
Cell[10283, 411, 247, 7, 70, "ExampleText",
 CellID->498205008],
Cell[CellGroupData[{
Cell[10555, 422, 189, 6, 70, "Input",
 CellID->18887261],
Cell[10747, 430, 266, 9, 36, "Output",
 CellID->181885688]
}, Open  ]],
Cell[CellGroupData[{
Cell[11050, 444, 128, 4, 70, "Input",
 CellID->198344102],
Cell[11181, 450, 175, 6, 36, "Output",
 CellID->307524161]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11417, 463, 311, 9, 70, "SeeAlsoSection",
 CellID->26581],
Cell[11731, 474, 201, 6, 70, "SeeAlso",
 CellID->2081]
}, Open  ]],
Cell[CellGroupData[{
Cell[11969, 485, 314, 9, 70, "TutorialsSection",
 CellID->28189],
Cell[12286, 496, 181, 4, 70, "Tutorials",
 CellID->8892]
}, Open  ]],
Cell[CellGroupData[{
Cell[12504, 505, 318, 9, 70, "MoreAboutSection",
 CellID->49580180],
Cell[12825, 516, 147, 3, 70, "MoreAbout",
 CellID->495862166]
}, Open  ]],
Cell[12987, 522, 27, 0, 70, "History"],
Cell[13017, 524, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

