(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     85637,       2569]
NotebookOptionsPosition[     74416,       2168]
NotebookOutlinePosition[     75679,       2205]
CellTagsIndexPosition[     75593,       2200]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dot" :> Documentation`HelpLookup["paclet:ref/Dot"], 
          "Projection" :> Documentation`HelpLookup["paclet:ref/Projection"], 
          "ArcCos" :> Documentation`HelpLookup["paclet:ref/ArcCos"], "Cross" :> 
          Documentation`HelpLookup["paclet:ref/Cross"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Dot\"\>", 2->"\<\"Projection\"\>", 
       3->"\<\"ArcCos\"\>", 4->"\<\"Cross\"\>", 
       5->"\<\"Degree\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Operations on Vectors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["VectorAngle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["VectorAngle",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/VectorAngle"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the angle between the vectors ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["VectorAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VectorAngle"]], "InlineFormula"],
 " gives an angle in radians."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "For nonzero vectors the vector angle ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " satisfies ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cos", " ", "\[Theta]"}], "\[LongEqual]", 
    FractionBox[
     RowBox[{"u", ".", "v"}], 
     RowBox[{
      RowBox[{
      "\[LeftDoubleBracketingBar]", "u", "\[RightDoubleBracketingBar]"}], " ",
       
      RowBox[{
      "\[LeftDoubleBracketingBar]", "v", "\[RightDoubleBracketingBar]"}]}]]}],
    TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->305417230]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15710777],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->512859035],

Cell["The angle between two vectors in 2D:", "ExampleText",
 CellID->651364183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->808784465],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41199187]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->236374703],

Cell[BoxData[
 GraphicsBox[{ArrowBox[{{0, 0}, {1, 0}}], 
   ArrowBox[{{0, 0}, {1, 1}}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->300393286]
}, Open  ]],

Cell["The angle between two vectors in 3D:", "ExampleText",
 CellID->205799658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->192110972],

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  FractionBox["1", 
   SqrtBox["3"]], "]"}]], "Output",
 ImageSize->{88, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->625716159]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Thick", ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->143322072],

Cell[BoxData[
 Graphics3DBox[
  {Thickness[Large], Line3DBox[{{0, 0, 0}, {1, 0, 0}}], 
   Line3DBox[{{0, 0, 0}, {1, 1, 1}}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[4]=",
 CellID->86359905,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydmWlP20AQhh0fOYEACXcIKXc5CrRAUaWqUj+0n/ojIhoJpFatKH/faj3j
2dh5dzbZYgnL48w8np3dnZ1dvg2fH0Y/h8+P98PB16fh74fH+z+DL7+esldR
JQiC79nfj/Uge/6bPfHf5zRNg2g0GqV8BTt0Cz5l9yR7OWDpY3YPMylk3cxq
xFeQ//ohuxMgiFjkK6SbUOmnnHpX4iSkEec/5/dc51Z0yrSYYCTGYz+zhz4r
vFO+Ti5WSUzG+uLHNitdgR/1KboXij/En1Nteqx05vBpAWIdgrzB6ieOCCx6
WR85vt0B7QjkdVY/gMiseFntOWK0DtoxyGusPnB4vAnaCcirrN53RKvnZb3l
+PYOaFdB5rhwxMvReuVlteaI1j5o10DusnrX4fEhaNdB5v4Plh3ROvayXnR4
fgraDZCXWX3e4fk5aDdBXmL1luPbl17WDYf1W9BugcxzjqNB1tTHNzO+V1iY
tyYfvp/xrbZlmUq6vYV3cyAvFJZFhqRoK/5OsYXcQtbX8H5ek62RSvM8VqLr
Z52YdgTmutJ8xjZZnKrFwbHS1nrE4oxloVBfvnkRSRsVOPoxyzdVUkMhnYHO
kmZj5aQWkKjXT15EwpFFpNfwblmLiEXCcRIpGcqPhCOFSEfwDlfGmkrCHqbx
fQDvuiBXVRL3sDVPMfvrLFzFlr1Y9EVSqquMjsWgtu0qfUIiruGJykTvTT7B
FbIhnqk5YCY1EupAiRWJmGF1qlbjaDVAJFQcUzp1FeRYqNtIzR5xfunENQex
J35hdHIK9teGg7IuPYF+6xSszUzG74gvWCdijGOVuqV8m3xrC1Wtp2ZStUqQ
qC2hYrXiR8V+TCQCZuxhNvSj9kGuiq+hUDEL6VSMvjo/ONm71x0/Ms5nM0eI
jhnaj1jOO7TmhpJztB2QH3EP5Jq0nuYx0XGXEnlR6kJpSotxN6bunGZSG9LS
JNVHvJYBA2sniPm/Jb6a/XZ+YeWq7hC92LGSFbH3/Wj1UjQpDjiLXkY10TQ9
j1TMv35UMydbntTQSU1kZmsUdddvUXbTYg2IJbdNq15yCjc0f8kzWRvH3bTI
ltMqK5vYT/WKYTUtZs7/Ec1uHauFNWk1ZnKsI20iWypzYUN8RCL2jk00+3Ns
zaYnsWIRl4SI42lLWo17N+wpQ5yMtFYxbIuPGN/ZxKbEEWuUvoOI8baJNfER
a4IdBxHjahNjIeIaO0iLlRtzkUKcrLYzAdfAXfEQeehxziMcZpY9ISRehPKb
A9DYl7bhHCRSJROJMDniaM1FyqH4g5SqRZm2mtPjkYOUWCTSoNUZCccOQmwR
MP5Yz5+kRW01nYRxxxF06iBFFsmcJCHhzEEILQLOHJwf59Lj5QxS9qM4SUPL
i9RUhYVlOGGJ+RQrp0tDSMaE/EFGKuZEzBZXxn7inD+3bYvXaEPn//jfhtwC
8yVmu2uxDMffMKejqHkjmkUkUAO/RRbRWHtFuKhF7Y3NCmlFA6N1npZ38Rh7
XEfo5CUZyT5kfFKNWgfCzE9JcURgTh0IMz/H7gkTtXrC5D2iuqPBMRSbGcFz
lJio1ZEvczZQdx1Y7RCTT3qsHIRzzFSwfIo9/l8GalXFgwvWKmdIGnGxMPi8
lPNlNZPuWAoq/wCZaIOf\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->520848262],

Cell["The angle between orthogonal vectors:", "ExampleText",
 CellID->450883119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->303997197],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->442690995]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->536727836],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->78692317]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{
   RowBox[{"UnitVector", "[", 
    RowBox[{"10", ",", "1"}], "]"}], ",", 
   RowBox[{"UnitVector", "[", 
    RowBox[{"10", ",", "2"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->204952492],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->62301503]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Use exact arithmetic to compute the vector angle:", "ExampleText",
 CellID->88130052],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";", 
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33508245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{"u", ",", "v"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->131390729],

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  SqrtBox[
   FractionBox["6", "7"]], "]"}]], "Output",
 ImageSize->{91, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->443852]
}, Open  ]],

Cell["Use machine arithmetic:", "ExampleText",
 CellID->127852485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{
   RowBox[{"N", "[", "u", "]"}], ",", 
   RowBox[{"N", "[", "v", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->123820169],

Cell[BoxData["0.38759668665518077`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->544153610]
}, Open  ]],

Cell["Use 47-digit precision arithmetic:", "ExampleText",
 CellID->471061282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"u", ",", "47"}], "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{"v", ",", "47"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5390697],

Cell[BoxData["0.3875966866551806536020468555912367128999087170115012579671`45.\
59724443933696"], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->344046600]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->538670431],

Cell["Use symbolic vectors:", "ExampleText",
 CellID->207990182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175307351],

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  FractionBox[
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"Conjugate", "[", "x", "]"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"Conjugate", "[", "y", "]"}]}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "a", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "b", "]"}], "2"]}]], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "x", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "y", "]"}], "2"]}]]}]], "]"}]], "Output",
 ImageSize->{321, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->934085746]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"VectorAngle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->122032239],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100014673]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"VectorAngle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "<", 
    RowBox[{"Pi", "/", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30602279],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->150042972]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell["For complex vectors the angle returned may be complex:", "ExampleText",
 CellID->22140336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.", ",", 
     RowBox[{"2.", "I"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3.", "I"}], ",", "4."}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->240508143],

Cell[BoxData[
 RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.43350736324528244`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167741338]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Find when two vectors have the same direction:", "ExampleText",
 CellID->17172159],

Cell[BoxData[
 RowBox[{
  RowBox[{"samedirection", "[", 
   RowBox[{
    RowBox[{"u_", "?", "VectorQ"}], ",", 
    RowBox[{"v_", "?", "VectorQ"}]}], "]"}], ":=", 
  RowBox[{"PossibleZeroQ", "[", 
   RowBox[{"VectorAngle", "[", 
    RowBox[{"u", ",", "v"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224796531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"samedirection", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{".1", ",", ".2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->764909729],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4706014]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"samedirection", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", ".1"}], ",", 
     RowBox[{"-", ".2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->304982],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->428312440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->331416825],

Cell[TextData[{
 "Find the area of the triangle with ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " as two sides:"
}], "ExampleText",
 CellID->217904593],

Cell[BoxData[
 RowBox[{
  RowBox[{"tarea", "[", 
   RowBox[{
    RowBox[{"u_", "?", "VectorQ"}], ",", 
    RowBox[{"v_", "?", "VectorQ"}]}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"Norm", "[", "u", "]"}], 
   RowBox[{"Norm", "[", "v", "]"}], 
   RowBox[{"Sin", "[", 
    RowBox[{"VectorAngle", "[", 
     RowBox[{"u", ",", "v"}], "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5635788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tarea", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->86394099],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->245180961]
}, Open  ]],

Cell[TextData[{
 "Plot the area in the triangle formed by the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " axis and a unit vector in the first quadrant:"
}], "ExampleText",
 CellID->587049354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"tarea", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->622928700],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->202432564]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->407709970],

Cell["\<\
Distribution of angles between random vectors with positive entries in 2, 3, \
5 and 10 dimensions:\
\>", "ExampleText",
 CellID->72950748],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", " ", "=", " ", 
   RowBox[{"10", "^", "5"}]}], ";"}], "\n", 
 RowBox[{"Table", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"v", " ", "=", " ", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", " ", 
       RowBox[{"{", 
        RowBox[{"n", ",", " ", "2", ",", " ", "d"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"angles", " ", "=", " ", 
     RowBox[{
      RowBox[{"Apply", "[", 
       RowBox[{"VectorAngle", ",", " ", "v", ",", " ", 
        RowBox[{"{", "1", "}"}]}], "]"}], "/", "Degree"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"bins", " ", "=", " ", 
     RowBox[{
      RowBox[{"BinCounts", "[", 
       RowBox[{"angles", ",", " ", 
        RowBox[{"{", 
         RowBox[{"0", ",", "90"}], "}"}]}], "]"}], "/", "n"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"bins", ",", " ", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "90"}], "}"}]}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"d", ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "5", ",", "10"}], "}"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->36869732],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->278344072]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "The vector angle ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " satisfies ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cos", "(", "\[Theta]", ")"}], "\[LongEqual]", 
    FractionBox[
     RowBox[{"u", ".", "v"}], 
     RowBox[{
      RowBox[{
      "\[LeftDoubleBracketingBar]", "u", "\[RightDoubleBracketingBar]"}], " ",
       
      RowBox[{
      "\[LeftDoubleBracketingBar]", "v", "\[RightDoubleBracketingBar]"}]}]]}],
    TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->253135544],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "5", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "5", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->260076847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Theta]", "=", 
  RowBox[{"VectorAngle", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->126157760],

Cell[BoxData["0.7674914710909844`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->733645808]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "\[Theta]", "]"}], "\[Equal]", 
  FractionBox[
   RowBox[{"u", ".", "v"}], 
   RowBox[{
    RowBox[{"Norm", "[", "u", "]"}], " ", 
    RowBox[{"Norm", "[", "v", "]"}]}]]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->146108280],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->15874120]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->164352885],

Cell[TextData[{
 "The generalization to complex vectors satisfies ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cos", "(", "\[Theta]", ")"}], "\[LongEqual]", 
    FractionBox[
     RowBox[{"u", ".", 
      SuperscriptBox["v", "\[Conjugate]"]}], 
     RowBox[{
      RowBox[{
      "\[LeftDoubleBracketingBar]", "u", "\[RightDoubleBracketingBar]"}], " ",
       
      RowBox[{
      "\[LeftDoubleBracketingBar]", "v", "\[RightDoubleBracketingBar]"}]}]]}],
    TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->625064869],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{"1", "+", "I"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"2", "I"}]}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->271868361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Theta]", "=", 
  RowBox[{"VectorAngle", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->319185117],

Cell[BoxData[
 RowBox[{"0.801519844068388`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.5240142285279465`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1034108063]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "\[Theta]", "]"}], "\[Equal]", 
  FractionBox[
   RowBox[{"u", ".", 
    RowBox[{"Conjugate", "[", "v", "]"}]}], 
   RowBox[{
    RowBox[{"Norm", "[", "u", "]"}], " ", 
    RowBox[{"Norm", "[", "v", "]"}]}]]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->423307616],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->627641143]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->620129902],

Cell[TextData[{
 "If you rotate a vector ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " in a plane that includes ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " then the vector angle is the rotation angle:"
}], "ExampleText",
 CellID->23695950],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->671100507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{
   RowBox[{"RotationTransform", "[", 
    RowBox[{
     RowBox[{"Pi", "/", "3"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}], "[", "u", 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245552852],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->342278517]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{"u", ",", "v"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31942819],

Cell[BoxData[
 FractionBox["\[Pi]", "3"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->74489036]
}, Open  ]],

Cell[TextData[{
 "If you rotate in a plane that does not include ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " then the angles differ:"
}], "ExampleText",
 CellID->140688826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{
   RowBox[{"RotationTransform", "[", 
    RowBox[{
     RowBox[{"Pi", "/", "3"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], "[", "u", 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21498831],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox[
    SqrtBox["3"], "2"], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{95, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->93964344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{"u", ",", "v"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->582209384],

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  FractionBox["3", "4"], "]"}]], "Output",
 ImageSize->{72, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->609646122]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24242265],

Cell[TextData[{
 "The vector angle ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " is related to the cross product through ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftDoubleBracketingBar]", 
     RowBox[{"u", "\[Cross]", "v"}], "\[RightDoubleBracketingBar]"}], 
    "\[LongEqual]", 
    RowBox[{
     RowBox[{"\[LeftBracketingBar]", 
      RowBox[{"sin", "(", "\[Theta]", ")"}], "\[RightBracketingBar]"}], " ", 
     RowBox[{
     "\[LeftDoubleBracketingBar]", "u", "\[RightDoubleBracketingBar]"}], " ", 
     
     RowBox[{
     "\[LeftDoubleBracketingBar]", "v", "\[RightDoubleBracketingBar]"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->111934511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"u", ",", "v"}], "}"}], "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149115777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.1948294199293421`", ",", "0.691848407118586`", ",", 
     "0.3686698295529771`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9966116630994388`", ",", "0.5413026838999575`", ",", 
     "0.7966790599792668`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{431, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316543814]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Theta]", "=", 
  RowBox[{"VectorAngle", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23374506],

Cell[BoxData["0.6915360855151924`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->857608040]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Norm", "[", 
   RowBox[{"Cross", "[", 
    RowBox[{"u", ",", "v"}], "]"}], "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}], "]"}], 
   RowBox[{"Norm", "[", "u", "]"}], 
   RowBox[{"Norm", "[", "v", "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->134981889],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->263171184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->189341205],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 " of two arguments gives the signed vector angle between the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " axis and the vector:"
}], "ExampleText",
 CellID->72065632],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->343116615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10590272],

Cell[BoxData[
 RowBox[{"ArcTan", "[", "2", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63603803]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->194718784],

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  FractionBox["1", 
   SqrtBox["5"]], "]"}]], "Output",
 ImageSize->{88, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->279008266]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%%", "-", "%"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->79610466],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->11082936]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->817702153],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Eigenvectors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvectors"]], "InlineFormula"],
 " are the vectors for which the angle between ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], ".", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is 0:"
}], "ExampleText",
 CellID->265504991],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"1", "/", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->506642853],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "t_", "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "t", "]"}], ",", " ", 
        RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"VectorAngle", "[", 
     RowBox[{
      RowBox[{"m", ".", "x"}], ",", "x"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15942882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", " ", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->507761686],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->151079153]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quiet", "[", 
  RowBox[{"FindMinimum", "[", 
   RowBox[{
    RowBox[{"f", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", ".5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->581898852],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "0.49139687892787715`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->380126038]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Cos", "[", "t", "]"}], ",", " ", 
    RowBox[{"Sin", "[", "t", "]"}]}], "}"}], " ", "/.", " ", 
  RowBox[{"%", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->393461893],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8816745906028137`", ",", "0.471857940788709`"}], "}"}]], "Output",\

 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->138063942]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvectors", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->224570626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.8816745987679436`", ",", "0.4718579255320243`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.4718579255320243`"}], ",", "0.8816745987679437`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->449179487]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
The angle between the zero vector and any other vector is indeterminate:\
\>", "ExampleText",
 CellID->166027525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorAngle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->430738443],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->390896610]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Projection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Projection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCos"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cross",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cross"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->147642405]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VectorAngle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 55.9452436}", "context" -> "System`", 
    "keywords" -> {
     "angles between vectors", "law of cosines", "vector angle"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "VectorAngle[u, v] gives the angle between the vectors u and v.", 
    "synonyms" -> {}, "title" -> "VectorAngle", "type" -> "Symbol", "uri" -> 
    "ref/VectorAngle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5747, 180, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->15710777]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 75451, 2193}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1517, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2140, 62, 1576, 37, 70, "ObjectNameGrid"],
Cell[3719, 101, 697, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4453, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4931, 146, 205, 7, 70, "Notes",
 CellID->1067943069],
Cell[5139, 155, 571, 20, 70, "Notes",
 CellID->305417230]
}, Closed]],
Cell[CellGroupData[{
Cell[5747, 180, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15710777],
Cell[CellGroupData[{
Cell[6131, 194, 148, 5, 70, "ExampleSection",
 CellID->512859035],
Cell[6282, 201, 79, 1, 70, "ExampleText",
 CellID->651364183],
Cell[CellGroupData[{
Cell[6386, 206, 228, 8, 28, "Input",
 CellID->808784465],
Cell[6617, 216, 181, 6, 49, "Output",
 CellID->41199187]
}, Open  ]],
Cell[CellGroupData[{
Cell[6835, 227, 556, 20, 28, "Input",
 CellID->236374703],
Cell[7394, 249, 284, 8, 121, "Output",
 CellID->300393286]
}, Open  ]],
Cell[7693, 260, 79, 1, 70, "ExampleText",
 CellID->205799658],
Cell[CellGroupData[{
Cell[7797, 265, 248, 8, 70, "Input",
 CellID->192110972],
Cell[8048, 275, 224, 8, 55, "Output",
 CellID->625716159]
}, Open  ]],
Cell[CellGroupData[{
Cell[8309, 288, 610, 20, 70, "Input",
 CellID->143322072],
Cell[8922, 310, 2048, 39, 129, 137, 3, "CachedBoxData", "BoxData", "Output",
 CellID->86359905]
}, Open  ]],
Cell[10985, 352, 125, 3, 70, "ExampleDelimiter",
 CellID->520848262],
Cell[11113, 357, 80, 1, 70, "ExampleText",
 CellID->450883119],
Cell[CellGroupData[{
Cell[11218, 362, 228, 8, 70, "Input",
 CellID->303997197],
Cell[11449, 372, 182, 6, 49, "Output",
 CellID->442690995]
}, Open  ]],
Cell[CellGroupData[{
Cell[11668, 383, 248, 8, 70, "Input",
 CellID->536727836],
Cell[11919, 393, 181, 6, 49, "Output",
 CellID->78692317]
}, Open  ]],
Cell[CellGroupData[{
Cell[12137, 404, 258, 8, 70, "Input",
 CellID->204952492],
Cell[12398, 414, 181, 6, 49, "Output",
 CellID->62301503]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12628, 426, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[12852, 435, 91, 1, 70, "ExampleText",
 CellID->88130052],
Cell[12946, 438, 260, 9, 70, "Input",
 CellID->33508245],
Cell[CellGroupData[{
Cell[13231, 451, 130, 4, 70, "Input",
 CellID->131390729],
Cell[13364, 457, 221, 8, 60, "Output",
 CellID->443852]
}, Open  ]],
Cell[13600, 468, 66, 1, 70, "ExampleText",
 CellID->127852485],
Cell[CellGroupData[{
Cell[13691, 473, 188, 6, 70, "Input",
 CellID->123820169],
Cell[13882, 481, 177, 5, 36, "Output",
 CellID->544153610]
}, Open  ]],
Cell[14074, 489, 77, 1, 70, "ExampleText",
 CellID->471061282],
Cell[CellGroupData[{
Cell[14176, 494, 238, 8, 70, "Input",
 CellID->5390697],
Cell[14417, 504, 238, 6, 36, "Output",
 CellID->344046600]
}, Open  ]],
Cell[14670, 513, 125, 3, 70, "ExampleDelimiter",
 CellID->538670431],
Cell[14798, 518, 64, 1, 70, "ExampleText",
 CellID->207990182],
Cell[CellGroupData[{
Cell[14887, 523, 228, 8, 70, "Input",
 CellID->175307351],
Cell[15118, 533, 720, 25, 62, "Output",
 CellID->934085746]
}, Open  ]],
Cell[CellGroupData[{
Cell[15875, 563, 465, 16, 70, "Input",
 CellID->122032239],
Cell[16343, 581, 20916, 347, 70, "Output",
 Evaluatable->False,
 CellID->100014673]
}, Open  ]],
Cell[CellGroupData[{
Cell[37296, 933, 524, 18, 70, "Input",
 CellID->30602279],
Cell[37823, 953, 2579, 46, 70, "Output",
 Evaluatable->False,
 CellID->150042972]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40451, 1005, 244, 7, 70, "ExampleSection",
 CellID->1020263627],
Cell[40698, 1014, 96, 1, 70, "ExampleText",
 CellID->22140336],
Cell[CellGroupData[{
Cell[40819, 1019, 274, 10, 70, "Input",
 CellID->240508143],
Cell[41096, 1031, 274, 7, 36, "Output",
 CellID->167741338]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41419, 1044, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[41649, 1053, 88, 1, 70, "ExampleText",
 CellID->17172159],
Cell[41740, 1056, 325, 10, 70, "Input",
 CellID->224796531],
Cell[CellGroupData[{
Cell[42090, 1070, 232, 8, 70, "Input",
 CellID->764909729],
Cell[42325, 1080, 159, 5, 36, "Output",
 CellID->4706014]
}, Open  ]],
Cell[CellGroupData[{
Cell[42521, 1090, 271, 10, 70, "Input",
 CellID->304982],
Cell[42795, 1102, 162, 5, 36, "Output",
 CellID->428312440]
}, Open  ]],
Cell[42972, 1110, 125, 3, 70, "ExampleDelimiter",
 CellID->331416825],
Cell[43100, 1115, 236, 9, 70, "ExampleText",
 CellID->217904593],
Cell[43339, 1126, 422, 14, 70, "Input",
 CellID->5635788],
Cell[CellGroupData[{
Cell[43786, 1144, 221, 8, 70, "Input",
 CellID->86394099],
Cell[44010, 1154, 178, 6, 51, "Output",
 CellID->245180961]
}, Open  ]],
Cell[44203, 1163, 210, 6, 70, "ExampleText",
 CellID->587049354],
Cell[CellGroupData[{
Cell[44438, 1173, 464, 15, 70, "Input",
 CellID->622928700],
Cell[44905, 1190, 2266, 41, 70, "Output",
 Evaluatable->False,
 CellID->202432564]
}, Open  ]],
Cell[47186, 1234, 125, 3, 70, "ExampleDelimiter",
 CellID->407709970],
Cell[47314, 1239, 149, 4, 70, "ExampleText",
 CellID->72950748],
Cell[CellGroupData[{
Cell[47488, 1247, 1270, 38, 70, "Input",
 CellID->36869732],
Cell[48761, 1287, 4867, 84, 70, "Output",
 Evaluatable->False,
 CellID->278344072]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53677, 1377, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[53918, 1386, 555, 20, 70, "ExampleText",
 CellID->253135544],
Cell[54476, 1408, 341, 12, 70, "Input",
 CellID->260076847],
Cell[CellGroupData[{
Cell[54842, 1424, 161, 5, 70, "Input",
 CellID->126157760],
Cell[55006, 1431, 176, 5, 36, "Output",
 CellID->733645808]
}, Open  ]],
Cell[CellGroupData[{
Cell[55219, 1441, 271, 9, 70, "Input",
 CellID->146108280],
Cell[55493, 1452, 160, 5, 36, "Output",
 CellID->15874120]
}, Open  ]],
Cell[55668, 1460, 125, 3, 70, "ExampleDelimiter",
 CellID->164352885],
Cell[55796, 1465, 545, 18, 70, "ExampleText",
 CellID->625064869],
Cell[56344, 1485, 421, 15, 70, "Input",
 CellID->271868361],
Cell[CellGroupData[{
Cell[56790, 1504, 161, 5, 70, "Input",
 CellID->319185117],
Cell[56954, 1511, 273, 7, 36, "Output",
 CellID->1034108063]
}, Open  ]],
Cell[CellGroupData[{
Cell[57264, 1523, 309, 10, 70, "Input",
 CellID->423307616],
Cell[57576, 1535, 161, 5, 36, "Output",
 CellID->627641143]
}, Open  ]],
Cell[57752, 1543, 125, 3, 70, "ExampleDelimiter",
 CellID->620129902],
Cell[57880, 1548, 275, 9, 70, "ExampleText",
 CellID->23695950],
Cell[58158, 1559, 190, 7, 70, "Input",
 CellID->671100507],
Cell[CellGroupData[{
Cell[58373, 1570, 284, 10, 70, "Input",
 CellID->245552852],
Cell[58660, 1582, 232, 8, 36, "Output",
 CellID->342278517]
}, Open  ]],
Cell[CellGroupData[{
Cell[58929, 1595, 129, 4, 70, "Input",
 CellID->31942819],
Cell[59061, 1601, 181, 6, 49, "Output",
 CellID->74489036]
}, Open  ]],
Cell[59257, 1610, 191, 6, 70, "ExampleText",
 CellID->140688826],
Cell[CellGroupData[{
Cell[59473, 1620, 283, 10, 70, "Input",
 CellID->21498831],
Cell[59759, 1632, 289, 11, 56, "Output",
 CellID->93964344]
}, Open  ]],
Cell[CellGroupData[{
Cell[60085, 1648, 130, 4, 70, "Input",
 CellID->582209384],
Cell[60218, 1654, 211, 7, 51, "Output",
 CellID->609646122]
}, Open  ]],
Cell[60444, 1664, 124, 3, 70, "ExampleDelimiter",
 CellID->24242265],
Cell[60571, 1669, 721, 22, 70, "ExampleText",
 CellID->111934511],
Cell[CellGroupData[{
Cell[61317, 1695, 251, 9, 70, "Input",
 CellID->149115777],
Cell[61571, 1706, 451, 15, 36, "Output",
 CellID->316543814]
}, Open  ]],
Cell[CellGroupData[{
Cell[62059, 1726, 160, 5, 70, "Input",
 CellID->23374506],
Cell[62222, 1733, 176, 5, 36, "Output",
 CellID->857608040]
}, Open  ]],
Cell[CellGroupData[{
Cell[62435, 1743, 345, 11, 70, "Input",
 CellID->134981889],
Cell[62783, 1756, 161, 5, 36, "Output",
 CellID->263171184]
}, Open  ]],
Cell[62959, 1764, 125, 3, 70, "ExampleDelimiter",
 CellID->189341205],
Cell[63087, 1769, 315, 10, 70, "ExampleText",
 CellID->72065632],
Cell[63405, 1781, 208, 8, 70, "Input",
 CellID->343116615],
Cell[CellGroupData[{
Cell[63638, 1793, 124, 4, 70, "Input",
 CellID->10590272],
Cell[63765, 1799, 189, 6, 36, "Output",
 CellID->63603803]
}, Open  ]],
Cell[CellGroupData[{
Cell[63991, 1810, 228, 8, 70, "Input",
 CellID->194718784],
Cell[64222, 1820, 224, 8, 55, "Output",
 CellID->279008266]
}, Open  ]],
Cell[CellGroupData[{
Cell[64483, 1833, 131, 4, 70, "Input",
 CellID->79610466],
Cell[64617, 1839, 157, 5, 36, "Output",
 CellID->11082936]
}, Open  ]],
Cell[64789, 1847, 125, 3, 70, "ExampleDelimiter",
 CellID->817702153],
Cell[64917, 1852, 409, 15, 70, "ExampleText",
 CellID->265504991],
Cell[65329, 1869, 364, 13, 70, "Input",
 CellID->506642853],
Cell[65696, 1884, 474, 15, 70, "Input",
 CellID->15942882],
Cell[CellGroupData[{
Cell[66195, 1903, 217, 7, 70, "Input",
 CellID->507761686],
Cell[66415, 1912, 3360, 59, 70, "Output",
 Evaluatable->False,
 CellID->151079153]
}, Open  ]],
Cell[CellGroupData[{
Cell[69812, 1976, 245, 8, 70, "Input",
 CellID->581898852],
Cell[70060, 1986, 283, 10, 36, "Output",
 CellID->380126038]
}, Open  ]],
Cell[CellGroupData[{
Cell[70380, 2001, 271, 9, 70, "Input",
 CellID->393461893],
Cell[70654, 2012, 241, 8, 36, "Output",
 CellID->138063942]
}, Open  ]],
Cell[CellGroupData[{
Cell[70932, 2025, 136, 4, 70, "Input",
 CellID->224570626],
Cell[71071, 2031, 400, 13, 36, "Output",
 CellID->449179487]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[71520, 2050, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[71754, 2059, 123, 3, 70, "ExampleText",
 CellID->166027525],
Cell[CellGroupData[{
Cell[71902, 2066, 228, 8, 70, "Input",
 CellID->430738443],
Cell[72133, 2076, 170, 5, 36, "Output",
 CellID->390896610]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[72364, 2088, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[72683, 2099, 1170, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[73890, 2148, 299, 8, 70, "MoreAboutSection"],
Cell[74192, 2158, 152, 3, 70, "MoreAbout",
 CellID->147642405]
}, Open  ]],
Cell[74359, 2164, 27, 0, 70, "History"],
Cell[74389, 2166, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

