(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32332,       1188]
NotebookOptionsPosition[     25404,        948]
NotebookOutlinePosition[     26932,        988]
CellTagsIndexPosition[     26847,        983]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"], 
          "Scalars, Vectors and Matrices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ScalarsVectorsAndMatrices"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Putting Constraints on Patterns\"\>", 
       2->"\<\"Scalars, Vectors and Matrices\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MatrixQ" :> Documentation`HelpLookup["paclet:ref/MatrixQ"], 
          "ArrayDepth" :> Documentation`HelpLookup["paclet:ref/ArrayDepth"], 
          "ArrayQ" :> Documentation`HelpLookup["paclet:ref/ArrayQ"], 
          "Dimensions" :> 
          Documentation`HelpLookup["paclet:ref/Dimensions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MatrixQ\"\>", 
       2->"\<\"ArrayDepth\"\>", 3->"\<\"ArrayQ\"\>", 
       4->"\<\"Dimensions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Operations on Vectors\"\>", 
       3->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VectorQ", "ObjectName",
 CellID->23324],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["VectorQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/VectorQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a list or a one\[Hyphen]dimensional ",
     Cell[BoxData[
      ButtonBox["SparseArray",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
     " object, none of whose elements are themselves lists, and gives ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["VectorQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/VectorQ"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["test", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " only if ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " when applied to each of the elements in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->32199]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VectorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VectorQ"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    ButtonBox["NumberQ",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberQ"]}], "]"}]], "InlineFormula"],
 " tests whether ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a vector of numbers. "
}], "Notes",
 CellID->23935]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160392398],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->272806807],

Cell["Test whether an object is a vector:", "ExampleText",
 CellID->520814388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67688093],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108669684]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", "1", "}"}], "\[Rule]", "a"}], ",", 
     RowBox[{
      RowBox[{"{", "5", "}"}], "\[Rule]", "b"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36125004],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->650390386]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32611529],

Cell["These are not vectors: ", "ExampleText",
 CellID->509155597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"{", "2", "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->490895117],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->443627736]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", "vector", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->535656022],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13574241]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->275337451],

Cell["Use specific tests to generalize or specialize:", "ExampleText",
 CellID->318239255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "}"}], ",", "ListQ"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->280849999],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->375023016]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "1.2"}], "}"}], ",", "NumericQ"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->406965974],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80808175]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14376],

Cell["Test for a vector of integers:", "ExampleText",
 CellID->317483784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", "IntegerQ"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->230040277],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->526881233]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->477412241],

Cell["Test for a vector of machine-real numbers:", "ExampleText",
 CellID->58388563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", "MachineNumberQ"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->212789397],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414869750]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}], ",", "MachineNumberQ"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91907687],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->674012782]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53666062],

Cell["Test for a vector of real-valued numeric quantities:", "ExampleText",
 CellID->162495718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "Pi", ",", 
     RowBox[{"Sin", "[", "1", "]"}], ",", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"NumericQ", "[", "#", "]"}], "&&", 
     RowBox[{
      RowBox[{"Im", "[", "#", "]"}], "\[Equal]", "0"}]}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->435983962],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->298977]
}, Open  ]],

Cell["Faster test for explicit real-valued numbers:", "ExampleText",
 CellID->130689922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"N", "[", "Pi", "]"}], ",", 
     RowBox[{"Sin", "[", "1.", "]"}], ",", 
     RowBox[{"3", "/", "4"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"NumberQ", "[", "#", "]"}], "&&", 
     RowBox[{"!", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"#", ",", "_Complex"}], "]"}]}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->386435001],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->377486154]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15201],

Cell["Define a function that only evaluates for vector arguments:", \
"ExampleText",
 CellID->16454487],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"v_", "?", "VectorQ"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"v1", "=", 
        RowBox[{"Take", "[", 
         RowBox[{"v", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"v2", "=", 
        RowBox[{"Take", "[", 
         RowBox[{"v", ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", 
            RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]}], ",", "n"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"Length", "[", "v2", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"v2", "=", 
       RowBox[{"(", 
        RowBox[{"v2", "-", 
         RowBox[{
          RowBox[{"PadRight", "[", 
           RowBox[{"v1", ",", "n", ",", "v1"}], "]"}], "^", "2"}]}], ")"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"v1", "-=", 
       RowBox[{"Range", "[", 
        RowBox[{"Length", "[", "v1", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"v1", ".", "v1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Range", "[", "n", "]"}], "v2"}], ")"}], ".", "v2"}]}]}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356180061],

Cell[TextData[{
 "Numerically find the minimum of the functions with ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " components:"
}], "ExampleText",
 CellID->661982082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Quiet", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"FindMinimum", "[", 
      RowBox[{
       RowBox[{"f", "[", "v", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"1", ",", "n"}], "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "5"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->139203150],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWkly1DAUdVvubjoJCYEEUiSLrBlWEI4AG0LBAVh0pTItKKiQ4hZwF6bz
GUuyOvLTkyX3aANdldhf83/6w2upj8fXF6cfxteXJ+PDV1fjTxeXJ58PX368
KopEL0l660mSvN9Live8eFN/8rNR/OlX/fZN/hemNk/ugHx/RlmoWb5C6Xbx
Ly3EB57nHrRP1ShfoHQN5CHp1S9EUY46gPrBjPWj4p8UU0/9sKzPPPVaqxRa
9S1ZlLMLUi7lpD8ZTY2la/tWr6fWnLJ+g+hoyxnZP7N2+RwF6od0VdhqXU1l
t2o2hotiaWjJpMQZPaOjprSUYyuq45oStHYLbWaR7rhPoJecfUQ07YOMvrZL
5EHpVXV+01Pz4uiwR0TbjLcI96mxP47QY1q6HhgL5wrFqh06C8Yi9IC0CXoV
q8y89ldjlY2ti2MXip0h7NCmdhx9ZY+URJxq1NsoW4kSD+HFI7Nacf+Ms6VH
5cxaRfO511B/tIod2Js4q0mhdNNBceDFo26121FImPxmYqf8vGiIA/cZu5WU
eSv0X47JGu1LI2+wFWqDbMfvjRNf9UR7+fqcjIbsRpS2IeXdUkYcxASHrPRU
O//7+MBmXuUP1OIs+Yea5V1Ap+83rYaAS4nOT/V8m1tZ1plFviLzrH+bNy89
UKPG8lD03n3Vu2v8U6/axy8xY4nc5Z39xMebus4zXZymZZCoSZOMPs88v2gW
iVHqoZqH8p6aeILtOaa4++1niTjL/vzQqYnh3WKEHCNkgmyvTbxi9Tzzt4kL
+vV2uF9jz8C13Y7Se3nML053zvH42uOYH++7FYXOovgeetjBBAub55m8a38j
svPyVv6f593IR2qUEK9DD1U71zo+p1dl+6SwWpv9N8wrhaf9vaCLfM2PhMHe
ZWT+Ues8Io6xtYuFYVx/lrM4uknXFMrk/hzRVg6G42l7wX2X/pyRWBWSu3f6
huNpPHCUW0G98tzNDAyddp7BYQzSKKB+PGbQdTdg4s1O3LA3MonpuBf3CieK
BrHgaw95DdrNFGdrHuaBzNTHs1B/zQ1Sq9bmUfZ5iMlBsjx0jlbDnJz89Oum
ztH8t3oaPmXysmZZss1iedQb1cvHm9CzjlXrZfMlPauPD+H5p+/ZPj7k19Gg
NtvtZddPoBD717nx42m/Mw6qmCYuVwhFt1WyH+yvbQY1GC0Uj+luthfDfjge
2Mucjtt3hvZNY318WCaP4frE8Rb0CsXxKjuL6Mbl5XkxFa5bc06ysvu+KTkJ
xjCdb5GL+O70jI3+nVzkXLVC7nEX5DPVat6c46yyD+3/zZW79n/xl06I4GnO
IiTGGprTO8MCsP1ZvM6RvzKiNykryvFcW993tyZn/vXnoovM836dmlhtU12X
l+u7op/vPgflI1LPcvn5RE9zb2P/Ng3va7I8Lpcv597Gl9uT3h/fP0A/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{267, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->81781898]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20634],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["VectorQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VectorQ"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["ArrayQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->308723009],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2.", ",", "E", ",", 
     RowBox[{"Pi", "+", "I"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->548544250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VectorQ", "[", "v", "]"}], ",", 
   RowBox[{"ArrayQ", "[", 
    RowBox[{"v", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->263198888],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->438102040]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VectorQ", "[", 
    RowBox[{"v", ",", "NumericQ"}], "]"}], ",", 
   RowBox[{"ArrayQ", "[", 
    RowBox[{"v", ",", "1", ",", "NumericQ"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->618900711],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->127629230]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VectorQ", "[", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "#", "]"}], "\[Equal]", "0"}], "&"}]}], "]"}], ",", 
   
   RowBox[{"ArrayQ", "[", 
    RowBox[{"v", ",", "1", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "#", "]"}], "\[Equal]", "0"}], "&"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->344826294],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "False"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->387966540]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186313404],

Cell[TextData[{
 "A function equivalent to ",
 Cell[BoxData[
  ButtonBox["VectorQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VectorQ"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->59269994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"testf", "=", 
  RowBox[{
   RowBox[{"MatchQ", "[", 
    RowBox[{"#", ",", 
     RowBox[{"List", "[", 
      RowBox[{"args___", "?", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Not", "[", 
          RowBox[{"ListQ", "[", "#", "]"}], "]"}], "&"}], ")"}]}], "]"}]}], 
    "]"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102507817],

Cell[BoxData[
 RowBox[{
  RowBox[{"MatchQ", "[", 
   RowBox[{"#1", ",", 
    RowBox[{"{", 
     RowBox[{"args___", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"ListQ", "[", "#1", "]"}]}], "&"}], ")"}]}], "}"}]}], "]"}], 
  "&"}]], "Output",
 ImageSize->{266, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5448474]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"vectors", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->348459378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"VectorQ", "[", "v", "]"}], ",", 
       RowBox[{"testf", "[", "v", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "vectors"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableDepth", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->702114143],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", "}"}], "True", "True"},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "True", "True"},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], "False", "False"},
    {
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "}"}], "False", "False"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, TableDepth -> 2]]]], "Output",
 ImageSize->{144, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->555154409]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1277],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayDepth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayDepth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dimensions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dimensions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21486]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15580],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->25132],

Cell[TextData[ButtonBox["Scalars, Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ScalarsVectorsAndMatrices"]], "Tutorials",
 CellID->11061]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->605237045],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->151327628],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->221703445],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->666718762]
}, Open  ]],

Cell["New in 1  |  Last modified in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VectorQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 57.3359042}", "context" -> "System`", 
    "keywords" -> {
     "lists as vectors", "test if vector", "testing for numerical vectors", 
      "testing for vectors", "vector argument functions"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "VectorQ[expr] gives True if expr is a list or a one-dimensional \
SparseArray object, none of whose elements are themselves lists, and gives \
False otherwise. VectorQ[expr, test] gives True only if test yields True when \
applied to each of the elements in expr. ", "synonyms" -> {"vector q"}, 
    "title" -> "VectorQ", "type" -> "Symbol", "uri" -> "ref/VectorQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6086, 192, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->160392398]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26704, 976}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2551, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3174, 86, 45, 1, 70, "ObjectName",
 CellID->23324],
Cell[3222, 89, 1878, 60, 70, "Usage",
 CellID->32199]
}, Open  ]],
Cell[CellGroupData[{
Cell[5137, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5615, 171, 434, 16, 70, "Notes",
 CellID->23935]
}, Closed]],
Cell[CellGroupData[{
Cell[6086, 192, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160392398],
Cell[CellGroupData[{
Cell[6471, 206, 148, 5, 70, "ExampleSection",
 CellID->272806807],
Cell[6622, 213, 78, 1, 70, "ExampleText",
 CellID->520814388],
Cell[CellGroupData[{
Cell[6725, 218, 159, 5, 28, "Input",
 CellID->67688093],
Cell[6887, 225, 161, 5, 36, "Output",
 CellID->108669684]
}, Open  ]],
Cell[CellGroupData[{
Cell[7085, 235, 310, 11, 28, "Input",
 CellID->36125004],
Cell[7398, 248, 161, 5, 36, "Output",
 CellID->650390386]
}, Open  ]],
Cell[7574, 256, 124, 3, 70, "ExampleDelimiter",
 CellID->32611529],
Cell[7701, 261, 66, 1, 70, "ExampleText",
 CellID->509155597],
Cell[CellGroupData[{
Cell[7792, 266, 200, 7, 70, "Input",
 CellID->490895117],
Cell[7995, 275, 162, 5, 36, "Output",
 CellID->443627736]
}, Open  ]],
Cell[CellGroupData[{
Cell[8194, 285, 108, 3, 70, "Input",
 CellID->535656022],
Cell[8305, 290, 161, 5, 36, "Output",
 CellID->13574241]
}, Open  ]],
Cell[8481, 298, 125, 3, 70, "ExampleDelimiter",
 CellID->275337451],
Cell[8609, 303, 90, 1, 70, "ExampleText",
 CellID->318239255],
Cell[CellGroupData[{
Cell[8724, 308, 260, 10, 70, "Input",
 CellID->280849999],
Cell[8987, 320, 161, 5, 36, "Output",
 CellID->375023016]
}, Open  ]],
Cell[CellGroupData[{
Cell[9185, 330, 184, 6, 70, "Input",
 CellID->406965974],
Cell[9372, 338, 161, 5, 36, "Output",
 CellID->80808175]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9582, 349, 216, 7, 70, "ExampleSection",
 CellID->14376],
Cell[9801, 358, 73, 1, 70, "ExampleText",
 CellID->317483784],
Cell[CellGroupData[{
Cell[9899, 363, 167, 5, 70, "Input",
 CellID->230040277],
Cell[10069, 370, 161, 5, 36, "Output",
 CellID->526881233]
}, Open  ]],
Cell[10245, 378, 125, 3, 70, "ExampleDelimiter",
 CellID->477412241],
Cell[10373, 383, 84, 1, 70, "ExampleText",
 CellID->58388563],
Cell[CellGroupData[{
Cell[10482, 388, 175, 6, 70, "Input",
 CellID->212789397],
Cell[10660, 396, 162, 5, 36, "Output",
 CellID->414869750]
}, Open  ]],
Cell[CellGroupData[{
Cell[10859, 406, 205, 7, 70, "Input",
 CellID->91907687],
Cell[11067, 415, 161, 5, 36, "Output",
 CellID->674012782]
}, Open  ]],
Cell[11243, 423, 124, 3, 70, "ExampleDelimiter",
 CellID->53666062],
Cell[11370, 428, 95, 1, 70, "ExampleText",
 CellID->162495718],
Cell[CellGroupData[{
Cell[11490, 433, 415, 14, 70, "Input",
 CellID->435983962],
Cell[11908, 449, 158, 5, 36, "Output",
 CellID->298977]
}, Open  ]],
Cell[12081, 457, 88, 1, 70, "ExampleText",
 CellID->130689922],
Cell[CellGroupData[{
Cell[12194, 462, 462, 15, 70, "Input",
 CellID->386435001],
Cell[12659, 479, 161, 5, 36, "Output",
 CellID->377486154]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12869, 490, 223, 7, 70, "ExampleSection",
 CellID->15201],
Cell[13095, 499, 103, 2, 70, "ExampleText",
 CellID->16454487],
Cell[13201, 503, 1408, 44, 70, "Input",
 CellID->356180061],
Cell[14612, 549, 190, 6, 70, "ExampleText",
 CellID->661982082],
Cell[CellGroupData[{
Cell[14827, 559, 494, 16, 70, "Input",
 CellID->139203150],
Cell[15324, 577, 1681, 31, 70, "Output",
 Evaluatable->False,
 CellID->81781898]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17054, 614, 233, 7, 70, "ExampleSection",
 CellID->20634],
Cell[17290, 623, 318, 12, 70, "ExampleText",
 CellID->308723009],
Cell[17611, 637, 207, 7, 70, "Input",
 CellID->548544250],
Cell[CellGroupData[{
Cell[17843, 648, 209, 7, 70, "Input",
 CellID->263198888],
Cell[18055, 657, 209, 7, 36, "Output",
 CellID->438102040]
}, Open  ]],
Cell[CellGroupData[{
Cell[18301, 669, 258, 8, 70, "Input",
 CellID->618900711],
Cell[18562, 679, 209, 7, 36, "Output",
 CellID->127629230]
}, Open  ]],
Cell[CellGroupData[{
Cell[18808, 691, 429, 16, 70, "Input",
 CellID->344826294],
Cell[19240, 709, 212, 7, 36, "Output",
 CellID->387966540]
}, Open  ]],
Cell[19467, 719, 125, 3, 70, "ExampleDelimiter",
 CellID->186313404],
Cell[19595, 724, 206, 8, 70, "ExampleText",
 CellID->59269994],
Cell[CellGroupData[{
Cell[19826, 736, 374, 13, 70, "Input",
 CellID->102507817],
Cell[20203, 751, 406, 15, 36, "Output",
 CellID->5448474]
}, Open  ]],
Cell[20624, 769, 421, 15, 70, "Input",
 CellID->348459378],
Cell[CellGroupData[{
Cell[21070, 788, 423, 13, 70, "Input",
 CellID->702114143],
Cell[21496, 803, 994, 32, 92, "Output",
 CellID->555154409]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22551, 842, 310, 9, 70, "SeeAlsoSection",
 CellID->1277],
Cell[22864, 853, 943, 35, 70, "SeeAlso",
 CellID->21486]
}, Open  ]],
Cell[CellGroupData[{
Cell[23844, 893, 314, 9, 70, "TutorialsSection",
 CellID->15580],
Cell[24161, 904, 170, 3, 70, "Tutorials",
 CellID->25132],
Cell[24334, 909, 165, 3, 70, "Tutorials",
 CellID->11061]
}, Open  ]],
Cell[CellGroupData[{
Cell[24536, 917, 319, 9, 70, "MoreAboutSection",
 CellID->605237045],
Cell[24858, 928, 144, 3, 70, "MoreAbout",
 CellID->151327628],
Cell[25005, 933, 152, 3, 70, "MoreAbout",
 CellID->221703445],
Cell[25160, 938, 149, 3, 70, "MoreAbout",
 CellID->666718762]
}, Open  ]],
Cell[25324, 944, 50, 0, 70, "History"],
Cell[25377, 946, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

