(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17279,        645]
NotebookOptionsPosition[     12880,        495]
NotebookOutlinePosition[     14292,        534]
CellTagsIndexPosition[     14207,        529]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"], 
          "Verbatim Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/VerbatimPatterns"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns and Transformation Rules\"\>", 
       2->"\<\"Verbatim Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HoldPattern" :> 
          Documentation`HelpLookup["paclet:ref/HoldPattern"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"HoldPattern\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:guide/Patterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Verbatim", "ObjectName",
 CellID->31374],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Verbatim",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Verbatim"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in pattern matching, requiring that ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " be matched exactly as it appears, with no substitutions for blanks or \
other transformations. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23820]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Verbatim",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Verbatim"], "[", "x_", "]"}]], "InlineFormula"],
 " will match only the actual expression ",
 Cell[BoxData["x_"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15711],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Verbatim",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Verbatim"]], "InlineFormula"],
 " is useful in setting up rules for transforming other transformation rules. \
"
}], "Notes",
 CellID->179],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Verbatim",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Verbatim"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " does not maintain ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " in an unevaluated form. "
}], "Notes",
 CellID->22203]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->410736464],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->246110186],

Cell["Match any expression:", "ExampleText",
 CellID->20276633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"any", "[", "expression", "]"}], ",", "x_"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->781949370],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32774070]
}, Open  ]],

Cell["Match only the pattern x_:", "ExampleText",
 CellID->70094912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"any", "[", "expression", "]"}], ",", " ", 
   RowBox[{"Verbatim", "[", "x_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->446288799],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->415573399]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{"x_", ",", " ", 
   RowBox[{"Verbatim", "[", "x_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1029412042],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->115716376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65275745],

Cell[TextData[{
 "Rule that changes only the pattern when it is explicitly",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["x_", "TI"], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->671095986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"f", "[", "x_", "]"}], ",", 
    RowBox[{"f", "[", "y_", "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Verbatim", "[", "x_", "]"}], "]"}], "->", 
   RowBox[{"x", "^", "2"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->595486533],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   SuperscriptBox["x", "2"], ",", 
   RowBox[{"f", "[", "y_", "]"}], ",", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{140, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4265761]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2552],

Cell["Transform a rule into a list of rules with special cases:", \
"ExampleText",
 CellID->370127349],

Cell[BoxData[
 RowBox[{
  RowBox[{"rule", " ", "=", " ", 
   RowBox[{"x_", "\[RuleDelayed]", 
    RowBox[{"x", "^", "2"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->475728434],

Cell["This rule transforms an expression into its square:", "ExampleText",
 CellID->134384068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "+", 
   RowBox[{"f", "[", 
    RowBox[{"1", "+", "b"}], "]"}], "+", 
   RowBox[{"g", "[", 
    RowBox[{"3.", ",", 
     RowBox[{"4", "+", 
      RowBox[{"5", " ", "I"}]}]}], "]"}]}], " ", "/.", " ", "rule"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->84941871],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"f", "[", 
     RowBox[{"1", "+", "b"}], "]"}], "+", 
    RowBox[{"g", "[", 
     RowBox[{"3.`", ",", 
      RowBox[{"4", "+", 
       RowBox[{"5", " ", "\[ImaginaryI]"}]}]}], "]"}]}], ")"}], 
  "2"]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54565684]
}, Open  ]],

Cell["Use Verbatim to make rules specific for number types:", "ExampleText",
 CellID->538270737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"specifics", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"rule", " ", "/.", " ", 
     RowBox[{
      RowBox[{"Verbatim", "[", "x_", "]"}], "\[RuleDelayed]", 
      RowBox[{"Pattern", "[", 
       RowBox[{"x", ",", 
        RowBox[{"Blank", "[", "type", "]"}]}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"type", ",", " ", 
      RowBox[{"{", 
       RowBox[{"Integer", ",", " ", "Real", ",", " ", "Rational"}], "}"}]}], 
     "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->184848028],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x_Integer", "\[RuleDelayed]", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"x_Real", "\[RuleDelayed]", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"x_Rational", "\[RuleDelayed]", 
    SuperscriptBox["x", "2"]}]}], "}"}]], "Output",
 ImageSize->{301, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->41628979]
}, Open  ]],

Cell["\<\
The list of specific rules only transforms integers, reals and rationals:\
\>", "ExampleText",
 CellID->738278115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "+", 
   RowBox[{"f", "[", 
    RowBox[{"1", "+", "b"}], "]"}], "+", 
   RowBox[{"g", "[", 
    RowBox[{"3.", ",", 
     RowBox[{"4", "+", 
      RowBox[{"5", " ", "I"}]}]}], "]"}]}], " ", " ", "/.", " ", 
  "specifics"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5758518],

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{"f", "[", 
   RowBox[{"1", "+", "b"}], "]"}], "+", 
  RowBox[{"g", "[", 
   RowBox[{"9.`", ",", 
    RowBox[{"4", "+", 
     RowBox[{"5", " ", "\[ImaginaryI]"}]}]}], "]"}]}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->63417794]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9976],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->7439]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19910],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785],

Cell[TextData[ButtonBox["Verbatim Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VerbatimPatterns"]], "Tutorials",
 CellID->12718]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->375857251],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->420591149]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Verbatim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 58.2578028}", "context" -> "System`", 
    "keywords" -> {
     "disabling patterns", "literal patterns", "transforming rules", 
      "transforming patterns", "pattern language"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Verbatim[expr] represents expr in pattern matching, requiring that expr \
be matched exactly as it appears, with no substitutions for blanks or other \
transformations. ", "synonyms" -> {}, "title" -> "Verbatim", "type" -> 
    "Symbol", "uri" -> "ref/Verbatim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4735, 163, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->410736464]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14064, 522}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1905, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2528, 77, 46, 1, 70, "ObjectName",
 CellID->31374],
Cell[2577, 80, 743, 22, 70, "Usage",
 CellID->23820]
}, Open  ]],
Cell[CellGroupData[{
Cell[3357, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3835, 124, 284, 10, 70, "Notes",
 CellID->15711],
Cell[4122, 136, 243, 8, 70, "Notes",
 CellID->179],
Cell[4368, 146, 330, 12, 70, "Notes",
 CellID->22203]
}, Closed]],
Cell[CellGroupData[{
Cell[4735, 163, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->410736464],
Cell[CellGroupData[{
Cell[5120, 177, 148, 5, 70, "ExampleSection",
 CellID->246110186],
Cell[5271, 184, 63, 1, 70, "ExampleText",
 CellID->20276633],
Cell[CellGroupData[{
Cell[5359, 189, 166, 5, 28, "Input",
 CellID->781949370],
Cell[5528, 196, 160, 5, 36, "Output",
 CellID->32774070]
}, Open  ]],
Cell[5703, 204, 68, 1, 70, "ExampleText",
 CellID->70094912],
Cell[CellGroupData[{
Cell[5796, 209, 207, 6, 28, "Input",
 CellID->446288799],
Cell[6006, 217, 162, 5, 36, "Output",
 CellID->415573399]
}, Open  ]],
Cell[CellGroupData[{
Cell[6205, 227, 169, 5, 70, "Input",
 CellID->1029412042],
Cell[6377, 234, 161, 5, 36, "Output",
 CellID->115716376]
}, Open  ]],
Cell[6553, 242, 124, 3, 70, "ExampleDelimiter",
 CellID->65275745],
Cell[6680, 247, 248, 9, 70, "ExampleText",
 CellID->671095986],
Cell[CellGroupData[{
Cell[6953, 260, 425, 14, 70, "Input",
 CellID->595486533],
Cell[7381, 276, 331, 11, 39, "Output",
 CellID->4265761]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7761, 293, 215, 7, 70, "ExampleSection",
 CellID->2552],
Cell[7979, 302, 102, 2, 70, "ExampleText",
 CellID->370127349],
Cell[8084, 306, 186, 6, 70, "Input",
 CellID->475728434],
Cell[8273, 314, 94, 1, 70, "ExampleText",
 CellID->134384068],
Cell[CellGroupData[{
Cell[8392, 319, 302, 11, 70, "Input",
 CellID->84941871],
Cell[8697, 332, 422, 15, 36, "Output",
 CellID->54565684]
}, Open  ]],
Cell[9134, 350, 96, 1, 70, "ExampleText",
 CellID->538270737],
Cell[CellGroupData[{
Cell[9255, 355, 547, 16, 70, "Input",
 CellID->184848028],
Cell[9805, 373, 424, 13, 39, "Output",
 CellID->41628979]
}, Open  ]],
Cell[10244, 389, 124, 3, 70, "ExampleText",
 CellID->738278115],
Cell[CellGroupData[{
Cell[10393, 396, 312, 11, 70, "Input",
 CellID->5758518],
Cell[10708, 409, 359, 12, 36, "Output",
 CellID->63417794]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11128, 428, 310, 9, 70, "SeeAlsoSection",
 CellID->9976],
Cell[11441, 439, 201, 6, 70, "SeeAlso",
 CellID->7439]
}, Open  ]],
Cell[CellGroupData[{
Cell[11679, 450, 314, 9, 70, "TutorialsSection",
 CellID->19910],
Cell[11996, 461, 178, 3, 70, "Tutorials",
 CellID->244552785],
Cell[12177, 466, 144, 3, 70, "Tutorials",
 CellID->12718]
}, Open  ]],
Cell[CellGroupData[{
Cell[12358, 474, 319, 9, 70, "MoreAboutSection",
 CellID->375857251],
Cell[12680, 485, 128, 3, 70, "MoreAbout",
 CellID->420591149]
}, Open  ]],
Cell[12823, 491, 27, 0, 70, "History"],
Cell[12853, 493, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

