(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    225342,       4271]
NotebookOptionsPosition[    219354,       4075]
NotebookOutlinePosition[    220855,       4115]
CellTagsIndexPosition[    220768,       4110]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VertexColors" :> 
          Documentation`HelpLookup["paclet:ref/VertexColors"], 
          "NormalsFunction" :> 
          Documentation`HelpLookup["paclet:ref/NormalsFunction"], "Polygon" :> 
          Documentation`HelpLookup["paclet:ref/Polygon"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"VertexColors\"\>", 2->"\<\"NormalsFunction\"\>", 
       3->"\<\"Polygon\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Polygons" :> Documentation`HelpLookup["paclet:guide/Polygons"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Colors\"\>", 3->"\<\"Polygons\"\>", 
       4->"\<\"New in 6.0: Graphics & Visualization Options\"\>", 
       5->"\<\"New in 6.0: Graphics Primitives & Directives\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["VertexNormals", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["VertexNormals",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/VertexNormals"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " which specifies the normal directions to assign to vertices of 3D \
polygons."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15585]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"VertexNormals", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that vertex ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " of a polygon should have effective normal ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " for purposes of shading by simulated lighting."
}], "Notes",
 CellID->4502],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are vectors of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["x", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["y", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["z", "TI"]]}], "}"}]], "InlineFormula"],
 ". Only the directions of these vectors ever matter; the vectors are in \
effect automatically normalized to unit length."
}], "Notes",
 CellID->440408949]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->225450204],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->407455713],

Cell["\<\
Compute normal vectors using the cross product of edge vectors:\
\>", "ExampleText",
 CellID->909021973],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176938153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{
    RowBox[{"p2", "-", "p1"}], ",", 
    RowBox[{"p3", "-", "p1"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98566966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "1"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->670988590]
}, Open  ]],

Cell[TextData[{
 "A triangle with normals pointing in the direction ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->794880732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], ",", 
      RowBox[{"VertexNormals", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "n", ",", "n"}], "}"}]}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->157239568],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 1, 0], Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}},
    VertexNormals->{{1, -1, 1}, {1, -1, 1}, {1, -1, 1}}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->786100334,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytmWtvGkcUhtfALnew8QUcCCa4xLWT1L0mUa9SPiSVqqi/wUqREqlVqzQ/
r/8sQu2cmbMXHgaPoSB5vbM77/Oemdmd276++fB2/sfNh3dvbiav3t/89fbd
m78nL/98by6V96Io+s38/T6IzPm/5sz+vVgsFlF5Pp8v7C86k0P0kznG5uLE
pn4wx5JJlfW/u/qtOYqwIqmKYTmIOTrGc82dSCo29z/+k2dRn6eap5oyTB6X
rYS4Rjb/V+pZLzBdfnMeUTO0mi/UoympJNNkMr/qWlUtezdTRWU5xFluLY2L
7rFG14amYoXOTW7R8dSqr9SxC3V8J/WFeu9DnUBdhnpg1TP1Plynlv/m51ef
q/oI6irUFaj7Vj3RyI+hrkEdQ31i1WP17kNdtxXv1A5Ad6cfqvsA+saKnv42
Xlv74n8P+uYd9X3Vj3z6ONOvqQNb4/YoF++D0fIyEjBsm0c9jeMMjPYGjP1F
oX8oMDqFlpTTkk27B1KysmV6ltbWUj0ArRugsY4OLK2psZ2Dtg9aORCbo9WV
NtuQxtjs2xrV1tB6G5Y0p6VX5b1niQ83jLGbUyvZVU+7HAW4fGY6OXelP+VT
eLw9u3DV29MXXE7gUgm42H4+quIqn5hTuPR34sJWYv8VciGv5XVhLCdwGcAl
Drg0vS5Mcxw53YkLn4YeXO4FXKhveF3qSHM8HsIlCbhY3ko7NJHuwGW0E5cW
0pzXhFxYFzWvS9tbttzlPlyqgbL4XTredspdxgEXlqXqden6chVczgIuDegT
r8s+0jFcJnCpBcriXNij9JAuw2UaKItQZcCoeemHSJc2pEs02eqDdeGfJ+Wj
l8HM1tXR3P6ibFVyN7amZW70cMPa91M5G14b70ZU9qyMtR54t/xUrhoutqKy
JRkrqY3AKOCnMtZPA1TGWvFSOZZc7oR6AOoVqM1ADfipHJEe7YTKVevjrahc
XzJWUluePidMZaxPdkLlGPzZTqgcc4VqdwkCtLKXxt0MqU+5XdowVj+dI/eV
0pOPtz8Lfjpn64z9QumNAJ29lZ/O2D8xBxkwuHblm3w3egP0qcbOFd52dM5l
JkrneoZ0vsN+eg30sdI5X2Yvz9hLXjpnSEOtd87HON5tRx9o7OcBOmvG0W0F
6UDPWjlRMkcpzlvCZMZ8pGT2/puTE5B7SmZP5Ztr3U7mDLSrrfglyFwhhMkV
kNsa8zOQuVpjbewFyQ0lfxcgM+aUvH6mXFPyj/+bzFlyrPX8IkDme6HkOLvi
0lYn2V6Bx92DNbylGXZZWb+Axb2b21murHL7Vx8nzjiuYbUPE7Hcer2BphiD
vCnyqeBn6LkDJ7HvmdsS8/ITJlwZsarmElun5I3CPfu+GZAwvreajCEpNVv2
l6c63Q8X3VPbfLm3T8Pxd6jaa6/napk5lxsjLazLlThWOek+6Ipe4yn22n4C
189DpDvaruNbSPleMdVHGscgrZesCeXcabmbMVhTt720PjKA03Ofoo/0VPXZ
9wUXQ6bvLorfQ3Ldpeqyr0lLUR94SlpMf671Vsp80u8FzPlsqSZ5lz7fLNwq
3uU+ViZzyRc8KaqbIbNkrLEni+K+A+ufe1pSL9KUbv8z/ZrDXDNlut1/Phdc
e0+U6b7wjJTJXCNl2i9HK+8M38mB5rb57P549m21kOtQnac21wPc9a2DhHlh
c09x1zdDltyPbO70mx9zJRrBtc01K9yVp62ijK/t3YfmmJjUc5uK9v4Dreub
8g==\
\>"]]
}, Open  ]],

Cell["Using different normals will affect shading: ", "ExampleText",
 CellID->238986113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], ",", 
      RowBox[{"VertexNormals", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "n"}], ",", "n", ",", "n"}], "}"}]}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->220323761],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 1, 0], Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}},
    VertexNormals->{{-1, 1, -1}, {1, -1, 1}, {1, -1, 1}}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[4]=",
 CellID->21535949,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23638],

Cell["Define vertices and face indices of a cylindrical model:", "ExampleText",
 CellID->965055],

Cell[BoxData[
 RowBox[{
  RowBox[{"vl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"2", "\[Pi]", " ", 
           RowBox[{"i", "/", "20"}]}], "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "\[Pi]", " ", 
           RowBox[{"i", "/", "20"}]}], "]"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"2", "\[Pi]", " ", 
           RowBox[{"i", "/", "20"}]}], "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "\[Pi]", " ", 
           RowBox[{"i", "/", "20"}]}], "]"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "20"}], "}"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->780167557],

Cell[BoxData[
 RowBox[{
  RowBox[{"il", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"i", "+", "1"}], ",", "20", ",", "1"}], "]"}], ",", 
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"i", "+", "21"}], ",", "20", ",", "21"}], "]"}], ",", 
       RowBox[{"i", "+", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "20"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->313838249],

Cell["\<\
Without surface normals, the shading is constant or flat for each polygon \
face:\
\>", "ExampleText",
 CellID->25220463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", 
    RowBox[{"EdgeForm", "[", "]"}], ",", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"vl", ",", 
      RowBox[{"Polygon", "[", "il", "]"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22404248],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[3]=",
 CellID->63925454]
}, Open  ]],

Cell["\<\
With surface normals, the shading is interpolated or smooth across each \
polygon face: \
\>", "ExampleText",
 CellID->55009090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", 
    RowBox[{"EdgeForm", "[", "]"}], ",", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"vl", ",", 
      RowBox[{"Polygon", "[", "il", "]"}], ",", 
      RowBox[{"VertexNormals", "\[Rule]", "vl"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->326858482],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 1, 0], EdgeForm[None], 
   GraphicsComplex3DBox[
    NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {
      Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {0, 1, 0}, {
      Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {-1, 0, 
      0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
        Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {
      Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
      Rational[1, 4] (1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 0}, {0, -1, 0}, {
      Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
      Rational[1, 4] (1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
        Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {1, 0, 
      0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2]), 2}, {
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 2}, {
      Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 2}, {0, 1, 2}, {
      Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 2}, {
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 2}, {-1, 0, 
      2}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
        Rational[1, 4] (1 - 5^Rational[1, 2]), 2}, {
      Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       2}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 2}, {
      Rational[1, 4] (1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 2}, {0, -1, 2}, {
      Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 2}, {
      Rational[1, 4] (1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
        Rational[1, 4] (1 - 5^Rational[1, 2]), 2}, {1, 0, 2}}, {{
      0.9510565162951535, 0.30901699437494745`, 0}, {
      0.8090169943749475, 0.5877852522924731, 0}, {
      0.5877852522924731, 0.8090169943749475, 0}, {
      0.30901699437494745`, 0.9510565162951535, 0}, {0, 1, 
      0}, {-0.30901699437494745`, 0.9510565162951535, 
       0}, {-0.5877852522924731, 0.8090169943749475, 0}, {-0.8090169943749475,
        0.5877852522924731, 0}, {-0.9510565162951535, 0.30901699437494745`, 
       0}, {-1, 0, 
      0}, {-0.9510565162951535, -0.30901699437494745`, 
       0}, {-0.8090169943749475, -0.5877852522924731, 
       0}, {-0.5877852522924731, -0.8090169943749475, 
       0}, {-0.30901699437494745`, -0.9510565162951535, 0}, {0, -1, 0}, {
      0.30901699437494745`, -0.9510565162951535, 0}, {
      0.5877852522924731, -0.8090169943749475, 0}, {
      0.8090169943749475, -0.5877852522924731, 0}, {
      0.9510565162951535, -0.30901699437494745`, 0}, {1, 0, 0}, {
      0.9510565162951535, 0.30901699437494745`, 2}, {
      0.8090169943749475, 0.5877852522924731, 2}, {
      0.5877852522924731, 0.8090169943749475, 2}, {
      0.30901699437494745`, 0.9510565162951535, 2}, {0, 1, 
      2}, {-0.30901699437494745`, 0.9510565162951535, 
       2}, {-0.5877852522924731, 0.8090169943749475, 2}, {-0.8090169943749475,
        0.5877852522924731, 2}, {-0.9510565162951535, 0.30901699437494745`, 
       2}, {-1, 0, 
      2}, {-0.9510565162951535, -0.30901699437494745`, 
       2}, {-0.8090169943749475, -0.5877852522924731, 
       2}, {-0.5877852522924731, -0.8090169943749475, 
       2}, {-0.30901699437494745`, -0.9510565162951535, 2}, {0, -1, 2}, {
      0.30901699437494745`, -0.9510565162951535, 2}, {
      0.5877852522924731, -0.8090169943749475, 2}, {
      0.8090169943749475, -0.5877852522924731, 2}, {
      0.9510565162951535, -0.30901699437494745`, 2}, {1, 0, 2}}], 
    Polygon3DBox[{{1, 2, 22, 21}, {2, 3, 23, 22}, {3, 4, 24, 23}, {4, 5, 25, 
     24}, {5, 6, 26, 25}, {6, 7, 27, 26}, {7, 8, 28, 27}, {8, 9, 29, 28}, {9, 
     10, 30, 29}, {10, 11, 31, 30}, {11, 12, 32, 31}, {12, 13, 33, 32}, {13, 
     14, 34, 33}, {14, 15, 35, 34}, {15, 16, 36, 35}, {16, 17, 37, 36}, {17, 
     18, 38, 37}, {18, 19, 39, 38}, {19, 20, 40, 39}, {20, 1, 21, 40}}],
    VertexNormals->
     NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {0, 1, 0}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {
       Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {-1, 0, 
       0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {
       Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
       Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 0}, {0, -1, 0}, {
       Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
       Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {1, 0, 
       0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
         Rational[1, 4] (-1 + 5^Rational[1, 2]), 2}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        2}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 2}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 2}, {0, 1, 2}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        2}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 2}, {
       Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        2}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 2}, {-1, 0, 
       2}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 2}, {
       Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        2}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 2}, {
       Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 2}, {0, -1, 2}, {
       Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        2}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 2}, {
       Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        2}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 2}, {1, 0, 2}},
       {{0.9510565162951535, 0.30901699437494745`, 0}, {
       0.8090169943749475, 0.5877852522924731, 0}, {
       0.5877852522924731, 0.8090169943749475, 0}, {
       0.30901699437494745`, 0.9510565162951535, 0}, {0, 1, 
       0}, {-0.30901699437494745`, 0.9510565162951535, 
        0}, {-0.5877852522924731, 0.8090169943749475, 
        0}, {-0.8090169943749475, 0.5877852522924731, 
        0}, {-0.9510565162951535, 0.30901699437494745`, 0}, {-1, 0, 
       0}, {-0.9510565162951535, -0.30901699437494745`, 
        0}, {-0.8090169943749475, -0.5877852522924731, 
        0}, {-0.5877852522924731, -0.8090169943749475, 
        0}, {-0.30901699437494745`, -0.9510565162951535, 0}, {0, -1, 0}, {
       0.30901699437494745`, -0.9510565162951535, 0}, {
       0.5877852522924731, -0.8090169943749475, 0}, {
       0.8090169943749475, -0.5877852522924731, 0}, {
       0.9510565162951535, -0.30901699437494745`, 0}, {1, 0, 0}, {
       0.9510565162951535, 0.30901699437494745`, 2}, {
       0.8090169943749475, 0.5877852522924731, 2}, {
       0.5877852522924731, 0.8090169943749475, 2}, {
       0.30901699437494745`, 0.9510565162951535, 2}, {0, 1, 
       2}, {-0.30901699437494745`, 0.9510565162951535, 
        2}, {-0.5877852522924731, 0.8090169943749475, 
        2}, {-0.8090169943749475, 0.5877852522924731, 
        2}, {-0.9510565162951535, 0.30901699437494745`, 2}, {-1, 0, 
       2}, {-0.9510565162951535, -0.30901699437494745`, 
        2}, {-0.8090169943749475, -0.5877852522924731, 
        2}, {-0.5877852522924731, -0.8090169943749475, 
        2}, {-0.30901699437494745`, -0.9510565162951535, 2}, {0, -1, 2}, {
       0.30901699437494745`, -0.9510565162951535, 2}, {
       0.5877852522924731, -0.8090169943749475, 2}, {
       0.8090169943749475, -0.5877852522924731, 2}, {
       0.9510565162951535, -0.30901699437494745`, 2}, {1, 0, 
       2}}]]}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[4]=",
 CellID->345419746,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyU3Ad4FGma4Pn/VVf3TM/27NzN7uzu3N7dzu7d7t7cc9tlKU/hvQchEBLy
3nvvvffee+9dSikvISEhlVSihFGrBUIIGeQNwlU/d18EVDUNdE0Xz6tEkRlK
Mn685ovIhBM69sYGFjr2Jno6/3TIVsfa2ETP7p8OWtmKu37xPwGJ4ivvPyC+
///Ed/JX4h/+8AfQFbe/MDAw+EDe0ha374itd6Qt6e4/yL94T35U8+Wj7778
/X35XvWXz/CrV35G3L78GbWX+/76rY9eePnov5K23v3xzxPf/FZ+XOXlc/+t
tPXLHx9/+Rz/Q97n7Mvn+J9/Yp9TL5/n7187rteP8/+R9z7x8hn/4S/a+9jL
vf/9a4/+4rXtf5b3Pvzylfzja4+++9r2/y3vffDlc/9vf9He+1/u/X+89ugv
X9v+7/Lee16+kv/8Lzz3i713vXzu/+tfeO7/Ju/91cvn/m+vPfqr17b/q7z3
Fy+f+5//or0/e7m3nBN/V/YJlZ9R8yX1O1HsRrmXtgN0HqLnCH3HGTjJ0BlG
znH9PDcuwt+99ox/9dq2fHTsePnq/0ba+sfUD8j8gNwPKfyI4h2UfUrlF9R8
Rf0uFHtQ7qftIJ2H6TlG3wkGTjN0lpHzXL/ADTVuqTN+mQkt7ugwpQd/8xf9
+R/94ZWa+c9h7xH1PnEfkPQhaR+S9RG5H1O4g+JPKfucyi+p+Zr63Sj2oTxA
2yE6j9JznL5TDJxhSIURVa5f5IY6ty4zrsmENnd0mdJn2pAZY+ZMWTDnDem/
fm37/5Rf1wcvX5f8qv/Z7bd4vYff+wR9QNgHRH1I3EckfUTax2TtIO8Tij6h
+DPKvqByJzW7qN+LYj/KQ7QdofMYPSfpO83AOYbOM3KB65e4ocEtTca1mdDl
jj5ThkwbM2PKnDkLFixasWzDmh0bDrxRib9+bfu/yK/3t394pTO9Z/1b7N/D
+T3c38f7A/w/JPhDwj8i+mPid5C0g7RPyPqUvE8p+ozizyn7isqvqdlD/T4U
B1Eepu0onSfoOUXfWQZUGLrAiBrX1bmhyS1txnWY0OOOAVNGTJswY8acBQtW
LNqwbMeaAxtObDnzyBWpL/2rt77i//dV4Q9Nf4vFe9i8j/37OH+A+4d4f4T/
RwR/TPgOoj8h/hOSPyX9M7I/J/9zir6g+EvKdlK5m5q91B9AcQjlEdqO03mS
njP0nWNAlaGLjFzi+mVuaHFLh3E9Jgy4Y8SUCdNmzFgwZ8mCNYu2LNuz5siG
M1uuPHKTXve25xuvXO4fcneT7pQzZ4fRbzF7D8v3sfkQhw9x+QiPj/H5mIAd
hHxCxKdEf0r8ZyR/TvoXZH9B/pcUf0XJTsp2UbmHmv3UH0RxBOUx2k7QeZqe
s/SdZ+ACQ5cY0eC6Jjd0uKXLuD4ThtwxZsqUaXNmLJmzZsGWRXuWHVlzZsOV
LTe23OUX78VjH574vlmH/yQfw39/te4+1/ktBu9h/D7mH2D1IbYf4fAxLjvw
2IHPJwR8SshnRHxGzOckfEHKl2R8Sc5XFOyk+GtKdlG2m8p91Byg/jCKoyiP
03aKzjP0qNCnyoAaQ+qMXOa6Njd0uaXPuCETxtwxZcqcaUtmrJmzYcGORQeW
nVhzYcONTXe2POQj8eGxL4/9eRLA0yDeqNcXx/NfXz2eneq/Res9dN/H8ANM
PsTiI6w/xm4Hjp/g+imen+L7GQGfE/I5EV8Q8yUJX5HyFRk7yfmagl0U76Jk
N2V7qdxPzSHqj6A4jvIkbafpPEfPefouMnCJIQ1GtLiuww19bhkwbsSECXfM
mLJg2ooZG+bsWHBg0YllF9bc2PBg04MtL/mofNn243EATwJ5GsyzEJ6F8UaP
/E/ysf2XV3v0brXfovEe2u+j9wFGH2L6EZYfY7MDu09x/AzXz/D8HN8vCPyS
0C+J/IrYnSTuJPVrMneRs5uC3ZTsoXQvZfuoPEjNYeqPoTiB8hRtZ+lUoecC
fWoMaDCkyYg21/W4YcAtI8ZNmDDjjgVTVkzbMGPHnD0Ljiw6s+zKmjsbnmx6
seUtHd4jP7b9eRzIk2CehvA0jGfhPI/k+6g3puiLY/ynP7yyOtp39reovofa
+1z+AO0P0f8Io48x24HlJ9h+iv1nOH2O2xd4fonvVwR+RehOIr8mdheJu0jd
TeYecvdQuJeSfZTup+wAlYeoOUr9cRQnUZ6h7RydqvRcpE+dgcsMaTGiy3V9
bhhxy5hxUybMuWPJlDXTtszYM+fIgjOLriy7s+bJhheb3mz6yEfqz3Ygj4N4
HMKTUJ6G8yyC51F8H833sbxxtPJ6Rb798WgPnvgfnH6Pc+9z4QMufYjmR+h8
jMEOjD/B/FOsPsPucxy+wOlL3L7Cayd+Own6mrBdRO0mbjdJe0jdS+Y+cvdR
uJ+SA5QepPwQlUeoOUb9SRSnUZ6l7TydF+i5RJ8GA5oM6TCix3VDbhhzy5Rx
cyYsuWPNlC3T9sw4MOfEgguLbix7sObFug8bPmz6ysccwHYQ28E8DuVJGE8j
eBbF82iex/J9HN/Hv3HU/7t81P/xD6+scA+dfI8z76PyARc/RP0jtD5GdweG
n2DyKRafYf059l/g+BVOO3H7Gq+v8dtF0G7C9hC1h7i9JO0jbT9Z+8k7QNFB
Sg9Rdojyw1QepeYE9adQnEGpQpsqnWr0qNOnyYA2Q7qMGHDdiBsm3DJj3IIJ
K+7YMGXHtAMzTsy5sODGogfLXqz5sO7Lhh+b/vJRB/EomO1QHofxJIKnkTyN
5lkMz+VD/j6B78WZx+sryhdH/o8v/77lNdkRceSnPuDsh5z/CLWP0diB9ifo
fYrRZ5h+juUX2HyJg3zkzrtw34X3bvz3ELyX8L1E7SNuP0kHSDtA1kHyDlF0
mNLDlB2h/CiVx6k5Sf1pFOdQnqftIp2X6LlMnxYDOgzpM2LIdRNumHHLgnEr
Jmy4Y8eUA9NOzDgz58qCO4ueLHuz5su6Hxv+bAawFSgffwjbYTwO50kkT6J4
GsOzWJ7/cOTfJ/F98pvHL6/m+Xcv/+bl85ZjJ3/Lqfc5/SHnPkZ1B5c+4fKn
6HyG/ucYf4HZl1h9he1OHL/GaRcuu3Hfg/de/PcRvI/w/UQfIP4gyQdJP0T2
YfKPUHyE0qOUH6PiOJUnqDlN/VkUKigv0KZGpwY9mvTpMKDHkAEjxlw35YY5
tywZt2bCljv2TDky7cyMK3PuLHiy6M2yL2v+rPuzEcBGIJvBMkEY2+E8juRx
FE9ieBrLs3ieJ/D8h+P/PoXvU3njfOiFwr99mQXymdmxEz8onPkYlR1c+AT1
T9H8DN3PMfgCky8x/wrrndjJCs57cN2Lxz589hNwgOADhB8k+hDxh0g+TPoR
so+Sf5TiY5Qdp/wEFSepPEXNGerPoVBFeZE2dTov06NNny4D+gwZMWLCdXNu
WHLLmnFbJuy548iUM9OuzLgx58GCF4s+LPuxFsBaIOuBbASxGSJDhPMogu0o
HkfzJJancTxL4Fkiz5N4/qPCO9+nvSHxH2WJv38p8W+krRNC4uT7nPqQ0x9z
dgcqn3LxM9Q/R+sLdL/E8CtMdmLxNda7sN+N0x5c9uK2H48D+Bwk4CAhh4g4
TMwREo6QcpSMY+QcI/84xScoO0n5KSpOU3mamrPUn0dxAeUl2jTo1KJHhz49
BgwZMmbEjOsW3LDilg3jdkw4cMeJKRem3ZjxYM6LBR8W/VgOYDWQtSDWg9kI
ZjNUwtiK4FEU29E8juVJHE8SeJrIs2RJ4nkKz1MRDt+nSx4Zb3j8r7LH372s
D/ks/OSL/nD6I87s4NynnP8ctS/Q+BLtr9DbidHXmO7Ccjc2e3DYi/M+XPfj
dgCPQ/gcIuAwIUeIOErMURKOkXKcjOPknKDgJCWnKD8tY5yh6iw1KtSrolBD
qU6bJp3a9OjRZ8CAEUOmjJhz3YobNtyyY9yBCSfuuDDlxrQ7M57MebPgy6I/
y4GsBrMWzHoIG6FshskekTyKZjuGx3E8judJIk+TeJbyEuN5Gs/TERTfZwqR
rDfOb16I/O0fXrnScOpVkbOfovI5ql9w6Usuf4XOTvS/xngXZrux2oPtXhz3
4XIAt4O4H8LzML5HCDxK6DEijxF7nMQTpJwk4yQ5pyg4Tclpys9QcZbKc1Sp
UHOe+osoLqG8TJsWnbr06NNnyIAJQ2aMWHLdmjFbbtkz7siEM3dcmXJn2pMZ
b+Z8WfBnMZDlYFZDWAtlPZSNMDbCZZQoHsWwHcd2PI8TeZLE0xSepfIs7aXI
c1lEgAiV7Dfy5B9/VHn1Xjlfdv6Jziec+4zzX3DhK9R3ovk1ursw2I3JHsz3
Yr0Pu/04HcD1IG6H8TiC51F8jxF4nNDjRJ4g9iSJp0g9ReZpcs9QeJbSs5Sf
o0KFyvNUq1JzgXo1FBooNWnToVOPHgP6jBkwZciCESuu2zJmzy1Hxp2ZcGXS
nSlPpr2Y8WHOj4UAFoNYDmE1VBznmljy/v16OBuRslAMj2J5FM92Ao+TeJLM
01SepvEs/SXP80yeZyFwvs8RRrlvGP0H2eg3r9wrnX3+wxvd9oWRyheofsXF
r9HYhdZu9PZguBfTfVjsx+YA9gdxPiQZuQujY3gdx+8EQScIO0nUKWJPk3ia
1DNkniX3HIXnKFWh4jyVqlRdoPoiNWrUq6O4jFKbNl06Degxos+EAXOGLBmx
4bodYw7ccmLchQk3Jj2Y8mLahxk/ZgNYCGIxhOUwVsJYDWctgvUINqIkpc1Y
tuJ4lMB2Io+TeZLKkzSeSt3lWYZYbr4wep7N8xwEkXDK+ymnP7kOKc0njp58
g+n8V1z4GrVdaOxBey96+zDaj+kBLA9icwiHwzgfwe0oHsfwPI73SfxOEXSK
sNNEnSHuDElnSTtHlgp5KhSdp0yVigtUXqTqItVq1FyiXgOFFkod2vTpNKTH
mD4zBiwYsmbElusOjDlxy4VxNyY8mPRiyodpX2b8mQ1kIZjFUJbDWYlgNYK1
SNaj2IiWpeLYSuBRItvJbKfwOI0n6bzzNBN+9SyTZz8oPc/leZ5wyhd6T/P4
ww+/pNz5xz9KvXG1VZ5dR3+cWufktnT+S1R3cnEXl/ZweS86+9Dfj/EBzA5i
dQjbwzgeweUo7oLqBF4n8TmF/2mCzhB2lqhzxJ0jSYW082SdJ0+VoguUXaTi
IpVqVF+iRp1aDeo1UWij1KPNgE4jekzpM2fAiiEbRuy57siYM7dcGXdnwpNJ
b6Z8mfZnJpDZYBZCWQxnOYKVSFajWItiPZr1GFkrnq1EHiXxKIXtVB6n8yRD
aIl29GtB9SybZz9QPc/neQHfF/A0/82Vzr9/owalb1/v8fI68Pir/fwF3IVd
qO1BfR+a+9E9gMFBTA5hfhjrI9gdxekYrsfxkOG8T+N7Bv+zBJ8jXIVoFeLP
k6xKuirZF8i7SJEaZWpUXqJKnWoNai5Tq0m9FgpdlPq0GdFpQo8ZfZYMWDNk
x4gD150Zc+WWO+OeTHgz6cuUH9MBzAQxG8JCGIsRLEexEsVqNKsxrMWwHifb
JbKVxFYKj1LZTudxBk+yeJLN02xRlTnitP5ZLs9+gHteyPMinha8uVb+d2+1
e134X0s3F06899Lu3Oeo/GB3cTeX9qKxH62D6B3C8DCmR7A4is0x7I/jfAK3
k3iewus0PmfwPYe/CsHnCT9PtCrxF0i+SPpFstXIv0TxJcrVqdSg6jLVmtRo
UatNvQ4KPZSGtBnTaUqPBX1WDNgyZM+IE9ddGHPjlgfjXkz4MOnHVADTQcyE
MBvGQgSLUSxHsxzDSgyrsazFsh4v8W0ksZnMViqP0tjO4HEmj7N5ksNTEQJO
tnuWz7Mf7J4X87SIR28R/Ie3Cr6+lzxFj5384E86nOrXEp/aXtT3c/kg2ofQ
P4zREcyOYnkM2+M4nMDlJO4yn/dZic9PhQBVQlSJuEDMRRLUSFEj/RLZ6uRr
UKxB+WUqNanWokabWh3qdKjXRWGA0og2UzrN6bGkz4YBO4YcGXHmuitjHtzy
YtyHCT8mA5gKZDqYmVBmw1mIZDGapRiWY1mJZTWOtXjWE2TBZDZT2UrjUQbb
mWxn81ik3TtPckUF58Ffv9B7VsgzWe95CU+LeVT4Z/xev+r5+hXz37zw++hP
8C7s5uJeLu1H4yCah9A5gsFRjI9hfhyrE9idxPEUrqfxOIPXWXzO4Xsef1UC
LxBykQg1Yi6RcIkUdTI0yLlMwWVKNKnQokqbah1qdKjVpU6Pen0UhihNaDOj
04Iea/psGXBgyIkRV667M+bJLW/GfZnwZzKQqWCmQ5kJZzaShWgWY1mKZTmO
lXhW41lLYC1R9kthM42tdLYyeZTFdg6Ppdn5RNj9jehyolif/sD3rJhnJTwv
lW4fFb1xpePfvlXw9et6f/PjmmTHK4KigPegtg/1A1w+hNYRdI9hcByTE5if
xPoUdqdxOoPrWTzP4a0iCfqpEnCRQDVCLxGpTow6CRqkXCZDkxxNCrQo0aZC
hyodqnWp0aNWn3oDGgxRGKM0pc2cTit6bOizZ8CRIRdG3Bj1YMybW76M+zMR
yGQwUyFMhzETwWwUCzEsxrEUz3I8KwmsJLKayFqSjJjKZjqbmWxl8SiHbUnw
sRgRv3ki8z0tlOMHwWdCsEy63S5m/c1MfLvj69d+5au9J6STx0//OEFeIF46
gMYhNI+gfQy94xiewPQkFqewOY39GZzP4nYOLxV8BOIF/GXEIHVCNYjUIPYy
iZqkapGpRa42hTqU6lKhS5UeNfrUGlBnSL0RDcYoTFCa02ZJpzU9dvQ5MODM
kCvD7ox6MebDLT/GA5gIYjKEqTCmI5iJYjaGhTgW41lKYCmR5URWklhNYi1F
dkxnI4PNLLayeZTLdh7bBTwukPKxUKxdhKAoXil+QHznWbkYxNulbBTxtn73
b95q+fr7SLLtmZNi6Sem8Z9Cqh/i8mG0jqJzHP2TGJ3C7DSWZ7A9i8M5XFRw
P4+3Kr4X8FMj4BKB6gRrEKpJpCaxWiRqk6pNpg65uhTqUapHpT7VBtQYUmtE
nTH1JjSYojBDaUGbFZ229NjT58SAC4PuDHsy6s2YH7cCGA9iIoTJUKbCmY5k
JprZWBbieZjIYiJLSSwns5LMagprqZLlegYbmWxms5XDozxpZmwX8lhEEU9E
yIiiR5ZKriIby3lWIcV2GRslb/S9v3+r41vf5zx+8mPOffnHoSL6ovpBNA6j
eRTt4+iexOA0xmcwP4vVOexUcDyPqyoeF/C5KCH6C0QNgi4TokmYFlHaxOmQ
pEuaLll65OlTqE+pAZWGVBtRY0ytCfWmEmKjGQpzlJa02dBpR48jvc70uzHo
wbAXo76M+XMrkPFgJkKZDGcqkuloZmKZjWchkYdJLCazlMxyCisprKaymiY7
ZrKRzWYOm3ls5UujY7tIVHexyDuB+ETMk1LJsUxyLOepQKyUYrucjdK/0PGt
U+fsKTGid0rD5VXEy0fROo7OSfROYXgGk7NYnMNaBfvzOKnidgHPi/iq4adO
gAaBlwnWIlSbMB2idInTI0mPNH2yDMgzpMiQMiOqjKkxkRDrTKk3o8GcRgsU
liitabOl04FuJ3pd6Xdn0IthH0b9GAvkVjDjoUyEMxnBVBTTMczEMZvAQhIP
k1lMYSmF5VSW01hJYzWdtUy5vHPYyGUzn60CaYCI9rddwuMSCfFJKU/KEIDv
CEFxNlLJ0yqeVbFdwUbZm+8O/S9vdXx99SNPqBOnxKjeJU1otR8Rj6B5DO0T
6J5C/wxG5zBVwfI8Nqo4XMD5Iu5qeF2SEP0FoiZBWoRoE6pLuB7R+sTrk2xA
miFZRuQZUWRMmQlVptSYUmtGnTn1FjRY0mhFkzVKG9rs6XCk24VeN/o9GfRm
2JfRAMaCuBXCeBgTEUxGMRXDdBwzCcwmsZDCwxQWU1lMYymN5XRWMljNZC1L
TslcNvLZLGBLrAXFaqaEbSkHH5dKOVnGk3KeVEg5WSlJVvG0WorHVWyUv/ke
onw+8kYl/+vXtn/xYtp8xGkxsne/0htlSa0T6JxC7wwG5zBWwUwVywvYXsRB
DZdLuKvjrYHfZQJkyWAdSTJMjwgDog2INyTZiHRjso3JN6HYlHIzqs2oMafW
gnpLGqxotEZhQ5MtSjtaHehwptuVXg/6vRj0Ydif0UDGQrgVxngEE1FMRjMV
y3Q8M4nMJrOQykIaD9NYTGcpg+UMVjJZzWItW8bMY6OAzUK2itkSCxtJUjRB
fvm4/KXkk0qeVEme1eKrRhg/rmazkretbt6u+frnUeRzwuNiAXRarH72vqTU
OMJlmVL7FLpn0D+LoQomqphfwOoidmo4XsJVHQ8NfC7jr0mgNkE6hOgSqk+4
AZGGxBgRb0yyCekmZJuSb0axOeXmVFtQa0mdFfXWNNjQaIvCjiY7mu1pdaLD
hW53ej3p92HQj+EARoMZC+VWOOORTEQzGctUPNOJzCQzm8p8GgvpPMxgMYOl
TJYzWcliJZvVXFmzgI1CNovZLGFLzOdHUsqJXvi4QooXkk+qeVKDkHznaa2k
WcNmFasVb+bm371VUzY+/eo1CbEEOi0Wka/0SM3jaJ1E5zR6ZzFQwUgV04tY
qGF9CXt1nDRwu4ynJr5aBMiMwXoSY5gBEUZEGhNjQoIpKaZkmJFjToEFJRZU
WFJtRa01dTbU29JgS6NgtKfZAaUjrc50uNHtQa83/b4M+jMcxGgIY+HcimQ8
mokYJuOYSmA6iZkUZtOYz2Ahg4eZLGaxJCKb5WxWcljNkyULWS+SZvFmKVui
Lz6SgEQ73K7kcaVUzS8Yn9TypE5I1kmStWxWs1r5l0rKXfTMj9unPueMOJU5
8CeG2qfROYu+CoaqGF/ATA1LdWw0cLiMsybuWnhp46dDoC5BeoToE2pIuGwY
ZUqMGQnmpJiTYUGOJQWWlFhRYU2NDbW21AlDOxrtUTjQ5EizE0pnWl3pcKfb
i14f+v0YDGQ4mNEwxiK4FcV4DBNxTCYwlcR0CjNpzGYwn8lCFg9FZLOYzVIO
y7ms5LKaLzGuFbFeIo3izXK2Ktiq5FGlVOFVUoVXIUr58Q+IonnWS4p1bNaw
KnZ4fZ34r9+qKM/0Cy+2T3/JOTFoDr3up3sOg/MYXcBEDXN1rDSwvYyjJi5a
eGjjrYO/7BdsIPmFGRFhQqQp0WbEWpBoQaolmVbkWlNgTYkNFbbUCD876u1p
cKDREYUTTc40u6B0pdWNDk+6ven1oz+AwSCGQxkNZyyKmzGMxzERz2QiU8lM
pzKTzmwm81nMZ7OQzcMcFnNZymU5j5V8VgtkQnGaUiqN4c0Kqe9tVfFIRDXb
1S/5RN4JNAnv3ScNQnCzjtUauT++Lvi3bxV88V6Y2D69k/P7uXT4j51Q54xk
p3cewwsYq2GqjoUGVprYaeGojasOHrr46OGvT5ABIYaEGhMu20WZE2NBrCWJ
VqRak2lDrg2FtpTaUWlHrT11DtQ70uBEozNNLjS7onSjxY1WDzq86Pal15/+
QAZDGA5jNJKxaG7GMh7PRCKTydxNZTqdmUxms5nLZj6HhVwe5rKYx1I+yyIK
WCmU+UpYL5Nm70alVJ68syVu/upRDdtyvMB7XM/jBsmvUfht1bNa+xN+r98r
X7s4fnoXqodQF4n3p3L6FzBSw+QSZhpYamKtjb0OTrq46eGpj68BAYYEG0ly
YSZEmBFpTrSQsyLOmiQb0mzJtCXXjkJ7Sh2odKDWkTonGpxpdEHhSpMbzW4o
3WnxoNWTDh+6/egNpD+YwVCGIxiNYiyWm/GMJzKRxGQKd9OYzmAmi9kc5nKZ
z2Uhj4f5LIooYKmA5UJWimW8MtbKWa9ko0qqyne2xNejWlG/olzffYH2uJHH
ClG7CkmugbU6We71HPvNn5fbfWYPF4+g/mJmCLaz6Kmgr4rBRYwvYaqBuSZW
2tjo4KCLsx7u+ngZ4GdIoBEhJoSZEi6zRVkSY0WsNfG2JNmRZkeWPXkOFDlS
5kiVE3XO1LvQ4EqjGwo3mtxp9kDpSasXbd50+NIdQG8Q/SEMhjMcyWgMY3Hc
TGA8iYkUJtO4m8F0FjM5zOYyl8d8Pgv5vPNQnCL/erGQpSKWi1gpkeRWy1mr
YF2s+qSc25Qm7VYdj+QQflKn2/4BTzS9Jqn9NbHVyFr9n1lZv13v6zP7UDuK
xgmp1b1KZ3gJEw3MNLHQwloHWz0c9XExwMMQbyP8jQkyIdSUMHMiLIi0JFrQ
2RBnS4IdSfakOZDlSJ4TRU6UOVPlQp0r9a40uNHojsKDZk+UXrR40+pDmy8d
/nQH0htMfxiDEQxHMxrLWAI3kxhPZiKVyXTuZjKdzUwus/nMCbd54fa3C4U8
LGKxiKVilktYKZX1KlirYr2ajVo2xECQzERZ8qtH9Qg2KRrZViDc3n3cLNk2
sdYoZ95bz+7ebnfq7AHUjnP5lDwjXoEzUsf0MuZaWOpgo4edAU6GuBrhaYyP
CQGmBJtJcOECzoooa2JsiLUl3p5EB5IdSXci25l8Z4pdKHelyo06NxrcafRA
4UmTF83eKH1o8aXVjzZ/OgLoDqY3lP5wBqMYjmE0nrFEbiYznspEOpOZ3M1m
OpeZfGYLmC1krpD5IhaKeFjMYglLJSyXslwm21WyVs16Det1bNSzKaIBUZmi
ckV3e/cF3HYT283CTinZNbOm4Mc8e/0Kwxt28hWyE2d2cfYQl06gefqPnc5Q
TbIzvoyZFhY6WOlhq4+9Ic5GuBnjZYKvKYFmhJgTZkmEFZHWRNsSa0ecPQkO
JDqR7Ey6C9ku5LtS7Ea5O9Xu1HvQ4EmjFwpvmnxo9kXpR6u/ZNceQEcQ3SH0
htEfyWA0w3GMJjCWzM1UxtOYyGAyi7s5TOcxU8CDQmaLmCtivpiFEh6WsFjK
YhlLZSxXyHzVrNVIbWy9ng1JbVOeCY1sKXikkGpXqlWBt63kcYtUu9LNIyVr
TT/X8KLofOdE5zuF1tmXgAZqGMqAJlqY62Cpi7U+doY4GONsgrspXmb4mRNo
Qagl4QLQhihbYuyIdSDeUQJMcibFlQw3ctwocKfYg3IPqj2p96LBm0YfFL40
+6H0p8Wf1gDaAmkPoiOY7lB6I+iPYjCW4XhGkxhL4WYa4xlMZDGZw908pguY
KeJBEbPFzJUwX8JCKQtlPCxjsZylcpYrJcOVGmmCik623sBGIxsKNhWSn6jS
RyKaecG33cJ2K9tt4ty5VTJsYb2ZZcWLFcq7P3xK8Y3V9Iv31UXfUzmGxhm0
Vf4IZ6SBsSam2ljoYqWPjSH2xjia4mKGhzneFvhbEmRFmDURMly0vQQX50iC
M4kuJLuS6kaGOzkeFHhS4kWFFzXeNPjQ6IvCjyY/mv1RBtASSGsQbcG0h9AZ
Snc4vZH0xzAYx3Aio8mMpXIzg/FMJrKZzOVuPtOFzBTzoITZEuZKmStjvoyF
ch6Ws1jBUiXLVbJdLav1rEmZty6Nho0mNuUQHVB0ul+KTBNQP9KJfGyXqrqN
R22st7DcJJ8VS1yvv3/36z+veUJ0QtUTXD6LzvkfeqBMaaKNmS6W+lgbYmuE
gwlOZria42mBjyUBVgRbE25DpB1R9sQ4EOtEvEyZ5EaKO6keZHiS40WBNyXe
VPhQ40uDH41+KPxpCqA5EGUQrcG0hdAeSkcYneF0R9AbTX8sgwkMJzGaylg6
NzMZz2Yil8l87hYyXcxMCQ9KeVDGbBlz5cyXs1DBw0oWK1mqYqla1hRr4QZp
NIjqXJcMN4ThX28q2ZJDSD5qleSEn3B8Z7tDsmznUTvrrawo5Svar/+7q3/B
8rhoixdPoamCrkjLVyBNdTHXx8oAGyPsTHA0w9kCN0u8rPC1JtCGEFsiZMho
RwkyzpkEVxLdSBaQnqR5kelNrg+FPpT6UulHrT8N/jQGoAikOQhlMC0htIbS
FkZ7OB0RdEbQHUVvDP3xDCYynMJoGmMZ3MxiPIeJPCYLuFvEdAn3y5gp40E5
s+XMVTBfyUIlD6t4WM1iNUs1sqVYFzeyqmCtWeSmmBy/2lCy2SLF1g+O7wg5
cZ7cwXbny3jUwXobKy28lHy9E/6UpGiOl86idR69i39si6Y6mOlhYYC1EbYm
OJjhZI6LJe7WeNvgZ0uQHaH2RDoQ5UiME7EuxMuMSR6keJLqRboPmb7k+lLo
R6k/lQHUBtAYiCKIpmCaQ1CG0hJGazht4bQLxki6ouiOpjeO/gQGkxlOZTSD
sSxu5jCex0QBk0XcLWG6jPvlzJTzoILZSuYqma9ivpqFah7WsFjLUh3L9TKm
glUxd5VCUpofGy1stLLZKlW5KOp3BaOAe9QpxS+2u6Ss7GS9nZVW6YdfnzE/
YXjynGiSKmhfQE+k4iuA5gZYGmFjgp0pjuY4W+JqjYcNPrb42xFsT5gMGO0s
Aca5kuBOogfJAtCbNB8yfMnyI8+fogDKAqkKpDaIxmAUITSF0hyGMpwWARhB
eyQdUXRG0xVDdyy98fQnMZjCcDqjmYxlczOX8XwmCpks5m4p0+Xcr2CmkgeV
zFYxW81cNfM1LNTysJbFOpbqWWqQDZtYFXO3hbVWqVzf2RByv9xsY7OdLRGy
n8jILvHVLWq7W3LuZKXtrXP6JwxVz4nWqIqOGvqill8BtDDEyhhbU+zNcbLE
xRo3Wzzt8LEnwIFgR8KdiHImRgC6ES8DJnmR4k2qD+l+ZPqTFUBeIEVBlAVR
FUxdCI2hKMJoDpcBI2iNpC2K9mg6YuiMpSuO7nh6E+lPZjCN4QxGsxjL5WY+
44VMFDNZyt1ypiu5X8lMFTPVPKhmtoa5WuZrWajjYR2L9Sw2sKSQDZWstrDa
xlqbVKcixTbaJcDNDglwq5OtLoTeLx/1SHpdrHT8XL3jKqIZXkD3EgaXX84T
0QYFnaUx1qbYmeNgibMVrja42+HlgK8jgU6EOBPhQrQrsW7EuZPgSaIXyYLO
lzQ/MvzJDCQ7iPxgikIoC6EqlLowia4pnOYIlJG0RNEaTVsM7bF0xtEVT3cC
PYn0JtGfymA6w1mM5jCWx80CxouYKGGyjLsVTFcxXc39amZqeFDLbC1zdczX
sVDPQgMPG1hsZKlJ1muRKnJVTI41qe+td7AhopPNzpd0W91s9Qi9K5JeNyud
st7rn6aU3d64mv1iMp87isoZtNTQ1cBQ6+UQeaFnZYqNOfYWOFrhYoObHR4O
eDvh50yQC6GuRLoR406cB/GyXpIPKb6k+pEeIOllBZETQn4oxaGUh1EdTn0E
igiaImmOQhlNSwxtsbTH0RFPZwJdCXQn0pNEbwr9aQxmMpzNaC5jBdwsYryE
iTImK7hbxb1qpmu4X8tMLQ/qmK1jrp65BuYbWGjkoYLFJpaaJcBlMWXbWe2Q
PpPZIXqhKNi/Elm2KccLvK0rbPVKLbFXMuxhpevnGh4/dxxV0QPV0dPESFsu
XkMsjLAywdoMWwscrHCywdUOd3s8HfFxxt+FYFfC3IhyJ9aDOC8SvEn0IVkA
+pMWQEYgmcFkh5AbSn4YxeGUR1AdSX0kiiiaolHG0BJLaxxt8bQn0JFAZyJd
SXQncyWF3lT6MxjMYjiH0XzGCrlZzHgpE+VMVnK3mnu1TNdyv46ZOh7U86CB
2QbmGplXsKDgYROLzSwqZcM2qSrfWRV2v1jrYl0O0Q1Fv3t3s5vNHwh/sdUn
OmGfpNjLSjdLnW9+rvcnFE+qnOSiKtoa6GthrCv3PyMsTbAyw8YCOyscbXC2
xc0eD0e8nPF1JcCNEHfCPYj2lAjjBaEvSX6k+JMaSHqQRJgVQk4YueEURFAS
SUUUNVE0RNMUQ3Msyjha4mlNoC2B9kQ6kuhKpjuFnlSupNGbTn8mgzkM5zFa
wFgxN0sZL2eikslq7tZyr47pOu7Xc7+BmQYeNDKrYE7BfBMLzTwUoWSxRVbs
kKpTJNeqmBdr0qxY70akmwhxDijV72YvQnDrqmCVbn6x2cfKFZa6f5biaZXT
XLqIjiYGOpjo/5HQ2gJbS+ytcbLFxR53Rzyd8XbFz41AD0I8ifAi2ps4HxJk
wuQAiTAtiIwQMkPJlgnzIimIoiSaimhqYmiIpSmO5niU8bQIwkTak+hIpjOF
rlS60+hJ50oGvZn0ZzOYy3A+o0WMlXCzjPEKJqqYrOFuHffqudfAdAP3G5lR
8EDBbBNzzcyLULKg5GELi22yYifLXVJyrYroYa1H1LSw++XGFQSfFC8Ef7nV
LwleZbWXpZ6fJXhC5Szql9DVwlAXU5GEciO0NsfGEjtrHGxxtsfVEQ8nvFzw
ccPfgyBPQr2I9CbGh3hfEv1JCiAlkNRg0mW+rHByIsiNJD+KwhhKY6iMpSaO
hniaBF8CLYm0JtGWTHsKHal0ptGVTncGVzIlvr4s+nMYzGe4kNFixsq4WcF4
FRM1TNZxt4GpBu41Mq3gvoKZJh40MytCyZyS+RYWWnnYymK7JLjUxbIYFFLW
rQq5v167wlov672Iot3ok/yE2ma/EByQBPtZ7WPpys+r5PMqXL6Mng5G+piJ
BPyBz9Yae1uc7HFxwM0JTxe83fD1IMCLYG/CfIjyJdaPBJkvOUjiSwshI4zM
cLIFXxR50RTEUBhLaRyV8dQm0JhAcyLKJFqSaU2hLZX2NDrS6cqgO5OeTK5k
0ZtNXw79eQwWMFzEaClj5dys5HY1E7VM1nO3kSkF9xRMN3G/mRkRSh4omW1h
rpX5VhbaeNjOYocs2M3yFak0V3qFoZgaf7XWx7qIq2xcfam3OSBV9TXRE69J
itdYvcpS759TfP3sT/687LHzqmhpoa+HsSFmxnIblAntbHCww9kBVyfcXfBy
w8cDP08CvQnxJdyPaH/iAkgMJCmIlGBSQ0mXCbMiyYkiN5r8WArjKIqnNIHK
RGoTaUyiORllCi2ptKbRnk5HBp0ZdGXSnUVPNldy6M2lL4/+fAYLGS5htIyx
Sm5Wc7uWiXomG7mrYKqJe81Mi1ByX8lMCw9amW1lro35dhZEdPCwU1aUMnBZ
mrkrfVKOCSDRF6XSXe9nQw6BKOTEkBmUWuIg4vfVAZauvvH5hb/684onVEUz
1MFAHxMjzE3lNmglEdrb4eiAixNuLni44u2Oryf+3gT5EupHhD8xAcTLhMkh
EmFaGBkRZEaSLQhjyIulII7CBIoTKUuiKpm6ZBQpKFNpSaM1nbYM2jPoyKQz
i65sunPoyaU3j758rhbQX8hgMcOljFYwVsXNGm7XMdHApIK7zUyJUHJPyXQL
91uZaeVBG7PtzInoYL6DhU4edsuKor31sSzZrUgzY7WfNTlEX5Tqd2OAjWsS
HL/aHJIev8ZS/1vXNz9heFxVtEM9DA0xNcFCVPIPgA4OODnh6oy7K57u+Hji
502AL8F+hAUQGUhsEAnBJIWQEkpqOOkyYFY0OTHkxpIfLwEWJVKSTFkKVSnU
paJIQ5lOSwatGbRl0p5FRzZdOXTn0pPHlXx6C+gr5GoR/UUMljBczmglYzXc
rON2AxMKJpu5o+SukqkW7rUy3cr9NmbaeSCig9kO5jqZ72Khi4c9kuFin5RT
7ywLtHdX+qUUE7E2IASviVXOoKQ4xOY3Uohc/EZaBQ2yNPAzFF/MlRQbLmqg
Z4CREaamWFq87IcO9jg64uyMmyse7nh54uuFvw+BfoQEEBZEVDCxISSGkhwm
KaZFkBFFZjTZQjGOvHgKEihMojiZ0hTKU6lOoz6dpgyUGbRk0ppFezYdOXTm
0pVHdz49BVwppLeIPqFYzEAJg2UMVzBazVgtN+u53chEE5NK7rRwt5WpVu61
Md3OfREdzHTyoJPZLua6mO9moYeHV2TIq1JyCUkp81YGWBFt75pU1YNSVQ8i
GKX4ho1h6UR6WJIcYunaz5U8df4Cl0RnNMTYBDNzrEQ+/sDo5IyLK+7ueHrg
7YWfDwF+BAUQGkR4MNEhxIWSFEZKBGmRpMuMWbHkxJEbT36ixFiUTEkqpWmU
p1OdQX0mTZm0ZNGaTVsO7bl05NGZT1cB3YX0vGAs5moJ/aUMlDFYznAVozWM
1XOzkdtNTCiZbOVOK3fbmGrnnogOpju538lMFw+6mO1mrod5EVdY6JUl+6UE
EzLLkt+K5Lcqmt8QwmtdxDfS+ntYJOaIGC4jkuMwy0M/1/GiqhrqojcaY2yG
uSXWL4paRnR2wdUNDw+8vPDxwd+PwACCAwkLJiKUmDDiw0mOIDWStGgyYsiM
JVsgJpCXSEEShSkUy4hlGVRkUpNFfRZN2bTk0JpLWx7t+XQU0FUoIxZxpZje
EvpKuVpGfzkDFQxWMlzNaB1jDdxUcLuZiRYm27jTzl0RHUx1cq+T6S7udzHT
zYMeZkVcYa6X+V4W+mTHayyKWh1keVDyWRmSDFe/YU3EMOsiRhCGv9z4Virt
b1kbYfkbHg7+GcXXPxP/csKoc1l0RxNMzLGwwsZW6ouOTji54OKGmweeXnj7
4OtLgD9BgYQEEx5KZDixESREkhIlEaYLwjiy4slJIDeR/GSJsCiVknRKMyjP
pCKbmmwacmjOpSWP1nzaC+gopLOQriK6i+kp4UopvWX0ldNfwUAl16oYrGa4
ltF6xhTcbOZ2CxNtTLYz2cGdTu52MtXFvS6mu7nfw4yIKzzoZbaXuT7m+1jo
lxSFx6IYHu8siZtfC58VEcOsDkuGQkwYrn/L+qh0wXZUysVvWR7m4dCbq52f
UDylehktAwzNMLXE0gZbexxkQmc3XD1w98LLGx9f/PwJDCQ4mNBQIsKIiiAu
ksQoUqNJiyUjjsx4shPJTSIvmYIUCtMolgnLsiTCyhxqcmnIozmf1gLaCmgv
pKOIzmK6SugupaeM3nL6KrhaSX8VA1Vcq2awhuE6RhsZa+KmktutTLTz+04m
O7nTxd0uprq518N0D/evcL+XmV4e9DHbx9xV5vtZGGDhmpyO37AkYljqkeLm
1ysjrMohyF4Qrl9n/Ts2vhPpuHFdOkccZXmEh6LeX1/z/OrPWx6/oIWOMUYW
mFljZYudSEdR0a64uOPmiYc33r74+uMfSFAQISGEhREZQXQU8dEkxUiQ6QIy
gaxEcpLITSE/VYIsSqckk9IsygVkLlV51ObTWICykNZC2opoL6ajhM5Susvo
KedKBb2V9FVxtYr+agZquFbLUB3DDYwq+E7JzVZutzPRye+7mOziTjd3e5jq
4d4V7vUy3cv9Pmb6eHCV2X7m+pkfYP4aC0OS5TuL0vxYGpF8RIgu+a3UJUUN
j0rxAlIAjokuKX/zHcujPBz+WZInL+igZ4qxJeY2WNtjJ1JSZnT1xN0bT198
/PELICCI4BBCwwiPICqKmGjiY0mOIy2eDJkxO1lizEulIJ3CDIplxrIcKnKp
zKO6gNpCGotQFtFaTHsJHaV0ltFVTncFPZVcqaK3ir5qrtYwUMu1OgbrGWpg
uJFvm/muhZtt3O5goovfdzPZw50e7l7hbi9TvdzrY7qP+1eZ6edBP7MDzF5j
7hrzgyx8I5f3CIsjorqF3y+Wv2VlVApxZiPl35rMKBAF4A2xIhqTEnNMumP5
Og+//TmWpy/qoW+OiTUWdtg4Yv+itj1x88bDBy8/fAPwDyIwhJAwwiKIiCQ6
mthYEuJIiSc9gcwkspLJSSE3jXwZsiiLkmxKcygXkPlUFVBTSF0ximJaSmgr
pb2MjnI6K+iqpLuSHgFZTV8NV2vpr2OgnmsNDDYypOCbJr5V8l0bNzu43cVE
D7/vYfIKk73c6eVuH1NXuXeV6X7u9zMzwMw1HlxjdpC5Iea/YWFYtvyWRRGj
LI2KGheCv1q5zsp3rH7Hmgghd4N312/KmkL7O2nXt03tn3A8qibapCWmNlja
Y+uEg0hID9y8cPfB0w/vAPyCCAghKJTQcMIjiYwmJpa4eBITSE0kQ0bMTpUQ
89IpyKQwi2KBmEtZHhX5VBZQXURNMXUlKEppKaOtnPYKOirpFIhV9FRzpYbe
WvrquFpPfwMDjVxTMNQkIQ43820r37Vzs5Pb3UxcYaKX3/cy2cedq9y9ylQ/
9/qZHmD6GvevMTPIgyFmh5j7hvlhpP8bgd88FKV6ncXrLIkQlfudhLgyxqqI
G6yJuCmWlLdERt6UHMekXX+m40F1I4ysMbPDyhFbFxxFVcuIHn54BeAThH8w
gaEEhxMWSUQ0UbHExhGfQFISaclkppCVSk4auRnky4hFOZTkUppHeQGVhVTJ
iLWl1JehKKelgrZKGbGKrmq6a+ip5UodvfX0NXC1kQEF15oYbGKomW+UDLfw
bRvfdXCzm9tX+F0vE338/iqTV7nTz91+pgaYusa9a0wPcn+ImSH5H73z7vwo
C9flZPyOdxZF7/vrJVGuIm6wckPiW70p8a0JvbXbIhtvS8V9i+WbSDu/vaLf
+i9691/Q5bLojraYO2DtjJ0rTh5yOfvh6Y93IL7BBIQSFE5IJOHRRMYQE0dc
AglJJCeTLgtmp0uCeZkUZFOYQ7EQzKesgIpCKoupLpEE68poqKCpktZK2qvo
qKazhq5auuvoqedKA32NXFXQ38RAE9eaGVQy1MI3rQy38W0H33Vxs4fbvfzu
KhNX+X0/k/3cGeDONe5eY2qQe0PywfE3D4Z5MMLsCHPfMn+dhe9kR5FeIkT/
WxJV+ysBtSLH6i0JUTJcGxeZOC453mbllrTrz3Hcc1EfLdEZ7bBwxNoFe3ec
RSb6SohegfgE4xdKYDjBEYRGERFDVByxCcQnkZhMSirpaWSlkyMQs8iXEYvy
KMmntIDyIgmxqoSaMmrLqa+goZKmalqraa+ho5bOOrrr6WngSiO9CvoUXG2i
v5kBJddaGGzlmzaG2xnp4NtOvuvmZi+3r/K7fib6+f0Av7/G5DXuSCfJkt/f
Tn/D/WHujzAzwoNvmR1lbpT575gfY+GGbHmDxZvSWvKm6I+3pDPu26zKIQx/
tfY7cc/67xB3ir3ED72u+Ms/r/j1RUN0RF90wNIZGzccPHERxeyPZyDewfiG
4h9GUAQhUYTFEBlHdAJxiSQkk5RKajoZGWRnkptFXjYFuRTmUSwICykroqKY
ylKqZcK6ShqqaKymuYa2Wjrq6Kynq4HuRnoUXFHQ20RfM1eVDLRwrZXBNoba
+aaD4U5Guvi2m++ucLOP2/38boDfXWPi2gu739z9hqlvuDfMvRGmR7j/LTOj
PBhl9jpz3zE3xrzIwAWBJ5X5osiyWyyJGl6+LdY+Uu6tjrP6O9YmRIpKN78Q
d4pd5t+Siz+h+IWaEbqiKzph6YKtO45euPriEYBXED4h+IUREEFwFKExhMcS
FU9MIvHJJKaSnE5aBpmZ5GSTl0O+TFhUQEkhpUWUl0iEVWXUVFBbSX0VDTUo
ammuo62ejgY6G+lq/P8rO++oqrMs33/6XsBYqauqu2e638zrfq9nzZv3BBXF
nHNWJAgiImLOASNSiCAiIkEkI4iCYs7ZMuecFVRQARG1qnum+89e6+19fvcq
ojWraq39+8G9/Lx3fz9nn33O74J7c/ogZw5x9jDnj3DhKBePcek4l7/nygmu
nuTaKa4bhLfOcOcc9y9aGe+Lx1d5co2n1yi/TvkNKm7w7CbPb/HiFpW3qbpD
tdhdXt6jRmPvlcSdvfaB2ZE/1Fh8pLP6ET+UqgnDH8v48bFQfKwUy5CLFPsv
oNgmYBJhc5i6gBmLmRPJ/KUslkCMIyqe6ARiElmeRHwyCakkppGcTmoma7PJ
yCErj9x88gsoXM+GDRRtpLiIzYJwM1tL2L6FHdvYZRDu3aUID+zh0D6O7Of4
AU4c4ORBTh/izGHOHuHcUc4f48JxLn7PpRNcPskVC+Fpbpzh5lnHnP324RUe
XaX0KmXXeHydJ2I3eHqD8ptU3OLZLZ7f5sUdKsXuUnWX6nu8lLgSEy7Kr1b5
KcxS3pTyVqwMwWYThvYfn0h2fKIcHyM/1+t/AcdWAVMYH87URcxcwtwoFiwj
QkJxBUsTWLaK2NXEJbMylVVprE4nJZM1WaTnkJlHdj556ykoVIgbBWIxmzZR
spktJWzbqhB3bmf3TvbsYp9A3MvBfRzez5GDfH+Qk4c4dZjTRzhzlLPHOHec
899z4QSXThqIp7h6mmtnLHp/unWBOxe5f4WHV3l0jdLrlInd4PENntzk6S3K
b1Fxm2d3eC52lxd3qbxH1X2q7/PyIS8fUfOIV2Kl1JaakCzjjdhj3j5GoP3w
BGHo+uNTWa2fYoDKFfIPfoLjJ+uWtBg5nYnzmbaYWZGEL2VhDBESjCuJXkXM
apYnsyKVhDQS15KUQWoWaTlk5JGVT04B6wpZv4ENRRQVU7yJzSVs2cLWrWzf
xo4d7DIQ9+5h/14O7OPQAQ4f5Oghvj/MySOcOsrpY5w5ztnvOX+CCye5eJJL
p7h82hF9/3T9PDcvcOsity9x5zL3r/LwOo/EblB6g7KbPL7Fk1s8vU35HSrE
7vLsLs/v8eI+lfepekC1ofhSlg5bjZzcXpVRK/bYfD7+mDdPJEfK8cNTGvxY
rgSf8vqx8v4lBJuNmsnkhUxfwuwo5i1j0XKWxLN0FctWE5tMXCrxa1i1ltUZ
JGexJoe1eWSuI7uA3ELyN1JYxEbBt5lNJZRsYcs2tm1XfDt3sns3e/awT/Dt
56DBd+Qwx45w4ignj3HqOGe+5+wJzp3g/Ekr+fMvV85x7TzXL3DjIjcvcesy
ty9z5wr3r/PgBg9v8Ogmpbcou8Xj2zy5w1Oxu5TfpeIez+7z/D4vHlD5kCqx
R1SX8rKMGrHHkh0l67nVSpQ9MQCf8lasXPgpux8q+NGYRKSc7HKR4P7Uzvu/
Yfkfo2czJYIZ3zFnKfNjWBRHpIRiIjFJLE9hxRpWriUxg6QsUrJJyyV9HVkF
5BSSt5GCYjZsosiA3LxVQW7dzvad7NjFLgG5l7372L+fAwc4dIjDhzl6hOPH
OHGcU99z+gRnTlhx968XznDxLJfPceU8Vy9w7SLXL3HjEjcvc+sKt69y9xr3
b/DgJg9v8egWpbcpu8Njsbs8ucvTe5Tfp+I+zx7w/CEvxB5R+YiqUqoFoO2l
rh01QseY5Eidu6/LDdJy/fynQrY+z4TiM/0Uo1wv+vkUTW7898CphEhuXMLM
KOYuY8FyFsfznURkErEpxK0hfi0JGazOJDmbNbmsXUdGAdmF5G5gXRHrN7Fx
M8Vb2LSVkm1s2cE2Q3HnHnbvZc8+9h3gwEEOGopHjnLsGMePc9LB749nT3P+
DBfOcvEcl85z+QJXLnL1Etcucf0yN65w6yq3r3HnOndvcP8WD27x8DaP7lAq
dpeyuzy+x5P7PL1P+QMqHvJM7BHPS3lRSmUZVbKFsVXryvHyCTVP1SQ2BZ1L
bTmvK9T0U6C3z+QW+7lM6ufKsYJXTw3H+jPb5ac5/jlwOqGSG79jVjThsSxY
QUQCURKNySxfw4o0VqazKpOkbFJySVtHegGZ68nZQF4R+ZsoLKHIQNy8XSFu
3cn23ezYwy6BuJ+9B9h/kAOHOXSEw0c5esyR9/73qVOcOc3ZM5w7y/lzXDjP
xQtcusjlS1wRipe5foUbV7l5jVvXuX2DOze5e4v7t3lwh4did3l0j9J7lN3n
8X2ePODpQ8rFHlFRyrNSnpfxoozKx1RJ7qvW6Hv5lJfl1Gj0varQOV5B7TNe
PzMx+Zy3z2n4wwvh++ML3jxDUAv4X8DxT4EzCZMMGcXsZcxbzsJ4lqxiqQRj
KnFpxKeTkEliNsm5pOaxNp+M9WRtILeIdZsoKGHDFoq3sWk7JTvYsottBuLO
fezez54D7DukEA8eseh9efwEJ05x6jSnz3DmLGfPce485y9w4SIXL7K+u9aE
zu5IejvWeJHkiWtCc/ifK5pz/y4P7vHwHo/uU3qfsgc8fsgTsUc8LaW8lIoy
npXx/DEvnlAp9pSqcqrFKnhZQY2YsHmm5Gqf81rshfm7lBe8rRR+lRqFLxC+
Qvsn6NWvGWZy4r+MnM34xcyIZk4s81awKIHI1USnEJtGXDorM1mVzeocUvJY
k0/6ejI3kF1EXjH5m1m/hY3bKN7B5p2Kbututu9lxz52CbqD1orx9ZHjHAtW
OzqKQ4Ec8Neiobu92TlUy6pu6c+mPlpxOL87uV3I7EhaO1K8SPSUTB8v7L6N
a84yDyI9WOihJfhnuDPFnbJHPC7lSSlPyygvo+Ixz57wXOwpL8qpLKeqQsFV
P9OMKKeGNc95JfaC2hdK7nUlbyqVn/1tlczjKqVXqVdIoP4Ser8fOZeJkcyM
YW4c81eyeBXfJbEsleVrWZFBQhaJOSTlkZpP2noyNpC1kZxi1m2mYAuF2yja
waadlOxm6x62GXRWnNkPhXA4mMOj5H319Osjo7Q+5OEgDgSwz589PlpwdPsQ
LU67uT9FfVjfU4t0Z3cmvQNr2pLUmoSWuErg0XB5c5Z6sMS0L5jjznR3Jrkz
zh2Xsc1kNoY2o+Ipz8p5Xs6LCiorsFXp2lAtMMRe6O5GTg1fVVJr7HUVb8Sq
Tfi9xP62WlaUaiVYpYAV9y8g+LtR85gUxaxY5q5gQQIRq4lKIUaCL4P4LFbl
sDqP5HzWFLC2kMyNZBeTu5n8LazfyobtFO9k82627LG4uR4I48BYDozhwGgO
CDj7wSChdyiIQ6M4OJL9AezxY5cP24dpKduSgRT3Y0Nv8nuQ25XMTqS1J6UN
ia2JF3pxSi+2OVEeRHgw34PZ7kxzZ6I7Ye64CjgahDRjVDMCm+HXjOHNqHxO
lRKrfqF5r5IaY5L3qjTvVfPa2JuXCDjx11W+2H54qeyqFa0A/yXsvh29kCnR
zI4jfCULE1mSzNI1xEjoZbIyh8Q8ktaRUkBaIekbySomZzN5JRRspXA7G3da
sWbbO0F07B1nioGNYV+I1kPcF6TVNrHvl9NXB4KQr3tHaLXSHcO15G3JYDYN
oKgf63trmfTsrloQP7U9SW1IaKUtPXCVoKNBTHPt8rHIg3kezHJnqjsT3K2Q
w80iF+AkN6QZtkHyvEu1YKhSq6kWbnLUCh/X1y95U6P29pXpgOH2tkap1VBb
ZWL0F1D7KmQx02KYHc+8BBatJjKF6DRiJdyySchl9TqSC0gtZO1GMorI3kRu
ibX7te8ah233ePF9dxi7Q00NumD2jGLPSGx7ArHtDRRaewVVILtHaHnXbd5s
GcqmQRQNYENf8nuR253MLqR11M4PiV7Ee6KgXGOV1rLm79PcTJPmxiutMQ5a
QU5a3oaWi6H1spqal2qvJJJqhYnb6xpev+KNWK2ZobXC6pV+7vASCchP7VHs
P83q89AlzIhjzkrmJ7I4me/WEJ3O8ixW5rJqHUkFpBSyZgPpRY68tSWMrWFs
Hyuvt2Ms9h1homvnOK3ztXMMO0dr8UMtHymgbLsChKYe8uCLnf5aEXeLN5uH
UDyIDf1Z34d1vbQOf3oXUjuS1I4EL+I8iVFey5RXdHNnUjPLwmST1By8Rjt5
+Tp5NVBe9lc1vHpFrQCxva6VFxJIb16r6V5EnxBewqoGAfvTrMwX60mrommT
sO+YGc/cVSxIIiKVqDSWZRAnAZVHYj7J6x153TWrhI3jtNbUprGUhIoXW0Ox
bQvFvk2QuW0PZXsI24PZHsT2QK1Tat8xQmJq5wh2Bqht92OrD5uHUTxEC3Kv
70d+H3J7ktmNtM7adyOxLfGtiW0pLxatjJY2d6YuD01dk0zqwiaMXELecxrh
5DS4GY0Np9rXvDZcZJK9sZx/43j8Vk9C8OXLn0nIVMdtFLSQ8dHMWkl4IguT
WbKGqHRisliR62DTcE2RljQrCGX9WArHsnEsRaFsGoOtJESOMZKLt5i6cWry
zWi2jmLrSC1KatvqLwT9sQkxPt/qR8lwNg1j42AKB5Dfj7zeZPcgvau27khq
T0Jb4lprDx+3pcpIUtRiK0V5aIqS9D7W3Zpyhs9IJ59hhk9Tw+f1W94Yw6an
BsrnDZa9fUNtLS9rPu4Y9RNsXIMWM1Ey0irmJbEo1XGv3TSxgCTZbAWTM5rc
ENaFkG/wFI5hQwhFIRSPxrZJjxDxYHMIm8eg52CtlFkSSInAsJf4YdviB19u
8UcolfiyabiW6S4cRMEA1vUlpzeZPUjrSkon7d0S34bYVkS3wC1K2USa9B0u
CcnDkZBChY1d2NhHK59gJx8fJ5/PhY/Lmx8cTJyYat9Q84qqlx9n6p9gYh+1
hEmmS4L1m7kvI9OJzmJ5LivzSR1JRhCZo7Qyo8Unz+ITwvrRbAhm4yjsRcHY
ikaLj8WGVPEoikdSHECxxMomX2yb9RAyn8s3Rd5sGKpV3df1J7cvWb1I767d
T5I6ktCOOC9tnCQ83CRUaGAlnbl1ks4YdytUcLV4+Dt58KXJ0q9/5I0xXUWU
jb32LTWvqar5OTw0E5sZ8uu5SSxIJWIt32WyLIe4dSSMIDmAtEDSP0SSO1pL
VuYHUzAKW2EQ9g3yVcDgtjFYa6luDGTjCDb6sdFHSPlIjin2odjXmA8bvLWY
e/5AcvuT3YfMnqR1J6ULiR21w0+sF9GeREp4uAkK3KwEI0l4ujPBKAtbsCoP
dMIY2oyvhIXt9V+E4Ju/mHxrkNT+QM0bqmp/DolvnCT0z8hCljItgfAUFqYR
kUFUNjF5LPcl3p/VI0gNYI2pgPoejATKKK2Guk53NgXmFMR6Ux0Vm55c1o+k
MIBCfwolNgqHCzU5hBBNC4eRP1gr/2f3I7MP6T1J7UZSZxI6ENeWmNZEtaRB
hNJ4l0qmOVNJAyXham0T/c1mR2DwtaHxV/mJovgLtT9S85aq1x9nDdtHHLRW
leYIs8v5NjSGGYnMS2XRWpZksjSHpd5aiTjOl1V+JJtSumtMkKwd6cCRFUTO
SK2suy5AXnidrMANhUq+WJCxQPJHUOBHgQ+2Am/s673FrfXDtTS7WMFQLfef
M4CsfqT3Jq0HyV1J7ER8B2LbEt2aSFl/GixWGu+Sh7X3C/2Qht87Gt8YGv9p
pb7av1LzA1VvfpLE+2c++0edzmG/CVvOrCTmp7Eog8hslgwhahjR3iz3YaUv
q/1I8idZYqMOj4xAMgPIDiDH1Gq25cpqIlxwywskbyR5AeT5k+fLOomEdcNk
nuRLJHg7TNCsG0rOILIGkNGXtF6k9tAeQgmdiGtPTBuiWhEhu+EGizRvOG5g
PTRpjDdJQ1E0GKXzpO4++FvD4r8snTV/oeqHn46J9880dpAwtQW+Gb+C2aks
SGdx1vsy1VGmvne8jxaoTnTySHHyWBtA+ggyZRXN8pdXzvYne4QaNqGDW45B
lONHjg853uQMxZ47FJc8YdI0dwjZg8joz9o+rOlFcncSuxDfUTuCRXsR6cmi
5kY+btZubbqH4xY0xN3S71pvc8tvrLz5N80TNX+l+sefQcBZH8DkkW8nrGRu
GgsymGvqnC8cRIRAMEXO47xZOZwEJ4ck5yRJ9dei3el+ZPiK6gxZG+wZ/kpE
DFumoHCR77J8yRpO1jDhNETYDJEknz1UeVgmT2QO1M4pa/qQ0pPV3bWvVFxH
YtoR5UWEJwuaYxMMbpIzcdVtmYcjT4zWnZnQcAtyRMS7vetvrT2HoVH9l58T
DXZHhjBV7X4THMMkyRDpTOutJfPDrcrvg1gymKghxA5jhYRFHSgaGX5awzzV
V6vAr5U1Yq0gabjWT+moCSZf0n20FUHGUGE1WPjoMcRQoak8SB9AWj9SepPU
k1XdiO9MbAdtExfZmkUtdcVoME8jIty577LSwyh3Ghr9I+ro/53RX/NfOPJf
/ZXiE/rHObov/Hb0cqYkEdqVab2Y2Yc5Rv6CASweRKTprBBr2gUogeEOAjo3
fLUCfspwUk0PAexrZBVosMbgUPMhzZu0YawVsfa1gyQG0geRPthhgkMepg0g
tS9JvUnsQUJX7TC2rANRbYlozYKWNAzX8Z9bZ2eluwidCC4jP9A/+J3+v1Nt
EPyEfn3C+lwgZAXTUgjpwtSejp4Sc/syrz8LBxAxiKWW7CEsr6M8YTirhrN6
OEmS6m3JcmqS4q0AHOZDqo/CSB1G6hDtapI6UKkMxCVN1DcRBKn9Se7L6l4k
dCe+K7GdtGleZBsWtWK+5MCGc1WvNfknOyc/jepotfaP/2S0Vv+NF/9ptNb/
zcTHY200/yZ0JSPbM7qzo+PIDIl0I3t+fxabdiNLBxE9mBgz4O+Ur/QmYRiJ
Q1kt+Wy1zGmRb0uSAXeVb5KHkjyY5IEkD5A3TJHTFykDVbhlIj65P6v7aAut
+O7EdWFZR6LaEeHFAk/CVfOcD+Z4mDXH3USzPdCh26ee7r9T+ekx/tUHuwC9
whrrsFUEtiO4IxO7McVIn9mbOaaLyML+jk4rUYNU/bI66lcMI34oCRK9tlVD
sK+SOZwomdw10Rv5mjhEW9esFsG21f2Fhx4DsCuGxkn9WNWHlT2J60ZsF20X
GNmORV7M82ROcyPWReYzLlM9dEZLWgt2p5Gqtb/fFf/eaK38G5aYj8bY0lr/
034zn78Zl0RAW0Z1YLzpwSOSp/dklpE8vy8R/VlSR3X0O9VDiJP8FC/HSj1E
eIOVQ7WlisMGkzCQVf3lXVf1E+8TTcsny5QBjeWZlb21YdrybizrTFQHItqy
oLV2KBW9jWaq5ikejnksWayBaLYFvNc91KnbpfLvjp4o4z6ueGEpd/bIthT7
eDKiDUHttS3ThK5M7sbUHswwosP7sKgvi/u91x3lDHTRHTsIW5xO07hBrDCG
bcVgUb5iCPGWDSJ+gPa3iu8rl63siz2hn0SEEGiU0Feboi3vQUxXlnbWzpCL
2jKvNXNkb9d4hsb1ZA/HLA5y180cDZ1qHXu6P4jaT9bq+Uhv/f8lYiqIfuvd
Ej8vDe7QTozrzEQjfVoPZvZkTm/m92FhXfUy5Jb6gSwbSIzGbuwAOQZiXy4c
lotuF4ER15+4vsT1wb6ij9xyrOir0i0T+fF9iOtFTHeiuxLViYj2LGijnVtn
taDxdB3hSc5ZHChRbfT6faC3/l+T1K8cYelt4BhfS+ewFvi21qAeY9qRje/M
pK5M6cb0HszqSXgv5pnWSQv7vlcbadQu7a+9uLAvkxhdJvMzRsbaJWaQio/t
R2wfUd9blOvRR8T30U+zexLdnaguRHZkUTtt3zrHkxktaDTNMWcnOuesXdQ1
GPFe4ZBfpPCTNU6/Gdocn1YazKPbq9gw03tNxE7t5mikNVfE9mJ+Hb0R/Uxg
S1RG9cW2tB92UW2P1oQcLfL7sqy3EuglwntjF700XNaTpd2I7ExERxa0I9yL
WZ5Mkx2oyLPLFMX+bqtBY6dC7/cK6//Vbv3/a2wprF8J0uSwb4Z4MNxTWw+O
akdIe0I7Ms5qMNeV6d2Y1Z3ZRmf4hzq1K5bMvUgZse/k63eqVlNRVD+i+hDV
S75d2lPGZ2kvop2mmmm4tAffdSWiM4s6aLPaOa2127BobDxZdVofTQTpvkJ0
uvqrVt8PtNafear1V/JQNVo6m/yjTsf0bwe7490C/9amtaKROLYj4zsxsTNT
Tbu4md0dKufWUakTtTcR4rAtQqIxQiKx0ZI+LOnrtH7aVy6yN5E9iewhV33X
Q46eAqCnjHlP/YyuO0u6srgTCzoQ3la7806TPNRkkqoMM0lopI5mHYWDHfm2
fny6faSw/upj7qC+lVj1b0WAF0FG6RhJv0bp5M5MM90CLbGzuzPnnVgZz14s
7Kn9A7Et6iVHb70R7s3iPsb66lkwRKjGiO4yoktMD0rL7Cq9oUiXJxd3YWEn
5rXXJsQzWjGlBU0mqlZrbgbqLkK0uvg59A57r7f+zHP9SO/n/6jTK/driVhf
T5VqdQ0dLem2PeNkO9GJKTKoXd6rdUSvUTtPFcwXnxfICIlo3BaK8t5O66nN
Ne2LumFf3B0XVdowohsLuzC/I3PbMcuLaa2Y1IIJEqn6KyG7NR0DdAyNJp8P
NNWfay4fafryU1npG4nW4bKIyPopAWvkhbRjbHvtgDmxI5PfKeyqCmc6Fc7t
Tng3bOGiQGTa5kkcztcpKHLnd2NBV1GuJ5cFoshpLqJVbuk6E95BmwvP8GKK
p7b/bqy/wnF5Nw/95e5G9Nl832sc9LM1fvUpjV9ry1+jMaA1QV4Et2GM6Xc6
voNqnNTpvUwdRUtmN+aIAPucbnrqroLFsM3toXckEso9tQ9meFfCu8iz87rI
0VXky6G63cI7M6cDs9oyrbX2Ah/vQRP9pYKLNQn9zG18I6fCoe8V1q9gav9I
obOLaUNnLvU24vw9CTTiRrdhbDvC2qu+CR/qc0RpF21qOqsL9lkqUITONh0s
sevJVQTP6aINYMXmdpZn58qV4V2MRtzmdmJWe+0OPaU1E1sSJrr0FwF2a7VX
Qe9UDX+/n/vU/cmHqr75RAbiK6tBtW9LRngysjWjvBjThtC2DoHj6wqU0eus
/VqxTZeT24zOqtNhMqAyLjN1JFV5Z2Z1kuvkZJ/dGZc5er0ond2RGe2Z1oZJ
rbSDe1PzIX6wmXC+jhTSwEe/Gf5uxPR+5FOfMzi1YT6E1dEy6+NXw4wev5YE
GD2jvQhp816SFZCWJB2wjtqMF9tUcdY+zTSjNfpkFHGdboZSrTPT5Sr7DDm5
zOikzXstc1GRrjM7Mr0dU9poK/MwudtqqjfQdpllI9x1w03jeor0LtrMIdd3
iv5h3X9Yen77iczJF94e+MhSYHSNakVwHWljTYfld9ImdRAFkztgn9wR2xQZ
AQlL2VPJXXgnpnZQs03ToyN2kWVTVW6iarr8qB2TvBjvSWhzmuptsX2kyRUq
wEVODYarkiFGxiDHp2O//m+U/M4xMibSPhMFvs21KXigJ0GtPhChg+MUgW1C
e2wT9RAhdo09Y9gnKW0RNbm9w6bo1VM6iDi5soGIEk3y7eS2TGhNWEtCZKlq
Gqw6dOK463ShsdFgbT2cGszM+KBjpuX/P38iU/CZDONwD/xESgsCTItzVdPa
oWaMUw22cW1179OO8cawyWTCbo3RBB2jCSpKY7GdmuhtJxrb4yLKcBNZ8nVi
G8a3JrQlwR401Y2iXaaKj6XETU6u3h+OiH5m+20dr9+Pxe8/qUUSv4/R4m+0
BNaRM9p0L1c5bcS3sW101ZcxMsOETU9uVgZU62DObUWjHqJjghwqylUGcpLo
b0NYK0Jkdnym20D7CCNBnW9iFAx+p0A/gf+tI24sz//geGR2/E29jce+dQbg
ndOOcPLCPsYLm3hul5GwhaoXstjK7BcRYmEqRXTYHf7iKg6Lv2FehMqLqI+6
ibNL4HtbPjaQk8uwD/38tZz++YM89C+fItxouLvDX/93/nqqvxL+2IJbYRPO
dnHbLtPAFiLeuIyROzAvh9kFvouydxOvwwz+UJEocpvzmW6/7H7vvGxSz8Ov
HB6+J/mvjkcmozQQzyyM/nVCWRKXJzZxzi4hYAsWD2Qlt4uPuFhsLXNRwhoY
9jES+KJJZtpnI9QfmWbDrE9XGsrJLpNFSWkmMH+7Yvz44yf2GLj5fOhPYAts
MrQydw0v49tI4RUkfskaLI6aHGI4iq/24NbGT1uI/mx0K4IkVapX/uqVzzuv
bHJqJF596Zgprs6Vgz99Ku+6fuBVc/n34ppthPoVYHKxGLYAccI1sJVuD8Rb
y2Fs4q2LOKk0cbUShHwrutSlz/zUL293XRV0DW889MOZrL/f/9pBzapP/7/q
ZlMXmT6Wa2J2cc/m10JjtoUuEWLYZLeCiyzq4qtldnHVJVD/oFFxtjIm/ss/
+9xXfRn2zhcdtYbiymfig/N3fFbvnz9/gpFdAskuMW6T9cnuK3RkM2FXb1z8
Wjq8EXNxeCA+NlfPxWiqJ32zIdadYJMh1t99fO4YF6tX4L85dOsdhQKzyUJi
lzVeGLTQtd7HmM2nhXl3fWe7ArDLYiOeDdf3kX+letwGW39/85lDk9UF+N/r
aTLvM9R45sEwYxI1etfjbXaC3uatmxu9siy2wNeYrAmfD3O3xnCwdc/QZLD1
91FNHHr+h3m///OPOneydrk3GGIMm5z0LV3kvez6JipSB0WjRU6N5NXcHDt0
9d7EK/+3nvfW57UaRO4M1leVk11e2UVe+Qt9B8erNHW8yr+ZV/l/9V6l/ueB
VsxZL2nZF/I6dgdL1fYf5nWaObTV//d/drybh7nK4xPE6z7+o+NqT3N18zrj
X/eqPzjeuY25quWnPK7z2JmBOpqrPevOpTpXfe14za7mqtafyuh1Hn/heM1e
5mqvej+t/5dsTRxX9zNXt3F4UP8qN4cHg8xV7er8VNdyF8dreJuftpez/scz
P/OIX/1/nna3qw==\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140536221],

Cell["\<\
For larger collections of polygons the effect is easier to perceive:\
\>", "ExampleText",
 CellID->197663817],

Cell["Plot functions automatically generate surface normals: ", "ExampleText",
 CellID->172269037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"NormalsFunction", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->223816965],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1mX1oVnUUxx+dkjJKMaLC8AWtfKFXKP+o+EKl+IJuDE2xhJo4Al2WLTR8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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmAmYl1UVh78PZGRHZoAZHBwGBoaRgZncSNxywSBTYzPESoHBLEkGGSIV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        "]]]}, {}, {}, {}}, 
    Line3DBox[{297, 1, 291, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151, 
     166, 181, 196, 261, 301, 211, 295, 282, 212, 213, 214, 215, 216, 217, 
     218, 219, 220, 221, 222, 223, 224, 263, 302, 225, 296, 283, 210, 195, 
     180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 298, 15, 293, 265,
      14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 264, 297}]},
   VertexNormals->CompressedData["
1:eJx1WHtQ1tcR/YCS8ZGo0WhGNDKgdFInpE2iqBnJIVE7iRIwDNowSipmrC8S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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-2, 2}, {-2, 2}, {0., 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6796361,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Without surface normals, you get flat or facetted shading: ", \
"ExampleText",
 CellID->47797131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"NormalsFunction", "\[Rule]", "None"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->413495886],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1mX1oVnUUxx+dkjJKMaLC8AWtfKFXKP+o+EKl+IJuDE2xhJo4Al2WLTR8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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmAmYl1UVh78PZGRHZoAZHBwGBoaRgZncSNxywSBTYzPESoHBLEkGGSIV
kIHIXFBQMzdMSFI0JfcFxUgLIzGVMImIrEhcJnDHBMHzPt/7PX+eh8O999yz
/M797vL7T59JjaOntkqSpFv81zraf4cw7hpSFtI2pF1IT9v2IaUhBzpXrD2+
JbYHEM+2TcghaZL8N9ptIb1COoZ0Cjk8pG9IFTbqOoccFtLHufKQDvocbH7G
PUKKxNHdPIwrQw4Sf5WYwHKoNRCjvz7EqLalpn7aMldrbvB+ybhgGmiMcsdd
XYO+tuQbbD0VIYOMwbg+pLexjhAfOWtca/AdqQ6MXw85NuS4kGPMXauu1thD
rGFAyJdtiXeUMZgbav0DjTVIjCe51nyHYebG72R1YDwhpE7sJ7oW+HxFHeOj
zUmOU/Qj1qnGA+MZIccb70xbYozQH4xfs6XW4dbD3De0JX/72EtvGnuM+cC+
JGRhyLUhXzUn/iP1o9ZRttQ32hb/08x5rOtX6vfYbqyzQr5pH1zniYnYE2yJ
fY6x+G7fDjndusdbG3PnWj/+E/UDyw5znB9yScj3Qr4f8l3140I6RO1vWfe7
4poc0in0b0c7NuQ75iTHBfqdbbyzxXKRdmCZEvIt8f7Alrn3Q94T41RtqfvD
kHdCJoX8z/xNIT8yX457vOvxQ2uijp32Z4TMVIfPxyEtIQ1iHOF6XRZyoRhn
iw/sN4TMD/lxyC7z5+Mm438a0hhyechnIR+ETAuZYwxqWqAtGK8236yQq0Iu
dTzObz7CuSni+Il+1HGFLWvwU1u+4d6QT0Kmh/SMb9Qq5Lro9452T7QfJdme
nS2ufSHzQhaHJGGzO5q5dKP/ebTNITdaJ9iv157af6YOXD8XE1huD7nGPP93
PTgjt1ondd8ScqXj29Thc5PxrnA8S6yN7oUJIa0D26Jof5FkdyL3EvfMr/QH
yz0hN5tnmbj5hr+0paal1s3ccuvBf4V+4L0/yc75HSG/DflNyIMhD6gDw73a
UsevrR+f+9Qxvsuc5Fip353Gu1Msj2gHlofEDd6HbZl7wtrA+Ki21P2kOrCs
MjdYnjVfjnupcZ+xNup4WlvGq9Xh85TxiLVGf3A9HnK3OH6nDox/C1kX8qeQ
P4Q8pu06Y4HreesE+x/FzdxabanvBdsnjbVKjK+Ig5zrrQG8LzrP+CV11P2y
3wyfP6tj/Koxngs5IM2wbkwKfII39XVxgPHv5iDnX8XK3GbxMbdJW2rdoi1Y
/mFL/v8kGdeBK7zmGhFrq/Pg/acttb5hC97ywFkUskHcD7uOrcQLJ8g5EDVU
hG19yMVJxl04J3AIOE0vx/AY3h24CLyqzHGROjhJe/3gCXClQ/TP+Qd8hDef
N/dIc1c5t037zuLDttL6aeElOc8rE3s//bsbt5/zvPM14uO9rNanxjGY4Bi1
4h2oD/kHO0dOuEO9ccF7RFLgZP3FDQ/J+eBh+lRpe7i4iVGn3xDrz/nQEHEd
7Rgewdt7prh494cag7kTxDpUnzp1xycF7nWMOE7UB1wnOSYfPOFU/Xk3hov1
ZO3Afopj6h7m+Cj9hrlGx5mPO4k7drE1DDdHG79NN/Hx7p+eFLjOSP3hI6eJ
b6T15zzsjKTAh0aJY4xjsPMej7NmYvAuv6kNOOFj8KSxYoKrnCXGcY5zbpe/
6+ONS7xzHIMb7gEX6SCfgWPAbeA6DeLm3Tk3KXCv86wDHbwFfjQxKXCqyeIh
B7wEfsL7z3s723y86ReKFU5yflLgTDmHusC5UcafkBQ40xRzX+QY7gRHmiY+
3kv4xnv28YULNYmvX5rxqhZzwytmmBMuMdO44J1lrVPNB254yqXivUSfKdpe
Ju6Zxv3U2vGHd8Hh4Cfwo8vFx3vPu837C4eBY81LClwHTgB/gds0GxfdAmuC
n8y3hgWOc26EP7zmWvOBD76Rcy7aK8V+jXPwloX7fbOFziXyouvEB3fgjHDX
8Xuzwvy88zcaG25wi5jQ3WA+dDdbx036kPs2fch3u2NyLE2ycznfGNeLa4l2
cL0l1gn3gyfBURbpB+eAl8IB5+q/zLg5N1omxrscg493/m5zwBPuEy+8Y7n4
0N1rTSv0uVXdCjHer3/OaR4SE1wj51MPaJdzo5ViwjbnLw86B8ZHjAWORx2D
FS7xmLnhEU+I5SnH4F3lGExPOyb3M47v0e9xca12jtzwiGfFBZdYI641zoHp
OedWartafM87Bz44wO+T7NsvtybyrXUOrPCKF8QH31hnPDjDS9awTrvV6tZb
w4v6gOllfcD4imPywGleSwrca624X9UOrBsc94k91SYt8Cb8Nrou683Hbwd+
Vywy3uvmACMccZN28KrN+m1xnHOmLWLd6jjnRlutZ7Oxcp7EXK/I2zbNOFZV
mo3hXPANdHCQdml2VuEk8Kk3rAuegL7Cddwkbt4q7lnuXd5J3iHeIN6d7eo6
ptndyx0N7yp2zHvF2zBaG/q8L2P15Y3o7LvT4Phd57uk2T2JvjL6JWl293VT
36QN9tznzHOXTzdmy3653hYLb80O8xyUZn3u/q5p9k5MMy7vxAzrQT9BG+7r
RnXva99DPfcJOT9MCr/TPxY/uXaKszTN7p/mJFunj4zToj344a0Vvk9l1j3P
2ndpw5g+dyF3MXcf9173NHtvuOeJ/ZnxwY2eN+gD9XO1566fYy27k8Lv1d3G
Jv9ec5a5t5uNv8f+oDT7Tnus8XPj40+fs5D/Hib2O67hROvYa11j3GNj9Uv9
rYu0TgvxeIeIv8TauTv3aQ+eO7TnfuWccl65Z9jzB7rvdxuHmAd7pjdq20b7
DfpwRvrqWyQm8i1OCr9JuNc4Z5zBVtYBV8v3IBwr/ztSJ/VvqZ+kDfoG9ZyZ
ia5Vx/1sOttnH7IvG43ZRd8WbRrch+jZezvdi+z5HfYnux+IM81cxfZr0+zv
JsXuQc7YdGN2s7/LfpP7i/00x+9Mn71UnWZ8q8Sz0iMt7M9Sv+Mn7q1mv2+p
/X3q5/m9emjPN++ZFr5zT7/jdtece2lAmt3XfNtDvQ/jXzIwzf4+3sV9S438
TuSu7OX9WesZRN9O+22uTW/PbbV7Hpu6NNsf/4p+jf1yz0Ol6zdYPH9xv/Vx
z5VrX+SZr/D+7G/edmKvEn+J68l3pq0WQ6X9EmMPMBexa8TWy7Voa+z+rgN9
1gUOR321+8UcZL+3fWoi/mDPSYX2xdZR5zmpF+fF4qy3vi8AIl/TjQ==
        "]]]}, {}, {}, {}}, 
    Line3DBox[{297, 1, 291, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151, 
     166, 181, 196, 261, 301, 211, 295, 282, 212, 213, 214, 215, 216, 217, 
     218, 219, 220, 221, 222, 223, 224, 263, 302, 225, 296, 283, 210, 195, 
     180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 298, 15, 293, 265,
      14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 264, 297}]}],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-2, 2}, {-2, 2}, {0., 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4491083,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->215],

Cell["A function that visualize the surface normals using lines:", \
"ExampleText",
 CellID->66289245],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"normalsShow", "[", "g_Graphics3D", "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pl", ",", "vl", ",", "n"}], "}"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"pl", ",", "vl"}], "}"}], "=", 
       RowBox[{"First", "@", 
        RowBox[{"Cases", "[", 
         RowBox[{"g", ",", 
          RowBox[{
           RowBox[{"GraphicsComplex", "[", 
            RowBox[{"pl_", ",", "prims_", ",", 
             RowBox[{"VertexNormals", "\[Rule]", "vl_"}], ",", 
             RowBox[{"opts___", "?", "OptionQ"}]}], "]"}], "\[RuleDelayed]", 
           RowBox[{"{", 
            RowBox[{"pl", ",", "vl"}], "}"}]}], ",", "Infinity"}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"n", "=", 
       RowBox[{"Length", "[", "pl", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{"g", ",", 
        RowBox[{"Graphics3D", "[", 
         RowBox[{"GraphicsComplex", "@@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Join", "[", 
             RowBox[{"pl", ",", 
              RowBox[{"pl", "+", 
               RowBox[{"vl", "/", "3"}]}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"Line", "[", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"i", ",", 
                   RowBox[{"i", "+", "n"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "n"}], "}"}]}], "]"}], "]"}]}], "}"}]}], 
           "}"}]}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54083269],

Cell["Visualize the normals for some surfaces: ", "ExampleText",
 CellID->14263224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ")"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}], "//", 
  "normalsShow"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->148805197],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1mX1oVnUUxx+dkjJKMaLC8AWtfKFXKP+o+EKl+IJuDE2xhJo4Al2WLTR8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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmAmYl1UVh78PZGRHZoAZHBwGBoaRgZncSNxywSBTYzPESoHBLEkGGSIV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         "]]]}, {}, {}, {}}, 
     Line3DBox[{297, 1, 291, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151, 
      166, 181, 196, 261, 301, 211, 295, 282, 212, 213, 214, 215, 216, 217, 
      218, 219, 220, 221, 222, 223, 224, 263, 302, 225, 296, 283, 210, 195, 
      180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 298, 15, 293, 
      265, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 264, 297}]},
    VertexNormals->CompressedData["
1:eJx1WHtQ1tcR/YCS8ZGo0WhGNDKgdFInpE2iqBnJIVE7iRIwDNowSipmrC8S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     "]], GraphicsComplex3DBox[CompressedData["
1:eJx1WnucjtUW/kLSxSmcEnVcTqYpHZJCnfB8CTHKDBEhiejiGkOURi5xNMc5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    "], 
    {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt1tO2GAYABMAb27Zt27Zt27Ztswja2LZtO21s252c5ml2v2A3UeMOldsH
DggIyBAoIOCnCMj4K2diEGZmUGZhMGZlcGZjCGZnSOZgKOZkaOZiGOZmWOZh
OOZleOZjBOZnRBZgJBZkZBZiFBZmVBZhNBZldBZjDBZnTJZgLJZkbJZiHJZm
XJZhPJZlfJZjApZnQlZgIlZkYlZiElZmUlZhMlZlclZjClZnStZgKtZkatZi
GtZmWtZhOtZletZjBtZnRjZgJjZkZjZiFjZmVjZhNjZldjZjDjZnTrZgLrZk
brZiHrZmXrZhPrZlfrZjAbZnQXZgIXZkYXZiEXZmUXZhMXZlcXZjCXZnSfZg
KfZkafZiGfZmWfZhOfZlefZjBfZnRQ5gJQ5kZQ5iFQ5mVQ5hNQ5ldQ5jDQ5n
TY5gLY5kbY5iHY5mXY5hPY5lfY5jA45nQ05gI05kY05iE05mU05hM05lc05j
C05nS85gK85ka85iG85mW85hO85le/7GDvydHfkHO/FPduY8duF8duUCduNC
dudf7MG/2ZOL2IuL2ZtL2IdL2ZfL2I/L2Z8rOIArOZCrOIirOZhrOIRrOZTr
OIzrOZwbOIIbOZKbOIqbOZpbOIZbOZbbOI7bOZ47OIE7OZG7OIm7OZl7OIV7
OZX7OI37OZ0HOIMHOZOHOIuHOZtHOIdHOZfH+BuP83ee4B88yT95ivN4mvN5
hgt4lgt5jn/xPP/mBS7iRS7mJS7hZS7lFS7jVS7nNa7gda7kDa7iTa7mP1zD
f7mWt7iOt7med7iBd7mR97iJ97mZD7iFD7mVj7iNj7mdT7iDT7mTz7iLz7mb
L7iHL7mXr7iPr7mfb3iAb3mQ73iI73mYH3iEH3mUn3iMn3mcX3iCX3mS33iK
33maP3iGP8fnLALx3M/K8wzCCwzKiwzGSwzOywzBKwzJqwzFawzN6wzDGwzL
mwzHfxie/zICbzEibzMS7zAy7zIK7zEq7zMaHzA6HzIGHzEmHzMWnzA2nzIO
nzEunzMeXzA+XzIBXzEhXzMR3zAx3zIJ3zEp3zMZPzA5PzIFPzElPzMVvzA1
vzINvzEtvzMdfzD9r+HPwEDMyMDMxCDMzKDMwmDMyuDMxhDMzpDMwVDMydDM
xTDMzbDMw3DMy/DMxwjMz4gswEgsyMgsxCgszKgswmgsyugsxhgszpgswVgs
ydgsxTgszbgsw3gsy/gsxwQsz4SswESsyMSsxCSszKSswmSsyuSsxhSszpSs
wVSsydSsxTSszbSsw3Ssy/SsF/j/31Wf/wGjwBQl
      "]]}]},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-2, 2}, {-2, 2}, {0., 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->427454262,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "\[Phi]", "]"}], 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", "\[Phi]", "]"}], 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Phi]", ",", "0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}], ",", 
    RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "1.3"}]}], "]"}], "//", 
  "normalsShow"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->298175582],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->472376862]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20958322],

Cell["Vary the effective normals used on the surface:", "ExampleText",
 CellID->1517601905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"NormalsFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"RandomReal", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", "3", "}"}]}], "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70093528],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30795972]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8201],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexColors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexColors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalsFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalsFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Polygon",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Polygon"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12140]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->249203446],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->733843],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->615462426],

Cell[TextData[ButtonBox["Polygons",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Polygons"]], "MoreAbout",
 CellID->1401394],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->109379285],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->599134359]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VertexNormals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 6.0080012}", "context" -> "System`", 
    "keywords" -> {
     "color dithering", "continuous shading", "Gouraud shading", 
      "Lambertian diffuse lighting", "light dithering", "polygon normals", 
      "surface lighting", "surface normals", "surface shading"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "VertexNormals is an option for Polygon and GraphicsComplex which \
specifies the normal directions to assign to vertices of 3D polygons.", 
    "synonyms" -> {"vertex normals"}, "title" -> "VertexNormals", "type" -> 
    "Symbol", "uri" -> "ref/VertexNormals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6845, 208, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->225450204]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 220625, 4103}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2048, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2671, 72, 1578, 37, 70, "ObjectNameGrid"],
Cell[4252, 111, 794, 24, 70, "Usage",
 CellID->15585]
}, Open  ]],
Cell[CellGroupData[{
Cell[5083, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5561, 157, 634, 22, 70, "Notes",
 CellID->4502],
Cell[6198, 181, 610, 22, 70, "Notes",
 CellID->440408949]
}, Closed]],
Cell[CellGroupData[{
Cell[6845, 208, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->225450204],
Cell[CellGroupData[{
Cell[7230, 222, 148, 5, 70, "ExampleSection",
 CellID->407455713],
Cell[7381, 229, 114, 3, 70, "ExampleText",
 CellID->909021973],
Cell[7498, 234, 420, 14, 70, "Input",
 CellID->176938153],
Cell[CellGroupData[{
Cell[7943, 252, 201, 7, 28, "Input",
 CellID->98566966],
Cell[8147, 261, 232, 8, 36, "Output",
 CellID->670988590]
}, Open  ]],
Cell[8394, 272, 258, 9, 70, "ExampleText",
 CellID->794880732],
Cell[CellGroupData[{
Cell[8677, 285, 403, 13, 70, "Input",
 CellID->157239568],
Cell[9083, 300, 2188, 41, 129, 170, 3, "CachedBoxData", "BoxData", "Output",
 CellID->786100334]
}, Open  ]],
Cell[11286, 344, 88, 1, 70, "ExampleText",
 CellID->238986113],
Cell[CellGroupData[{
Cell[11399, 349, 428, 14, 70, "Input",
 CellID->220323761],
Cell[11830, 365, 6177, 106, 129, 171, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->21535949]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18056, 477, 216, 7, 70, "ExampleSection",
 CellID->23638],
Cell[18275, 486, 96, 1, 70, "ExampleText",
 CellID->965055],
Cell[18374, 489, 982, 30, 70, "Input",
 CellID->780167557],
Cell[19359, 521, 547, 17, 70, "Input",
 CellID->313838249],
Cell[19909, 540, 131, 4, 70, "ExampleText",
 CellID->25220463],
Cell[CellGroupData[{
Cell[20065, 548, 309, 9, 70, "Input",
 CellID->22404248],
Cell[20377, 559, 3137, 56, 70, "Output",
 Evaluatable->False,
 CellID->63925454]
}, Open  ]],
Cell[23529, 618, 138, 4, 70, "ExampleText",
 CellID->55009090],
Cell[CellGroupData[{
Cell[23692, 626, 369, 11, 70, "Input",
 CellID->326858482],
Cell[24064, 639, 43758, 729, 184, 12875, 218, "CachedBoxData", "BoxData", \
"Output",
 CellID->345419746]
}, Open  ]],
Cell[67837, 1371, 125, 3, 70, "ExampleDelimiter",
 CellID->140536221],
Cell[67965, 1376, 119, 3, 70, "ExampleText",
 CellID->197663817],
Cell[68087, 1381, 98, 1, 70, "ExampleText",
 CellID->172269037],
Cell[CellGroupData[{
Cell[68210, 1386, 563, 18, 70, "Input",
 CellID->223816965],
Cell[68776, 1406, 32552, 544, 167, 9074, 155, "CachedBoxData", "BoxData", \
"Output",
 CellID->6796361]
}, Open  ]],
Cell[101343, 1953, 103, 2, 70, "ExampleText",
 CellID->47797131],
Cell[CellGroupData[{
Cell[101471, 1959, 558, 18, 70, "Input",
 CellID->413495886],
Cell[102032, 1979, 15285, 260, 167, 6182, 106, "CachedBoxData", "BoxData", \
"Output",
 CellID->4491083]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[117366, 2245, 221, 7, 70, "ExampleSection",
 CellID->215],
Cell[117590, 2254, 102, 2, 70, "ExampleText",
 CellID->66289245],
Cell[117695, 2258, 1811, 50, 70, "Input",
 CellID->54083269],
Cell[119509, 2310, 83, 1, 70, "ExampleText",
 CellID->14263224],
Cell[CellGroupData[{
Cell[119617, 2315, 552, 19, 70, "Input",
 CellID->148805197],
Cell[120172, 2336, 38200, 639, 167, 15419, 261, "CachedBoxData", "BoxData", \
"Output",
 CellID->427454262]
}, Open  ]],
Cell[CellGroupData[{
Cell[158409, 2980, 749, 22, 70, "Input",
 CellID->298175582],
Cell[159161, 3004, 25544, 423, 70, "Output",
 Evaluatable->False,
 CellID->472376862]
}, Open  ]],
Cell[184720, 3430, 124, 3, 70, "ExampleDelimiter",
 CellID->20958322],
Cell[184847, 3435, 91, 1, 70, "ExampleText",
 CellID->1517601905],
Cell[CellGroupData[{
Cell[184963, 3440, 761, 24, 70, "Input",
 CellID->70093528],
Cell[185727, 3466, 31305, 517, 70, "Output",
 Evaluatable->False,
 CellID->30795972]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[217093, 3990, 310, 9, 70, "SeeAlsoSection",
 CellID->8201],
Cell[217406, 4001, 716, 26, 70, "SeeAlso",
 CellID->12140]
}, Open  ]],
Cell[CellGroupData[{
Cell[218159, 4032, 319, 9, 70, "MoreAboutSection",
 CellID->249203446],
Cell[218481, 4043, 145, 3, 70, "MoreAbout",
 CellID->733843],
Cell[218629, 4048, 124, 3, 70, "MoreAbout",
 CellID->615462426],
Cell[218756, 4053, 126, 3, 70, "MoreAbout",
 CellID->1401394],
Cell[218885, 4058, 197, 4, 70, "MoreAbout",
 CellID->109379285],
Cell[219085, 4064, 197, 4, 70, "MoreAbout",
 CellID->599134359]
}, Open  ]],
Cell[219297, 4071, 27, 0, 70, "History"],
Cell[219327, 4073, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

