(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     83301,       1764]
NotebookOptionsPosition[     78772,       1616]
NotebookOutlinePosition[     80226,       1656]
CellTagsIndexPosition[     80140,       1651]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"General Graph Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/GraphDrawing"], 
          "Tree Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/TreeDrawing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"General Graph Drawing\"\>", 
       2->"\<\"Tree Drawing\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EdgeRenderingFunction" :> 
          Documentation`HelpLookup["paclet:ref/EdgeRenderingFunction"], 
          "SelfLoopStyle" :> 
          Documentation`HelpLookup["paclet:ref/SelfLoopStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EdgeRenderingFunction\"\>", 
       2->"\<\"SelfLoopStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["VertexRenderingFunction", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["VertexRenderingFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["GraphPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
     " and related functions which gives a function to generate the graphics \
primitives to use in rendering each vertex."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"VertexRenderingFunction", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " specifies that each vertex should be rendered with the graphics primitives \
given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["k", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["k", "TI"]]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is the coordinate position where the vertex is being placed, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is its name."
}], "Notes",
 CellID->166183907],

Cell[TextData[{
 "The graphics primitives obtained by applying ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " are in effect directly spliced into the graphic generated by a function \
like ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 " can be used to insert an arbitrary expression."
}], "Notes",
 CellID->184577521],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"VertexRenderingFunction", "->", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"{", "}"}], "&"}], ")"}]}]], "InlineFormula"],
 " draws nothing for each vertex. "
}], "Notes",
 CellID->839055751],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"VertexRenderingFunction", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " renders vertices according to the style specified by ",
 Cell[BoxData[
  ButtonBox["VertexLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexLabeling"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->336501309],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " define defaults that can be overridden by explicit directives in ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->809570488]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->697088447],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->70536648],

Cell["Draw each vertex using its labels in a disk:", "ExampleText",
 CellID->359524412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"White", ",", 
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107339026],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{1.7746720323889682`, 0.489932963371797}, {
      0.8307350853754956, 0.}, {0.8308232440262058, 0.9798583207057228}, {0., 
      0.1330252454414802}, {0.0011272410213615247`, 0.8474882025594347}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {1, 3}, {4, 5}, {4, 2}, {4, 3}, {5, 2}, {5, 3}}]}], {
      {GrayLevel[1], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.7746720323889682`, 0.489932963371797}, 0.1], 
       {GrayLevel[0], 
        InsetBox["1", {1.7746720323889682`, 0.489932963371797}]}}, 
      {GrayLevel[1], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.8307350853754956, 0.}, 0.1], 
       {GrayLevel[0], InsetBox["4", {0.8307350853754956, 0.}]}}, 
      {GrayLevel[1], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.8308232440262058, 0.9798583207057228}, 0.1], 
       {GrayLevel[0], 
        InsetBox["5", {0.8308232440262058, 0.9798583207057228}]}}, 
      {GrayLevel[1], EdgeForm[GrayLevel[0]], 
       DiskBox[{0., 0.1330252454414802}, 0.1], 
       {GrayLevel[0], InsetBox["2", {0., 0.1330252454414802}]}}, 
      {GrayLevel[1], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.0011272410213615247`, 0.8474882025594347}, 0.1], 
       {GrayLevel[0], 
        InsetBox["3", {0.0011272410213615247`, 0.8474882025594347}]}}}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.7746720323889682`, 0.489932963371797}, {
     0.8307350853754956, 0.}, {0.8308232440262058, 0.9798583207057228}, {0., 
     0.1330252454414802}, {0.0011272410213615247`, 0.8474882025594347}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1340793347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->310379970],

Cell["Do not draw a vertex at all:", "ExampleText",
 CellID->472492659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->837049105],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.7746720323889682`, 0.489932963371797}, {
    0.8307350853754956, 0.}, {0.8308232440262058, 0.9798583207057228}, {0., 
    0.1330252454414802}, {0.0011272410213615247`, 0.8474882025594347}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {4, 5}, {4, 2}, {4, 3}, {5, 2}, {5, 3}}]}, 
     {RGBColor[0, 0, 0.7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.7746720323889682`, 0.489932963371797}, {
     0.8307350853754956, 0.}, {0.8308232440262058, 0.9798583207057228}, {0., 
     0.1330252454414802}, {0.0011272410213615247`, 0.8474882025594347}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->979701302]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->208840718],

Cell["Use graphics:", "ExampleText",
 CellID->546473373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"smiley", "=", 
   GraphicsBox[RasterBox[CompressedData["
1:eJy9VrGRxCAMNCAcuYnvgPmAQj5U5LkGrgmiK4Z6KOdtY/9LAh+Q3M44kXe9
EkaCr8fz56Gnafo+H1WBNsYAgDG69rZkw0xgWyrN6JdojP9WY+r8HVDLTdt7
wYbSpiEoJbrBLyQdgq2YUQFzadVw4W/FymV1BxYZtvWcHL5iyogBuerMi/1p
H3fiit57DLsyuCIvauFenLL4sAWIDwgLTAll8i6kSL4hLNbo5hKYAquELVSx
OtmGhK2ouwNKDQpm07lBiOJNG9UBwwo7rhhdqs8oPlA58D/oED0nuHXluxPY
LvF74wUawT2CNGLoVFhytxKCy91LXTTd7T6/JyaY5Dcs6yjXoTBsWJ1Z+eIb
JCvNp5WLsk7cRwuJgJyIi0fR6QuyWaFbJ43ENaz795auj9F7/A/3zrzoAdIl
sUqNSaw4b5vVS0HTBSRfNc7nm1vDrU31ypBtqtXc87OPEDWvS4fIgD2wXcoq
9F9ZLI/Q
     "], {{0, 0}, {50, 50}},
     ColorFunction->(Apply[RGBColor, 
       Part[CompressedData["
1:eJztmMtNxFAQBA0iEWIggM2BEJA4Ew9k9ELwmRM3QuAn68ndXTOGK/YF2eXx
FrP72mPfPjzdP14vn9vVstws2/Z+yX+dvzx/bW9w/vvl7nt7Rf5TvzZ8IP+r
18bpvO04+e/r3X/P3X//ue7f9W3j5L9xus6+3v333P3316X+d9/r2vR/bfq/
Nv1fm/6vjT//7jZe+4/GfzT+o/Ef6F8fn7xeJ8tS/w63evqeN0591O34uj26
r/75/LXhAzn5d7lC5+lx8qf8ydz9KX+O5h7lj3Lyp/zJ3P0pf36Xy54/yuv+
e/5kTv33/Dl636D8UV77e/5kTv6eP919TXm9fj1/cj2tX8+f7Dc9j9538/Wc
d/vqn/lATv7dXED5o5z8aZ1l7v70O6HcIE7+dJ1c7/6UP/m61P9urvL8UV73
3/Mnc+q/5w/938Rrf8+fXE/+nj/Zz/31OPF6/Xr+5Hpav54/2W961vPU0Xml
yxOt7/Y1P9XP/ev5Z3Lyr+cfrXf/ev5RP/fXzyVO/jknqN79aR1mP+p/91xE
88+Kfcj11H+af7SO/Pm5rZ5/Jq/9af5RTv40/3TPlZPX65fmH62n9Uvzj/qp
f//cu9/n56Xsz3mSOe+Tf50/k5N/nT9a7/51/qif+9f5M5r8GU3+aL371/mj
ftT/7r0G5c/kdf8pf5RT/yl/+vcudf4M/B5zPflT/uhx99fjxOv1S/mj9bR+
KX/UTz3dm3he55PndaT13TzDeUP7lD/KyZ/yJ9e7P+VP9nN/yh/l5E/5k+vd
n/In+7k/5Y/yuv80B2o99Z/mGPUjf35vWt/nJq/9KaeVkz/ljG783rdev/Q7
1Hpav9RH2k5+8pOf/P/yD7a1mLo=
        "], #]]& ),
     ColorFunctionScaling->False],
    Background->None,
    ImageSize->{28., 28.},
    PlotRange->{{0, 50}, {0, 50}}]}], ";", 
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "4"}], ",", 
      RowBox[{"1", "\[Rule]", "5"}], ",", 
      RowBox[{"2", "\[Rule]", "3"}], ",", 
      RowBox[{"2", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "5"}], ",", 
      RowBox[{"3", "\[Rule]", "4"}], ",", 
      RowBox[{"3", "\[Rule]", "5"}]}], "}"}], ",", 
    RowBox[{"VertexRenderingFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Inset", "[", 
        RowBox[{"smiley", ",", "#"}], "]"}], "&"}], ")"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->888324870],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{164, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->454446218]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->492269761],

Cell["Draw vertices as spheres:", "ExampleText",
 CellID->1083846730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sphere", "[", 
       RowBox[{"#", ",", "0.1"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357900828],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsGroup3DBox[{
     GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {0., 
      0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
      0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
      0.5283357973836946}}, 
      {RGBColor[0.5, 0., 0.], 
       Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {2, 3}, {2, 4}, {3, 4}}]}], {
      SphereBox[{0.0336565100218259, 0.261321765643619, 0.}, 0.1], 
      SphereBox[{0., 0.24474517434175455`, 0.9989742720647393}, 0.1], 
      SphereBox[{0.8449440803872921, 0., 0.523159358644546}, 0.1], 
      SphereBox[{0.530937494896891, 0.9494940038888471, 0.5283357973836946}, 
       0.1]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2143491359,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["\<\
For large graphs, it is often better not to display vertices:\
\>", "ExampleText",
 CellID->1881226827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"ExampleData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Matrix\>\"", ",", "\"\<HB/Blckhole\>\""}], "}"}], ",", 
     "\"\<Matrix\>\""}], "]"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1012619612],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->948139773]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->263779286],

Cell["Draw vertices as graphics:", "ExampleText",
 CellID->1998898712],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"leaf", "=", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztlGdXE0EUhrPLLpvEQCAJKQTQ0IzUEKoFC9IEsQSQrhJs9GoHxIYI3Pub
ndmskC0zZr/7njMzZ+68z5mZe+ZOLL2eSosOhyNBWpI0tFYeAGOFpf8EV57s
STgXou5be/tLWZYbRFF8dAvgRNQky8fWhL8MVO0LgrD1GSAqaAIIMzbxAUNe
1rEOFhnEEfMmHdaAM8LwhxoPrYnXDKDqKusas4mAFfDmBQsgmq83+SM1pRwA
oDPeENIBN71cP5Vrp7nkzF/ovvhPgGozT2OKr+Tkp5KSxD9a/i5nAKB0KIzv
820ARGWtwbHLdoDo7S+IAX5idfrUTauo6kLuRLmaq/s2DrWhEk90Mf6ten4R
wK9L1kCv0SToZhWEeJAdkPxuI1EdzZ59J8Tbr5IkuRcyQAmmjMTuB/UNTazU
VUuDTid9VUFFUfAHPds1BbHFSHRh7DEZ7hKrEglcOn++16Gzho6mVJ8izuxB
fpZV043natWsGQFoIdFY0SuLImxW+3smooiGp5NWdauqz0RAiGlWZVErd/hE
pZmo4AKeAmI5fwQFLtIluEQx+QIqu84yPNUad8EqlxiHJh/i779pWsdhX9My
l1iabKM7aZuM0FBbI5cIZobMl13Lter1jCYAHtogME0A77Yd4qcT4KkdAHEO
+u0BWFj70SaBbg9r5Q9kPtCc
     "], {{0, 0}, {50, 48}},
     ColorFunction->(Apply[RGBColor, 
       Part[CompressedData["
1:eJztl1tvVFUYhkfDDxABQYMQ/oHGQ+IB+AvYKMqFmJB4LQmSmBDBSy+LcmjL
MV4RYgwtEMKhBwNyCiG0tp1DLcx0pu102pkREwETRPy+L30u3izDD3A/N08y
z+zJzl5rr7Vm3bYvOj5/Pvcvz+VyS3KL/L5xlXMCL36+6Lecaaw9rqtj7Z84
Baz97qSDtb/gfIO1//PEaGHtLzp9OH3/32Ltp/uMKZy+v+1Y+9Cg0cbp6zux
9g1OC2t/2bmBta92LmHt7zoNrH27U8baB/qNJta+3mli7YMDRgtr3+q0sPbj
x4w21t7dZdSx9jVOC6ef3484PX6nsPZXnJNY+w6nirW/7cxg7TFvu7D2I4eN
Baz90UNjFqd//zrW/tuEMY+1L3UqWPurziTW/pJzFaev78faDx4wrmLtHzlj
WPuDP41prP27vUYFa9/3vVHF2t9wqlh710HjGk73Wax9b6dRxtqPHTVuY+1f
OXWsvcOZwtq/dppY+wfOMNYe720Ba1/u7MPae08ZZax9fMzB2lc6eaw93usS
1n6ox2hg7e8581h7T7cxh7WfPWPUsPa1zj2cvv8G1h7r4k84PX4VrL2v16hg
7a87FZwe/+tYe+zrI1h7rHu3sPadzjROP/8i1r7baWHtm5wy1r7MqWLtXzo1
rH1s1Khh7buceaw93pszWPtmZxxr3+O0sfZC3pjF2lc401h7vDc3sfbYV37G
2o8eMSax9j/uGxWs/a9HRh1rLxaMOk4/3ytY+2tOGWt/06lh7e87C1h7rFvn
sPYD+41fsPaJkoPT4zeGtce8voy1x76Vx9pj37qDtce8ymPtMW9ncPr+z2Lt
v44YU1h7rJs3sfYL5405rL1UdLD2vx8bC1j7Z04ba//QGcXaY90Yxdrjf8V5
rD1oY+2xbt7A2u/ddXB6/Iew9piXDaz9HWcOa4//pXWsPc6d41h7zOvTWPvH
zizWHutWL9Ye+9oPWPvFC0YDa//UaWLtcW4dxtqH7zhY+xaniLXHubyJtce6
3MTa49wyiLXHubWFtce6W8Pa49w6grU/fGDMYO35cWMGa499q4S155Jof9b3
/+v6rGc961nPetaznvWsZz3rWc/6/70/BeBaxH8=
        "], #]]& ),
     ColorFunctionScaling->False],
    Background->None,
    ImageSize->{28., 26.},
    PlotRange->{{0, 50}, {0, 48}}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", "#"}], "}"}], "&"}], ",", "x", ",", "2"}], "]"}], 
   ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{"leaf", ",", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1241459968],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{149, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->638298811]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelfLoopStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelfLoopStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["General Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawing"]], "Tutorials",
 CellID->99260146],

Cell[TextData[ButtonBox["Tree Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TreeDrawing"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VertexRenderingFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 8.1486810}", "context" -> "System`", 
    "keywords" -> {
     "vertex drawing", "vertex graphics", "vertex rendering", 
      "vertex display"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "VertexRenderingFunction is an option for GraphPlot and related functions \
which gives a function to generate the graphics primitives to use in \
rendering each vertex.", "synonyms" -> {"vertex rendering function"}, "title" -> 
    "VertexRenderingFunction", "type" -> "Symbol", "uri" -> 
    "ref/VertexRenderingFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7389, 236, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->697088447]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 79997, 1644}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1441, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2064, 62, 1588, 37, 70, "ObjectNameGrid"],
Cell[3655, 101, 697, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4389, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4867, 142, 791, 28, 70, "Notes",
 CellID->166183907],
Cell[5661, 172, 624, 19, 70, "Notes",
 CellID->184577521],
Cell[6288, 193, 233, 8, 70, "Notes",
 CellID->839055751],
Cell[6524, 203, 413, 13, 70, "Notes",
 CellID->336501309],
Cell[6940, 218, 412, 13, 70, "Notes",
 CellID->809570488]
}, Closed]],
Cell[CellGroupData[{
Cell[7389, 236, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->697088447],
Cell[CellGroupData[{
Cell[7774, 250, 147, 5, 70, "ExampleSection",
 CellID->70536648],
Cell[7924, 257, 87, 1, 70, "ExampleText",
 CellID->359524412],
Cell[CellGroupData[{
Cell[8036, 262, 827, 24, 47, "Input",
 CellID->107339026],
Cell[8866, 288, 1809, 38, 129, "Output",
 CellID->1340793347]
}, Open  ]],
Cell[10690, 329, 125, 3, 70, "ExampleDelimiter",
 CellID->310379970],
Cell[10818, 334, 71, 1, 70, "ExampleText",
 CellID->472492659],
Cell[CellGroupData[{
Cell[10914, 339, 506, 14, 70, "Input",
 CellID->837049105],
Cell[11423, 355, 874, 20, 121, "Output",
 CellID->979701302]
}, Open  ]],
Cell[12312, 378, 125, 3, 70, "ExampleDelimiter",
 CellID->208840718],
Cell[12440, 383, 56, 1, 70, "ExampleText",
 CellID->546473373],
Cell[CellGroupData[{
Cell[12521, 388, 2346, 54, 60, "Input",
 CellID->888324870],
Cell[14870, 444, 5548, 95, 137, "Output",
 Evaluatable->False,
 CellID->454446218]
}, Open  ]],
Cell[20433, 542, 125, 3, 70, "ExampleDelimiter",
 CellID->492269761],
Cell[20561, 547, 69, 1, 70, "ExampleText",
 CellID->1083846730],
Cell[CellGroupData[{
Cell[20655, 552, 576, 17, 70, "Input",
 CellID->357900828],
Cell[21234, 571, 10646, 182, 229, 1069, 21, "CachedBoxData", "BoxData", \
"Output",
 CellID->2143491359]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31929, 759, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[32153, 768, 113, 3, 70, "ExampleText",
 CellID->1881226827],
Cell[CellGroupData[{
Cell[32291, 775, 351, 10, 70, "Input",
 CellID->1012619612],
Cell[32645, 787, 36125, 596, 70, "Output",
 Evaluatable->False,
 CellID->948139773]
}, Open  ]],
Cell[68785, 1386, 125, 3, 70, "ExampleDelimiter",
 CellID->263779286],
Cell[68913, 1391, 70, 1, 70, "ExampleText",
 CellID->1998898712],
Cell[CellGroupData[{
Cell[69008, 1396, 2626, 57, 70, "Input",
 CellID->1241459968],
Cell[71637, 1455, 5546, 95, 70, "Output",
 Evaluatable->False,
 CellID->638298811]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77244, 1557, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[77563, 1568, 491, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[78091, 1590, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[78412, 1601, 147, 3, 70, "Tutorials",
 CellID->99260146],
Cell[78562, 1606, 138, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[78715, 1612, 27, 0, 70, "History"],
Cell[78745, 1614, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

