(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49114,       1235]
NotebookOptionsPosition[     45120,       1105]
NotebookOutlinePosition[     46496,       1143]
CellTagsIndexPosition[     46410,       1138]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ViewRange" :> Documentation`HelpLookup["paclet:ref/ViewRange"],
           "ViewVector" :> Documentation`HelpLookup["paclet:ref/ViewVector"], 
          "ViewPoint" :> Documentation`HelpLookup["paclet:ref/ViewPoint"], 
          "RotationAction" :> 
          Documentation`HelpLookup["paclet:ref/RotationAction"], 
          "PreserveImageOptions" :> 
          Documentation`HelpLookup["paclet:ref/PreserveImageOptions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ViewRange\"\>", 
       2->"\<\"ViewVector\"\>", 3->"\<\"ViewPoint\"\>", 
       4->"\<\"RotationAction\"\>", 
       5->"\<\"PreserveImageOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ViewAngle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ViewAngle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " and related functions which gives the opening half-angle for a \
simulated camera used to view the three\[Hyphen]dimensional scene. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7845]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be used: ", "Notes",
 CellID->31308],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "an opening half-angle sufficient to see everything ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "a maximum opening angle of ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["35", "\[EmptySmallCircle]"], TraditionalForm]]],
     " (default) "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["\[Theta]", "TR"], Cell[
    "an explicit half-opening angle in radians ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->28146],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"ViewAngle", "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", the complete bounding box or circumscribing sphere will, if possible, \
just fill the final 2D viewing area. "
}], "Notes",
 CellID->26460],

Cell[TextData[{
 "The default setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " when the simulated camera is far from the object, but is constrained never \
to be greater than ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["35", "\[EmptySmallCircle]"], TraditionalForm]]],
 ", even when the camera is close. "
}], "Notes",
 CellID->1405],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ViewAngle", "->", 
   RowBox[{"35", 
    ButtonBox["Degree",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Degree"]}]}]], "InlineFormula"],
 " is a typical field of view used for human ergonomics and in cameras. "
}], "Notes",
 CellID->13741],

Cell[TextData[{
 "Changing the setting for ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 " is effectively like zooming a camera. "
}], "Notes",
 CellID->18513],

Cell[TextData[{
 "Explicit settings for ",
 Cell[BoxData[
  ButtonBox["ViewMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewMatrix"]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20145]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->388196196],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->415842575],

Cell["Use a specific half-angle for a simulated camera:", "ExampleText",
 CellID->45754525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"ViewAngle", "\[Rule]", 
      RowBox[{"d", " ", "\[Degree]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "35", ",", "50"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->297329540],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ViewAngle->NCache[20 Degree, 0.3490658503988659],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ViewAngle->NCache[35 Degree, 0.6108652381980153],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ViewAngle->NCache[50 Degree, 0.8726646259971648],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->93667865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->246573656],

Cell[TextData[{
 "The default 35\[Degree] half-angle may not be enough for the particular ",
 Cell[BoxData[
  ButtonBox["ViewVector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVector"]], "InlineFormula"],
 " setting:"
}], "ExampleText",
 CellID->51980408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cylinder", "[", "]"}], ",", 
      RowBox[{"Sphere", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"ViewVector", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", 
         RowBox[{"-", "6"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ViewAngle", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"SphericalRegion", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575365378],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[{CylinderBox[{{0, 0, -1}, {0, 0, 1}}], SphereBox[{4, 0, 0}]},
   SphericalRegion->True,
   ViewAngle->Automatic,
   ViewVector->{{4, -6, 0}, {2, 0, 0}},
   ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
  StripOnInput->False]], "Output",
 ImageSize->{114, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->297148638]
}, Open  ]],

Cell["\<\
Choose the half-angle automatically, so that the view includes all the \
objects:\
\>", "ExampleText",
 CellID->934491308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Sphere", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"ViewVector", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", 
        RowBox[{"-", "6"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ViewAngle", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->253334336],

Cell[BoxData[
 Graphics3DBox[{CylinderBox[{{0, 0, -1}, {0, 0, 1}}], SphereBox[{4, 0, 0}]},
  ViewAngle->All,
  ViewVector->{{4, -6, 0}, {2, 0, 0}}]], "Output",
 ImageSize->{154, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->493794267,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24719],

Cell[TextData[{
 "Illustrate the relation between ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 " and the simulated camera view:"
}], "ExampleText",
 CellID->244652192],

Cell[BoxData[
 RowBox[{
  RowBox[{"cone", "[", 
   RowBox[{"y_", ",", "\[Theta]_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"r", "=", 
      RowBox[{
       RowBox[{"Abs", "[", "y", "]"}], 
       RowBox[{"Tan", "[", 
        RowBox[{"\[Theta]", "/", "2"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"ParametricPlot3D", "[", 
       RowBox[{
        RowBox[{"r", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], ",", "0", ",", 
           RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
        RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Large", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", "y", ",", "0"}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "y", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"r", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "y", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "r"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
           "}"}], "]"}]}], "}"}], "]"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37960064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"cone", "[", 
         RowBox[{
          RowBox[{"-", "3"}], ",", "\[Theta]"}], "]"}], ",", 
        RowBox[{"Graphics3D", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Sphere", "[", "]"}], ",", 
           RowBox[{"Cuboid", "[", "]"}], ",", 
           RowBox[{"FaceForm", "[", "]"}], ",", 
           RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
           RowBox[{"Cuboid", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{"-", "1"}], ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}]}], "}"}], 
         "]"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "3"}], ",", 
        RowBox[{"BoxStyle", "\[Rule]", "Gray"}]}], "]"}], ",", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sphere", "[", "]"}], ",", 
          RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
        RowBox[{"ViewVector", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "3"}], ",", "0"}], "}"}]}], ",", 
        RowBox[{"ViewAngle", "\[Rule]", "\[Theta]"}]}], "]"}]}], "}"}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", 
     RowBox[{"Pi", "/", "4"}], ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}], ",", 
   RowBox[{"AnimationDirection", "\[Rule]", "ForwardBackward"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->261177754],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Theta]$$ = 1.1663162726452108`, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Theta]$$], Rational[1, 4] Pi, Rational[1, 2] Pi}}, 
    Typeset`size$$ = {360., {95., 100.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`\[Theta]$982$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`\[Theta]$$ = Rational[1, 4] Pi}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$982$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Row[{
         Show[
          $CellContext`cone[-3, $CellContext`\[Theta]$$], 
          Graphics3D[{
            Sphere[], 
            Cuboid[], 
            FaceForm[None], 
            EdgeForm[Black], 
            Cuboid[{-1, -1, -1}, {1, 1, 1}]}], PlotRange -> 3, BoxStyle -> 
          Gray], 
         Graphics3D[{
           Sphere[], 
           Cuboid[]}, ViewVector -> {0, -3, 0}, 
          ViewAngle -> $CellContext`\[Theta]$$]}], 
      "Specifications" :> {{$CellContext`\[Theta]$$, Rational[1, 4] Pi, 
         Rational[1, 2] Pi, AnimationRunning -> False, AnimationDirection -> 
         ForwardBackward, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{406., {133., 138.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`cone[
         Pattern[$CellContext`y, 
          Blank[]], 
         Pattern[$CellContext`\[Theta], 
          Blank[]]] := 
       With[{$CellContext`r = 
          Abs[$CellContext`y] Tan[$CellContext`\[Theta]/2]}, 
         Show[
          ParametricPlot3D[$CellContext`r {
             Cos[$CellContext`t], 0, 
             Sin[$CellContext`t]}, {$CellContext`t, 0, 2 Pi}, PlotStyle -> 
           Red, Axes -> False], 
          Graphics3D[{Red, 
            PointSize[Large], 
            Point[{0, $CellContext`y, 0}], 
            
            Line[{{{0, $CellContext`y, 0}, {$CellContext`r, 0, 0}}, {{
               0, $CellContext`y, 0}, {-$CellContext`r, 0, 0}}}]}]]]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 273},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->419078623]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26236],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewVector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewVector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotationAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotationAction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PreserveImageOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PreserveImageOptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6379]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ViewAngle",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ViewAngle"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->552052768],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->98737301],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->352489876]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ViewAngle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 12.0550310}", "context" -> "System`", 
    "keywords" -> {
     "aperture", "viewing angle", "camera opening angle", "view frustum"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ViewAngle is an option for Graphics3D and related functions which gives \
the opening half-angle for a simulated camera used to view the \
three-dimensional scene. ", "synonyms" -> {"view angle"}, "title" -> 
    "ViewAngle", "type" -> "Symbol", "uri" -> "ref/ViewAngle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8211, 253, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->388196196]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46267, 1131}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1863, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2486, 69, 1574, 37, 70, "ObjectNameGrid"],
Cell[4063, 108, 682, 19, 70, "Usage",
 CellID->7845]
}, Open  ]],
Cell[CellGroupData[{
Cell[4782, 132, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5260, 149, 69, 1, 70, "Notes",
 CellID->31308],
Cell[5332, 152, 1067, 28, 70, "2ColumnTableMod",
 CellID->28146],
Cell[6402, 182, 325, 10, 70, "Notes",
 CellID->26460],
Cell[6730, 194, 557, 18, 70, "Notes",
 CellID->1405],
Cell[7290, 214, 291, 9, 70, "Notes",
 CellID->13741],
Cell[7584, 225, 238, 8, 70, "Notes",
 CellID->18513],
Cell[7825, 235, 349, 13, 70, "Notes",
 CellID->20145]
}, Closed]],
Cell[CellGroupData[{
Cell[8211, 253, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->388196196],
Cell[CellGroupData[{
Cell[8596, 267, 148, 5, 70, "ExampleSection",
 CellID->415842575],
Cell[8747, 274, 91, 1, 70, "ExampleText",
 CellID->45754525],
Cell[CellGroupData[{
Cell[8863, 279, 412, 14, 28, "Input",
 CellID->297329540],
Cell[9278, 295, 10762, 185, 123, "Output",
 CellID->93667865]
}, Open  ]],
Cell[20055, 483, 125, 3, 70, "ExampleDelimiter",
 CellID->246573656],
Cell[20183, 488, 266, 8, 70, "ExampleText",
 CellID->51980408],
Cell[CellGroupData[{
Cell[20474, 500, 719, 21, 70, "Input",
 CellID->575365378],
Cell[21196, 523, 4721, 84, 133, "Output",
 CellID->297148638]
}, Open  ]],
Cell[25932, 610, 132, 4, 70, "ExampleText",
 CellID->934491308],
Cell[CellGroupData[{
Cell[26089, 618, 606, 19, 70, "Input",
 CellID->253334336],
Cell[26698, 639, 7922, 135, 85, 159, 3, "CachedBoxData", "BoxData", "Output",
 CellID->493794267]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34669, 780, 223, 7, 70, "ExampleSection",
 CellID->24719],
Cell[34895, 789, 247, 8, 70, "ExampleText",
 CellID->244652192],
Cell[35145, 799, 1782, 51, 70, "Input",
 CellID->37960064],
Cell[CellGroupData[{
Cell[36952, 854, 1826, 51, 70, "Input",
 CellID->261177754],
Cell[38781, 907, 3249, 77, 70, "Output",
 CellID->419078623]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42091, 991, 311, 9, 70, "SeeAlsoSection",
 CellID->26236],
Cell[42405, 1002, 1229, 44, 70, "SeeAlso",
 CellID->6379]
}, Open  ]],
Cell[CellGroupData[{
Cell[43671, 1051, 305, 8, 70, "RelatedLinksSection"],
Cell[43979, 1061, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44379, 1078, 319, 9, 70, "MoreAboutSection",
 CellID->552052768],
Cell[44701, 1089, 147, 3, 70, "MoreAbout",
 CellID->98737301],
Cell[44851, 1094, 197, 4, 70, "MoreAbout",
 CellID->352489876]
}, Open  ]],
Cell[45063, 1101, 27, 0, 70, "History"],
Cell[45093, 1103, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

