(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16757,        518]
NotebookOptionsPosition[     13425,        407]
NotebookOutlinePosition[     14836,        448]
CellTagsIndexPosition[     14718,        442]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Selectable" :> 
          Documentation`HelpLookup["paclet:ref/Selectable"], "WindowFloating" :> 
          Documentation`HelpLookup["paclet:ref/WindowFloating"], "CellOpen" :> 
          Documentation`HelpLookup["paclet:ref/CellOpen"], "AutoScroll" :> 
          Documentation`HelpLookup["paclet:ref/AutoScroll"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Selectable\"\>", 
       2->"\<\"WindowFloating\"\>", 3->"\<\"CellOpen\"\>", 
       4->"\<\"AutoScroll\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>", 
       2->"\<\"Package Bulletproofing\"\>", 3->"\<\"Stylesheets\"\>", 
       4->"\<\"Window Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Visible", "ObjectName",
 CellID->8476],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Visible",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Visible"]], "InlineFormula"],
     "\[LineSeparator]is a notebook option which specifies whether the \
notebook should be explicitly displayed on the screen. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11771]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Visible", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " a notebook can still be manipulated from the kernel, but will not \
explicitly be displayed on the screen. "
}], "Notes",
 CellID->23095],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CreateWindow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateWindow"], "[", 
   RowBox[{"Visible", "->", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"]}], "]"}]], "InlineFormula"],
 " creates a new invisible window. "
}], "Notes",
 CellID->8938]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->266690185],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->707399],

Cell["Create a document that is not displayed:", "ExampleText",
 CellID->763939],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"TextCell", "[", 
        RowBox[{
         RowBox[{"\"\<text \>\"", "<>", 
          RowBox[{"ToString", "[", "k", "]"}]}], ",", "\"\<Text\>\""}], "]"}],
        ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Visible", "\[Rule]", "False"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261681783],

Cell["\<\
You can carry out manipulations of the notebook even while it is invisible:\
\>", "ExampleText",
 CellID->917318146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "CellContents"}], "]"}], ";", 
  RowBox[{"NotebookRead", "[", "nb", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->300607028],

Cell[BoxData["\<\"text 1\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->130487733]
}, Open  ]],

Cell["Make the notebook visible:", "ExampleText",
 CellID->14138864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"Visible", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->512821768],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3dtvFOcZB2BXva/yL/Rf6eE2iCo3tFIDUTmkVYRa9a5SL6ImaUNTlRwg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   "], {{0, 0}, {458, 170}}, {0, 255}],
  ImageSize->{458 0.75, 170 0.75},
  PlotRange->{{0, 458}, {0, 170}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->463889470]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8534],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Selectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Selectable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowFloating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFloating"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AutoScroll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutoScroll"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24856]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20176],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->11922]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->262823001],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->4403594],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->3824815],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->700367775],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->409005176]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Visible - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 20.1177374}", "context" -> "System`", 
    "keywords" -> {"invisible windows"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Visible is a notebook option which specifies whether the notebook should \
be explicitly displayed on the screen. ", "synonyms" -> {}, "title" -> 
    "Visible", "type" -> "Symbol", "uri" -> "ref/Visible"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4902, 154, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->266690185]},
 "Notebook Image"->{
  Cell[6860, 231, 3686, 63, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->463889470]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14450, 431},
 {"Notebook Image", 14591, 435}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2528, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3151, 86, 44, 1, 70, "ObjectName",
 CellID->8476],
Cell[3198, 89, 487, 14, 70, "Usage",
 CellID->11771]
}, Open  ]],
Cell[CellGroupData[{
Cell[3722, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4200, 125, 312, 10, 70, "Notes",
 CellID->23095],
Cell[4515, 137, 350, 12, 70, "Notes",
 CellID->8938]
}, Closed]],
Cell[CellGroupData[{
Cell[4902, 154, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->266690185],
Cell[CellGroupData[{
Cell[5287, 168, 145, 5, 70, "ExampleSection",
 CellID->707399],
Cell[5435, 175, 80, 1, 70, "ExampleText",
 CellID->763939],
Cell[5518, 178, 513, 16, 70, "Input",
 CellID->261681783],
Cell[6034, 196, 126, 3, 70, "ExampleText",
 CellID->917318146],
Cell[CellGroupData[{
Cell[6185, 203, 221, 6, 28, "Input",
 CellID->300607028],
Cell[6409, 211, 171, 5, 36, "Output",
 CellID->130487733]
}, Open  ]],
Cell[6595, 219, 68, 1, 70, "ExampleText",
 CellID->14138864],
Cell[CellGroupData[{
Cell[6688, 224, 169, 5, 70, "Input",
 CellID->512821768],
Cell[6860, 231, 3686, 63, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->463889470]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10607, 301, 310, 9, 70, "SeeAlsoSection",
 CellID->8534],
Cell[10920, 312, 961, 35, 70, "SeeAlso",
 CellID->24856]
}, Open  ]],
Cell[CellGroupData[{
Cell[11918, 352, 314, 9, 70, "TutorialsSection",
 CellID->20176],
Cell[12235, 363, 151, 3, 70, "Tutorials",
 CellID->11922]
}, Open  ]],
Cell[CellGroupData[{
Cell[12423, 371, 319, 9, 70, "MoreAboutSection",
 CellID->262823001],
Cell[12745, 382, 167, 3, 70, "MoreAbout",
 CellID->4403594],
Cell[12915, 387, 153, 3, 70, "MoreAbout",
 CellID->3824815],
Cell[13071, 392, 134, 3, 70, "MoreAbout",
 CellID->700367775],
Cell[13208, 397, 145, 3, 70, "MoreAbout",
 CellID->409005176]
}, Open  ]],
Cell[13368, 403, 27, 0, 70, "History"],
Cell[13398, 405, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

