(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    116525,       2386]
NotebookOptionsPosition[    111476,       2216]
NotebookOutlinePosition[    112946,       2256]
CellTagsIndexPosition[    112859,       2251]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WeierstrassP" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassP"], 
          "InverseWeierstrassP" :> 
          Documentation`HelpLookup["paclet:ref/InverseWeierstrassP"], 
          "KleinInvariantJ" :> 
          Documentation`HelpLookup["paclet:ref/KleinInvariantJ"], 
          "WeierstrassHalfPeriods" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassHalfPeriods"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"WeierstrassP\"\>", 
       2->"\<\"InverseWeierstrassP\"\>", 3->"\<\"KleinInvariantJ\"\>", 
       4->"\<\"WeierstrassHalfPeriods\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WeierstrassInvariants", "ObjectName",
 CellID->13633],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["WeierstrassInvariants",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WeierstrassInvariants"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["\[Omega]", "TR"], ",", 
         SuperscriptBox[
          StyleBox["\[Omega]", "TR"], "\[Prime]"]}], "}"}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives the invariants ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]], "InlineFormula"],
     " for Weierstrass elliptic functions corresponding to the \
half\[Hyphen]periods ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["\[Omega]", "TR"], ",", 
        SuperscriptBox[
         StyleBox["\[Omega]", "TR"], 
         StyleBox["\[Prime]", "TI"]]}], "}"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1722]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassInvariants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassInvariants"]], "InlineFormula"],
 " is the inverse of ",
 Cell[BoxData[
  ButtonBox["WeierstrassHalfPeriods",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassHalfPeriods"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17222],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["WeierstrassInvariants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassInvariants"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->804736039],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassInvariants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassInvariants"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->409871808],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->61599663],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->82870859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassInvariants", "[", 
  RowBox[{"{", 
   RowBox[{"1.", ",", 
    RowBox[{"2.", "I"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287333899],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8.12421844305302`", ",", "4.443052044945955`"}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217752987]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->317394759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"WeierstrassInvariants", "[", 
     RowBox[{"{", 
      RowBox[{"\[Omega]1", ",", 
       RowBox[{"1", "+", "I"}]}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535319250],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{223, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157571005]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->273582334],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->114757376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"WeierstrassInvariants", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"2", "I"}]}], "}"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152570203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8.1242184430530170907174818823599001851017295858586039430350599049397`50.",
    ",", "4.443052044945949990628549678084379316152052756756807485094710852757\
7`50."}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{375, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136048726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87778528],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->396280068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassInvariants", "[", 
  RowBox[{"{", 
   RowBox[{"1.00000000000000000000000000", ",", 
    RowBox[{"2", "I"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15003901],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8.12421844305301709071748188235990018484`25.069917805920536", ",", 
   "4.44305204494594999062854967808437931597`24.86179129212113"}], 
  "}"}]], "Output",
 ImageSize->{394, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11155872]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->216834343],

Cell["Plot an elliptic function over a period parallelogram:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->111168518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Omega]1", "=", "1"}], ",", " ", 
     RowBox[{"\[Omega]3", "=", 
      RowBox[{"0.2", "+", "I"}]}], ",", "g2", ",", "g3"}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ContourPlot", "[", 
         RowBox[{
          RowBox[{"Evaluate", "[", 
           RowBox[{"Re", "[", 
            RowBox[{"WeierstrassPPrime", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"x", " ", "\[Omega]1"}], "+", 
               RowBox[{"y", " ", "\[Omega]3"}]}], ",", 
              RowBox[{"N", "[", 
               RowBox[{"WeierstrassInvariants", "[", 
                RowBox[{"{", 
                 RowBox[{"\[Omega]1", ",", " ", "\[Omega]3"}], "}"}], "]"}], 
               "]"}]}], "]"}], "]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"y", ",", 
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
          RowBox[{"MaxRecursion", "->", "1"}]}], "]"}], "//", "First"}], ",", 
       
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", "\[Omega]1", "]"}], ",", 
           RowBox[{"Im", "[", "\[Omega]1", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", "\[Omega]3", "]"}], ",", 
           RowBox[{"Im", "[", "\[Omega]3", "]"}]}], "}"}]}], "}"}]}], "]"}], 
     ",", 
     RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154412271],

Cell[BoxData[
 GraphicsBox[GeometricTransformationBox[GraphicsComplexBox[CompressedData["
1:eJysvWVYlc/zB4zdgoHd3WJjjgoqdmBgA3YrgqJiYyC22KACEooioTQMSIN0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    "], {{
      {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
       GraphicsGroupBox[{
         PolygonBox[{{2476, 2639, 1133}, {1351, 1352, 677}, {1675, 2128, 
          677}, {2282, 2583, 431}, {1200, 1528, 1062}, {1301, 1220, 475}, {
          1520, 1298, 997}, {2500, 2498, 997}, {2212, 2210, 796}, {1505, 1473,
           843}, {2572, 2573, 1062}, {2071, 1834, 475}, {1403, 1351, 677}, {
          2583, 2284, 431}, {1281, 1424, 431}, {1473, 1538, 843}, {1833, 2051,
           475}, {2280, 1793, 843}, {2279, 2280, 843}, {1383, 1281, 431}, {
          1834, 2313, 475}, {1444, 1302, 796}, {1296, 1518, 987}, {2478, 2479,
           987}, {2313, 1833, 475}, {2122, 1675, 677}, {2471, 2472, 982}, {
          2284, 1798, 431}, {2128, 1953, 677}},
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtln1o1WUUx39tv+d6d+/SylEmNpTeCEdSk16kNCgDs7KZ9GorzMoiZ2no
CrKMIbGiTLGgNCrpxbJG5iinphQZwdqw8CVrYTanmVEqhUlpn09nfxzuOc9z
nuee55zv+Z7fiGmzJjdVZFn2OpIji4tZ9l4hy37BWJGy7Dj6lHKWTUX/m7U5
6OuRl7HvR0ah7+LMavSJyH34H8bejN6Ff2MxfNybj7SX2MN+DX0P+4MGZNks
7HuxT0TmVmdZPT6JewYie9G7jIm9YUgTa2exlvO7hfO9nB+D/hn6DPbnleMN
xt6E3Ig9iv0N7N+OvZazFezPRN/L2unoQ5A52I8gj+I/ErlSHWlGr+X8anyb
sX9Cv4C1a9EPs3YD8Q4jhsHYB5FzsIcjO9B3IpvwvRlpRH8FqUF/lhg6OTsG
u7Iqy/qwh6B/hTyDvpF43kL/Ep8l2FOxH8feil3i7j/4vwexv0CK3DcQuQT9
InNsbvD5HP1T/LdjX4rdq2+KXD+EXSxEzidhN3H/8+i3poitBdmUR4zN6Ffg
M4W9DuzRxaiJtZiX4r8PYZ+bIoZ2Yutm7W3065A+9KuRm9A/RirQD+B/Nno9
srAYbzD2V1PkwppYC3PiW8WMWPHNxjoZ/9tSxNxZijs8m1JgQYyKTTFxZily
bG4r2TuFt09E9mN/jdQVIge+fX0e2B2KfVkKDHdwvoEY6tD3sb8Huwqfh7FP
Q2rxPcbaSPTLkfPLgSGxc41vqI4aWrut2Hdy9h7kOXOd4qwYFrveYa3tGXvF
mvdw107kI/Q1yAR8F3PmW+4bkQKrdchVKTC7lL3HsJ9A34ZPfTFqZq3mGnMh
MC2WP8wjF/asvWpOFiG7PVuZZW0nEBv3dZC/31k72RrjX0EMR/Hfhb2yGDkx
F28i7+C7vxhnvWMl9jLu78X/5xS9Yo/am/bMaM5O4s7f0Av4XSyfIO3YDSm4
xZyaSzlmcHXU0Np1Id9wZjv776L/mgfWrKm1FHNyxf8YKARn7ChHDnz7qhRc
MwO7Ow/OOWNA9LS9XCPH4T8Ouw99egruGo6MTcFha9DvRqahv4SsKEWNrW1P
HrWeIAekqPmWUnCAvV9AWrFPxWe2/ZxHLa2xtbWmF/Lfx1jbiP6j+ca/jrUf
zE0e2JTT5DIxKndbE2shh4udP1n7Kw8MtWJvxv84dgv2HeXgDLnirhTYeRJZ
kAJD9nIL8lSKnn4RfRGyEP3pFL5rieH6FGdqqqMm1qIbezl3D2VtG/r3eeRS
TpKLzKm97IxxttjT49lvY3839j75E/2A/4H+rxgqxYxwNgwSb+y9gbyAviQF
d8mRcqMc9kE5amRtliK3sNeI/IN+FFlWjjs825pitsnZcrUzzrvlLLnK/5jO
2UPY6+zdFFzhDHN2yRlyq5gRK8X+2ekMcvY4Q0usnWQu6I2ZxPcA/rOJ+ROH
L3vf4buc+8bj836K3qilhzpT9IjYazCGFBiU23t8cwqONzZnkLPHGK2NnCwX
WyNnlxwhNzjDrK2YEAvW2FybI3Njzp1Fcojc4UySu50JzgI5/Eg5MC2WN6TA
qm/yLWLW2ltDaycGavvf6NucqWJZjIttMS22rIm1EGPOHnvKXnIGmStrYO7N
mVixxtZWzNiLYlos25NHStEz9sp5KWajMRurM9JZLUbFpjO7jVyvqoraWCOx
IifJRWLGXpLT5XJ7ytyLWbFqDeQSOa3Qzyn2vjPQ2ScHyG1yulwux9mL9pS9
ZE86S43ZWJ2pYmEd9sE8MOG3i5wsF/sNIxbkLLlKTPitJMfJbX4zOSvsSXvR
meG3jpwj1/jNI7bkVLlUjPmt4kx1lvrN8h/ZaV+P
          "],
          VertexColors->None], 
         PolygonBox[{{2747, 2122, 677, 1352, 1265}, {2490, 2500, 997, 1298, 
          1519}, {1798, 2473, 1507, 1383, 431}, {2210, 1646, 1233, 1444, 
          796}, {1583, 2279, 843, 1538, 1213}, {2573, 2699, 1223, 1200, 
          1062}, {2498, 2846, 1341, 1520, 997}, {3031, 2572, 1062, 1528, 
          1450}, {1692, 2478, 987, 1518, 1252}, {1793, 3128, 1504, 1505, 
          843}, {1953, 1761, 1267, 1403, 677}, {2057, 2212, 796, 1302, 
          1393}, {2639, 2787, 1295, 1546, 1133}, {2051, 2746, 1256, 1301, 
          475}, {2070, 2071, 475, 1220, 1394}, {1794, 2471, 982, 1506, 1274}},
          
          VertexColors->None]}]}, 
      {RGBColor[
       0.37754629617595453`, 0.20368426440137075`, 0.6476673087704367], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlV1olmUYx++9z8vz8b7vEsyvgVukMtCGCVqNHehwQ1YpG1NiBzlYIJOx
OQ0t61hQ8CDwNIOYoA1aXytRO1GP/Igom04tOtEhuJNNmYQl9vv7vw8uruu5
7uvrvq7rfz+vfjDau68UQjgGJdC9SgjdUFc5hFIWQmsthLG6EDanITzmexSb
g3kIh6AEh++LEP5Fvx/94WoIy7HrQP6Js1boY3y3lmyrOIPI16Ej2NzA71Pi
7EFeRZyz+DZgM4/tzZLlRdQxW3Kcds47C+dqSp1PuV6DfwJ1Iw+if7fmOr/G
9lvorurgfCX5rhLnbXgL3wPE7cG2Meo/KzvvHPJe6hrK3ZTLnD8j7pfoB+CD
6N/nqF8ceobPQ/hX5NqO/XH6Vw/tR1+FD6FvRz5EnJ7MPbhN/l9z9+gLdHf4
PoW+Fd3nmeWXqa0J3wPY1COXc9epe6huyS2J8yi++Etly7uI9zzWrBzqo3q4
QLwnhe101/7E922uOodifsP5SXyfc8cL1J/kntlv6JYUjnMRfgm6j38b50dT
13yC2t7KPRfNTfWpHu3OG6nnMsb3D+gPE2eG+OPYN/I9hc2bqfdBd22Kc1HO
31PnXYq+M/X+nFbPo+8oNvugSS0xvA7qS7yb2hvtzI7MO6f409z3Ruoa1J8f
E9f8BL478e7tgG8o235LYQyo/tfhO6vegT8Uu7C/9uJKZr32eirmGuZ8pPCd
l9DjExX3YDV8DdRWNs7qMmNE2NPOvqgZ/lfiWawgZgN0C9+l2H5X+EzfT+Mc
Z+MuqFd/6rzwmeY3l7hvfyeOr5jCyuKIF917Pt5de/pf7l2Vvr1s37XUu67i
77nYK+mb6cNEZgwKi+sjHqcT30G5rnG+OfN7INvG1Da/5MaJ6la/hSH1bZLa
l2WudwR+P7ev/Pqib63iWWqOXdisTI3rV4S5iJ0J9T6+A8JEb9W4ELa6a7YZ
Js4dvsfIv5w8y3Lj4x34z5wtIH9U8/v44m1Efx75GvpNyBtz914+ekfUw3+k
y31/xZVeM1JfO1L3VlgXfoSdM4XfXO3AtsJ3UG2TEeO64+3Cb6Xib6y4JtWj
vo7E3mreH8ZcB7CdSv0e30V+r+IzvWdDmfsgPI1ETO2mlkep3zRh6FxqHE0j
b8iMjwe5MaA9H0efZp5zf9xF5R3IPA/NYib3P0P/gP8BRAHOMQ==
          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlm1MlmUUx2946Hnu+7mfsJVKSitZW03DRWhp9kHKhHQZQq1gy7eCXkB5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          "],
          VertexColors->None], 
         PolygonBox[{{2273, 1574, 79, 2862, 2272}, {2896, 2152, 768, 2158, 
          2895}, {1778, 2864, 2863, 2142, 765}, {2497, 2491, 2490, 2788, 
          996}, {1647, 1605, 1082, 2596, 1646}, {2708, 2141, 765, 2140, 
          2707}, {2119, 1676, 1675, 2122, 757}, {3154, 2854, 457, 1821, 
          3153}, {2216, 2058, 2057, 2789, 797}, {1822, 2195, 2194, 2935, 
          457}, {1589, 2292, 2291, 1639, 111}, {1708, 2214, 797, 2217, 1707}},
          
          VertexColors->None]}]}, 
      {RGBColor[0.5206147501245962, 0.4524416680357414, 0.8487673282167151], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVn1MV1UYvvzur3vvubT1h8PMYmazWmlTQ5RqTk1R85d9DVMrUsS5QuRj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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQzmUUx3/e9/W7vL+3aERNyDCVLsj9WrnkNrqM2xRKLqmwlt3QtKSU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          "],
          VertexColors->None], 
         PolygonBox[{{1790, 2161, 634, 1898, 1789}, {2036, 2293, 847, 1589, 
          2035}, {1700, 2336, 2335, 2374, 909}, {2306, 1876, 282, 1720, 
          2305}, {2336, 1699, 908, 2368, 2335}, {2289, 2844, 2843, 2292, 
          847}, {2271, 1966, 1965, 1574, 838}, {1966, 2263, 831, 1565, 
          1965}, {2748, 2891, 2890, 2150, 766}, {2725, 2145, 766, 2144, 
          2724}, {1749, 1948, 1947, 2104, 749}, {1609, 2306, 2305, 2304, 
          133}, {1783, 1972, 685, 3097, 1782}, {2018, 1596, 1595, 2021, 
          705}, {2215, 1713, 717, 2216, 2214}, {2589, 1599, 1598, 2367, 908}},
          
          VertexColors->None]}]}, 
      {RGBColor[0.6372427899874445, 0.6455340361503584, 0.9111725350126789], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgm0VtV5hs9/zs85//mhCy6XoSkNcK8ImsqgVBzhikMaEJkcIlzmBJHE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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHnYVVUVxs+99+Pcc8+l5GMQCYgpGZIhQFAmkQ+JD6cEROYxhhQQGS0G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          "],
          VertexColors->None], 
         PolygonBox[{{2451, 2460, 976, 1777, 2450}, {2506, 2508, 2507, 1699, 
          264}, {2695, 2026, 706, 3084, 2694}, {2060, 1835, 798, 2219, 
          2059}, {2465, 1788, 415, 1897, 2464}, {2494, 1697, 1696, 2492, 
          995}, {3020, 3017, 3016, 2743, 706}, {2370, 2585, 1075, 2589, 
          2369}, {1779, 2632, 2631, 1972, 414}, {3049, 1575, 91, 2888, 
          3048}, {2489, 1818, 995, 2493, 2488}, {3043, 2877, 414, 3039, 
          3042}, {1983, 2156, 2155, 2153, 91}, {1817, 2489, 2488, 2641, 
          1134}, {1988, 2162, 769, 1790, 1987}, {2054, 2197, 788, 1823, 
          2053}, {2220, 2224, 2223, 1713, 272}, {2159, 1895, 1894, 2161, 
          769}, {2105, 1673, 1672, 2107, 750}, {2587, 2037, 2036, 1599, 
          1075}},
          VertexColors->None]}]}, 
      {RGBColor[0.7424312085194975, 0.8145425557425954, 0.9135705069704526], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnuQVdWVxs8593rOPZduYhAVGqF9JNLQQHwwyMMnguiIMCKvmMQYQCPi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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmUVcURxu97b7jLe09ZxAASRRZhBoLhGBYRBmUVN4wsIqAyMKwRBVn1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          "],
          VertexColors->None], 
         PolygonBox[{{2461, 2449, 243, 2459, 2460}, {1803, 2024, 2023, 2180, 
          781}, {2463, 2266, 2265, 1788, 977}, {1911, 2221, 799, 2220, 
          1910}, {2456, 2452, 2451, 1776, 975}, {1970, 2454, 975, 2458, 
          1969}, {1805, 3188, 3187, 2930, 442}, {1698, 2178, 781, 2177, 
          1697}, {2295, 2039, 442, 2290, 2294}, {2266, 2275, 839, 2274, 
          2265}, {2901, 3012, 3011, 3007, 110}, {3029, 3027, 3026, 1976, 
          686}, {2109, 1674, 235, 2105, 2108}, {2256, 1952, 1951, 2255, 
          825}, {1825, 2371, 2370, 2508, 1000}, {2017, 2495, 2494, 1818, 
          455}, {2287, 1587, 110, 2019, 2286}, {1896, 2462, 977, 2465, 
          1895}, {2942, 2715, 686, 2947, 2941}, {1767, 1957, 1956, 2131, 
          759}},
          VertexColors->None]}]}, 
      {RGBColor[0.8389565553611272, 0.8724505389464926, 0.8798372195960354], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVn9MVmUUvt93P++978XU1i9qsAKGMUtbrhJrUsyy9YXaUBNJiwkSAolT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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQzWUYx3/nnO38Lue4RW5DydoplJCQtGook2vjGla0Vohsgwgb0jTI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          "],
          VertexColors->None], 
         PolygonBox[{{2041, 2502, 998, 2504, 2040}, {2331, 2361, 904, 1685, 
          2330}, {2016, 1804, 1803, 2178, 704}, {2422, 2420, 68, 1861, 
          2421}, {2125, 2124, 2123, 1674, 676}, {2201, 2041, 2040, 2202, 
          790}, {2455, 1629, 974, 2456, 2454}, {2908, 2187, 782, 2768, 
          2907}, {2794, 1985, 687, 1984, 2793}, {3095, 2634, 1129, 1780, 
          3094}, {1914, 2309, 857, 2308, 1913}, {1662, 2422, 2421, 1863, 
          225}, {2181, 2829, 2828, 2186, 782}, {3150, 1812, 1811, 2039, 
          707}, {2630, 1971, 1970, 2633, 1129}, {2453, 2331, 2330, 2449, 
          974}},
          VertexColors->None]}]}, 
      {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlEtIllEQho///11/LV20KQuNcFNhKnYjqCA0SGthq6IIpEWbNLTEFC2K
bBW1qWidubRASisXQRF2g8xuSF6y6AaVhBVRi57hPYv5Zs573pkzM2fOt7Sx
uaEp45xrRbLIEz41yD/sgcC5OeRMnnMTqXPVMTh7O9ENyAEc63POXWZvDHwA
rJb1bnw/RM71xfJtY7+b9SCc+exXsu4E/x069wv5CH4xlb/5FmOfR5rAG/Gr
w2c/+AOw0lj8AvBHoTgj6GbkMfm8TpwrYW8z+Cn42+A3ZpTfc19XCNab+jX1
ZfHtJ5+72E+RDjh3iLMRqcGegzdOjEk4Lfi1IjfAWjLSVssezjwLvgt+J/oV
62H2QuwOzuuBOwQvyuqsvZFqtnptvz8R54edb33BXpOvPloP29k/msj/JH4n
kHvYtb42q+sc2LdId7iEGAuRHvAMeoq4B7F70VeQiTzdzycf/y/Yw0BxNnFO
ne/bPmJtCRSnnHtYldO6Hs72RHmeRjYE6s9V62Wo/leEmiGLP4v+jnRhPwP/
GSh/y7HE51mFrkTaiFdEXoWR8h3zddoM9Pn85/LU77W+51vhluWUxwhSHup+
FqGLQ+VmNdlMWF3T6GWp+tCM39tUse2O7H6sV3am2XbuGDEGA93XOPp6oHMn
6cGCnN7Mikjzavz7xPsTa5bMLz+S75dAc2Z4WaS5sTgO7IivqzDRG7P3NWMz
ktOexbuUyHcKe12kPK2OlbFqeQnWwfo2+dzKqt8zTvPrfHzDbd9m2+au3c/n
MXwrUvG7PM84hh2PhAf0YTVyk/134O9TxX1h7ynVW7F/hM2N5WM5vomVZzX2
LOftyOq9HvJvdjFYbaQZ6E406zbn1+yNJOKsT/VfsPduPZjn+1AKp4j+LLc5
iXUH1n/zS7zvaKL/jr3Tqkg843xGF8SqZRydxrp/m69e36tJsJzHjTvt+YdT
/dfsnzbse239uRDr32F9M79x7/uVeKPUOwTvPz5UvxU=
          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmIV1UUx9/M7733W2bUIiFatWWirBRFETG0TQOrMYwsJbHMwpJGsUzT
XEAyRKIFlUojMiuDkiKzGZXM0Cwno2XSFh23LFxyIcNKrT6fzu+PL+/cd+49
996zfM+9aMyEYU21SZK8DVKwq5gkO8HDyC01SbKwnCTjK0myAGVTIUk+4Pte
liSDkEcwpy5Pkg556Ecy7oruDMbLGO9g/THWFuuSpDf/LwOF+iTpC3Yifwy6
oRvO+Hfka0EL4/fBIuQXQGfO0oj+EHJHcDe6jWAJ8miwEftd0G9D/oc9RyEf
Q7+a8UkwD/1zYAu69WAP8gDm7ENXBz7C/hL+fY9uKONb62NP9zoIniwlyXzw
CvLLYGtdrHHuW2Aoci/uO5a7r+C+wxhPZPwUTh0HDjK/EdzF3GZwJfZPMF6L
/BN4BnkemONe4HH8vZX1a/DvavAOulfBfHQLwD3orgArOe/n4Bx0W/Uxuv6g
J/ZXMN6t/xlfD67O4iyeqbUSe7pXAtZia285gv8j+h7oz+e+c/l1A/8GMncf
WMXc20F3cJj/LZxtEvMnMz4XtNfE+sHYy7A3tzZsuPcB5k9L4gxDsH82Z2zj
f5G5DfXhE33xA7gOXJDFWm0cYu1naew1nT2+5CxH8PF45iwFX4Hf0Ddzng8L
cffToFsWPjgCvjHu2JvB+s1Z5Ki5OZr5Y7A3DtzHv3vBNcqc5zTyMPMV1GZR
D8Z3FbZOpSEP5kzrOcsB9ruEObeBGZXIeXN9DfM+TcNH+uY4a86rxsRY6LPd
+KqJ+a8z7w3Ql3G/ctSa9dWTuReDMcx/DGxO4wzufQp9q7bTmOsac+G0OZpF
TgwglgNLsX4Qc27kbk3o70f3axZ3t+asNX1gbZ9Mw7Y1vhDdYnPUM4OJ4ELQ
A90X2OxYjJqxVurBSvYfwng/8t40aseatVatoRPoz2LcD/ny6t3a0jibZ+zA
/E6lyBVzZhE5cpA1l5ofaeTO3/w7kUYOWbuzsDc7ixqWSxoYD8yCU4yNNWOt
GKM+nHdCJXxtPOQGa8jakSOsxTawPIua3F4Jn+mrsvzD+knEZ1U1/6cgP1qO
3DMHrVV9pq+s2ZGV2NO9JmP/UDE4SS56CP1Y7rqccTvjp63/UnCK+ZUXwvfW
rLVqDBqQ83LkTn/WdKgLjpKb+oLZ3HU6+rWFyHm5903wfBYc/CB3mYKNFtb+
mwWXyFFyk5zyGmsz9m9j/beFqCVjZqysqanoNpQi/tbnukrcwbP/yfqfWb+n
HHeVU4ydNWJtGMPh7LUGvIg8qhr7o2nUpjlg7FrlvCxiOA1bi4qhkxNd+wBn
bk3DRls5OOz/+kI/lLPUMKcHuifAtjw4VS7VJ/YeOVJutAcZazldLjfmcosx
MjZyzNRyNea1wXmLsfcs/7YUokZm5jGnpco/cr0+0RdyvrVYZr8NWdTknEpw
jlyzjjk3M76lEr62hxzGXnspas897IXWlLVkTzyzPnqmvXJTFrG1R9gbjLFc
LYfJXXK2vXtUHr3ZHm0vbebfL2n0VHPpu3L4zpwytu/mUdvG+CruvgP9qUJw
prVnT7AXWINyyWRslvPgFHvfTXnkphxnrk1AX5NHzlmrL/FvWxo1W8b+zFLk
ejP2tzNuL4Ys5w5BHpEH98kPR5m7vxhvk0bW3IntTZzvD2wdz+IscpJc5Jns
9dawtWvPt/daA+a+PbiOtd0r0evsB52RG/LgU2PQhzmfZLGXe8pd1py1JofJ
3bvK4Rs53LN2Bd3SOLN3983jW0cf2Ft8o/g2sccMqoueYa+4I4tcMUfMDXPG
t441Y6345vGtVZ8H1xvPnuw9K49atz/a6+yZyv57BP3XpRjLWXKNe7qXnNMp
jx4lP/lm2wnSLO6q//9C7pXFXbyTb62l2NiexptrWTlqwlqQM7pk0WP1pT3c
t4I92tqwRnoXw+fqzSnfar7hfLv5ZrN3+Ebzbba/2mt8E8yt5qN7+2bwreAZ
5ArfBL4F5Iz/ALWkf9k=
          "],
          VertexColors->None], 
         PolygonBox[{{1768, 2127, 1404, 1328, 397}, {2434, 1686, 1241, 1490, 
          964}, {1638, 1588, 846, 1474, 1227}, {2817, 2124, 758, 1402, 
          1327}, {1950, 2264, 832, 1454, 1350}, {2576, 2267, 1456, 1529, 
          1066}, {2630, 2634, 1543, 1491, 90}, {2125, 1950, 1350, 1266, 
          758}, {2744, 2505, 999, 1526, 1254}, {2267, 2435, 964, 1269, 
          1456}, {2503, 2502, 122, 1232, 1525}, {2861, 2423, 952, 1489, 
          1353}, {2714, 2870, 397, 1268, 1239}, {1567, 2861, 1353, 1455, 
          832}, {1824, 3159, 1524, 1527, 999}, {2056, 3089, 1479, 1480, 716}},
          
          VertexColors->None]}]}}, {{}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{2419, 2257, 2574, 2353, 1663, 2352, 1664, 2427, 1751, 2425, 
          1750, 2426, 1942, 2240, 2110, 2111, 1867, 2437, 1866, 1625, 1568, 
          2576, 2267, 2435, 2434, 1686, 2795, 1985, 2794, 1632, 1577, 3051, 
          2894, 2751, 2148, 2728, 2885, 2685, 2801, 2823, 2983, 2989, 2977, 
          2965, 2971, 2763, 2959, 2953, 3028, 3030, 1982, 2716, 2943, 2714, 
          2870, 1766, 1958, 1768, 2127, 2817, 2124, 2125, 1950, 2264, 1567, 
          2861, 2423, 2420, 2422, 1662, 2424, 1884, 2418, 2419}],
         "10"],
        Annotation[#, 10, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2786, 3146, 2740, 2995, 3001, 2920, 2914, 2691, 3081, 3069, 
          2774, 2841, 2705, 2697, 2028, 2031, 3022, 3019, 2853, 3158, 2858, 
          3089, 2056, 2199, 1712, 2244, 1912, 2222, 1914, 2309, 1606, 2076, 
          2607, 2606, 2315, 1844, 2525, 1836, 2339, 2528, 2670, 2529, 2671, 
          1845, 2650, 2530, 2532, 2531, 1724, 2516, 2517, 2310, 2597, 1607, 
          1648, 1874, 1875, 2063, 2061, 2201, 2041, 2502, 2503, 3159, 1824, 
          2505, 2744, 3150, 1812, 3149, 1806, 3189, 2926, 3140, 2780, 3134, 
          2786}],
         "10"],
        Annotation[#, 10, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2467, 1797, 2468, 1691, 2448, 1774, 2270, 2580, 1573, 1628, 
          2447, 2359, 2361, 2331, 2453, 2667, 1629, 2455, 1971, 2630, 2634, 
          3095, 1786, 2879, 3045, 2876, 3171, 3165, 3057, 2757, 3103, 2722, 
          3109, 3115, 3063, 3177, 2679, 3183, 3075, 3127, 3121, 2734, 2813, 
          2807, 2835, 2829, 2181, 2187, 2908, 3013, 2902, 3003, 1638, 1588, 
          2288, 2025, 1804, 2016, 2015, 1592, 2012, 2014, 1802, 2010, 1801, 
          2174, 2168, 2169, 1871, 1586, 2003, 1579, 1634, 2635, 2636, 2467}],
         "10"],
        Annotation[#, 10, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{2133, 2113, 2112, 1562, 1622, 2327, 2328, 1561, 2354, 1558, 
          1620, 1880, 2409, 2408, 1740, 2406, 1739, 2407, 2569, 1557, 1931, 
          1932, 2091, 2090, 1657, 2402, 1736, 2401, 1735, 1879, 1878, 2405, 
          1738, 2403, 1737, 2404, 1940, 1941, 1863, 2421, 1861, 1621, 1560, 
          2256, 1952, 2109, 1674, 2123, 2816, 2126, 1767, 1957, 1765, 2869, 
          2713, 2942, 2715, 1981, 3029, 3027, 2952, 2958, 2762, 2970, 2964, 
          2976, 2988, 2982, 2822, 2800, 2684, 2884, 2727, 2147, 2750, 2893, 
          3050, 1576, 1631, 2793, 1984, 2157, 1989, 2163, 2160, 1896, 2462, 
          2463, 2266, 2275, 1578, 1990, 2439, 2440, 2438, 2442, 2441, 1891, 
          2132, 2133}],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2785, 3145, 2739, 2994, 3000, 2919, 2913, 2690, 3080, 3068, 
          2773, 2840, 2704, 2696, 2027, 2030, 3021, 3018, 2852, 3157, 2857, 
          3088, 2055, 2198, 1711, 2243, 1911, 2221, 1913, 2308, 2077, 1722, 
          2230, 2231, 1921, 1650, 1610, 2082, 1612, 2610, 2545, 1849, 2340, 
          1850, 2653, 2654, 2652, 1851, 2387, 1727, 2344, 2548, 2655, 2656, 
          2318, 2319, 2320, 2083, 2534, 1846, 2533, 2536, 2535, 2342, 2341, 
          1725, 2383, 2598, 1916, 1915, 2225, 1714, 2205, 1827, 2062, 1826, 
          2202, 2040, 2504, 2042, 1825, 2371, 2586, 2588, 2038, 2295, 2039, 
          1811, 3148, 1805, 3188, 2925, 3139, 2779, 3133, 2785}],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2009, 1693, 2475, 1800, 2474, 1799, 2638, 2365, 2366, 2364, 
          2470, 2469, 2637, 2000, 2001, 2167, 2166, 1690, 2446, 1772, 2269, 
          2579, 1571, 1627, 2137, 2138, 1962, 1683, 2139, 1892, 1893, 1773, 
          2360, 1685, 2330, 2449, 2461, 2452, 2456, 2454, 1970, 2633, 1780, 
          3094, 1785, 2878, 3044, 2875, 3170, 3164, 3056, 2756, 3102, 2721, 
          3108, 3114, 3062, 3176, 2678, 3182, 3074, 3126, 3120, 2733, 2812, 
          2806, 2834, 2828, 2186, 2768, 2907, 3012, 2901, 3002, 1637, 1587, 
          2287, 2024, 1803, 2178, 1698, 2495, 2017, 2299, 2013, 1695, 2175, 
          1694, 2011, 2298, 2009}],
         "5"],
        Annotation[#, 5, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{1553, 2620, 2621, 2619, 1730, 2622, 2623, 2561, 2562, 2563, 
          2345, 2346, 2321, 2322, 1617, 1555, 2349, 2350, 2325, 2326, 1619, 
          1556, 2568, 1937, 1660, 1862, 1882, 1883, 2255, 1951, 2108, 2105, 
          1673, 2121, 1678, 2131, 1956, 1764, 2868, 2712, 2941, 2947, 1980, 
          1976, 3026, 2951, 2957, 2761, 2969, 2963, 2975, 2987, 2981, 2821, 
          2799, 2683, 2883, 2726, 2146, 2749, 2892, 3049, 1575, 1630, 2792, 
          1983, 2156, 1988, 2162, 2159, 1895, 2465, 1788, 2265, 2274, 1991, 
          1687, 2443, 1769, 2268, 2577, 1569, 1626, 2436, 2355, 2356, 2329, 
          2444, 2445, 1770, 2628, 1771, 2629, 1679, 2357, 1680, 2358, 2578, 
          1570, 1959, 2429, 1753, 2428, 1754, 1885, 1623, 2114, 1752}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{1554, 2087, 2237}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{1615, 2234, 2249}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{1616, 1652, 2615, 2614, 1852, 2662, 2663, 2661, 1857, 2389, 
          2390, 2388, 2547, 2546, 2651, 2385, 2673, 2386, 2384, 2527, 2672, 
          2526, 2648, 2649, 2078, 1723, 1877, 1721, 2075, 1835, 2060, 2224, 
          2220, 1910, 2242, 1710, 2197, 2054, 3087, 2856, 3156, 2851, 3017, 
          3020, 2029, 2026, 2695, 2703, 2839, 2772, 3067, 3079, 2689, 2912, 
          2918, 2999, 2993, 2738, 3144, 2784, 3132, 2778, 3138, 2924, 3187, 
          2930, 1810, 2845, 2290, 2294, 2037, 2587, 2585, 2370, 2508, 2506, 
          1701, 2203, 2204, 1907, 1643, 2200, 2046, 2659, 2660, 2557, 1856, 
          2558, 1828, 2206, 2600, 2599, 2645, 2644, 1715, 2245, 1917, 1918, 
          1837, 2064, 1716, 2226, 1919, 2518, 1838, 2311, 2312, 2066, 1717, 
          2065, 1829, 2509, 1830, 2510, 1908, 2207, 1704, 2048, 2297, 1591, 
          1641, 1904, 1816, 2008, 2007, 1585, 1636, 2171}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{1839, 2227, 2067, 2068, 1831, 2303, 2591, 2592, 1644, 2511, 
          2512, 2375, 1705, 2337, 2513, 2642, 1832, 2593, 2594, 2377, 1706, 
          2376, 2379, 2378, 1602, 2191, 2552, 2553, 2551, 1855, 2554, 1905, 
          1906, 1817, 2489, 1818, 2494, 1697, 2177, 2180, 2023, 2286, 2019, 
          1597, 2934, 3007, 3011, 2906, 2767, 2185, 2827, 2833, 2805, 2811, 
          2732, 3119, 3125, 3073, 3181, 2677, 3175, 3061, 3113, 3107, 2720, 
          3101, 2755, 3055, 3163, 3169, 2874, 3043, 2877, 1784, 3093, 1779, 
          2632, 1969, 2458, 1776, 2451, 2460, 2459, 1684, 2117, 2118, 1964, 
          1963, 1572, 1961, 1563, 2261, 2260, 1759, 2433, 1742, 2098, 1758, 
          2625, 2627, 2626, 1668, 2097, 1667, 1944, 2259, 1943, 1666, 2096, 
          1665, 2431, 1756, 2430, 1755, 1887, 1886, 1888, 2575, 2258, 1757, 
          2432, 1681, 2136, 1682, 1960, 2135, 2134, 1996, 1997, 1796, 1999, 
          1998, 1868, 2172, 2173}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2570, 2251, 1741, 1934, 1933, 2092, 2093, 1929, 1654, 2094, 
          1653, 1928, 1860, 2089, 1732, 2238, 1731, 2088, 1859, 2085, 2086, 
          1729, 2391, 2618, 2617}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2608, 2316, 1847, 1922, 1651, 1611, 2317, 2084, 1728, 2232, 
          1924, 1925, 1613, 2233, 1853, 2248, 1926, 1927, 1614, 2235, 2236, 
          1858, 2560, 2665, 2664}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[CompressedData["
1:eJwl1Hloz2EcwPGva2NbIjliNvbPlDFyZKbcjRwxirlN1BiaiBy1yFqaaxRK
rg1F2Go2ZRQyVxFCSk1Tcm1Mk3K/nvzx3vtzPc/zvX7rm7s2e02rKIqS/Enr
EEWbYqKoP2/kHJ6HubgtHxMXRdncjtvifvsoWqA3H5vVR6ht4XT5Iz4SG0U7
eby5Ip7ArzlX/bn4BS6K6/kSN+uVWvs5rOUKtSx7VvF3tVfxZtGADCxJcH1o
Et80lyg+zincDy3qK3i9Wj5HGIqBOK/2Ay3oZC4Oxa7joTwn7Ifr2IBRzm5w
DY36b3kHF+KEeq3rvIYrmGntDKxUz0AP8W9zv/R+ope1J+QnsR/7MMvME71J
5qfxVEzHX1TpX8YH8XsMtj6VP+ITmtCIZDN9cAd12GHui/oI/hzWOaOv+vXw
bsWrMURvDqdhAAr0CtVmo7U1k+U9rTmH84gP7wiV6mf5Ah/kZPPtuKNnmupZ
zeIUvosa+37VT1ArEu9BN/Wn4dlzjHqheLF4OapRgUq1LL16zuSXPJZX6a3j
Au5s30RudvY3tMhHu6beYdb1P0CZvA+X80RO0vtl7oy8xJqz/Fv+RzxW/Fd8
2Vx1ePboLq/htbzbzB48Fz/DIPPLwnn6icjESHRzRle8NdvG3Cm1I+YeiCPk
YxVu6B9Wvyf+yXnh2zC7ggv0/qjdCrPiPMx0rwPVJvE7TEGtc5bqneZx8s3c
FH6b4nKcwzGU4nB4J3olXITH4f3Y/yq2i7fiUPgu+I1zytSz7b07nMnFnMlH
w/2LD/A2HqY2PHzL8r1IF+/ixe5lCRZhIbqgzvxSZ+QiBrFx///n/ANTaZsa

          "]],
         RowBox[{"-", "5"}]],
        Annotation[#, -5, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{2550, 2252, 2571, 2410, 1744, 2324, 1745, 2417, 1748, 2253, 
          1747, 2416, 1938, 2103, 2104, 1947, 2106, 1671, 2119, 1676, 2129, 
          1954, 1762, 2866, 2710, 2939, 2945, 1978, 1974, 3024, 2949, 2955, 
          2759, 2967, 2961, 2973, 2985, 2979, 2819, 2797, 2681, 2881, 2724, 
          2144, 2150, 2890, 3047, 2887, 1581, 2896, 2152, 2154, 1986, 1789, 
          1898, 1633, 2151, 1992, 1994, 1854, 1901, 2276, 2277, 2164, 2165, 
          1870, 2281, 1869, 2002, 2170, 2004, 1590, 2296, 2283, 1813, 2480, 
          1902, 2483, 1814, 2477, 2482, 2481, 2043, 1600, 2372, 2613, 2374, 
          2335, 2368, 2367, 1598, 2035, 1589, 2292, 2843, 1808, 2928, 3185, 
          2922, 3136, 2776, 3130, 2782, 3142, 2736, 2991, 2997, 2916, 2910, 
          2687, 3077, 3065, 2770, 2837, 2701, 2693, 3083, 2033, 2742, 3015, 
          2849, 3154, 2854, 3085, 2052, 1822, 2195, 1708, 2214, 2216, 2058, 
          2213, 2211, 1647, 1605, 2304, 2305, 1720, 2515, 1719, 2523, 2524, 
          2522, 2646, 1842, 2668, 2521, 2666, 2520, 2338, 1718, 2519, 1840, 
          2314, 2601, 2602, 2069, 1604, 1645, 1909, 1872, 2300, 1603, 2049, 
          2496, 2497, 2491, 2501, 2499, 2847, 2815, 2021, 1595, 2932, 3005, 
          3009, 2904, 2765, 2183, 2825, 2831, 2803, 2809, 2730, 3117, 3123, 
          3071, 3179, 2675, 3173, 3059, 3111, 3105, 2718, 3099, 2753, 3053, 
          3161, 3167, 2872, 3041, 3038, 3035, 1782, 3097, 2708, 2141, 1778, 
          2864, 2273, 1574, 1965, 1565, 1624, 1889, 1864, 1564, 1946, 2412, 
          2413, 2411, 2415, 2414, 1881, 2549, 2550}],
         RowBox[{"-", "10"}]],
        Annotation[#, -10, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{3141, 2781, 3129, 2775, 3135, 2921, 3184, 2927, 1807, 2842, 
          2291, 1639, 3147, 3090, 3091, 2334, 3151, 2612, 1640, 2611, 3190, 
          2787, 2639, 2476, 2479, 2478, 1692, 2473, 1798, 2284, 2583, 2282, 
          2472, 2471, 1794, 3128, 1793, 2280, 2279, 1583, 2899, 2900, 1791, 
          2898, 2158, 2895, 1580, 2886, 3046, 2889, 2149, 2143, 2723, 2880, 
          2680, 2796, 2818, 2978, 2984, 2972, 2960, 2966, 2758, 2954, 2948, 
          3023, 1973, 1977, 2944, 2938, 2709, 2865, 1761, 1953, 2128, 1675, 
          2122, 2747, 1949, 3033, 1566, 2936, 1559, 3032, 2254, 2791, 2100, 
          2099, 2239, 2699, 2573, 2572, 3031, 1746, 3092, 2706, 1865, 2860, 
          2859, 2937, 2862, 2272, 2863, 2142, 2140, 2707, 3096, 1781, 3034, 
          3037, 3040, 2871, 3166, 3160, 3052, 2752, 3098, 2717, 3104, 3110, 
          3058, 3172, 2674, 3178, 3070, 3122, 3116, 2729, 2808, 2802, 2830, 
          2824, 2182, 2764, 2903, 3008, 3004, 2931, 1594, 2020, 2814, 2846, 
          2498, 2500, 2490, 2788, 2050, 2745, 1873, 2746, 2051, 1833, 2313, 
          1834, 2071, 2070, 2698, 2072, 2073, 2790, 2307, 2595, 2596, 1646, 
          2210, 2212, 2057, 2789, 2217, 1707, 2194, 2935, 1820, 3152, 1821, 
          3153, 2848, 3014, 2741, 2032, 3082, 2692, 2700, 2836, 2769, 3064, 
          3076, 2686, 2909, 2915, 2996, 2990, 2735, 3141}],
         RowBox[{"-", "15"}]],
        Annotation[#, -15, "Tooltip"]& ]}, {}, {}}}], {{1, 0}, {0.2, 1}}],
  PlotRange->All]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{184, 214},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146136128]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24664699],

Cell[TextData[{
 Cell[BoxData["WeierstrassHalfInvariants"], "InlineFormula"],
 " is effectively the inverse of ",
 Cell[BoxData[
  ButtonBox["WeierstrassHalfPeriods",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassHalfPeriods"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->17441655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WeierstrassInvariants", "[", 
   RowBox[{"WeierstrassHalfPeriods", "[", 
    RowBox[{"{", 
     RowBox[{"I", ",", 
      RowBox[{"1.", "-", "I"}]}], "}"}], "]"}], "]"}], "//", " ", 
  "Chop"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->930812],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.999999999999998`", " ", "\[ImaginaryI]"}], ",", 
   RowBox[{"1.0000000000000022`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.000000000000001`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1074992]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20612712],

Cell["\<\
Assignment of invariants corresponding to symbolic or exact \
half\[Hyphen]periods is impossible as the right\[Hyphen]hand side is not a \
list:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->295104909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"g2", ",", "g3"}], "}"}], "=", 
  RowBox[{"WeierstrassInvariants", "[", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", "\[Omega]3"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373510320],

Cell[BoxData[
 RowBox[{
  RowBox[{"Set", "::", "\<\"shape\"\>"}], ":", 
  " ", "\<\"Lists \\!\\({g2, g3}\\) and \\!\\(WeierstrassInvariants[\\(\\({\
\[Omega]1, \[Omega]3}\\)\\)]\\) are not the same shape. \\!\\(\\*ButtonBox[\\\
\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Set/shape\\\", ButtonNote -> \
\\\"Set::shape\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->155992579],

Cell[BoxData[
 RowBox[{"WeierstrassInvariants", "[", 
  RowBox[{"{", 
   RowBox[{"\[Omega]1", ",", "\[Omega]3"}], "}"}], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380206589]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13516],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassP"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseWeierstrassP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseWeierstrassP"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KleinInvariantJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KleinInvariantJ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassHalfPeriods",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassHalfPeriods"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7354]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9375],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->5580]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->27916],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/WeierstrassEllipticFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/WeierstrassInvariants/\
"], None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->574231007],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->169900059]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WeierstrassInvariants - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 24.7272304}", "context" -> "System`", 
    "keywords" -> {
     "invariants", "Weierstrass elliptic function", "Weierstrass invariants"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "WeierstrassInvariants[{\\[Omega], \\[Omega]^\\[Prime]}] gives the \
invariants {g_2, g_3} for Weierstrass elliptic functions corresponding to the \
half-periods {\\[Omega], \\[Omega]^\\[Prime]}. ", 
    "synonyms" -> {"weierstrass invariants"}, "title" -> 
    "WeierstrassInvariants", "type" -> "Symbol", "uri" -> 
    "ref/WeierstrassInvariants"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5709, 188, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->409871808]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 112716, 2244}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2244, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2867, 82, 59, 1, 70, "ObjectName",
 CellID->13633],
Cell[2929, 85, 1215, 39, 70, "Usage",
 CellID->1722]
}, Open  ]],
Cell[CellGroupData[{
Cell[4181, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4659, 146, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4782, 152, 366, 12, 70, "Notes",
 CellID->17222],
Cell[5151, 166, 274, 8, 70, "Notes",
 CellID->804736039],
Cell[5428, 176, 244, 7, 70, "Notes",
 CellID->31226]
}, Closed]],
Cell[CellGroupData[{
Cell[5709, 188, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->409871808],
Cell[CellGroupData[{
Cell[6094, 202, 147, 5, 70, "ExampleSection",
 CellID->61599663],
Cell[6244, 209, 200, 5, 70, "ExampleText",
 CellID->82870859],
Cell[CellGroupData[{
Cell[6469, 218, 186, 6, 28, "Input",
 CellID->287333899],
Cell[6658, 226, 237, 7, 36, "Output",
 CellID->217752987]
}, Open  ]],
Cell[6910, 236, 125, 3, 70, "ExampleDelimiter",
 CellID->317394759],
Cell[CellGroupData[{
Cell[7060, 243, 380, 12, 28, "Input",
 CellID->535319250],
Cell[7443, 257, 3957, 70, 166, "Output",
 Evaluatable->False,
 CellID->157571005]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11449, 333, 220, 7, 70, "ExampleSection",
 CellID->273582334],
Cell[11672, 342, 207, 5, 70, "ExampleText",
 CellID->114757376],
Cell[CellGroupData[{
Cell[11904, 351, 243, 8, 70, "Input",
 CellID->152570203],
Cell[12150, 361, 405, 12, 54, "Output",
 CellID->136048726]
}, Open  ]],
Cell[12570, 376, 124, 3, 70, "ExampleDelimiter",
 CellID->87778528],
Cell[12697, 381, 113, 3, 70, "ExampleText",
 CellID->396280068],
Cell[CellGroupData[{
Cell[12835, 388, 210, 6, 70, "Input",
 CellID->15003901],
Cell[13048, 396, 328, 10, 36, "Output",
 CellID->11155872]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13425, 412, 227, 7, 70, "ExampleSection",
 CellID->216834343],
Cell[13655, 421, 234, 5, 70, "ExampleText",
 CellID->111168518],
Cell[CellGroupData[{
Cell[13914, 430, 1740, 48, 70, "Input",
 CellID->154412271],
Cell[15657, 480, 89433, 1497, 70, "Output",
 CellID->146136128]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[105139, 1983, 236, 7, 70, "ExampleSection",
 CellID->24664699],
Cell[105378, 1992, 440, 13, 70, "ExampleText",
 CellID->17441655],
Cell[CellGroupData[{
Cell[105843, 2009, 278, 9, 70, "Input",
 CellID->930812],
Cell[106124, 2020, 422, 13, 36, "Output",
 CellID->1074992]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[106595, 2039, 229, 7, 70, "ExampleSection",
 CellID->20612712],
Cell[106827, 2048, 332, 9, 70, "ExampleText",
 CellID->295104909],
Cell[CellGroupData[{
Cell[107184, 2061, 254, 8, 70, "Input",
 CellID->373510320],
Cell[107441, 2071, 435, 8, 70, "Message",
 CellID->155992579],
Cell[107879, 2081, 317, 10, 36, "Output",
 CellID->380206589]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[108257, 2098, 311, 9, 70, "SeeAlsoSection",
 CellID->13516],
Cell[108571, 2109, 1012, 35, 70, "SeeAlso",
 CellID->7354]
}, Open  ]],
Cell[CellGroupData[{
Cell[109620, 2149, 313, 9, 70, "TutorialsSection",
 CellID->9375],
Cell[109936, 2160, 191, 4, 70, "Tutorials",
 CellID->5580]
}, Open  ]],
Cell[CellGroupData[{
Cell[110164, 2169, 321, 9, 70, "RelatedLinksSection",
 CellID->27916],
Cell[110488, 2180, 198, 4, 70, "RelatedLinks"],
Cell[110689, 2186, 209, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110935, 2195, 319, 9, 70, "MoreAboutSection",
 CellID->574231007],
Cell[111257, 2206, 147, 3, 70, "MoreAbout",
 CellID->169900059]
}, Open  ]],
Cell[111419, 2212, 27, 0, 70, "History"],
Cell[111449, 2214, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

