(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    139128,       3284]
NotebookOptionsPosition[    130249,       2979]
NotebookOutlinePosition[    131693,       3019]
CellTagsIndexPosition[    131606,       3014]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WeierstrassP" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassP"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"WeierstrassP\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WeierstrassPPrime", "ObjectName",
 CellID->22070],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["WeierstrassPPrime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WeierstrassPPrime"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["g", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["g", "TI"], 
           StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the derivative of the Weierstrass elliptic \
function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[WeierstrassP]", "(", 
        RowBox[{
         RowBox[{"u", ";", 
          SubscriptBox["g", "2"]}], ",", 
         SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[WeierstrassP]", "\[Prime]"], 
     RowBox[{"(", 
      RowBox[{"u", ";", 
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], ")"}]}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[PartialD]", "/", "\[PartialD]", "u"}], ")"}], 
     "\[WeierstrassP]", 
     RowBox[{"(", 
      RowBox[{"u", ";", 
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->30942],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["WeierstrassPPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassPPrime"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->223798420],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassPPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassPPrime"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->292727847],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->150230246],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->38654821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassPPrime", "[", 
  RowBox[{"2.", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->125018082],

Cell[BoxData[
 RowBox[{"8.396551140167125`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249951942]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90816760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"WeierstrassPPrime", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82266961],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{223, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->339163921]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->388072707],

Cell["Series expansion:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->10191991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"WeierstrassPPrime", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173331649],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["2", 
     SuperscriptBox["z", "3"]]}], "+", 
   FractionBox[
    RowBox[{"g2", " ", "z"}], "10"], "+", 
   FractionBox[
    RowBox[{"g3", " ", 
     SuperscriptBox["z", "3"]}], "7"], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["g2", "2"], " ", 
     SuperscriptBox["z", "5"]}], "200"], "+", 
   RowBox[{
    FractionBox["3", "770"], " ", "g2", " ", "g3", " ", 
    SuperscriptBox["z", "7"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       SuperscriptBox["g2", "3"], "15600"], "+", 
      FractionBox[
       RowBox[{"5", " ", 
        SuperscriptBox["g3", "2"]}], "5096"]}], ")"}], " ", 
    SuperscriptBox["z", "9"]}], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["g2", "2"], " ", "g3", " ", 
     SuperscriptBox["z", "11"]}], "15400"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "13"],
    SeriesData[$CellContext`z, 0, {}, -3, 13, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {-2, 0, 0, 0, Rational[1, 10] $CellContext`g2, 0, 
    Rational[1, 7] $CellContext`g3, 0, Rational[1, 200] $CellContext`g2^2, 
    0, (Rational[3, 770] $CellContext`g2) $CellContext`g3, 0, 
    Rational[1, 15600] $CellContext`g2^3 + 
    Rational[5, 5096] $CellContext`g3^2, 
    0, (Rational[1, 15400] $CellContext`g2^2) $CellContext`g3}, -3, 13, 1],
  Editable->False]], "Output",
 ImageSize->{509, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->377343697]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->558424070],

Cell["Evaluate for complex arguments and invariants:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->542166696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassPPrime", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"{", 
    RowBox[{"I", ",", 
     RowBox[{"1", "-", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62404871],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2.9897301938094745`"}], "+", 
  RowBox[{"0.14509597231090568`", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374262885]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->459573364],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->38712691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"WeierstrassPPrime", "[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->457580715],

Cell[BoxData[
 RowBox[{"8.\
396551140167088868834245673131795861327058412465562191339953272637`50.\
15051499783199", "+", 
  RowBox[{"0``49.22641406038499", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{440, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38158366]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->293425699],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->354628230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassPPrime", "[", 
  RowBox[{"2.000000000000000000000000", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70266597],

Cell[BoxData[
 RowBox[{"8.39655114016708886883424567308792482642`22.369743014278043", "+", 
  RowBox[{"0``22.190460472281856", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157713000]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15161106],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassPPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassPPrime"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists in its first argument:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->303104344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassPPrime", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->452701008],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"WeierstrassPPrime", "[", 
    RowBox[{"u1", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], ",", 
   RowBox[{"WeierstrassPPrime", "[", 
    RowBox[{"u2", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{452, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66789971]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->563694966],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassPPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassPPrime"]], "InlineFormula"],
 " automatically evaluates to simpler functions for certain parameters:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->356873801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassPPrime", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"-", "8"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26066663],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "6"}], " ", 
  SqrtBox["3"], " ", 
  RowBox[{"Coth", "[", 
   SqrtBox["3"], "]"}], " ", 
  SuperscriptBox[
   RowBox[{"Csch", "[", 
    SqrtBox["3"], "]"}], "2"]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{189, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->256100572]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->195637960],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->56507263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WeierstrassPPrime", "[", 
   RowBox[{"z", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["g", "2"], ",", 
      SubscriptBox["g", "3"]}], "}"}]}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->334742989],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    TagBox["\[WeierstrassP]",
     WeierstrassPPrime], "\[Prime]"], "(", 
   RowBox[{
    RowBox[{"z", ";", 
     SubscriptBox["g", "2"]}], ",", 
    SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->448077763]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->418720937],

Cell["\<\
Conformal map from a triangle to the upper half\[Hyphen]plane:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->227466203],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"w", "[", "z_", "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], "+", 
    RowBox[{
     FractionBox["27", "2"], " ", 
     RowBox[{
      RowBox[{"WeierstrassPPrime", "[", 
       RowBox[{
        RowBox[{"z", "-", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "3"]]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "729"]}], " ", 
           SuperscriptBox[
            RowBox[{"Beta", "[", 
             RowBox[{
              FractionBox["1", "3"], ",", 
              FractionBox["1", "3"]}], "]"}], "6"]}]}], "}"}]}], "]"}], "/", 
      SuperscriptBox[
       RowBox[{"Beta", "[", 
        RowBox[{
         FractionBox["1", "3"], ",", 
         FractionBox["1", "3"]}], "]"}], "3"]}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->400108590],

Cell[BoxData[
 RowBox[{
  RowBox[{"triangle", "[", "\[Tau]_", "]"}], ":=", 
  RowBox[{"Join", "@@", 
   RowBox[{"Apply", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"#1", "+", 
         RowBox[{
          RowBox[{"k", "/", "12"}], 
          RowBox[{"(", 
           RowBox[{"#2", "-", "#1"}], ")"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "0", ",", "12"}], "}"}]}], "]"}], "&"}], ",", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Tau]"}], ")"}], 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "6"]], "/", 
            SqrtBox["3"]}]}], "+", 
          RowBox[{"\[Tau]", "#1"}]}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "3"]], ",", "0"}], 
         "}"}]}], ",", "2", ",", "1"}], "]"}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->347162714],

Cell["Map a triangle:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->279142526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Hue", "[", "h", "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Re", "[", "#", "]"}], ",", 
               RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
            RowBox[{"triangle", "[", "h", "]"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"h", ",", "0", ",", "1", ",", 
          RowBox[{"1", "/", "50"}]}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Hue", "[", "h", "]"}], ",", 
           RowBox[{"Point", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Re", "[", "#", "]"}], ",", 
                RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
             RowBox[{"Select", "[", 
              RowBox[{
               RowBox[{"N", "[", 
                RowBox[{"w", "[", 
                 RowBox[{"triangle", "[", "h", "]"}], "]"}], "]"}], ",", 
               "NumberQ"}], "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"h", ",", "0", ",", "1", ",", 
           RowBox[{"1", "/", "50"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]}], "}"}], "//",
    "Quiet"}], "//", "Row"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28071203],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{360, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->371174365]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119834783],

Cell[TextData[{
 "Uniformization of a generic elliptic curve ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "2"], "\[Equal]", 
    RowBox[{"f", "(", "x", ")"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "0"], 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"4", 
      SubscriptBox["a", "1"], 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"6", 
      SubscriptBox["a", "2"], 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"4", 
      SubscriptBox["a", "3"], "x"}], "+", 
     SubscriptBox["a", "4"]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->746489349],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a0", ",", "a1", ",", "a2", ",", "a3", ",", "a4"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "2", ",", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"a0", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"4", " ", "a1", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"6", " ", "a2", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"4", " ", "a3", " ", "x"}], "+", "a4"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->831380291],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"roots", "=", 
   RowBox[{"x", "/.", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], "]"}]}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{"z0", "=", 
  RowBox[{"roots", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->260055584],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "-", 
  SqrtBox["3"]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{56, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->310925231]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[ScriptG]2", ",", "\[ScriptG]3"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a0", " ", "a4"}], "-", 
      RowBox[{"4", " ", "a1", " ", "a3"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a2", "2"]}]}], ",", 
     RowBox[{
      RowBox[{"a0", " ", "a2", " ", "a4"}], "+", 
      RowBox[{"2", " ", "a1", " ", "a2", " ", "a3"}], "-", 
      SuperscriptBox["a2", "3"], "-", 
      RowBox[{"a0", " ", 
       SuperscriptBox["a3", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a1", "2"], "a4"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->210647137],

Cell["The parametrized uniformization:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->34638874],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"x", "[", "z_", "]"}], "=", 
   RowBox[{"z0", "+", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "'"}], "[", "z0", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"4", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"WeierstrassP", "[", 
          RowBox[{"z", ",", 
           RowBox[{"{", 
            RowBox[{"\[ScriptG]2", ",", "\[ScriptG]3"}], "}"}]}], "]"}], "-", 
         
         RowBox[{
          RowBox[{"1", "/", "24"}], 
          RowBox[{
           RowBox[{"f", "''"}], "[", "z0", "]"}]}]}], ")"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", "z_", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"f", "'"}], "[", "z0", "]"}]}], 
    RowBox[{
     RowBox[{"WeierstrassPPrime", "[", 
      RowBox[{"z", ",", 
       RowBox[{"{", 
        RowBox[{"\[ScriptG]2", ",", "\[ScriptG]3"}], "}"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"4", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"WeierstrassP", "[", 
           RowBox[{"z", ",", 
            RowBox[{"{", 
             RowBox[{"\[ScriptG]2", ",", "\[ScriptG]3"}], "}"}]}], "]"}], "-",
           
          RowBox[{
           RowBox[{"1", "/", "24"}], 
           RowBox[{
            RowBox[{"f", "''"}], "[", "z0", "]"}]}]}], ")"}], "^", "2"}]}], 
      ")"}]}]}]}], ";"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->236091838],

Cell["Check the correctness of the uniformization:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->338900051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", "[", "1", "]"}], "]"}], "-", 
   RowBox[{
    RowBox[{"y", "[", "1", "]"}], "^", "2"}]}], " ", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->507630505],

Cell[BoxData["0"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->110661840]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->670664305],

Cell["Define Dixon trigonometric functions:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->166746512],

Cell[BoxData[
 RowBox[{
  RowBox[{"cm", "[", "z_", "]"}], ":=", 
  FractionBox[
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"WeierstrassPPrime", "[", 
      RowBox[{"z", ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"1", "/", "27"}]}], "}"}]}], "]"}]}], "+", "1"}], 
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"WeierstrassPPrime", "[", 
      RowBox[{"z", ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"1", "/", "27"}]}], "}"}]}], "]"}]}], "-", "1"}]]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->33065910],

Cell[BoxData[
 RowBox[{
  RowBox[{"sm", "[", "z_", "]"}], ":=", 
  FractionBox[
   RowBox[{"6", " ", 
    RowBox[{"WeierstrassP", "[", 
     RowBox[{"z", ",", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", " ", 
        RowBox[{"1", "/", "27"}]}], "}"}]}], "]"}]}], 
   RowBox[{"1", "-", 
    RowBox[{"3", " ", 
     RowBox[{"WeierstrassPPrime", "[", 
      RowBox[{"z", ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"1", "/", "27"}]}], "}"}]}], "]"}]}]}]]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->101170414],

Cell[TextData[{
 "These functions are cubic generalizations of ",
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->172970446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sm", "'"}], "[", "z", "]"}], " ", "==", " ", 
     SuperscriptBox[
      RowBox[{"cm", "[", "z", "]"}], "2"]}], " ", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"cm", "'"}], "[", "z", "]"}], " ", "==", " ", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"sm", "[", "z", "]"}], "2"]}]}], " ", ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"cm", "[", "z", "]"}], "3"], "+", 
      SuperscriptBox[
       RowBox[{"sm", "[", "z", "]"}], "3"]}], "==", "1"}]}], "}"}], "/.", 
  RowBox[{"z", "\[Rule]", "1.5"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->212194834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->416532606]
}, Open  ]],

Cell["Plot the Dixon trigonometric functions:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->335101019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"cm", "[", "z", "]"}], ",", 
     RowBox[{"sm", "[", "z", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{"-", "3"}], "Pi"}], ",", 
     RowBox[{"3", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->680306295],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydXF2sHVUVPtx7zrn3UvoDtPRSUOoPCmipVOCNYELUIFHwgahpeABiAg/y
Z0lMTQioAR4wIEikCWmNVUyFhyIEUWqCEklJGkgIIIEaLZEACYiBaGwkuX57
f3vWt2fNmnNPbdrbM+fOrPV962+vvWfPfPnybVd981uXb7v6yss3fvGGy6+7
6uorv73xC9fegK9mjxoMBofw747FAT4v4VP+d2hpCf9fl37OpuP8Z3DNhG8/
lH6Od+08gP8fvus3L+0/iA8Hdj5+bvp+7vf7Dh469O6/3//Prm278cXBfc++
e+itwRon6aP53MOHP/jFz58zMYff//fzv3pyQDkP733xnXf+9fpf3vrlLQ/h
ixf3/ulf77w3mK8QnH/eDvx/z9fvfPD2h/Fhx3nX5ytHt9365G8ee/kvz7/2
o899J30xA2yx/jfeeO9rlz5gQt57450HLv1+0X/tNY889+zrf9iz/84vfQ9f
PHLNva8/+2qtf87px6UQMDhnIoYZQPhYvhrCoSLWffVVe1984c1Y98np5zxM
89WLd3fVT9betYBD8cHh/95/wY0FBUwDAxmKx7bteG3/n1sonP3aKOZu3PbY
M/tfMxTw4FN3PNgTCU/98a/f3f5b584Yx5O3/vLlx55ZBsfeq+5684W/nVN5
0nDgYojowQGzwXhT4Xj67r0pWmsccBpcV19N1xHHlVc89Oorb3scCw7HMMI1
38W1++KbkBD0NyPRkGV/17iclx0u8jJcf/3j87/dvnNKXMjSH97xVF8cHjmu
fTf/DBUjxAW8QD2YwcchYAxms6D8J2XVKMA3gyI1GHfRnZ21v//+4Ysu3FUD
hD/h1Rph1+4MPyLE5RDiEc5VSBK6BCAdxojoibPbcWyIGCTTI6LFDRFK756t
t+UYnSlIuj685+6nH/zV832YELII3ImYxt0oSJ4OEZU6NxkR61ctj8Xn7HbU
GCL8CicIUdfK9Cyvt9ppoFj2pot4VrWu/fuwMShqD3btTYtmCSOLAaLL8T6Y
RRUqKFaFqFjj+lBZzBgqBkaNqmtzJCLSkaiMVwsVa1AvqvFlW/egF/Bx0YeJ
oVFj6tqa1iQm/AoneEzM8H5MrCohphGakR33PWOYOrYfV9i6Fq+xGbsWtoeu
uOPtV/7eYLNeYJ51JI6IHMuz02HqcqNNJ2FirvdHFvO3L1otllvoFBfTojOW
LWwYhzAaRdg+kn4sWCZ33TAgPovqFj7FSIVv5Jh2LL2lFydzrR+n5XSNE/0J
upSC06KphZNdjHCelD+ia/78BffX0nj2rgu3o4NukFbcW1jZtvRjtUzvOqpg
ZR/jsSqOaqxd5t4DW9r8W1if+/m+Z+57tB+rVYAaa+lhidViroVV/qqxWvfm
sIoZsbI791iZFb1Yx5Z9TrpyhdLhWjjYI4YZYAyPuMvf582WthVaiJkoDeKZ
0qEMxlYFnVQMGBg20sezOnFIsN5rNdY+/pgTYGYQ8G9hRdlE8ey3LgBzJtnr
O2K2bsZhlvdqzH2WEMOuJQib58GxcG8/astQJ59dsOTXOVmjZt/jUVtNdlLF
sWsLos4t9SyyBzmUPq4MUVuuOvmqLGd1PF6jli9r1Jj+YRLYlSqOlFrHfI1a
FSVGbb3IMr6E6WDALmqUVhRYj9pqoZMqjl1b1KgVnzFq6wyW8WUd/0TtfTmq
UPdJVbwmqWms4/fVSoKLT496Yz62cZnnj602LzXD85aOz2vUqjREvYEeaLKs
oDCpAz/+fWbJZ1dtc8VpQp/qXrb1rNX/ADUHwC0dn9eoVXVr1Ag6hF4/ao3x
RG09r0PN5ZN+m/9+38Fbbt4Xo+eQuKXj+xq9rFKjt2zrQa9IIPo6y2r0Gmti
9FZpe/QouzfnY5u7l99Xawz5mPM9z8Zyu0eLbLA5jDifB4yKflYWgT36FDGb
owjssOLSjGdl9b5Hi2oFtVjd77DyNSMdD4O1FbKzPmhKa1oN7GHHOalnZ6NN
jxZV2s1RHnTYaQ5Wz+8HvSwtX3r0Ky+p3ypxh6W37rBiuZwWjT6xFs8SeVmt
jc06Zn5l45R8rKo9G2LghEUYrHr3MFUVJ9MTl9Hix/EzQy2eqTLdryU10fvh
fKBKFrPzFgZIQO1npzlEzc7WsXvYqV6SnXXmPexUNyN2XR+qwsX6Ff2b8rHq
6GzIUtatWSr6Yi3qqTaFPvcsZft8PBSrblae4qJiOTtvCv3iecrONc/ltOgq
alHt8TyHLiPS76P1T7JTNYj1yitJb+rThiErFBrYFT9brJaTrqvISuNLzEqZ
sMKxYebZGkA53+tTBac+VXzvK16vnpm3ABbzR41qXou/6tP52Lq4HlZc/exn
pdEs1qdu9FOM8cMfwPD4OfC+GjY+Lb2AWCXPjgLpacWSLJS/w5CFMitmgXBF
0PazUB6Rhc1EOyyOrnyhziCWKo9Tqt0/6LAYOd8lLYnEhxqboq7ABoPISrUP
qUd1K0a/3sWrl8pjjVBn5GPr2HvQqxoe7XxAFhqZYhbKR7LQmDGJhTrqmIVW
lE5vIgm2TPE5CllobhizUK8b6+MdHOlTJI0msFCWxlLVM1Kqxj/PYuwiyd/t
OdlF1DjUpw6c+hC2CN5+Fifkb9XXe6ke1Wkha89CHX3MQvkUs0AsIYjTforT
QtYxC9WKmIVs88mQtWchFDELWSHWp/nFJ53vYxbr8rfoRZBAKc7nQqlCRanq
ATwLXq+xeN6xyGstVecR64Mm6EvZTX3K7kksNCZ7qR7VqflYo+NcyEKsmzuz
3gexHvng1JCtR782f3vo0LsQnHwwH0oFGowPad/Qqc4HHv28Y1vfe08fNzhU
sT754ONNPiByQbycH7MQKi913uVDvstXVbz5kIVYxyzki0hf6gmIXpU/Rn98
/lajzoKTxmOtTaTjBGads82CY7HgWPve9kSHzus1K6Cip51U6dJTXM4uhIyO
a5BdtnUPkqeMUJ4RvAzJ6IgGxzhk6frUax3tGPFYPZCfiyy6aI71orSXefOM
u/5kF0eT2Gmk8Vp4rDGhmff6Wf6xIVrPFvZBFCb7x2zV24U4RlYRMvamU1O3
fHTIkdg0f1rhZPNYMw3fg6xpIgDcwLCcL24rGk/Us7zqet8zef3khtjE9WW5
1mokIg5a0+i5IuS2xp11TMhNdm8qMPNUfZXnRDmqwM2cklzgJFSb5OdYX6oz
/GOdD87HVeV8z2J1cxaqBipZWfGUVF4F28BCqZL6Gnasi4NjHBvKUyfkc4XV
B/aDFVOOx/pxfskCjr4aJyex0lleKo/b40uyMX2KKoh0SDZeGbJBxYFP06ga
s9FMN9Kb9GxwVlsZsljlsmeVk7bKZc96Z8tVDn0+HpkvS7SzC9QcymshNpyP
Vj/tV110cbgqxL7SnbU6xA6pqKGYNxbsspzHnq8falW2GbfUA8Qa4CVoSPlH
nhhz4NtkndUh7mOcDdc4qbwK8hABaczxfdtqh5vX8254svZaF2GxfOWbj6hJ
qDVj9VJ5rDp5vIusNSFq1sWB1SxZ5dhQvsaq451V1oSoD+U6ZbMEwunMGqxD
LUv6fozI49lQo/mAZ8zZGfgj5H70y91JWZkkf9/v23HxiP99ljiq784PGgyd
dV2/Rua0jO3Y0i3Em+IHX6lz0u9zdzaUpYt9y3mKu+WsnLuToY2Mg6YaKRKX
t+TxzRllTzRjV7NYXz29Zb3NVnX8quwmOmZ3ZP941jVfXZWiY63TSAbUkqSW
em5xzd8rb46rbMARnFfAZEjOZHevwe8gsXsyJdqY2Rqf14Y85pqzyli/zmlZ
66SucJ5YG/EYGarypAKvgp1gLdisR4tfYZW1JmHXKoSXus5JZeRqZFkXYVcm
WQO20NiozHNOCPWo71pwNloXomdcqcP0UnmsVbk5Z8MTIvStGMfoCPunsYbR
qnlFrEszPOrSjPCEkAHzWOPoeieVx362hIoKBqknXx8w0N1JxA0KWYq5sYsG
r4fowBNsU0fA8+Ep+Dn11+tD9Oz4gQPoUzQshuihH2ZJz7kMG/SQmqJgMbJ/
pwZpZOP1WpOK9anrHzb+hr5UYRZDFqc4KYsNatgioZ5pUHOIL3PuftRDh5rX
q988MdQHvNCXUM841CdOhTqfNQZ3hiCNjKK1YRm0HEGBFkEGzjAuYDadvpNO
jIgPuJzgNkyFLZ+VxrOHvvWTmy65E64/aRlUZU328QP3fOUHP779iTKf8hKB
52ffuH371+8DkpOOwEowDioGUujJu3/NvULTWQl5+rVLH3j0p39CfKXnlGIr
obKgoH7vpt89ccsv4AyAjK00bDigQUWcwXVh9g8Rc6iCX714Nwpdjo0Rdw3A
FXBbipioCnTGtRWo2vDuZVv3IFt5Gx4qUXJ3X3wTSmTqM3w+5aowgrVAHJQA
AcMEpY0QYw9c+n0EDT6k+hhXCPaHaL9Rh3ZduB2qxqmrTfMm1ORUaeI5J0IE
bEE7b40cjKD6/PN2IAExJNj9lCHqGwQBxo7zrs9yh1BzYOfjKJYINj8b5jGY
IxXh/txOpVqZVaBDhQKEBEoLopv+Ru8BlDA15Ke92sTOUSrN9WPssPOunQdS
N52xDyH3ogt3wegwHjtE4ENgwB73X3AjZRJ3Gufj2ShHH+DBKemsRD1nLTyH
YNyz9bZUqeIVFsQP2OEvSMN8eetrtkOJjnTVOMkbQwZQwKfwE1jChuF61gjX
okjAJ/gJN+UWK3de+B9/4byVTU1r4eWcH2BLXxvjBUaIhitgxRRvCa/Ng1vy
iBfCgDflY7xWxGyAv2Dk9LRkvKKIWEN4pVEp71Ea8sHZunvxq7KwK5IJwdRZ
lWUecY0y4fIa2a1zRIFemJM64V/YBxdBebxuyS4O+VTGlniVHG4p65ofa7iX
sSVeJQcThGca5+NVciiDnSN9PJ/9SBobuVrOXlddU3y/xd9haEtNa8efaKKo
zPfj+yxIV2hP6OO7Reqe4vstcELp6U5t/FZm6vH9FvZK7tmMzj0o3anjPSi3
G75z547rrLoH4FmAPxInrXvF97zUX1Cfe7qhh4XbN96RqvsjvKupvU7xXVT1
ZvH9R80k4ruoSAXkVPLlaU3Gl3toMYu4P/ZS1V+f3sRnuXsQ35eHLzDOpxlC
0jJj+908e69H/fXpLsIn3Y9XvMVSdXfgDIci3hvh7wv4XQWKxHhvhNif4SIv
ZrEYovJStWebOy60mhiz0FpHzAKRgaqfqkLMQutr1KdnYibtstG+kohFqkmf
bmwC7bYLrLNHSHuI4j1CbqdjB71m5J9yMRLtdJqBy4YVC+2hjqUrosjG7f7q
sNE8PGajrI53o2mfFnejaR9XtBttBgFc763T3qB4HU+2zjv3MFLFPmnvPIzu
5n248W3Z3xWz0T3nTc6X8d467T6YrVj5q7wWZfEmFwGxj7QD0e/BjncmK19j
/bonQf2qZfFuT7cjsbBs30HtalHFPNNFRrx3V3suor27urvdvoPX1avqQnba
8xSzczsTCzt/ldei0fNMl2cxO2nxfZhfrSVL7Qvo2X9tebc5tK5nKW/U++i1
u75nH7090bHZ2T5mqbuv07Hst/KMi4nNoZU9S3mlZqlnhmKWXovGr5il09La
f+0zcmPoHY9AI1psZ8/TVYRm346Ng9NpUa8U87RnS/M4HL01ZONU9lW9ie3r
n2xxO0oLO1Wp6bTwKa6IndcSP42kzjPWpzEntqZnpU61ZqXnNZfTwifGbE/8
UvuJMY1cMRt1P7EejWTlWS4bKWM2budoYaN8jrUoc8jGdrk6NupKYjbqSrLc
1tN7rFl8es/ybqn99J6qYY3eR4xHr6wjess3h769P0JPTLoIaaFmD03UNn47
1LoPXT+dak/EL7WfTtVTJGctsXeK80ARFtvaRUILNaOOqC1fHGpFVo3aaoZD
rbn1Wfk86zKcjdXnxk8C156v5WscpnybSzvU7drXoK451lKV25RqHZ1DLVvE
qGvPS36am9DGVgOX2k9by9et9x1U3CbZwLLWobU3fPSgrbO3lq+9d5Rv2epQ
ux3PBXXNsW2Dz2Z32BtGWm88UDWP3x1gPbnDqujveq7GKg/XWGtmtVT1QXxL
g0VjC7P4R5gtY1sZx7jf0vFbjVX+rbHWzGqsqirEanOyFlbxb7/9IvZWHelb
2l6r3tORfDpXIaz51LKU65RlXWALoVjHEVBXklq6Mt35qvVGEdX02qY2G1+G
vWVKhTixXx0hXeh6ailvtcH4U97TYj5qYXR778t7eszyFFXOVW4ToY1lLZsq
k+M3ytgaY42UQ1lBar5qIdUcrX7jkVnekT67ZEP3TULKsxhf1z9LzaBV8Nld
/RY+ey6/hc+sbqJYdSjJMqGF0O+88wit56jFMtkKQqtcLYTuuYeC0MYPE8W5
DSVZBkyJMGf4vIsffGCmtbzSwqaMqrFZJDhHEJtV0hY2+aH9BjDreUwW+9F+
TIr3GpN53+RwVwcxWR62MMny8RvTulGSMp1vcbOZj7XTjPD6LW429wvsPRhZ
xrUwyeKxD63bMpmsZ0RlcWGoGNfVGwKTTcd9mCzLWphk8RhTNx6YzcRk6x+G
iaNl/R5Fm9MElra8snaXPVK8f9Bjsz7PJHPVlrItLgwbI7n2otnUWZxveWRO
GTSau2dvo8dm9cAkM4P7sHHWPxkbLR9io9nz/bdoXfWjYXTUiCw6DBFjp0Zk
s+AQETPKEJX6Xd8RHJS1idnSl3QRsZJMj8jsaBLYJ01ClO6L9b1bdTDfjVZW
Er77lVavZtmI5Ml4aGPi4aqA4SGdZfB0o+BI8JgNQzzMbY9nqvie6+JCJeE7
hUtvdiSo6PdJqOI3G09AUbxvKBiqg8k4atuyulTzcLCIUXS93ouCBar1xm36
0EEob9xmFfk/MLCMFgyMO8PAEJiEgQPVMhj01m8b7Sig1MlzK29O0D12umG6
c5vaMDKtLMs9UeD8eIT6Ga28lON8oL9Ez1T62czF+hnoLf2MkBp6oL/sfJxK
f6lz1M8oNv0lumr9GMDB//5rduEk8EdLm/Wn15GP/vHmP++65HYcYoqRcPe8
8T7vecRHCsFYlHZ3UT83Vb20/+C9l92DL8ouF+o/kvfzX1ci7tp8NDjqf4u2
xww=\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{225, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->30555103]
}, Open  ]],

Cell["Series expansions of these functions:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->759701201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"cm", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "12"}], "}"}]}], "]"}], ",", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"sm", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "12"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->278225066],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{"1", "-", 
     FractionBox[
      SuperscriptBox["z", "3"], "3"], "+", 
     FractionBox[
      SuperscriptBox["z", "6"], "18"], "-", 
     FractionBox[
      RowBox[{"23", " ", 
       SuperscriptBox["z", "9"]}], "2268"], "+", 
     FractionBox[
      RowBox[{"25", " ", 
       SuperscriptBox["z", "12"]}], "13608"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "13"],
      SeriesData[$CellContext`z, 0, {}, 0, 13, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {1, 0, 0, 
      Rational[-1, 3], 0, 0, 
      Rational[1, 18], 0, 0, 
      Rational[-23, 2268], 0, 0, 
      Rational[25, 13608]}, 0, 13, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{"z", "-", 
     FractionBox[
      SuperscriptBox["z", "4"], "6"], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["z", "7"]}], "63"], "-", 
     FractionBox[
      RowBox[{"13", " ", 
       SuperscriptBox["z", "10"]}], "2268"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "13"],
      SeriesData[$CellContext`z, 0, {}, 1, 13, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {1, 0, 0, 
      Rational[-1, 6], 0, 0, 
      Rational[2, 63], 0, 0, 
      Rational[-13, 2268]}, 1, 13, 1],
    Editable->False]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{426, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->17656287]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->243799990],

Cell[TextData[{
 "Integrate expressions involving ",
 Cell[BoxData[
  ButtonBox["WeierstrassPPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassPPrime"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->368350005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"WeierstrassP", "[", 
      RowBox[{"z", ",", 
       RowBox[{"{", 
        RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "^", "2"}], " ", 
    RowBox[{"WeierstrassPPrime", "[", 
     RowBox[{"z", ",", 
      RowBox[{"{", 
       RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]}], ",", " ", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13359753],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  SuperscriptBox[
   RowBox[{"WeierstrassP", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "3"]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{193, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121639438]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->57913661],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->584904650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassPPrime", "[", 
  RowBox[{
   RowBox[{"10.", "^", "14"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340874640],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.0808332798819413`"}], "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{99, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218711559]
}, Open  ]],

Cell["\<\
Use arbitrary\[Hyphen]precision arithmetic to obtain a correct result:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->134297893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"WeierstrassPPrime", "[", 
    RowBox[{
     RowBox[{"10", "^", "14"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52996543],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.88981514157281275180866162175760518084`20.15051499783199"}],
   "+", 
  RowBox[{"0``20.20121520616871", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->176292506]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->216084730],

Cell["\<\
Weierstrass functions are doubly periodic over the complex plane:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->660346928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g2", "=", "2"}], ",", 
     RowBox[{"g3", "=", 
      RowBox[{"1", "+", "I"}]}], ",", "\[Omega]1", ",", "\[Omega]3"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]1", ",", "\[Omega]3"}], "}"}], "=", 
     RowBox[{
      RowBox[{"WeierstrassHalfPeriods", "[", 
       RowBox[{"{", 
        RowBox[{"g2", ",", "g3"}], "}"}], "]"}], "//", "N"}]}], ";", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{
          RowBox[{"x", " ", "\[Omega]1"}], "+", 
          RowBox[{"y", " ", "\[Omega]3"}]}], "]"}], ",", 
        RowBox[{"Im", "[", 
         RowBox[{
          RowBox[{"x", " ", "\[Omega]1"}], "+", 
          RowBox[{"y", " ", "\[Omega]3"}]}], "]"}], ",", 
        RowBox[{"Re", "[", 
         RowBox[{"WeierstrassPPrime", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", " ", "\[Omega]1"}], " ", "+", 
            RowBox[{"y", " ", "\[Omega]3"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "3"}], "}"}]}], ",", 
      RowBox[{"BoxRatios", "->", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}]}], ",", 
      RowBox[{"Mesh", "->", "False"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17769469],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153109987]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20078],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["WeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassP"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->31998]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9157],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->16769]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->18199],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/WeierstrassEllipticFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/WeierstrassPPrime/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->563131415],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->133214122]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WeierstrassPPrime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 30.0398664}", "context" -> "System`", 
    "keywords" -> {
     "derivative of Weierstrass elliptic P function", 
      "Weierstrass elliptic function", "Weierstrass P prime", 
      "Weierstrass prime"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WeierstrassPPrime[u, {g_2, g_3}] gives the derivative of the Weierstrass \
elliptic function \\[WeierstrassP](u; g_2, g_3). ", 
    "synonyms" -> {"weierstrass prime"}, "title" -> "WeierstrassPPrime", 
    "type" -> "Symbol", "uri" -> "ref/WeierstrassPPrime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5270, 183, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->292727847]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 131463, 3007}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1815, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2438, 75, 55, 1, 70, "ObjectName",
 CellID->22070],
Cell[2496, 78, 1028, 33, 70, "Usage",
 CellID->11219]
}, Open  ]],
Cell[CellGroupData[{
Cell[3561, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4039, 133, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4162, 139, 563, 20, 70, "Notes",
 CellID->30942],
Cell[4728, 161, 266, 8, 70, "Notes",
 CellID->223798420],
Cell[4997, 171, 236, 7, 70, "Notes",
 CellID->31226]
}, Closed]],
Cell[CellGroupData[{
Cell[5270, 183, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->292727847],
Cell[CellGroupData[{
Cell[5655, 197, 148, 5, 70, "ExampleSection",
 CellID->150230246],
Cell[5806, 204, 200, 5, 70, "ExampleText",
 CellID->38654821],
Cell[CellGroupData[{
Cell[6031, 213, 186, 6, 28, "Input",
 CellID->125018082],
Cell[6220, 221, 255, 7, 36, "Output",
 CellID->249951942]
}, Open  ]],
Cell[6490, 231, 124, 3, 70, "ExampleDelimiter",
 CellID->90816760],
Cell[CellGroupData[{
Cell[6639, 238, 327, 11, 28, "Input",
 CellID->82266961],
Cell[6969, 251, 3555, 62, 158, "Output",
 Evaluatable->False,
 CellID->339163921]
}, Open  ]],
Cell[10539, 316, 125, 3, 70, "ExampleDelimiter",
 CellID->388072707],
Cell[10667, 321, 196, 5, 70, "ExampleText",
 CellID->10191991],
Cell[CellGroupData[{
Cell[10888, 330, 310, 10, 70, "Input",
 CellID->173331649],
Cell[11201, 342, 1581, 48, 55, "Output",
 CellID->377343697]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12831, 396, 220, 7, 70, "ExampleSection",
 CellID->558424070],
Cell[13054, 405, 226, 5, 70, "ExampleText",
 CellID->542166696],
Cell[CellGroupData[{
Cell[13305, 414, 236, 8, 70, "Input",
 CellID->62404871],
Cell[13544, 424, 319, 10, 36, "Output",
 CellID->374262885]
}, Open  ]],
Cell[13878, 437, 125, 3, 70, "ExampleDelimiter",
 CellID->459573364],
Cell[14006, 442, 206, 5, 70, "ExampleText",
 CellID->38712691],
Cell[CellGroupData[{
Cell[14237, 451, 244, 8, 70, "Input",
 CellID->457580715],
Cell[14484, 461, 371, 11, 36, "Output",
 CellID->38158366]
}, Open  ]],
Cell[14870, 475, 125, 3, 70, "ExampleDelimiter",
 CellID->293425699],
Cell[14998, 480, 113, 3, 70, "ExampleText",
 CellID->354628230],
Cell[CellGroupData[{
Cell[15136, 487, 209, 6, 70, "Input",
 CellID->70266597],
Cell[15348, 495, 342, 9, 36, "Output",
 CellID->157713000]
}, Open  ]],
Cell[15705, 507, 124, 3, 70, "ExampleDelimiter",
 CellID->15161106],
Cell[15832, 512, 395, 11, 70, "ExampleText",
 CellID->303104344],
Cell[CellGroupData[{
Cell[16252, 527, 238, 8, 70, "Input",
 CellID->452701008],
Cell[16493, 537, 503, 17, 36, "Output",
 CellID->66789971]
}, Open  ]],
Cell[17011, 557, 125, 3, 70, "ExampleDelimiter",
 CellID->563694966],
Cell[17139, 562, 401, 11, 70, "ExampleText",
 CellID->356873801],
Cell[CellGroupData[{
Cell[17565, 577, 206, 7, 70, "Input",
 CellID->26066663],
Cell[17774, 586, 393, 15, 44, "Output",
 CellID->256100572]
}, Open  ]],
Cell[18182, 604, 125, 3, 70, "ExampleDelimiter",
 CellID->195637960],
Cell[18310, 609, 339, 11, 70, "ExampleText",
 CellID->56507263],
Cell[CellGroupData[{
Cell[18674, 624, 281, 10, 70, "Input",
 CellID->334742989],
Cell[18958, 636, 460, 16, 50, "Output",
 CellID->448077763]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19467, 658, 227, 7, 70, "ExampleSection",
 CellID->418720937],
Cell[19697, 667, 250, 7, 70, "ExampleText",
 CellID->227466203],
Cell[19950, 676, 963, 31, 70, "Input",
 CellID->400108590],
Cell[20916, 709, 1248, 38, 70, "Input",
 CellID->347162714],
Cell[22167, 749, 195, 5, 70, "ExampleText",
 CellID->279142526],
Cell[CellGroupData[{
Cell[22387, 758, 1879, 55, 70, "Input",
 CellID->28071203],
Cell[24269, 815, 31968, 529, 70, "Output",
 Evaluatable->False,
 CellID->371174365]
}, Open  ]],
Cell[56252, 1347, 125, 3, 70, "ExampleDelimiter",
 CellID->119834783],
Cell[56380, 1352, 779, 26, 70, "ExampleText",
 CellID->746489349],
Cell[57162, 1380, 620, 19, 70, "Input",
 CellID->831380291],
Cell[CellGroupData[{
Cell[57807, 1403, 378, 13, 70, "Input",
 CellID->260055584],
Cell[58188, 1418, 258, 10, 38, "Output",
 CellID->310925231]
}, Open  ]],
Cell[58461, 1431, 675, 21, 70, "Input",
 CellID->210647137],
Cell[59139, 1454, 211, 5, 70, "ExampleText",
 CellID->34638874],
Cell[59353, 1461, 1460, 50, 70, "Input",
 CellID->236091838],
Cell[60816, 1513, 224, 5, 70, "ExampleText",
 CellID->338900051],
Cell[CellGroupData[{
Cell[61065, 1522, 245, 8, 70, "Input",
 CellID->507630505],
Cell[61313, 1532, 206, 7, 36, "Output",
 CellID->110661840]
}, Open  ]],
Cell[61534, 1542, 125, 3, 70, "ExampleDelimiter",
 CellID->670664305],
Cell[61662, 1547, 217, 5, 70, "ExampleText",
 CellID->166746512],
Cell[61882, 1554, 587, 20, 70, "Input",
 CellID->33065910],
Cell[62472, 1576, 551, 18, 70, "Input",
 CellID->101170414],
Cell[63026, 1596, 474, 17, 70, "ExampleText",
 CellID->172970446],
Cell[CellGroupData[{
Cell[63525, 1617, 690, 23, 70, "Input",
 CellID->212194834],
Cell[64218, 1642, 271, 9, 36, "Output",
 CellID->416532606]
}, Open  ]],
Cell[64504, 1654, 219, 5, 70, "ExampleText",
 CellID->335101019],
Cell[CellGroupData[{
Cell[64748, 1663, 361, 13, 70, "Input",
 CellID->680306295],
Cell[65112, 1678, 7462, 128, 70, "Output",
 Evaluatable->False,
 CellID->30555103]
}, Open  ]],
Cell[72589, 1809, 217, 5, 70, "ExampleText",
 CellID->759701201],
Cell[CellGroupData[{
Cell[72831, 1818, 425, 14, 70, "Input",
 CellID->278225066],
Cell[73259, 1834, 1596, 52, 54, "Output",
 CellID->17656287]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74904, 1892, 237, 7, 70, "ExampleSection",
 CellID->243799990],
Cell[75144, 1901, 233, 8, 70, "ExampleText",
 CellID->368350005],
Cell[CellGroupData[{
Cell[75402, 1913, 441, 15, 70, "Input",
 CellID->13359753],
Cell[75846, 1930, 394, 14, 51, "Output",
 CellID->121639438]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[76289, 1950, 229, 7, 70, "ExampleSection",
 CellID->57913661],
Cell[76521, 1959, 253, 7, 70, "ExampleText",
 CellID->584904650],
Cell[CellGroupData[{
Cell[76799, 1970, 212, 7, 70, "Input",
 CellID->340874640],
Cell[77014, 1979, 301, 10, 36, "Output",
 CellID->218711559]
}, Open  ]],
Cell[77330, 1992, 258, 7, 70, "ExampleText",
 CellID->134297893],
Cell[CellGroupData[{
Cell[77613, 2003, 271, 9, 70, "Input",
 CellID->52996543],
Cell[77887, 2014, 361, 11, 36, "Output",
 CellID->176292506]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[78297, 2031, 228, 7, 70, "ExampleSection",
 CellID->216084730],
Cell[78528, 2040, 253, 7, 70, "ExampleText",
 CellID->660346928],
Cell[CellGroupData[{
Cell[78806, 2051, 1780, 53, 70, "Input",
 CellID->17769469],
Cell[80589, 2106, 47166, 777, 70, "Output",
 Evaluatable->False,
 CellID->153109987]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[127816, 2890, 311, 9, 70, "SeeAlsoSection",
 CellID->20078],
Cell[128130, 2901, 204, 6, 70, "SeeAlso",
 CellID->31998]
}, Open  ]],
Cell[CellGroupData[{
Cell[128371, 2912, 313, 9, 70, "TutorialsSection",
 CellID->9157],
Cell[128687, 2923, 192, 4, 70, "Tutorials",
 CellID->16769]
}, Open  ]],
Cell[CellGroupData[{
Cell[128916, 2932, 321, 9, 70, "RelatedLinksSection",
 CellID->18199],
Cell[129240, 2943, 198, 4, 70, "RelatedLinks"],
Cell[129441, 2949, 207, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[129685, 2958, 319, 9, 70, "MoreAboutSection",
 CellID->563131415],
Cell[130007, 2969, 147, 3, 70, "MoreAbout",
 CellID->133214122]
}, Open  ]],
Cell[130169, 2975, 50, 0, 70, "History"],
Cell[130222, 2977, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

