(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32828,        801]
NotebookOptionsPosition[     29591,        690]
NotebookOutlinePosition[     30786,        726]
CellTagsIndexPosition[     30701,        721]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GrayLevel" :> Documentation`HelpLookup["paclet:ref/GrayLevel"],
           "RGBColor" :> Documentation`HelpLookup["paclet:ref/RGBColor"], 
          "Style" :> Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GrayLevel\"\>", 
       2->"\<\"RGBColor\"\>", 3->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["White", "ObjectName",
 CellID->17591],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["White",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/White"]], "InlineFormula"],
     "\[LineSeparator]represents the color white in graphics or style \
specifications. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["White",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/White"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"], "[", "1", "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23942]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->70782555],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->72827276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"White", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->523691949],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[1], DiskBox[{0, 0}]},
  Background->GrayLevel[0]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->31063510]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "White"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", "White"}], ",", 
   RowBox[{"Background", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245967023],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->93959965]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}], ",", 
     RowBox[{"Background", "\[Rule]", "Black"}]}], "]"}], ",", "White"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->392421959],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwKAKxsgQDkP0fyAJj
xf//gTQyycAMoUCAjwGVzwPEjINAFQuUy46mmhXKZcGqixmsBMEHeh/IZkMz
A53PjNUsdJtZ0PhMIJNwuoQY3ZguZcVqFkiUCUtYgH3LAucDGdj1E3ILMh+3
K4gLW+LMwhe7TDj9QWn6GjqpnzhVoBgBRQh6HDBBxXGnJny5gdSUSShnocuT
bgp6eiXPLejy2PMtIVOIKzuoGcYgd4LyBAcWm5mhsU+rvALNMYwA4iSfng==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{33, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->461455575]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15681],

Cell["\<\
White color can be affected by the colors of light sources in 3D:\
\>", "ExampleText",
 CellID->116670670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"White", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165065652],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[1], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->226350256,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Neutral lighting can be used to avoid this:", "ExampleText",
 CellID->278547368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"White", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280509553],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[1], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->114189724,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15392],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29350]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->196082428],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->7983651]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"White - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 35.4775056}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "White represents the color white in graphics or style specifications. ", 
    "synonyms" -> {}, "title" -> "White", "type" -> "Symbol", "uri" -> 
    "ref/White"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3287, 115, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->70782555]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30559, 714}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1285, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1908, 58, 43, 1, 70, "ObjectName",
 CellID->17591],
Cell[1954, 61, 443, 14, 70, "Usage",
 CellID->22609]
}, Open  ]],
Cell[CellGroupData[{
Cell[2434, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2912, 97, 338, 13, 70, "Notes",
 CellID->23942]
}, Closed]],
Cell[CellGroupData[{
Cell[3287, 115, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->70782555],
Cell[CellGroupData[{
Cell[3671, 129, 147, 5, 70, "ExampleSection",
 CellID->72827276],
Cell[CellGroupData[{
Cell[3843, 138, 252, 8, 28, "Input",
 CellID->523691949],
Cell[4098, 148, 285, 9, 121, "Output",
 CellID->31063510]
}, Open  ]],
Cell[CellGroupData[{
Cell[4420, 162, 371, 10, 28, "Input",
 CellID->245967023],
Cell[4794, 174, 2357, 43, 109, "Output",
 Evaluatable->False,
 CellID->93959965]
}, Open  ]],
Cell[CellGroupData[{
Cell[7188, 222, 448, 15, 28, "Input",
 CellID->392421959],
Cell[7639, 239, 516, 13, 56, "Output",
 Evaluatable->False,
 CellID->461455575]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8204, 258, 226, 7, 70, "ExampleSection",
 CellID->15681],
Cell[8433, 267, 116, 3, 70, "ExampleText",
 CellID->116670670],
Cell[CellGroupData[{
Cell[8574, 274, 187, 6, 70, "Input",
 CellID->165065652],
Cell[8764, 282, 13197, 222, 129, 81, 2, "CachedBoxData", "BoxData", "Output",
 CellID->226350256]
}, Open  ]],
Cell[21976, 507, 86, 1, 70, "ExampleText",
 CellID->278547368],
Cell[CellGroupData[{
Cell[22087, 512, 264, 8, 70, "Input",
 CellID->280509553],
Cell[22354, 522, 5615, 98, 129, 104, 3, "CachedBoxData", "BoxData", "Output",
 CellID->114189724]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28030, 627, 311, 9, 70, "SeeAlsoSection",
 CellID->15392],
Cell[28344, 638, 692, 26, 70, "SeeAlso",
 CellID->29350]
}, Open  ]],
Cell[CellGroupData[{
Cell[29073, 669, 319, 9, 70, "MoreAboutSection",
 CellID->196082428],
Cell[29395, 680, 122, 3, 70, "MoreAbout",
 CellID->7983651]
}, Open  ]],
Cell[29532, 686, 29, 0, 70, "History"],
Cell[29564, 688, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

