(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17005,        509]
NotebookOptionsPosition[     13631,        399]
NotebookOutlinePosition[     15231,        444]
CellTagsIndexPosition[     15113,        438]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WindowFloating" :> 
          Documentation`HelpLookup["paclet:ref/WindowFloating"], 
          "SetSelectedNotebook" :> 
          Documentation`HelpLookup["paclet:ref/SetSelectedNotebook"], 
          "WindowOpacity" :> 
          Documentation`HelpLookup["paclet:ref/WindowOpacity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WindowFloating\"\>", 
       2->"\<\"SetSelectedNotebook\"\>", 
       3->"\<\"WindowOpacity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Window Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WindowClickSelect", "ObjectName",
 CellID->20014],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WindowClickSelect",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WindowClickSelect"]], "InlineFormula"],
     "\[LineSeparator]is a notebook option which specifies whether the window \
for the notebook should become selected if you click it. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27754]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"WindowClickSelect", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", clicking the window corresponding to a notebook makes that notebook the \
currently selected one. "
}], "Notes",
 CellID->8670],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WindowClickSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowClickSelect"]], "InlineFormula"],
 " affects selection of a window as a whole; ",
 Cell[BoxData[
  ButtonBox["Selectable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Selectable"]], "InlineFormula"],
 " affects only selection of the contents of a window. "
}], "Notes",
 CellID->18290]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->188100225],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->497834015],

Cell["\<\
Create a notebook that does not become the selected notebook when clicked:\
\>", "ExampleText",
 CellID->130663489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"TextCell", "[", 
      RowBox[{
       RowBox[{"PasteButton", "[", "\"\<text\>\"", "]"}], ",", 
       "\"\<Text\>\""}], "]"}], ",", 
     RowBox[{"WindowClickSelect", "\[Rule]", "False"}], ",", 
     RowBox[{"WindowSize", "\[Rule]", "All"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520801642],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztm+1Pk1cYh0n2ffFf2L+yl6+aLX7ZlkwwA3SLMS77sGTJPpipm8xl+FJE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   "], {{0, 0}, {241, 96}}, {0, 255}],
  ImageSize->{241 0.75, 96 0.75},
  PlotRange->{{0, 241}, {0, 96}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->26093218]
}, Open  ]],

Cell["\<\
Clicking the \"text\" button pastes \"text\" into the currently selected \
notebook:\
\>", "ExampleText",
 CellID->147566116],

Cell[BoxData["\"\<text\>\""], "Input",
 CellLabel->"In[2]:=",
 CellID->32348834],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"WindowClickSelect", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", clicking the button causes its notebook to be selected: "
}], "ExampleText",
 CellID->59188130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"WindowClickSelect", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->976170527],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnO1PU1ccx5vs/eK/sH9lD281W3yzLZlgBugWY1z2YsmSvTBTN5nL8KGI
AioDFESRMlFxBeShlBbLQ0FKpcW11QwEFWaJDNjZuT29p+c+UGA62nvu95Mv
ze93zu/c2uSTa0HsO3sPfrT3LYfDUUC/FuiXUhcXf4cgkmVldQ1B5AhX+krD
XQSxenRK5/wvCwR5nZgqTQCwJsXq+2coDeQASgPJgNJAMqA0kAwoDSQDSgPJ
gNJAMqA0kAwoDSQDSgPJgNJAMqA0kAwoDSQDSgPJgNJAMqA0kAwoDSRDJqUf
TcffSHL9OsDGfP1t6wc7K1g+/PiCuAWlobTVoVaLLZSG0lYHSkNpybCD0o4U
Yi224phxHkpbDumVNpVWJ7CxxV3authWaTHZZ3L9OsDWsJvSIlBaSuymNN54
SI8dlN7St4fGe3iuXwfYGnZQeks/ssNd2qJk/gFxF5SG0vIwFZ2T/i79+sn1
6wCbhfrM7tXiIpSG0haF+fzXy2UoDaUlgPtMbPDtIZSWHtFnAqWhtPUpr/Qc
+sbFf19638EmcVcmpQEgUBpIB5QGkgGlgWRAaSAZUBpIBpQGkgGlgWRAaSAZ
UBpIBpQGkgGlgWRAaWBFbPIxj8CeSPzLpcCeQOltw+Fw5PqPYAugNKNYxbjC
F8U2y9Z6QOntAUoTVUhe61b4orhu9Fk3aQRKbw9QmhgENl3RbRnv5xs+C5Te
HqA0WV9p43sPAqXzHrspzbzS2ZX9Lm1arzeQ5Ymg9PYApTe8G5t+D2i8jeuO
Q+lcAaXJpt85rAfu0vmD3J+JZwqUlhjpPxMP2Ao7fCYesA82+Uw8YBPs85l4
wCbgM/GArYDSQDKgNJAMKA0kA0oDyYDSQDKgNJAMUekvD5RGph61tHqPl9Yi
iHWz8veKxztx6Kuy4gMnqNI0k5NRBLFuRKUnQ3FC1tbWVhHEovlnbVVU+sF4
bGVlNbn0imYplXSdpI/LvE0m0wN0kQ/zWswSWrT6dssina1sqNr9bv2u9+p2
vW8MXae7dIYdfPVqOZlc5kqPjkwvLCbn5hfm5l+kHhfU+oW+fiYO8Hm+uKjd
RYuW5b+I5Nq9c/XUaXKxhlRXm+RiDd2lM+zg/DPlCFd6aGjqyZ/zscTTWHzm
7R07xMQSM7HEbLqOi/UsjTD2VC1mec3azLowbzqcuXJqmO2yQn9Ku4s231vF
nJlUy7Zm0gM86a0ZZV49+7CkkLTdJM2N66btJp1hZ+OPn8YTc1xp/2B4avrJ
5MM4c4YWLGqbyKyHMzNqEUsNp2fCmovExFZ3cd0ubbUDyq44nH0Xbd63NIlM
Hda2Sh0TZpSz4eJC4mohVy+nf05HCxbeulroTOpIIjyVeBh5wpX2DoSC49Mj
wQjThhbDwYjY8sJsMWq6Pqy9yLD24sbdYW3NdsXh7Lto87kdMasNiYrHaaFX
mtIk1KrS7NToWGTswR9caVr4AyHf/QmmzcBgyOsPDQxmWrWYEOt0cT804J/I
tH5+asJH54VW9wbDOMxqr3bSqzypZpdfmRZoLdH6BkM0A+ojE4kO+FKasTEu
Ej8bLi4grmbSWKdER/0FUldNrjdQpQfYNe+HAsNTXOk+z3ivJ9jjCTJtaNHT
F+z2jKbbPs26brE7tdjTx4dHM+ueoNjyg93rDKfrvlF+lg2//i7a3LbMEOXR
E1S31Ec1XCR+dvLzPYrMNedJzTlySfg/LNVOUnWanD9JrZ4s2qMeGfX6Qp33
RpjSvZ7xjq4hGiaG+55Sd9wLsJav84jD6kpAV+had9eQW3vErVwkYHbxABtm
u7xdb5ddSnw641m0uW35oztdayJMas4qStdWkYoycrZMf5c+dYKc/IlUVVCl
+XV6PWO/tXmZ0j19Y7fbB+7c9TExaMHC2tt3/XeU+O60+2ittO1+YTi1paz7
UpP8lHmrGxZbfkHjLhc+++4mnwjttrd8xUQktmsUabKogFRXrP5SykVe/jlT
L/14jJSfCRcVpM76brf7urqHrzR2pJXuHWtt89y85WVW0IJF1+qi3e3nrbDe
b2yF6FvdBTe5m1rUPPuGT4Q2F+0m088flffS5WcWjx1lDr/84ehiKqx9fuQI
OXOazvCz7s5AZXWrqvR4c0t/S6v3/wiT7c1OvtmzSH4msq+QOJ1zhw8/P/K9
MXSdlDsjJQVs+IbL2/77UNmpxrTSPQ+arvZev+ZBkPxJYP8n5Fw5KadxmsTp
JOcqB7/4jA1fa/LcagscL61lSnd1BWsuuetrOxEkf3K2smGo6NPo/r1TJYXG
RPcVBkoK6Qwbrvu140azF0oj0gRKI5IFSiOSRad0d0+wtsZ9ub4TQSya+roO
V0tG6XjiWSQ6G4nOIIh18/jxC640gkgTqvS/aMISiQ==
   "], {{0, 0}, {241, 96}}, {0, 255}],
  ImageSize->{241 0.75, 96 0.75},
  PlotRange->{{0, 241}, {0, 96}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->29694717]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2130],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowFloating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFloating"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetSelectedNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetSelectedNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowOpacity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowOpacity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6571]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24985],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->7278]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->41759027],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->8791326]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WindowClickSelect - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 37.5400584}", "context" -> "System`", 
    "keywords" -> {"click-to-type", "Selectability"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WindowClickSelect is a notebook option which specifies whether the \
window for the notebook should become selected if you click it. ", 
    "synonyms" -> {"window click select"}, "title" -> "WindowClickSelect", 
    "type" -> "Symbol", "uri" -> "ref/WindowClickSelect"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4490, 146, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->188100225]},
 "Notebook Image"->{
  Cell[5600, 188, 2466, 43, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->26093218],
  Cell[8788, 264, 2653, 46, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->29694717]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14744, 424},
 {"Notebook Image", 14885, 428}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2018, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2641, 78, 55, 1, 70, "ObjectName",
 CellID->20014],
Cell[2699, 81, 516, 14, 70, "Usage",
 CellID->27754]
}, Open  ]],
Cell[CellGroupData[{
Cell[3252, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3730, 117, 311, 10, 70, "Notes",
 CellID->8670],
Cell[4044, 129, 409, 12, 70, "Notes",
 CellID->18290]
}, Closed]],
Cell[CellGroupData[{
Cell[4490, 146, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->188100225],
Cell[CellGroupData[{
Cell[4875, 160, 148, 5, 70, "ExampleSection",
 CellID->497834015],
Cell[5026, 167, 125, 3, 70, "ExampleText",
 CellID->130663489],
Cell[CellGroupData[{
Cell[5176, 174, 421, 12, 70, "Input",
 CellID->520801642],
Cell[5600, 188, 2466, 43, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->26093218]
}, Open  ]],
Cell[8081, 234, 135, 4, 70, "ExampleText",
 CellID->147566116],
Cell[8219, 240, 80, 2, 70, "Input",
 CellID->32348834],
Cell[8302, 244, 279, 9, 70, "ExampleText",
 CellID->59188130],
Cell[CellGroupData[{
Cell[8606, 257, 179, 5, 70, "Input",
 CellID->976170527],
Cell[8788, 264, 2653, 46, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->29694717]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11502, 317, 310, 9, 70, "SeeAlsoSection",
 CellID->2130],
Cell[11815, 328, 739, 26, 70, "SeeAlso",
 CellID->6571]
}, Open  ]],
Cell[CellGroupData[{
Cell[12591, 359, 314, 9, 70, "TutorialsSection",
 CellID->24985],
Cell[12908, 370, 150, 3, 70, "Tutorials",
 CellID->7278]
}, Open  ]],
Cell[CellGroupData[{
Cell[13095, 378, 318, 9, 70, "MoreAboutSection",
 CellID->41759027],
Cell[13416, 389, 143, 3, 70, "MoreAbout",
 CellID->8791326]
}, Open  ]],
Cell[13574, 395, 27, 0, 70, "History"],
Cell[13604, 397, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

