(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26708,        701]
NotebookOptionsPosition[     22982,        580]
NotebookOutlinePosition[     24619,        626]
CellTagsIndexPosition[     24501,        620]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WindowToolbars" :> 
          Documentation`HelpLookup["paclet:ref/WindowToolbars"], 
          "WindowTitle" :> Documentation`HelpLookup["paclet:ref/WindowTitle"],
           "WindowFrame" :> 
          Documentation`HelpLookup["paclet:ref/WindowFrame"], 
          "WindowStatusArea" :> 
          Documentation`HelpLookup["paclet:ref/WindowStatusArea"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WindowToolbars\"\>", 
       2->"\<\"WindowTitle\"\>", 3->"\<\"WindowFrame\"\>", 
       4->"\<\"WindowStatusArea\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Stylesheets\"\>", 
       2->"\<\"Window Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WindowElements", "ObjectName",
 CellID->19191],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WindowElements",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WindowElements"]], "InlineFormula"],
     "\[LineSeparator]is a notebook option which specifies the elements to \
include in the window used to display the notebook on the screen. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1397]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WindowElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowElements"]], "InlineFormula"],
 " is typically set to a list containing elements such as ",
 Cell[BoxData["\"\<HorizontalScrollBar\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<MagnificationPopUp\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<StatusArea\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<VerticalScrollBar\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16539],

Cell["\<\
The details of particular elements may differ from one computer system to \
another. \
\>", "Notes",
 CellID->9592]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->476648307],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->233127729],

Cell["Create a document window with scroll bars and a status area:", \
"ExampleText",
 CellID->114760561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"TextCell", "[", 
      RowBox[{
       RowBox[{"StringJoin", "[", 
        RowBox[{"Table", "[", 
         RowBox[{"\"\<abcd \>\"", ",", 
          RowBox[{"{", "50", "}"}]}], "]"}], "]"}], ",", "\"\<Text\>\"", ",", 
       
       RowBox[{"PageWidth", "\[Rule]", "1200"}]}], "]"}], ",", 
     RowBox[{"WindowElements", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<VerticalScrollBar\>\"", ",", "\"\<HorizontalScrollBar\>\"", ",", 
        "\"\<StatusArea\>\""}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206955065],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnelzU9cZh93p907+hf4hTGa6fE2mnXxpO9NApkDSTibTTr5lph8yTdJi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   "], {{0, 0}, {458, 102}}, {0, 255}],
  ImageSize->{458 0.75, 102 0.75},
  PlotRange->{{0, 458}, {0, 102}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->925131841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->283342690],

Cell["\<\
Create a document window with a horizontal scroll bar and a magnification \
popup menu:\
\>", "ExampleText",
 CellID->591005156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"TextCell", "[", 
      RowBox[{
       RowBox[{"StringJoin", "[", 
        RowBox[{"Table", "[", 
         RowBox[{"\"\<abcd \>\"", ",", 
          RowBox[{"{", "50", "}"}]}], "]"}], "]"}], ",", "\"\<Text\>\"", ",", 
       
       RowBox[{"PageWidth", "\[Rule]", "1200"}]}], "]"}], ",", 
     RowBox[{"WindowElements", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<HorizontalScrollBar\>\"", ",", "\"\<MagnificationPopUp\>\""}], 
       "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42778035],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnetTlNcdx+n0fSf/Qv+QTGd6eavTTt60nWnUqZe0k8m0k3eZ6YtMTVpv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   "], {{0, 0}, {458, 103}}, {0, 255}],
  ImageSize->{458 0.75, 103 0.75},
  PlotRange->{{0, 458}, {0, 103}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->147414068]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->428703760],

Cell["Make a scrolling palette:", "ExampleText",
 CellID->243534950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{
    RowBox[{"Button", "/@", 
     RowBox[{"Range", "[", "40", "]"}]}], ",", 
    RowBox[{"WindowSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Fit", ",", "350"}], "}"}]}], ",", 
    RowBox[{"WindowElements", "\[Rule]", 
     RowBox[{"{", "\"\<VerticalScrollBar\>\"", "}"}]}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75302836],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztndlvG8cdx1X0vchT3/vQP6FvNQK0fSgKtAGKtA8t0FhGLMcN0iJFH1IU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   "], {{0, 0}, {53, 376}}, {0, 255}],
  ImageSize->{53 0.75, 376 0.75},
  PlotRange->{{0, 53}, {0, 376}}]], "NotebookImage",
 CellID->397084422]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13618],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowToolbars",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowToolbars"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowTitle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowTitle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowFrame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFrame"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowStatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowStatusArea"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18000]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29025],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->9691]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->288621244],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->566989078],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->5532151]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WindowElements - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 38.0088204}", "context" -> "System`", 
    "keywords" -> {
     "elements", "window elements", "window components", "composite window"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "WindowElements is a notebook option which specifies the elements to \
include in the window used to display the notebook on the screen. ", 
    "synonyms" -> {"window elements"}, "title" -> "WindowElements", "type" -> 
    "Symbol", "uri" -> "ref/WindowElements"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4611, 146, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->476648307]},
 "Notebook Image"->{
  Cell[5945, 194, 4422, 75, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->925131841],
  Cell[11313, 306, 3934, 67, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->147414068]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24129, 606},
 {"Notebook Image", 24270, 610}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2228, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2851, 81, 52, 1, 70, "ObjectName",
 CellID->19191],
Cell[2906, 84, 515, 14, 70, "Usage",
 CellID->1397]
}, Open  ]],
Cell[CellGroupData[{
Cell[3458, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3936, 120, 510, 15, 70, "Notes",
 CellID->16539],
Cell[4449, 137, 125, 4, 70, "Notes",
 CellID->9592]
}, Closed]],
Cell[CellGroupData[{
Cell[4611, 146, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->476648307],
Cell[CellGroupData[{
Cell[4996, 160, 148, 5, 70, "ExampleSection",
 CellID->233127729],
Cell[5147, 167, 105, 2, 70, "ExampleText",
 CellID->114760561],
Cell[CellGroupData[{
Cell[5277, 173, 665, 19, 70, "Input",
 CellID->206955065],
Cell[5945, 194, 4422, 75, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->925131841]
}, Open  ]],
Cell[10382, 272, 125, 3, 70, "ExampleDelimiter",
 CellID->283342690],
Cell[10510, 277, 138, 4, 70, "ExampleText",
 CellID->591005156],
Cell[CellGroupData[{
Cell[10673, 285, 637, 19, 70, "Input",
 CellID->42778035],
Cell[11313, 306, 3934, 67, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->147414068]
}, Open  ]],
Cell[15262, 376, 125, 3, 70, "ExampleDelimiter",
 CellID->428703760],
Cell[15390, 381, 68, 1, 70, "ExampleText",
 CellID->243534950],
Cell[CellGroupData[{
Cell[15483, 386, 421, 13, 70, "Input",
 CellID->75302836],
Cell[15907, 401, 4504, 76, 70, "NotebookImage",
 CellID->397084422]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20472, 484, 311, 9, 70, "SeeAlsoSection",
 CellID->13618],
Cell[20786, 495, 981, 35, 70, "SeeAlso",
 CellID->18000]
}, Open  ]],
Cell[CellGroupData[{
Cell[21804, 535, 314, 9, 70, "TutorialsSection",
 CellID->29025],
Cell[22121, 546, 150, 3, 70, "Tutorials",
 CellID->9691]
}, Open  ]],
Cell[CellGroupData[{
Cell[22308, 554, 319, 9, 70, "MoreAboutSection",
 CellID->288621244],
Cell[22630, 565, 134, 3, 70, "MoreAbout",
 CellID->566989078],
Cell[22767, 570, 143, 3, 70, "MoreAbout",
 CellID->5532151]
}, Open  ]],
Cell[22925, 576, 27, 0, 70, "History"],
Cell[22955, 578, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

