(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27303,        675]
NotebookOptionsPosition[     23827,        563]
NotebookOutlinePosition[     25511,        610]
CellTagsIndexPosition[     25393,        604]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebooks as Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NotebooksAsMathematicaExpressions"], 
          "Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Notebooks as Mathematica Expressions\"\>", 
       2->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WindowClickSelect" :> 
          Documentation`HelpLookup["paclet:ref/WindowClickSelect"], "Visible" :> 
          Documentation`HelpLookup["paclet:ref/Visible"], "WindowOpacity" :> 
          Documentation`HelpLookup["paclet:ref/WindowOpacity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WindowClickSelect\"\>", 
       2->"\<\"Visible\"\>", 3->"\<\"WindowOpacity\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Window Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WindowFloating", "ObjectName",
 CellID->6607],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WindowFloating",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WindowFloating"]], "InlineFormula"],
     "\[LineSeparator]is a notebook option which specifies whether the window \
for the notebook should float on top of other windows when it is displayed on \
the screen. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12074]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"WindowFloating", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is often used for palettes. "
}], "Notes",
 CellID->790],

Cell["\<\
If there are several floating windows the most recently selected one goes on \
top. \
\>", "Notes",
 CellID->22599]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26541668],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->151887559],

Cell["Create a notebook that is always on top of other notebooks:", \
"ExampleText",
 CellID->1008246745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"CreateWindow", "[", 
     RowBox[{
      RowBox[{"WindowFloating", "\[Rule]", "True"}], ",", 
      RowBox[{"WindowTitle", "\[Rule]", "\"\<floats\>\""}]}], "]"}], ",", 
    RowBox[{"CreateWindow", "[", 
     RowBox[{
      RowBox[{"WindowFloating", "\[Rule]", "False"}], ",", 
      RowBox[{"WindowTitle", "\[Rule]", "\"\<does not float\>\""}]}], "]"}]}],
    "}"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1498936300],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
  ImageSize->{273, 178},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->702218715]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1957068385],

Cell["A palette notebook is automatically a floating window:", "ExampleText",
 CellID->1588809243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<always on top\>\"", ",", "16"}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1305280303],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3OlzVed9wHE6ed/Jv9B/pe2Lti+amY77IslMYzw1OHGYTvOq9Yu+yNRJ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   "], {{0, 0}, {458, 259}}, {0, 255}],
  ImageSize->{458 0.75, 259 0.75},
  PlotRange->{{0, 458}, {0, 259}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->55198496]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2216],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowClickSelect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowClickSelect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Visible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Visible"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowOpacity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowOpacity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23357]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32518],

Cell[TextData[{
 ButtonBox["Notebooks as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"]
}], "Tutorials",
 CellID->3140],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->17103]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->39189426],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->16246012]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WindowFloating - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 42.6808150}", "context" -> "System`", 
    "keywords" -> {
     "floating", "palette windows", "floating windows", "always on top ", 
      "top most window"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WindowFloating is a notebook option which specifies whether the window \
for the notebook should float on top of other windows when it is displayed on \
the screen. ", "synonyms" -> {"window floating"}, "title" -> "WindowFloating",
     "type" -> "Symbol", "uri" -> "ref/WindowFloating"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4311, 139, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->26541668]},
 "Notebook Image"->{
  Cell[5471, 182, 10195, 170, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->702218715],
  Cell[16146, 374, 5076, 86, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->55198496]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25021, 590},
 {"Notebook Image", 25161, 594}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2183, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2806, 80, 51, 1, 70, "ObjectName",
 CellID->6607],
Cell[2860, 83, 545, 15, 70, "Usage",
 CellID->12074]
}, Open  ]],
Cell[CellGroupData[{
Cell[3442, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3920, 120, 226, 8, 70, "Notes",
 CellID->790],
Cell[4149, 130, 125, 4, 70, "Notes",
 CellID->22599]
}, Closed]],
Cell[CellGroupData[{
Cell[4311, 139, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26541668],
Cell[CellGroupData[{
Cell[4695, 153, 148, 5, 70, "ExampleSection",
 CellID->151887559],
Cell[4846, 160, 105, 2, 70, "ExampleText",
 CellID->1008246745],
Cell[CellGroupData[{
Cell[4976, 166, 492, 14, 70, "Input",
 CellID->1498936300],
Cell[5471, 182, 10195, 170, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->702218715]
}, Open  ]],
Cell[15681, 355, 126, 3, 70, "ExampleDelimiter",
 CellID->1957068385],
Cell[15810, 360, 98, 1, 70, "ExampleText",
 CellID->1588809243],
Cell[CellGroupData[{
Cell[15933, 365, 210, 7, 70, "Input",
 CellID->1305280303],
Cell[16146, 374, 5076, 86, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->55198496]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21283, 467, 310, 9, 70, "SeeAlsoSection",
 CellID->2216],
Cell[21596, 478, 722, 26, 70, "SeeAlso",
 CellID->23357]
}, Open  ]],
Cell[CellGroupData[{
Cell[22355, 509, 314, 9, 70, "TutorialsSection",
 CellID->32518],
Cell[22672, 520, 427, 12, 70, "Tutorials",
 CellID->3140],
Cell[23102, 534, 151, 3, 70, "Tutorials",
 CellID->17103]
}, Open  ]],
Cell[CellGroupData[{
Cell[23290, 542, 318, 9, 70, "MoreAboutSection",
 CellID->39189426],
Cell[23611, 553, 144, 3, 70, "MoreAbout",
 CellID->16246012]
}, Open  ]],
Cell[23770, 559, 27, 0, 70, "History"],
Cell[23800, 561, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

