(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    178904,       3354]
NotebookOptionsPosition[    173587,       3180]
NotebookOutlinePosition[    175296,       3227]
CellTagsIndexPosition[    175174,       3221]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WindowSize" :> 
          Documentation`HelpLookup["paclet:ref/WindowSize"], "WindowMovable" :> 
          Documentation`HelpLookup["paclet:ref/WindowMovable"], 
          "MousePosition" :> 
          Documentation`HelpLookup["paclet:ref/MousePosition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WindowSize\"\>", 
       2->"\<\"WindowMovable\"\>", 
       3->"\<\"MousePosition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Palettes" :> Documentation`HelpLookup["paclet:guide/Palettes"],
           "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], 
          "Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Palettes\"\>", 
       2->"\<\"Programmatic Notebook & Interface Customization\"\>", 
       3->"\<\"Window Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WindowMargins", "ObjectName",
 CellID->29948],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WindowMargins",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
     "\[LineSeparator]is a notebook option which specifies what margins to \
leave around the window that is used to display the notebook on the screen. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7775]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"WindowMargins", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["left", "TI"], ",", 
       StyleBox["right", "TI"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["bottom", "TI"], ",", 
       StyleBox["top", "TI"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies the distances from each edge of your main display screen to each \
edge of the notebook window. "
}], "Notes",
 CellID->9712],

Cell[TextData[{
 "Typically only two distances are given explicitly; the others are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", indicating that they should be determined from the size of the window. "
}], "Notes",
 CellID->1597],

Cell["\<\
Explicit distances are given in printer\[CloseCurlyQuote]s points. \
\>", "Notes",
 CellID->14793],

Cell["\<\
Negative values represent edges that are off your main display monitor, but \
may be visible on additional monitors. \
\>", "Notes",
 CellID->13696],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 " change whenever you move a window around interactively using the front \
end. "
}], "Notes",
 CellID->1078],

Cell[TextData[{
 "Window edges closer to the edges of the display screen are typically \
assigned explicit margin distances; the others are set to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". This allows the same setting for ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 " to work on screens of different sizes. "
}], "Notes",
 CellID->948],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowSize"], "->", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], ",", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], "}"}]}]], "InlineFormula"],
 " all four margin distances must be given explicitly. "
}], "Notes",
 CellID->28362],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"WindowMargins", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", new windows are placed on the screen in such a way as to make as many \
window title bars visible as possible. "
}], "Notes",
 CellID->11145]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23088078],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->972703715],

Cell["Postion a notebook at the upper left corner of the screen:", \
"ExampleText",
 CellID->1108145522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "0"}], "}"}]}], "}"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1623601470],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "NotebookImage",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{485, 210},
 ImageMargins->0,
 CellID->105566089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1821248157],

Cell["Postion a notebook at the lower left corner of the screen:", \
"ExampleText",
 CellID->913949605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "Automatic"}], "}"}]}], "}"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->708430313],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "NotebookImage",
 ImageSize->{485, 194},
 ImageMargins->0,
 CellID->11964202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->512253116],

Cell["Postion a notebook at the upper right corner of the screen:", \
"ExampleText",
 CellID->1942687508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CreateWindow", "[", 
    RowBox[{"WindowMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "0"}], "}"}]}], "}"}]}], "]"}], ";"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->407577968],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "NotebookImage",
 ImageSize->{488, 221},
 ImageMargins->0,
 CellID->449850277]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1633354008],

Cell["Postion a notebook at the lower right corner of the screen:", \
"ExampleText",
 CellID->1947967891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "Automatic"}], "}"}]}], "}"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->938931623],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "NotebookImage",
 ImageSize->{493, 202},
 ImageMargins->0,
 CellID->58415630]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176179789],

Cell["Specify explicit margins for all four sides:", "ExampleText",
 CellID->497352855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"200", ",", "200"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"120", ",", "120"}], "}"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160982305],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzsvQdYFdcTNzzuLYDYU/4xmpiisdcYjd0kJvbYe0Fj70Zjb7F3sfeuoNiw
9y42QKWIgA0QREHsPZbzzcyWW7gXQRN93+9dnmdmz5mZM+d35pQ9u+zdrd32
r84derT9q0u7tl9V7dO2d+cu7fp+9VuvPigypAMwAYARvgJKC0wrrCV80f4L
MMCY+X9DYuI9GD1qCWqQ27HmrDFA02Y9wHvjbmjbbihUYw4obb2uD/yy/U/4
eVs/kJgbtbxylAUGaxGaUspoI8MjezBpKSykKi2eLY6IXBw4Nzmwc4JNcmBq
Zm6ykanFZJ0reJycABOveMLU84NhWthQqO5TFbINzgljl4+mYAo45HfejjUn
hggojuERF2HylNUwYfIqiRNGSnLKRuyqifk41cuSTkVpJ2KDjVOjIlOdKzmn
Ms0l6kycMlvs8JgMnMlhG9JxDrD/Gi5tCz+ubQ1l1ngo1EI7pueUAXkrTS8x
N1nZWcplppRE7lycWFFNBs1ri2ReZSStrBC1YC/29jIyN5Z1OzsVRlwYAwPO
9IWpoUOhhk8N+HJoQfA7cxiuRidCBoi7G7sEug8YJShlYb7ElKlFQ2LdxqPg
ztwAa9cfhrU+MtnL5FxymZG4RFlOGShlciBzcVBHOpbRlK49uyGUXPI7UyPm
rlBlYyvoE+oJXU70h/GhA2HUuYFQcWlFKDG+JNx7dt8dkm4lYdFWfYZB2x4D
qamwkLmB8yQnC0HcwjYqxdT2b98ZgEsLcYCsUGVqFSgwvxwUnFcRCs8nKq/l
C2Bazpe3yldkvbXOwNr0UGheea08pdVydj5kc7ONC/WIRSVNXU4VycjmsieD
xcag2VBtEjsxamU0d5RwUyovZ9M4OqpAZRcFFBeyjUISC4zWIOkog3C3Ckk5
aLK3A3Q81hsa72gGwwP/hL6nu0HGPjng6Lnd8PjRYwxSws2bEnWXBBNnLMRR
P3HGIk5ZH1PSlaYUsUU5WWaw0i4Edi2oEgvbRMxqAOw/dA4HAHEaiD+Prwh5
ZxRjciEuSflnloBshvwzilNKPZryTS+eJd/kYgVKTCpTPO/QIlXy9y/atGDv
Yp0Kdi3erVCX4m0K9ij+W8GBJQoUHF0iW/4pJYz5ZhRPh1SOPbvCj4sqQ+sD
baHexlq8kPc51hHyTMoHpSeUhqfPHqeH+Lh4Rr8IJkxfqLQDZRbmQwx78hYO
57DzYXD40GHYtm0b7NixA06ePAVhYWEQG3sTzp0Lh6pw5FgIt++3MRUgz7QC
kNszP3YhpT7jNKWQDPk8C5vyTivkln9aEff8nkVc83oWSp9vSqFieYcV/KtE
7x/+LNC1UN9vWuYZnbd5/rkFGhVaWbB+Ya9C9YrML9S4yNBCfxStX7BPkdz5
Rxd2/25yQem7aQXJt4GdGzLnm1wgV/4JeYsWGv0dGCoVGZEHXCmdq8D4fKRj
PaZJVqnw37npaCABGFiEBbiQpBQtOCYPuSMLLoZ5docyciVxrS42XrGgVmPe
KflBtjFZB0BLS5wy2MhMzF2hzoZauOBWhZ9XlYcqS8pD261NwNwuK1y6FgZJ
iUluEHstjrssE4z3XACGDFMmzqoxr/OfnJtEXOlQtLOwtcQgI0SER8Jm383w
96iFMGHSOhg/cT2MHuMNw0asxOMaWLDoAJwJugmvX7+G6OibsGXrUagCx09c
4A6uOqY84s3HZGD+OaLOq8mQMuaelC/zd1MKZM03peCXBScW/vLbkd+V/bL3
152zN8mx48e2ZQO+bv2N/899SkYNHFr0ru/C7I+Oen2csMjz27Me3YqsKN36
+16FuhQtk39ooY/yTshv+M6zAPv9dkpuSa4Uw0sd+K1HiQG4ARzxQ68vwLVX
yT5f1ik2+BvuJSTsim9IT1qP4v2+NFABMKgiLiQxN5KMtGpRqU7RId+AO4mw
r79TG0VprhW9sVelGNsoyCDPlDx2waEO1gKDM4J4ek1WcdGPUH9tNai0oDSU
nVcCGq+vAVl6fQpzNk2FR48euUFMdCx3Jc7DsdPmwTjP+RqpeeujxCmTtazQ
1AGjriQUK4ZISGJwGTdlTsbJE2dy7mPiOcgsp5b6UrZjH1QzkSAgFraGGG5M
zp0Nghm4DPbsNR3GT/CBiZM2wKQpG3FUbeARNfzvVTBk+DIYOGgxj7KXL19i
s57hiDoCv8Ap/wjeLNUcWwEKYjAKTc/Px4Iz8vGxwHQKLKU+QZ63YpHhBXt/
1fTLbjmbfd4/d8uvB3xe97MR2Wv9b1n+hvlCf/3j1wf1ehV5sWFGVhG2wV3c
O+wuRCjSRaQQ95ublhceVbJj8RpFBxTKWWh8fpdCnjQ7qYZP1bqLFh+b26MU
jo8yvb5YVqHj58vKd8yOxMcRZXp/Uafk0G/qfD/kK49SA7/yLNv1c98Kf6C8
15d1Sg75Gukbj9IDvvYs1zUnyZE+kygB7KJX6b65qCiZYfqLET/2yonHLyt9
//e3mQtP/U6r/ocBudBFDipONmSfq8iE3FAM4Racng8KIxWahaGZkZfTRRQZ
NsUzL2SB/NPzsB2RmiZb0paYXRDqelWB0rOLwg8zCkHhqfmg7PRi8OWgPPDk
6WO4FhPnClFRMTze3GHM1LmQ/rOxIydzCmn8ol8aCvFjsfIrh4+i/KfTRk06
uufbkunGTp07jgTKmoMuLMybGO57LoSFw7hxU6BD5/EwaeoGmDJtA0yfuQlm
ztqKtAXTm2HadF+YMHEdjBm3hkfOoMGLIen2Y3j69AVs3nIYfoaAwIs4Yr6C
ZpN/gzLYjPKziyU7VrCkl5UbWHVXvT51d/3SvvKJ39pX2Vu+VdlDlVr+FFu2
oe8/BX7aIGq2/VVsmGIWAd7u4vpud/HCH0fLBR41rx+cyrCido+ybX7sXTxf
uXHF05edofmWuCJDpQqj80H76b/DoTPbsAeEENgD1xOiYKH3KPilXQ74qf+3
vZCg6eiKLCeLgAtHodLg3B4/Dc5jIw8MPgwtu3+vuvmp8xe9KlPR8ZVYEhEV
RDKgYhWnFJZbitXbuEDXFQfnzlVpahEJys4pgnO4wpziUBGp8tzimCuPKTOU
mVOYZaVnF4HSswpjg5BmFcYis4rg0lRqFmeh3qpfsJaiUALPYwUmfguVZmPh
5png+q0YiL9+0xUuXbrMPe4Ko6bMweuBkcj/njyLckWG/zX83I4cRYpM/2vE
kfAiZYQoWyzpyaifl55r8pu4mdFl1srydT4lwxxUKicVK0tZZQShZwvzIoar
BI2gxYsWQ72GPXEErYMpU31gxsyNMGv2Jgz+lGmbEHvT5n1h/oLteAbbDfMW
7IaZM7fDuAnrcA1aymtPzLUE2Ln71E/KQMoFHrNqQtVFZaA6Us3F5eX0wrJQ
Y3E5TtdYwMeVDUetfd5i2LMXDQY8f9Z5+M0nQ6ZEv+g1+v6rRj0evi7xc9SL
H35v/XrhOLM4utRdXN3mLh4dx0F0Himcl5+jfw77qV+Frj/8+NvoMlmqzy0H
NRfSNp5qMFSqMbEEdx+RUeGLVo+Car1zT/ut97dw5Mx2A4sNUGNQgZ7VB+eH
M+HHQJaZ4cGDO1rxqi2zcxEsKinqqi2yQ7W+eaHG1BLwG55tqo4pbO2x+qD8
uarPKgW1FlbAKFZfXBYrr7GwHNReXIGP1ZaUkaDa4jI4hasuwNKLkdBLlQU/
wE8LSyrH7+Hn+d9DlXk/wO/LysMvc0pAiYl5If+4r6DAmK8B2prhQMA2uHkz
Ebc24eHhVqMmi/WoIbpw8LPC4nC6j4X4pcCLV6XyPHk07vunwSMLCO/06ZZO
KFWdbJrN+qP94F0tm5vGTJ5l5oImbo3igkkOI6a4oRJXI7d5pKI12MmI2E7u
A5NmqCopbe9ILkT4ZRml5FxymVFGgklJAUBS1cKxFy5B7THatFATG2zERk0h
WQJgbWFxaDF1EjyDA//uVnMU+9HCvIjhYDtx4iSU/KESjBqzHKZ6roPpM9bh
/NwgT093np6vXr2Cvv1mwOrVB8DL+yis9vKDBQv34cK/EafzGt50btl6CNQ5
aoAOS+pD4xW/QaMVv2KUmmCqMDTEdCOWKbTstzrNZ/UWzYcLUXeQEF2nCuF1
QIhle4T4428hytS8+bDkr5NFr/7fiJ2z3UT4Jndxh7YIwcocveB+efHsUmMq
t//x15qjKn/SYMGvXBP5bigfK9WfWpajsfOoN1Rr+hlUbfAJdOldmWUPHt6F
2n3yT/u9T344F+7HsmmzekHNzt9A3dHf16k3vhSovd66fTH4rXZWWLveU5Fl
he4Df51WC8sSnVXKo4zzdaf+CA1WVIG6E37QdOS7Ruev4ffRJTI3XvILx8cA
jVf+ituZhsgbEa2qwseGeKy/4hdogAt63ZU/Q/2VP0E9pDqrfoLayytC7VWV
oM7qilAXqdq8klBs/DdQdNzXkHfUF5Cuoxv0XN8OEm8lukJIcJi8F/0fjMD9
43Ar+nvSLCU9g3SuY8Z7Zhk/anLpSd0HfTN50OjzRz7LIe7W/EyIXS3DEjyr
vnjV4lvxNKerCE6XRZxyl0Tod5+L13ny5x4/aDQu9eRdHpWUUkmOHqXcHOoI
g/XRwCmTJlPJojPY2EucMtrYyzN2Es7YEZo9peScrUzB50TmalNW1VkdJaeQ
zPaQ1KOjVjhtmcQdJIfDuutkA+c6A6cMNrr0ioxCb7lEwPFhYV7E0OXsxQuh
QcPOMHvedj5dz567QTldZ+D1QD11Ea1YsQ7WbTgGvr6BsMbnFMydvxfGjF2N
G8CnEBwS6UJLgoHu80uUMmkpYCGn5Bxxo41MLWlyav9mWUZlSTJDxxUNoPXK
WtB6VS1oubImtEJquaKmxJn/ydmVNf/XeknD2KajEkQTXJVajRRiyhoh1h0S
ojeuTr+2uPekRKUD4hePH8S6SSZxdq27iN/jLl6fUbagke7PwrZ9vqxKqx+b
V+9f6Ysmc6phFTUQUgvilZpMrQCTV/WF2p1zYxBqtMoJeWHGkv5aLOv0Kbi0
To+8cCxwB+enz+sDdXrkg0YTyhRtNrMy3Lgdy/LFq0dDm+6loHqTz2D7nuUs
m7Hwr6V1euaFun0Lwu4TPiwbPfkPrqvhmFLQcml1aDKxLBw7u9PiG+0bTyoD
LVfXgFZIdPRAau1VHfPVESOlDNDKC3XeKOMcpTIirwYt1ii0tiq09KkGzbyr
Qo15paHQmC8hz8ickOfvz8HYyxV+nFISLwpu4XzyCwhW7uwNnTAdPoJhyIeO
9+TcMKYZlP5m9IAROzbnKyn+cckgxGe4BlUu/vD5yvri9Z2hj56F93/yz9Ta
L+NK5nwRVfW7hEdLWr941bg0eicvLtw6Sjk6yvW6aTKVHNkaOGVyaCvrDA58
G23seS3ChMStk3XDlLaybpjmZpjm2pnM1aa4qrM6GlNAYAfWUQOcNkriPlIi
Qb2lEOU/4ZQMUK1T2W5gZ1uYFzHsnZYtW+H2fgVs8j0NGzYe5VVl3LiZvK7I
VbvxXmPFgh24nuxHu5Pgu/kM7j38cHviC7t27YJnz15hMGhim+wXDM6bU7nA
8FYluanz9Sn1682X0GFlfWizqjaTB9HK2rj+UPp3+Sjnja2X1fb+w/OgaDtG
iIZDhRiyQIhNR4UYuUSIel2fvC5a4fLDcs3qihWjpWf+a7KG71uTP3zZ8oJX
NqwpdCdo37cvnpzOdrJVp4pDfulYtnCjqVVxfi6viRFosbxmpSZTKkD9AUWh
59+1YMe+lbTjkTcv6cFn8yxaWpbS8rJs40SWrt00A36n5WJ0KVxufoap6wfK
p7GPqPTSuj3zQf2BRWHexlGaec1WX0C9voWguWclaDz2R1ixZbLFVZfc0GTs
j5k9lteAtl4YCK/fkWrT6PD+HcdN2zW/wx9IdGy7FtNEPnWQ8LgOZetqI/0O
HutrQdsNKPOtDe021oBa88tAvjE54Mvhn8EXwz4Gt96u8Em/L+Fm4m0cFbid
tVphTA5XGFmXgfLVVnbpLUTjPEK0Lx1xa2L1hEcne8XFbOkRdLB+mX/25cn+
7HFYnxsPrvQ6Hdui9H+zwBhsbLm8ejVjXcC2AvtCqVpdLEYGm9VDtjM7W11M
aURjtGqcKne0BLHMQJ3DJVJYSLBPLcyLr1jMkC9fftixIwROnb4GficuqIuI
QRngtIbMm7cBFi3aCKtWb4d16w7Apk0nYM2aYzAX9zULFiwgS9dUzn83BzJj
mtaOZEuPI1N1+TBCx9UNod3qutDOiwkjgZkvcTWpA22R2jD9LiG16bxkmvAY
jRdRA4XogdsU7/1CzNokRMuBr0XJX+MSy1QfLtr3zX20498l9/0xqHTIHyOK
X+oxseTl3uOKxwwfW+JMg9YV55dvWurnuqN/hebLaiDVRKoOzZbVqNQYl5Dl
W6eqt7joxsX2Xcug21+/8LVUrc65N9EOg1YYsgg8d4j3NfUGFK3UGHc7DUeV
gj5TG8LRU1uprNw5OeFM8BHcrOSDhiNKQv/5LVl6/UYUu6zd7mtoOLg4NOhX
GHqPsrit7fElNB5aomjbhdUyd8ClpNP6+tBpQwPojNR1Y0PosqkhdPUlagTd
NjeC7pubQvetTaHHtmYS9N7RDOd7r51NoOfOxtBrT1Pou785DDrSGq9Cy/M+
Jc+wz+HjAZngswFZIf3vGSE+8Y4r7DtwRr56MsGQsdNg8NipfBwyTk4bKSdx
NsOw/V2bifhJxYXwKPT07oQq4Xsq57+6rnaZx+u+/yoi3rvx85cLyghRK2fQ
jTyFPvl7yFgze5IXE0o5OkqcctNkKjmyNchYMCl7NjjwZLTxxCuE1gAFybhp
Do8mThlsZAZOuWoylezKSxwquSilZDhy+FSZIjc5MDU4K262g0T0kSKz7ixl
DcGutDAvYriG5M6dGy5ffQZXop/Axo07+WLm5cuX8mh35zWE9idEixdvhGXL
tvBassZ7L64jB3Ed2QZTpkxha0cLiaMNgkm7DHJ0WcNrgtGyOqRp0TBAF+8m
0GFNffjDuy5atvOuB99juh6uHXhaxYWkDdHqOumQcrVb2U5UHx4tqva5K+rh
xc4kvNBZshUveoa9ED80uClKNR34ukSzAq/q98skeq5xFyNPuYupV9zFnCT3
V+PDMie1HV7Mu1yDUo1rDv4JmtHFBVLjpdXoWKnh5PLw4PE9DoznrF586+RX
JJrfdOHR5M8Sm2p1/hYadyvCNrSskO73HvnqNBpfFhoi1R9Wgi9eqjXJDlXr
f8LlldsxvBVpPO5H3nLIsgxcTzVaP9p/jfQNNGqXT/NdrcGn0PDPgnVae1bO
1QH3XV03NZagu29j+BR6bGkCvbY0hZ64VPTe3gz+3N4c/tzZAvrsagH99rRC
8oD++z2gH1L/Ax4w8FB7GObXEcae7gqNl1eEgmO/5J1I9sFZ4LOB2SBTjU8g
Ou66K+zef1z5r8yAkVMg46vXn6YXIUXTi8SPMgj/TzMIv8I5n28pnVssL5hT
xDTKLkSNz8Vzd+Ote5mznYz6Jm/ZqR17YfdTWfkETCmV5IlBKYONTrlXaKuQ
Zwxxo5ZXjmxqsE0pjoVyTWrinIuNN/tjKtwwAMOb7Rya2OJObpCdUso8x7Bb
mBcxemQjbz4IPX8fN8DP4Pr1O9ZzHdQdsfVkX7BgDW4c1sHSpb6wauU2mLdg
I8yfP9/ZhsGYwrVISvPYaFkGMjos/KZjZiVlgp4+LaDTugbQkcinAXRAkqD9
2vrwGbRbWw832nWZ2q6pmw5XB6PH6jqibf9hona7EaJ+Py9RZ6C3KN1kkKj/
68+i8c+FHv/U4kdRrUc60Wd5ejHyqLuYFuEuFt92F0vuu78asDHbgSrNyner
+mclaLq8hgTNVtSA/0GT5dWLNppZWZv43YdWgxotc0IjnOQXo4JZdi7cb9nv
PfLyxKb7rySr2/QrqN0ltwdedkATz4pwOT6c5ROX9CI5jJ/XVemk/CMaDCkO
LWb+BC2RHmI9Dx7JPpZ4jYZmPYtB3W7f8UbhwcM7mu/6PfN5tJlaKVc3XBj/
3IEze0dL6LuzJfTf0xoJZ/TeNjBofxsYfOAPGHaoHYw40g5GHekMo451g3En
usOEUz1gon9vmHauD8wI7Q+zzw8GjzVV+Z4r3en4duSnkGNANshW/3O4eCkG
zwTbdspT3w3+Gj4JMmTv13fE2e3Z81w7njWPWJcupziTzv3atQk1Ex/e84xJ
mlJZnPrGKBaky/woMlN6qf/wSS5cTJ71lFJJnh+UMtjoTHYyOn5GKWXSqamU
/GZ34DePXJKnFTbJwryIYTurVa8FO3f64/X4M6QncPPmDaup9UruNDe+tKdZ
NX++F84sb1i4UJ5dM2cuAW9vb4iLu4nOAs9cUqYVpYhMzI02Mj7N2ZrK0yl5
cTPzjDYy1f5Nx8xKygyDt3SAP7e0gN5bmkPPzc2h1+ZmeMQtZQ/fphjl7r5N
oNumptBtY5N0eHx9fWAucaljRhFaJ51Y1/47saRnNbGz7ufieLF0YsVH6W53
bFtRVOn2sWg70UUM2+cuJoW4i3nx7mLpA3cx2t/9QuOulQZV61FJnrNraduP
k9aQq/WS6uB9eJ6yGsoDgcZ+1ym1ejUZWUr7H+S5sGM9m44uDR6zf4GhqzvI
fe0CwRdPerSeVBE6Lq0FHZbVgvNRAfIUW9Bd+xfHiaDdtqs17tODLvj17Dil
cq7+vi1gxIEO8PdBpEOdYNThTjD6WFcYgzTerxuMP4FTBKfJFP8+MOtsf5gb
PAjmhw6BxeEjYMXFUeB1dRxsjPOEtdfGQ6dNNaGiZ1GoOLUA5P/7CzD1dIXs
bfLAueBIV9iyax8POCP8OWQCgvpz6HjoPXgc5yTmGT7u32e44a8h40n3V98q
DURswSxCbG6T+NCv3avXI4sIUe5TEedmECeMHxn7DB7vwsXkSFBKJbnVcjXW
OpOdTJ5NmFJmk5pKyS/rsjF6xWDoeI3knsJULtkXzy9suIV5EcOJM3T4OOjQ
sa8yvxzOMaWrXPn0NXfuMpg9exnMmrUYpk9fCJMmefL9slP+Z1xoQEuW6WNy
OC0sVs4nlNnZhLJ4l6ynkAtMO9gPR05nphEHOsFwpL+RRuzvhPWM2N8RvoCh
yCk1fH/Hvtu8mwgxqoAQgz7CbWkOIXwbC7H0V/G8jbs4XcH9zsTmZV6U8cgv
6vYzikHb3MXYQHcxKxrn0H13Mf2qe2zn8cVathhTG/rv9MCFHrduO1pDv50e
mftubgE9V9WDVYemQ8KdOCV0JjgVth/6zW8CnedWq9NpbjWeHcotGI9OM6vA
n94NoY93I5ixdRBE3YjQdpynww7A8BUelfqsagADtrSCwVtbw7YzK1k7aF4T
GLOsPQRcOMj50EunZJc5PP5a9Huu8fs6wfSAvjAz8C/wRJqNk2bOuQEwO2gg
LMDJMzd0MCw+PxSWhg+H1RFjYO3libD+0lTwjZoBu64tgH3Xl8ChxJWwI2E2
dN1RC6rN/x4qTS8MP0zMC9DWCCWH/gzHT5zFcbHW55ByP6zHwNESPQpt0lK4
68HkpnF5SwvxW4XB29s1Doqrmh8n0Ge+J/IX+N+gnoNOReYttrVHnlL/I0Nl
UlCKiMPwMSU/Vp6w5rM+pohMxHOQ9gtKKdXzWEdIFuZFDMuu9toC33yTB54+
fY6eabRnwvQjuHEjXhvv//zzAk8ePjBz6mIe47NmLYIZM+biOJ8K06Z5wpEj
R+Gk/1lXOBcUpYxdShFJxFnk5kDLs8FISeXaC1PKcFZTmdkQMKLegZNhXuAQ
mBswCOYFDIY5/soR85g2IhsIn2RYcHrQpXuTSwnx97dCjPxEiBVVhdj4hxA9
PxIR1dyfr/7tm8Sf2pQRv3bFXdZq3GUddxeeF3GHddddLExyf9R37UcF/vbt
Bp4n/oJpJ/qC58m/EBjlDJmnHOqZa/zuzkVHb2kHUqXh61pBJuQti47Z0i7X
hL3diGDE+tawbNc47hT/kP3QZ3bNSiPXe2SefqxvZs9jfXJN3te96PjtHQ2V
Rm1sAwWKTtzROdfUAz0zzzrejyiX58FeRSft7FxprO8flcb5tqs0fnP7SuO3
4LXP8sawfPtY+bZM6AEYtKBepcnbO2VecmYYrLowBlYThY8F74hxsCZyPNIE
8Lk4AdZdmggbLk+FTVenwZaombArej4cjF0Bx26sgVMJ6yEwaTucv7sHDiUt
gX4HGkL9FeWg5rySUGVOMYAmRhi5dAwcOHgKB/T63eo9ma5/jYQuCnG630gM
EaXcbWR4/KhPr4FhJ7/Kl+Wv3sNIl65bv5FCZP78+5FtOmMZsjbUH1fXI0uX
nkM49xHxHFS0NPnISSnFjv1a/oWKgCzMixiarNlwAHr3Ggz16jXEHA3nDMgf
we3bSdpwXr1sE6xc6Y37oIVINIynIU3iW5OHDh/9GcIuxPDmfl/kMvCJmKTQ
ZFiLR4lTRpatVeSYljjz2dIrXrhmjswnxJCsQswtKcT2rjgS84r4+u5iV+mM
0e161BAVOqQX7aebwycdK7hzzrmyBxZGlo5aEvft3QmBn7ivODcWvMImwOqw
8eB1YQJ4I1GejmvCJ0qYGY9RZvEFTczHxSeHwNJDI+BKfChcT7oKM3b1zEUy
hibDdgGfSLkZdFx/cQqsi0TC44aLU9FwAy51mWDj5Wmc2nTZE9OesCLgb1h5
dDSuwech/vZVmLvvz1yrz47G4TSDh9RWouhZEmyPmS3BjmtzIBvsjJ0Lu2MX
wN7YRXDk+io4Hr8e/BO2w9mb+yA48SBcuHMcIu+egqO3V8O4039Ap221oLX3
T9BwVUUwVjaB75FNsHXbSVdY5bUf5N+QNPDoBp36jsDFk7jh636d/8zcvcdg
zkmybJ133nJ5R3Tow7kJsozLUXnyJIhbmJfifvmKHdCwYXMYPny4MmrcedRc
vx7Ho2bfvgOwbt1GHC3zcMGbzjefaMT4bt4CF8Ivws94AXKdl7Kz17fCPmzz
vtjFRBJnPoL9mN0fR7SEVftlNR2bBp0cjUMmrxADcT81JY8QW9oJMfsn8bCF
u/Ar5544rlnZuNq9Ko2ecrhdxt1R80CS9sYsAkPGPdHzSm2/OolzEuy9hjLY
c20hphZyrS4sM6pwMu+4NDvXxuDJUtE1p0aBCyanoGiOBoegHUCio8RgjVpe
0ZngwPWlWMvB60sz774yL9eW854gFV0XMA53ypjOvOfKfDh8YzkWP3JzBdpR
mlJHb67EHPGscPzWGjiZ6AMBib4QeHMnhCTuh9A7hyH8zgmIuHsSLt47DWdu
b4VF4YNhvH8HGLizHvTaVhfcC2SC8MtXYYPvETwXrPTabTUqOvQeiucJ4ob8
XT26f/Jn576cmyDLtBFApQRxC/NmoREWL90EDRu1gCZNmsDz58/lM6EbPHr0
EKKjo8Hf3x82b94M8+bN484fMWIEeHl5w/kL4fALxMQk8obr8h08Dyb4wKlE
mU4mqul1iIJS2axkPjkCY1fHPp+Cm4BhXwgxOrsQa+shNRcvO2Z8HVIt4zy/
SU1cjsd7Sydurk2n+j2ZsBZOJKyVOGHk6jDLuZOy2AfFqkipSaJqjZwzWMuB
3ZgpaVRQnr61jlNEkrVMIYlyxNZL4H9rvRn8k9ZjszAJgXd84WzSVghO2gvn
bx+EsNtHIeyuPM+j7uLakRQH5+7sB5/YibAiZhzMC+4GrddUgy/qFoXQkChY
uWKXKyxdstOqZ9vjWWEhc0svkoUgbmFrWJgRFi/2hW5d++GG5hvo27cvHDx4
EC5duoQdFAP79++HOXPmsLxzly6wcZMvXI2Khiq4tb/DW474RyGIfR+TO3O3
XBExGwfdPDjE//HqBjdfeDeM/WdDO9/7Sxv/Ehk41xicuDcdWZUkW1cISdqP
ozA06RBcuH0EG38MLtw9wY2nMU0BuJkUD5fvnoUTSZvgaOJa2IBB+AJPcWOW
TISAgAgcbwsXbLFuPZ7IFjK3tJ4sBHEL82GhG16CrIF+/UZBzZr1oVjR4nyX
/eeff4UhQ4biKrYRwiMj4Te4c+chQCO4deuOgQEZ4eq9sxB9NwQSbt0ieBLj
NcKqKxMgb41vIeLKRThyOMgeXNtuCIZ5iuA2KsXUX3g9evQUqjGnkEclncOh
s5Xpd+bpkW+DgKSdcEYZRhFJJyEyyR8u3Q1AZPIKcfVuqAzTBMF3tkGnrfWg
SOvC8OTpM9h/IBBjQTdKLD9H/KVeC8RK3PJzRLKwu7+yUSmmYn32/B/ESpx2
A4E3NsDWBE+NNid64pzHlAQbiZEsPSU1i43Oj7K5mUXkaKOVU0wbOGPgrFrS
YClnUci5rapakxkdyEwaWKWIqlTBWDtV9SiT1a6wOWkG7Lw1F/bdWgwHk1bB
YVzK/W754AqwFZfsHUZl3FCHQEcjbD+5nnar7nDx8s0l8hUIpizMl5hVtOlp
1mrMaWTsiVwISy8NZ6rN3B3537Ds8ghYFYX73Fjc38ZNhQ3xnrAhYQZsvjUP
tiYugl23lsHZWwexTYQDAxA/FYxtM8Gr1y+Ab7LYsWbKDQkVBeWqMScUa/wn
w8QzvZlqM3eHqcF/wozQvjA9rB/MCRsMsy8Mhbl4vTg/cjgva97XxsNGRHYw
kc6ENIsMUHxKHjgYukW+0WMbBmbNksVCcCxkFAW7fgXp+2dk+oW5GTIMcIeM
AzNApkEZIeuwTPDp8Gzw+d+fGODLUZ/hsPx85CeQfcTHLCY1mZE5FTOwCxN8
Pe5zyDvhCyg9rxCUn1sY8o3Lg+CGDV9gx1oQcxwiAadPhztiJmKkf/HylSNm
JJZONUq8/dgRMxBLZ2PppDqJWLrk5tFRsY5YOmJ0YkOr+IQ4KgL/cpmdirn/
Cfm5P8pVfTsXASd3vKuL/Xu9NRcm4gb5Kjt5irXKzV9KKcTX4vnervIjB9dr
lZsVCHbuQQOh3CFwJiOSHEDkuwfJTfO8HeLjR3z/VcSO7P5FuCePbflP4cpB
xz93SrpQ6tO3RHp86788FJxEMiNx9v2/D4/UEUj6y6LNus/eFuQ222ktWap3
cQj3zRCTzassDsL7lkE9fWK7XVAdzGxHS5PkCDPRWy5J/ifeeUn9sAv7f3Ma
S749kv/Na4Y7t6/Dw4d3IDz8FAQG7sUCO+H48S1m8PPzpefL/TbDiRPbICjo
EDx+fB+Skq5b1/DGCgxcwbVr4cotfvkfBBcvnrH39GasRnYl+AmU23D9+iW8
sIu/jOL4+CucUkgiHc6S2NgIuH//FpcICTmStspMWmWEPTHxGl5X0TBOSoqT
OOnOwoSEaLzKjIIbN64yDKqTb+RyJN+qcQQeazHC7dvxGDAKE9VHpNZItcXF
RSo17UlTh9hWhHWg4M4N+ufL6aNUr01F1DQye7eKqF+wDgPcvZtA4/OogStw
4SpI6cD9myNmsPJ/Bdg57U2Pyt3jwlX8C84p1hLcu5fIyDFO1C2UUkmNF6Fw
0PVpiBNFW61I4nrc2bt9bQTprQaZpVUEWOLZYWS3WC0TjjYe43ihbT0e1BrP
nNn/rjUm4dSietUalVoRB1Vm1qo6d+5gmsJo1moib7Si0SqBNRm4CneOJ6ks
FKdVFhp6NG3tctNqo8lDC+OjR/eUGpO09kk0KMkWbeTq47RhEhFxOm1VumhV
kvunTx9ytWpD5dC6a1VTxVStdZVRUSFpq9JVq5L+cUiuZZfX1UEv0ZiVOIyu
XA2tSg+VR4Vo4Uj7qeLly384l1GZHGk/4SQl3YUXL14zZWRuZJnuRfeie9G9
6F50L7oX3YvuRfeie9G96F50L7oX3YvuRfeie9G96F50L7qXN3s5JZft2HG4
hfUltu3tXGEJLMz/mSCye66sFwtlEwUybHnnitb67AP61dQ+C+vJQgOr1cq2
/ksV2cSqBysNrFIre9vQGW0q4hpsHg7opjwBQlZW9f1X1bWRH+0Q9E6B5Cnl
UTQ7LP9Z27928FxHOeZZYPf2VbB7xwpN/qb8e4qfCtn6OZJyysM1DGn7Cu1B
GSUvP+Pjmkz9nhH/m88jvrfhqoL/gM8zfvl/zjz5UM9IfsE8w/9pc/ADPIOZ
KTVT/b3Pjg/2iOf/1S111Ej6szwi+smHnvAf7GHTj5i7fugZ/u8/vJrbumEf
7mSc/GHY9z6Vkj9M+94hJH8Y971BeM/b7v++OptLxuZs9YZHiN0cPkL8Hy5x
DiA6egjZrD2E/F6jlbaHmF2TPcT8XsG+8SHoDG98CPoDBdfmIeqMkJqHqN/v
kHTyGHZGSM1j2B8KqpMHuV2TPcj9Xns95QfBXZM9CP6BwNk9SJ4xVQ+Sf6ie
Tv4oeoY3Por+geL6xkfZ04OzR9k/MOKUH4V3sXkU/v0OhDc8TJ/hjQ/Tv9fI
puVh/PROH8Z/r5BT8zB/hjc+zP9eIaflxwBuDn8M8CE2fbY/JzB9kM1ncr8m
luk4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQ
ceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQ
ceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQ
ceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQ
ceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQ
ceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQ
ceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQ
ceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQ
ceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQ
ceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQ
ceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQ
ceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQ
ceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQceg4dBw6Dh2HjkPHoePQ
ceg4dBw6Dh2HjkPHoePQceg4dBwfHocZ7ty+Dg8f3oHw8FMQGLgXXeyE48e3
mMHPzxfckG+GEye2QVDQIXj8+D5Wef29h4ogXrsWzrkMCuyLF884wvLfQjEy
FEo9eHAbrl+/ZID4+Msojo+/wimFJNKBK8TGRsD9+7e4REjIkfcL1qSBpdgl
Jl6DW7diQULPcRInM7AwISEabt6Mghs3rnIzCDMVorHwgYJLwUOURrh9Ox4r
oG4mvEQqYkIbFxepIN3znoekLVREiYI7N7ACAozIbaBScMnsw0B10aDS2CSU
d+8moJujfJRYkoExE16Sq7jJ3gnm9xVdGo8I08C4DIyY8NKAkGWujPaDITVo
SGk8SnDvXqKMSx4JlFJJHRHUJCfT670NWhqRCFWitclE6AwMz4Vb8WHAWSJJ
QWJkVuF01yaVelSRnjmz/4MjTcKlllZ5hMtEiGmIGhmtJarnzh38IGd3ShEe
OsvTeQuxGhhoBmW9um5FcRrc0NCj/91sEgBgYc2J4WZDRUuTnDYbjx7dUxAn
aRGWeBlIzzbqcqtOqoiI0+93AbCsrgTv6dOHDFsNtDw4MmjQLeuXBXJUVMj7
heyqQX769BFDU5dUZYmSaH2QeBi4MUw6z1KT1PPdh5hvL1/+w7mMytbm39yG
Grj006fPYf78NSBgwICZFtaDGJqQikz+nYr2HziDFSG3sJ4sNGiVUIGt71xR
XGwsVoTcwnqy8N+s6N79R5yz67+8iglVt3j1HujWzxNzxI3Qvf90TtERyY0z
ZjZjyLIHtagxbaWSEhPlUt5lqmCpNWWrcIqOSG6cMXApspRBypxa8q4x+ZQ9
XIu5hpqXaP+SB+jLF68w/YrTJH9JMjq+UI8v+Sjr1DKynVzupcQKo1b0BRd9
JcguKzFBVtmIJXJ5gxb2sRM3QxbmZs6TXEbySrXJmkwtg6c0BiwrrCvfCBcP
ip2qVvGTF2rvO69d0dEx8ASHJQ5NiRPuyJ/xSH2KxydMcpplT9T8cz5KnDIq
ck1n4ITBytVzoNXveRZigrTZiCWyxqAFbPHSgxg04mbOk1wtr9hkZbWrppar
eMZRongdrd8CTjRsnhFONGqJ5yxMsohUZPLUqnF0pPa/QxBzchCvXonBZf0R
E43new8efR0Sev7rkBCk0LCvg5EoHRzCsq9COa/Kwkj+FduxLMx4+8492deD
x7LfB+yT0gIreMzsW2KJXJ8cwK07gmDN2qMYQOJmzpP8noJKscnKapOV+jFX
QNGROFYGCGjYDM40a83kztzIMtISoa3EPo0Kzkccg3cIZHoO5OVL0ZB4655M
Sfcg4dbdrwPPBIk1a9aIVStXiZUrV0pixYoVYBDLly8X64YMFMuWLQOJuEQi
WWukAhZHt+5KnDBQEqKjbsCZ0xewrSePBqMs5OxFvFxPYAu2Y4VdCu2uXrnO
JYhSocUzOdV02i8ELl2MZUlkeAznycb/xHk8s99iTFT+XGCEJmfHbloVYZQS
FI9sxBK5FfL6vHNPMGzcdILIVQk8ZTfIIiVn4DyZUhHJcXG+ySM5sb+Hw4WG
Bw0EHhqNW8DZZh44NIKae+COjNIkU4cN2VItakjvok/q2ndd5+UlKzIyCmKv
J0JsHF5PxVIM206dOkMsWrRIbNiwAYdGQkICZBSxFy6IKx7NxK2oKJGUlCRu
374trgWHiKT4eHHv3j3x4MEDsWrVKnKDdItdSpxzg2XL1sD335eCTFmyMDVq
3BR8fLZwD0VGXuNaJda4sIzyqq2aX7R0pWzDIGVrgxMtDn+fDZvh8xw5Yejg
0SwZOHAY56lY/gIFYdP63RAackVpMfz886+ayt43kdlRpUShxAW1MxuxRG63
ibt6/8HzsHWrP5N8LdOzB+0f8uQppclNzM1sS2W4I5CU8hKr5XM7FSNyI25Q
SmvlKOJI8qojrzBBLdrA+ZYe6qbChTIS59xZTnp1VaJy3HPyQOCm0cB4981i
eMRVuHw1noYs8qwFd+05yItNYmKiiI+JERGHDnP6/KrV4uZvFcWTpTN5bCWs
9xahLVuJe3fv8th6+PAhjy/yIiGnq1NKDxk2krulaZNWstgEbf7owKKJ46bD
qWPBLJX7zo37jvLWw4vyOb/4QsuzH7mAybkBOrOWqTh69+wPEyd7sq5n774a
VhUUDUjNvUFzT2R2phDEmQUpTaQ+P3TkAuzec5bJfnypchNzM9tSGdWjUl5i
tWV8Uc7FgUy2c7NyE89u1FUsuHlrON+qLTTI85Vc0gQXPNoZlEsdkpKWrNTB
Zt2FlKJh8s67r7ALVyAsIhouRMRInMhSb+asBcLT01NMmzaNFjKxvVEzcaZF
KxHp0Vrcr/ObeDSpuUga1kycKJlH+I8YqQ21h7eTxOrVq8lNDDYhLJy8RkOO
nJYeN8AFlBo5T0sLyVAid6BZzdqMNE1t0NRE1mPNvohkX0iFIJubuIA1LItD
20o4Z3AGIZS4oDZmI5aotJs6+9jxSLyyC2aSbxngsHDhrJmVZETmREoBidWW
QUQ5Fwcy2c6kuSEoYXhel4dIWKs2aB/Rpi1Etv0Dfvvyc7m0gbLqBQ9JSUtW
cgkXLk29xaDClSOOjXdZzeSLopDzV+BcyGUIYrpCx+bjJ0yjlUncwDMhrWRB
ixaLHTk+FddblhdP+zYQ94dUFef7VhJeeXMIrwoVxcGJ40RA7y7i+pZNNMQM
7MzIbq06nsXWYynIVm9RmxyqpTQYyENBVRpTU6nBRs0yoyMtUShxgQ28ko1Y
IgvlTfap05fgmN8F3GQTN3Oe5GpRxUZitWXoUM7FgUxSNKobiikRDYhwDw8e
KHgi6tABY0IDR73eJiKpQbnBRDrKq0TlqDz5CaJdg9wCck0j4l3G1edcOijk
EgSciQD/M5EQcJaOEV9v3rZfLOndTWxv0lCca9ZCRNapIeLblxNiRw/xz/Ze
4vn4+iK+bmlxukR+EdygrLjZoKq47jldPHnyRKz28mJ/AehP8SkpnUs9Q2KF
rIcYiax72z8gXBtBuNG2V0uW8iaH5a0MMiprV05NefpUmGXpPB7Khe311qNJ
xWy2OLVVsAuBTY3MRiyRAyAPs4DAq3DKPxJ7lrgBx0ckp5QccqMmI1ssI3Fx
s01xImW4mTiT1caTOhI5b+tN7VRtJF5q3x6iO3WA6I4dsJVXO3VSljJ1NBqU
yziSkZaIbKkMlVVHoz/5PRvJkQYDj6N/55bYuXMX4fip85gjnrXLX/2HiflD
BosDFSuIhz8VE0+aVxPPJ3uIV6eGi5ehU0Xi7C4isMVvInZGO/F6a1/xYkQP
HonPnj0TXqu92IsEx0+ex9qPnwyzXer8TobJPZqee9TPSr9h3S5YvsSH05Uq
/QJ+x89r5pJyCvSz9cd5K4P0yQwa4y6E0kOGjIY5M5dwujFtIMnQaFHjXo0v
Si2DjQyITIrpcauFky8uUSzA79T5bMQSMXteGYNBwdEQEHAZlzriZs6TnCyI
FBuJ1ZZljXIuDmSSolHdHFfc0KCgARLVoT2CjO7a2cFSR3lZZ2Q7sqdyfqcw
rn5yp2PraAi8++3xwLMX4SiuHkf8MJBHMJHl2zU+28W8efPErl27xP3VS8T9
Ub+L+yMbiH98eosrc7qLfV0ai3W1KohHBwcKsauzeNa7jnhy9ap4/vy58PLy
MrAbI3oNth1GXIVln39E0VevWVe79quAQ2jthl2sMypL1xErP0SaTrJ4NGge
GzVppa1LlCYZERujjGog7Xd584N9WdkzcROj2rvTz2ZchpFOUPOyEUvkwMnD
JzT0GpwLuoLDh7iZ8yQnCyLFRmK1ZahQzsWBTFI01m4Ilzp8YrrQOTK6exeT
vJ3HFEaVpOpgOcIVq+0K4X5+99HiHxgBBw+fgwOHz0mYOAsft+0/4G+xYMEC
4b3GWyTs2S2iulUQUW0qiIseP4vdNcuJjY1rCZ8mVcWNMXXF/d4VxK1fCoqE
74uJKDwXent7sxdyqRytz4OyiMm6q1Sxi0VhBL8j52zt/dCnkbNqF6KJ5MxX
emcK2YVJOxfajgfUCQzG2WzEEtlUHg8XLsRh5+ElDnMz50muulVsJFZb+l7e
38g3AShPWpUsLuSWUi/TOSema1dEGdu9u0HpKLv1hHUoJjuyp3JK/53DqskV
deu775JO+0fAzt2nYM/+ANjLFFhw0WIfsXTpEhGwdZs4U+J7sefbL8Wxb3KJ
wLplxLVVvcSFkU2Ed5l8YlPxL8W1miXFncXzxONzAeLZ6aM8OvbsD4S9+wJV
n9ajg1QKWXecKnZhboBWbTpBnu/ycU5iboZiJX6AEkjHMAIkUWwM1r6OHwnS
fKV3pjAyN8HcBd5QrsJPdqMDdYKikI1YIsdEHh0REdexS2N4dMQgHsqTfK8S
OcVGYrXcrXTzgMiVeSZldMRoZOsiUB4dXTpDTI/uEPdnD6ReENe7p/V1GWYt
V20SZ9OzLZWhsuRjr1UHUOdSJ7/DnQB5pJxEwfadJ9nhzt2nYeee03WHDZ8k
pk6dKma0bCpi9+0T/jPnCN+8n4tns/4Qry96ipcrWovE5iXEvjw5xa6CBcU/
//wjXrx4IV6+fMkjBX3ALtkX7NpzWrnmQQmnMsupYsVLurCVAcqV/wmyf56D
cxkcyFwVWcvWHblLKRdGXBDkbMQSWWjUJjz1QUREvIESJi0lUUpipZs2iakg
kV1RZVtJXZyRu5hksu66bVlsJXVPXE/s2r96wQ3qXjyqN3W4f//qpZHWz7iw
WNtTefJDUVN6gnuGeujd7y6eOCX3s4F5lsrjJ8zB1WCpCDt/nu9KxwSeEUHl
vhf/jO4ongzBa/EOP+I1U2WROHGMOPdjabF5wkTu31evXuH5ZY0gNxb2MXuV
74KEhcXC5Us3mK4gZeKUmeWkJ0sixVZitYFN7e7cksItWTmK0Y2+GLd+fSCx
f19IHNgfJKu5lDB8IJOBuavNGky2VIbKkg/0ZVTCQgH6dy4I7EL9g+f0pWLc
uHFi9uxZfNcscFBfcQfzjx8/Fk+vRYmH5YqJW/Nm8jR6lpQkgqfPFM/xguD1
69f8DyhHoZYXr7DzsRAdlYiLF3Ez55OF+HxsVla7JVPzv0sG9YWEoQPh7sjB
8GDiSIwkxcsFbs2fDImLpsDteZOSpSVlX0z2VI7Kkx/5f/D/RTi3bDuFOeIZ
G/cbMJbvi8dEx4gHd++IqL27OZTqNVRIz17i6b5d2oqEIxYkCiYY+N9z5IVI
ELewbEolFKDbtx5Cws37GFfiZs6TXC2q2GRldfZkaorD/b/7wb0xQ+HxlDHw
dMk0eLB+Ltzfughub18ESTsWO02THdlTOSpPfuS4yvD+3bju3kX7Dt9N2GP/
W7Z0B6/669atAxNzg/CaMUNsW7TAIhNkbGEfy2W59SHBsfDg/lMMGnEz50lO
FkSKTVYnamrko0nDJHg8fWxGeLB7KafQNwpZSUaSUh/hViPxbuvi4SPBcBKv
BgVsWO9nYXmJoYMxU1YyysCAK/SIREZlX0dPS5CIVGgivYW1C8yYv44bJpZN
hdeHVsM/l3fBP7eQEnZiQ58jN3L6uUKYlsVm2QzNqRgVJzfozsCeDdwgati7
X2WQl5CQKNixHU+2q1cdtLC8xNCv2maizMqDPyQjLZH0FnbUHKLMzF1t7IgQ
DaNS2vi2TTTLz5WtOQTx8bfRYTTs338OtmzGIYBCC+vENmbSsAVZUgmSvlX1
p5Xqx49fBOER1/jpmrjYmxAUFA3+/hcF1WJhHbhSM2nYgiypBJVED9vfsnoX
bv2c2es1CA/uP4SkW3cg5totnA8otbB2bOTCKjIhUxUDuSBXaQfibzURyUtw
MD1aTYu27eNlHeRtMVVoYCO1yh1prjJAdkWFDTBh/BJ2RR1p1+ftWWhkNZlR
AaSdaa7wjNwKfuZRZV2I7U6zK7uoMLure9G96F50L7oX3YvuRfeie9G96F50
L7oX3YvuRfeie9G96F50L/8PeXnDm45cHb7pKG0wk7+nyKS9p8jKE7zRVdre
M+SS7D1Daarsje8Jcn/je4LesnE27/nJAKl5z09aOsTJW3oypOotPWmpKDXv
2JFfYZLSO3beMohvfEeOS7J35KSpJqfvuMmQqnfcvF2HOXlDjdnmDTVpn5yU
cvR+mfSQ0vtl3q2elN8OY7Z5O0za1zNKOXy3i/sb3+3iaBTYvpaF2d00v5vF
zem7WdI08FLzbhX3N75bJU1VpuXdKK4O342S9rFi+2YTo9PTTmBApCNmIJYO
Em8/1iwx7YgZbYxeiZeOmIFYujdY7iNGa82dO3DidCj4bNwDWZibOU9ysiBS
bLKy2mCjlhQ3JDsyfQ6TxNyIfLYio+NsN87IpqpnB1Bf8DswrNk+YkpBQnDg
YAhCJW7mPMn5FR1Iik3WFNSIIiscm7kEPRIgVW0gbgvln39e2LF9xNCU/AYE
XoRjx8/TD7eQmzlPcrIgUmyystotmZrqJhTBy1YhrYTzy1fSr5JXrMa15vyK
VRCCMtKRjRxPLGWNT4Jnz567fB0REQmGryIjL1KKcxJzo7XM+OgRDiC0t2M+
xJT2BJ69BP4BEdge4mbOk5wsiBSbrKw2JVPLPU+IDdiWVRCObYhY7Y3rMnET
RKzygjBsndzeVUqbsKRtm548eQLGry9cuJDWVzTIz4BRcSJB3I7JWiOjDgq6
DGfPXiTiZ8FdOGdmOelVP4qtgdQSnD13MQMbuiUzpOZQQ7nZ2NTI1Wvw7HrR
aw1WSHk1HGhnpAK2rX708DEY2s6bN9/upQPpU/vSAUEu7JgPuzUxzJDQKAgO
vswkn3l276KnzmbPXqzJTczNbEtlqDSRUl4itRIs2dzeUB4C1EojXPRei633
BmW1dIHL3mskZa96yXsN68lSiQmWQA+2Qbl97yFkKXj8lP+7/FpekBs75sOu
5cCcvxAN58OuMtkHRpWbmJvZlspQaSKlvMRq+clfKkZkIu7CCrdk5dSxQvG5
vGYtbBy5EJTfjF9Z66M+XkxS0pKVJUpY3kGU6q1c7f0uP/J+U5ToaaAL4TFM
8nmdm0dZMyvtw4IyidWWsMi55DIzc1MyN/JouoIRMECUjw/SOkukSLROfdCe
pKQlK7UElVY9ScmjdgfPX1maL1y48F1+t0wbqTt2zIddyyvqxUtxSLG4ohI3
c57kZEGk2EistgRFztnK6MjTx8gK92S+qL1X167lOMTg+nENiY5axDDClFfm
I5OsIymHk8vLoww92sbrZsJ9yPK1f0DIu/weV5AbO+bDruV4Xbl6g9+EkEV5
FwTlSU4WRIqN/OIES2zknK1MjhemjMqLKux9qfGKXr8eYjdugFiMggTXNm5U
xpMaI/X30CQjLRHZUhkqq8TMSE5tQxZ/8zZk6TJ+wuR3+dGoIDd2zIddyyGL
jk6Aq9i0LMzNnCc5WRApNhKrbcNjVDjlSavojJxxS+aJAkYNvrZhPcRt2gBx
vhSq2E0blaUq+cCSdWRH9lSOyssDDD3aRivuOkbr2+MnAt/lZ5GC3NgxH3Yt
R+vatUSIiaFoETdznuRkQaTYSKy2RIvOCEaFU560WrQo45bMkxqtWCVS1zf7
UkR8N5nk1QtTFBuUkpasLLHB8raxiY2/CVnaTsWJ9A4/AhTkxo75sGs5NnH0
/pxYrIi5mfMkJwsixcZAal7+gZNakIycc0tWjtpEEybO1xejsJkjgd29ebP6
Uzq7wcM6jA3ZkT2Vo/JybNCjbWyu0q8kCu7Zc+xdfgInyI0d82HXcmzomWB6
o1cW5mbOk5wsiBQbE6ldlGWDYkLWRBLz9MnKcWxwllCL47cibduKxy3W5zXM
Wq3hZs7LZpu5GBXn9Qf9OYhM3fkLVrzLT75SE5nr15MwMsRTiAyp5TbQPLLM
KDlQpCWSmLs5DFT8FgzQ9q1wE1t/c8dWsN4nkVwl6zPeDcWedVheHkTJQxUd
D1kqe6/d8G6/nEI3dsyHXcuhopbduIGrHHMz57mNaEGk2JhY7WA3aWSFW7Jy
1CaOyfZtkLBjOyTs3KH9bIpikbBnJ5OBuavNfEvYvZPtqSz5kEdSdLxteC5f
wWXhh02+u9/t107oxo75sGtLeBIS7tJPc5BbwkMWRIpNVla7JVNTFBJ2becW
Je3bDXcO7UPk1FYXuHXiMNw6dQSS6GiXlm1MbE/lOCLoRx4p6Nk2FJeuxEPG
xjNmzn+nXyqRFyJB3I7JWoNyYfUU7t19hDEhbuY8ydXyik1WVmdPpuY98N4d
cPvAHrh35AA88D8G94JPwr3zp+EOUZi/8zTasT2Wo/LkR44JeraNSWQk7rz+
d/x4UGp+ZYTGdsxHdsDIY2IS4OGDJ9hg4mbOk5wsiBSbrE7UBPDu4b0S3Dt6
MCPcuxDAKbrLdXgvK+WakNve6AkPj7Vj+4hhY3ft89OAYS+qN/ioQ9XK0UR6
C2sXiDh0lEE9CTgGTy+dg6cJkfD0HtLdCLoRgtzI6ScKYVoWm2UzMsdiVJyv
KA8dNZLnNzVtP1dv0MASZVZu7ZGMtERSGu3U5hBlVu71kUy1MyQHl3y3xsxg
vwVKi2XSnceOmIGYrWXye7rKBgRZOnj2XLytYzw4YiZVb/OTEQsz8W9R6BYo
vRA4OTPxDXD6PYvPPkfMxG/SToX/6Gu3HDETsf9ef5wPBvqPBKeIQh3I7Ep3
+DdKmx1YGuxk9CdRikWZZOSqzMhqo2aoOJEonVErpPhUDSSHNahmBs25HTDJ
1rOd1mhX1mSjtWkIGG10Nm2xVJLZVuYQlq2dXTMNjhRaW2VXLg5RJg+7VYiV
P0tH2HeYFisnnWNpk12Lk5u+MZ5Oe8JJ3QYNsGRbt12MOZUlhYodjVJHgbDr
QEMKLjM5i2OyCeJkJHDObqK1f9NEM9m4SKkp7k59uDlsj/0xi+Ox73T4vCG6
zso6GhKGVAx2QwpTMxVQsrxjdDKlGmJqbBzhddzTLqnsadMbJ0PqRtK/Lfs3
RmZqYpa8vW+eqRnT4CPtslTNpAxpml2pXwzslpm2snFal5ms79hxKS4pRnsX
klVrVJUxhS7K7BTdf7qSOKrW6BSKbVlHi5/zev/dlcSsxdjpWdnRtu6d5+j/
OevIm9dIB2sqR8x+9Xd0fNuTokXmlqL/tI4hUyqjmtalwmiPyuQM1X+wVCh/
Bq1eu/XC+TL/n60TFiNbKI72i0YLbqN9fY5hJvfr8LrB2SBIaUEwasM7NUua
5s3R1h0cD620oUzlAmC0Q2Lr3vmgSHa+sTelvyz/F070NHRICnNdjobZGZqU
uyMtZ4pUXmdY2mR25tbqQtnBjE/NSFD+UrrsT8VZ3fn0SV1EnJ6PJUuXpHZo
pTDV7WrIZNd7js+L9ufMlFA4i8+7n/PfHZujCFn7cmSf9b0sBo72XMmGIg8R
s1UpVW/fd2+KZ1rP9ine6HM0Zh3f6nJaQrW1u7fjaKKqutTc3nNc0m6xd1Sx
I+cmO+dv3tM73U1bvDi6zebo7J8ytJSGdMr3JR1PXptiKd3wM1q6NK21p1yT
8md3T84qACnN32TdbrdZcD7AlDKOsDq67Pgvb/zZb9yJHF2Ju6QQDke3uz5x
IHM0pnI4kDmavG4OmurI7qNU1uHoNOoo9jlSaLej22UpXfZ9/sYh9WY82VM5
Phz1q92o6GQ1KpxcJnyk6VI6/WXWBvqnznqdCzrCbvmPhX00Nc+sdX53yMG4
c3qRmNIJPrtWl+t/2K/093761dHscDQT+jlAmNuBXWEHsh8cyMo6kH2XatQf
+j+gdp8ntjATf6gY7L4qbGEm/r4w2H0M2MJM/Aldh/rDyheD1a/Jyl9iTOGT
vAbtk7xEUlqLm22KE6Xti75UIp3cnNPyc88njwZX1lJ2/7PfqDzvlNK3ctVn
npx8K9darX0r16B9K5dU6ZjDf/xZW1/i/PGNyloK5PfuqyZLtI/eLiTGH8Lt
+x9/+dbk8Mu36dgfLYTKZ2r5y6/yJ2Yfa5+bRV2Gu/EJNWI2+GJelT0G+ZOv
bvIXY5Wvxjr5TC1sJivrjxBQIaKfnCksX7b9UU096vuBP29Li7XyHVr+jKn8
MdT02sdN8Vjo6tFTVx6XLWuRJd1zib9+M+PNqDj1W6uJSXedfY1WFZuYu8D5
4MscFXp4kCR0pDzJjSwxajb8ObywKIMitvvcrCR/YkZNyYXNWmEsqKWxpKOP
3nLKpKUUjPTVWsrRUf7Aq/YZXFdn3ll79cp1p7VICjpHn8h1Yv2u9WJzqDaq
xbo2KeU4mZVgk1gFGnL2ohLnM6cvGBTf9EFga9+EJpNsZRn7au+rlarfJlZ7
V/k2scFpyz/gZ4mNzhqzRPte8UJigsZ533/jo8Um++Js42plr8rf7kPGZmcf
Mk7HRUH+9u5Hli8GxyV+dvFcmPxp3bjE8Se7DxKidNHyiYcOU/7Ta8EXjp4t
XTVdbFyC9o1a7Xu1Nl8cNih5mYzMXaFdh04cXvroEn11+Hz4ZfXLsXD6RKiB
zdyhZau22ldWunX/k/siNOQKa+2/Kuzoi8DWHzJTZUQtW7ZhTa/ef0Frj3ac
njNzifX39xx899hxDZpC/u7eiVPyN4g2rtvFUFUIZ/3DU6oaonDoLlq60v6z
yhmcgXH+FeVUtMESkTTCsa0+b978LC1QqBDs2HZA65oUnJqUb0J37dZbQ9+g
YWN2G3zuImt/LFsOSpYsDQH0CTQSuMC8+Uttalu8eDUXibl2E8/4Gjxzsp5W
Pnet9tD/j7527RAN0RLtM9gLiQmajH3/g29hK7/AfZePX5udffw6HddGT/xf
jZd/UZepyIkdh88dL1C+SMTOw0eSKtcUokzRpJcTqi590O8PcTODedbJ1r3k
Txhfkb+rfPkKfc44XtJ+lhevfHI5Xv66M16/U9ApgPR16rN4Ppi3YCnnaahR
SOkXjmRJH49W7eiD0pRu366r9kVr649PO/lutPUoU2Xqd6hprSC36iilvPUo
tJS3fAPbWi//tDAT/PpbNU2mQmaYx0O1bzYGngqzr9e62hS+v53BYd3OvrWt
FTM7LGb3Ve+UIvFGSNYQyLg+ricKBMdNNWh+Lb/YdNXc0Eq1dcde7XykwS39
Y1lJsVX1NWvWhfCIaK0aOp/hQMroqPlE/y98IV1yprB8Op3Z+v/2++lEJvnz
2P/NB9NtVidabS4E5C4jDsNHQvyc/8XrUt89eTrhh6ehowoIbzdYuq5hRzJv
Fjh33uDrY0eZLkfGOFudTEp8zwSFaz3fHKumaYwdI4fWncda2PmrjhYg7QOG
qVk9nPaXdSGqyLZQKua2g3GBJ0jrVUpdgPPlL8h5dZUKDrpkXYN97alcY62L
qBEyydcQqV6ZrFUEI5WRNNpUytcUdo7t22RSph6uMm9qp7pi0UJH2hVL17HE
etXCwcIz1GBXue16ZAXQoNRvN3TeqqPTMNhs+kUJgv1odhwDFfO/tQbRd+/3
Hwhmkl8twYsHZc2stF90UCax2rLoyLnkMjNzk5UbyxokQVirNmgf0aYtf9xc
+3qfgbLW33AkLVlxiXRUOB15SacuR2F4JsrieiEoMssF/5DSgT47vgndd+L8
udzfibs1/ifErhZhTxbVf/G6RW7xNIeLCIbM4lT6dCI0T3bxOne+3EF7/cgD
uYnBcRAWHg0XIoj4bRu4KKLAHWbNXqjN0nz5C3Bw6VhJ+dQuncYC8TqfrK3H
DuWtBwLmrceJvVqyGLhoBkS/VKnK0imTZ1stRMnnqqV+xxUYZQkMHDxc2yAw
/gkz+Lhpw27tDHn2TIR9vanE7tjA/EbMbg7LpdT2FEAY7SuS22503CaDTbgN
9m0JCbmsucILNDApZupKrtWNMsqrW2m2Y5HJ4tK2Lmu0qkwzfddR9EYDg02U
jKmp1GCjVj5C6rRxThRLiAuaaguJCZp+fXkOyjeHT52+BMf8LtDbvZCbOc9f
XUQLIsVGYrVl1ZFztjKrd7eQwkXzRTjCwmN4OaKv2dNCg2trhw6Q/IPlJFXf
RUI6yqtE5ag8+cG2pGOA9C/zoJArSJe/Cdh5eMfJCtXFP2Z3If6Ha1KlYg9f
eTUUr+8MefQycsCTV551Xl7/PseLqN++S3ixsv2L141Lw7mQyyYqTPfskFOK
jrLsI2ih3COihUc9GVrneQuP+2qyzpHTcmI5g9d76rnOHxcs0lsPlSCrgS4P
FZRYj0VycAZXBjIkEOjcoJQ/5RdiU5ZMrX2fPXfRoj9GixE5yQj9BgxlGV20
0cQhXLS4dujYXVuMzpyNtK4SrOtMAXOGZBVTAeuABAaEawE5ffK8fVOt/aIb
bbIqoXUQgRTQuGvnDVWpdsHpE6EQ4H/BQRMNmlN5MGjOjNznc2Yt4VytWnXN
Fp1B60tL/9rK3FM2NtrI7IaAfQu1uJh4s55CAN44xjKyIIX+STagSe+oHSlE
w4liCXGBs+zKQmKCsn2VqNNyERB4FU75R+ICQBz75XQkp5QccqMmI1ssIylQ
rIsTKUuTUSlru1JhSnLmTl4C1AXrUvv2EN2pA3/yXIKrnTopOybblye5sYy0
RGRLZaisumjROpWOoQJ8BgFnI8AfZ7g/HgPORFSLXLhaiEa5hWhXKuLpzPoJ
/wT2i7u5u29QQOtf/9mfJ/uzZ+F9bjy/9tfpR51/JXulbCSnA85EYj5S84ky
EwuzQt58yjRQVg11K6Xm1VMove6wY+ceyjZlJt+o4NWifVdsNPqyHrHkWhla
krLpsBLx6jhn9jI4Qad9Upgoqe2Cvv++FFanjic3mDhpls1dKd8t+2GjskP6
jhYqtDWyn/Swes0WDTYtZKQj2GozabKe9g+XqzU7rFZti4w8sw1ysl2xfL2N
fbMW8g3noUPHalFp2rQVl0tLE1KPyd0GE0n6/DVE7o0O3bg83Rqi9fo0Lmwp
hdik6Er+UFoLGx0r//wrnqG1XjVovWppFMmCNJl7ysZGG5lmmt5+tPDOd8VS
H20oJm+8KVnjtWpkg/TJDJz0kBwYo5V6jP1OVEVsUkztzq1GZ61eQlzgfItc
SEzQjOvLU1FexIKCoyEg4DJuToibOc+rkzw5VRuJ1bYrk/rCMsqTVlvEKONi
8aRMdVpYaJGJ6tCenmjq2tnBrkr+3DXpjGxH9lQOl550vIYghOOn8KR8HFf+
TMNiJg8T8ZOKCdG64NP7E38N96v+/dWtjX56vOGHryLu+Xo8f72wrBA1cwQ9
KvrjJ0d3H+dSanF0dDLMCH4nw/DyZ9e+U1pHH/cLhYqVqzjM082m43hKo1KN
m7VWhxQmWaSQo520Miw0rYkLfZcvv1aQ0upJj+pbv2mfjA4lvf4cxHpKk27Z
yo0aJpKTrYmtzaxTa92wbidLUW+9SbCqUsVqXaPRDqtRW4uVuiTFjJqgVsXh
IHH61CKWFMCqmWqqwDAqdasx0JZxEphsKqDjrLnLQdU58mi2KkfymjXrcAdR
d7qwzlUrR3I/pZvVvcbxo8EZ7TtXjaP10pJsHLhpYsrVqFVP+z9YspgrfWjV
Wof9YamcOkCVWQ9CORAGm4g7Am5UgkKoaGxbr1VGZ61dQlyA36nzC4lh6uT5
vsSUJSU09BqcC7qCSwpxM+dJThZEio3EasuSQre6jQqnPGm1JYUyLpqn44on
dUmJ6UKXaNHdu5jkG9eYQickVRcQv1Nh6Qgs3R864hdCDOcmHDke8kp84iZC
iriJxGzuwv8Td+FXKMfzraXziOUFcoiYhp8JUT27eJ7ecOtJtk9O3in6Q9kT
81YZyAdCP4pOKEVkZJcZYOwE+YKLTnpHjwVBj979HeZp63HsSJArFbPeTDMw
q244cizoCxZabiQc4z2yLPsur2XIull84ep2JIhNiKx7UZXltBgbbYxZjIKP
OWfSapiAgMnBMWyEmXWu0AivKkm3fIkP+KGPtRt2KZOr7v/X2dXFxFFF4bsz
yy5LWxa0lRDrQ2OaWmOMtmqiKY0xMab6YKzGFx80PEFDi7q0wdoaSSHGiihR
awFXqvJQodBC+VlwfyBpWggL1aY0JJSkFJSySBSENJDY6/nOzB1ml93U9OGe
ueec75x77txzZmdnZmcx2Q32gOyD2wsmbty1UPfd4jT3vNpnJNFS+cpIpXCa
c1XFHl8HKYz8oBKLXwsiKR2u+EDMOrh2bYoy9gbVAaiLeciBQDMxOtR8lVVw
1yoIJ3PuODuMi3zGWfvEvn14kqSoSL25MeHTlHWoA8IBDzuK08FpS0sQ7h2m
j5pw7+XczubgcN/WJ24O5TwmG8WDckhk3Ix98VpseenricWvXpL9W3RZIzIX
x7zrtFB4iOIkK9pd8ICe2oZ6h03pevHGm2/xPsNpTjgyJKqq65LyuDBxoe9y
OszUlc6LtKrwonzUU3rxEYjG2Mwaoxjy8wtFJDJszkUX7+QXGAdNwnlssq3b
HmFOWx1EtwZB25wKTLIndzwtdlCD040soy9cpzusPPmkgpamF7fkoHOL1vY+
1u15+VW2QS0AV40JWwHoqyd4RhmoUGwR2sXulBG64iKExMToqWabkUrhNKdX
6z8t8na/EFcGuolIuIhaD7HEyteCSLA+M1Yk7ejo75TGE1wEeLc0eMjVkCYm
DWr1qk4kP9BoGtMMm50xRy6CwgIxsb9ITL23n1qxmHr3gP0+AbGrdxE0ZtMY
CxvYwkeI/DnYq70iNgZbI3ooHEW/xF9YKicf9Up57u3YykDBv3fKHpfyuU1y
Kl2TF/X7nMFQ9H9UxDpeNuw1JAgk2CbjgVPZi1VAMtkTUq0Mlv0hmwxJaceB
hxxcZhJ/DxtpQG4eSLBA3aXbUh0jqciOVVTRV1HSqQeh2X2Wul6sMstrOXcn
GXp9Ell6QhFbU+GBTqXMM6d1sEWOjI7+oRsJpXoaehor061jqT39Ek3NcxKc
iayekxhZSRBuhjuPzd1qVk4doGwsKRbTyEjaqlvonJIlxVazUhMv97XhYW9m
ppmYFEJPcJBaVG017nha/LtekfLFXYfHyj/8deH1Zygtc86O5z2fE2rq7r/1
1O62Y8/uoVh7fhnURDdZp1E3Sr1BNocEfYleDYiE71oQ9AZ9DDNuC46MTIrr
Y9PcxsfwpCt6LpZD32M6NbEaq50MVWb80BOfzYHzJJhGedLTPtoRB98XsUM+
ESs9JDRbPc98VMpNZ+qJ+7gDFjawhQ/4gk8HzxjX3jsDA6Kze8DYUusKDNwf
ONMzcnX7zqxgSxgyR0egX8rM3J3hb35gLGH2dh+tymptDmps5FRiY9s9wGIJ
SQ2IBFtryXwMNQ6EI1cnxQ28Apipi3nIu4xYFCab1Z54NY3FD6p+4BMzR0rF
X2WHxcKnZbRzsAvcYvbkZyJWVynmvj2+pm9gXIyHHezhB/5oDg6eFq1xe+cl
oW/pOtXsPd8UZE4zZI2RvL3bIv4W5iRoAmkzcBzt3Ow/YubWPF4aS9TFPORA
oJmYbFbnrlEjqPmPD4q/y4+IpcpycdtfJRaaToj5tjox114n/uz4LmUfOOBh
B3v4Me4rwzN9grSe7xf69p9PNG3qaAgwJ0ETSJuB47Cu/DYpFuZv02xAXcxD
DgSaiclOocboi8ePamLpy4oNYiHwPffINwlZCZCDKYVytuVSAomAUMqVV/7I
fqOD4/hPHPUWU/xJDkRQEUS7B7RbVJ9s5FBk/efiTqRBrFzvEiuz1GY6ac8t
E3Vyf9ls1DfELgNGcJjBHG7IneGZJnSm6UIC6QWh+asQ0bzmj5sggxZNuwcc
Rkfzmr9bsuMcTCmkhp/CyUgayN31wvEfzraz8A==\
\>"], "NotebookImage",
 ImageSizeMultipliers->{0.25, 0.125},
 ImageSize->{320, 256},
 CellID->786129878]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30858],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreatePalette",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreatePalette"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CreateDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDialog"]], "InlineFormula"],
 " have preset ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 " which can be overridden:"
}], "ExampleText",
 CellID->1016594877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"CreatePalette", "[", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], "]"}], ",", 
    RowBox[{"CreatePalette", "[", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Green", ",", 
         RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"WindowMargins", "\[Rule]", "Automatic"}]}], "]"}]}], "}"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360841373],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\
eJzsfQV8FEnTd7G7IYFgxx08uHMEd5fghGABggYIcrjD4a5BEoIH9yQQ3Dnc
3d0DhCAhuGt/XT0zPRmm92Dvdp/d9/kWft3b09NT9a/q6urqnslMrVZ/dmjb
tdWfHdu0ylStV6seHTq26Z2pavdetMoYD8AFAEyQCbBMaFnOmkH6P9KDEUbP
Gg4xMS9g1Mj59AzNv8uasjNGaNykK4St3gat2gwGL5YDrW0R0QsqbeoJFTf2
AQPLTfxY/pUqjHGraFMsmTR19JdRcOElepFyUqWsEsLkKiDuImhnBptB0DQ+
y100dcpl0jk38D8yDsbfCoagiwNh0qXBUH1FNUg+MB2MWTQKlUlgz8GL32VN
MaMIUI9Xrl6HiYHLYNzEpQZWMGGRlTTVbrya/QaFquWfuNpMtVFD1CTXKcTl
I7N1nCQ958JK8dV29FcHzkUoQzx2BLT/fBe0ghLLW0DJcH85+fHfhKxkpHlz
ft7Acpc47dTrkmLJgORczbRCTkZO1U9HVULSPA4iP0bl+/YSsgSsrvPpIBh2
eTT0O9Ubgi4MBu8V3pBhcG44eGov3L4TA4ng/vOo+dCl30iCJTVbi5k8tNAk
IlbvB3eWG2H5yr2wfIWUvq+TjvR1JswNeMhKRiy5COpcBTzisToc0rWm+0KR
+bVZasByN6i8ujn0uhAMHQ/3hYAL/WHkmf5QbkE5KBRQBF58eOkOsU9i6aXN
ew2BVl37o6gwh+VGdoz12IJgrmar5csU+TdtOUFdC+YAv0DloMqQa1ZpyB1S
DvLOwlSGH+eiZem4TJzjcux83HNGdjYh5Akpw6/HsnLddzSk5vE1JJRfeqmB
ny6tVEnIZjJKRrWNkbdBbgZGxMSv4eSwkEBmXlojHP4qQCUSuWQSUhs5GViF
KS5I/JVAuMdRSWlotL0ttDvQAxpubgJDT/aE3sc6Q+JeaWH/mW3w9s1bqqTH
jx4ZsLsMMH7KHGr146fMZaW4v393rjiWMJubjtUZ45ydA4w0QSZqtgazOAaw
c88ZagCYoyFWDCgHOaYUYMkVc4Mh59RCkNyYc0pBLCm/Lh6TCybzmFggV6EJ
JQvmGJyvcs6++Rvn7lGgfe5OBTvn6ViwZe6uBavm7l8oV+5RhZLnDCxk8phS
MB5NpRllNygxtzy02NUK6q6uyRx5rwPtIPsEDyg+rji8//A2ITy4/4Chnwvj
Js+R5aB1arYCM9qTT6g5X7p4Cfbu2QsbN26EzZs3w5EjR+HSpUsQFfUIzpy5
AtVg34HzTL6qo8tC9km5IFtwTtqFWErFyliiyegRnNclx6Q8CXJOyueeMzif
W47gPAk9AvMUyDEk95+FehTtmatTnt5ZmmUflaNpzpm5GuRZkrte3tA8dfPN
ytMw3+A8rfPXy90rX7aco/K6/z4xt+H3SbmRtpERNyb1mJgrY85xOfLnGfU7
GD3zDcsObljOmCvAA8+x87SMdZ55h2fDXyNWgJFV0QvYRQb50tyjsyM5bMEu
o8eMHK1DUgbG1VVDlV7IOeYIzAlSG5e4CuBlAysZNXUuLHeDOqtqUodbDSou
LQOV55eBVhsaQfw2v8CNe5cgNiY2AUTdu8+6LAkEBM8GY6LA8dO8Qzr0ZEcT
MJc7lLZTs+WYQWK4euUarFu7DoaPnAPjJkRAwPiVMGp0GAwZtoT+hsPsubvg
1NlH8O3bN7hz5xGs37AfKsOhw5dZB1cbXYbi9WDJyPI0FHUOXkdT4mwTPJL+
HpjrF4/A3Blyj8+bIeuI30tl6JG5Q+pGaTeXaFXqROYWWY5X7FUksv/g/M/X
zkn9Zn/ob4/nBmc97d853+LiLQp3z9Mxf8mcg/P8mmNcTuPvwbkY3ayB2QwS
U6pe7MCs/oX60QBwWNHu6cGte5FeGeoUGJiF9RJNtCuy4Hk861+wTwYjXgBG
pYpdZGC5CevwrHKpoU7+QVnAHatoX/+uCIVlxpVSY1Tly1gbGRlkD8z+nXKw
g7li6IjAPCGvKze3BNRb7gWes4tDqZBC0HClNyTrnhJmrAmCN2/eJIC7d6JY
V9JxOGZSCIwNnsWTchz318BKLnHr8gT1G3nrcYECFAnWGF3HBs5IPHH8VHb0
G+ZpsVk6XsogtWM0kDMmgkDULBwzGpicOX0WplA32K37ZAgYtwLGT1gFEwJX
U6taxSxq6PClMGjoQug/YB6zsi9fvlCxPlCL2geV4OjxqyxYqjGmLOSmysgz
OSf7zT3Fg/3mmoyKxVIKmucol29o7h6ZGmfonK5Jmr7ZmmXul8Yn1bDUNf+z
MKevx4Uqrau8qts93+dVU34hl1a5kxd73Qm5QNN1ms67P1qzKO/IIu0Keufv
lyddnoCcrnmCcXQih5QK7/wFx2TzL0bto2T39AvLtkuzsEy71DSx32Ele6Sv
U2RwljqFB2XyL9Y/U3CpTmnWlm1N67tnqFNkUGaasvgX75c5uHSndFhPUyoD
FoCR6F68d0a8FJvRcvphJbqno78ZPAsPz5o0b9DvnH3RfhkpibR4ObbB9hnz
jcsGBSjc3JM9IC9NeaZR1UzJwcr55DoqSnAOSAY5J2dn7TApZWyLZwtNzw0+
oZWh+PT8UHRKHsgb5AGlJheADAOyw7v3b+He3ftuEBl5l9mbO4wOmgkJU40Z
MZGVaAqYW8mXkBIFyiwZOhKPU04aOWH/X1mLxBsTNHMsVsg+h5JQszDMaNxz
+dIVGDs2ENp2CIAJQasgcNIqmDx1DUydtoGm9bS8DiZNXgvjxkfA6LHhzHIG
DJwHsU/fwvv3n2Hd+r1QEU6cvE4tJhM0mVgVSlIxykwvoPstq5YXlu5fbWvd
Xj5bK/1R/nDVPypvL9O81B7PZhWiSvmu/ZSrwipSo1UVsiowPjkR5k6it7mT
z8eptVxmVvPt1dFEi2t1LdWyRI+CHqXHFkxYagqnbWCMjJ5lR3nAH5Nrw55T
G2kPEEJoD0Q/joQ5YSOhUpu0UKFv1u40QeNR5Vg9tjhxeT94DszmX2Fgdk39
yXN7oVmXwgqZCh3Sdy+PlwZ4spqrkWexDvCycoF5JUkpew0JSrrcwGwZPYPy
GaDUjHx0DJedURDK0VR+ZkF6VIaW4kPJGXlZXfHp+aD4tLxUIJqm5aWXTMtH
XVOxaewQ6i6tRLnkh0J0Hss1Pit4TqcXN00C0U/uwoPoR25w48ZN1uNuMDJw
Bl0PjKD58InT8Cjf0D+HntmcNl++yX8O23clX0lCShWIfTey4oIzjaqSR4ld
py0pUyclNkyLV6XDy0rhoWxBlLKahWJGvQRa0Ly586CubzdqQREQGLQCpkxd
DdOmr6HKD5y0hmJv3LQ3zJq9ic5g2yBk9jaYOnUTjB0XQX3QAuZ77t57DFu2
Ha0gG1JG8J9WA6rNLQnVaaoxr4xUnlMKvOeVZmXv2ex3ie/I5R/9hnz4XL/f
xw8dhj56Nyjwzufuo15+bdD19bdCFSM/F63d4tucsfHJ/gXu5PZGd/LmEDWi
izRdYe5nf88hFfqU7VS0RNVRJZNVn1kaaszBMB45GD29xxdi3YfJJOdzl40E
rx7ZJlXtkRX2ndpkZNVG8B6Qq1v1gTnh1JUDINXFh1evnvHLqzVLzS6hlxrk
09X8UoNX7xzgHVQIqtLZptrovHEpVh+QM2P1acWg5pyyVIvV55WizL3nlIZa
88qyX6/5JQ3gNa8kHcLVZtOr59FEqVSeXRQqzCki/xaGirMKQ+WQolB7YRmo
NKMQFBqfA3KOzQS5RmcGaBUfdp3YCI8exdDQ5sqVK3GsJllcq8F0eXeqvGRv
vN8IqZTr89di2d+9GVv4/bkRuUhYwngLxhWrjm2aTGv9x8CtzZq6jJ44LT67
0IVJI5NgSVIjLTFBDYyNJPMI+azxuzpMrJ3UBy68oXISy98Tki5C/FIdlqQj
fZ1JQkKLBhkA1iotxFTYFSiPSSMhrzZqqk38hEFVQNwWKkG1qRnlGQX03eOM
UdqPahaKGTW2w4ePQJGinjBy9CIICo6AyVMi6PhcJQ1PdzY8v379Cr37TIFl
y3ZBaNh+WBZ6EGbP2UEd/2o6nMNZ0Ll+wx5QxqgR2s6vBw0XV4UGi6tQLTWi
pbzgS8sNWJ2cFlat03RaD9J0KCE+AwjpFERI6C5CFv5FSOvhhJSs8eh1kSoT
Sfe+WciW6QnIlTXu5BmGCOfkMXrZ/ea86cVGl/+jRJUaI8unqD+7CuOEtH2l
X896QaWYNrbsDwOvxqmgWv0U0LFHeVb36vVzqNUr56TavXLCmSsHWd2kad2h
Rocs4DOqcJ26AcVA6fUWfxSAqrV+geUrg+W6X6BL/yqTatJrMZ2Wr6d17Ngn
qATUX1wZfMYV5eeQtneHzFB7VKGkDedXYvoxQsMlVWg440vzBpiWVma/vvS3
3uJKUJ86dJ8lFaHekgpQl6Y6SytArUXloNZST6izrBz40OQVUgQKBGSB/GMz
Q46R6SFeuwTQbWUbiHkS4wbnz12SYtH/wDAaPw6Nk4ZPmCaXp+A5t9EBwckC
Rk4sPqHLgCwTB4y6uC9VWvK8RipCtja79Di42uevflnJ+3Ru5Fy8ZOSou4Fc
+D0N+ZY9Z7aAAaOoq0fqklViSUmS9rCUQHgOMcT9NbKSC69TknrOqGlvYCWT
pr00YifQETuMt8eSdKStk/GZqXPTXKuci/NrMAsp/veQlF+RFGYlM7AOktQR
t+ukBubPGVnJqDmXUK5D1atLBGofahaKGSU5fd4cqO/bAaaHbGLT9fSZq+Tp
OhHzB8rUhWnx4giIWHUA1q49CeErjsLMWdth9JhlNAB8D+fOX0vEXALu/AMr
KQn/ubCS6ftzRvWcUXPO+JN1yWQO8aHd4vrQYklNaLG0JjRbUgOa09RscQ0D
O/iPdLikxn9azPeNajzyMWlEPVHzEYQEhhMSsYeQHtQjVfF78a6Q5y5Syb8o
iZjgQk4vdycP/nIn307JYec19w+XNqZZWLl5iabV+3qmbzTDi7LwppD8MPds
FFQWJi7tDbU6ZKM69G6eDnLAlPl9uf7q9Mq9oE7XHHDg5GZ2PDmkF9Tp6gEN
xpXM32RqeXj4NIrVz1s2Clp2KQbVG6WCTX8tYnVT5vy5oE63HODTOzdsO7yC
1Y2a2Jrx8h1dDJotqA6NxpeCA6e3qLRp+4YTSkKzZd7QnCb89aepRWh1elyd
YsSSEZqH0nNhtI4dYSkxzb3AL1xOy6tBsxVe0CSsGniHFIc8ozNA9hHpIPvw
NGDq7gYlAovQhcATOoYOnjgn7+YNHjcZfoUhNB8cEMyOhrA0BctZRvUbtnmd
RxHyyTURIamo3ylf8PXHJfXIt2eD33y40vfdp6BaX+4XSfc5strvj9/Mb/H5
a8PilDpScWXSYUn0K/FNwOuUJGprZCUXYVvpnFFA26Rpz/wPLRiYdNK5IbKs
7NwQTmYIJ22uzk1zuXIuzq/pbxB8B1YkgFmhDKyPZE1gb8kJj1OwkgRQ4SmH
GLSz1SwUM9o7zZo1pyH9Yliz9hisWr2feZKxY6cyXyKxTsDii8WzN1MfspO2
OwJr152i8cZBGpKsha1bt8KHD1/BUmfCQhG9fzBYwbdkgLZL6kHLpbVY8se0
pBb1NViuLf1Kx6YWC2uFtQ7eTVqNJsR3MCGDZhOyZj8hI+YTUrfTu2/5y958
XbqJD1k8yvDhePgvV3aE57yycFHuW6vC8zw7uyPr53fHkh9p3r7coErtSuVt
EFSNjsVFNahr81tUw7NRYFmo1y8/dBteEzbvWIIRjRScJIQV66ahG1mArmTh
6vGsdvmaKVAbXcOoYtS1VISglf2laepXvHqBTzcPqNc/P4SsHsmb12ieHur2
zgNNgz2h4ZgSsHj9RJVUx2zQaEyJpP6LvKFVKFVEaG2aaqElhNWmNtIqvDa0
pgl/Wy2nZUwr6tBEfyNoXUQtmmqD/8qa0GoVrVtbC9qs9oaas0qCx+i0kGFo
Kkg/5DdI0MMNUvTJAI9intLhQMPVON7ERehNpHOJ8NhrSccehDTMTsgfxa8+
GV/98Zsj3e/fXd/17O56JT/tyJ76w9tLvR6+utX9WJRfcds4E6OmLbteWa3E
vUDL4PuLfsqTqI2MGk8htYtvzpO4WIjGFEc4pV7kblidETuHXfE3ToP2qZqF
shVJfPDwyAmbN5+Ho8fuwcHDlxWHYZQNHP1FSMgqmDt3NSxdtgkiInbBmjWH
ITz8AMykccvs2bOxZSLBGHa1hqvQXS5qqngLE7Rb5gttlvlAm1CWqOD0IAN1
HnWgFU0tWaptoKllh/mTiP8ouibqT0hXGoGE7SRk2hpCmvX/RopUuR9TsvpQ
8kfvbPvbDS+yo/WA4udbDyt4o+v4Ijd7jC14d+iYQqfqtyg3q0zjYhV9RlWB
pgu9aapBU3VostDbsyH1GIs2BCk7VrgPsWnrQuj8ZyW2NKrZIdsaDB7QoWCL
k2f2sJClbr/8ng1pIOM7shj0CvKF/Uc34LVSX6SDU+f20TjEA3yHFYG+s5qx
2uiHkYxkrTaZwXdgQajfJy/0GKmSreWfARoOLpS/1RyvpG2p52i/sh60X1Uf
OtDUabUvdFzjC53WYmoAndc1gC7rGkOXDY2h68YmBuixuQkd3t23NIJuWxpC
978aQ++dTWHAvhZ0UVmGhSDZh6SB3/olgVT9foGEtRPDg5hnbrBj1ylpMeQC
g8ZMgoFjgtjvoLFS2YRHBnaYaMjOTk3IgwkFCfHP8/75uMpX/iqf83ZErZJv
IwpnuvogrOHHL7NLElIz3dmH2fOkGD5oTHxGSfIdWBL9GlgpAa9TkqitUcJC
ixJlo4CSSUOJOQQugIxk7CThrwsrGTV1RlZy43VK+u56A1OVdCmWJDiS+pQ6
ud5F0NRo7vL430HC9KtcF7ezZJdBu1LNQjGjLiNbtmxw8/YHuHXnHaxevYWt
Tb58+SJZuztzGRh6YJo3bzUsXLieuY7wsO3UbeymbmMjBAYGygEJHbkuPLCQ
Yg4jjzbM+QZWZ1LdgUVewggdwxpB2/B60DrMh7ZsE1YXCtNyXeos6LRJPUdL
TMvqxKMpY5slbUj1oXdItV7PSV26cJlAFy3zN9AFzJDPpGj9R6RY4/7fCjXJ
9bVenySkW7g7GXHUnQTdciczYt2/BlxKGttqaIGw0vWLNawxsAI0wYUCTQ0X
eOGvp+/EMvDq7QumieBp3dnWRxWacEDjIqJRz0JranbICg0752Nt0I/gudpd
Peo0CCgFvjTVG1KILUS8GqWGavVSsOvl7RQWajQcW4KFFFJdIsbHCx3GH5lp
ygIN2nhw2l71U4Jvz9x1WgSXz9iWxlWd1jQ0QJe1DSEldF3fCLqvbwzdqG/o
sakJ9NzUFHpu8YNeW/2gz1/NafKHvjv9oQ9NfXf5Q/89f8CQg+1gzLFO0HBR
Ocg9JgOLNFIPTAap+ieHJN4p4M79aDfYtvOQfFel34hASPz1W8qE5Hz+hCTm
10TkeMpE5GDedB/XF89GFuVOR+42SE2Idxry0d305EXS5Ecis+QoFdSuO+1+
vFaaYLGkJGkkYMmoOSfv9WlPSEMEcxM/ln9ZU6O2JBMm8vrShR25aqh9//sT
ZBgA44/bCZtocesbpMaSPLCp2tUsFDN85CKHB1y4+JIGuB8gOvpZ3MENSsQb
d3TPnh1OA4MIWLBgLSxdshFCZq+GWbNmYcsEfzf5mxmuFoQKiYWLkx/9JpdL
LtBthR+0j6gP7TCtqA9taTLAH8vrQSpos7wuDah9WGoV7hOPegmT/7I6pFXf
IaRWm2GkXp9QUqd/GCneaACpV6UiaVgxz9sKfiWIV9d4pNeihGTEfncy6ao7
mffUncx/6f613+rkuyo3KdO5Wk9PaLzI2wBNFnvDf6DRour5G0wtzx1Al8Fe
4N0sHTSgg/165DlWd+bKwYW1u+ZgAxz3UbHOp3EmqNUxmz9dXkCj4HJw88EV
Vj9+fnesh4CQTnJn5RxWf1BB8JtaAZrR9JryefVGojE/dBQ06VYAfDr/ziKE
V6+fcdr1unn4twzyzNiZOsiem+kI39wMem9pBn3/akETHdnbW8KAnS1h4K7W
MGRPGxi2rw2M3NcBRh7oDGMPd4FxR7vC+OM9YNKZXjDlQl+YfnEg+IdXY3un
uHuRdURKSNsvOSSvlwau37hLp8KNWyQXkAD+HDoBEqXu03vY6U2ps9879Et2
EhEvHTkVz/3evXE1Yl6/CL4bG1ieHM1iIrPjJX1zLUlCQ9+hE1zZZdLox5KS
pHGCJaPmnMt3dfibCkvy4FNKf0c3tYBudulKNryoSGoWihmV06t6Tdiy5Thd
Y3+g6R08evQwzhD7apBnRFyu4+iaNSuUjrAwmDNHGmVTp86HsLAwuH//ER2H
J0/dkEcGlqTRgiVXXqekuG0MrOQibGNipcR/e7253+RyKT4MXN8Weq73gx7r
m0K3dU2h+7om9JcGk13XNqZq7rK2EXRe0xg6r24Uj/5+i+6fkdxol5hcqBOP
RPzxO5nfzYts8UlDDhWIRxb/Gu9pu1blSOXOv5FW413JkB3uZMJ5dxLywJ0s
eOVORh13v9ywk+cAr66e0qBdjgE/HbXGjC3mV4ewvSGyW5QsAY2/U2DN7o1G
FOM3E89cOtCt8aji4D+9Egxe1lbqbFc4d/2If4sJ5aDdgprQdmFNuBh5Qhpj
s7vwexWHz27Tum0aoZ+9fLBbu8DyGfuu9YNhu9rC8N007WkPI/e2h1EHOsFo
mgIOdoaAw3SM0HESeLwXTDvdF2aeGwCzLgyCeVeGweLrIyH09lhYfT8Ylt8L
gPZrakC54PxQLigX5ByeHly6uUHqltnhzLlrbrB+6w5mcSboOWgcBdVzcAD0
GDiWHRlYnui3vr2GGv8cFIDn/uxduT6Jyp2MkHUtY14fbPP124h8hJROSe4n
MJLDpl9NvQYGuLLLJE1gSUmS1BKbuOdcvquThhMtycNJKf0dXXYuOUMvNxgc
wJPUU7SUUaLFBhgVXM1CMaMjZ/DQsdC2XW95gAkHmdxVbmwemzlzIUyfvhCm
TZsHkyfPgQkTgtkm2NHjp9zRoA1o2m689OPBE9/c4DHwAWqIO1xcYdLuPtRK
OrA0bFd7GErTcJqG7WxP+Q3b2Q7Sw2CaY2nozna9N4Y1ImRkLkIG/Epj0bSE
rG1IyIIq5GNLd3KsrPuz8U1Lfi7pn5P49DGRARvdyZiT7mTaHTpeXrqTybfd
ozoEFGjmN7oW9N3iT706jdc2t4A+W/yT9l7nB92W1oWleybD42f3ZTW5wNFL
O6HPrEbQYaZXnfYzvdhIkPdV/NtPrQw9w3yhV1gDmLJhAEQ+vMrDzGOXdsHQ
xf6evZbWh37rm8PADS1g46kl7OyAkEYweuEfcOLybnZ84cZRiWRa/z/n1s4Y
sKM9TD7RG6ae/BOCaZpOB8iMM/1g+tn+MJsOlJkXBsK8i4NhwZWhsOzqaFh+
czysvBEEayOnwNZ7s2FH9HzYE7MENj+eDp021wSvWYXBc3JeKDo+B0ArExQZ
XBEOHT5NO3b5ij3yJlfX/qMM+PyyCy9RF0uLa8bmKE5I1bIDN7VpePZ+tZx0
sKRaezhnrv8M6Dbg6LUcBTZ0zV7sP9hQHgBYwsTU8BsWf5Mfi2ZTPC1hcsE8
LZ5NjyWZPbNrCknNQjGj1y4LXQ9ZsmSH9+8/Uspo2Ulo+Q08fPiA2/anT5/p
TLECpgbNY/Y8bdpcmDJlJrXpIJg0KRj27dsPR46fTgRnzkbKEweWMLmy3KSp
o0m+QURL8kqLlmQ7VkrJWVscI2EnJ0LIyUEw88QACDkxEGYcl3/pMS2baNYf
UiSafWzAjRcTixEyPCshI1IQsrgaIatbE9LtV3LVy/3jsqpZYiq0LEmqdKKx
1DIaSx1yJ8HXaRz13J3MiXV/03v5r7mGr+0MwYf/hEmHe0PwkT8pMDwyJg3c
0y1jwLYO+UetbwMGz6ERzSEJzZvlH72+TcZx2ztjgmErW8DCrWNZbxw/vxN6
Ta/hOWKlf9LJB3onDT7QK+PEHV3yB2xqZ/Qcubol5Mo/fnOHjEG7uiWddqgP
pozBu7vnn7Clg+eYta09x65t4xmw7g/PgPV0pbOoISzaNEbadbmwCwbMrus5
cVP7pPNPDYGll0fDMkxXxkDY1bEQfi2ApnGw4vo4iLgxHlbdDII1tyfB+sip
sPXOLNgdtRgOPAyHo49XwsnYTXDx+V+wJ3Y+9NnlC/UWl4YaIUWg8owCAI1M
MGLBaNi1+yi15JXblC2XTn+OgI5yYuU+I6iKsOSuqaO/v/bq3v/SkUweyf7s
MQTPxevcZwQhSdMUHtGyA70GWxvrjfXxT9ax2yB29CvmafHS4kgjHZbkdoyu
esOTAlKzUMxok/BVu6BH94FQt64vPUI7TkTzN/D0aSy342UL18CSJWE02plD
E9rvJJomsI3GPXv3V4RLl+8yu9xxbSGsuDpBThNhOf01sJKJ1S2X62nZwA5S
LbgVSp3lCA9CBv1CyMwihGzqRC0xB3lQz51sLZ74Tpuu3qRs24Tkj8nxr0w4
kHvLjDOlds25Vjxy/v2sz8edTOG++MwYCL00DpZdCoDQy+MgjCY8xt/wK+MN
9CCAaplVX+bV7HfekUGwYM8wuPXgAkTH3oYpW7tlxDoGTYLtCiuuSWLg78rr
gRBxjSb6u+p6EG24ivq4JLD65iRWWnMzmJaDYfGJ4bBk/yjqfC/Cg6e3YeaO
nhmXnR5FzWkKM6kNmO5MM8Cmu9MNsPneDDpot0TNhG1Rs2F71FzYF70UDj1Y
Cccfb4LTj3bAuZjdcPnZIbj2/Cjsf7oMxh5rDe031oQWYRXAd2k5MJV3gbX7
1sCGjUfcYGnoTpD+4qO+f2do33sY9ZqYGzP36dAzaZeuA9mRQaqLCMtROsew
tr3Y0Tipjl2H1yMlgrmahcrkFy3eDL6+TWHo0KGy1bgzq4mOvs+sZseOXRAR
sZpaSwj1dJPZ3hJazNp16+HyletQkS4zotkUfTp6A+ygMu+ImofJwA5+hZ30
cOd9TPPZqZ3SafxtfPbIKGoyOQjpT4OmwOyErG9DyPQK5LWfOzlY2j1mbJNS
92t19xwVuLdN4m2RIWAwbL87F4yJ/7oTUmzT7QnsyADb79E6+OveHFqaw7i6
sjqTAifp5hvTM64+N9GQP/zoSHClxUBaNYPDQWi7aMJfAwNr4sfyORfYFb2A
ctkdvSDptlshGddfDAZD/ogTY2k4TMtJ/7o1C/Y+XEQv3/doMW2HZSztf7SE
HmH+Cxx6Eg5HYlbAiZi1cPLRFjgfsxMuPNsLV54dhqvPj8D1F8fg1NMNMPfK
QAg43hb6b6kL3Tf6gHuuJHDl5m1YtXYfnQuWhG6LYxVtewyGpCw35uzk3yVF
zw692dE4qY5bAF5FMFezMFZpgnkL1oBvAz9o1KgRfPz4UZoCE8CbN6/hzp07
cPz4cVi3bh2EhISwzh82bBiEhobBxctXoBLcvRvDIq2bz+gE+HgFHI2R0pEY
pRxBUWApeZy6FWlPRi2L+hhIZ/8h6QkZlZqQ5XVpakq+tEv87bxX4pCDExq5
HnoQZjj8aHk8he6Rx8vh8OPlBlYwMXb0kB0dkapX0GqlSuZkQLYmdmSMWw+M
THwsmmSUx55EsBImQ9w6ORnwCLOVBjj+ZGV8OB67kopFi3Dy2Vo4HbsBzsVu
h4tPd8Olp/vh0nNpnEc+p74j9j6cebYTVkSNh8V3x0LIuc7QItwL0vvkhwvn
I2HJ4q1usGD+ljg9+wedFeawXO1FbEEwV7NwVpkY5s1bC5079aGRTBbo3bs3
7N69G27cuEE76C7s3LkTZsyYweo7dOwIq9eshduRd6Ayjd+fsZDjwZvzFPsO
ltxZniDj1burBzzaPej422X1H30O8436tKrN2pcLGla6dnKm6VzM9njYqgi2
dYPzsTupFV6I3QOXn+6jwh+Ay88PM+HRplEBj2IfwM3np+Fw7BrYH7McVlEl
pKdT3Oj54+HEiavU3ubMXh9XejqRzWG5Kj22IJir2QpWmYCuM8KhT5+RUKNG
PSiQvyDbRK9YsQoMGjSYerHVcOXaNagKz569BmgAT548MzJAJrj94jTceX4e
Hj95gvAMDK8Jlt4aBzm8s8LVW9dh396z34Nr1ZmCYfnfglstX6b8PdabN+/B
i+Wo8sjYM9R0NrBUm+UJab4RTsRugVOyGV2NPQLXYo/DjecnKDLJQ9x+fkGC
6QLnnm2E9hvqQr4WeeHd+w+wc9dJqgvcDlH/eLBSXT+KFXP1jwexxXe7KKvl
yxSsHz5+olgxx2jg5MNVsOFxME/rYoLpmKclA6zGDOsSYpG3WG3+V2oen1Uh
odVxiNKykR0Y2aFypVG9Tj0hHW1QTvM6k6DOhYOVL1FOKmDiElXO0zrptBus
i50CW57MhB1P5sHu2KWwl7ryg09WUA+wgbrszSbZbrBDoJ0JNh1ZidGqO1y/
+Wi+tPSgJTVbi1kcbeOzp14sR8v469ocWHBjKEu1WO5O8+Gw8OYwWBpJ49wo
Gt/eD4JVD4Jh1eMpsO5JCGyImQtbnyyE0092U5kQB1XAgyAwtUoCX799BraT
8l3WRN51UFDgkRfLEUX48Ykw/lQPlmqx3B2CzvWEKRd6w+RLfWDGpYEw/fJg
mEkXirOuDWVuLexeAKymyHbH4EyIo8gIBQOzw+4L66XdHK0aWNZEpwvCdCGh
yN0pEyTsm5ilSiyPD4n6uUPi/okgyYDE8MuQJJByaHJIMzyFETKMTEXNMs2I
FJB62G+sGk9jM2yOlxkZCRfIPDYN5BiXHoqH5IEyM/OCx9jsFNyQobO/y/ww
E6uIQLt2Q0WZC2YMPP5+/vKVJYK5KIsnZd9fs3zFDgz0V+wQZX97jR7RN8zi
6S40aS5kje9ERn2XfcFM5oHNsPl/l8AGmcDxw9IDgHhUzVpETxzZbH2iO7eH
caIumBulhb2+xM7KmwNYkhNb/ntYC86+3Ss5nPgyqO8YAocl716Yq8NkEIBm
Wxj6ptmtJcOhfWutKoOonU0FOHJgvU0FkDqG/nPHIrtPkdJq2A9tsLIBmdF2
YswZ7f84InYRbPyXjI/nVNaDvVHrQgwqIFehAD8GrRuxyQRdYDXFHzu86TvF
C7yIyDEaRFJgsppDPH7YBk7f8aen//ZUro84nzBh4sOzp9Hw+vUzuHLlKJw8
uR2OHdsChw6tjw8HD67Fh+0ProPDhzfC2bN74O3blxAbGx2X5z9gaWQs7927
It9AkW6/XL9+6nva/0QeEyNO2GM+TyE6+gZdTz+4SasfPLjFSnIy4Dk6eqOi
rsLLl9K158/v+7fsXTh7lC8m5h5d4OLwio29b2BFd1b5+PEdutyPhIcPbzNg
iILtqFP9W00BKCDla4KnTx9QNaNyEQEmBQPyv3//msz7r3/ZsVrWlCutePYQ
b5Ed249INKxRfGxmbdbYv5SrEZ4/f2xEzkbG0pUxxZMChv9Ez8Y4HG8BY+eC
7KRudmVMbcIO+8wAL17EMOmodrF7saQkRcuIS2BU/0q72GsKawPj7M74fc8f
QVrJoFXJUSgDG60mxogCYYlaNhthkEBjaQqGU6d2Wh9DLB3qiETBIOOgRJF9
fM78zJnd/1L58TlvpI+eGj0b5W1kTN1ZL+ApNd3n7C9c2P9vZU/A+eNgxing
zZsXMoZYrgMDDgBsS9tIgO5zA7x69di/BeHKQSDD9+9fMyCKMqQOcedgEAoC
iQsiMvL8vwXhxkHgLWlkJjGJVoacAceHgSnfjTFG3/pafuIMnZ01Js4vXz6x
o8Ty0LTGhBwb+xw+f/7GUmKWm1idk66TrpOuk66TrpOuk66TrpOuk66TrpOu
k66TrpOuk66TrpOuk66TrpOuk66TrpOuk66TrpOuk66TrpOuk66TrpOuk66T
rpOuk66TrpOuk66TrpOuk66TrpOuk66TrpOuk66TrpOuk66TrpOuk66TrpOu
k66TrpOuk66TrpOuk66TrpOuk66TrpOuk66TrpOuk66TrpOuk66TrpOuk66T
rpPu/zG6hySSx45d6YkZq9tkVeKA76a9ws5hYp/16MqK0glZIukjLBtsxTrm
6VvKgeZdWNHIKjl7zDfaljU96syqjKyCs7eBwk2M8lfyBR48vi/16p3IqI7y
a+6VczICJwAnACeA/wqApdIHK5Kdv3up/PKHEUrqMfTpMDAM7/G8JxiDW7/8
Y0+J9yUxgYuUP0zxJQXzUfL/50m+JgFXds6E7fFKTEjHiATBiCz4lyEW2VHk
udI3ORSRG0+LmYFQQ/xeNUcBItN9TgfZUShwRTGxbqHv6wbYpmXgk0l4TaoT
907DHDvKMEPbbf37PeuPGFkHFGXYXY4U/FAovNab2oibY55uR8yTJcyZDkYd
QZ0HdHzRGfGijsFTwoxmhHVoQqhrj13390CwHTEHSrwLbInehqaM+kT7qM7g
mhD62qpvq6H6S6x9sH6iHZGOk3gjDOxx1OJ712+u9RhSIx6iwr0WP1oKAXaE
OVrijcaIHYwKxU5vIikUEaNCO4yJHYt2MsqOSEdI305BhaLmzuT6mBtaSdq8
kvVTNjRRps3hdsQ4VMKIwxvdFxtK7SWMqFV0CT5zHs+DIXbEOEiAsasA40A7
YuwvYUR3wzH21mJEO4B+dsTYR8Lodu3OTRw56N5hgGqPOGTYFPunHTH21uqR
RQVDJIw4tLkee9kRY08Jo6JDhm6kVo+oY+huR4zd1L5GPCwkCZAwom3ifMP6
uqsdMXZRMeLUyMbMRHXM4CTEMHa2I8ZOEkbEgXiYPQar9og+nIVF9ozAO0gY
EQfHOE2LEadCaG9HjO1UjIgHccEsCSOOaYYPW/xhR4wSbyNiQUwM4zwJI0YZ
GMKxFq3tiLG16h8RI0O3SMKIYQ/H2NKOGFuqYwbjHoZumdrXbLxgixZ2xOgv
YcRlhLIShTDV97DVK7ZobkeMzdW+3ur5rjxDFyFhxFiSzYPYws+OGP1UH459
zcbMGgkjzt98yd7EjhibShgx1sZ5kKFbp/Y1zo+sRWM7Ymys+kfe15skjBhj
8HHd0I4YG6p9jfED6+ttEkb06byvfe2IsYG6VsBYjKHbrsY9GLOxFvXtiLG+
6h+5D9+t9jWfC+vaEWM9de3Kx8xedcyw9Ra28LEjRkk/RvTVaIsM3QHVHlkM
ji1q2xFjHbWv+bg+LOjrWnbEWFvtaz4XHhX0dU07YpT0Y0S/o+wYwwlBX3vb
EWMNQV+fFvR1dTti9Bb09VlBX3vZEaOkHyOuZXhfXxD0dVU7Yqymzte4M8rQ
XRb0dRU7YpT0Y8TYgff1VbWv2d4jtqhsR4xV1NiM+/AbEkY+V2OqaEeMldX9
Ho7xloQR/RHHWMGOGCupcyEfM5FqHM4xlrcjRqkPjcqakKG7q66v+bj2tCNG
qQ+NSlzG0EVJGNGn8xi3nB0xeqpxOJ9nHqjrQr6+LmtHjOXUuZDvkT6SMGI8
yf1jGTtiLKvu96DeGLoY1T/yNVdpO2Iso+4B8Dg8VuDDS9kRY2l1nkFMDN0z
wvcfuR8vaUeMpQTzzEvBPFPcjhhLqnrkGF9LGHGfimMsZkeMJdQxw/v6jdrX
3B7tibG4ipGPmXcqRj6ui9oRYzHVP3Lf80Ed19w/FrEjxqLqPMNj3E8CH17Y
/hiVeZCh+6zOhXy+LmRHjEUEMcVXwp+q4HFPQTtiLCxYcxE17uG+p4AdMUp9
aMT9Wi1GA+E3FzjQ/HYEWlC9uaAFapKAsqfiFKD57Ai0gGBWZEDjS0D5bRBM
ee0INL8gxGBA3QTzYx47As2n+nU+9zCgCdQJiD2T5iBA8aah1kYTSkBx95x7
ptx2BJpXsLJlQBMJRn0uOwLNo26taQdTEkGcmdOOQHObs9GkAht1AKB6G00m
sFEPOwLNZc5GkxP9FkwOOwLNac5Gf5OA8v1fTL/bEaiHORtNIQiSHQCo3kZT
Er4bzG00ux2B5jBno6kI31rnXZ/NjkB/N2ejaQQ2mtWOQLObs9G0Aht1AKCa
BQgDmk5dhXCNZrEj0Gxq12uBZhCEeZntD1RZuuuA4v0WPurtCTSruVGfSTDq
M9kRqGR27IaaNsLPrAYlfOfGAYDiHQutRrOoDp9rNKMdgUpmxx6F0QLNJohH
M9gRaCZ1n4nvhTGg2dXBxDdyHACofjD9LhhM6e0INKM6mLRTqIcElA8kTOns
D1QfPclA2d/MOALQDOpOiRZoLgkof4gQU1o7Ak2vDib+ABwDmlsdTPwOoQMA
1TzRw4DmEayZ0tgRaDpzgymfYDCltj9Q9EJajcpAcZQ5BNC05jRaQKDRVPYH
qt8Vl4Fq9p7sCTSNOur5oz4MaEE1euKj3gGA6qfQQoIp9D92BJranEYLCzTq
AED1Gi0i0GhKOwJNZU6jRQUadQCgeo0WE2g0hf2BKvO8DigupPgq1J5ApfHB
dm60QEtIQDX3mX6zP1D9ur6EGj1xjdoTaEpzGi0l0Oiv9geq12gpgUbtCTSF
uQi/DNEvl5PbH6h+zSQD1WxA2BPob+bCvHKCMO8X+wPVL0XKCRy+AwBVdpt1
QDUO355AfzU3mMoLBlMy+wPVD6bygsFkT6DJzQ2mioLBlNT+QPWDqaJgMDkA
UOXxZB1Q9j4CRwAqDWT2PKMWaGUJKHs7lgI0if2B6rteBqrZ0nEAoPquryzo
ensCTWau66sKuj6x/YHqu76qoOsdAKi+66sKut6eQJOa63ovQdcnsj9QnNKF
QDVPOzoAUP1cLwPV3GxwAKDKfVAVqPTWOO2LEN3tCFRyjYJbjN6CMM8BgOo3
cmWgmo1cBwCqXy57qxG+QwBNrMajWqA1JaD87SSYEtofqN491RS4JwcAqr99
IwPV3L5xAKB6G60psFF7ApV8OHOXWqC1iX7NlMD+QPXLZRmoZjfPAYDq/Wht
gR91AKDK3y3pgLIX4jkQUGVNrwKtIwHlDxBicrMjUGmyYWNGC9RHAqp5Ns8B
gOr/TEgGin9/7khA9Q7fR+DwHQCofjDJQDVrJgcAqg+c6woCZ1c7Ak1oLnqq
J4ieHACofmaSgWqee3IAoPoNCBmoZgPCAYDqnx+VgWp2nB0AqD7MqycI8xwA
qH7U1xeM+vh2BJrAXDzqK4hHHQCofq6XgWr+BMMBgOpvg/sKAmcHAKp/pkQG
qrkr4gBA0V0KgWr+GtwBgGr+8j8uUHwqxpGA6p/SkYGy92g6EFC9H5VeUWnk
d5YxudgbKEPWmOgXSfZE5mYurmso8PAOAFR/d0EGqrm74ABA9VvMMlDNstMB
gOojZRmoZi/cAYDqN0RloJoNUQcAqp8zZaCahbwDANXvislANbtiTqA/D1Tz
qsC4QHH15EhA9X9aKwPV/GmtE6gTqP2A6iPlhoJI2QGA6vcZZaCaTXsn0P9B
oPpnM2SgmmczHADo/5lR7wT6/y3Q/zNhnhOotYHqb3466OLO7CpU82Z1BwBq
dgPC0db1+pfnyEA1m/YOAPT/zN6T/n6NDJS/JM/eQB13Q1TeU477tW9Q95Tt
+ayAjEx/e1Peltfc3nSAbXl9aOwrCI0dAKj+eRYZqOZ5FgcAqp8kZaCajUUH
AKrfU5aBap6+cACg6BCFQPl74R0EKN7KEgLVuHR7Ak1oznHKDzVobsY5AFD9
H9TIj4loHg5zgMdE9He2ZaCaO9sOAFR/30MGqnlWwAGA6iNOGajm3pwDANUH
cjJQzW1ZewJ1Nzfq6wpGvQMA1QclPoKgxAEeCdXfSZKBau4kOQBQ/UcDZKCa
BbEDANUv32SgmuWbPYHKj9brn2eRH63XPBfoAED1g6m2YDA5wB8r6Gem2oKZ
yQGA6mem2oKZyQGAol/XvtZBBqpZyNsTqPxHX/o7SfIffWnuJDnAX6fpHX5N
gcN3AKD6Z1dloJpnVx0AqN5Gawps1J5Ak5izUW+BjTrAX/nq/ai3wI86AFD9
ul4GqlnX2xOo/Cfz+jcjyX/bj4bLg2cH+Nt+/U1EGajmJqIDANW7Jy+Be3IA
oBjNad2TDFSzpWNPoPKrR/TP4civHtE8h+MA70jR35uTgWpuIjoAUH3XVxV0
vT2B/mKu6ysLut4B3oyk7/rKgq53AKD6rq8s6Hp7Ak1urusrCrreAd6Hpu96
GahmA8IBgOJ0rv1USAV1rucvEnaAlwvqb4iVl4Bqbog5AFD93/uVF4R59gQq
vwBTf7OhnCDCd4A3deoHUznBYHIAoPrBVFYwmBzgtbf6wVRGMJgcAKh+MJUR
DCZ7Ak1pbttRfjWzZtvRAd4hrdeoDFTzZJM9gf7HnEZLCDTqAO8512u0hECj
9gSaytyWTjGBw3eAd/Hrl8syUM1y2Z5A5e9F6J97kr8XoXkhuz0/w5DanEaL
CDRqT6BpzGm0kECj9vxUSBpzGi0k0Kg9gaY1p9ECAo06wAeC9E+SyUA1T5I5
AFD9x1fyC8I8B/iIlX5rXP6IlWZr3AGA6jWaV6BRe36/LL25UZ9HMOrtCTSD
uZ2SXGr0xEe9PT9dJwPFLSbt3pMMVPMEhD2Byp9X1P/Zivx5Rc2frTjAdyCx
d7WfUs4hAcWlKR9M9vyypvwJUP0TufInQDVP5NoTaGZzS5FsgqWIPT+qKgPV
f9hCBqp5Ns+eQOUP/+rfMCd/+Ffzhjl7fvg3izqYtN/TzaxGT/zZJ3t+Sjmr
BFT/p1WZJKCaP62yJ1D5c9/6d/ZlkIBq3tnnAN8l139FO70alPABZeZL742R
NMFST3bKQgjZzYXE6QQh8d9BoGrCaqzCRDDvKmnmH8D63Zw/TKN2IQ8usv4c
rJinb+m1NO+CWbx/iw3HpHb2S63Ofvwhm2yWYKNHnTGL9+8A5pAA4uN0Wh+d
iui3i/4WoI40wdYdJfqaS/4RUA9zq4eUgtVDdjsCzWnOHH8TmOPv9geqt81f
BbaZw45Ac5mz0eQCG7Un0NzmbDSZwEY97Ag0jzkbTSKw0Zz2B6q30cQCG81l
EVDpTo1LsvPnossvD49RUo+hQ56DYXiP7i+xv1q/3lOixAdM4CLlD1Ok+CKB
kNLzJEm+gis7Z8L2eCUmpGNEgoj+XDTv9kXWUk1ec6MikWBUWKaauay1q6Ka
xtOmPkWRQvz83qCgkenSfYbsyA5cUR1Yt9DX9w22aRk48Rlek+rE8Qcwx1qy
5jM3sBIKBlZui2SdoTWD/v36vkBZWIcWZTK6HClY8GN4rVpvUT4u23RryZbf
3Fh0E4zFPBbJNlmSLdPBAw+xDwM6dnyFcmGfgackG5ov1qHpYt957Nr5EIKt
LBsOX+16RTJXdo+HD9+8FskWKLUusGXzIxxq2D9ol9WZWCYUcW3Vqu+wO0us
XfN4orUkKqCG4VqH5KI6JP6AUj6LJBontUa4aGnYK+9dXb/VYxIZ8RA70Gvx
oicQYC1xCkqEsA+0W51GdVXB31if3yJxRkutcbCgYWEHobE1kToIJcMO6jBm
9DO0z1HWkkharbG9Be06ySBJpLlHb5lEIxSPu+Yx9sSZXLk+QSupd65kzfoZ
hxDrneHWkqWwuiWldfHfLaALWCTGUGVtHh6DHp15g/aSGNhB6P185syOhSHW
EqOIREizTf1VEkPz0GFBi8QYJBCjq0CMgdYSo6hg+ftZMP8UskgM6VkhI/pd
LkZvrRhocNDPWmIUkwhpdo4/SmJo/oCmsEVi9JGoul27eh9HO06ZMEAdGzjM
WRj0p7XEKC4R0jxt/14SA28z8BmziEVi9Nb2BgvuhkhioMfivdHLWmKUEMz+
byUxcMbkm3lFLRJDGlNGpSeYACO1vYE9Bd2tLAZqXXmgA96oczzf4C9mkRjd
VKNCyCzuDJDEwHGCkzszqq7WEqOkIF55JVhpFLdIjC6qGBiqsCE+UR3iONkz
MTpbS4xSAjFeSGLgLM+3CUtYJEYnheq5aITMxkawOjZw+mORsdUWf6VVMbhR
PRMEjiUtEqODEsEdf8DFmKYVAwMSaG8tMcqoY0MZ5hArGOKlLBKjnSoGQkbo
MEsSA70UEwFb/GEtMcoJHO5j1eFyMUpbJMYfSgB64CHCZmLMk8TAiBHDe9ai
tbXE8BRMfw/V6Y/PG2UsEqO1Om+gGEyARZIYGOVyMVpaS4zygmAkWhJDc7eq
rEVitFSHOEa4TIBlqlGx4Y0tWlhLjApqaMgj3ChBaFjOIjH8Jaq45lW2ayBM
dbhsiwdbNLeWGBWVWPRhBF903BUE6p4WidFcNaqtnp7vmQARkhi49mCBCLbw
s5YYldS1E18N3lYXgnxHqYJFYvip0x8aFRviayQxMMbiu2NNrCVGZXVRy9fo
N9VZnD/DUdEiMZoqi7FFTzAQYQKsU40KAxTWorG1xKgimMWvC2bxShaJ0Vid
N7hRbZLEwFCRe6qG1hKjqioGn/6uqltbfBavbJEYDVWjwjCQGdU2SQycDrlR
+VpLDC+JEG5Bck91SV398XmjikViNFAXsRiYMwG2qxEuBvCsRX1riVFd2cN4
sJ6PjfPq2OBDvJpFYtRX5w0+/e1WjYoHI3WtJYa3wKjOCozKyyIx6inKWfOY
D/G96hBn2wnYwsdaYtQUGNUpgVFVt0iMugrVIc9xXDABDqhjg638sEVta4lR
S2BUxwVGVcMiMeqoRsU91WGBUdWylhi1BUZ1VGBUNS0So7ZqVDwYOSowqprW
EsNHYFSHBEZVyyIxZC2js1VufcEJgVF5W0uMugKj2i8wqjoWiVFDYFSnBUZV
3Vpi1BMY1V6BUflYJIa3wKjOCozKy1piyPMoRrM8wt2phob46A8zrHoWiVFd
WYx1f8mN6oLAqKpaS4wGam8oC1mcb5VFLL9zU98iMaqpMRXepmECXBYYVRVr
idFIHRs8NNyihoZ8bDSwSIyqSvi/+RE3qquqUbF7G2qkZgUxmig+5Vl/blQb
JTG4Qamx6M+KUUUN1Pn0d0MSg8dTavhvBTGaKt1/77TyHCGuDIj8zhduVI0t
EqOyMuImPuNi3JLEQCfMxahgLTGaKXp7tFT5oiWsUo2Kv1itqUViVFKDET7E
I9XVHxejvLXEaK6sDO7cRMNi3+CMUKc/vk/lZ5EYsrEouyJMgLvqPhX3VJ7W
EsNfXcQqfzaBexjKvMFXf80tEkM2FiVIZwJESWLgdMiXTeWsJUYr1aj4lsIS
1aj47oi/RWJ4qqs/Pos/UHdG+D5VWWuJ0Uad/ngwskAVA2Mt5q1aWSRGOTUY
4bdpHkli4PqDzxtlrCVGW1UMPm/MUXfUcTeRidHGIjHKKqZ64CFqnwkQo84b
fEuhtLXEkLfmcZrjYsxUxeBG1dYiMWQt43YbX/3FCqa/UtYSo6Oy+H8Ywe9v
TFVvDPBZvL1FYpRWZ3GEzQR4pt7f4FNgSWuJ0VkVg3uqSaqn4mJ0tEiMUoJZ
/KVgFi9uLTG6KnqL3sYD9QnqLM53DTtbJEZJtTe4GK8lMXB7motRzFpidFes
+P4eHuGOlcRAsfjDPF0tEqOEOsS5Ub1RjYqPDauJ0VOd/jAUZK+aH6Gu/vAe
B4urelgkRnFVDD7E36licE9V1FpiyI87YOzEx8ZgdWygp2IOt5dFYhRT5w3u
cD+onorPG0WsJUZfQW/0E/RGH4vEKKrO4nzZ9Ekw/RW2lhgD1N7AQJ2Fhr3U
scF7o98/EUMJRJgAn9VghMdUhawlhvTkkwmhxhWli1YSFugOtEiSIoLoUBrr
7PFDHuQWtJYkQ8WStBNIMsQiSQoLNhaIGudyt1vAWpKMVONcXGWwV7/5MzFM
GJLgCMGJECUdbpEkstXg7SWtJAbC78tycfJbS5wxEkYc8BgUYk9gxzRWt0ow
5GVjfrRF4hRUhuDUp1pxTJI47MF7RZx81hJnvIQR53C8rYz42R6i1EE4vWM1
dh52UIBFEhUQBCpMoviSRPxuM6a81pIoSMKI0Qp2EE71aGdS2GJCB419hp2E
M36gRRLlF0SQTCI3QeCSx1oSTWGEXHAXBTsCOwT9AftrZumNZS44qrDv8ByO
JmZ/ky2SLZ86dfIIgMmWQA0D2DPwVpUtRJINuwIdGuJHo2OyFVRlwzqcX7FH
Wbw585/Ihg+caMdWQsIf/eM+PLe1ZJvPCLEXYiBm9OMoH1okl1H682RXLGMd
9iu2QV3gNWwTfJ5FssoDSbOtxPJEAreYy1qyhqujDnFjQjt0Zc+quKBYKJ6S
2HvrpHMmbKZcgpeHWSStbIi43a/1MUkEK6Kc1pI2zp9y/SzQ3OaGV1LB8HIA
oPqxkkwwVjzsCDSXOUNPLthEzWFHoDnN2ehvElB+TwrT73YE6mHORlMIllAO
AFRvoykJv7fEbTS7HYHmMGejqQi/l8e7Pts/BGqEc+fvwL37z+Dy5ShK9crV
+50xoycuX4mCGzcfQuTdJ2AG4u/mrDONwDqz/mOIJ07ehjfvPsGnL/hag49f
vnTBjJ7Aijv3YlmzRmKI2c3ZZVqBXf4LiKduw7v3n+DrV4T4BSF+YRCx4ucg
ahaILE+nrhK5FrP8K4hMi58+oRY/fvLDjJ6YNW8FLPOrDqsbeIMby40Q2tSL
1UstpPzTpy8/EiWbahBaUTIIgtzM/0qUV2/ew4f37ynV9+/e+2FGT2xv4gtk
zlwg4RHgCmRZOK3DMtbhOZPc7sOHjz8pirIVpBMFb+ZyP/HvRHnx6j28fvUW
DPDq1VsXWLJ4MSsZBCUjluhltMhKmP7+hEqPlVyxZMISwVJWdoER7nTtAGTL
Fpo2UhvA3MiOsV5qIeWvqdZ/oLis5vxWJoHfyvSPHezJ05Hw9OUbePr8BSam
IiMvASvG0YSZE2avMHvChZ9QicYX1BEsZWGXGiGyi6zeDesolveXLxqxyErA
iuwstjLJVzx/SZV078nfKVp2BXhfTruizCzYfP03ir4NsU/fwOOY5zQpilZK
wIpxFG3mhNkrzJ5w4SdUogl5iWApC7tAq14jU6orK2NJSVolS9c9efrqJ5WM
t6O11pxFDRe4NWf8V9YcE/sKoh88heiHz2QlKyVgxThKNnPC7BVmT5gsIc/q
XPhZgqUsrIWJqrW91AXr1wBZt8aF6dwEZNVyICvDgWxaj5o3sdZGeEjVj3HF
3yhedqn4EK9W8dkEq7MM/1jxp6jiHz15CVH3H0NUdIyseKUErBhHAWZOmL3C
clLqCVcsya6alrKyZi4Q2akdNea1QFYsA7J8KZ3flshG7wIkdAGQpfOALJnD
1B7ZuR2VEa8zwoNHT3+kc9lJ4LTGb4EwnWdX5zy+8/4vdH4mkqJ5AbcjH0Hk
nceyzpUSsGIcDTIPQKtMssXGPcurtRep7Vm9PPMpHAiWsrMLTJI6I8KALJwN
ZMFsbrhzZgCZNZ1qcwlqUeJqhHtRsT+pRP3897tg/kv/75T48DncvP0AbkU+
lJWolNx4Kb7gbCJecuUlgqXsmKEuO9PRvGwJkJBpqkOdPk3jUL8EB1OFzWdt
TfJ1d+7F/Eg9GdVZS7tm8JDUw2csTOn+lXruU/Vcv/kAbtxSFKCU3AR1wIpx
7E45kYiXXLHkImmLlrKwC4yS75s/Hz4ETQJlTv80aRJ8kJNS93ZiEJC581h7
k3zt7bs/qzH9itVDvR/2rzVmZBqLin4GV6/cp2Z57Vq0LLxSIljKhxmOA4wX
5y2AV+MmUNN4OzEQI0RaJvMX0HMontTu1q1HPxIvg7rVrxUvlyQe/xsgTGn/
hXh34O69p3Dp4l1K9fLle36Y0ROXuraidkz95tz5aOU0N7JeIguXwgUmitTu
+vXoH4mSXvWf/A9PmCi5Vf/JH6P656JgsPDw8Uu4Q10SgTt3Y/wwk1dyF/q3
hHsD21NR7g5ojz01sB1coAnPmeR296N/OBXIomieTGd5HsEOWRrridLl5yGm
M+dJ8gk8SWp7QkSXr9WiDBHHtJ0hpjWnxQICLab6FxBvw/NXH+kC8iM+rPPm
YxdWpCvKt59+tKKUIervOxcQ3Jb45xDPnLsDb95/hU+fcQ+H5l1Y0QgfP32D
qAfP/w5iGnXk86e8GcSC6lqMj/x/DnHHrjMQseki7N17llKleRdWNMK+fWdh
3/5zPwFRH5cUEsQl/7EYopoFi/mnNqeiwgIV2Y6/Xv4iAvlTWp9/KnPyFxXI
bzv+evmLCeRPYTP+ysSo4497GHxDzQb8ZZPCPWkt/xISf80jBb/ZjL9+Q7GE
YEPRBvxTmpO/lED+X23GXy9/KYH8NuCfwlycWUawoZDcZvz1YXwZwU6SDfj/
Zm6iLyeY6H+xGX99RFlO4H9sx1+5C6Tjr/E/NuD/qzn7Ky+wv2Q246+3v/IC
+7MB/+Tm7K+iwP6S2oy/3v4qCuzPdvyVv0nR8WdvsLIhf9mk8Wanln9liT97
ra7CP4nN+Ov1X1mworQdf73+Kwv0bwP+yczpv6pA/4ltxl+v/6oC/duOv17/
VQX6twH/pOb07yXQfyKb8Uc3L+SveUjXdvz1/l/mr9lGtB1/5Valyl96u7D2
hd7u1ucvD2n9DSVvwfxrO/76XQxvwS6G7fjr429vNf6xJf/E6vyv5V9T4s/f
vIUpoc3468dfTcH4sx1//V6gzF+zF2g7/vr+rynofxvwl10KDnMt/9qC+C+B
zfjr4+/agvWv7fjrx39twfi3HX/lj8J0/NmLYG3PX4n9Vf51JP78KTxMbtbn
L7s0NDMtfx+Jv+bZNNvx1//Nkcwf34LwX+Cv9z8+Av9jO/56+/MRxH+246+P
P+oK4g9X6/NPaG7+qyeY/2zHX+//ZP6a+6y2469ff9QTrD9sx1//JJfMX7P/
YTv++vm3nmD+tR1/vf3XF9h/fOvzT2Bu/vcVzP+246/3/zJ/zcPqtuOv33/3
FcQftuOvv/8j89fsf9mOPw5zIX/NnxDbjr/mL8rj8scbU/8F/vr7XzJ/9rZV
2/PXj/8GEn++943JxUb8GcPGgoDPBgzdzE24DQUOx3b89RtOMn/NhpPt+Os3
PBoKAl7b8dcHHDJ/zYaL7fjrF/wNBQt+2/HXO9yGgoDfdvz1C86GggXn/y5/
zdvl4vLHSPC/wF//d10yf83fdTn5/6/y1wccDQUBh+346xfcMn/Nho+Tv634
62+4yPw1N1z+d+3fyd++/O09//7/zl+/4fvfjT/Nxr+aFx7bYf3xX4r/9X+M
LvPXbPj8767/9BtuMn/+ypj/lQW/vMMR92PiUs52OGxwS0FmqN/Slbd0NFu6
ttvS0UcYvoIIw3b89beUZP6aW0q246/3sL6CFbbt+Ot3OGT+mlsqtuOPA1nI
n79B1rb8cedQyF/jYWzAP6G5AS/f0tBsadqOv/6RNvmWjuaWpu1u6ei31GX+
mi112/HX73DJ/DW3FGzHXz/Dy/w1O5y246+fYWX+mh1mG/B3N2f/dQX2bzv+
+vnHRzD/2O6Wvn6HT+av2eGzHX/9e1d9BBG27fjrI0wfQYRpA/7yIz36W0ry
Iz2aW8q246+3v9oC+7PdI016/1db4P9sx1/v/2oL/J/t+KOb0f5JR21BwG8D
/vIjjfodPvmRRs0On+0eqdT7n5oC/2M7/vpHCmT+mkcKbMdf3/81Bf1vA/5J
zPW/t6D/bfdItX78ewvGv+346+N/b0H8bwP+8iP9+j+pk/+kAI2CxyC2+5MC
/Q6rzF+zw2o7/vrx5yUYf7bjj9Osdvx5CdZfNuAv/0mP/g6X/Cc9mjtctvuT
Iv0Op8xfs8NqO/56/VcV6N8G/H8xp//KAv3b7k/q9PqvLNC/7fjr9V9ZoH8b
8E9uTv8VBfq33Z+U6vVfUbD+sB1/dPHaN1BWUP0/f6WF7f6kWb//WF7ir9l/
tB1//SOl5QXzrw34y3/Srt9/KieIf2z3J/V6+ysnsD/b8dfbX1mB/dnulQ56
+ysjsD/b8dfbXxmB/dmAf0pz6+9SgvW37V4popdf5q+5w2cD/v8xJ38Jgfy2
e6WMXv4SAvltwD+VufVXMYH/sd0rhfTxdzFB/G0D/vIrpfT3/+RXSmleaWOD
VzqlNid/EYH8NuCfxpz8hQTy2+CVXmnMyV9IIL8N+Kc1J38BgfyWv/XtZ/nr
73/K/DX3P23HX/9Ks/yC+dfy1xv+kL/8ekX9/ov8ekXN/ovt+OvlzyuQ3/KX
ZP6Qf3pz9p9HYP824J/B3Ponlzr/cfu3/H2nP8sfl3na9Z/MX3P/wwb85Tfz
6p8wk9/Mq3nCzPI38/4sf1Sx9uMmOST+GBRz+7P8VdM/5C+/6lr//IP8qmvN
8w824J/ZXPyVTRB/Wf6+8p/lr3+llcxfc//XBvzljxPo/6RW/jiB5k9qLf84
wc/y178vPrM6//F7gJZ/geKH/LNKJPVPGGaS+GueMLQBf/kbMfo/Kc4g8df8
SbHl34j5Wf76L4CkV+cfboOWfznoh/yzm4s/0gniDxvw/93c+E+j6p/PP1lt
xl//canUqv/l98As/0TXD/nLnwjTf38rlWD9ZwP+Hubir5SC+Mvyb6n9kH9O
c/3/m6D/Lf/o3M/y1/f/r4L+t/wzgj/kn8tc/ycX9L8N+Oc21//JBP1v+fce
f8g/j7n+TyLof8s/jPmz/PX9n1jQ/5Z/L/WH/POa6/9Egv63Af985vo/oaD/
Lf827g/55zfX/26C/rf8u8M/yx/7Xxv/uEr80Sh4/1v+leof8i+gzv9a+3NR
7Y/fA7P8u98/5C9/dxxF1K5/jWr8wV9rY/ln1H/IX/6Mu/6b2vJn3DX73zbg
X1hd/2jH33ehZwHrsy4iWPpLCtDedS1ofdZFBVHfZ8GAL2R91sUEC+6PEmvN
s1aFrc+6uERS86zJe4k17n9wN1PE+qxLCNzcW3WFy1dYRW3GGqVTdvnhjerc
+OZCMeuzLilwrq8E82px67MuJWD9Ql3S8iVVCeuzLq2y5gp/JphNSlqfdRm1
rxVTg1iBmZWyPutygsH1WB1cnHVp67P2FLiUh6pL4eO6jPVZlxc40mjBzk1Z
67OuoE4ffOaKEkwf5azPuqK6acMn7buCSdPT+qwrqfECj1duq6EKD5crWJ91
ZTVU4qHaTdWb8Z3qitZnXUXgza4LvFkl67OuqrLmLuWqGptzb1bZ+qy91LUJ
t/BLapTCx3UV67Ouri7LeF+fV/uam1k167P2Fij8rEDhXtZnXVOg8FMChVe3
PutaAoUfFyi8hvVZ1xYo/KhA4TWtz9pHoPBDAoXXsj7rugKF7xcovI71WdcT
KHyvQOE+1mftK5HEWYrPXDvV6QN3u5nS61mfdQNVaiVIgu1qgMQX+fWtz7qR
2td8+tiiTh+8rxtYn3UTiSTe3+IK3yix5srGFg2tz7qpurWi3N6BdRJrjMu5
whtbn3UzdVeBf0V0lapw/kddTa3Purm6BECls1dSRqguhcfhftZn7a8GSMrz
BBCmjmsepTS3PutWqsJ5WLhEVTiPSv2tz7qN6lK4I12gskbfzqy8lfVZt1VZ
83E9R11p4qqEsW5jfdbt1dUHZz1TZc0V3tb6rDuqqw++vp6qLnK5N2tvfdad
VdbcwiepFs5Zd7Q+667qwodPmhNUb8ZXH52tz7q7RBIdJp+5xkqsEQrfHu5q
fdY9VZeC0wV7G8MINUrBNTbz4z2sz/pPiST6at7Xg9W+Rgtng6uX9Vn3FUjd
TyB1H+uzHqBKjZMmmz56qX3Npe5nfdaDGEkTko/LvouWO5vABlqf+1Ax93YC
7kOsz32kOn/hLM3+6sifsTahO8UeR+eC6IZbn/sYSXa0N5wzUFiUvbEaneIs
xkxutPW5j5e4owfDjStkx1Ygkvjo3LAaVYPiB1gEgNIANQvGTA8gSAKArhXF
Rx+HSq8mAcDRhxpBFaCrC7S+BqYwki4YqaKYKC7aH3v2Tfo7GBe0CNQMnkNL
YJ0x2fpQQiQoKCjaO7LDHmBQCqpQsA5dE+qLTT0zrQ9lPiPpilpBFjgqEQ52
D4ckPaXmimWsQ61hG4SO17Cl5Ly/gWZk0Pr1m8oSwVzNJrNKHa5w1VyQBybs
EVe26+qCEBCKktgfEEnnTNhMuQQvD/shMlTYzl2ncJW665SaTWaVOmQE6f1d
7CETDd8D96OiKFGaq9lkVulQRFcs38Ns4zuDmSw2mB8SlQxxZcQ+ePf+I7x/
/9HACu40/4CHNH1g5XdymdW9U44/sl8DK5nken7OyArGOKQ+4u3F9x9nYkbw
7EzMqsuXW4o9HcO+auV+ePnyDUsvML16k/n8hYuZz5+n6cKlzOdowvK586wu
0wV2rNRdwvpMrB2ru2R6+uyFROvVW4nuK0YTy4QyeKtm+TCrzphaDj4hA79m
9UGIefJCSrEv4PGT55lPnjpLwsPDydIlS8mSJUsMZPHixWAkixYtIhGD+pOF
CxeCAXMDVklnTXiBSujJcwMrGLHIqwnmMzAjyGsmZtVZi39qNuvWHoKo6BiI
uh9joIUnYGwVFDSFzJ07l6xatYpifvz4MSQmUZcvk1v+TciTyEgSGxtLnj59
Su6dO09iHzwgL168IK9evSJLly5FMjQ9YSQN7MgoH0uJYD4DM4JnZ2JWnbU2
wrnzd+De/Wdw+TKOtytX73fGLB5cvhIVD27cfBgPIu8+4YNow/ojcPP2A3qE
+S+5t/61m+k3JiaGPLh7l1zds5eVLy5dRh5VLUfeLZjKUD9eGUYuNGtOXjx/
zlC/fv2aIUcqBppHyxSxhL8ES2rWT25y4uRtePPuE3yiGiXw8cuXLpjFw+N4
cOderDmcdWeGzCPBwcFk0qRJqFuyqUETcsqvObnm34K8rFOVvJnQlMQOaUIO
F8lOjg8bwTG+fhpLli1bZjHOU7fp+PwEX78izi+I8wvipMcKTskQNm06Cpeu
3oHLV+8aWCFZ0wkTp6BqyEPayajKs3Pnkc1pU5LoZmXI+971yctB1cjF3p4k
NEdaElq2HNk9fiw50aMjiV6/BqEimbuU+qUrSJVRpn15l9DsTghmBKtnYlad
NZXQMq1++oRa/fjJDzN6Yta8FbDMrzqsbuANbiw3QmhTL1YvtaA51f6nL4pU
KZlUW7YchzPnb8JZlm7hb+bNW/eS+T06k02NfMmZJn7kWh1v8uCP0oRs7ko+
bepOPgbUIw98ipNjhXKSc/VLkUf1q5Ho4Mnk3bt3ZFloqJERM3Ky+EuwFIIZ
oce3ZmJWXW6HMr168x4+vH+PrvPdez/M6IntTXyBzJkLJDwCXIEsC6d1WMY6
PIfO+H08+PDhoyKT5C3/2naSEr0Kx09dgxOn8fdqx34DhpFZgwaSXeXKktcV
CpB3Tb3Ix4n+5OvRoeTLhSASM70jOelXlURNaUO+behNPg/ryuT58OEDCV0W
yuidoPTi0MQ6gpUhmNHS6WszMavOGktyvXj1Hl5TJ2uAV6/eusCSxYtZySAo
GbFEL6NFVsL09ydUeqyUgNMjWMrKLjDCna4dgGzZQtNGahmYG9kx1kstaB4P
Xr95rx2XO3aehkNHL9IjzH/JGrF6KwkJCSFbt24lL5fNJy9H1iYvR9Qnn1b0
ILdmdCE7OjYkETXLkje7+xOytQP50KMOeXf7Nvn48SMJDQ1lVAxw6MhFSvDI
JQIHj1wKwYyWjl6ciVl1eniR9urJ05HwlE44T5+/wMREMvISsGIcTZg5YfYK
sydc+AmVaAJeIljKyi4wQmQXWakb1mFkcJkKRYusBKzIzmIrE14RD56/fI3q
fcLdye7dZ2D/wfOw7+A5A83OQ7JW/QeMILNnzyZh4WHk8V/bSGTnsiSyZVly
3b8i2VajNFndsCZZ0agaeTjah7zsUZY8qZSbPC5cgETSsRcWFmZkZIyU6jlW
wkSQfghmWDo/E7PqjC+q+TbEPn0Dj2Oe06SoWSkBK8ZRs5kTZq8we8KFn1CJ
xsdSfEnNtJSFXaBVs5Ep15WVsaQkrbLpdfHgydNXWmXv3XcOdu89A7v2njHQ
wmlIkXvBolVkwYL55MSGjeRUocLkr6wZyIEsGclJn5Lk3tLu5PKIRiSspAdZ
UzADuVejCHk2L4S8PXOCfDi2H5XNqCBJ5XcX/SV4NAszgsczMavOWkhGHRP7
CqIfPIXoh89kbSslYMU42jZzwuwVZk+YLCFvkC9R6vBXaUqwlJVVmaiy20sd
s34NkHVrXFhPmICsWg5kZTiQTeuxPxihePAQ+0QKTcx1h8/I0ZNIUFAQmdKs
MYnasYMcnzqDrM2RhnyY1pp8ux5MvixuQWKaFiI7sqcjW3PnJnQCJJ8/fyZ0
rv5H3XGKdsejJy9pePUYoyu5O5QSsGIctZg5YfYKy0mpJ1xZvdRvcVpgZBiT
ldW4QGSndtTw1wJZsQzI8qV0WlwiDxAXIKELgCydB2TJHNYZkZ3bUWr0unjw
4NFTpSekqfLAwQuwfecJ+Ium7SydLD8xaBYdGQvIpYsXWeh69+QpcrZ0YfJp
VDvybhCNatqWoNN/eRIzfjQ5U6I4WTduPOsGGjFR1xVOaZ2E7TtOcpp4TMsE
CyGYEWQzE7PqrAHtjTORFNsLuB35CCLvPJZ7QykBK8bRLXMdtMokm2vcs7xa
e5HantWzCdMNS0ZJt7SUlV1gknQbEQZk4WwgC2Zz254zA8is6VS1S1CljGs8
uBcVq2g0DdPo4cOXYctfR2HLNkzHaPlY0clTF5KxY8eS6dOnsXD15IDe5Bk9
fvv2LXl/L5K8Ll2APAmZyoz6A108nJs8lXykwce3b9/YoofSgK0SLdj61zED
EiZYE4IZwcOZmFVnrWR1PnzOwt5bkQ9ldSolN16KLzibiJcS8BLBUlbMUKud
6dBftgRIyDTVJ0+fpvHJX4KDqerms7YmvA7dcYx2fXL06BXYtOUIPcI8ccN+
A0az9cndO3fJq+fPSOT2bUxBShR2vlt38n7HVj7qMWA3oIroGgyVhFQwEczV
bBCrlHRyn+rk+s0HcOOWIrVSchPUASvGMTvlRCJeSshaSAEaljARzDPLJ5if
nD8fPgRNAiU6+DRpEnyQk1L3dmIQkLnzWHsTXhsPbt/9TmEnTlyD9RuP0iOW
/2fx0i3MZUZERIALy40kdMoUsnHubLWOYGM1GyJTQG1ERT+Dq1fuQ3q4di1a
FkwpESzlw4w2vocR5LwF8GrcBNrXbycGYsxIy2T+AnoOAdN28eDWrUdawKdO
34C1a7BHaK5mk1klYrgDd+89hUsX79Imly/f88OMnrjUtRW1HurE5s5H26K5
kSmHLFwKFxg/2i4eXL8ereV35uxNWLXyIN50X3lQzSazSiObgR8+fgl36Cin
i/+7MX6YyWunC/1bwr2B7Sm/uwPao8wD28EFmvCcCdvFg/vRT7X8zp27DcuW
7qbEaK5mk1mlgF8XG9O5cPE2248jmKvZZFb5/7q5EuiqijRd7963JGwBEW0M
9uluAQEddNxQpBdH3M+ZbhGZRlZZxg2FKNAq2ke6dRC1ERFblEX0qGBYRCRs
ghAIIQmYBZIQlkDCTkDZAjEEcqe+/1bVXVLv5UWkdSbnVN2qf6+q/6+qe/Oq
GiCnsLiMrViRh6+PK/KcbCIBTdo3Hj1Rzd8Y8KmL58OQ8TeIU2e8bxBbSnaz
o8dOcyKeO9lEAvL3w4IyVll1jp2pwZs3z4chC7DqM7UBtmf/UXzipa/GMnub
pJrsq5V5LHVRIVu9Oh8/IVqdPwxZgKWnI1tTUIfRyUIkQhqIrz019H2C57os
YGd+HnyetZDrspg8dS2qRRaow6j5eM43tL7sLG1ynU/G9ter/78C1gli/KGE
tFkD8+no93PTEdbIM30w/BkoEagZSiEFCzL7P1qSUAgxUG6qmIRMSWBoNUgy
Uwn3GWZ4JfuwQR9vyIP1NIQFPThPWxwlSV6Y1iwvna+Zpg6h2mqLimitrNvt
ri4Wf85A+AdM9VWUwXHa5GtxXdJ6+zPqSETRbSqDDa9uXx9TqXkMxTov1XWE
bwDNGCKbRevHOgESxROo5gvHvj9OOIY8imI1uHFUGYnaVvufzfUREtXJ6hmD
aLw6xzHjCAkzRgDHYUrz8+ydZnGbGA+Nzl79SEfiHOlQvSETnyf92LAfwzPj
6bO67a0/nps2QEbDYXFFUpMGRVf8k4FvMuotSC7IZNTiPIc35sQT9IswXG2W
qGCMgUyKat0FnW90aoNRTfHy6qbI6Hp/3PkmrPo46gqv2yKedyT/fGab+mdS
zcxLPeZfI3TPH7p0OrDEmPIb6kOhOHv1wkwoQb/toWi2X4AJRfyZSq9vVom+
ZFyw2cQh8pqi26EGHbuDfn16M+vK1b6pRHOVWNNGUAVBPBOfkqZ7WWB6B2yY
lXFOE0GfJV7x0Z2izqrkJ8Vf8/+D00EDBuS8ZwS7z8LRbI49aA1ZdeJ8s3Fa
Ho4m1vUCr5kX4vEX8Rfrc0QcO4ToQRZfj0Rd2w1nSOJ1wBgTgk9DM9/o6ddY
//oby4po/XP++4fzt03XQ25ZOvoW/5IpQ7d/q+OK5CJhF5fE+8euvv68MDuH
mJ8pdZ6t/1AXlUPS+r5M6cJZ4uL5OKnn9C0cOsU64SGf8PrfIqLu3x0puo+E
up1EbNNiOX7sr6r6EPewxfpcGXSGtKHaY2sSf74viq4OiBXldYbdt/GI7mCC
R2er7kXnp/9s6X+hQNJ9IYjE6DTdx7pWGpjO85I1MF2IJ2o6REfXMk4duiVZ
N0LJMdqt+9gX63X0snodr357WsfpRbpx9fnOgAb7TpTXl5YKF2vBTVJBc0k0
3yBGXQud/934+1xJJmz0b1sa74z68hprS9Fa6Uq4gKOPv5/T6OsiTRdVozTt
aKuh+zcN7EYNrKsG1v5HbttP/1/qf7kAG4rzRVOmzPKfZqOsFlkA6ADo6jJq
Dps5WRQezbEvJ9Pw4AyR5lQXZUsJY5LMaR8vY0+MepPXkAfZsNETqYQnT4lU
CRMZmWBLkKzBhnEdqaiwuT69pTvnmtW1O5Xw5CmRKiZxgdI2kucBtEY2zz5J
sbt8Nx+Vs6ymxj5GdLbmHC+fEz8yOcvOAoZnjXyepaeNkzw2nc131iBEULHW
EOs5C3TvIsOPVM7+Exn9XCWFhJiqB18Zv4Cv5sjDVAdc/uZF0LSog7ZbgDJv
ewuW2u1BPkujGyRaNgJS0GivH5eVlf+Ex+wIlkJoU3XBtBlf825AHqY64FKI
oGlB6ASFtvV8T+1GD6zp0Ydl9nyoKct8sC/fvPAigYACSZWrhXiiE2S3tKDn
ztJy/wk+OnVnn747pU7icVyTo/sP3Vs+93NelzAcIAFXIpUJLng1J/iY7ggf
SpUpJMTumIVp+WzW7DW8Y5CHqQ74MWGgoGlB6JALbetGqw3qA5Nt6NmbfdO7
P6XGlAcJBiwSpzWE5uOi6egO2UEReu7YXuY/JUjn9uxTfo1cp/yOXr1zTVbp
qa5dHdiRY5H9+w42PbhrryEO+1UcOVr3rGCi4igs2MHWrylgBw58S3U8UQc8
SJCgokEqLtplCnDZrgMsO2MT275tDyAG8KYq2cxhxcwZVbkMP6flBUNRO6WQ
KjEqsn37DlMNT9Qdeu6mUaQTdmfpvqhaDGHd1i3l1Abw5WQWSiX18P0gvbw5
0AYtbm1G7H4Ki84GWBq6KXeb6OdvsotNIZtr9ciGNWe85z9xJvRoivAL+PDi
ZQVs3vxMpAQxpaM61waJmkl1kILF0LM3AbsRhR7mIUwQEBQivfqw3N4DeIjk
PzSAez3KgMnwAa30T9IXQFB4Z9etW3d5T6O2dE6U7q34xba8Ivsk6d6KceuH
PWdZXa7pVrFqNeqX7C4oXpPb5a4AnXgAz77DUpTvRGoi1QcPfYQ1a96cLV+c
wdXuZoVbdlD9z//Vj2VnbmYmSWjM+vZ7mOBITwxLoZHYvKmUsJ/NXcAuS27D
Xnj+71Q3iMokGnni1YY18sCQ+vYdSJjhI0ay/gMGU/mdSdNt8rAil6pFXa9B
IUKEyMzKpdq81CVkqjQhN2dLLNVsF3euqTM+InKX0CbRjGHPPvsitR+wjp2u
YvPnLIXCuNrg9EgDzfGqv/LKjgTtdPXVLO3LlWpoYggNEUEj9vgTI5T1D/Ts
RWIL8rYR9uaut7IbbujCNmQV2Y4YYe9OmeHRNm3ax8RSvvsgq/aeaKazLCni
LAviZcXXhWzhwhxKiMgwe+pJ7ADbtbtJwUOUh4kWPOS8PAl+g9C0OyM2pETk
puBWfBQsh8USZi9X+X0GssK+A+S2MIKKQbVGBAdeLnHgswOoQgUSj0vvZndL
yU7nVLNJZ42bdc5MW523rlO3ziWLV6cf+cN9lnXLNUfOvnrXjBOjBlkHm4Tf
Xt9/uH1kuXSffWy5FMeX99unmVt7TjPDm9DR4/9nIsvdWMLefW8G1TEA6PRt
2/cQ7VMjnlF0419/k8pDBj/OstYWEL7N5Zcr10PdHT+2LgmLeGADBw1VIQS5
MrxQd7uzwx9SdTc+aEPYHXferWDSZrJz3WYq//73t7ONWUV+vW61/uZQt7kj
1K97zItjqTziqdHUBjBDt2ILa9kU2m5RrJ6o1yS3CSDuwcNMmKBvqqnkyhPu
+/i6LMUggBemLVfztDK3y81dDUEr8ffd9yfupWVKDeZ57km+Y/KWzQ9WO1JX
pRezpctyKfkjVcJDlIeJFjzSXMFvENqJVNQiGphNl+gSY/u/XFQLHurPCvnq
80C7X9mcIVY8YLAtI0RQYEElw9Z/LwCi1LvAFhWX+k754yA+lXACn6finCtu
tlazlpb1Hx1ram9qf7rq1RurNv+tk/VpIpsxq8cQHNfvnfX25OfLx74UKirc
oTvln5WzWQ5n7z/3Z1l8h4M52IY1pqHARAvNyW0c90EdZUzKsu52RYl33I1D
3BENAj8TFHmZHNf3C4wqDnkjdnv3uxRph46dqIwn6jKIc78pcWvwa49pcERr
lOyhkL3njMP6kLJIomBGnD0Z9CilLb9PsL9NIRIXZDd1uaW+dpqUJ7A/9XiQ
sB/OSCXIvM8Xq6Dm3lLtvR3CgoulkJ/ZQbp23Va2YmUBJURDBDEVoWqYkCAS
/iwZDEI7EYhaRAOz6UJKDIUH3+Hb8VXUbyCnLxn4MNv68CB25y8vs7lNVE2x
2QYUWFDZHGHiLpZBtkU8i0tlcLai56bCUv9lFQn5G4qa52fmdsn6ZOFvchev
Kcy9op119N5LLWtJn6JT799fU9vnCqsqOWIVsCQrq1HA2tyutVXbtkPbjWnp
WPe5pKZK5oS3pig/vbKD7bd4oi4X0ez1hUTrdjTU3QPO625/8KMNhyCiCJBu
u/1Ogr722iRXKNb1Vke/XoHdrmZs1F9eUCsI2T9uol2fs0StOhtyiv1647Rd
TxCu1+ZELV+stscwIuhXZLc9qG+T6elu09+Wb3K3KlF4xQkJMjmXKd0c5t5s
VXsvNqHLTlIEHUIkK3s7W5tRzNcS5GGqAy4NETQGoZ1oQy2igRkCI8XkiUtW
EENbBgyg2OJr3NChvAGINfmtEwlQW1oC4VCXCXzgh5x8vKVw2wKQHEDkyVDs
TM/8Tdv9d6z8JvPLFWmZt95tnQk3tqxLeQj+/tqT5z7padV+N6by7Na/nD73
5h/P7rs+uWbXne0P1Xw0pKa2Vxchgyfe9bo7Vnr3GaBCT06I7jomxEw+BOBL
btNGDVN2drFaKrN4yHK8e6RB7vUoRRBW/Egg7M03/1y2KfnXej0bZG7ZORu2
KHwmRSOENGVPjxxDMGxr23PPgVmYXYYMfUJFYzZ/A3WpZG6dMWxuUkcxGDz9
wffOauuwbrO/qW65XIyMLdmzmh6IYU1jNXFKpBgB2uhkrS/SNNFUQpFMR1iQ
hnwy39iixjetYQdnqrFE0sGqvFfz4LqekhRxPw9CB7dUZeVs5cGA3OQhtZVK
osbzoIKBlvMYxB72sCOJCA1RpYVHkgxeqnulKUeXwbt9yBBW9shQVvbfQ3mL
dj7yiFgwZQCb4q0UMGCRQAse8MoAzsmloKJhCSBcve+neXyPght5gpQ3x708
dxe9M9OyHmxrWYNvKjk96f5DZzaM3HtwydP5Of26n1nRrvX3VcVPH6jePTL7
5CPdiSuDJ86HMl3sg6yIN729+AiwzrXtc9fbi2kzI7OQDRLOP44vTe+IQR7E
A8TA1UDuKZ5Xpb8ZYqFxgWg+ePvt6VxHPrFyL+VFtfJdd/1NLGNdoVqBxr06
ic1NXazY58xbxutLlHmgDZKcRuyDj+ap2R6xCxzMls2Ef2YgpEAe1qqVbbEt
T/JYDtqZYlaT9L34+wrqY8b8XfVKLz7Tga8hTYjfpsYemwAZnvIclQfzJoMf
74vD+RTFm8pidXFI4K67oYvqNjx/94fufM1So2qqUXUaZbLM9HwFq/LeDoUb
owpT6IooO3bzC8rYhg07uPMiD1MdcFAgCRqD0M4KilpEAzMERopZJ8QgmBBY
u4YOwT/iH39Us6qibuOCRAd68GXg6xi3PYDICCDovG+bG3O3eS6BQsZjhKWv
2/TirvFjrP2vXWtZ/a+qOj7+ji1r77l+58Ket52ae+OvSo59PqC69v2ulnVf
cn5l55tbrVq0FnLsG6CS6AaoRUvXqeBbuzaf/VYEob+Od03UofhB7mIy5lBO
p5ukCmzznEGTXiLcR2FDxATfk4wo27impHD23CV2CznkyRGjVQgBN21mqjIK
cNCGiDpMOKl17meLCcrx7hXCpVLa6tYY9NkaVLOS0GUIMjRBquJlG9woXosN
YbAkk6TCjKDQLftATWgAhDwK8Hxr8nQmcTqJYRcfrY73/pEGCOMZIVyC4gM8
XYyz3AhkpOdXe+8Gs+BGKeSTdpBt3ryb5eWX8iBDHqY64KBAEjQGoZ2AQi2i
gRkC4xYDi2SQlT+GTWvZsMdC9vccXuJtAFSGVDopln65CSHkjamcjSWey6UM
qv0Slz+dq22VaG3qnGhVXNTYymnV2Mq4Orn6iy7trJmdkq3ynr+wrHtaW9WN
zMOnL2q1/rvON3RdO/nDOjdL/e2VCWq7torDnnhylLaOFWnN6twE2wZnuwU5
7nmW81xOQOedYk16HjMErN2VHRRpoiPL5IMnbcr1bH0krI1DHPQQEzhjdd7F
VAspDa9yg8lLVuPbHXAJrGevPoSbOf0ztpY3/tPZaXIfBsOrvZdr0YVbKcJw
+jZQvJcPNT6iIQ9THXBpiqAxCO14iv16grwx1YGVyRFhtwg+gf1P+eOP45ar
YcNMcUuwb44mHAeDDvTgEy6SF4CkADxHulJLembnlNA9Tq7bsfBs/WXqstz0
ttfs3njJVVYqS7a+YY12H5pwf8X3lZPLKyfdZWX92rTeY80qtyc1NpZ/lc2H
Z/lXGwy6CCvJczVWj55292KN5yTs9Qnva+t4y+EjxjuFy5BfDtbxtRIipZDp
02bb0c8J2xDG9qhBDz9KlhsC1m+g/Y+9NavwcdWBtWvfgWqGo8RUSpDaRCPm
sGuvu5FdxxOUX0ywEPvwky9Za/H/o1densBWfw3HAi7C5i1YRbi77vlP4oFD
gW7Cm++zM95LwlDakEL9ZXtVSck+7grl5FXlXCLqgC8XvSpoDELb7oBv1EgJ
lDcTXlWuklfERturHnuUlT85jO1NeZKn4WzviKfcX7B41fm+ZVA1kWjBA17I
WO66Cw2eBI+SPnYxPddn29dgue4Lw/PitNRl5hKCZ498b+hoa0+nJMtaMKCi
OuvRc7Uvdbasrq2svQmGlWleFExLy1T3gnEP810Xxtq27yB2iCsJjqeuDrpE
gpjs1m63sdaXJVPNcMFAd+2/38Aud8FmfrjAQ4c64Kg108i7ArkBMZf4OO5/
oDcfIsBCBIMmadlfX3qd1XjvO6M70FLEpWdyvsFQlpTsN1EIqZKBkkHIRDWH
gBHJxyresOApTclTALNx+7y8vHMxynuf4h4ycjg7AC/hT/kvCHKTkcNVUu7C
pbvpwQ85YuzpCZ/gvuF9a8sUd6ZFKE+cP7XrvZZ1R7fnS8Y+l3+8x43cKS79
fPutv7t06adpWQeu++3CsV3u9t+HRtls4re/FRcV7WE7th+gVMpTMyqFCQ68
vFdN0BqENonU929WIBLr8KFhB57hjR31NKsY/QyreHY0M1xxdOivz1IyKU/w
zNugBQ94IYPLCkJoAD2h75qw3UEtl6QuLSrseH3zZdy5wfFlWqZlNWt9/YrJ
H3D1dPFcj6Vj/tF8/pyvdNfGUfapuKCOml64h5XtqsCv43kepnqd7inc04LQ
iXXQ9OOO555hh154lh0d+zw7MX4sNwNtjbDDU15nFVPfYN+++1qdsiHeLUAP
PvBDjv1zxehdgWvewvZlb79eNGN+0hezV1LNsGGpX3d74MqVU+dTzXdHHGWp
4qI4tOHbwyfZoYPHedORh6kOOCiQBE0LQreug4apx18axY69/AI79cbLrGr6
BHZizj/Z8YVT2beLprIjadOilkEHevCBH3LspnPJUZq+dEke3zfQHXMdZ01K
bbVo5hLdNXSUpYq76GDvpoI97MTxKt5M5GGqAw4KJEHTIgoaZlW+9qLBTk18
pSk7sXQGlbhsDiQkiAzkAZioMR7Xoq7nb5y+++soW0qX2AXZy298RFo3bijF
7zSbis0OfrIJEFCcxPgB1BH21pRUMtT64B+sdtXH7MyOJezMYZ4OLeaGV/M8
SOVqkXjZBodtMk4ONrBDDBdnQnIAjQqgdd6NOpq7adMulrYo23fzHWVLxfV3
sg1ISeKHwYABi2T8ADqYh5REecRDh8RNItNgojQ6bP/2etYqtn//txxr35H3
xYIM33V7lH1PhCGgiQzkYAPU+d3jocoqNm7cVLooD7+q3bvnIMvPL2M5Odv8
l+9RdppkhQkPOtCDD/xcToBlbz1BRxkqTp4iJe9MnqOEnzh+kh05/B0rxy/K
OdCXVRJhBGgiA7mUDTEQx7fI204ynAuBgkMnKpUSXGFIv1bW/bj7tL1DgjST
KKU8Q8gz2eHKU1zmSVbBZRqEM9mr46YTpeZKQ8pOESZINKAFF0+mMvLIKS60
8iQ7zIUePl7JKo6d1F7BdwZZSLAF/heDpMi4\
\>"], "Graphics",
  ImageSize->{320, 256},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->538654637]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"CreateDialog", "[", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], "]"}], ",", 
    RowBox[{"CreateDialog", "[", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Green", ",", 
         RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"WindowMargins", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]}], "}"}],
   ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167136883],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
  ImageSize->{320, 256},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->618619916]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13479],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowMovable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowMovable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MousePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MousePosition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24441]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15026],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->20525]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->389302405],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->454067823],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->51606237],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->829665861]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WindowMargins - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 43.8839708}", "context" -> "System`", 
    "keywords" -> {
     "margins", "positioning", "window position", "window positioning", 
      "window placement", "window location", "window size"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WindowMargins is a notebook option which specifies what margins to leave \
around the window that is used to display the notebook on the screen. ", 
    "synonyms" -> {"window margins"}, "title" -> "WindowMargins", "type" -> 
    "Symbol", "uri" -> "ref/WindowMargins"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6797, 221, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->23088078]},
 "Notebook Image"->{
  Cell[87637, 1688, 39629, 652, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->538654637],
  Cell[128052, 2371, 43017, 708, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->618619916]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 174795, 3207},
 {"Notebook Image", 174935, 3211}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2321, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2944, 82, 51, 1, 70, "ObjectName",
 CellID->29948],
Cell[2998, 85, 523, 14, 70, "Usage",
 CellID->7775]
}, Open  ]],
Cell[CellGroupData[{
Cell[3558, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4036, 121, 493, 16, 70, "Notes",
 CellID->9712],
Cell[4532, 139, 312, 8, 70, "Notes",
 CellID->1597],
Cell[4847, 149, 108, 3, 70, "Notes",
 CellID->14793],
Cell[4958, 154, 158, 4, 70, "Notes",
 CellID->13696],
Cell[5119, 160, 277, 9, 70, "Notes",
 CellID->1078],
Cell[5399, 171, 510, 14, 70, "Notes",
 CellID->948],
Cell[5912, 187, 494, 17, 70, "Notes",
 CellID->28362],
Cell[6409, 206, 351, 10, 70, "Notes",
 CellID->11145]
}, Closed]],
Cell[CellGroupData[{
Cell[6797, 221, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23088078],
Cell[CellGroupData[{
Cell[7181, 235, 148, 5, 70, "ExampleSection",
 CellID->972703715],
Cell[7332, 242, 104, 2, 70, "ExampleText",
 CellID->1108145522],
Cell[CellGroupData[{
Cell[7461, 248, 349, 12, 70, "Input",
 CellID->1623601470],
Cell[7813, 262, 11870, 198, 70, "NotebookImage",
 CellID->105566089]
}, Open  ]],
Cell[19698, 463, 126, 3, 70, "ExampleDelimiter",
 CellID->1821248157],
Cell[19827, 468, 103, 2, 70, "ExampleText",
 CellID->913949605],
Cell[CellGroupData[{
Cell[19955, 474, 348, 12, 70, "Input",
 CellID->708430313],
Cell[20306, 488, 16675, 276, 70, "NotebookImage",
 CellID->11964202]
}, Open  ]],
Cell[36996, 767, 125, 3, 70, "ExampleDelimiter",
 CellID->512253116],
Cell[37124, 772, 105, 2, 70, "ExampleText",
 CellID->1942687508],
Cell[CellGroupData[{
Cell[37254, 778, 374, 13, 70, "Input",
 CellID->407577968],
Cell[37631, 793, 7217, 121, 70, "NotebookImage",
 CellID->449850277]
}, Open  ]],
Cell[44863, 917, 126, 3, 70, "ExampleDelimiter",
 CellID->1633354008],
Cell[44992, 922, 105, 2, 70, "ExampleText",
 CellID->1947967891],
Cell[CellGroupData[{
Cell[45122, 928, 348, 12, 70, "Input",
 CellID->938931623],
Cell[45473, 942, 8733, 146, 70, "NotebookImage",
 CellID->58415630]
}, Open  ]],
Cell[54221, 1091, 125, 3, 70, "ExampleDelimiter",
 CellID->176179789],
Cell[54349, 1096, 87, 1, 70, "ExampleText",
 CellID->497352855],
Cell[CellGroupData[{
Cell[54461, 1101, 337, 11, 70, "Input",
 CellID->160982305],
Cell[54801, 1114, 31482, 518, 70, "NotebookImage",
 CellID->786129878]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86332, 1638, 216, 7, 70, "ExampleSection",
 CellID->30858],
Cell[86551, 1647, 497, 17, 70, "ExampleText",
 CellID->1016594877],
Cell[CellGroupData[{
Cell[87073, 1668, 561, 18, 70, "Input",
 CellID->360841373],
Cell[87637, 1688, 39629, 652, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->538654637]
}, Open  ]],
Cell[CellGroupData[{
Cell[127303, 2345, 746, 24, 70, "Input",
 CellID->167136883],
Cell[128052, 2371, 43017, 708, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->618619916]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[171130, 3086, 311, 9, 70, "SeeAlsoSection",
 CellID->13479],
Cell[171444, 3097, 720, 26, 70, "SeeAlso",
 CellID->24441]
}, Open  ]],
Cell[CellGroupData[{
Cell[172201, 3128, 314, 9, 70, "TutorialsSection",
 CellID->15026],
Cell[172518, 3139, 151, 3, 70, "Tutorials",
 CellID->20525]
}, Open  ]],
Cell[CellGroupData[{
Cell[172706, 3147, 319, 9, 70, "MoreAboutSection",
 CellID->389302405],
Cell[173028, 3158, 128, 3, 70, "MoreAbout",
 CellID->454067823],
Cell[173159, 3163, 208, 5, 70, "MoreAbout",
 CellID->51606237],
Cell[173370, 3170, 145, 3, 70, "MoreAbout",
 CellID->829665861]
}, Open  ]],
Cell[173530, 3176, 27, 0, 70, "History"],
Cell[173560, 3178, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

