(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38346,        990]
NotebookOptionsPosition[     33798,        842]
NotebookOutlinePosition[     35612,        893]
CellTagsIndexPosition[     35494,        887]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebooks as Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NotebooksAsMathematicaExpressions"], 
          "Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Notebooks as Mathematica Expressions\"\>", 
       2->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WindowMargins" :> 
          Documentation`HelpLookup["paclet:ref/WindowMargins"], 
          "MousePosition" :> 
          Documentation`HelpLookup["paclet:ref/MousePosition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WindowMargins\"\>", 
       2->"\<\"MousePosition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Document Generation\"\>", 
       2->"\<\"Stand-Alone Interfaces\"\>", 3->"\<\"Stylesheets\"\>", 
       4->"\<\"Window Properties\"\>", 
       5->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["WindowSize", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WindowSize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WindowSize"]], "InlineFormula"],
     " \[LineSeparator]is a notebook option which specifies the size of \
window that should be used to display a notebook on the screen. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2989]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given: ", "Notes",
 CellID->18954],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["wspec", "TI"], Cell[TextData[{
     "width specified by ",
     Cell[BoxData[
      StyleBox["wspec", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["wspec", "TI"], ",", 
      StyleBox["hspec", "TI"]}], "}"}], Cell[
    "width and height specified ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Full",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Full"], Cell["full screen ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, None, {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->2017],

Cell["\<\
Specifications for both width and height can be any of the following: \
\>", "Notes",
 CellID->21763],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "determined by ",
     Cell[BoxData[
      ButtonBox["WindowMargins",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
     " and screen size "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Tiny",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tiny"], ",", " ", 
     ButtonBox["Small",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Small"], ",", " ", 
     ButtonBox["Medium",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Medium"], ",", " ", 
     ButtonBox["Large",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Large"]}], Cell[
    "pre\[Hyphen]defined sizes ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["d", "TI"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " printer\[CloseCurlyQuote]s points "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"72", 
     StyleBox["di", "TI"]}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"],
     " inches "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "a fraction ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " of the screen "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[TextData[{
     "large enough to fit all visible contents ",
     ButtonBox[" \[RightGuillemet]",
      BaseStyle->"ExampleLink",
      ButtonData->28692318]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->17753],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["WindowSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowSize"]], "InlineFormula"],
 " changes whenever you resize a window interactively in the front end. "
}], "Notes",
 CellID->27158],

Cell["\<\
On most computer systems, the front end does not allow window sizes below a \
certain minimum value. \
\>", "Notes",
 CellID->25550],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["WindowSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowSize"]], "InlineFormula"],
 " specifies the size of the content area of the window, excluding any \
frame."
}], "Notes",
 CellID->9037],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"WindowSize", "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 ", a window will be shown full screen on the main monitor where it appears. \
"
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->29072]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55877288],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->394699157],

Cell["Create windows of varying size:", "ExampleText",
 CellID->15709596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"CreateDocument", "[", 
    RowBox[{"\"\<text\>\"", ",", 
     RowBox[{"WindowSize", "\[Rule]", "ws"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ws", ",", 
     RowBox[{"{", 
      RowBox[{"Medium", ",", "Small", ",", "Tiny"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->368881174],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{467, 488},
  ImageMargins->0,
  ImageRegion->{{0, 1}, {0, 1}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->94793857]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125870773],

Cell["Create a window just large enough to fit the contents:", "ExampleText",
 CellID->255242094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\"\<text\>\"", ",", " ", "\"\<text text\>\"", ",", " ", 
      "\"\<text text text\>\""}], "}"}], ",", 
    RowBox[{"WindowSize", "\[Rule]", "All"}]}], "]"}], ";"}]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 CellLabel->"In[1]:=",
 CellID->28692318],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhkl63/gX+ld6uNW08aZtUsEU0DbGtOmdSS9M1VZqUzyAKKBS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   "], {{0, 0}, {241, 123}}, {0, 255}],
  ImageSize->{241 0.75, 123 0.75},
  PlotRange->{{0, 241}, {0, 123}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->43123485]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6442],

Cell["\<\
Make a window that occupies one-third of the screen width and all of the \
screen height:\
\>", "ExampleText",
 CellID->80174909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{"\"\<text\>\"", ",", 
    RowBox[{"WindowSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Scaled", "[", 
        RowBox[{"1", "/", "3"}], "]"}], ",", 
       RowBox[{"Scaled", "[", "1", "]"}]}], "}"}]}]}], "]"}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->27827905],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt29uPVeUdx2Ga3vWi8V/ov9LDraaNN22TCqaAtjGmTe+a9MJUbaU2xQOI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   "], {{0, 0}, {266, 509}}, {0, 255}],
  ImageSize->{266 0.75, 509 0.75},
  PlotRange->{{0, 266}, {0, 509}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->392855815]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7358],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MousePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MousePosition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10963]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26739],

Cell[TextData[{
 ButtonBox["Notebooks as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"]
}], "Tutorials",
 CellID->1781],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->26975]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->212633045],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->254891778],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->83625548],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->263787677],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->334366285],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->47610968]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WindowSize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 45.2121298}", "context" -> "System`", 
    "keywords" -> {
     "size", "scaled window size", "full screen window", 
      "document window size", "interface window size", "palette window size", 
      "window height", "window width"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WindowSize is a notebook option which specifies the size of window that \
should be used to display a notebook on the screen. ", 
    "synonyms" -> {"window size"}, "title" -> "WindowSize", "type" -> 
    "Symbol", "uri" -> "ref/WindowSize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13808, 378, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->55877288]},
 "Notebook Image"->{
  Cell[14813, 418, 7841, 132, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->94793857],
  Cell[23295, 576, 2701, 47, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->43123485],
  Cell[26792, 660, 4007, 68, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->392855815]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35018, 870},
 {"Notebook Image", 35159, 874}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2707, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3330, 91, 4194, 83, 70, "ObjectNameGrid"],
Cell[7527, 176, 502, 14, 70, "Usage",
 CellID->2989]
}, Open  ]],
Cell[CellGroupData[{
Cell[8066, 195, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8544, 212, 70, 1, 70, "Notes",
 CellID->18954],
Cell[8617, 215, 1119, 29, 70, "2ColumnTableMod",
 CellID->2017],
Cell[9739, 246, 111, 3, 70, "Notes",
 CellID->21763],
Cell[9853, 251, 2822, 80, 70, "2ColumnTableMod",
 CellID->17753],
Cell[12678, 333, 262, 8, 70, "Notes",
 CellID->27158],
Cell[12943, 343, 142, 4, 70, "Notes",
 CellID->25550],
Cell[13088, 349, 268, 9, 70, "Notes",
 CellID->9037],
Cell[13359, 360, 412, 13, 70, "Notes",
 CellID->29072]
}, Closed]],
Cell[CellGroupData[{
Cell[13808, 378, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55877288],
Cell[CellGroupData[{
Cell[14192, 392, 148, 5, 70, "ExampleSection",
 CellID->394699157],
Cell[14343, 399, 73, 1, 70, "ExampleText",
 CellID->15709596],
Cell[CellGroupData[{
Cell[14441, 404, 369, 12, 70, "Input",
 CellID->368881174],
Cell[14813, 418, 7841, 132, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->94793857]
}, Open  ]],
Cell[22669, 553, 125, 3, 70, "ExampleDelimiter",
 CellID->125870773],
Cell[22797, 558, 97, 1, 70, "ExampleText",
 CellID->255242094],
Cell[CellGroupData[{
Cell[22919, 563, 373, 11, 70, "Input",
 CellID->28692318],
Cell[23295, 576, 2701, 47, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->43123485]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26045, 629, 215, 7, 70, "ExampleSection",
 CellID->6442],
Cell[26263, 638, 139, 4, 70, "ExampleText",
 CellID->80174909],
Cell[CellGroupData[{
Cell[26427, 646, 362, 12, 70, "Input",
 CellID->27827905],
Cell[26792, 660, 4007, 68, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->392855815]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30860, 735, 310, 9, 70, "SeeAlsoSection",
 CellID->7358],
Cell[31173, 746, 471, 17, 70, "SeeAlso",
 CellID->10963]
}, Open  ]],
Cell[CellGroupData[{
Cell[31681, 768, 314, 9, 70, "TutorialsSection",
 CellID->26739],
Cell[31998, 779, 427, 12, 70, "Tutorials",
 CellID->1781],
Cell[32428, 793, 151, 3, 70, "Tutorials",
 CellID->26975]
}, Open  ]],
Cell[CellGroupData[{
Cell[32616, 801, 319, 9, 70, "MoreAboutSection",
 CellID->212633045],
Cell[32938, 812, 149, 3, 70, "MoreAbout",
 CellID->254891778],
Cell[33090, 817, 153, 3, 70, "MoreAbout",
 CellID->83625548],
Cell[33246, 822, 134, 3, 70, "MoreAbout",
 CellID->263787677],
Cell[33383, 827, 145, 3, 70, "MoreAbout",
 CellID->334366285],
Cell[33531, 832, 172, 3, 70, "MoreAbout",
 CellID->47610968]
}, Open  ]],
Cell[33718, 838, 50, 0, 70, "History"],
Cell[33771, 840, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

