(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20356,        580]
NotebookOptionsPosition[     16833,        468]
NotebookOutlinePosition[     18540,        515]
CellTagsIndexPosition[     18422,        509]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WindowTitle" :> 
          Documentation`HelpLookup["paclet:ref/WindowTitle"], "Tooltip" :> 
          Documentation`HelpLookup["paclet:ref/Tooltip"], "StatusArea" :> 
          Documentation`HelpLookup["paclet:ref/StatusArea"], "WindowElements" :> 
          Documentation`HelpLookup["paclet:ref/WindowElements"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WindowTitle\"\>", 
       2->"\<\"Tooltip\"\>", 3->"\<\"StatusArea\"\>", 
       4->"\<\"WindowElements\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Window Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["WindowStatusArea", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WindowStatusArea",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WindowStatusArea"]], "InlineFormula"],
     "\[LineSeparator]is a notebook option which specifies what should appear \
in the status area in the frame of the window used to display the notebook. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3623]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"WindowStatusArea", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " makes the status area display whatever is specified by ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " objects at the current location of the mouse pointer. "
}], "Notes",
 CellID->17853],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"WindowStatusArea", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " makes the status area always be blank. "
}], "Notes",
 CellID->3592],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"WindowStatusArea", "->", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""}]], "InlineFormula"],
 " specifies a particular string to display in the status area. "
}], "Notes",
 CellID->20208],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["WindowStatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowStatusArea"]], "InlineFormula"],
 " can be overridden by specific ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " constructs within the window."
}], "Notes",
 CellID->56413133]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->148024893],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->121532081],

Cell["Put a time stamp in the status area:", "ExampleText",
 CellID->1173252716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"WindowStatusArea", "\[Rule]", 
    RowBox[{"DateString", "[", "]"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->966487549],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt2+9PW9cdx3FPez71X9i/su3xKk19tElriBbSbqqm7Q/og2ppt2adliaB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   "], {{0, 0}, {458, 126}}, {0, 255}],
  ImageSize->{458 0.75, 126 0.75},
  PlotRange->{{0, 458}, {0, 126}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->233141826]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->420052935],

Cell["Display a dynamically updated clock in the status line:", "ExampleText",
 CellID->663551058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"WindowStatusArea", "\[Rule]", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"Refresh", "[", 
      RowBox[{
       RowBox[{"DateString", "[", "]"}], ",", 
       RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}], "]"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1953313206],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt211zE9cdx3F1ep/JW+hbaXvdzHRy1c4kmCkmaSfTaV9ALjIlaULTKQFs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   "], {{0, 0}, {458, 126}}, {0, 255}],
  ImageSize->{458 0.75, 126 0.75},
  PlotRange->{{0, 458}, {0, 126}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->68291106]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4888],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowTitle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowTitle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StatusArea"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowElements",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowElements"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14332]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18956],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->25862]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->501112530]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WindowStatusArea - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 46.0090252}", "context" -> "System`", 
    "keywords" -> {
     "status area", "status bar", "window status area", "window status bar", 
      "window update area", "window element"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WindowStatusArea is a notebook option which specifies what should appear \
in the status area in the frame of the window used to display the notebook. ",
     "synonyms" -> {"window status area"}, "title" -> "WindowStatusArea", 
    "type" -> "Symbol", "uri" -> "ref/WindowStatusArea"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6671, 203, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->148024893]},
 "Notebook Image"->{
  Cell[7520, 237, 3141, 54, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->233141826],
  Cell[11289, 317, 3148, 54, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->68291106]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18051, 495},
 {"Notebook Image", 18192, 499}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2057, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2680, 77, 1581, 37, 70, "ObjectNameGrid"],
Cell[4264, 116, 532, 14, 70, "Usage",
 CellID->3623]
}, Open  ]],
Cell[CellGroupData[{
Cell[4833, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5311, 152, 450, 13, 70, "Notes",
 CellID->17853],
Cell[5764, 167, 240, 8, 70, "Notes",
 CellID->3592],
Cell[6007, 177, 231, 6, 70, "Notes",
 CellID->20208],
Cell[6241, 185, 393, 13, 70, "Notes",
 CellID->56413133]
}, Closed]],
Cell[CellGroupData[{
Cell[6671, 203, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->148024893],
Cell[CellGroupData[{
Cell[7056, 217, 148, 5, 70, "ExampleSection",
 CellID->121532081],
Cell[7207, 224, 80, 1, 70, "ExampleText",
 CellID->1173252716],
Cell[CellGroupData[{
Cell[7312, 229, 205, 6, 70, "Input",
 CellID->966487549],
Cell[7520, 237, 3141, 54, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->233141826]
}, Open  ]],
Cell[10676, 294, 125, 3, 70, "ExampleDelimiter",
 CellID->420052935],
Cell[10804, 299, 98, 1, 70, "ExampleText",
 CellID->663551058],
Cell[CellGroupData[{
Cell[10927, 304, 359, 11, 70, "Input",
 CellID->1953313206],
Cell[11289, 317, 3148, 54, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->68291106]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14498, 378, 310, 9, 70, "SeeAlsoSection",
 CellID->4888],
Cell[14811, 389, 961, 35, 70, "SeeAlso",
 CellID->14332]
}, Open  ]],
Cell[CellGroupData[{
Cell[15809, 429, 314, 9, 70, "TutorialsSection",
 CellID->18956],
Cell[16126, 440, 151, 3, 70, "Tutorials",
 CellID->25862]
}, Open  ]],
Cell[CellGroupData[{
Cell[16314, 448, 299, 8, 70, "MoreAboutSection"],
Cell[16616, 458, 145, 3, 70, "MoreAbout",
 CellID->501112530]
}, Open  ]],
Cell[16776, 464, 27, 0, 70, "History"],
Cell[16806, 466, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

