(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44057,       1099]
NotebookOptionsPosition[     38818,        924]
NotebookOutlinePosition[     40767,        980]
CellTagsIndexPosition[     40649,        974]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WindowElements" :> 
          Documentation`HelpLookup["paclet:ref/WindowElements"], 
          "WindowStatusArea" :> 
          Documentation`HelpLookup["paclet:ref/WindowStatusArea"], 
          "StatusArea" :> Documentation`HelpLookup["paclet:ref/StatusArea"], 
          "CreateDocument" :> 
          Documentation`HelpLookup["paclet:ref/CreateDocument"], 
          "CreateDialog" :> 
          Documentation`HelpLookup["paclet:ref/CreateDialog"], 
          "SystemDialogInput" :> 
          Documentation`HelpLookup["paclet:ref/SystemDialogInput"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WindowElements\"\>", 
       2->"\<\"WindowStatusArea\"\>", 3->"\<\"StatusArea\"\>", 
       4->"\<\"CreateDocument\"\>", 5->"\<\"CreateDialog\"\>", 
       6->"\<\"SystemDialogInput\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"], 
          "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Palettes" :> Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Custom Interface Construction\"\>",
        2->"\<\"Dialog Boxes\"\>", 3->"\<\"Document Generation\"\>", 
       4->"\<\"Palettes\"\>", 5->"\<\"Stand-Alone Interfaces\"\>", 
       6->"\<\"Window Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WindowTitle", "ObjectName",
 CellID->27664],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WindowTitle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WindowTitle"]], "InlineFormula"],
     "\[LineSeparator]is an option which specifies the title to give for a \
window. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6364]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For notebooks, ",
 Cell[BoxData[
  RowBox[{"WindowTitle", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " makes the title be the name of the file in which a notebook is stored. "
}], "Notes",
 CellID->23859],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"WindowTitle", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " displays no title. "
}], "Notes",
 CellID->6827],

Cell["\<\
The title given for the window need have no connection with the name of the \
file in which the contents of the window are stored. \
\>", "Notes",
 CellID->17078],

Cell[TextData[{
 "Not all settings for ",
 Cell[BoxData[
  ButtonBox["WindowFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowFrame"]], "InlineFormula"],
 " leave room for a title to be displayed. "
}], "Notes",
 CellID->26992]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->177152252],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->104765755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"DocumentNotebook", "[", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", "\"\<My Name\>\""}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36345675],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnN1Pk1ccx1l2v/gv7O/Y3V5uNVu82ZZMMAN0izEuu1iyZBdm6iZzGb6A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   "], {{0, 0}, {458, 59}}, {0, 255}],
  ImageSize->{458 0.75, 59 0.75},
  PlotRange->{{0, 458}, {0, 59}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->115083990]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177862567],

Cell[TextData[{
 "Let the title be set dynamically to the value of ",
 Cell[BoxData["wt"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->980302128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"wt", "=", "\"\<Old Title\>\""}], ";", 
  RowBox[{"CreateWindow", "[", 
   RowBox[{"DocumentNotebook", "[", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", 
      RowBox[{"Dynamic", "[", "wt", "]"}]}]}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241309955],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPFGcch2l63/gV+i163cOtpo03bZMKpoC2McamF02a9MJUbaU2xQOI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   "], {{0, 0}, {458, 56}}, {0, 255}],
  ImageSize->{458 0.75, 56 0.75},
  PlotRange->{{0, 458}, {0, 56}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->346248183]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"wt", "=", "\"\<New Title\>\""}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->583174875],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhml63/gX+i963cOtpo03bZMKpoC2McamF02a9MJUbaU2xQN4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   "], {{0, 0}, {458, 56}}, {0, 255}],
  ImageSize->{458 0.75, 56 0.75},
  PlotRange->{{0, 458}, {0, 56}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->638582219]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3578],

Cell["Open a document:", "ExampleText",
 CellID->607810311],

Cell[BoxData[
 RowBox[{
  RowBox[{"datadir", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{
     RowBox[{"Nest", "[", 
      RowBox[{"ParentDirectory", ",", 
       RowBox[{"NotebookDirectory", "[", 
        RowBox[{"EvaluationNotebook", "[", "]"}], "]"}], ",", "2"}], "]"}], 
     ",", "\"\<ExampleData\>\""}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->778105540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookOpen", "[", 
    RowBox[{"ToFileName", "[", 
     RowBox[{"datadir", ",", "\"\<document.nb\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37204901],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9zFEd+x/FN5Xnq/oX8D/kDqCT3UFBQ94RQlTOuGOuSuqIuxTNUeXAV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   "], {{0, 0}, {458, 308}}, {0, 255}],
  ImageSize->{458 0.75, 308 0.75},
  PlotRange->{{0, 458}, {0, 308}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->36169263]
}, Open  ]],

Cell["\<\
Set the window title to give the full path of the document file:\
\>", "ExampleText",
 CellID->573870908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"WindowTitle", "\[Rule]", 
    RowBox[{"ToFileName", "[", 
     RowBox[{"\"\<FileName\>\"", "/.", 
      RowBox[{"NotebookInformation", "[", "nb", "]"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->292917125],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3WuTXMV9x/FJ5Tnlt5D3kBegSuKHK5UoP1GoihEVxDoplyopnqHKA1ew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   "], {{0, 0}, {458, 308}}, {0, 255}],
  ImageSize->{458 0.75, 308 0.75},
  PlotRange->{{0, 458}, {0, 308}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->359387264]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11362],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WindowTitle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowTitle"]], "InlineFormula"],
 " should be set to something that formats as a simple string of text:"
}], "ExampleText",
 CellID->29729489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"DocumentNotebook", "[", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", 
      RowBox[{"Subscript", "[", 
       RowBox[{"x", ",", "1"}], "]"}]}]}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408330100],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhml63/gX+it638Otpo03bZMKpoBtY4xNL5o06YWp2kptigcQ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   "], {{0, 0}, {458, 55}}, {0, 255}],
  ImageSize->{458 0.75, 55 0.75},
  PlotRange->{{0, 458}, {0, 55}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->224059528]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31555],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowElements",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowElements"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowStatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowStatusArea"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StatusArea"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDocument",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDocument"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemDialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemDialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19333]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6182],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->25862]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->72733511],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->929150281],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->139678392],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->4790335],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->39717396],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->357443215],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->252905615]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WindowTitle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 51.3372866}", "context" -> "System`", 
    "keywords" -> {"Label", "title", "window title", "window heading"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "WindowTitle is an option which specifies the title to give for a window. \
", "synonyms" -> {"window title"}, "title" -> "WindowTitle", "type" -> 
    "Symbol", "uri" -> "ref/WindowTitle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5690, 174, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->177152252]},
 "Notebook Image"->{
  Cell[6530, 208, 2402, 42, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->115083990],
  Cell[9607, 279, 2309, 41, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->346248183],
  Cell[12083, 331, 2353, 41, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->638582219],
  Cell[15425, 415, 7431, 125, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->36169263],
  Cell[23319, 561, 8586, 143, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->359387264],
  Cell[32792, 742, 2325, 41, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->224059528]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39861, 948},
 {"Notebook Image", 40002, 952}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3078, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3701, 95, 49, 1, 70, "ObjectName",
 CellID->27664],
Cell[3753, 98, 451, 14, 70, "Usage",
 CellID->6364]
}, Open  ]],
Cell[CellGroupData[{
Cell[4241, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4719, 134, 298, 9, 70, "Notes",
 CellID->23859],
Cell[5020, 145, 215, 8, 70, "Notes",
 CellID->6827],
Cell[5238, 155, 172, 4, 70, "Notes",
 CellID->17078],
Cell[5413, 161, 240, 8, 70, "Notes",
 CellID->26992]
}, Closed]],
Cell[CellGroupData[{
Cell[5690, 174, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->177152252],
Cell[CellGroupData[{
Cell[6075, 188, 148, 5, 70, "ExampleSection",
 CellID->104765755],
Cell[CellGroupData[{
Cell[6248, 197, 279, 9, 70, "Input",
 CellID->36345675],
Cell[6530, 208, 2402, 42, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->115083990]
}, Open  ]],
Cell[8947, 253, 125, 3, 70, "ExampleDelimiter",
 CellID->177862567],
Cell[9075, 258, 152, 5, 70, "ExampleText",
 CellID->980302128],
Cell[CellGroupData[{
Cell[9252, 267, 352, 10, 70, "Input",
 CellID->241309955],
Cell[9607, 279, 2309, 41, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->346248183]
}, Open  ]],
Cell[CellGroupData[{
Cell[11953, 325, 127, 4, 70, "Input",
 CellID->583174875],
Cell[12083, 331, 2353, 41, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->638582219]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14485, 378, 222, 7, 70, "ExampleSection",
 CellID->3578],
Cell[14710, 387, 59, 1, 70, "ExampleText",
 CellID->607810311],
Cell[14772, 390, 383, 11, 70, "Input",
 CellID->778105540],
Cell[CellGroupData[{
Cell[15180, 405, 242, 8, 70, "Input",
 CellID->37204901],
Cell[15425, 415, 7431, 125, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->36169263]
}, Open  ]],
Cell[22871, 543, 115, 3, 70, "ExampleText",
 CellID->573870908],
Cell[CellGroupData[{
Cell[23011, 550, 305, 9, 70, "Input",
 CellID->292917125],
Cell[23319, 561, 8586, 143, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->359387264]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31954, 710, 226, 7, 70, "ExampleSection",
 CellID->11362],
Cell[32183, 719, 250, 7, 70, "ExampleText",
 CellID->29729489],
Cell[CellGroupData[{
Cell[32458, 730, 331, 10, 70, "Input",
 CellID->408330100],
Cell[32792, 742, 2325, 41, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->224059528]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35178, 790, 311, 9, 70, "SeeAlsoSection",
 CellID->31555],
Cell[35492, 801, 1501, 53, 70, "SeeAlso",
 CellID->19333]
}, Open  ]],
Cell[CellGroupData[{
Cell[37030, 859, 313, 9, 70, "TutorialsSection",
 CellID->6182],
Cell[37346, 870, 151, 3, 70, "Tutorials",
 CellID->25862]
}, Open  ]],
Cell[CellGroupData[{
Cell[37534, 878, 318, 9, 70, "MoreAboutSection",
 CellID->72733511],
Cell[37855, 889, 168, 3, 70, "MoreAbout",
 CellID->929150281],
Cell[38026, 894, 135, 3, 70, "MoreAbout",
 CellID->139678392],
Cell[38164, 899, 147, 3, 70, "MoreAbout",
 CellID->4790335],
Cell[38314, 904, 127, 3, 70, "MoreAbout",
 CellID->39717396],
Cell[38444, 909, 154, 3, 70, "MoreAbout",
 CellID->357443215],
Cell[38601, 914, 145, 3, 70, "MoreAbout",
 CellID->252905615]
}, Open  ]],
Cell[38761, 920, 27, 0, 70, "History"],
Cell[38791, 922, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

