(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17112,        493]
NotebookOptionsPosition[     13826,        387]
NotebookOutlinePosition[     15446,        432]
CellTagsIndexPosition[     15328,        426]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebooks as Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NotebooksAsMathematicaExpressions"], 
          "Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Notebooks as Mathematica Expressions\"\>", 
       2->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WindowElements" :> 
          Documentation`HelpLookup["paclet:ref/WindowElements"], 
          "WindowFrame" :> 
          Documentation`HelpLookup["paclet:ref/WindowFrame"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WindowElements\"\>", 
       2->"\<\"WindowFrame\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WindowToolbars", "ObjectName",
 CellID->29900],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WindowToolbars",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WindowToolbars"]], "InlineFormula"],
     "\[LineSeparator]is a notebook option which specifies the toolbars to \
include at the top of the window used to display the notebook on the screen. \
"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9447]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WindowToolbars",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowToolbars"]], "InlineFormula"],
 " gives a list of toolbars to include. Typical possible elements are: "
}], "Notes",
 CellID->14657],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<RulerBar\>\"", Cell[
    "a ruler showing margin settings ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EditBar\>\"", Cell[
    "buttons for common editing operations ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LinksBar\>\"", Cell[
    "buttons for hyperlink operations ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->27937],

Cell["\<\
The detailed appearance and operation of toolbars differ from one computer \
system to another. \
\>", "Notes",
 CellID->8677],

Cell["\<\
Toolbars are always shown inside the main frame of the window. \
\>", "Notes",
 CellID->26849]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5965522],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->1012302852],

Cell["Create a document with a ruler bar:", "ExampleText",
 CellID->249302913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"TextCell", "[", 
      RowBox[{"\"\<abcd\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
     RowBox[{"WindowToolbars", "\[Rule]", 
      RowBox[{"{", "\"\<RulerBar\>\"", "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148645382],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnW1vk9cdh1PtBe9KPwHSPgCfoN2bPbzZpqJN7EWLtCZoBOhUVa0mVdWk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   "], {{0, 0}, {458, 91}}, {0, 255}],
  ImageSize->{458 0.75, 91 0.75},
  PlotRange->{{0, 458}, {0, 91}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->7881763]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WindowToolbars",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowToolbars"]], "InlineFormula"],
 " can be reset by using ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->238154379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"WindowToolbars", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58286167],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3dtPlEccxnGa3jf+C/1XerjVtPGmNaliCmgbY9r0rkkvTNVWa1NPICqo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   "], {{0, 0}, {458, 91}}, {0, 255}],
  ImageSize->{458 0.75, 91 0.75},
  PlotRange->{{0, 458}, {0, 91}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->513241705]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22721],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowElements",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowElements"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowFrame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFrame"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17081]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8392],

Cell[TextData[{
 ButtonBox["Notebooks as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"]
}], "Tutorials",
 CellID->23669],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->8564]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WindowToolbars - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 52.7279472}", "context" -> "System`", 
    "keywords" -> {"toolbars", "rulers", "window toolbar", "window element"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "WindowToolbars is a notebook option which specifies the toolbars to \
include at the top of the window used to display the notebook on the screen. \
", "synonyms" -> {"window toolbars"}, "title" -> "WindowToolbars", "type" -> 
    "Symbol", "uri" -> "ref/WindowToolbars"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4523, 145, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5965522]},
 "Notebook Image"->{
  Cell[5516, 183, 3246, 56, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->7881763],
  Cell[9338, 266, 2638, 46, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->513241705]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14961, 412},
 {"Notebook Image", 15100, 416}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1512, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2135, 64, 52, 1, 70, "ObjectName",
 CellID->29900],
Cell[2190, 67, 528, 15, 70, "Usage",
 CellID->9447]
}, Open  ]],
Cell[CellGroupData[{
Cell[2755, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3233, 104, 248, 7, 70, "Notes",
 CellID->14657],
Cell[3484, 113, 756, 16, 70, "2ColumnTableMod",
 CellID->27937],
Cell[4243, 131, 136, 4, 70, "Notes",
 CellID->8677],
Cell[4382, 137, 104, 3, 70, "Notes",
 CellID->26849]
}, Closed]],
Cell[CellGroupData[{
Cell[4523, 145, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5965522],
Cell[CellGroupData[{
Cell[4906, 159, 149, 5, 70, "ExampleSection",
 CellID->1012302852],
Cell[5058, 166, 78, 1, 70, "ExampleText",
 CellID->249302913],
Cell[CellGroupData[{
Cell[5161, 171, 352, 10, 70, "Input",
 CellID->148645382],
Cell[5516, 183, 3246, 56, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->7881763]
}, Open  ]],
Cell[8777, 242, 341, 12, 70, "ExampleText",
 CellID->238154379],
Cell[CellGroupData[{
Cell[9143, 258, 192, 6, 70, "Input",
 CellID->58286167],
Cell[9338, 266, 2638, 46, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->513241705]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12037, 319, 311, 9, 70, "SeeAlsoSection",
 CellID->22721],
Cell[12351, 330, 469, 17, 70, "SeeAlso",
 CellID->17081]
}, Open  ]],
Cell[CellGroupData[{
Cell[12857, 352, 313, 9, 70, "TutorialsSection",
 CellID->8392],
Cell[13173, 363, 428, 12, 70, "Tutorials",
 CellID->23669],
Cell[13604, 377, 150, 3, 70, "Tutorials",
 CellID->8564]
}, Open  ]],
Cell[13769, 383, 27, 0, 70, "History"],
Cell[13799, 385, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

