(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38281,       1478]
NotebookOptionsPosition[     29708,       1176]
NotebookOutlinePosition[     31219,       1217]
CellTagsIndexPosition[     31133,       1212]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Local Constants" :> 
          Documentation`HelpLookup["paclet:tutorial/LocalConstants"], 
          "Some General Notations and Conventions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeGeneralNotationsAndConventions"], 
          "Variables in Pure Functions and Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/VariablesInPureFunctionsAndRules"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Local Constants\"\>", 
       2->"\<\"Some General Notations and Conventions\"\>", 
       3->"\<\"Variables in Pure Functions and Rules\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Module" :> Documentation`HelpLookup["paclet:ref/Module"], 
          "Block" :> Documentation`HelpLookup["paclet:ref/Block"], 
          "ReplaceAll" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceAll"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Module\"\>", 2->"\<\"Block\"\>", 
       3->"\<\"ReplaceAll\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"], 
          "Scoping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/ScopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Evaluation Control\"\>", 
       2->"\<\"Language Overview\"\>", 3->"\<\"Procedural Programming\"\>", 
       4->"\<\"Scoping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["With", "ObjectName",
 CellID->24187],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["With",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/With"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           StyleBox["x", "TI"], "=", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["0", "TR"]]}], ",", 
          RowBox[{
           StyleBox["y", "TI"], "=", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["0", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " occurrences of the symbols ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", \[Ellipsis]",
     " ",
     " should be replaced by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]",
     " ",
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16459]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " allows you to define local constants. "
}], "Notes",
 CellID->8294],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " replaces symbols in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " only when they do not occur as local variables inside scoping constructs. \
"
}], "Notes",
 CellID->17382],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["With",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/With"], "[", 
   RowBox[{
    RowBox[{"{", 
     StyleBox["vars", "TI"], "}"}], ",", 
    RowBox[{
     StyleBox["body", "TI"], "/;", 
     StyleBox["cond", "TI"]}]}], "]"}]], "InlineFormula"],
 " as the right\[Hyphen]hand side of a transformation rule with a condition \
attached. "
}], "Notes",
 CellID->20643],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15522],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " constructs can be nested in any way, with inner variables being renamed if \
necessary. "
}], "Notes",
 CellID->6700],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " is a scoping construct that implements read\[Hyphen]only lexical \
variables. "
}], "Notes",
 CellID->21610]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->109786186],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->101965347],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "=", 
      RowBox[{"x", "+", "1"}]}], "}"}], ",", 
    RowBox[{"1", "+", "y", "+", 
     RowBox[{"y", "^", "2"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45856640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167590394],

Cell[BoxData[
 RowBox[{"2", "+", "a", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "a"}], ")"}], "2"]}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->649559114]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15564],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " to insert values into held expressions:"
}], "ExampleText",
 CellID->27653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "y"}], "}"}], ",", 
   RowBox[{"Hold", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15692],

Cell[BoxData[
 RowBox[{"Hold", "[", "y", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12436]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", "=", "j"}], "}"}], ",", 
     RowBox[{"Hold", "[", "i", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hold", "[", "1", "]"}], ",", 
   RowBox[{"Hold", "[", "2", "]"}], ",", 
   RowBox[{"Hold", "[", "3", "]"}], ",", 
   RowBox[{"Hold", "[", "4", "]"}], ",", 
   RowBox[{"Hold", "[", "5", "]"}]}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67918657],

Cell["The variable names can be the same:", "ExampleText",
 CellID->17980],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "x"}], "}"}], ",", 
   RowBox[{"Hold", "[", "x", "]"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->14589],

Cell[BoxData[
 RowBox[{"Hold", "[", "5", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->487151346]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->401862514],

Cell["Use a constant for a value that is needed more than once:", \
"ExampleText",
 CellID->61235739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "=", 
     RowBox[{"Sin", "[", "1.0", "]"}]}], "}"}], ",", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"y", "^", "i"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71951114],

Cell[BoxData["5.3632327754613005`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236887165]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29841],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " allows inserting values into unevaluated expressions:"
}], "ExampleText",
 CellID->12121490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"v", "=", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ",", 
     RowBox[{"w", "=", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], "}"}], ",", 
   RowBox[{"Thread", "[", 
    RowBox[{"Unevaluated", "[", 
     RowBox[{"Dot", "[", 
      RowBox[{"v", ",", "w"}], "]"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->214294321],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", ".", "x"}], ",", 
   RowBox[{"b", ".", "y"}], ",", 
   RowBox[{"c", ".", "z"}]}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157391980]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"Dot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->55574271],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "x"}], "+", 
  RowBox[{"b", " ", "y"}], "+", 
  RowBox[{"c", " ", "z"}]}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->477593730]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11107],

Cell["Module introduces local variables that can be assigned to:", \
"ExampleText",
 CellID->612209666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "2.0"}], "}"}], ",", 
   RowBox[{
    RowBox[{"While", "[", 
     RowBox[{
      RowBox[{"x", ">", "0"}], ",", 
      RowBox[{"x", "=", 
       RowBox[{"Log", "[", "x", "]"}]}]}], "]"}], ";", "x"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->830060264],

Cell[BoxData[
 RowBox[{"-", "0.36651292058166435`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->425935487]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25993449],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " is faster than ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->262584003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", "=", "5"}], "}"}], ",", 
      RowBox[{"x", ";"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", "^", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28825695],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.31199999999999994`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->448275794]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", "=", "5"}], "}"}], ",", 
      RowBox[{"x", ";"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", "^", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->261207485],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.09300000000000003`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->625593919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->353673619],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " localizes values only; it does not substitute values. ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " creates new symbols:"
}], "ExampleText",
 CellID->777208462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", "=", "5"}], "}"}], ",", 
     RowBox[{"Hold", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", "=", "5"}], "}"}], ",", 
     RowBox[{"Hold", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", "=", "5"}], "}"}], ",", 
     RowBox[{"Hold", "[", "x", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1575193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hold", "[", "x", "]"}], ",", 
   RowBox[{"Hold", "[", "5", "]"}], ",", 
   RowBox[{"Hold", "[", "x$100433", "]"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->485852485]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23276199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "5", ",", "5"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->161251887]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->214705512],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " allows substitution inside an unevaluated expression, preserving nested \
scopes:"
}], "ExampleText",
 CellID->447895390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", "=", "x"}], "}"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", "e"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118880327],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x$", ",", "x"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->614231352]
}, Open  ]],

Cell["Ordinary substitution does not preserve scoping:", "ExampleText",
 CellID->372061446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"x", ",", "e"}], "]"}], "/.", 
  RowBox[{"e", "\[RuleDelayed]", "x"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->309109793],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", "x"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44989699]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14143],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " is a scoping construct; variables are renamed in nested scopes:"
}], "ExampleText",
 CellID->280628775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", "=", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], "^", "5"}], "]"}]}], "}"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", "e"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34425433],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x$", ",", 
   RowBox[{"1", "+", 
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    SuperscriptBox["x", "5"]}]}], "]"}]], "Output",
 ImageSize->{281, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207038078]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "10", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->300888483],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"5", " ", "x"}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  SuperscriptBox["x", "5"]}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->226501075]
}, Open  ]],

Cell["Build the function from its elements to avoid the renaming:", \
"ExampleText",
 CellID->257040373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", "=", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], "^", "5"}], "]"}]}], "}"}], ",", 
   RowBox[{"Function", "@@", 
    RowBox[{"{", 
     RowBox[{"x", ",", "e"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->174526574],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   RowBox[{"1", "+", 
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    SuperscriptBox["x", "5"]}]}], "]"}]], "Output",
 ImageSize->{274, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->156125997]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "10", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3968270],

Cell[BoxData["161051"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->505561996]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30121],

Cell["Find a zero of an arbitrary function using Newton's method:", \
"ExampleText",
 CellID->76251522],

Cell[BoxData[
 RowBox[{
  RowBox[{"newton", "[", 
   RowBox[{"f_", ",", "x0_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"fp", "=", 
      RowBox[{"f", "'"}]}], "}"}], ",", 
    RowBox[{"FixedPoint", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "-", 
        RowBox[{
         RowBox[{"f", "[", "#", "]"}], "/", 
         RowBox[{"fp", "[", "#", "]"}]}]}], "&"}], ",", "x0"}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193327115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newton", "[", 
  RowBox[{"Cos", ",", "1`20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->436384],

Cell[BoxData["1.57079632679489661920219437107881788052`18.60846551217816"], \
"Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156557411]
}, Open  ]],

Cell["Find a fixed point:", "ExampleText",
 CellID->142423595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newton", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "#", "]"}], "-", "#"}], "&"}], ",", "1`20"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26110190],

Cell[BoxData["0.73908513321516064161018771949684946776`18.34685995973834"], \
"Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->204780586]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95115269],

Cell[TextData[{
 "A version of ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " where the initializer is within the scope of the local variable:"
}], "ExampleText",
 CellID->14724354],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"letrec", ",", "HoldAll"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"letrec", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"var_", "=", "val_"}], "}"}], ",", "body_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "var", "}"}], ",", 
    RowBox[{
     RowBox[{"var", "=", "val"}], ";", "body"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->48239083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"letrec", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"n", ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"n", "\[Equal]", "0"}], ",", "1", ",", 
         RowBox[{"n", "*", 
          RowBox[{"f", "[", 
           RowBox[{"n", "-", "1"}], "]"}]}]}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"f", "[", "10", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->247899803],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->69586127]
}, Open  ]],

Cell[TextData[{
 "Here the ",
 StyleBox["f", "InlineCode"],
 " inside the function definition is not inside its own scope:"
}], "ExampleText",
 CellID->102952897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"n", ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"n", "\[Equal]", "0"}], ",", "1", ",", 
         RowBox[{"n", "*", 
          RowBox[{"f", "[", 
           RowBox[{"n", "-", "1"}], "]"}]}]}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"f", "[", "10", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->875072800],

Cell[BoxData[
 RowBox[{"10", " ", 
  RowBox[{"f", "[", "9", "]"}]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->115137715]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10074],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceAll"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22836]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18129],

Cell[TextData[ButtonBox["Local Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LocalConstants"]], "Tutorials",
 CellID->32554],

Cell[TextData[ButtonBox["Some General Notations and Conventions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SomeGeneralNotationsAndConventions"]], "Tutorials",
 CellID->314307143],

Cell[TextData[ButtonBox["Variables in Pure Functions and Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VariablesInPureFunctionsAndRules"]], "Tutorials",\

 CellID->135909037]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->209631462],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->350070051],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->214660595],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->92775736],

Cell[TextData[ButtonBox["Scoping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScopingConstructs"]], "MoreAbout",
 CellID->226233812]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"With - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 53.1654584}", "context" -> "System`", 
    "keywords" -> {
     "code", "constants", "fixed variables", "local constants", "macros", 
      "programs", "replacements", "substitution", "write-once variables", 
      "single static assignment", "lexical scoping", "lexical scope", 
      "local scoping", "letrec"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "With[{x = x_0, y = y_0, ...}, expr] specifies that in expr occurrences \
of the symbols x, y, ... should be replaced by x_0, y_0, ... . ", 
    "synonyms" -> {"let"}, "title" -> "With", "type" -> "Symbol", "uri" -> 
    "ref/With"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7223, 244, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->109786186]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30990, 1205}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2761, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3384, 90, 42, 1, 70, "ObjectName",
 CellID->24187],
Cell[3429, 93, 1482, 52, 70, "Usage",
 CellID->16459]
}, Open  ]],
Cell[CellGroupData[{
Cell[4948, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5426, 167, 197, 7, 70, "Notes",
 CellID->8294],
Cell[5626, 176, 322, 11, 70, "Notes",
 CellID->17382],
Cell[5951, 189, 443, 16, 70, "Notes",
 CellID->20643],
Cell[6397, 207, 298, 12, 70, "Notes",
 CellID->15522],
Cell[6698, 221, 247, 8, 70, "Notes",
 CellID->6700],
Cell[6948, 231, 238, 8, 70, "Notes",
 CellID->21610]
}, Closed]],
Cell[CellGroupData[{
Cell[7223, 244, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->109786186],
Cell[CellGroupData[{
Cell[7608, 258, 148, 5, 70, "ExampleSection",
 CellID->101965347],
Cell[7759, 265, 315, 11, 70, "Input",
 CellID->45856640],
Cell[CellGroupData[{
Cell[8099, 280, 97, 3, 28, "Input",
 CellID->167590394],
Cell[8199, 285, 263, 9, 36, "Output",
 CellID->649559114]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8511, 300, 216, 7, 70, "ExampleSection",
 CellID->15564],
Cell[8730, 309, 214, 8, 70, "ExampleText",
 CellID->27653],
Cell[CellGroupData[{
Cell[8969, 321, 200, 7, 70, "Input",
 CellID->15692],
Cell[9172, 330, 184, 6, 36, "Output",
 CellID->12436]
}, Open  ]],
Cell[CellGroupData[{
Cell[9393, 341, 313, 11, 70, "Input",
 CellID->21903],
Cell[9709, 354, 389, 12, 36, "Output",
 CellID->3482]
}, Open  ]],
Cell[10113, 369, 124, 3, 70, "ExampleDelimiter",
 CellID->67918657],
Cell[10240, 374, 74, 1, 70, "ExampleText",
 CellID->17980],
Cell[CellGroupData[{
Cell[10339, 379, 270, 9, 70, "Input",
 CellID->14589],
Cell[10612, 390, 188, 6, 36, "Output",
 CellID->487151346]
}, Open  ]],
Cell[10815, 399, 125, 3, 70, "ExampleDelimiter",
 CellID->401862514],
Cell[10943, 404, 101, 2, 70, "ExampleText",
 CellID->61235739],
Cell[CellGroupData[{
Cell[11069, 410, 352, 12, 70, "Input",
 CellID->71951114],
Cell[11424, 424, 176, 5, 36, "Output",
 CellID->236887165]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11649, 435, 223, 7, 70, "ExampleSection",
 CellID->29841],
Cell[11875, 444, 222, 7, 70, "ExampleText",
 CellID->12121490],
Cell[CellGroupData[{
Cell[12122, 455, 488, 16, 70, "Input",
 CellID->214294321],
Cell[12613, 473, 286, 10, 36, "Output",
 CellID->157391980]
}, Open  ]],
Cell[CellGroupData[{
Cell[12936, 488, 277, 9, 70, "Input",
 CellID->55574271],
Cell[13216, 499, 259, 9, 36, "Output",
 CellID->477593730]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13524, 514, 233, 7, 70, "ExampleSection",
 CellID->11107],
Cell[13760, 523, 103, 2, 70, "ExampleText",
 CellID->612209666],
Cell[CellGroupData[{
Cell[13888, 529, 352, 13, 70, "Input",
 CellID->830060264],
Cell[14243, 544, 194, 6, 36, "Output",
 CellID->425935487]
}, Open  ]],
Cell[14452, 553, 124, 3, 70, "ExampleDelimiter",
 CellID->25993449],
Cell[14579, 558, 306, 12, 70, "ExampleText",
 CellID->262584003],
Cell[CellGroupData[{
Cell[14910, 574, 344, 12, 70, "Input",
 CellID->28825695],
Cell[15257, 588, 225, 7, 36, "Output",
 CellID->448275794]
}, Open  ]],
Cell[CellGroupData[{
Cell[15519, 600, 343, 12, 70, "Input",
 CellID->261207485],
Cell[15865, 614, 225, 7, 36, "Output",
 CellID->625593919]
}, Open  ]],
Cell[16105, 624, 125, 3, 70, "ExampleDelimiter",
 CellID->353673619],
Cell[16233, 629, 367, 12, 70, "ExampleText",
 CellID->777208462],
Cell[CellGroupData[{
Cell[16625, 645, 558, 19, 70, "Input",
 CellID->1575193],
Cell[17186, 666, 317, 10, 36, "Output",
 CellID->485852485]
}, Open  ]],
Cell[CellGroupData[{
Cell[17540, 681, 106, 3, 70, "Input",
 CellID->23276199],
Cell[17649, 686, 213, 7, 36, "Output",
 CellID->161251887]
}, Open  ]],
Cell[17877, 696, 125, 3, 70, "ExampleDelimiter",
 CellID->214705512],
Cell[18005, 701, 251, 8, 70, "ExampleText",
 CellID->447895390],
Cell[CellGroupData[{
Cell[18281, 713, 233, 8, 70, "Input",
 CellID->118880327],
Cell[18517, 723, 217, 7, 36, "Output",
 CellID->614231352]
}, Open  ]],
Cell[18749, 733, 91, 1, 70, "ExampleText",
 CellID->372061446],
Cell[CellGroupData[{
Cell[18865, 738, 188, 6, 70, "Input",
 CellID->309109793],
Cell[19056, 746, 215, 7, 36, "Output",
 CellID->44989699]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19320, 759, 226, 7, 70, "ExampleSection",
 CellID->14143],
Cell[19549, 768, 233, 7, 70, "ExampleText",
 CellID->280628775],
Cell[CellGroupData[{
Cell[19807, 779, 352, 12, 70, "Input",
 CellID->34425433],
Cell[20162, 793, 490, 16, 39, "Output",
 CellID->207038078]
}, Open  ]],
Cell[CellGroupData[{
Cell[20689, 814, 98, 3, 70, "Input",
 CellID->300888483],
Cell[20790, 819, 414, 14, 36, "Output",
 CellID->226501075]
}, Open  ]],
Cell[21219, 836, 104, 2, 70, "ExampleText",
 CellID->257040373],
Cell[CellGroupData[{
Cell[21348, 842, 375, 13, 70, "Input",
 CellID->174526574],
Cell[21726, 857, 489, 16, 39, "Output",
 CellID->156125997]
}, Open  ]],
Cell[CellGroupData[{
Cell[22252, 878, 96, 3, 70, "Input",
 CellID->3968270],
Cell[22351, 883, 163, 5, 36, "Output",
 CellID->505561996]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22563, 894, 224, 7, 70, "ExampleSection",
 CellID->30121],
Cell[22790, 903, 103, 2, 70, "ExampleText",
 CellID->76251522],
Cell[22896, 907, 525, 18, 70, "Input",
 CellID->193327115],
Cell[CellGroupData[{
Cell[23446, 929, 127, 4, 70, "Input",
 CellID->436384],
Cell[23576, 935, 218, 6, 36, "Output",
 CellID->156557411]
}, Open  ]],
Cell[23809, 944, 62, 1, 70, "ExampleText",
 CellID->142423595],
Cell[CellGroupData[{
Cell[23896, 949, 207, 8, 70, "Input",
 CellID->26110190],
Cell[24106, 959, 218, 6, 36, "Output",
 CellID->204780586]
}, Open  ]],
Cell[24339, 968, 124, 3, 70, "ExampleDelimiter",
 CellID->95115269],
Cell[24466, 973, 251, 8, 70, "ExampleText",
 CellID->14724354],
Cell[24720, 983, 457, 15, 70, "Input",
 CellID->48239083],
Cell[CellGroupData[{
Cell[25202, 1002, 477, 15, 70, "Input",
 CellID->247899803],
Cell[25682, 1019, 163, 5, 36, "Output",
 CellID->69586127]
}, Open  ]],
Cell[25860, 1027, 162, 5, 70, "ExampleText",
 CellID->102952897],
Cell[CellGroupData[{
Cell[26047, 1036, 475, 15, 70, "Input",
 CellID->875072800],
Cell[26525, 1053, 209, 7, 36, "Output",
 CellID->115137715]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26795, 1067, 311, 9, 70, "SeeAlsoSection",
 CellID->10074],
Cell[27109, 1078, 690, 26, 70, "SeeAlso",
 CellID->22836]
}, Open  ]],
Cell[CellGroupData[{
Cell[27836, 1109, 314, 9, 70, "TutorialsSection",
 CellID->18129],
Cell[28153, 1120, 140, 3, 70, "Tutorials",
 CellID->32554],
Cell[28296, 1125, 190, 4, 70, "Tutorials",
 CellID->314307143],
Cell[28489, 1131, 186, 4, 70, "Tutorials",
 CellID->135909037]
}, Open  ]],
Cell[CellGroupData[{
Cell[28712, 1140, 319, 9, 70, "MoreAboutSection",
 CellID->209631462],
Cell[29034, 1151, 147, 3, 70, "MoreAbout",
 CellID->350070051],
Cell[29184, 1156, 145, 3, 70, "MoreAbout",
 CellID->214660595],
Cell[29332, 1161, 154, 3, 70, "MoreAbout",
 CellID->92775736],
Cell[29489, 1166, 147, 3, 70, "MoreAbout",
 CellID->226233812]
}, Open  ]],
Cell[29651, 1172, 27, 0, 70, "History"],
Cell[29681, 1174, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

