(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10762,        374]
NotebookOptionsPosition[      8075,        284]
NotebookOutlinePosition[      9312,        320]
CellTagsIndexPosition[      9228,        315]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Patterns\"\>", 
       2->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Whitespace" :> 
          Documentation`HelpLookup["paclet:ref/Whitespace"], 
          "WhitespaceCharacter" :> 
          Documentation`HelpLookup["paclet:ref/WhitespaceCharacter"], 
          "Except" :> Documentation`HelpLookup["paclet:ref/Except"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Whitespace\"\>", 
       2->"\<\"WhitespaceCharacter\"\>", 3->"\<\"Except\"\>", 
       4->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WordBoundary", "ObjectName",
 CellID->15846],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WordBoundary",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WordBoundary"]], "InlineFormula"],
     " \[LineSeparator]represents a boundary between words for purposes of \
matching in ",
     Cell[BoxData[
      ButtonBox["StringExpression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30114]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->25512722],

Cell["Capitalize all words in a sentence:", "ExampleText",
 CellID->840329560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<this is a test\>\"", ",", 
   RowBox[{
    RowBox[{"WordBoundary", "~~", "x_"}], "\[RuleDelayed]", 
    RowBox[{"ToUpperCase", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1566452248],

Cell[BoxData["\<\"This Is A Test\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17788593]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->634397583],

Cell["Extract numbers in a string:", "ExampleText",
 CellID->1705423598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a 13 bbbc 41 ccc\>\"", ",", " ", 
   RowBox[{
    RowBox[{"WordBoundary", "~~", 
     RowBox[{"x", ":", 
      RowBox[{"DigitCharacter", ".."}]}], " ", "~~", "WordBoundary"}], 
    "\[RuleDelayed]", "x"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1584375629],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"13\"\>", ",", "\<\"41\"\>"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4668389]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20394],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Whitespace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Whitespace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WhitespaceCharacter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WhitespaceCharacter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29909]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18414],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->376172752],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->40419577]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WordBoundary - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 53.5717188}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WordBoundary represents a boundary between words for purposes of \
matching in StringExpression.", "synonyms" -> {"word boundary"}, "title" -> 
    "WordBoundary", "type" -> "Symbol", "uri" -> "ref/WordBoundary"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3604, 109, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9093, 308}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2272, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2895, 82, 50, 1, 70, "ObjectName",
 CellID->15846],
Cell[2948, 85, 619, 19, 70, "Usage",
 CellID->30114]
}, Open  ]],
Cell[CellGroupData[{
Cell[3604, 109, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3981, 123, 147, 5, 70, "ExampleSection",
 CellID->25512722],
Cell[4131, 130, 78, 1, 70, "ExampleText",
 CellID->840329560],
Cell[CellGroupData[{
Cell[4234, 135, 269, 7, 28, "Input",
 CellID->1566452248],
Cell[4506, 144, 179, 5, 36, "Output",
 CellID->17788593]
}, Open  ]],
Cell[4700, 152, 125, 3, 70, "ExampleDelimiter",
 CellID->634397583],
Cell[4828, 157, 72, 1, 70, "ExampleText",
 CellID->1705423598],
Cell[CellGroupData[{
Cell[4925, 162, 327, 9, 47, "Input",
 CellID->1584375629],
Cell[5255, 173, 219, 7, 36, "Output",
 CellID->4668389]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5535, 187, 311, 9, 70, "SeeAlsoSection",
 CellID->20394],
Cell[5849, 198, 979, 35, 70, "SeeAlso",
 CellID->29909]
}, Open  ]],
Cell[CellGroupData[{
Cell[6865, 238, 314, 9, 70, "TutorialsSection",
 CellID->18414],
Cell[7182, 249, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[7324, 254, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[7539, 263, 319, 9, 70, "MoreAboutSection",
 CellID->376172752],
Cell[7861, 274, 140, 3, 70, "MoreAbout",
 CellID->40419577]
}, Open  ]],
Cell[8016, 280, 29, 0, 70, "History"],
Cell[8048, 282, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

