(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    483193,      11500]
NotebookOptionsPosition[    455685,      10581]
NotebookOutlinePosition[    458738,      10643]
CellTagsIndexPosition[    458650,      10638]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Internet Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InternetConnectivity"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematica Internet Connectivity\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DictionaryLookup" :> 
          Documentation`HelpLookup["paclet:ref/DictionaryLookup"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"DictionaryLookup\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integrated Data Sources" :> 
          Documentation`HelpLookup["paclet:guide/DataCollections"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Integrated Data Sources\"\>", 
       2->"\<\"New in 6.0: Data Handling & Data Sources\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["WordData", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["WordData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WordData"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"word\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the specified property for the English word ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"word\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["WordData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WordData"], "[", "\"\<\!\(\*
StyleBox[\"word\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of full word specifications representing \
possible uses and senses of ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"word\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["WordData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WordData"], "[", 
       RowBox[{
        StyleBox["wordspec", "TI"], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a property for a particular word specification."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A particular use or sense of a word can be represented by a word \
specification of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"word\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"part\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"sense\", \"TI\"]\)\>\""}], "}"}]], "InlineFormula"],
 " where ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"part\", \"TI\"]\)\>\""], "InlineFormula"],
 " is a part of speech, and ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"sense\", \"TI\"]\)\>\""], "InlineFormula"],
 " is a sense tag."
}], "Notes",
 CellID->241374237],

Cell[TextData[{
 "Words that occur only in one sense can be specified just by ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"word\", \"TI\"]\)\>\""], "InlineFormula"],
 ".",
 " ",
 "Words that occur only in one sense as a given part of speech can be \
specified by ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"word\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"part\", \"TI\"]\)\>\""}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->883755962],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["WordData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordData"]], "InlineFormula"],
 ", ordinary words are capitalized as they would be within a sentence (such \
as ",
 Cell[BoxData["\"\<word\>\""], "InlineFormula"],
 " or ",
 Cell[BoxData["\"\<America\>\""], "InlineFormula"],
 ")."
}], "Notes",
 CellID->343754239],

Cell[TextData[{
 "Some multiword phrases (such as ",
 Cell[BoxData["\"\<a priori\>\""], "InlineFormula"],
 ") can be used, and are treated like single words."
}], "Notes",
 CellID->44245654],

Cell[TextData[{
 "Parts of speech include ",
 Cell[BoxData["\"\<Noun\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Verb\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Adjective\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Adverb\>\""], "InlineFormula"],
 ", as well as ",
 Cell[BoxData["\"\<Preposition\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Article\>\""], "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->376181716],

Cell[TextData[{
 "Sense tags are capitalized like ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " names."
}], "Notes",
 CellID->250883811],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordData"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives a list of all words and phrases available in ",
 Cell[BoxData[
  ButtonBox["WordData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordData"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->398173972],

Cell[TextData[{
 "For properties that depend on the use or sense of a word, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordData"], "[", 
   RowBox[{
    StyleBox["wordspec", "TI"], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives a list of rules for each use and sense of a word consistent with ",
 Cell[BoxData[
  StyleBox["wordspec", "TI"]], "InlineFormula"],
 ".",
 " "
}], "Notes",
 CellID->81793370],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordData"], "[", 
   RowBox[{
    StyleBox["wordspec", "TI"], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"form\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " yields results in the following forms:"
}], "Notes",
 CellID->243664958],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<List\>\"", Cell[
    "a single list of results for all word specifications", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "a list of word specifications for each word specification", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ShortRules\>\"", Cell[
    "a list of word results for each word specification ", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->302202177],

Cell["Basic grammatical properties of words include: ", "Notes",
 CellID->332621726],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<PartsOfSpeech\>\"", Cell[
    "possible parts of speech for a word", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->19778572],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordData"], "[", 
   RowBox[{
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], ",", "\"\<\!\(\*
StyleBox[\"part\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives all words of a given part of speech. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordData"], "[", 
   RowBox[{
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], ",", "\"\<Stopwords\>\""}], "]"}]], 
  "InlineFormula"],
 " gives a list of words typically ignored in text comparisons.",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordData"], "[", 
   RowBox[{
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], ",", "\"\<PartsOfSpeech\>\""}], "]"}]], 
  "InlineFormula"],
 " gives a list of parts of speech."
}], "Notes",
 CellID->305083431],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordData"], "[", 
   RowBox[{
    StyleBox["patt", "TI"], ",", "\"\<Lookup\>\""}], "]"}]], 
  "InlineFormula"],
 " gives a list of all available words matching the string pattern ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->76948272],

Cell["Basic meaning-related properties of words include:", "Notes",
 CellID->848570680],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Antonyms\>\"", Cell[
    "words with an opposite meaning (e.g. \"large\" from \"small\")", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BroaderTerms\>\"", Cell[
    "generalizations of a word (e.g. \"shape\" from \"circle\")", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Definitions\>\"", Cell[
    "definitions for a word", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Examples\>\"", Cell[
    "examples of the word in use", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NarrowerTerms\>\"", Cell[
    "specializations of a word (e.g. \"circle\" from \"shape\")", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Synonyms\>\"", Cell[
    "words with the same meaning (e.g. \"large\" from \"big\")", 
     "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->109859610],

Cell["\<\
Properties describing usage characteristics for words include:\
\>", "Notes",
 CellID->311647375],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ConceptWeight\>\"", Cell[
    "rough estimate of semantic importance", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<GeographicDomain\>\"", Cell[TextData[{
     "geographic region to which the word relates (e.g. ",
     Cell[BoxData["\"\<India\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<UsageField\>\"", Cell[TextData[{
     "field or category in which the word is used (e.g. ",
     Cell[BoxData["\"\<Law\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UsageType\>\"", Cell[TextData[{
     "type of word usage (e.g. ",
     Cell[BoxData["\"\<Slang\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<Archaism\>\""], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->147057298],

Cell["Lexical properties of words include:", "Notes",
 CellID->126617740],

Cell[BoxData[GridBox[{
   {Cell[" ", "TableRowIcon"], "\"\<Hyphenation\>\"", Cell[
    "hyphenation blocks in a word", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PhoneticForm\>\"", Cell[
    "IPA phonetic representation", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->69550753],

Cell["Morphological properties for words include:", "Notes",
 CellID->1296392266],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BaseForm\>\"", Cell[
    "base uninflected form of a word (e.g. \"large\" from \"larger\")", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InflectedForms\>\"", Cell[
    "inflected forms of a word (e.g. \"went\" from \"go\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MorphologicalDerivatives\>\"", Cell[
    "words that are morphologically derived from a word", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MorphologicalSource\>\"", Cell[
    "word from which a word is morphologically derived", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PorterStem\>\"", Cell[
    "Porter-stemmed form of word", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->95732200],

Cell["Special properties for nouns include:", "Notes",
 CellID->149970660],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DerivedAdjectives\>\"", Cell[
    "derived adjectives (e.g. \"American\" from \"America\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PartTerms\>\"", Cell[
    "terms for parts (e.g. \"finger\" from \"hand\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WholeTerms\>\"", Cell[
    "terms for wholes (e.g. \"hand\" from \"finger\")", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->4152491],

Cell["Special properties for verbs include:", "Notes",
 CellID->465231541],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CausesTerms\>\"", Cell[
    "verbs for causes (e.g. \"kill\" from \"die\") ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ConsequencesTerms\>\"", Cell[
    "verbs for consequences (e.g. \"die\" from \"kill\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EntailedTerms\>\"", Cell[
    "verbs for entailed actions (e.g. \"step\" from \"walk\") ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SentenceFrames\>\"", Cell[
    "ways that the verb can appear in phrases", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PhrasalVerbs\>\"", Cell[
    "phrasal forms for verbs (e.g. \"move on\" from \"move\")", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->118151164],

Cell["Special properties for adjectives include:", "Notes",
 CellID->45732549],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BaseNoun\>\"", Cell[
    "noun derived from (e.g. \"America\" from \"American\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DerivedAdverb\>\"", Cell[
    "derived adverb (e.g. \"quickly\" from \"quick\")", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->68931504],

Cell["Special properties for adverbs include:", "Notes",
 CellID->104078661],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BaseAdjective\>\"", Cell["\<\
adjective the adverb is derived from (e.g. \"quick\" for \"quickly\")\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->744250446],

Cell["Word labeling properties include:", "Notes",
 CellID->25807126],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<WordNetID\>\"", Cell[
    "WordNet synset IDs for a word", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->52495961],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordData"], "[", 
   RowBox[{
    StyleBox["wordspec", "TI"], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"ann\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives various annotations associated with a property. Typical annotations \
include:"
}], "Notes",
 CellID->271849171],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Description\>\"", Cell[
    "a textual description of the property", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Note\>\"", Cell[
    "special note about the property given", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->469751789],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordData"], "[", 
   RowBox[{
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], ",", "\"\<Properties\>\""}], "]"}]], 
  "InlineFormula"],
 " gives all properties supported by ",
 Cell[BoxData[
  ButtonBox["WordData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordData"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->83363415],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["WordData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordData"]], "InlineFormula"],
 " may require internet connectivity."
}], "Notes",
 CellID->94188222]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->602984239],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount"]
}], "ExampleSection",
 CellID->793912571],

Cell["The several senses of the word \"fish\":", "ExampleText",
 CellID->227427165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", "\"\<fish\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->231146461],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", 
     ",", "\<\"AquaticVertebrate\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Food\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Grab\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Search\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{416, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1351945338]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->689363353],

Cell["Parts of speech:", "ExampleText",
 CellID->156939200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<fish\>\"", ",", "\"\<PartsOfSpeech\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->353693390],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Noun\"\>", ",", "\<\"Verb\"\>"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1768310506]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23357404],

Cell["Definitions:", "ExampleText",
 CellID->175295229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<fish\>\"", ",", "\"\<Definitions\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->332739535],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", 
      ",", "\<\"AquaticVertebrate\"\>"}], "}"}], 
    "\[Rule]", "\<\"any of various mostly cold-blooded aquatic vertebrates \
usually having scales and breathing through gills\"\>"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Food\"\>"}], 
     "}"}], "\[Rule]", "\<\"the flesh of fish used as food\"\>"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Grab\"\>"}], 
     "}"}], "\[Rule]", "\<\"catch or try to catch fish or shellfish\"\>"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Search\"\>"}], 
     "}"}], "\[Rule]", "\<\"seek indirectly\"\>"}]}], "}"}]], "Output",
 ImageSize->{428, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1346455575]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->529209393],

Cell["Synonyms:", "ExampleText",
 CellID->169022019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<fish\>\"", ",", "\"\<Synonyms\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->621585352],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", 
      ",", "\<\"AquaticVertebrate\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Food\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Grab\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Search\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", "\<\"angle\"\>", "}"}]}]}], "}"}]], "Output",
 ImageSize->{421, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1843660586]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->645541958],

Cell["Broader terms:", "ExampleText",
 CellID->130645779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<fish\>\"", ",", "\"\<BroaderTerms\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->410216586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", 
      ",", "\<\"AquaticVertebrate\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", "\<\"aquatic vertebrate\"\>", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Food\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"food\"\>", ",", "\<\"solid food\"\>"}], "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Grab\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"catch\"\>", ",", "\<\"grab\"\>", 
      ",", "\<\"take hold of\"\>"}], "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Search\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"look for\"\>", ",", "\<\"search\"\>", ",", "\<\"seek\"\>"}],
      "}"}]}]}], "}"}]], "Output",
 ImageSize->{386, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220790881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->628425659],

Cell["Inflected forms:", "ExampleText",
 CellID->273690426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<fish\>\"", ",", "\"\<InflectedForms\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52156434],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", 
      ",", "\<\"AquaticVertebrate\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", "\<\"fish\"\>", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Food\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", "\<\"fish\"\>", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Grab\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"fished\"\>", ",", "\<\"fishing\"\>", 
      ",", "\<\"fishes\"\>"}], "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Search\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"fished\"\>", ",", "\<\"fishing\"\>", 
      ",", "\<\"fishes\"\>"}], "}"}]}]}], "}"}]], "Output",
 ImageSize->{514, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1665868005]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(23)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Word Identification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->112956214],

Cell["Inflected forms are canonicalized:", "ExampleText",
 CellID->217083626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", "\"\<fishes\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->977589140],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Grab\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Search\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->845358822]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->295155159],

Cell["See all senses for \"fish\":", "ExampleText",
 CellID->381824890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", "\"\<fish\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19087200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", 
     ",", "\<\"AquaticVertebrate\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Food\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Grab\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Search\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{416, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193912802]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->467061439],

Cell["All senses for \"fish\" as a noun:", "ExampleText",
 CellID->150386046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<fish\>\"", ",", "\"\<Noun\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->579550009],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", 
     ",", "\<\"AquaticVertebrate\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Food\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1359770715]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6963866],

Cell["Narrower terms for \"fish\" as a food:", "ExampleText",
 CellID->446615292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<fish\>\"", ",", "\"\<Noun\>\"", ",", "\"\<Food\>\""}], "}"}],
    ",", "\"\<NarrowerTerms\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196602],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Food\"\>"}], "}"}],
    "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"\<\"alewife\"\>", ",", "\<\"anchovy\"\>", ",", "\<\"eel\"\>", 
     ",", "\<\"gray mullet\"\>", ",", "\<\"grey mullet\"\>", 
     ",", "\<\"haddock\"\>", ",", "\<\"hake\"\>", ",", "\<\"mullet\"\>", 
     ",", "\<\"panfish\"\>", ",", "\<\"rock salmon\"\>", 
     ",", "\<\"salmon\"\>", ",", "\<\"schrod\"\>", ",", "\<\"scrod\"\>", 
     ",", "\<\"shad\"\>", ",", "\<\"smelt\"\>", ",", "\<\"stockfish\"\>", 
     ",", "\<\"trout\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{535, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->739851261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71433135],

Cell["Look up words that begin with \"fishe\":", "ExampleText",
 CellID->750826949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{
   RowBox[{"\"\<fishe\>\"", "~~", "___"}], ",", "\"\<Lookup\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75357635],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"fisher\"\>", ",", "\<\"fisher cat\"\>", 
   ",", "\<\"fisherman\"\>", ",", "\<\"fisherman's bend\"\>", 
   ",", "\<\"fisherman's knot\"\>", ",", "\<\"fisherman's lure\"\>", 
   ",", "\<\"fishery\"\>", ",", "\<\"fisheye\"\>", 
   ",", "\<\"fisheye lens\"\>"}], "}"}]], "Output",
 ImageSize->{469, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1499254096]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Structure of Results",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->252741441],

Cell["Give senses of \"group\" together with synonyms:", "ExampleText",
 CellID->465474833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<group\>\"", ",", "\"\<Synonyms\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68272425],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"group\"\>", ",", "\<\"Noun\"\>", 
      ",", "\<\"Abstraction\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", "\<\"grouping\"\>", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"group\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Set\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", "\<\"mathematical group\"\>", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"group\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Unit\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"chemical group\"\>", ",", "\<\"radical\"\>"}], "}"}]}], ",",
    
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"group\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Classify\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"group\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Assemble\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", "\<\"aggroup\"\>", "}"}]}]}], "}"}]], "Output",
 ImageSize->{568, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1537961221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->661029803],

Cell["\<\
Give a list of synonyms, without specifying senses of \"group\":\
\>", "ExampleText",
 CellID->877392509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<group\>\"", ",", "\"\<Synonyms\>\"", ",", "\"\<List\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->354356773],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aggroup\"\>", ",", "\<\"chemical group\"\>", 
   ",", "\<\"grouping\"\>", ",", "\<\"mathematical group\"\>", 
   ",", "\<\"radical\"\>"}], "}"}]], "Output",
 ImageSize->{441, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1401066055]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->628340166],

Cell["Give the sense for each synonym:", "ExampleText",
 CellID->714497797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<group\>\"", ",", "\"\<Synonyms\>\"", ",", "\"\<Rules\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25899539],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"group\"\>", ",", "\<\"Noun\"\>", 
      ",", "\<\"Abstraction\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\<\"grouping\"\>", ",", "\<\"Noun\"\>", 
       ",", "\<\"Abstraction\"\>"}], "}"}], "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"group\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Set\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\<\"mathematical group\"\>", ",", "\<\"Noun\"\>", 
       ",", "\<\"Set\"\>"}], "}"}], "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"group\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Unit\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"chemical group\"\>", ",", "\<\"Noun\"\>", 
        ",", "\<\"Unit\"\>"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\<\"radical\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Unit\"\>"}], 
       "}"}]}], "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"group\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Classify\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"group\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Assemble\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\<\"aggroup\"\>", ",", "\<\"Verb\"\>", 
       ",", "\<\"Assemble\"\>"}], "}"}], "}"}]}]}], "}"}]], "Output",
 ImageSize->{570, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->558997030]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Meaning-Related Properties",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->537525481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<grateful\>\"", ",", "\"\<Definitions\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459442105],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"grateful\"\>", ",", "\<\"Adjective\"\>", 
      ",", "\<\"Thankful\"\>"}], "}"}], 
    "\[Rule]", "\<\"feeling or showing gratitude\"\>"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"grateful\"\>", ",", "\<\"Adjective\"\>", 
      ",", "\<\"Pleasant\"\>"}], "}"}], 
    "\[Rule]", "\<\"affording comfort or pleasure\"\>"}]}], "}"}]], "Output",
 ImageSize->{449, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1969611232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46338052],

Cell["Usage examples:", "ExampleText",
 CellID->316019794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<grateful\>\"", ",", "\"\<Examples\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136673703],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"grateful\"\>", ",", "\<\"Adjective\"\>", 
      ",", "\<\"Thankful\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", "\<\"a grateful heart\"\>", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"grateful\"\>", ",", "\<\"Adjective\"\>", 
      ",", "\<\"Pleasant\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", "\<\"the grateful warmth of the fire\"\>", "}"}]}]}], 
  "}"}]], "Output",
 ImageSize->{477, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1943041366]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->966160966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<grateful\>\"", ",", "\"\<Synonyms\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470208393],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"grateful\"\>", ",", "\<\"Adjective\"\>", 
      ",", "\<\"Thankful\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", "\<\"thankful\"\>", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"grateful\"\>", ",", "\<\"Adjective\"\>", 
      ",", "\<\"Pleasant\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "}"}]], "Output",
 ImageSize->{568, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2059902080]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->863234405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<grateful\>\"", ",", "\"\<Antonyms\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->544919711],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"grateful\"\>", ",", "\<\"Adjective\"\>", 
      ",", "\<\"Thankful\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", "\<\"ungrateful\"\>", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"grateful\"\>", ",", "\<\"Adjective\"\>", 
      ",", "\<\"Pleasant\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "}"}]], "Output",
 ImageSize->{330, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1822395662]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125218664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<galaxy\>\"", ",", "\"\<NarrowerTerms\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111183368],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"galaxy\"\>", ",", "\<\"Noun\"\>", 
      ",", "\<\"Aggregation\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"galaxy\"\>", ",", "\<\"Noun\"\>", 
      ",", "\<\"ExtragalacticNebula\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Great Attractor\"\>", ",", "\<\"Magellanic Cloud\"\>", 
      ",", "\<\"Milky Way\"\>", ",", "\<\"Milky Way Galaxy\"\>", 
      ",", "\<\"Milky Way System\"\>", ",", "\<\"spiral galaxy\"\>", 
      ",", "\<\"spiral nebula\"\>"}], "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"galaxy\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Herb\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "}"}]], "Output",
 ImageSize->{531, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1592117720]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75432370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<galaxy\>\"", ",", "\"\<BroaderTerms\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->814515032],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"galaxy\"\>", ",", "\<\"Noun\"\>", 
      ",", "\<\"Aggregation\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"accumulation\"\>", ",", "\<\"aggregation\"\>", 
      ",", "\<\"assemblage\"\>", ",", "\<\"collection\"\>"}], "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"galaxy\"\>", ",", "\<\"Noun\"\>", 
      ",", "\<\"ExtragalacticNebula\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"accumulation\"\>", ",", "\<\"aggregation\"\>", 
      ",", "\<\"assemblage\"\>", ",", "\<\"collection\"\>"}], "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"galaxy\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Herb\"\>"}], 
     "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"herb\"\>", ",", "\<\"herbaceous plant\"\>"}], "}"}]}]}], 
  "}"}]], "Output",
 ImageSize->{566, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1076278420]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Usage Characteristics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->390865844],

Cell[TextData[{
 "Rough ",
 StyleBox["a priori",
  FontSlant->"Italic"],
 " estimates of likelihoods of reaching different senses of \"fish\":"
}], "ExampleText",
 CellID->98520218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<fish\>\"", ",", "\"\<ConceptWeight\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340093129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", 
      ",", "\<\"AquaticVertebrate\"\>"}], "}"}], "\[Rule]", 
    "1.8239948751825625`"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Noun\"\>", ",", "\<\"Food\"\>"}], 
     "}"}], "\[Rule]", "0.726623739291956`"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Grab\"\>"}], 
     "}"}], "\[Rule]", "2.3219751461256593`"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"fish\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Search\"\>"}], 
     "}"}], "\[Rule]", "0.7917530647086467`"}]}], "}"}]], "Output",
 ImageSize->{498, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->685823727]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221307100],

Cell["Convert to and from British spelling:", "ExampleText",
 CellID->308081907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<color\>\"", ",", "\"\<BritishSpelling\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->412831473],

Cell[BoxData["\<\"colour\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->448466545]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"%", ",", "\"\<AmericanSpelling\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43709220],

Cell[BoxData["\<\"color\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->490524709]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Lexical & Morphological Properties",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->117310012],

Cell["Syllables of \"parallelogram\":", "ExampleText",
 CellID->261208603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<parallelogram\>\"", ",", "\"\<Hyphenation\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->676416153],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"par\"\>", ",", "\<\"al\"\>", ",", "\<\"lel\"\>", 
   ",", "\<\"o\"\>", ",", "\<\"gram\"\>"}], "}"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1693440997]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->615010760],

Cell["Phonetic form of parallel:", "ExampleText",
 CellID->721919778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<parallel\>\"", ",", "\"\<PhoneticForm\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10890902],

Cell[BoxData["\<\"p\:02c8\:025br\:0259l\:02cc\:025bl\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->336002371]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240531738],

Cell["Stem a word:", "ExampleText",
 CellID->512821730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<running\>\"", ",", "\"\<PorterStem\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206613040],

Cell[BoxData["\<\"run\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1457341434]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->381277181],

Cell["Inflected forms of \"be\":", "ExampleText",
 CellID->1404964286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<be\>\"", ",", "\"\<InflectedForms\>\"", ",", "\"\<List\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1289741796],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"am\"\>", ",", "\<\"are\"\>", ",", "\<\"been\"\>", 
   ",", "\<\"being\"\>", ",", "\<\"is\"\>", ",", "\<\"was\"\>", 
   ",", "\<\"were\"\>"}], "}"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1486487203]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Words Derived from Others",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->73280521],

Cell["Things that contain a tail:", "ExampleText",
 CellID->1821926092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<tail\>\"", ",", "\"\<WholeTerms\>\"", ",", "\"\<List\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142505671],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"body\"\>", ",", "\<\"coin\"\>", ",", "\<\"craniate\"\>", 
   ",", "\<\"fuselage\"\>", ",", "\<\"ship\"\>", ",", "\<\"torso\"\>", 
   ",", "\<\"trunk\"\>", ",", "\<\"vertebrate\"\>"}], "}"}]], "Output",
 ImageSize->{433, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2065039092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->811076316],

Cell["Parts of a tail:", "ExampleText",
 CellID->271077820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<tail\>\"", ",", "\"\<PartTerms\>\"", ",", "\"\<List\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->884169519],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"dock\"\>", ",", "\<\"escutcheon\"\>", 
   ",", "\<\"horizontal tail\"\>", ",", "\<\"skeg\"\>", 
   ",", "\<\"stabilizer\"\>", ",", "\<\"vertical tail\"\>"}], "}"}]], "Output",\

 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->979250100]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13126146],

Cell["Adjectives derived from a sense of the word \"tail\":", "ExampleText",
 CellID->465369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{
  "\"\<tail\>\"", ",", "\"\<DerivedAdjectives\>\"", ",", "\"\<List\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141898184],

Cell[BoxData[
 RowBox[{"{", "\<\"caudal\"\>", "}"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->687234511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8627192],

Cell["Terms for what water is made of:", "ExampleText",
 CellID->31463713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{
  "\"\<water\>\"", ",", "\"\<MaterialTerms\>\"", ",", "\"\<List\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92751508],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"atomic number 1\"\>", ",", "\<\"atomic number 8\"\>", 
   ",", "\<\"H\"\>", ",", "\<\"H2O\"\>", ",", "\<\"hydrogen\"\>", 
   ",", "\<\"O\"\>", ",", "\<\"oxygen\"\>", ",", "\<\"water\"\>"}], 
  "}"}]], "Output",
 ImageSize->{475, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231286365]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51701123],

Cell["Strict subset and superset terms:", "ExampleText",
 CellID->12784552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{
  "\"\<Reptilia\>\"", ",", "\"\<SubsetTerms\>\"", ",", "\"\<List\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399866883],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Anapsida\"\>", ",", "\<\"Archosauria\"\>", 
   ",", "\<\"Lepidosauria\"\>", ",", "\<\"reptile\"\>", 
   ",", "\<\"reptilian\"\>", ",", "\<\"subclass Anapsida\"\>", 
   ",", "\<\"subclass Archosauria\"\>", ",", "\<\"subclass Lepidosauria\"\>", 
   ",", "\<\"subclass Synapsida\"\>", ",", "\<\"Synapsida\"\>"}], 
  "}"}]], "Output",
 ImageSize->{528, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->741189069]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{
  "\"\<Reptilia\>\"", ",", "\"\<SupersetTerms\>\"", ",", "\"\<List\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37095554],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Craniata\"\>", ",", "\<\"subphylum Craniata\"\>", 
   ",", "\<\"subphylum Vertebrata\"\>", ",", "\<\"Vertebrata\"\>"}], 
  "}"}]], "Output",
 ImageSize->{444, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->621013002]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Classes of Words",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7947778],

Cell[TextData[{
 "Total number of words and phrases in ",
 Cell[BoxData[
  ButtonBox["WordData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->175571998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"WordData", "[", "All", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261017046],

Cell[BoxData["149191"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1484400126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56986158],

Cell["All supported parts of speech:", "ExampleText",
 CellID->7718816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"All", ",", "\"\<PartsOfSpeech\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->223737561],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Noun\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Adjective\"\>", 
   ",", "\<\"Adverb\"\>", ",", "\<\"Preposition\"\>", 
   ",", "\<\"Conjunction\"\>", ",", "\<\"Pronoun\"\>", 
   ",", "\<\"Determiner\"\>", ",", "\<\"Interjection\"\>"}], "}"}]], "Output",\

 ImageSize->{332, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->995390483]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->520710420],

Cell[TextData[{
 "Number of verbs in ",
 Cell[BoxData[
  ButtonBox["WordData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->157205259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"WordData", "[", 
   RowBox[{"All", ",", "\"\<Verb\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->703838843],

Cell[BoxData["11531"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->630237651]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35835138],

Cell[TextData[{
 "List of conjunctions in ",
 Cell[BoxData[
  ButtonBox["WordData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30822464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WordData", "[", 
   RowBox[{"All", ",", "\"\<Conjunction\>\""}], "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2053792804],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"afore\"\>", ",", "\<\"after\"\>", ",", "\<\"albeit\"\>", 
    ",", "\<\"although\"\>", ",", "\<\"an\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "84", "\[RightSkeleton]"}], 
    ",", "\<\"whithersoever\"\>", ",", "\<\"why\"\>", ",", "\<\"without\"\>", 
    ",", "\<\"yet\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{525, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->1014853353]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell["\<\
Porter stems can be found even for \"words\" that do not occur in English:\
\>", "ExampleText",
 CellID->976019072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<baaabanizing\>\"", ",", "\"\<PorterStem\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->551074242],

Cell[BoxData["\<\"baaabaniz\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->595000194]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(14)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["List the senses of a word:", "ExampleText",
 CellID->194427009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "[", 
  RowBox[{"Column", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Row", "[", 
      RowBox[{"#", ",", "\"\<:\>\""}], "]"}], "&"}], "/@", 
    RowBox[{"WordData", "[", "\"\<fish\>\"", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123070782],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   TagBox[GridBox[{
      {
       InterpretationBox[
        RowBox[{"\<\"fish\"\>", ":", "\<\"Noun\"\>", 
         ":", "\<\"AquaticVertebrate\"\>"}],
        Row[{"fish", "Noun", "AquaticVertebrate"}, ":"]]},
      {
       InterpretationBox[
        RowBox[{"\<\"fish\"\>", ":", "\<\"Noun\"\>", ":", "\<\"Food\"\>"}],
        Row[{"fish", "Noun", "Food"}, ":"]]},
      {
       InterpretationBox[
        RowBox[{"\<\"fish\"\>", ":", "\<\"Verb\"\>", ":", "\<\"Grab\"\>"}],
        Row[{"fish", "Verb", "Grab"}, ":"]]},
      {
       InterpretationBox[
        RowBox[{"\<\"fish\"\>", ":", "\<\"Verb\"\>", ":", "\<\"Search\"\>"}],
        Row[{"fish", "Verb", "Search"}, ":"]]}
     },
     ColumnsEqual->False,
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Column"]], "Text", "TR"],
  Text[
   Column[{
     Row[{"fish", "Noun", "AquaticVertebrate"}, ":"], 
     Row[{"fish", "Noun", "Food"}, ":"], 
     Row[{"fish", "Verb", "Grab"}, ":"], 
     Row[{"fish", "Verb", "Search"}, ":"]}]]]], "Output",
 ImageSize->{155, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1325179397]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90525123],

Cell["Find which parts of speech words in a sentence can be:", "ExampleText",
 CellID->41652639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"WordData", "[", 
    RowBox[{"#", ",", "\"\<PartsOfSpeech\>\""}], "]"}], "&"}], "/@", 
  RowBox[{
  "StringSplit", "[", "\"\<it rains on the plains\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->624687263],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"Pronoun\"\>", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Noun\"\>", ",", "\<\"Verb\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Adjective\"\>", ",", "\<\"Adverb\"\>", 
     ",", "\<\"Preposition\"\>"}], "}"}], ",", 
   RowBox[{"{", "\<\"Determiner\"\>", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Noun\"\>", ",", "\<\"Verb\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{424, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->737222342]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92542013],

Cell["Find entities that can have a part named a \"head\":", "ExampleText",
 CellID->203334483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<head\>\"", ",", "\"\<WholeTerms\>\"", ",", "\"\<List\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17944289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abscess\"\>", ",", "\<\"animal\"\>", 
   ",", "\<\"animate being\"\>", ",", "\<\"arrow\"\>", ",", "\<\"beast\"\>", 
   ",", "\<\"body\"\>", ",", "\<\"bolt\"\>", ",", "\<\"brute\"\>", 
   ",", "\<\"coin\"\>", ",", "\<\"creature\"\>", ",", "\<\"drum\"\>", 
   ",", "\<\"fauna\"\>", ",", "\<\"hammer\"\>", ",", "\<\"membranophone\"\>", 
   ",", "\<\"nail\"\>", ",", "\<\"organic structure\"\>", 
   ",", "\<\"physical structure\"\>", ",", "\<\"pin\"\>", 
   ",", "\<\"pointer\"\>", ",", "\<\"ram\"\>", ",", "\<\"screw\"\>", 
   ",", "\<\"skeletal muscle\"\>", ",", "\<\"striated muscle\"\>", 
   ",", "\<\"tympan\"\>"}], "}"}]], "Output",
 ImageSize->{585, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1662742451]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217327565],

Cell["\<\
Find which words can be reached by up 3 steps of synonym relation from \"fish\
\":\
\>", "ExampleText",
 CellID->318841992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"WordData", "[", 
         RowBox[{"#", ",", "\"\<Synonyms\>\"", ",", "\"\<List\>\""}], "]"}], 
        "&"}], "/@", "#"}], "]"}], "]"}], "&"}], ",", 
   RowBox[{"{", "\"\<fish\>\"", "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80363179],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"fish\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"angle\"\>", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"fish\"\>", ",", "\<\"lean\"\>", ",", "\<\"slant\"\>", 
     ",", "\<\"tilt\"\>", ",", "\<\"tip\"\>", ",", "\<\"weight\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{384, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->507675546]
}, Open  ]],

Cell["Compute the growth in the number of reached words:", "ExampleText",
 CellID->266302749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Union", "[", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"WordData", "[", 
          RowBox[{"#", ",", "\"\<Synonyms\>\"", ",", "\"\<List\>\""}], "]"}], 
         "&"}], "/@", "#"}], "]"}], "]"}], "&"}], ",", 
    RowBox[{"{", "\"\<fish\>\"", "}"}], ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63024582],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "6", ",", "66", ",", "470", ",", "2824", ",", "9243", 
   ",", "16895", ",", "21852", ",", "24398", ",", "25601"}], "}"}]], "Output",\

 ImageSize->{391, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->550372091]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->385655446],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlVzsvBUEUnru79xLXqxB7kYhKpbhejURExKMRGlSKzUZCxFujUmooFR6J
Bn+A8AM0VFq1PzLmsczM2dnZB5dN3OTO3nPmO9/MnvOd2buz3v7qyoa3v+Z7
PdO73vbqmr/XM7W1S1x2ASF0T77bFUR+Y/KLfe8xJld5rJLRIVOd1LIphn2Q
SwYr8NMrtem0FditLLpfikIalnY6OMJGqBLyuCGPBViamHtAs0NHG599jUHd
/qX7CzN3BPkIzyRbwZXi7YAv296rkXvrAPjs+ekPGLs0jJa04udd2VhWS1h9
LuA513obmH1z/To2enZy/ITKwD5kUW1kvCJBBS2HA2ybDS/P78T1+PCGijHz
UNkVYJdj1vtpuyVF/rJ5ad0uar7Kb3h7saqXHQNqaeGWoCYnLo0oooutzTuq
C46i1ZdPR6gmvq9GHNdl0E4TJ+qVDE/N39hXOK6M1dNBn608Kqn23uiuG8Kq
in0DSqjYV5iHsapePlvCqnrNdakzVh0lVkE2HqHav91H7XhKoAr/sUvGsar1
RQNKaN2EEpoXqLgnHH/ofn5gd5jrYqVSQ3J15JtXdGe+96mptS1qDSucjw6c
w2pPzBhQoicEit7BPFZ7Qc+RhxOAe2nG5ScT/JctTkzz/5B6YC+DXI58i0dk
Ow0PNZdBPYzxxS8Pd3Jc0mwkjC5iVfM01onUfrPk1XGugzz3MVxLwK1Hi2wm
QYvcwbfCbhbdCqLge9QBWBOy8DdXqM4D7drRLJaW5SiGRR91CqL0qOBUK3wA
S8xzew==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->427341516]
}, Open  ]],

Cell["Some words reach fixed points:", "ExampleText",
 CellID->98299757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Union", "[", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"WordData", "[", 
          RowBox[{"#", ",", "\"\<Synonyms\>\"", ",", "\"\<List\>\""}], "]"}], 
         "&"}], "/@", "#"}], "]"}], "]"}], "&"}], ",", 
    RowBox[{"{", "\"\<frog\>\"", "}"}], ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->70110596],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "6", ",", "7", ",", "7", ",", "8", ",", "8", ",", "8", ",", "8", 
   ",", "8", ",", "8", ",", "8"}], "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1086346290]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2800472],

Cell["Find words with successively broader meanings:", "ExampleText",
 CellID->55751679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"WordData", "[", 
        RowBox[{"#", ",", "\"\<BroaderTerms\>\"", ",", "\"\<List\>\""}], 
        "]"}], "&"}], "/@", "#"}], "]"}], "&"}], ",", 
   RowBox[{"{", "\"\<toad\>\"", "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27097597],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"toad\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"amphibian\"\>", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"aeroplane\"\>", ",", "\<\"airplane\"\>", 
     ",", "\<\"automotive vehicle\"\>", ",", "\<\"craniate\"\>", 
     ",", "\<\"motor vehicle\"\>", ",", "\<\"plane\"\>", 
     ",", "\<\"vertebrate\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{455, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316129236]
}, Open  ]],

Cell["Find the growth in the number of distinct words reached:", "ExampleText",
 CellID->217005960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Union", "[", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"WordData", "[", 
          RowBox[{"#", ",", "\"\<BroaderTerms\>\"", ",", "\"\<List\>\""}], 
          "]"}], "&"}], "/@", "#"}], "]"}], "]"}], "&"}], ",", 
    RowBox[{"{", "\"\<toad\>\"", "}"}], ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->966833327],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "7", ",", "16", ",", "329", ",", "2325", ",", "6166", 
   ",", "9030", ",", "10623", ",", "11260", ",", "11536"}], "}"}]], "Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->309526774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174557673],

Cell["Find words that end in \"ough\":", "ExampleText",
 CellID->537995249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DictionaryLookup", "[", 
   RowBox[{"__", "~~", "\"\<ough\>\""}], "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39400112],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"although\"\>", ",", "\<\"borough\"\>", ",", "\<\"bough\"\>", 
    ",", "\<\"breakthrough\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "18", "\[RightSkeleton]"}], 
    ",", "\<\"through\"\>", ",", "\<\"tough\"\>", ",", "\<\"trough\"\>"}], 
   "}"}],
  Short]], "Output",
 ImageSize->{489, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->1011097584]
}, Open  ]],

Cell["Find their pronunciations:", "ExampleText",
 CellID->285303750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"WordData", "[", 
     RowBox[{"#", ",", "\"\<PhoneticForm\>\""}], "]"}], "&"}], "/@", "%"}], "//",
   "Short"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->912250640],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"\:02cc\:0254l\[Eth]\:02c8o\:028a\"\>", 
    ",", "\<\"b\:02c8\:025d\:02cco\:028a\"\>", ",", "\<\"b\:02c8a\:028a\"\>", 
    ",", "\<\"br\:02c8e\:026ak\[Theta]r\:02ccu\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "17", "\[RightSkeleton]"}], 
    ",", "\<\"\[Eth]\:02c8o\:028a\"\>", ",", "\<\"\[Theta]r\:02c8u\"\>", 
    ",", "\<\"t\:02c8\:028cf\"\>", ",", "\<\"tr\:02c8\:0254f\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->478995577]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->473362358],

Cell["\<\
Find the distribution of numbers of hyphenation blocks (roughly syllables) \
for words in English:\
\>", "ExampleText",
 CellID->472929186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{"Sort", "[", 
   RowBox[{"Tally", "[", 
    RowBox[{"Length", "/@", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"WordData", "[", 
           RowBox[{"#1", ",", "\"\<Hyphenation\>\""}], "]"}], "&"}], ")"}], "/@",
         
        RowBox[{"DictionaryLookup", "[", "]"}]}], ",", "_Missing"}], "]"}]}], 
    "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67030175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5182"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "18209"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "16081"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "8827"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3846"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "1082"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "209"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{394, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1634840794]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"d", ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->930418894],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->415685]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21729540],

Cell["Make a table of definitions for a word:", "ExampleText",
 CellID->71655157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"Text", "/@", 
    RowBox[{"WordData", "[", 
     RowBox[{
     "\"\<fish\>\"", ",", "\"\<Definitions\>\"", ",", "\"\<List\>\""}], 
     "]"}]}], ",", 
   RowBox[{"ItemSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"30", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "1.5"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightYellow"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138762527],

Cell[BoxData[
 TagBox[GridBox[{
    {
     InterpretationBox[Cell[
      BoxData["\<\"any of various mostly cold-blooded aquatic vertebrates \
usually having scales and breathing through gills\"\>"], "Text", "TR"],
      Text[
      "any of various mostly cold-blooded aquatic vertebrates usually having \
scales and breathing through gills"]]},
    {
     InterpretationBox[Cell[
      BoxData["\<\"the flesh of fish used as food\"\>"], "Text", "TR"],
      Text["the flesh of fish used as food"]]},
    {
     InterpretationBox[Cell[
      BoxData["\<\"catch or try to catch fish or shellfish\"\>"], "Text", 
       "TR"],
      Text["catch or try to catch fish or shellfish"]]},
    {
     InterpretationBox[Cell[BoxData["\<\"seek indirectly\"\>"], "Text", "TR"],
      
      Text["seek indirectly"]]}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 0.85]}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{30}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1.5}}},
   RowsEqual->False],
  "Column"]], "Output",
 ImageSize->{391, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19279432]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35856993],

Cell["Make a 2-step synonym network for the word \"tree\":", "ExampleText",
 CellID->354227258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"Rest", "[", 
     RowBox[{"NestList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Union", "[", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Thread", "[", 
             RowBox[{"#", "->", 
              RowBox[{"WordData", "[", 
               RowBox[{"#", ",", "\"\<Synonyms\>\"", ",", "\"\<List\>\""}], 
               "]"}]}], "]"}], "&"}], "/@", 
           RowBox[{"Last", "/@", "#"}]}], "]"}], "]"}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<\>\"", "\[Rule]", "\"\<tree\>\""}], "}"}], ",", "2"}], 
      "]"}], "]"}], "]"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->505445604],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94949212]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24446713],

Cell["Make a 5-step synonym network for \"tree\":", "ExampleText",
 CellID->48984376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Rest", "[", 
    RowBox[{"NestList", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Union", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Thread", "[", 
            RowBox[{"#", "->", 
             RowBox[{"WordData", "[", 
              RowBox[{"#", ",", "\"\<Synonyms\>\"", ",", "\"\<List\>\""}], 
              "]"}]}], "]"}], "&"}], "/@", 
          RowBox[{"Last", "/@", "#"}]}], "]"}], "]"}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<\>\"", "\[Rule]", "\"\<tree\>\""}], "}"}], ",", "5"}], 
     "]"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137799795],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{275, 307},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84017153]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129863368],

Cell["\<\
Find the shortest versions of a phrase based on synonyms for its constituent \
words:\
\>", "ExampleText",
 CellID->378883310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", "\"\<operational fracture conceptualization\>\"",
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119514828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"operational\"\>", ",", "\<\"fracture\"\>", 
   ",", "\<\"conceptualization\"\>"}], "}"}]], "Output",
 ImageSize->{293, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->919331809]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"SortBy", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"StringJoin", "[", 
        RowBox[{"Riffle", "[", 
         RowBox[{"#", ",", "\"\< \>\""}], "]"}], "]"}], "&"}], "/@", 
      RowBox[{"Tuples", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"WordData", "[", 
          RowBox[{"#", ",", "\"\<Synonyms\>\"", ",", "\"\<List\>\""}], "]"}], 
         "&"}], "/@", "%"}], "]"}]}], ",", "StringLength"}], "]"}], ",", 
   "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28317143],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"usable break formulation\"\>", 
   ",", "\<\"usable crack formulation\"\>", 
   ",", "\<\"usable fault formulation\"\>", 
   ",", "\<\"usable shift formulation\"\>"}], "}"}]], "Output",
 ImageSize->{366, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64873698]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60587660],

Cell["Convert a sentence from British to American spelling:", "ExampleText",
 CellID->44473490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<The centre was modelled with customised colours\>\"", ",", 
   RowBox[{
    RowBox[{"w", ":", 
     RowBox[{"(", 
      RowBox[{"WordCharacter", ".."}], ")"}]}], "\[RuleDelayed]", 
    RowBox[{"WordData", "[", 
     RowBox[{"w", ",", "\"\<AmericanSpelling\>\""}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->765290704],

Cell[BoxData["\<\"The center was modeled with customized colors\"\>"], \
"Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1558033257]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->398596440],

Cell["\<\
Find all antonym pairs in English where both words are less than 4 letters \
long:\
\>", "ExampleText",
 CellID->465761161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"w", "=", 
           RowBox[{"WordData", "[", 
            RowBox[{"#", ",", "\"\<Antonyms\>\"", ",", "\"\<List\>\""}], 
            "]"}]}], "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", "w", "]"}], ">", "0"}], ",", 
           RowBox[{"First", "[", 
            RowBox[{"SortBy", "[", 
             RowBox[{"w", ",", "StringLength"}], "]"}], "]"}], ",", "w"}], 
          "]"}]}], "]"}]}], "}"}], "&"}], "/@", 
    RowBox[{"WordData", "[", "]"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "=!=", 
       RowBox[{"{", "}"}]}], "&&", 
      RowBox[{
       RowBox[{"Max", "[", 
        RowBox[{"StringLength", "/@", "#"}], "]"}], "<", "4"}]}], ")"}], 
    "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60579176],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"all\"\>", ",", "\<\"no\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"con\"\>", ",", "\<\"pro\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"dry\"\>", ",", "\<\"wet\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"lie\"\>", ",", "\<\"sit\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"nay\"\>", ",", "\<\"yea\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"new\"\>", ",", "\<\"old\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"no\"\>", ",", "\<\"all\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"off\"\>", ",", "\<\"on\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"old\"\>", ",", "\<\"new\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"on\"\>", ",", "\<\"off\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"pro\"\>", ",", "\<\"con\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"sit\"\>", ",", "\<\"lie\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wet\"\>", ",", "\<\"dry\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"yea\"\>", ",", "\<\"nay\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"yes\"\>", ",", "\<\"no\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{457, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1596842528]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->260333284],

Cell["Find 10 random adjectives in English:", "ExampleText",
 CellID->42703846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{
   RowBox[{"WordData", "[", 
    RowBox[{"All", ",", "\"\<Adjective\>\""}], "]"}], ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5999479],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Nestorian\"\>", ",", "\<\"manorial\"\>", 
   ",", "\<\"circumpolar\"\>", ",", "\<\"denaturized\"\>", 
   ",", "\<\"Russian Orthodox\"\>", ",", "\<\"blue-black\"\>", 
   ",", "\<\"disapproving\"\>", ",", "\<\"embonpoint\"\>", 
   ",", "\<\"nerve-racking\"\>", ",", "\<\"muffled\"\>"}], "}"}]], "Output",
 ImageSize->{448, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1029231537]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1865233658],

Cell[TextData[{
 "Find the total number of distinct words currently in ",
 Cell[BoxData[
  ButtonBox["WordData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->80449310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"WordData", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39619825],

Cell[BoxData["149191"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313665774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88162903],

Cell["Synonyms for a particular sense are commutative:", "ExampleText",
 CellID->213782465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<reptile\>\"", ",", "\"\<Synonyms\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172279774],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"reptile\"\>", ",", "\<\"Noun\"\>", 
     ",", "\<\"Vertebrate\"\>"}], "}"}], "\[Rule]", 
   RowBox[{"{", "\<\"reptilian\"\>", "}"}]}], "}"}]], "Output",
 ImageSize->{295, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1855793880]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<reptilian\>\"", ",", "\"\<Synonyms\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21268095],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"reptilian\"\>", ",", "\<\"Noun\"\>", 
      ",", "\<\"Vertebrate\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", "\<\"reptile\"\>", "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"reptilian\"\>", ",", "\<\"Adjective\"\>", 
      ",", "\<\"Reptilian\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "}"}]], "Output",
 ImageSize->{561, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->275252132]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WordData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordData"]], "InlineFormula"],
 " covers words and phrases that are not in ",
 Cell[BoxData[
  ButtonBox["DictionaryLookup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DictionaryLookup"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->103252936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", "\"\<every last\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->501756862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"every last\"\>", ",", "\<\"Adjective\"\>", 
    ",", "\<\"All\"\>"}], "}"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->482806886]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DictionaryLookup", "[", "\"\<every last\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->633052197],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1342114636]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174456079],

Cell[TextData[{
 "Some words in ",
 Cell[BoxData[
  ButtonBox["WordData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordData"]], "InlineFormula"],
 " are considered too obscure for ",
 Cell[BoxData[
  ButtonBox["DictionaryLookup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DictionaryLookup"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->659707307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordData", "[", 
  RowBox[{"\"\<ret\>\"", ",", "\"\<Definitions\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->281988465],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"ret\"\>", ",", "\<\"Verb\"\>", ",", "\<\"Souse\"\>"}], "}"}],
    "\[Rule]", "\<\"place (flax, hemp, or jute) in liquid so as to promote \
loosening of the fibers from the woody tissue\"\>"}], "}"}]], "Output",
 ImageSize->{473, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1899942811]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DictionaryLookup", "[", "\"\<ret\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->228158085],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1404477234]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell[TextData[{
 "Find the distribution of numbers words in ",
 Cell[BoxData[
  ButtonBox["WordData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordData"]], "InlineFormula"],
 " with particular numbers of meanings:"
}], "ExampleText",
 CellID->31339309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"Sort", "[", 
   RowBox[{"Tally", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"WordData", "[", "#", "]"}], "]"}], "&"}], "/@", 
     RowBox[{"WordData", "[", "]"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86206902],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWM1r1EAUT3c3adP9qrLQgh6KCHpQ8eDBg0VL1SLiUTwvRWyRtdpWSg+l
eCgiWkS0SFsREfXqwWLBqyB68urZfyTO5E1mJi8vL0mbihY2yZv5ve+PTHOt
uzB9s9ddmJnqjk7Ode9Oz0zNj16enRNL1T7HcbbFb2HEEc+BeAp/20Eg7snr
MXGtCkBF3Cvi3hD3GqLlflXRLcklAUH0R6Ga6m7TTlVzaemhNOd4XKbSbuMH
5cUFWl8TqIZFU/v1TD1ZEnx58WwJ2fZqKG1PDu/LsVsKcFxttUK2SvI428a8
3mb5ImNbidZjkuoUZwzx/3mbrSk9Hg02UlVyp1maZ3ljuft8h5yZXZavFwtl
PpyaeL7ZdL6p2bI8o+hmEJ/NMC3t6T2MrNskV8+G9Pt3P8+Pbaw9+Rpa5fRr
WlBoD2NdoGdufVSrLkINkKh+hBpGtI/oMNZOR1zfyBQBPpG56r+yaqrlx/ff
4nnn86/QA188i5XZO5/ECnpW9aQZgPY0av3FN0tSmoYmsgcAgl08gyrCTtuM
0nxN6SvkX6IiD5RMH8zYb5JW0N1Cr54L4rVaR3TYEYkOmGBk3bj+QaAuTbxS
sgwNsoC+MLapVjlZJrd1RIMsXVxqlZZ1GvlUeE4w9FVGo/EcNGpaUGgPYxma
1nhKXtpg1+L9HRGPleUv2j8dN/sZJPv2ns2vEVbU8eQbT7clxds28gbTjEQ/
6YX2UZ3EjaVtRNNyzyDtUwzKyKJR0F/2CUS+21x13wp3wzc7e7qI+E6iSN/e
Fb/xrAi/JE8gn4vw2/QRqn8S86S3J+moVxITpqczY59lXEpWPa0bzIzpkdk/
avl1ZfK10nyPwYKVF8e3lFwGa+VhnkSNoigvkqjDAZ57JnIch93JxhKGw8Xd
uaSxMvKHGDuWSKkj8uKj6MasYfgSkV5Ox1qRXiFR0OVeEO/ytJrqkNX+IJTR
z1a7k6P6O2S170W6JDtWBk3Vl2XzZkly4GRkKn61JLlDVsZMH6/qrNvZTsv6
EFl1q2Q9tSx95r37UGOlfPyOfERKapCSGKwl8TGDMh1Bo4qcNgdR1tYYlLGO
QxnraNQA0vgU6qCmysGJaiItr/LuI3tARvL/dq7W8tTeAPKoTD3mDFKOPEl6
KLbP9ikuHor//uox8Qc9cKiAP1whaROgSE/UUBSfMygTAw5lPKBRRawzq6aC
MKaCPFhnUMYDDmU8AJQbxN+3ddJKj62IQHfY3+WTJItPfGvwimjLyR3Nsqhi
JW8tqlzzFUQn8WXIhb8re3G0Tiag20o2QulkJlGmpoaQ1TXSi3IqeT9W/+cK
LcoXzlLHnILz6sJ0NeLQVbehY8lNV82n6w/48NcxjdMVCLhYnSZ8b6PVt0FU
n5IHKPhK7fT9AQeDu/E=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->476686480]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->166862061],

Cell["\<\
Find the number of meanings attributed to single capital letters:\
\>", "ExampleText",
 CellID->73247082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<A\>\"", ",", "\"\<Z\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->331653800],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>", ",", "\<\"C\"\>", ",", "\<\"D\"\>", 
   ",", "\<\"E\"\>", ",", "\<\"F\"\>", ",", "\<\"G\"\>", ",", "\<\"H\"\>", 
   ",", "\<\"I\"\>", ",", "\<\"J\"\>", ",", "\<\"K\"\>", ",", "\<\"L\"\>", 
   ",", "\<\"M\"\>", ",", "\<\"N\"\>", ",", "\<\"O\"\>", ",", "\<\"P\"\>", 
   ",", "\<\"Q\"\>", ",", "\<\"R\"\>", ",", "\<\"S\"\>", ",", "\<\"T\"\>", 
   ",", "\<\"U\"\>", ",", "\<\"V\"\>", ",", "\<\"W\"\>", ",", "\<\"X\"\>", 
   ",", "\<\"Y\"\>", ",", "\<\"Z\"\>"}], "}"}]], "Output",
 ImageSize->{480, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1842094550]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"#", "->", 
    RowBox[{"Length", "[", 
     RowBox[{"WordData", "[", "#", "]"}], "]"}]}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->842004076],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"A\"\>", "\[Rule]", "7"}], ",", 
   RowBox[{"\<\"B\"\>", "\[Rule]", "6"}], ",", 
   RowBox[{"\<\"C\"\>", "\[Rule]", "11"}], ",", 
   RowBox[{"\<\"D\"\>", "\[Rule]", "3"}], ",", 
   RowBox[{"\<\"E\"\>", "\[Rule]", "4"}], ",", 
   RowBox[{"\<\"F\"\>", "\[Rule]", "4"}], ",", 
   RowBox[{"\<\"G\"\>", "\[Rule]", "7"}], ",", 
   RowBox[{"\<\"H\"\>", "\[Rule]", "4"}], ",", 
   RowBox[{"\<\"I\"\>", "\[Rule]", "4"}], ",", 
   RowBox[{"\<\"J\"\>", "\[Rule]", "2"}], ",", 
   RowBox[{"\<\"K\"\>", "\[Rule]", "7"}], ",", 
   RowBox[{"\<\"L\"\>", "\[Rule]", "3"}], ",", 
   RowBox[{"\<\"M\"\>", "\[Rule]", "5"}], ",", 
   RowBox[{"\<\"N\"\>", "\[Rule]", "5"}], ",", 
   RowBox[{"\<\"O\"\>", "\[Rule]", "4"}], ",", 
   RowBox[{"\<\"P\"\>", "\[Rule]", "2"}], ",", 
   RowBox[{"\<\"Q\"\>", "\[Rule]", "1"}], ",", 
   RowBox[{"\<\"R\"\>", "\[Rule]", "3"}], ",", 
   RowBox[{"\<\"S\"\>", "\[Rule]", "5"}], ",", 
   RowBox[{"\<\"T\"\>", "\[Rule]", "5"}], ",", 
   RowBox[{"\<\"U\"\>", "\[Rule]", "3"}], ",", 
   RowBox[{"\<\"V\"\>", "\[Rule]", "4"}], ",", 
   RowBox[{"\<\"W\"\>", "\[Rule]", "4"}], ",", 
   RowBox[{"\<\"X\"\>", "\[Rule]", "3"}], ",", 
   RowBox[{"\<\"Y\"\>", "\[Rule]", "2"}], ",", 
   RowBox[{"\<\"Z\"\>", "\[Rule]", "2"}]}], "}"}]], "Output",
 ImageSize->{550, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1958846698]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Last", "/@", "%"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "All"}], "}"}]}], ",", 
   RowBox[{"Filling", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->294404571],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt0z0Kg0AQhuHFytLCYostVERERPz/a/QEKXKEQGqv7hES2dlA3hOkyIJ8
POM6OwgbP47701NK3d7PlXadm02zS0FSS/qSmWSAeoi6hg0ywvsETjGHO9d9
n+P8AnOUcIX+Nfo3ku4/tOjfoV8PD9g/4rwJnrF/wTwr7Ob6rP2bPhzAIaxh
A0dwAqdwBudwAZdwBddwA7dwB/fwAI/wBM/wAq/w//7Y/L378wKZpjW4
   "], {{{}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{27, 1}], LineBox[{28, 2}], 
      LineBox[{29, 3}], LineBox[{30, 4}], LineBox[{31, 5}], LineBox[{32, 6}], 
      LineBox[{33, 7}], LineBox[{34, 8}], LineBox[{35, 9}], LineBox[{36, 10}],
       LineBox[{37, 11}], LineBox[{38, 12}], LineBox[{39, 13}], 
      LineBox[{40, 14}], LineBox[{41, 15}], LineBox[{42, 16}], 
      LineBox[{43, 17}], LineBox[{44, 18}], LineBox[{45, 19}], 
      LineBox[{46, 20}], LineBox[{47, 21}], LineBox[{48, 22}], 
      LineBox[{49, 23}], LineBox[{50, 24}], LineBox[{51, 25}], 
      LineBox[{52, 26}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 
       68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 26.}, {0, All}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 ImageSize->{184, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1412144776]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->394492769],

Cell[TextData[{
 "Find which words in the ",
 Cell[BoxData[
  ButtonBox["WordData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordData"]], "InlineFormula"],
 " collection have the most possible meanings:"
}], "ExampleText",
 CellID->395599705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WordData", "[", "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"Ordering", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", 
        RowBox[{"WordData", "[", "#", "]"}], "]"}], "&"}], "/@", 
      RowBox[{"WordData", "[", "]"}]}], ",", 
     RowBox[{"-", "10"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97984396],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"clear\"\>", ",", "\<\"draw\"\>", ",", "\<\"give\"\>", 
   ",", "\<\"hold\"\>", ",", "\<\"light\"\>", ",", "\<\"make\"\>", 
   ",", "\<\"play\"\>", ",", "\<\"run\"\>", ",", "\<\"cut\"\>", 
   ",", "\<\"break\"\>"}], "}"}]], "Output",
 ImageSize->{406, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2075467235]
}, Open  ]],

Cell["Find the number of meanings of each word:", "ExampleText",
 CellID->12015132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"WordData", "[", "#", "]"}], "]"}], "&"}], "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9138742],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "45", ",", "45", ",", "45", ",", "45", ",", "46", ",", "51", ",", "52", ",",
    "57", ",", "70", ",", "76"}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->800940424]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->313371167],

Cell[TextData[{
 "Find how many words in the ",
 Cell[BoxData[
  ButtonBox["WordData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordData"]], "InlineFormula"],
 " collection can act as each possible part of speech: "
}], "ExampleText",
 CellID->81200459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"#", ",", 
     RowBox[{"Length", "[", 
      RowBox[{"WordData", "[", 
       RowBox[{"All", ",", "#"}], "]"}], "]"}]}], "}"}], "&"}], "/@", 
  RowBox[{"WordData", "[", 
   RowBox[{"All", ",", "\"\<PartsOfSpeech\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23527315],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Noun\"\>", ",", "119034"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Verb\"\>", ",", "11531"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Adjective\"\>", ",", "21538"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Adverb\"\>", ",", "4481"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Preposition\"\>", ",", "162"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Conjunction\"\>", ",", "93"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Pronoun\"\>", ",", "117"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Determiner\"\>", ",", "103"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Interjection\"\>", ",", "430"}], "}"}]}], "}"}]], "Output",
 ImageSize->{382, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->978206772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72866180],

Cell["\<\
Find which words occur as the maximum number of different parts of speech: \
\>", "ExampleText",
 CellID->47970571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WordData", "[", "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"Ordering", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", 
        RowBox[{"WordData", "[", 
         RowBox[{"#", ",", "\"\<PartsOfSpeech\>\""}], "]"}], "]"}], "&"}], "/@",
       
      RowBox[{"WordData", "[", "]"}]}], ",", 
     RowBox[{"-", "5"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203934446],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"so\"\>", ",", "\<\"steady\"\>", ",", "\<\"well\"\>", 
   ",", "\<\"fore\"\>", ",", "\<\"out\"\>"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1733899219]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"#", "->", 
    RowBox[{"WordData", "[", 
     RowBox[{"#", ",", "\"\<PartsOfSpeech\>\""}], "]"}]}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->314072167],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"so\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Noun\"\>", ",", "\<\"Adverb\"\>", 
      ",", "\<\"Conjunction\"\>", ",", "\<\"Pronoun\"\>", 
      ",", "\<\"Interjection\"\>"}], "}"}]}], ",", 
   RowBox[{"\<\"steady\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Noun\"\>", ",", "\<\"Adjective\"\>", ",", "\<\"Verb\"\>", 
      ",", "\<\"Adverb\"\>", ",", "\<\"Interjection\"\>"}], "}"}]}], ",", 
   RowBox[{"\<\"well\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Noun\"\>", ",", "\<\"Adjective\"\>", ",", "\<\"Verb\"\>", 
      ",", "\<\"Adverb\"\>", ",", "\<\"Interjection\"\>"}], "}"}]}], ",", 
   RowBox[{"\<\"fore\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Noun\"\>", ",", "\<\"Adjective\"\>", ",", "\<\"Adverb\"\>", 
      ",", "\<\"Preposition\"\>", ",", "\<\"Conjunction\"\>", 
      ",", "\<\"Interjection\"\>"}], "}"}]}], ",", 
   RowBox[{"\<\"out\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Noun\"\>", ",", "\<\"Adjective\"\>", ",", "\<\"Verb\"\>", 
      ",", "\<\"Adverb\"\>", ",", "\<\"Preposition\"\>", 
      ",", "\<\"Interjection\"\>"}], "}"}]}]}], "}"}]], "Output",
 ImageSize->{503, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->291083943]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->514367062],

Cell["\<\
Find the moving average of the number of word senses in the Declaration of \
Independence:\
\>", "ExampleText",
 CellID->742720665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"MovingAverage", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", 
        RowBox[{"WordData", "[", 
         RowBox[{"ToLowerCase", "[", "#", "]"}], "]"}], "]"}], "&"}], "/@", 
      RowBox[{"Flatten", "[", 
       RowBox[{"StringCases", "[", 
        RowBox[{
         RowBox[{"ExampleData", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "\"\<Text\>\"", ",", "\"\<DeclarationOfIndependence\>\""}], "}"}],
            ",", "\"\<Words\>\""}], "]"}], ",", 
         RowBox[{"LetterCharacter", ".."}]}], "]"}], "]"}]}], ",", "20"}], 
    "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "All"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input", "HiddenMaterial",
 CellLabel->"In[1]:=",
 CellID->63748116],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{182, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36084856]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170180374],

Cell["Find the network of causal relationships between verbs:", "ExampleText",
 CellID->477122470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Thread", "[", 
        RowBox[{"#1", "\[Rule]", 
         RowBox[{"WordData", "[", 
          RowBox[{
          "#1", ",", "\"\<ConsequencesTerms\>\"", ",", "\"\<List\>\""}], 
          "]"}]}], "]"}], "&"}], ")"}], "/@", 
     RowBox[{"WordData", "[", 
      RowBox[{"All", ",", "\"\<Verb\>\""}], "]"}]}], "]"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Tooltip"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->825506999],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxUW3k81F/3t5QtYszY9yVL9mHGMsMcS6ioZCltSgqllCjt0h5pIyWpVJYQ
EinhZClbKIWyRZLsKWup3+cx3+88z++vXu/X/dx7z/o+59yRinfgyi08XFxc
TEUurv/8GxPcNPH2pioE1x3S+kQ3Q781ilrlVWqQ/8Tzy6+55vhOed7V5PlM
GDvBw7MuRh3TuVdRyvyYkO5gR6PHqWNhwHZrkRNM0Jqz7/JCG3W84Xo07rQz
E46s23hQV1Adk0P8Pu/fwiTO292oO6yGKzcWXHbaw4Qsv0jRT9LqeDXjDFeg
KxMuS53hrlmmjpciT6rdojOgL/zrVd7d6riRLKo5GsaEP6SgRRePqmP7c7v+
N9uZ8CBUJsrLTR0j744ZuAkx4diVge85lup438QkYhUTAASvBgnGqOGbrLWf
vqeywG7cR/nqEzXcU2u4XHMNwIrM5pH7yaqYEHchmBGuDQPLF8attDfHe8WC
KaMpCyFqn0sFz3dz7JcpCKm6rgn2Z1zel6ibY4PHXN/AczowKVuzYIu0OYaP
x1/5GK8Fq3ndj6r/NkcuY9GwP6cWQsPxY1FPwAznvjCyVzigBdTk180vl5qh
VqbE/vFMI6gsvnLb/AQL4Wcul8IuKvDLrjERMAB8JdDwJovAmt5maNfNwmXL
/qxYkEsDY41ddt/sqVhzpmq9MhcNpiYYLt2XjFB3pnIW11bcNR36RUXuWiO7
hdvoYBl3bxbDF+os9qtkzn5vsejdfVwJ4Cx96U/naiYmf+dXWScOYGfdk5V4
kIFqf3/0r70MUHBbz/XZAQY6bXvY1eRvAEE34652/7L8B+vBEws2Vlj519p+
0gYW0jQ/3vxDwY0rbzfzbPvIis+sXfhQDPAaRSsvLG6cNfWJjVXfircvnkeC
Ii+KYnUBDW/xf8QxUQl4XacodWkLHYPL685unkOBE9u2RWvl0LDYxtvpzXNx
+LWIq7+nhY57r4ckT4EYKKjEjMrvoeNpVW7f0FYb+Pf8WbzOBv69/+czA67e
T8OsG/mvv5u50vAca2qxr/0Ua8GCAI1rvTREua4kehUfbDj0YY10nDzWJ8af
DO/khYSBFZKhpXJYP97V6ZwoDKtlOylDcorYL/2w2GpIDkqfnbkf9Z6BvVpF
RX7XFSEF6HuHVzDwrtid9JN7FCFDb27kTVUmbvDf/XRqhyy4rb19xH8fAzdm
ruW2jJKCXUszzjonMvCokW/go2wmXK10/P5WyBqHDT07xZstOJg3QvPBxClb
MOzUeWeeLI5OIiw/+4+aHP3YWJuj/22xOgWbi2ag/CGb5j9PAbXcfg77OJvD
9JTellU0RTRvHCLfj7OFwGuW67eOW7OxrC2I+/4vtoOFv9g4/eAT+w/iNM75
bGzCuX9+rviSU73GIP7lh/LEtAVWh1wwDSLw4eDjUec/MDDGOScquskEuI+f
TTTYxsBr4eIrQ6eosERn0WINAs94Ds1sr9Th6HtPV6Ao/7MVFOndux69VBul
0zqzq+2s4MzX+8INJpo4uPub/yclKwhdR5/zcLMm6gYIf/K9MMZKsCIJ3z9v
zom/fVuntc4qmmPb8v0/nFk8MKzXfXQFgd8JRsRXnR5jXXAs5zbNNMPCVXnl
g97qnPtvesSlPsxU5uDM+0c10xXloFdGcF+5PR0XP07On3iuCFbVN/b1PKeh
yvI8CQMJRdi99dMKkgMdc0oXBSwMVoYs0XNiMo509GhPpYc8VQT4Usuv/ZaO
eWMl8vYkdQhfPjx676gq6mhTb21W0ASqu8O5h6dVcehqlKnuowXQanYmqm2L
Ko5EO1F2ktQgSHcMxETV8Lj670h1BzXw2pfQLiekhg/OnNDjCtWGx6zMZKds
VeQiR3z2OKANm0e3S7uHq2JNVYSX0i1pEHhqfrYgXA0HaDe6729VAJO73h4N
71XQJ7VhXLtQAt5uecx37IMacpV98HDulgCtB/ZhpP3qOGeVlPu2aUmIaEl6
IF+hjhKFzDoWRR3GnfkK335VxoLL126dPKgJXRq5xacJ/dl4AWiWPZ7FZTEe
l695UuD2furw6W4q6n/3D++emA/a/b/2mSEVl93hrvRbKwZHTPLVyj9RMUiM
2nRpriislDwh2TzXGMNPiYb6OMwDhcdJJbE9VNS6mOla/lQWRr7H/HzziIot
kZ+sPxL47Ys6wwxJYzQZ+2I+2aoEcza3y2Uv08KyxPSRXQ3KkPbeJi3huwZ2
yWiUmOxWhaW8K1JXHlTHHtEoC78yS7jkt0PPw5OJxX5jhrdsLeHMpZIOyUMM
zD/++mWCrRX8HREM1yf40V5Kz92wTxeW+WiH+10xRvfqQ7vDVxiArtuXopWL
jbHk3IcrVhv0oTXjlMAlE2NMhu9SLZf1QWvRtys17iZIedS4w/WRNkSrbi44
AMa4oi8sOXuFPjgOLhinZhjj3/tNGg7VevDd9/7hZi8TXLxQvIuvQR+ojXdx
+DkV11x7fLtmux5s780nb59vglu2vSFpytvAme9nPA57SKPeD6tfTWANWUt2
3h++Iodaa6I0aZ+twcbnaIv1Uxn8vKTv0O1ia3hcn2ciOCiDmwcDeHo0zEAx
m53vvn9tPXbxMTn4/uiVQ7+T6VCX3LluP5HPuhljgg/zaZBSV7V/PZG/7e48
hcNXTUE59nG9OoHDWtemhBPfY3bMynm/LHABn/+c5VWq4FdfsMqGWL/d8Nn9
63wV0DpL4D4LHGvz/Z91Jn7YOPwo76Q6pJ59Prt+6uOFxJ5yKghQfGNu5NHR
y3jimsIiKvxlPndY94GGq5fV6SssMoa98bx9e5ppOLH7262rN4j6dePB14ei
htj89W4t9zKAiJK/imY79HG+85E6QX5FEE4TSGwNUMHwfrnE2DF5oDKSP4aX
KWOczbJMoe9ywIju2afqpILPkm/uFpqRA3kNeVaPiCpSCs02tZ6XgE+L/Cv3
1Cpj892C6twnMhCvrJ4jt10ZRRx8Q8fr5ODzjPkReq8Fzo+ZiM4uFOP0U7WX
G/ziXglz+q1NAgr3b3UIAkWMnijlbo6ZdmP/870F1pt6rboSQYEybdPZdX2l
s2MxUmSIOHx4dr9xvuynnVlUyN8WfWOy1AxznsXe7Q2nwtJ7W5e1bDDHcjxO
sybWg+Vtgj5PmiMpS74n6IQBx55lm/rffgrX59jzY7Xz30BrQ449X6dOi/ir
0EEh2DIO8lQJf3urJ2RbQ4DnGc8mERlc07QLLt+0BrHKe5iYI4veT9J2ayiz
YKj8ZppLujLee57CI7HHBqKqbCsiBWVQoknj1ZoSG/BRX0qliEljz7e6vIcB
RL0er8nUoEojj3mbY6CCFfySKny9rtAIE24Z7ajisgJBsfWrVjoZ47mVU6tc
eLU48TRXOTj1m4MGJ57WLJz8n3UmWmUc5XtapM2Jp4/SB4Tk0604/QwbW3L6
GV3uT1Yb81jQxSU19XFCGbsqlUhVQ1awcLVX76NhFUzfWScSJabNyY+h5QPP
PscCsMyLRF406OM8cqVceDVA5fM5qeN8BmiwZZ3nQBnA7Rp5i9hD+njUnOEZ
thRAOatwhbGdIX41sC9P8wYY8V/RN7PeAG9aTl5xjAIoLjCz3nHZAHPpe/lK
JQByrJUje68Z4N5fZyvm7AUgy+jonWIYYsdFlT3ijgDLyxWLhicM0F2p8fRf
VSLeI0R9/igYYum6binRJwAB5bvDir0NcG701pHxZADRVzriKKmPIdYdDZ9j
LIn89YlImEfFnj2mkokOluC3yZtr4RUq3pu69mswxwxOTbroKzyRQw88uOXg
fhYEXbrSa8itgr/PBoa/YgG4zLuy7STB9xXMHmdL4r5kRz+7biK+tszcMmQS
uMmXh6FDxFO4kIOH3EISp59Yfv1FeSgVOPVWlBoy4xJhxcHseqINqwb+t77o
QE123ixe8nthqVYOleNPNjbi+HPcbmfD8SB90OVjLG99bYYfh/26AiwMgbF3
kWPiPnO8VeSUKjZsAKNil8rNy4meeybmnMNSA/Af0JCfHDTH2ylK+WtF9CHi
VYGa/klz3KAazbSQJwH5YFD3DVcqPksp69p4WZwj7zlTtv223s8+mGFgjNMX
bv7mjTfg6MvGepz+aebVsj/ctYbw2LZuFpt7Fda7npAGP+ptv/m3bf7B8lC+
mY2nH/yW7ZiU4dzH2Ovd3/aJCbKZmCFC9D+UuspOykYmkJolNtYS/Y2kxu39
vGnW8Fa48oLFITl0aATPG6tYUHNOvubrKRXcMvl05OlvgKxVUuN2234VO23w
Vlsnaw2G2isCuGmDxdL5My1rzK0hzG7AvsNmpNj5YsacWyfVoFb8op7jkAoO
JZxNc2XqcfLRP2DOTH+YDicfi/ae+Z91JiZOia4pmNDn5GO55+uDYxdUoUeu
sy7FRA3ntPKxNuzQ5viTjTU5/uSd2bd0Z7w1JNU+GCBPyeDXhZ5LhJ+xYKHS
dV2+AQVsnlNZPnSBCmoxbHuxsRG8/Md+iTS7zUFR1jAkbvvut7MMmrF8tc+W
WsMhWzP/+Go5dM46WnRF1gq6Gzcxjn+k4SnL/PeHJ61A6pin64ImGjqs7i6S
UbQCPwOSbt8TOgal07Z3/rICodeyb148pqPt9l4JkXE16PPK+5iToIZfI4+6
jKsyiXqpdeHwOSW8MXn3qpAbE6hWvJbcX+QxdPWFiHmhTIg/fX+upIcq3qcv
kM8mE/Ntd1A7PJNH/x4Px74OBqSPXl8uvUIBN7naRm94Zw4vL2kWOxUqo1qr
nfT1JnNYXtEtUuqognE9zb0GxywgPyZ1jbmQCiatm3zKm63NiR821uTEFxvr
QNhLNlYQic+7aSoMeovZ9hbsnJHfe4EPfshuvdthb4nCJ6ZmcUX/67Pfsqxw
zVz5lK5hMTAtrJ3FHt7Ks9h7gP29GE/xotO588EtjXeBnjwVRUY9TMWWMOHd
XusjCcuUcGfpn+gt2TSOv9nYhONv4Zh7K+5PMkDfW+6b50di/vc859SnxoTH
T6q8vGvUsfzE7nzddwB9Rnl+7fxUTJDw3Z6obQ05c24EBHRSUaB4bMTkK0D+
rqRt9wh8Itzu/StlA5AUupvRNmaMBp1v4q8XAHiIs/NvFjOAk69qT6ZZ/lds
QSKALc/0m2/27z6rcOq1dFyEE/ktH0hOwxbIkEOFUZ9bWY8ADNW5lyWM8mPb
6redupJanHxd1xLzcK2DKSc+2ZjOic9+CbkIz0xbiL6Y3hF/k4pc/m20SGE7
6NBbc1V2ERWdeuc+phF4eERjwakjxvjNLP/atLotnDk+cTWM0O/r0xm/bcT+
tBC/eIsFxtiV7R1b8YfBuY+NLTj3mVMV/ue9xwKzAu/G3p9kwbv2aOq25TJ4
+dzbrYmZZhz/sLEpxz886TIDwTuNYGVa8M9eZ2P8HIG3744awTJ47mGUa4wn
pJR+6ISrwbiLmrXVJlWsDC87UhaoC/Pm7J+8qqiG+Vm1pVnbdSBHXNIu9roq
zvCeEjJM0IGLYTlSoZmqWHviJF/lOz2C35a7VzxSxZvXli2+dF4HypofXany
U0W+czomh4l6sPNZ0Rdamyo2JQ0kNy/Qha1Ces4tLDU8H98+W9+E0jNHzJ4Y
455oA53s91bg9Te+9RjBl06DV1V63azAQ2s0yiaL4H+BwCdf3Vjw+rS50RqC
PxPOfWo4I63OiQeueZVLBNVnWPw2fPHrM1QxJdap6ZWFMMQxrSOeVqmg91zl
3NsJ86Dkjb7WiRhjLLhesE872BjovL8HZBKpeMp/V+LNxcYQW6K4qP+7EY5Y
TswfcTQGOdqb5BUrjfHJji0WC7yosPDy2j+Nd6jIuzomTSjAgsPvrVm/71j3
m3P4nS2fKqeeZPJcEvRyM4egMvljssMWOKfJ60gflwU8iMwezOVm4vWoa/cC
uC2g/kvtljRXBu7JtTMTDDUDF8mPbo9TGfhncNEyTVdzUIxZo79tCxM/3RVc
ESA/xOpsjD13UpWYD3f7zZ13qZNVka546G25Gob9M2/3VeuGzjFVQ7ARkplK
G2IV39y9yvSwGiqsFZJNO2TAif9nGju+1fV9Z/3LL/YWpbP7/+WXf+f3f/ml
V+W+vBJjhvUvv3yMyZvF//LLrZ8nQhXNGRy+bj5WeEFAisnh6+vx30LvMRkc
vlbSJ8uNxRpx5IkWKEkOKLaCjPs5pV+PK//znqLDqceZ+iqp0buNOd+zDAxM
TZbS/vte0anaqWBkDCJdridZXoDugkcqPj00AkX5Su6KDYB1BpblDeqmnO8L
V7XO9rcFV1Y9PDDXBBn75snvoJFgB9P/UNdWIl5u6JSNPrUC+yH2+lTctJVu
lyw8XGtptCyAiVdDO/VGrxnAz2Ep4WsvjbFmJnxvwElxuN6tVpt5XxlXpLZx
+b4Shy57aneVF1EPuvfcHSWrwWCLXavFYzXM0e45uLjKGlwcEhaeJvjCy3Cp
654/Zhz5njt73ejepcbJdzZW4eR7tXnFdtMJU0483rts4L1zryknHttd25VC
gQUnxBuN7yurYsuxb9yC6dac/JnFutaceP07rLFT9z1w7pvF7sC574rcLx2f
cBrnvoBgb9Ub3DTOfT4XLPLjuOlwxnQ9T89DMzx11/h4ub41PJr6sfEE0R+u
aqPen29MAi/pO5EXfjBQwGglpUmQAlHL34QyiPwoa//6WcBDCII1Dqu2EvE/
cd/qWc1fMjSf1l10y5eJf+qomU+J/UbWjapjGxm4PP777Pth90T8+cYCOide
q6VSLniQTVHV7+OQxtRcCNydOouH1eNGb2rLc+Y/R0/hy0/rZDjzX+/FlZWX
JCZY1BAlq2+O1iisLORT5dbKem/Q4lLkZI0et3YKSF0dZ63anHfxawXghn/u
c4x4n9BaAxjt//zW1BGi/077OLB5riHeq75bnffUDKLbzqzf+JuGBz/v6v26
xhzeexw52L6WhjVlSWuqnptBqucAr5GxKWZrDrSsppgBv8s8BVsvGtY+qHn9
gdhfvH/eL4U1dBQv36eaWGwKEetkbqbup6Pc+Zb2XbnmsNAm/2pWMDE/5obU
vif8NURaWqtar4aNB6Nq4yes4GNP+8ubVsp4qUGsaYmbDce/s/idNce/2so7
/4r7scC3oNKw+YgyGpdK13yNtAUHo1XTGVEsvB08krQxiqhvKQFatLWA/LvI
KyqV7aCB6r1mWSQLq7/L37vTZAtFLa9oz4h44tGnax63sYZaBVrrpgxjnCMR
lU53E+LEG3v+kODk98ovK5P03jHh3uRDBvmKMq7sED1y4DzRn7BOfzL5q4yJ
16SqPeqZwDQYGyaNKWPf1pvS+4j89tIv6z1KzNdrZvQGLp43hpqb5WZpBP5Q
/rJ+uZYNrF83L9iJmHda2x/Tnt6ygb+SZgnB/5lfHGMO6BHrym5e80qJ+chx
lcCK+CxrGN0xlO1GrOeTpo6UqNpw3mdncaI1532WjW0477NCx259L/Qyhb88
XDKTZDU8Hm1B21NDB78zfTMOWmq46P75MbMOOpRInMmefqqOA6r6pXdlTWG8
f8YyQkIdrfcvjlg/Q4eU2P5nXfEq+PP3mU7143S43NObHjOgilI51Vf3KhtD
9YYBn8jPqqi/p7Tp1SFTeGd4xd3QXh1XLn7He/YRHbjNAsgjlSromHuBIRZI
h4ZlUbrCcUQ9ULR0r3UzBQ+N+j8ZHSqYy+SbHiygw44vyc6bOtRQY9Ptqbex
dNj4zenUsLs6GqducNSmmwIz8svgWLk6Jihk9QZwmULkt9itZUdUUbHoxyG+
NDpE1ajm/LRXxZPt/GdH7Yl+txtFLeYq47JeYwN1YQuQf/+6bHOGEv7msc44
1KsMetToI03cppi75I2dxzd1uJq85LLGPireCG91NpqnBr/jSjYXd1Nxju7b
8eILLFies3l2/v1d23QrttEKbLnz1U/upeKYyrU/JdFmYGie0ub1VQHb31bC
H4o6jLhll7uqqaHSJUnh32UGwHUj3bdvvxHyCqRdvrtEH5YnBP7502WE165X
RDoqWXP41i2bR/WEuyA8tZNf4rDIGA9dSsq7d1ENftYaBndXq+GeEw8HT5xT
BXHbLx7dCapY4LBrZ8t5gDNWuzyXEPwtb3Dw7KMMAB/lDVt83xjgh5c/dm/U
MYd5j0KtF+6n4oLsPQoaBKa5xVtkLDZG6XUzZj9KLKBQdOSkI7E/8+/QWGwi
A0hxTb37HxD6b79joq/GgM27dwmZrqCi7DstwzQGE75GcYckX6dimbhONc8r
BjH/2yZuvGeMzabTFr1xDNjY12trJWmMsXyF23+biEL/GtKqB0nG7P6ZbAtr
BNn5/q76nal1vwWHr4X77uyjbLTk4Pb3YyPy5xlwKvT1b11rDXx4qi5567AF
vFE642tqpIFDfNZ/595jwki+ZNn6yQUYfOukjvZLBhyIMDH2U6Dip+t1rtLC
Nhz7PnbeYmqgZAoO8z8s/JFljFpxjbK9k/9dPxfS2pjw1wpkd/sZ6qUpYJ/M
BRfnxSxYpnqqtOWQAjoJUdaCMy+HL3bFtXU++WLL2b/wy3NBPMCCpKV/nkgq
KOJx8aJi8XJNSBUvqtdfR8V22UVRFwesYLL6wHfSOhWs7Sh8qZTEgo86n7t/
vVVB33VLtCbWGXLm5dSxyL8PLIw48/SlTf+LmVils1IwL3sB5z0wzyXJrCOD
weFXNrb477xc2COWv8eUU3/ZmM7hQ8bjQM+MPbqQRLd31q5VRVP23M/6930r
4WAD9tyxgU//ke8BA9uumTv4ONhA0trTPpZjFijiysYHdYeXOHgxMZSxw8L/
tw30zbCx1Cs2ltA7M/v9+ieji/WWccOOLbWzv8eVZJJMPr/XB8f+9cb83aro
tXLXA/9qPs77mnD6dPQ4tyZM/Q4Upmkao61M/fqzeyyAYjiyJ3T/ArxiLNGe
FW8NXA8WaF6Jk0bdVQLje72sod68+PB8HiYO6cek9vJYQ0jTya0Vi5gYl/NM
fDWvNciGf3d8Pp+BNmrXzjY1WsOn7sVdVYR+53Qf771C7Febfsf8tZKBe7O1
zY9Ys2Dr3azZ+WFE4JCe8hAZVrrlxs5ZIYfMU71XDtRLQGPfzLq+5Yro8Gvh
7PeHo7bMvqct2qA328+dDGK/Z2YlnuDL3m4FgsFCRduJ/Nv8RP2kHDG/erzb
QJ56ZoyhSr6rn0yoc953He8/cPh6zZY9r7w2x1yX9pLw1bbseWXEDI28qs6H
N9uy55VhM4zP3NCrbaPMmecFjgUHul214vifjS05/u85Ejj8vleWEz9sLMmJ
H+U1G1a8DuxjHat3e6fxXhV3aS+jt+ZYQVyYxbAmtwpy3WGM/IxQhrsvTh2o
CtEi5p/YHc1ySnDcvkmeUqmJQiunt3SVW0Pfcr01m3/JYofonKNXM+Q58rCx
NEeeEf5wVrWHMiffrt/jHry1AQDW9fUEjZFwEL/VuR0HYJ4eWba7WgQ/3UjZ
SWlRgqMebonLvlAxqfS+7+FAI8irX+Dv/dMItdr8L7X8MILv5asXJJ03QnGK
keHztdKc+V1+Q3R3lpEe3HQYPrrF2BijtvwUSDihCXU7Z0oO/THGVTF7tJdv
ZnB+HzIc+qh0qsuC8/uQlmBO7skuBuf3IfS7m+JVQoO9V9Y9+mhBR2jZkezk
SgNBhfmvTdxo2JIbWlFVYQLnaFcvfuam4/zh6UjzaRNYGLPr6b6PdEx5l/g/
+03xpfbSspPn6FBwaPfs+vn1tWd+EvXTySN2dr8c98fUICM6RNxkn7/mj0TL
VTcLznsGG5tz7E0dE9r3+wsLwkOWv3z2XBF1vrRVCPSpg8CS5GcBLsb/vK+q
wY5N7N/vlua8ma2HyyYezb5nWpETDrbdA878nFb8ZjzUBzjzs+brwheh3cCZ
nzfyrNta9IoMfvNZ208qKmL627Dq5o0U6D6sZqshqoAV0c6NNjES8E6c7MgT
KY9Oy0yGy3jVQK2916RpSgX9rvrJM4n6PjIqSqr/pIhb9q7WTZO04PCDu8WZ
Q9PE/LU97cAtkZMs5FWrb9wgTeW8L1bH30uZNjMH9ZYFQUpEfvOdfrSclDzO
+tefZv/w3b/+VC9LJR+I+8P615/s+VqDE49tqbbveTfbgsa33gc96ykYe31c
x/grgK71phhJQTUUfvS6hEW1hvFr1122pavhkguW5907ABZ+S1vxkpiHTRaq
dzwLtgTp2/Zm4vnqKD5/6O+EMBOmz0bq91epYdmIxYIAWSbnPXGnTPjNjl5b
8JtcXsMlQEL/MwZhtHFLjv4jRW+eiEWzoKex4MEaa22s1Out2azMgtLBLzr+
dZp46V3s/8wfFpj9ijv36ITSf39P+h32gjI1wdqxwD6Zv4fKmWdmfCWNDjsb
I9yMuLzv6kfW1c+8Yw0HqbidJPdgmoiff+83debt6+gDDjZz7jlUqU7mYOvd
0ertn2U52FNjPDPpKwMWrssQnbRRxyKu7nsWMkwosgsVPi60AJPMvYPMn7Lg
7SmVUuvtKnhvicrW/S4q/72v4ctRmrs57Hpx528knzxOHPJ/y/vCHIqGgWy+
TxEb7aueG97RhiNPK6ayx80w5T/vm0YLOPtFM3Vcw48rcvh13F3iscwRFuS8
yrJ5oKqKAWsHh+wu2kCc6djOmwQ/2667t6lL0YbDv1kCza2H2605/KsrWZZ8
eIPNf/k3g39yx14zTj8zt7Ov5ZUbDRJVxu/DWVWULRtTNLAGEFIKc3ykqI6H
uDVKAwTnwffl7afiGVSkLJ9ooJIkIaqhSkJTVAnllxy5ILjLCuyKMzOS2hbg
XoMjJm/ybDjvebOYbsN5z9ujlLo79JUtp14/YopOjgXYcup11/j8WfxvvXbq
sOmfVrHj1OuBbbaz+N96XUKxPqA4KADmp+JpHbFUfGk8KnGdD4Aqlapo2KCE
86ZrbKVV7eDLeN2Ndk/ArLCkTdIjuhx7r6ksWvPG15CDG/OexXzV1gWr220/
pMmq+IlhvCBxiAFlMftDa8+pc/5e6N/36n/j8d/36n/7sX/r2/qVD05cXUXl
nM9zXULyzBJbcOQSsvjSK459irLHD5szgWLSYH9y3gJUfSTP/WGCARvml6fZ
c6njNg9pKe6fDHATZrTNOaiCu/fyZx+TY8Ik3bpAWl4FvWbfZ03+q09uM8P0
ui3Yu7aUFRHz283LZ3kuqtiC0sGyzkSCL8d7RFuzxOwg1uah2TYCOzx47jJN
1G/T9ReerSDmwcjc4j3hhDyaH4x/TeoY48Q8Kaccot/u4H911CnYGI3LpFB2
LXD8u/U/+Z7H4vjXemM9L1+eKkyfCdBNsFbFj2cPBN8h5l35k7nejySo2MX/
tO9XvzJU22xYqh5Fw7C569cfXSwAKQ1hL5O45fG2y+iBhh9zYKXuVJOWpwKa
ocH4+kg+uFx9jjp0XAGzWYvuh+QyOfWDjRn//z2cbAfnjG7M9gebfI41K5vS
Ofap+70v9fQRXVhku+6wXZgqej+fI/ppty6oDr2lO+qr4g8nGffyVXz/7c+P
jlqtms+AZdGqv3KXqeM3wXtPvHkZUH0532gZwQ91E4ovpKYt4PTCh3kuRgRf
2qVHD41agMTNA0vj5dVRoD6q0XbIAr7P5fpoPlcd658e/Oo6YAEaTvv7Vg+o
oXL5gSbTQQuQCT/ryWhQw827U1S6RywgZosZRaNADUkRTGvtCQt4NbEkfcV9
NZxgOEvn/bWA+mnf6+8vqyHd1lJQXogBMreej949oYZNF2vOv5NggMXLWs89
B9Uwirqf11GVAenqtY+e7VPD3W+Z7u/1GXBCfo/qg/1q+Nz0uNJHCwboH9e4
pXVMDcP+Cnx5togB0xYDJu/Pq2ER/76+vmVE/Ak86p93Sw27mkmuP9yJeFhx
S2woRw0z1h5Q3b+GAW8qjfbtIOZB0tnK99brGBC17rzymm41dD5+bjV9LQPk
9669tntGDc07XQx8VjEgQHk/BBLzvaJZS8XvFQygFd/Jl9dRR/tYgacSF2gQ
43po3SlxKpoZzfnueY4GCtUNG7cJUbGhauTiytM02HVzk/Rpbipqnuo4qHiK
Bscr2haYThrhYOH5iUoCU/1Vwj4MGeFDfyuDZWdpQHMqSH39xQgz7Tfvv3Se
BnYvf3QFthnh9Obl6/2u0ABthA9LNBqhieepZbFxBBYzCRasN8ITfn/nvU+k
QW/Px6Cz1Ua464NOxOs0GmRJNa0rrTDCt7Hsv3/MWB5wsOGVESq5v5E8XESD
o6rs9fclMzEhr2gg/Zu9f6Rmr2tOHQ32G7DP1ynIsOtqpEGFP/v+n3XXtZ62
0mD+T7Z8jneLgn5/osHQEbb8l+wCH4R9psG7BLZ+x3YraOh202DgD1t/UVVh
0mQXDULesu3jnT2ZNdJBg9u/2fb7bv2z16SFBreOsu0bS9HolRUHkPEJ8T9C
9Bf36rK37RUG6NrUXBB+joGmhsrNlLkAiUff6L+OZqB9k0O43BQLDK84BZ2L
Y6AQXe648lcWJLTYpNvdYOD304bfUt+zQLQ8d2DgKgNFG9Y7Kb5kwSqW/8bW
88R6RXDXc6J+5tmVar8OY2AgXug+ns2COarZQdW7GLi67+1C+Ycs8OTX6FPy
YmBe25o71ZksEJTu2kpzZqBGyu70QIJv0h06ag4yiXlIgTZ89AULBiZ4Ipbo
MzCgKYMhU88Cf9e5ouVqDGw6VVgt2kmcN0rfUqrAQKZXnhP/DxZ8iFvQjfIM
VPoz6OvAA6BQOunwVpmB5U/mGSkJAZi5pgnc0yb6ZZEbY/5iADWRi0WO0Rno
4dF/LIkCQFJOoG6yZ2BKBDYdlgQYyOU7+GcVA8ffJWlVSQAkeHubDPsz8MSU
Xft1wr4OIrq/Sg4wcHlC0rcOfwNYU75I+su0JVLkf+efDjQAEd2ki0rfLDE4
MvXowBED2DXRv6el2RIrfTwWvL1qAHbaQWVbqy1R82LEmHOuAUhRK+vev7BE
d9/uX4NNBvCklTx38LklWnoeNO//ZQBBJ3YYkwqJ9SVLPIxEDcGKu3sPq8QS
nQsLljoqGgLNR3SLSI0lqm1KTJyz0BAOvj+ak/3BEu2NIrxCjAxBwaaKRemz
xPR5a59xmxhCSC173jqrxl5vXL198LGIFZbYs/cXFOful1K0Qt9r7PN/ampU
FOhYYYcC+36Hoy5Pz9KscOXkgVn5KoZeTT2xsEIqH1v+xDMqWq0EjqWz9fu6
IGD9D+L7XzJs/adUS/28da3Qz4Ntn5ili58OEvcp//01az9B0oX41PlWWB7P
tu/5kGFK929LzJP38FCgGcDq+AW9B3msMHNnvuewhgGkirWKKM+xwncKjgZJ
0gbQryW368RcK+wziHWxFzKA8eeat1L4rPDwZXebd7/0Qc7JlxXJb4VX/b6e
cRvUB5PcQ4IGAlb4KGoqq7pdH+yubqi6SOB3LymLrer14Y6T7+ZsAgtMOxza
zasP6gvYeC11M6X7px7o+LO/n+8ZwlzbowdHw9nnqRnyH29p0oNaMvs+SnT5
Hv9KPZA6ypZnMJlyVbBAD8K/yM7Ka+55bzum68HzVy2z+jzN4Au8nKAHP5zZ
+nY/YeMGhugi5zFL7N/C/j781Wql1B+W+DKPfR5kyhTajVpi1j32fTQ5kSjl
75aoYMOWRyzy9SBzxBLnBLDlnVDNV4sbtsTeRWx9vlo3epsR+KWI46y+5yJe
V0oR+PJHtj34c9iYlci2F1cg+/vIg2x7pruzz9t3j23v9WXs+04B2x8UT7Y8
Gbpsf6WOsuXddJDtz0Axz1l9OjXY/jY7x9Z3MT2vpc5fD+rE2fFwIn+jsJaP
HsinR83Gi7pjzqJSNz14+slxNp7qAvlutzH1oOdhyWy87bJ7U7dJUQ/Ek7bP
xqPtjtDKF790IeiX8my8rj3YGVHWpAt5rux4HmRVSDvn6kJ/44rZeJ/x/KKn
FKsLP/csmM2HleLSYUlHdeEhDztf5gXZ85Xv0gXhq9tm8wkKk1akb9eFx/+8
R54+z153PVo5m48UB/b+ndLsfK26yz6fljV/Np8/XmPf37X682y+27ey5dv0
LWCWD7bWsuU/vZzNF9wJbP1sHlXM8snNZ2z9DXN3z/KN4RG2faIj2XwU+p5t
P+VX92f5qsGUbd94bzafcd2qp3n128CWjEyPLaISGDuv2fLdZxtYlm08fpMk
gek/5xrtabWBkXUpUX1zJHCL2NLlWe9tIKfSn07uo+DRF2/lx+sIzCdeUVRC
Qb6Y8YaEahsQ/NXWuvoSBf2Ka5qGKmzg4fbLaf2rie97qo6IEfhxzUX1EXkK
MgYr95EqbWAs4ZKlVCcZqd57RzuJ/f3H3laJppJx/5Hd19zrbWDyyfv9TqFk
pP147aDRaANUfjz62oWMyTcGNk8S8nXqkFy/m5LxlE5B6MZuGyjT3++5XJeM
FZInmr4R+qnpF71PMCCjr71aucIPG7BqTbmdZk1GVkpYxbkpGyDtTdzguYmM
exm0pOo/NhAaHvz3cSQZPxmuvnGeh+j/8VAw+QUZ/+LykJg5trC9NOwp4xcZ
74X700sJfEF84Pp1UwoeZDSKUHhtYbP9XfG9QRTsCJp7IvGvDVzq0G82SqHg
hss+a+l+Y6xIPxueyyKAIh0BTXfCf7Iu7+xx1xEC/LngmKwt/mCFSX1YO38u
YNjmwbgOvR8sIa9luqozLNynMpov8X6UdTTspKf1EAvtE278eFYwyrp7vDE8
uJ2FfsEjL/d/HmVd5MnfUV7LQn0plaTcxT9Yur9l+xnIwvATEt/yvv5gsYrq
j9XksJDrw+4quZyfLK75fusdH7Bwc16Q4OmEMVZQU+mF5fdY+Cldd3Z+Cui/
HmmfyMKswz3eB65OsB58Y6+fGui58+XYJMvKiL2/9aLN8SXOUyzqCPv8GSn6
y6X9U6zz5nKz9ydnbLl/2mWa5e7Ali9409NQ+/3TLMdqtvwvn27K6feaZi17
ydbPxWfLGxX+adbOBLb+N7LrXYqCp1hfjdj2MWZ0R3s9mmSNHmPbb0JwQKy6
ZoJ1aw/bvon3jeeoCJBAOFbQ3fc5DUXaZpjhlWKwquOcoEM5DUtV5lUGHReD
377W/H6VNGyK/eN4iUGsq78+GVJBwy9SOUdsh0XhbtGbyfASGmZfbFmlf0AU
rsifCxPKp+GdnmhnBxVRuCUrqPg5lZjHtlzvzeyfD3ktzsEG12kYcO9k/OO2
+RCo7RRqf5qGD//OOx48OR8i6m8MxYbQMPRYnFuVuShMpj/sj9pCQ1Vh132h
8aJQkrXkcfBqGvaLvXFeIiwG8vuc3DyW09CG5qUqsVIMpPbyCQ0voeF4SvV1
3jgxWKu50fr6UhqufOyWvKJdDGiu8q4OLjRsle2tOiZDgkWPTW6eWEvDub3M
i032JLgjXNt2xJ+GC2RlRTK9SWC044GY1AEaDlM+RtZsI8HS4qrgyQgavsvv
2n52AwnyxI935tykocypnSGdViSobi0xb8ugoUaIQfaG+SQIz3h3W6uAmA+L
7STzTpHA3rBQLOUlDRc2eOaeTyYBn9i71FzCvqFZC6tGX5FAWvO3q/BrGi72
farb8pUEthdteNPqaRgrodzK5BeHKgXlmIvvaPjgVQ73fA1xEAh8V19AzLt9
srI/7ezEIW3mla9OGw1r0lZYNG8Shy+8Y2NtnTSsWnNbf8UMGfINp4pfLqBj
gtBYOF2WAhsd1tY8W0hHUYOh91vpFNC4vqVyyICOHS9UXJpdKPDk5FGJTTQ6
TqZPe4YHUKDs/Olfogw6bnXbHr3uFAW+bFiXMwV0rD0Z+WXDLQosf7fdW56Y
x0emNfcee0KBlGIH+b3OdKTuEVepWE2CH20Cq7nzaBhi4Xzs7g7CXuYLmyMe
03DO4o6uzHASKGtddFiUQ8NMVnB6TywJDC/FC+s/oqGAVYCpdQYJLrl8PGKf
TUOJh9/f5JeQQLaisycqi4Z3r4i/sG8mwU6yzRF+Anfntdp0D5LAnS8wMCuT
hmbSY4NuimRottxgxkynIcM7mvHLmAyCYncTJAi8+EVQxN3FZLhSJ3NKicBn
+laTHbzIcC0mud+TwGbLLgh1BJPh6NGZ52UEjr3yJ83nHBm8AhKavQh/139f
ZvbmFhleHvomovOQhscK5k4q5JLhtou2ggZx/9gO6sYb7iRIYF2JSm+koS7z
mQ+XPwl+Tlu7jBH+Ktvgu2n9QRLsl+Hf4PeFhm0uvtHpkUR8dP7dwDtIQ/GY
Qxd740nQ8a3ke+lPGsqbPrISTifBxGGllOTfNPRy+9kh/owE11M/CaTPoeMG
gfPzJ1+SgIZXLtYK05HO82nHpmBx+Job0SUcRsddbs2KKmHi8EF4yZylZ+go
/Ih598k5cWhJP7kw8SIdb0bZpapEi8PcZ81PRK/TkVG3znJdvDg4ujTxX7pD
x5PplGqfu+Jw7/rnQLUHdDR6MaBgnioOkS95oewRHVfMEfBuyhCH0IqnpbsK
6Ggrm3LmbDQFHP6GqD9eQ8c4vivfsvdQ4LSSV0TSKjo6aZe8c3KlQIiAaedy
NzoeCDIO8jGmwJJbI0bZK+ioW1ZTwkOhQCmJfLvaiY6y4uY3jcbIcBI3+Nx2
pGNz0dsH041k6DLa/trQjo4TevE+vk/JkKJjxTrCouPUEaddwwri8P6PeUjM
LyI/6ybkBLnFQa+3ye/OOA0fP/hT0dxNAt+rr7fv+E7Ej1S1s28lCRpTc5R+
9RP5pDtqV/iQBJV30sydemi4/uQxoc/RJEipbzzm/Ynwr+vGp58I/1mtffWW
9ZGGDe1lWkWbSfAlsF+6p4GGsmJneiVIEnDWUGPohg8dh64zF/7Ul4AndxUP
Mwl96Y35rN/rJcBT8jf5pj0dzySf9vOLkwBrhcQd75mE/I9y+706JOBR09J1
D03peGrdz/g1mpKQ7N2acYnAZW9Cgi8HSIKEhn3mMeJ7+DUpfyBVEgzcnGek
ifMMeOLG9D9Igvi9wKTLrnTMvLTBu21CElKNf4x/2EzHqFMJXqK8UiC8reDB
7RA6Ov6oEeqYkoRL+9UL95+mY9a8n+KCbZIga++RNR5L2JvH+mrbQ0n48KF5
tOw+HYPdtt4V2yMJ+Ute8Vdm0vFKl6T+Tn1JGHnzy5aWS0euhYoX9/VIgEeo
o3McgU2dbhwevS0BKxi/BUay6Mi/N+1w0GYJcORytrmaTMcjylv8e6jEAKrn
/MspjjhfaJOyMVkCwj1M+Baco2PVlfrLn/kk4LcBQ21bKB2tuUQifs6XAJuS
LT5nttLRpSC5mr+LAocOb9vQR9i3b+fryHmNFLgyFbzIl4gnndtRHx5VUaCx
/pFQ1VI6zvkUDdxIgYL6UGUKwV8kQw356VwKxPB+4HKwoeO8IalLt9Mp8ElL
V8/Hko6rw96en7hLgUtfruntMKNjvvjWSu54Cli9vXZxszGRT+X6YdOGFBhq
PX6Bb4CGll779z/TpsC+a1u/9RPx8/H6hr1UNQow+RoaXhD87GhIOu6jQIHM
DvvBs600bE/ZuXulNAXOvohuXtRE8Iv9juYZMgUc2zYyJ94Q9XVPPNlPjAKL
QuNLbtXQ0LDiic1lEQq83MQlbf2K4Me8V0It7QSfd/yMjiH8mbjLYpffGwo8
fxZZVL+fjgO5kqs3llLAsERbZfAwHY1HT2u9ekyBy8qtQd+O0VHuND3kzn0K
fL7xYk/ZSTqK72ue+RFDgaJ2/6FDZ+koYf04vfQkcd5B03zSeWK/j2SMRAgF
FCMLs48R/CGcKcPFf5oMM27Z5k3FdAxyKVz3KYQMjjEiy1VKCX45pxVl70OG
E5+tQu1eEnz17rc0ayUZ5OeEPmVV0vGzNvNeHYsMLld2qonX0LHI6/jEjC4Z
zgslNTyrpSOPrcVUnQwZ5pXk/TR7Q8e/Ys/Sl/KR4VbzxaKIBqI+qdfbf8kj
w4qBkDWjRD+itj6mRzCRDKEX3T76PqNh9DLekzORZFBLHNr2kKjP31btLHi5
jwxk86775UQ/dNFzr2GANxkehd4zziik4fFvIzE/ncigzXOz2qeIyHfe+qSt
pmR4n8c0GSDw409zF1SqkGGoVNTWtpiGG48O7l/9nQTbI5UPPCH6o/W0ZbqP
Wkhg8ayF3E7g5Y2BrYIEP2dN++i+I7BYxlm3rVkkSDNpenmdwBsXu66vjSNB
2ZJjY/oE5p7TXeB4kgTd6z99uPKChhX3rxi0BpLgsHPMvQqkoVRra+CFNSS4
G+oe85q4v4zEc9SFSsT3c0XnulIa6mxoLXS2okAxULauJPq3Pl253UmLifzw
b7w9TMQPaZAitNqNArH+YhH3ifiac/O4vtcGChTSsx4EEfVKqOPS03xfCgSR
1h9xb6FhoVPT8027KPDCbeSwE8F/G57ZHlsVSgGK34isB1G/BAQOVm34TAGf
9XPlc3QJvthh+CahjwItd1RLXhsR9cR46TuN7xSQNMlrmqDT8XX8tVc/xylw
d41NkQHBX6bqjA98vylQGfrz7R5rOi46xQxayyUBQuu1AksIPgv2FDH9zisB
IiUDvTJEPfgyZ5T/FcEHkc1nroS60PHRa5cdUtwUICe9P3KN6B+Wdszn/VNN
hhEZc4egJKKfjf7+5H4SGSrc1vKLxRJ8363iIxJNhqUGOXczThL+/fas9VEM
GdKbRCSy9tDw6VVj1+A0Mih9Cn55xpuGUYMX5l1pIAOz/NiPWFca1sqlGzUJ
UcCLN9pXzJGGnXPeDb5xokD9XbGudqIKa/PgdjOi/k2Tf0nHWhH2uldzakUL
BXQ7mzp8rQk8PLh5q7wEZKeqbZVaTENP4dPnrFdKgPm5Ix/53Yn+9dwDqYuh
RP04v5Js50PDIdewIFakBGhZzjW/QvTL0+GrfQoiJGBpwte2S0Q/bRDZeGL+
Pgm4XJgQVnuN8Ifmro2dyyWgPjDO4GsyDWOMH21bLSMBx3ZyDd7/z///Phq1
r6GJ6O8iyJEyRD4Immb2XrlIgTfk44KpRPy3s1ilK4h4mZrv+0aJWE8OkPJ4
wU8B62Ofx7OJ/WY4XEEn7G1Q87Oqgah3uq+YO/AvGTJ0wkUuE3xGa1klQCL6
z7a1nQ+WEvFxt6lkt/YUGdY8e90zQ/Q3R+Q/dQn9JMNbHlf+JKIeH1x2cTxv
kAyblFPcrf/S0OhUdopBDxkyuQSVXvMT/aVkmPu+NjL4qF/ItRcj4iHzmeCu
NWSI7oq1mjpFx9Qn5B1nV5DB3Zc0vf4CHc3yrt/Zt4gMrx0azdKI+nXOv0DJ
ypwMo1E3NrbfouN++5vPP+mQYRnTruMnUX982r+kbFYgQ1Vsps4AUc8ao3cE
VosQ8fH4xMsXT+hoN//tD/kZcVjfOW2xh+C3wSSbqqNB4iC/9diBuS/omNf8
rFzWSxxePnj75PlTOirmiVQWOomDdaRI2mKiP5pbKnJ1J0McHpdRHjwk+qc3
RyevU3WI/qvARWookY4v20r658uLQ6nm2EahG3Q8jmFLBOaLg8pvYy6+K3Q8
Idwrp0b0Lye/hIV+JuphunjM86euJGgYPqNxX4qOezB+3rQDCTqvVc3xFSXk
9zY7vdmS6B8no9pF+f+TT4bHpoxJkNvPcEn8Q/hzkfRgkQ4JgtwsuVUI+6/3
2+iVp04CSWGj61GEf7Jdzwh3KZJAv0OscrCb6CrFdlTYypLApm3NImvCv0ui
g3kGBsXhLn3hjq5qOhZ+4L654Zc4iKy9bJv8ipAnekHuVkEyXHcd+3SO4H/d
1Y+7/0qRwXTM5kIUYT+70rnXFmiSoWf/+qgcol90btgs2kAn+N00l/yLsPcS
wTMbeR3IIBL3dfHWx8T+ngWh2avIkHZ204pxon9wvaEqgosoUIM7Km4T9Wtw
8khWjwcFjoWRcjyO0LGkmHw0zI+ol9RPZ40P0pF7L+vn6QMUyCAlO5oR/cMh
ZS7/iUgKhIZntW8h6uWdvnyJSmKeYc7br18YRMf1/DyUiUdE/XP1E2HtouNG
8/CNB19SYKFllO3ADjr+drAR+VMsDi7dIY8ZhPwC1mN+wS/EoeFE7+7DhL//
6n58rVZG2Mft7LvSVDpeMgz0mVchDhrj8ddIRD+d1+/yQ/u1ODzMkAr1v0bH
p0/vdBxuEAeliyXatUT88oaH6c1tEYc3mZs22hD9mN337LDCz0S8RbZUVhD6
4ep9NWVbyTDw+i1ICtAxYoWif9ouMugs9jyZTeTPjMs1k8KDZMjxi7b3mSDm
x4S9eeNEfY5SqVM0GqZhwYtoGTeC76jBGrdlv9LwjbaT3pu7ZMiTLnBV6yD4
aU/ZVv8cMtB+f8l3JvqRkSmvLqkyon7WBdrF19HweYLjVC2Kw4rFcec7Wgj5
dBaMuwqQYf3l3dTeNiJeuY+9erSEwAsNWB3ddGx9OXHpWjgZ+pUOPKSN0PFX
SMqpswS/PlizJZvnL9GPBu38ySwhg3TJ6FpJMVMs+laU94m474Fz01xxVVOU
bzt03YqQZ9Knf9sJY1OkvPuTjVFksBvMX8xva4pkh7+ubgQfmEx+V1q33BRT
NJvH9WTJIHmzMO/kKlNcrc1oCyLse/YJK6h1jSmmx20LqIsg5umapaVynqY4
J+xSOs9icRBspCb7rjTFkCU7lviJicOPmeKyxQ6mKHZO79K5HhJ4GqZtSjIz
xYfzKwzKa4l88LAgP9A0xUPbVe24qkngpCecmC1hikzgMzlL1P/oiypi+nNM
sft+4z7hvyQgvbr599RPOo7uPNaYRRWH+qG5H2e+0tH38u7PLgSfZLd5CER3
0JFv7k6R9/nicLnNzXmcsO8Zg2K/A602MBh8b7v+f/6/Y1T0uu42G3BIeZe8
lB+Q1M+KKuy0gRG5YarrHxZqqqRN5H21gTLnkOPtIyz8sz2/333YBq551EQ5
f2Vh1Z1lgzMTNmDKLVXm08VCuw2PmTNctjCasmv0DIGVMg7I3BC0haIFX6lP
iO9vbDWO1iDZQu4ZcfWT31l4Kj+peI6ULfyaCg/S/svCa8pyioWytrA8Z+vf
ckKeapHjS3nlbeHAFPv37acy7PU0K1OPqzKAHmns/QpB6+JfqQBqubHPt0iK
Lr2uBdh9lX1/t8vC52F6gIL2bPnund3SKmUIeOwsW/5LHpd/aBM4zp2tn8l9
06hc4vs989n6F6p9Jg8S511oY9tnnpnGc6oqYOFptv3KZSszxGQBNf6xL7/z
1Dc9EuAKtV8Z9S8EQGl0W1X/IgXUfPvtd/aIADRmNCas91RAX6EDV8KlBEHw
Mlm3cZcCRm6vuNBjIggN+ihxPEIBH0YZnm50EISgL932ISkKOGJrUpyyXBDo
A7gi9aUClg5nK0o5CcKaB7+Pin1RwJppzURrS0E4cuGDRxyPIv7exWeZoSYI
N3x3SlkpKiLdQprK4hIEW/dAgTmmihiVWSBMeycAr2QDVeY7KeKBko/hMncE
YN/m9vpb6xTx2w37u3l+AsAVonBV3U8RdcClZq6eAGx6H2xC26mIXes3TiuM
8IPW17UrbhBY9q2wiMpjftC/muLh6q+IEeczHmgd5Af/m9fjIzco4h3Z2B3G
DvwwxYh/krxMEau2l/GSZfmh5lyynLGFIi4ZU+5cO8YHFZ0HFXtUFHFs7xXJ
VR/5QNNzf2QcnyK+vfqoZrySD27vjhZY9E0BvfJ8Kl+X8cFcVzw4UKWAzVuN
f317KQ9PFuty3ZxmYPQSAwnLz/JwaE2RxmUuJlJbueKWTsuDW8hUSB0/E/kW
Py7QnacAPJZD7+aJMVGXJ3UeXUIBvMeWy/2UZuLw6x3GPNIK8NFOxlNflYna
V8d/BJMV4Mv1JO/1OkwMuVBv85xfAZTnhxxWN2FiMY/EgWVj8uAlsF1Ah8lE
yUV+GV9a5aFi4Pm0ki0TG9o0XEOL5eGwhKpkoSMTA/xaIgwS5OFBPCW90omJ
TuLq29YekAftZNWP8suZONa6NnuLuzyk7C/SuEXgmOXtF0sN5eGU1qKdS5cx
MXnrRH+PiDwE3eqSNFjKxFo+xVKDITk4JOpw1t+eifXkVy7tb+VAtfb4j4XA
xHn1fwP4CuWguOqS9yMzJqqzViWeyJCDtKjsRUsNmSiUNXxi7J4cZNZi8BJN
Jlo0nQ/LvCsHskoXm4QUCfmWcu0uTpWD1Zd56r9RmBjr55089VwOltpeK3Gv
ZeBqHTtaf6Yc2DAdfq6qYeDIXHNtDWK/fOy0mWUVA/fXqp94eFUODiZcM+er
YOBGmWT9M+fk4LNZd3JOOQPHjndO5B2Rg3y9RVb2pQwc/r0o2mqPHAQ+Pl9c
hAws27YjXtVPDtw3Fo4rFDFw9FzB1h21slDS8DIs5BoDLfUWeWSXykLQcBU8
j2FgKrn43OqnsjC1lunTf5mBwjzXbLZmyoKbgNxr3osM9JSUi2+7Lwvtkqd9
+M4zcH54SPSLeFkofrlP9udZIn7uv+STiJaF3Wa7vrw+RdzfbJH2MUIWqtSp
JdHHGZgjU/jG6pYs1L69uCnxCCGPR4utc7osNH3oNLgdxsA1h3qWixP3zxzR
738WzsA3OdM/z5bLQsK+i33fTzCwzy90SdYbWaC32R2yO81A9z+Wx461ycL/
EXXm8VB/3+Nvs5QSKcuMGWMGY4lqmDEMM2eKkkgUWkShRbaKokWKSKQoUsga
UhRRhOomQioiayXJlq1kb/O772+/8fnzPO7r3nvO85x777nnZtrd+6UrF8+/
I6ilc6qXALd3xznrXeCgYJn7H5aNEqDsgatm60XMe8JpSXU4EWxXO6YG5HPQ
IutW6rlrRMhQsf/CKeCgZI9dQ59SiEApGni6sIiDuKfPseqyiFC+SNx2tISD
hl3nfdz+kAic6eSnw085yGDW7c6jT4mw3SJ3/jzM/+GHrYdplUS49bGQq/4C
z5/Z+XpnLREshsd3O1Vx0MGOsfv+lXJQW8Q2oftwUFx6rp5MtBzwl5yQvn6E
g8LZFkvcneXg1iGH7csPcVBLzgeGqJ4cnL5U0U08wEGlV/P81ZbJgTvrSVr5
Lg6y3ExqzP4pC+Wf8T3LmoOqGktNxvpk4drk2Tmb1nNQiIVCU203lrO7Tu83
wPyOCl/xGZIFVWolil3BQRv5IWWBs+VgXbzvVASNg4zfshiTZDlQLB/T6ZfF
86+KXmduLAefztjM0pXgoNGoDweCDsuBg+WkZO98Djqp8cxr3U05oMasWGcl
zEGuv52//GmSAwi3W58mxEFX4w9xpxZgf30xXdonwkE1KZnoij4BTqY+PzVn
EQc5jFte2uJMAEP5oOrbSznoumLIVYlgAhiz3mj6kTnI/mS8nUgCAX4oP1oy
ocZBd5bpmf28TQDhONJXfxYHxfQ85Bni+AlXbFh0aA3mn33v0NNkPL7DIi/y
Jg5ql+l3vZtrAKlMrxwrMT5qdoCzrXcNoGHOGm/mUj4ayv5KUc0wgERyUoCt
PB+NrpXayIwzgLmiO1slaXw0lj+5ZyLMAEKDc7e00vlozYZXjhnHDSBSZ2HR
RnU+4tfNKru13wA0nD+lGGA5jOG9wN3WAGTVbgak4e+ri+csszExgODj4qFP
qHyUt0T+yXUDA1AxanQcIPIR10B7thrTAIwW58oXS/HR1Han9HjG/34/S9De
G9he3jf7f/2FLYr9H03BzPjpsoFbe37AzPxLDww6zBqCGf1mr7jPc+mHGf3j
7INUbbEssC9lYXt49SDM2K8WpiMahccT8An3HnbYiOcT8LON2OhxEOsj4Ht+
J5mxGeu7SebjR/Fm/RneJg6Mcf0G/Rne9tnvL4e81p/h7bxWCEU/05/hvSe/
r8n2vv4M7zzTJ+9EkvVneOe+/cGcf0l/hvevVXtPvvbTn+HNKR4NfuihP8Ob
tkR85U9H/RnedznKXud36M/wdtluLftn6/9+n0zQLuAt6C/gLRhfwFswv4C3
QD8Bb4H+At4C+wS8BfYLeAv4CHgL+Al4C/gKeAvd6Jb/k6cGgvfcuPR9F0xj
1EDwnuu74mX+31NqIHjPVStoMrrvpgaC99zejddEr+9WA8F7bsCpwXvu9mog
eM9dK7c1dI+TGgjecxM1ucKaB9VA8J5rWhyvNRioBoL33BbjypfbbqiB4D03
ePctRkWRGgjec62T/v2+m+A917O18Ub5lBoI3nNNex8Kacuog+A9t8GuIzlx
pToI3nMfvYaXDkbqIHjP9UAqa+mW6iB4z+1lRVIUbNRB8J77g99dMWKlDoL3
XKOC9LDWdeogeM8dpOQTLzLVQfCeS7ksbbSapA6C99zJsJi8S7PUQfCeKzek
7Ch3kQ1jVcEZ+9VIyFZS96jUOTY4L90fVbyfhL4W0Y8Jn2TD8nk3ny5JIKGR
TkmNF+5smLh8TfJgOQl5WAYlOu1kg5i7Enx+T0InpoZeyZqx4XmmtFHhJxLK
XXhx4SoOGxzDOefv1JKQQdMa8+8abLhiwz/4/h4JUc+ceHdcgQ2tqwYLS/xJ
6Mn75zufSrPB/Dbn8Nc1JLRI1cxgzxI2zKlkjr+fRUILJe+8e4plmZU/iNeL
5dFjxwH7Shk25Mj1i206Jo8oL0/vJyuyQTr28NdxrjwKe2u9cLEWG94kINQv
IY/6Ip7ZpBiyoaHTvCnpBxF99sx+l72RDYtdFqZs7yaiIeTQ1+fABoZop9W8
QSIqfNFovPggG/ZLTBmSheVReo7RtS4/NvhJSO6vWCGP+tW+ljiHsCH8+2Tw
573y6Ln+rcjnmCe7fUmpWYY8Gvy1TCgkgg0Zb2SLWAPy6Ne1oJMZaWxY8OPT
6RvSJKTYWXPb/g4behfdpM4jkFDUbhmbRbls4O5cLKRLJiErdfOHuQ/ZcMBI
qUmHRkKnfOOFTUvYwLlhLPpbFbcnTga9e4b9YZFfGbqChOLqM30sKtjgUkBZ
8IlFQqevNdMevWLD2hSL0+NcEgrII9zZJasHdcs2XqE+JKE/T7c5FJD0oGXV
2/yfT/B9Y5WW5xRVD16k1xVHVJKQd0e0jrKqHqxJHkn/XEdCwQ/DJPQ09YAR
Yqjf95GEKh+dd9Vm6MGpCOVZGTgfN/8i+nCJrh6stE8xXTpOQnzbv/sbOHi+
HZt1tOaSUU21YeQ0bl/yeVqOpk5GmadHHE1wf51yjm+JCr6fzM0quL5cD9qO
1Eafp5KRr/5R2zEVPbh/sfh5GImMzAZURHYq6sFnZuzlMhncXv7yXB1RD5QD
NeqYkmS0IlLuqq20HuQRn0Z8no/vE6/6vg5K6EHjygjCy9lkZJJ7y3FtORtM
H0eKJISS0OubLne/PWXD6mTx7vIzJCSvHZ2QXcQG2+WLPq3wJSGbAM2WMw/Y
mM/ASJs7CRnd1f3jnsOGPtOUXY2OJDTnjl6KF/Zf0uqiWDlbEvI7U2Qblc6G
AW/DTVmmJHR+UfnNt8lsMPO5sPeyIfaPjZqxq6Me7HLsytTNIKNdnXcNV7vo
gaEERVGviYwqHQ5elnPXg7emwgfMFiqgwWmT9CIsE47Gd5xao4A6QqaD5V31
4I3468dPjymgHOFjbs579CBeof66WJYCSqwNy/hipwecr822MU0KyK+okSRl
pQcBIRn1E1MK6Gdn3eULxpj/7620FFEK8tO8RprD1oMsbuVDWXEKqnRBRjrq
enCpfWpcchEFzd0lZt4jrwdXXEtOxAtR0PuMaqtmzHPgWc5No+8KSAbkqu4L
60FuxD7tFy8V0NxkhVHhaTbISWYW18UroLfVfV38n2zw8lOOmtivgCKjEz0z
JtnQIzckKs1QQJJ7YOdG3B7bdGS//i8cH5NhqxRw/+Iy8eyDFWRkVDzu1YDH
p6RKaVy/TkbyqoxTcyX1YFnE7Ts8b3y/PbHyiiyO38qeaD2fbWT0x0n8636s
v9vF8pQSUzK6G61t+nEJc6beEbGlbVXuMuZMvQMtZEY7kZgz9Y4+X7H9NmrM
mXrHdXGVTVFs5ky9Y+Vxq82d65kz9Q6lEdKPjh3MmXrHe6wX2Z05U++onyuf
zDzJnKl3ZGbMmRw+x5ypd7zy6c93vMScqXcwrIoXf4tkztQ7Fh/41y6od5iE
/+svqHcMthH/b3xBvWOP87/5BfWOe6X/9BPUOxLX/9NfUO+o+6z8f/YJ6h1n
N/+zX1DvKBrW+T8+gnqH9Np//AT1jt6of3wF9Q51vfsPDn3VhhavXQmRLRzU
2KxH0P2lDZUeRx33fuCgB5t9m46L6QAzMvSSXCcHmVgV/xiS1YFx0dXzF33n
oLmN1ur+VB14HvV334ZpDnJZYUHeR9eBxx/m34r7737uXC6xGsuk5YuNY/F9
fEtU5M8l+HuCqPWTBm0DFJECG43weAv/qOgPrDZA4huMPRIX6IBVXWNPBr4v
r9YtCDL4qQ3Zy8+2yNgYIJ/6TYvderXhM3G3bepWA/TjHaU5rlEbImoTFaRx
e+0g7ZbeC22IG/ePuYn7uyWs7Y8u1IbF51xievD4mkVrH1Te1YbmxN2qtXj+
+0URpnGZ2hAQc00rCusnu33fLx8sS5dLXozG+keWN8Tvxt9PJL2pMMb2WZw8
t3GkQBvOrnKwEcX2WyxaeXl/uTZ4zD+kLo35bODYiWc3aMOy/R8inDG/09T5
jw73aMN4WkLQf3yfqoyPO1VpzOSn9x4m0Uuea8zkp++tRnbZ5mvM5Kc9Z9cW
H4rXmMlP+3ZJ9o/5aczkp8HhhZ3WOzRm8tMzcYoZW3U1ZvLTZXaiOp+Xaszk
p9EeyuvzxtVn8lNn+a1x+p/UZ/LT457Bittq1Wfy0+GsbleoVp/JTwXtgvxU
0F+QnwrGF+SngvkF+alAP0F+KtBfkJ8K7BPkpwL7BfmpgI8gPxXwE+SnAr6C
/FRvlkXwhzYumCmy1GIV1dBhLYLBho9cyKNV7bKbo4bS3v7qKPjEhXnZ2q02
X1TRF73Plj+7uHBBJcA77IUqYvVfaL79jQvVltfVm7JVkUqb1pjqby5kXRVn
1cdiOWJFQdoCHqy5YxdVdFEV9UvTaKsIPLAQlUmzDlVFefZLi6rUeDC3uoQx
GK6KGv8OUt3ZPOgSHS4xvq6KZC1mdaga86B2Hdkq9Y4qmhNXNF/dggf8BU8K
G56rIoOYu+0vrXkwJv2WbNauikR7K2JvbOWB7adD81dMqyKS5TJvL1seLK9s
bzxFVkOPDnkVOFjxwF0nu0XHQA0dfDR56uF6HmxOjep1tlFDg461q0W4PLD8
TNPd6aqGnjVmRkit5AHJ6vK+0mNq6Ira2aBSCg+Eej/OSz+thjJ3mrVISvKA
rl3/PdpfDb1wFvEWmoPnd3N5kXpUDe3OORF/dZQLJs8oD532qiGzYl0v31eY
34vPMrnyuP/a45+2v+DC24E37v2L1RAj95e3D+KCSL05swjzX2W1ZWFtERd4
RssjFcdU0WE7M9e9D7igGHCzTLlHFU1dNzcyyOFCIl2EUd2Meei/Z26+w4V4
sx3bpF+qoqSPi19mpXOhYetYo1ixKnqTqV1O2MeFbY2lb5W66Ei23vhQoSMX
3nnX2VU10FF415LoOHsuVBF7yxVf0JHfu5zj5du5eKM9PMZ4SEfV6cI2urZc
mDJl9s1Op6PaIVejH5u5kDr6sOBKNB392WJhNrGJCwnRt88OnqUjLctOu3Ub
uXCw1fL8Um866nzCP2tcxYX5Hz9KudLUkA+xKNWklAu3H759eUBWDd3e0005
VcyFJ7HdYt8WqqGFgXXyvflcONdUevDXLDXUS152K+QuFzhpSYVXRlXRn2G1
0t23uPD3gGJFMebB2vd265EULijFLkv1aVVF+2qOrCuP50LKGb0j1a9UUcFZ
l6ceWJ9BzQy3lPmqaOGC0De/TbB/NKxPXf5FRz2RGnkv13AhO1mTTRuko++P
LMRbuVyYRXtA2dZGR27Ew27L9bnQp/e1lV1DR0/+iBk/Z3Lh1tpXShVP6Ugm
kfwzcRUXdn3pbRDNoaPV7LKm55pc0F/3+uOcJDo6LH//t5gdF4o27r/40ImO
lkV6Rqhh/kdUT7BPHqSjCypDPxfux/5e/ftgth/2R1C0U747joe3pGVrw+jI
7MSNeWQvLihfSfvMv05H5YbxGia+XMgYXO0dn0FHATfE9Vf5YZ6VQ2aW2F/k
ny1pTWe4cKhkS82OcmyP5sPbLs+w/dxz71bHqaL0eTf/Vpdz4XCSz/qE26po
1Y/G1l7sH7+p3e3GRaqIP1dv7MlrLgQfacrRwfE0svKLnPlbLpi/XFqyB/Md
6vXTuPwO+59yZai+TxU9C4ilhTdhHv6Jisd/qaKIYCEpw1YuNOpPym/G/rzc
m/ehi8eFD0c1ayQk6KhF5uvN14ZckPJcXmr+XQXpxT9qa8Ttf71UaoJrVVD3
C6fPbcZY3s7tbr6vgq52u832t+DCUEwq3/C6CrrksNNZCvP82Ul/vS9IBb3J
nt1dfoALxq8T1G77qiBp/QLr+ONciHTz0fvopYLmX3KQOx/KhZarj/OtfFSQ
674XBL/rXKA8mVNUE6CCPn4yf3MMr5cbg3cLI6JVEL9ViJKC19fTi1KHbe6q
oJIfC+nrC7hgEfdZ+0S1Clob+uvmn0dc2EFN6xDvV0H3TiWGRxZyYXH1t/GJ
BXj9CLVIk/K4EOOazJFRo6PZUsfk/2RyIe1O64DrGjoSHwsZeXUDr1+1wlrm
VjradlZG2u4S7k89ICS1l45WPHOwTfLH6++y6XkZNzp6LEYLS/PkgkKa/cAH
Fzp6lHHs4YldXDgzQKKcd6Aj3+9rppTweoy0DxuuNqejnLv9pdf4eP/+mywa
zqGjbn/Fo48Ax2fuLRcrQzqKdHi1sw7z5t7jfhHh0dHoe4fSLzjea44bDGQB
jkf320OD2D/JC1Jm8VfTkfzcJyuGDbjQrY6Sn2P9pZqb3g1ysL7MXTY6xnT0
KX7dik68PrZI9N2+vJaO5gTLZCks5wKRF5qxaRu2t0N5sYQGF37fUNWK305H
XrY/a36qccHVvf/Uux10FBZx2rhdlQsvDvTqTtlh+xTMKxGdC76N2/7Mt6cj
4aIz9+NVuBCuV3xMGNurPZbj4K3MhfXMzp1DWNa8/Gy5iRIXLLco7n62C9v/
6V7qZqyPVvbv8014/ZACdc9uwjzC60Xrm67SUR9bTISI1/+xbyORm1PoKISo
IJaL94ec+zKa6+7SUZb/B38Ja6xvp17X3SI6ismq2KO7gwt6Co8agyvoyF6X
UkPbjeP3e9nPl+/w/DUn2uv3ciFaNFnVp4OOPsqF7FfH+7WpnfaqpDRVFBK1
b1s83s+/2Qcp5OSpouyFL7zfPOVCaG/WHoVSVXSzM1nuaRkXdPcp+32tVUWq
gf7Fbng9mm8aLp2Pz7fGpK6OBrweL64RP3bimyrym67TnMLrsSl9uEIPn3dW
ezU3NTRw4c/qRYiHzxNbj09bpWhYNtYXHcU8FW9kpv3AcvJl7QwtzPvo47+P
WzCv51E3NI9h/0jxXbdVYp6MqkSld7Z0dOIeRfMJ5r1LT18CbOioX27RQBH2
B1FO3vPxFhwvRiNrn2B//RA/WWS2mY5UTwcOVGB/Zmv/2DNkSUdCMXmeF9g4
XuZZuazE8TWln7YwXo8LQul5HZ04/qLKazfkYv9cbfwemWVARycvmDZW43ji
tIw0n8PxuvGP3+Z+HG/n3QOkfPTx+nFa77IYx6f3AsWY43p09I5OKNHF8Vso
Pnn/MpuOWkPnf3PC8Z3zrejeU10cbye9ncqxfb6J+rzV/ng/ddNarY31de6Z
NXQzkY5eFvJqjLE91Rfc1O8jvP/bll5dRMXn5dJ4C/l2OmJ3jz7skf1vf1g3
eB+fD94q044+C7E/1s1pPC+pipyRV2DsH0NY5pnrSqSooko3b972QUO4Q93+
wkkFn0/V2wOaPxjC7vKPtT9oqojtGlbBeW0If7tDZEdlVVFnc0dU7FNDqNQm
lmkIq6Inb5ole/MNobPSvbd3AJ+3OgnLvmQbAiswSmvoDR0VzA9oFb1jCOFV
i92scHwOnfu05kKWIYjaWe/cEU5Hxw8bW1ndN4Rhp3iitQcdXYogCI0WG8Ib
D1VFF+yf37VaIeWVhmDRr1vgw6WjV9Xqmh1NhvB1fo7f+Ep8vhC5Owx6DYHh
lry7UYOOvrx7sjVn0hBWa6jUH15BRyWsi4myolwgkCh7w7B/eN1XLB2XcUF+
UZCFiQUdMRPEax0Sx3gOnvM7b4XroTdVcT+fFo/zpLRelR2L0EN/hIeLpdEE
LzfktaPaNT0k5PGTFxAzybtV+qJP7qYe8phnI1m8corHXXRplU2eHoojKn49
6j/F27/f3T6tTA/pXf25cI/fFM8/TmHuzUY9VNEv/eee+hTPJ2JjQnuPHnpd
FSL2M3ySt7F8Hm9qXA9FVDyhNuRN8LJnhfcWzNFHhlVHb6HscZ7tvFJPjQX6
aNMTk1WlEWO82SzD+qKF+shqNLPxgdco73KkxplVuD00lFfj6z7CE1N7cfE5
7o8aN32XuvKDd4fdHDp/Qg+ZGc16JjY+zEu6SOSP4vkDC06WTaYM88YNc10e
Yf2ODfk3nE0a5lEpVm+LsP7honJWHUPDvB3srZMu2L7SQ26Sled+8F5dtPNU
x/aPx9kf/WE/wnv/YLYVE/OxTn5upOA0yut8d1HtNOYnubJP6KD/GM+cJsnJ
xHztW2fz/zLGeEU3F088PaqHysp5ByeIY7yfZIvSmIN66Ds9LX2v6BiPlHw6
yemAHurYf1bYanKUN1kcGqjsrIfOnDsR+6R/lBctdWTXp516yPvYp805HaO8
N6bVWlds9VBhkf989Y+jPGHl6Z7VlnpI/2DpUc33o7zAxS+Dv5vi8UxUSxWb
R3nr29seTAyzUYShf/C9llFe5dJUZlo/Gx3sYipXtI3ylp97Fbmli42sj14T
2tczyiPWrioX+cRG6gu8vS6MjPKOrz1ShZrZyDnlW6L23DHeiWN7r56pY6Oc
yscpttJjvKWGzopmr9iI6p5+4sfyMZ7p8ad21BdsdDMumqPTOcbz7nghLY9l
bo7tQs6vMZ7O/nMbjPD3kht/NFSLj/Mku63dffF4lEVSR9vJ4zxW9YbQh3i+
00PEDi+Ncd51r93Zv9vY6OLvAtUAnXHeLgOxTyZYX9NiGS9R/XGeqmOT8nVs
T6VQg5CQwTjvjs/Cc/3YXrKmZ5EEb5zXlT5h24l5eLJlxwMMx3l7D2s3szCv
yIjdtq7scd6cWQtOnsM8s6b/Hq1egddDwU2Td5h3oyttfjptnJcPu42I2B8J
9Rkf/kqN8/IWHfTZjv21KbulpXXWOI9genjgEvZnm+jwLOgb43UulMl9hP2t
eSM0s85njDfv1SaW9j02EqnfbXpwxyjPVs5NxymLjWZTtwVK2Y7wMjq8HPNv
slFKr+bNBP8fvNXaloFl19hoSGxXx7buYd76r8n5IefZ6Fnar2MRMcM8p/6T
5Xq+bMSKHOBEXR/m6UyvVODsZaNdLy9XcQaGeUtlWWv+bmGjlhBed1fID97L
1fn0LmPsr2if2NlOIzwPXf16ZX022qwYaCjhguNjb+qpXAYbZUU/ur8weIzH
RzUcxZVsZHPm03xi6jhvrd/Ju5m4vex60JedmRO8+ic76qVxf9X+9z+qAyd5
mefJy2vx+H/9Fo9+okzxJlrLf3bi+e8Gcw7N8p7isUQlIhWwfsc+Oh4PODrF
Cwn0o5Ox/uvrOi4xVKd4TJ0Php7YPjuvwedbL03yavelc+9h+7/0sp/oFk7w
YlxvzEvDfKxqT/2UyB/n8RtHJrdjfvKiu71KY8Z4xs/5LxiYr7/Skyddjkoz
9QnP/P3fDHcqzdQn4jYVq7aYK83UJzICxANHmEoz9Ynb9i33fWSUZuoTa8NO
ZzWN0v73Xnn9q0drLW2mPtGwrfaX413aTH3C2m1QghlBm6lPKBEoTiW+tJn6
hL77xq+tLrSZ+kTu7bvapc60mfqEoF1QnxD0F9QnBOML6hOC+WfeK/+/foL6
hEB/QX1CYJ+gPiGwX1CfEPAR1CcE/AT1CQFfQX3CgZaSkn6PMsPbIs+s/m8m
ZYb3CYvEhbGxlBne58782JsfQJnhHbrz8VW2M2WGt0qoc8Q1PmWGt+K111Zx
JMoMb5fc/U/XjSvM8HZpTPna/0hhhrcoQ/Tiz1CFGd46zc6xuu4KM7ypm5VX
CDspzPAWtAt4C/oLeAvGF/AWzC/gLdBPwFugv4C3wD4Bb4H9At4CPgLeAn4C
3gK+At5LubXLpy6QYdi+YJfBUybaL7s1p3Q9GWgLoj6zEBPFnOy+91WEDKxO
4u38EiayS+pWpr0iAUQwv43lM9G77O6h/FgSiETWuoZkMlHRd79rdB8SbLTc
yDOMYyJH1uFCIWcSfNqa9VMujIkCF25zzXYkgVbV70Hj40wU/6fIXNeLBMNK
WxaOuTDRj8V5j7yjSKAj69truYOJIlcZuAiVkeBiGnXnfgsmGjplMhzwlwR7
N7jsW7KOicy0xqae8MhQVHcrsnc1Ew1zjZ8tDiSD8QfiQt01TFTVve5g2nOs
f2Sa/iT+/mGVglrHbzLcf3aM2LCJicoCLwXcVVeAG+0b/DV2MtH2i+L7ytYr
QNsjnWQ5N9xea/qnzxbHQzfd9OJJJvJ/9MpSYYsC2HimbbULZyLP+pSWdK4C
rH+9Zt2mG0xUmrjtxAI5BahZo6669g4TUYYIx352kaHgpm4g9yEThacW9/Q9
IoOllFEy8xUTHXwz6VRbSIYdB24s2ljLRHfkRyxoBWRQqpywc3rHRJspKxmd
+WTwZcSt825mIvdtf59I3SeDpNnKc/4fmCjlrkHz/btkiLmp0hTYzkSzb0iF
l94mw/djhDH/Tib6o5MkZ5ROhiXVesmHe5koeGG6GN2JDCrzqZMPFViorfFq
M9GeDDmtEWMJNBYKQkXHg7aS4X34qwUn6Cw0sDLg/h4rMiSpi88x1WChy4cP
uz7ZQIa1p+5kLljBQq3Xw4ojjcjQ/O3ou2IGC3kRkjs+G5Dh0gBpux2LhYZ4
aetzdcjg8yZIpl+PhWK5wo7+8xTg7ZVKZmYFE/Vsz7xxWEYB3FSG9ZNeMpHJ
6WNpk2oKoOlRwH72molIC17cFjNQADHL39pi//19xsjAnHRzBaC8f6Hkh/m8
TVRUK7VXgJ+zYsaXYT4iOGfe7qkAWyxKQt69Z6KvhDlRB/wVgOaec7fgExO1
H/j1tUKLAmTq0aA9Mix0TqNsMIRFgTOiHBE3Igtxdi+9MYtLAcn6kuQozOeS
VXTScmMKfJ+vK9KG+ThdyyxcYEaBEuMbn9aqstDeKMUn16woULRQpOr1chb6
w+1NebeVAmsqyFsPrWKhddK3DpfYU+DVrSuyKzEP3b89E6otZDCLnhQ53sJE
yVdaDJe3k2E7s3CV2mcmGhGrkCF2k2FWs+37buyvSuOAzJE+Mlx2iojJ+c5E
/e1Ej/whMrx7ZTkWOMlE4lo72XbDeL2KnzttP4uF5iWoaPf9wP0l35cairLQ
18v3P+8cIYOC2SkjBQkW2mJ4+vg4/r7ovEOusD8LZaiGFlpguXHZm6meYBZS
69tWdPEbjp+f0REvLrJQrWvewvwBMiz2Jf1NvMpC80/fjkK9ZJARcXl1KIGF
yBI7Lj34QoZPbe3n9NJZiJEbFBn1kQz7HixDo9ksJPtU4pxDIxmSz54VTX7A
Qu0OKd0cWTI4kNn0Ul3MS2fPARs5MlhXtBVlarNQafeBU3OJZLjgctY1CscX
4Ytm/GoSGdjT7acDcfzNuu2wWIpChsSuDXxfHJ/VWxTHvWhkkAu3HvbC/nHb
a8p3ppMBFeyu98H+O/jmcX6HBhkS9q6mB2H/9owXlE57kCFUdXst4PVxaXnF
2AJvzMu2v24rXj9fV6duTj5GhobUe49P4vV1uu498Zk/GSREPF5k4/hqjeh3
3B9MhgN5teRBHH9RLnVLosNx/POFRjk4Pqd6S/qNosmgaGzvEYfj1/954dkj
N8ig5zSesxDHt+mJ2yeu6pMg/X24RZYBC8V4lNtyJUmwRrLSKhyvj7NPNyxy
65eHgzmSnTY6LDS7i7u7+qU8fCaqT67RxPa5WG1/nSMPMn3zIm8qsRDvi/JI
TII8aGp06LQSWOjhMjPSVJQ8bNA2SdyM/Z14WOjWTiwL7479cE6IhVRirx56
FS8P574niwz/ZCKJwety3dnyEJoX1Ck8zEQ5VUW6//3706ETOlf1cPw5PVnV
U9QtD/xOwu0BzOdJgd3aETESSCto3j+M11foX+mdgzokGM2dmzgf81no+/tB
iwMJXl03n9vcyERUFcPmulAS9K0Lc+hvYiKtuANFP/JI2N9bz+vi/uGETM7+
FhLs4ggzY/D4+1v35IRNkUD8+IG41z1MdOO0SuzwEjKoNZupncfxH2v7+OFx
JTL4bxUh7MP6y4fycndpkmHugoR3E/Pw/tXG6OJiOXHucMvzxSy0qm9WxHMH
fL51O3edXc1C8e/3Wrz1IkMgVeeUE5+Fnt83cJ0XQoYTC5OWewILfWObXbSJ
J4NwEN/wFo+FSnpvbnuWQ4YzY0eHxLFsDXF7ueU4Pko3HUzlstDy0y9NKvB6
buQEdO7BsiRTNsIar89AUVt7GyyvuDD3W7UIBVz8ddqeYjmzZ/OFJUsosDoq
1LENy6Gqlw9Yy1Mg405tjzoe/87uFVaRKhR4ZjzfJu0/Obh60fOVFOjVrAs2
x/qJfWO59uhTYHPgQWMa1t+65bDBLyMKKPM/b1TB9nXcyNn6ayMFymHI0mYN
C73O7FB2x/uve29UgfUW/P3SmG+heH8+vOqX94AtC7lyQz+q4P1741GoidrB
Qte8RcO5eH8Pj2lIMndgoeTG+rIaSzIwe2Y/XebEQhFvGo8025JhugZ+9u/F
8bSpqthmJxkC/iSRaw6w0OLsyo8mjtg/PUqjjz1YaNg/4uzfVDII9ZAW7Mb7
w0BS5pjjLTJcTSZZb7/NQpW+1tbsLDKcq89stLvLQiKhPZ5+98jQnvfNbN99
fF7YDXFX4fNuzbcbXr4PWWhfedBXq//OQ2vTeZeKWOhLV2zZ5wdkWL+i+WHm
Exba+EZx88eHZIiT/8SvKGWhsFNXY/Zuwvv9up1WNoYstOd72dTAWgoE5uuY
O+izUP7HD2OZhhQodfOw4OL9qOoayytJhwKd59W2jOL9yFaJtq5egwI10/ZO
AStxfLwW1TGmUWCs5WLkV7zfv3sY1DtJwPlZmMu0uhoL4Wzt73fs31fuR1rW
KePv9xg8LlmHz7vCe3NiB5noZuftB/psBfCo6zt95SsTcY4tsN2Az7s2EZfu
A10437kqummEoADTtUOnFfF50L+gXUF3kQJoR4fcKsT7UeeS70uJsxSA+Yb8
dBVebw8fO25Ixft7lpTIyov1eL0t/nKnvgefB4zLnjVvmEjzKGVFO46HVZeE
TqaZsZCPn7tFC46XxM2sLy/MWagzMuDZUxxPGS4vdYo3stCbNz/vXcXxJj+s
qhRggffLoxtNd+N4TD49cpi4iYXkN9Q/p+J4Nc+TGw7G8oo7xVZtkhQw0+89
WYblx7VLV8TgeE90l5r77r+/N36iLzEwSIZH48zAA1jWFYltsMfrpf3zp78b
sOwdRJJrKcPr7+X1Y9N4Pm2pL+t34/W2e+VusaD/5KrbdX/iyKBvcq31A9bP
a7Je5sE5MtT8mCKKYLmdZnckHK/nPzrnl8zD9pTHthuE4/W+k3ly8bsNLOQQ
ZrzHOI4Cw/Mj9JnYP/Kk7CyfLAocbV3gFU9mIcMCuQ/kUgpUzHNtMpdmoW4F
9jKx9xQo9PP+9Rjvn19jFWPaxiiwUqJzQF8cx0dUUh9FUhH8gyUHerDc+Ngq
aLOGIvzxM/ArXoLP+zyxUuE1ivDMKGXQX46FlIa1RIdsFOGRnKRxIxV/v1pT
5MceRXh+JvM4Rwufx4dNhMFTEUx8nqT+9/sSpOWPD1kfVoSrUcKFCSYsRCvU
nSuC2+tsZA+q27CQ+1MFxUDcP0f4ft6oI85fkg5utsDjB3xyFTLF683donYY
VisCdUvMtjAfvL5NEw4dUleEwQbWG9YpvH5ohEktCUVYVJlXNXQG7wet9Pl9
oxQwuL5P3j+AhXYewFf4VgpcOzP+4RPODwIywwvMnlHAwtmmiXkc298lfbvy
DgUOl7iG1B5iobQL6fLP8X1js3lYqfI+/H0qS9cf5zsakkUdX7exkET7ToNz
W/+7r1mKpNizUMh5tzQOzpcCj6nncfF+EvI51TVhAwV0qWTvJ7h/hv7H5Fwc
n06zl31WcGOhutAvXj54fbbKH4/dfZCF7muUK/9gUmDH21umAd4slDdNklLC
+VzWkG36aV8Wmhxa6l98UgHMfLwMiu6x0PTW8AeX3RRAiESaG53HQnL3SrZ2
7FCACF2nadMCFpLeuPTmPVOcr/sdFHmP95PMxo5f03h9ir21/rMG7ycFHqn9
zSoK0PDZqebsMxZKKAIlWKoA7/6c9o0vw/mtnNlxzmwFCOo/Piu0AvOOcplY
g897beJhn2ic78ye9smFq2RQPnHfvBvnQ3eDQ5ssI/D+2LzkpireD1vNaoyP
hZFh0Ky1xx7nUwW5zDOFOL7vfJENDcP51mXn0YcSQWSwS/nyNwfnYzdG1Uv+
+31Z/8RLJW9xvlY4nbDov/vOLucB/e/Yvxut33ofPUuGchWxN6I4fn+5VLBI
uH9mbHwQHeeDx25N6LTh/OXSg3dDJjhffKuS0FF4ngwH2eZnPHE+eW1JxvYs
nM/sz5yddwOft2cDxh0KLuP8/+35iQacD3h+rt7ZfI0Msr+2PCXg/el8Pexf
lESGNo3uox44n70b6KeiG4vvX06E5E7MR1muyk4O9wdC/hdzzE/iW4OHXygZ
nBs8zqc9xudVoe3TPVh/5fyWgoFHLNRic+Hcu5Nk8HPOvq6E9/t++/ON1UfJ
kHfCw34jPg+2fLwaYX6IDCs3iuu74vPC9XSMxw43zNs51PkkPk/OZ9dUpKmT
Ids5cmPLYRa6eOGhDV+FDPK3I+e24/VxP3/BhCuVDBq+QgEf8Xnller7QUWB
DHUxT8Xq8XnWXntokZc8GTztJLue4fUltb/V0ZKA959x5y13cPzGrCs/V4rz
Vxf5puSI7fj8d+BOvZDB+fCKWmkvvD4fkSuTqjsx/y8JzK0I+yvt2NXi7/i+
1ygimVTMQllWdmVWf/B5fEJrz1wcf9kpg7rhCxTgUZ3+zUBs38Hvx6v3yipA
+MgaXSq2j7DJg/4ex590c5tfeyYL7RC/87yLqQDRtJzXT9Pw+bR3qveMsQIY
Cc8+/CwZ3084Eibn8Plz06/r/Tlsn4Pwu6w4fD71N3GWZWP7rHYYvB+hUmDX
4zHZCWxffVgEMxyfb4o+vRL78Hkfui5z/h58/nXR5hL/4nwg8FdlpC9ef0Sp
MZPHW/F9yPr4WBk+P+UnmhLTrPH5kOZtug6fr67z22QKrViIatrRr9eB84ft
uvvfN+P7gSt9ufgyBQgsjLLq/sJCh6PN7tjpK0DUAjODvmF83/jSHnjcQgF6
75Vd656tixKOEJd3WSnAvXOnqh4u0UVZNm5y9kYK4BzotYBO00XdSuZ635QU
YIVCsdcChi56/vTIYNM4GVo48X6buLqouTCox+kxjk97HT/ZdbpI/IJBw10c
TysMpvOfbdBF5x1CNbfpYf/0a9WPY1mq+fcp7UkSLGIcEsvH33dubjbvfkwC
q9ojdut4uihbh1ITf5EEL+iGv021ddH6S/uvF7qTYHKxsWWski762b8OXdmJ
890I19Wrl+qi0Hk7Kqxx/ttvfv+3+1xdxNXsOt12mATXppouWo6w0NznTdsr
r5Jgq8zODqkuLPtSv5+pJMFfB7W0Ry04Hl+bLPCbh/Mh17q0JXUsNHj85UPP
tdi+hgcTt9/geHCeV5WC1+uexV1DqAbnG9wLpfpRSlAyNEQ+eI2K6Ev3W99L
U4KjbmKMyzeoSHJNYeTLB0pw0rmhSDSdilQCSnL6nyvB+oZkrn8uFYlfr80I
qlECLcjeFPiUiroMrW4pNStBqeMm0fM1VOS9KiX18EclsN4Vc+R7OxUFrdJM
1/+kBAsdX3wUG6GihMd/eg7gdtfp0DMqQjQ07Kp/ahnuv+4oJzNMmoZsFqSl
e+Lx9T2rcsJVaEhhh1J+DZ7/rbDk6ws6NJR+STI3E+unOT649g+PhkZkvjSH
Yv07TncOupnQUKu7g/RSbN86799h58xpaDB/0+ORM0pgOddOi2BBQ96ndjxp
81SCGq/3istwO9ew/tp5eyU4MVBy6cI6Gmpsm9qUvFEJZs9xyy/g0pB2Z39O
Gd7CH38jFQ4xaMh6IELmFFMJ+I513AwlGno3bS/F1VQCA2mhOs+lNMTb8uqv
jaoSLNjTatk3h4Z+jWyxqtutBMFZC8Sc3KjoBG2T03EfPP7L9Ly4fVQ0+7vG
x/XhSlDbuEc2xomKzr5w+aqXqgQ9K56fsNlFRaodWzLWPFICRmVFR+tOKgow
V9fahflIWRUuVbajol0H1lwK6VICwxeNscwdVGRotbr5wS8lOLRDFy3Ect1e
0fRn2ipALguvWmNPReFHhL4MrFeBA3umYz9jOdjiMWXxLhVQuivSY4znM8l/
4qF4VAVE3H8YHnSkolKPmM/yF1TAN3N02GEPFZ3Ln476mawCYhQnmaUuVDRq
PPduXoEKLFf+fTbMnYpeJNN38l+rQFmj0buyw1TUo57k0vRKBVZMahz+HktF
+37d3LoCf5/feqmqIJGKPmtVtTng8bpe1zqXpFKR/dawOs8wFXjj7TX7D46/
IoOkpXuPqEDgB49Y30xs79uX4esdVCDF6tR+rTuYR37uckVsj2+bQwcpi4rS
Xt3/MsJQAaP10yVrsSxROLCs96cSxLTfyluM+1tnfmsu6VSCDTzdjkO3qMiu
Rjcu9o0SRI5rXV2UQUWxB1jmIYVKcFfXiPflJhVRcna2XkjBfH/xw0aSqWjH
gTGVexeU4PbZ+j28BCoaah5eNH5UCc77609WXKcieb/X9vuxv3+8Hr51MYqK
NCSa92Ya0+Hh+jNBqTGYZ8eHy+TddFBN/xT9Btv30/vnsY8+dDhK6Lmxv4SK
fOvlXrmH0MFIrk1/YRMVKb7q838cSQct5vP7s8aoaMLoZgjjCh2eLGjwtMHx
tvrjnZf5F+hwFd0XEdGmoTBRz9v3TtGhZly7RBrHe9FYOlHsAB1WD2RveLCX
hgzVW1PlN9HhRV/Z8A5fGtJLlDeJZNDhZs++W90BNJQqyqq3lKLD9qN0kYwg
GgoJ+cJ1GsXx8SgrxPM0ltPqTMubVKCJ0XjiqhcNXYpZdsDyqQp0Pnrj+d2B
hvRt9NXjs1Rgq+Nen9K1NKT7RF/8fZIK+Cz5oZKtRkOqhLrw2ngViLJccyty
AQ2JEFTOPsXtbYcoKYf7qWjh33sf9+L+nbX3x6zeUNH+Y59fCeHxxRVW+C59
QEWfhr7z9uP5G8T0a7ZifwgPZlT9HFGBO5Ysr72Y96bZEUOBKrKQUXSFMQfr
S1dR4dEGZaB9np681gm83sfsVF8UyMB7o8CqaE8aIm3MeBhxXgayRnS/9eyk
od3LPFQ5e2TgLRob1PpvP1gZONJrJgOfzWOVni2noccl2y+IrpaBHYOpVcsl
aMg0//w7Q2MZUCJpnaDg/U076OyRrTYykL44u9sS+29j3o9CG28ZCF23Xtj5
CRVlxTzK874hAx+WTPu8wfEIktqf1tbIAIMr4ViB18fvzdWX2oRlYV1wx6pV
l6koqf0GbRxkYbG/jUl4BOaRZmdBPS4L5clOdqPRVFR4NztF6J4sKGY+EF6W
QkXmN8s5gR9kgSjLusDOp6LWNxvvDk7LwjTPMtG8moqKXQa2r5CRg9T1fUcm
u6jo9OSZpq8UOZCKTeRn4P1K/uu8S6HycuCY8KMhU4GGGm7IOG5eIAdNXX9l
NnBo6LXIwRc2/bLQrH+qsG8zDW2afpaV/YsET67nia38oYgqp72fu+J8yiBI
kmH1VxGtIvRddLIiw+X9S8F3MRWlRrkl+eJ8rNdwckuREhWRl26+J4zzy6lj
jX8nDajowMnB6omLZNgSustlwIaK0tuyFtXjfLf22u27zENURJ0jNF6Kz2f2
ty8Oh0Kxv3nZq644kuF++K4Npjge1BnxjWlcMpw6QAgIw/YrEpk57UvIsETz
962Vz6noz/LQq1c+k6DrnOUjr1dU5DCZobEtmwRLJVyPNuHzKzI/Lm3ElwSm
x0TEtF7j9ai16Qx9HQmOn5E4EldGRRsOJEtfJZDg8Z1vCVceUtEzswyR2DF5
sNyxAt7h/cvuO8mN3ioPzMermreHU9FxUat9uVXyQHY8aWrrjc/TouJw6XJ5
OPDk5lvidipqa99Ki36F2+f3KIoBFa2nPnlb8UkeCGcnsoLoeL+g2c6580ce
Yo44zmuSpKIP4rDFwFoZhmrjPCz4LKRAePb8PFsZNNu+LAvQZ6EHqbQBQ4oy
XFlVpWiykoVG1VedHF6kDFuc9lw1p7HQTzTMa56jDEeD45+7LcX3k8G1PVnT
SiASNjiQOI+F7M7mPrs5Txn6F9Q0fR9lor4rMYZuksrwcR7Del83E7nLj+9Z
rqwMAS96+idw/j6SrDjnOlcZ5i3zr/CqZSL2o9kHhO2U4cCH1qnjL5no2eh/
/3+LMiQP5owfqmQiuubKhnlxynCp9187kyNheLhQGQKX/+svfp/T0vZWGWp6
/o3vSI+dndilDJWa/+YPoJz22/tDGcrY//QTT+yztZ9QhpdF//TfnMebZowq
w6wH/+zbw5j1XO6rMsSE/7M/MW3R5teNylCx5R8fD4WDJ848UYY5k//4aVOG
+94kK0Pup3983xBadzcGE8BKacPoxD0Gynqw1Xq+CQGqXV4e1LjNQJG/U65F
SRLgwql8gmcSAx0vObFkS48cgDsjwusKAznaeRqtfSUHac9DbZTOMtAVIY8p
61I5yLxxUi3Gi4G4B1ae0n0pB15na8wmHRlI6se21h1f5MCgnmZ8ZDMDKf5V
/PFTjAAu54WP09cykOxwQbM2nwCz+3qMZhkwEPwUms/3J8CxqsLGAiYD6fO9
35Y8I8DUfG91pM1Ar9U95IbnEmE8y37YgMVAR4zPtCznE+G4bLDYbEMGWngx
QlfuCBEOqzkURa5jIKENBJ5oPBE+GARuXmHNQLYXTibr5hHhrMXThg5nBjK1
Nn4+5xERDvSJH7h0hIGcrl4InZVNhKVqk5eFgxkoICPx7YIIIizfQYgnRTNQ
WkP7uJYzEfZNLC4vTWagO6n9ySHLiXDTPSVD4g4Dfcxy2j1/kABXrjkes89h
oNATswoU13BB0fdrtsVxDoqGk0kpBlzwPRF/9ZwLB8k5LMwjcLggXqBz7rot
B22RvmKfyeWC8GRg1pgxB+0WXRMjtI4LKtZxPGEWB2XJXcoN3MyFQ8MffZao
cZDqsdV0mhMXZLp6NihROIhFm6WR6s2F7cIG8iNEDlrqk+4UH8yFuvGKP+/k
OWhVls7TGzFcyLFZV1dA5SBZ8c2LTNO54HpsYwlVk4Mo4XGzvXO5oLNY+S2P
w0E32f72rEIuSEnb8wc3cNBc7eCtwkVc2CPeFPNuJwd199kUPnnIhZvTFauC
PTnoVfXXxpS7XEijNBVf9ecg05U3WNtSuHAq5LZNyQUOOnFbWrXtMhceF4Ut
/BrNQZoGjHDPM1zwc3zpuyuWg/Slo7Z5eXKhplCv88V1Dspp9/yw3Z4LjldO
JqlGcVBog4xikAUXhIwlxKbOc5DhQOwLqhHme3mX2fyTHDShNBD+vlETshbR
PcY9tFHqqgdi1jWa8OGh11/7A9pocH1MZ0iVJrwWrahcuUcbsavXKKWVa8LI
2K4fUQ7ayFlmx73K55oQ38MUKdymjca2LN44p0wTVMwo1yo3a6Py4RLWphea
UP1EtGrMXBvJ7CLJJ73UhBDdU63uJtoocn3qk5paTRAe2lFkt0YbiRX4/c5u
xuNHdaT3cfH86K3t78+akCQq+02fo41CfRb3HBzQhHGRra0H2NooePxXYuGE
Jrw3qXoawdJGZnT9/mNztSCheXBLMVMbHRh672q7WAuKxGrZw1jWN+jt/EHQ
gj8trk9X6mqjtrB3yt+VtcBiy/hfTz2sr8qj7okVWrCl5Dr5hoE2elsS4lfE
1oLqbp3OBNBGa85V2fzgaUGObOFJa2Nt9CVVi7zXWAuM5vX6xplqo9EHA0F9
JlrQZ39vfO0mbbR3T2aCk6kWXE0rH1S30UY3Y/yXJ6ziQ2VG88uSVCI6kfY5
frc6H7z+mpetuElEhPgzr21pfBhjKCQUXiUicdtzmn3yfDiVe0dc8SQRHfY7
LHpMhg/jDDvPCWsiUvGP/WItxQfLd9vdfVSIqMB+uvCJBB8GjFui938noHvp
7Tati/nw4PPsvNGHBDSm7EF4iNszYsxcfP0IaNWJq3Rj3N9016L3m9YR0Gbr
22q78fj7N6YZZcoQ0Nnci5Gv8PyzszTPbhiWQxdvdK5gYf1ybQo2H22UQ7yr
K8cMsf4ucz9lFFfKodn+TRHHsX0exf7qX7G8SeFxrD+bD+b1rat+4+/7d2n3
f+HyYavvyV7FH3KIWaxdus6ID7sNzqU+lyWg490Pdm834UOSaczdBBMC+uvC
rGgz5UPIrTLV7lMExN2RaHhvAx8eXzo14VZIQDopmpef4vZFl95vbxgmIEsG
tZqE+48vTd7+nE5EcsfkyKFmfFjnVLfAeCMRqUe90H9owQeKUpmSuAERLfiw
xHDcig9/S764PVYnogakTFlvw4eN13s3bSUQUeNFTkv2NqyfedbolwVE1CUx
ZUvbyQepRRdX7vlNQFdGUPCtXXxY/WrwUvsQ5vdmwQYDZz7MDXxqsb2DgGps
Lbp+XOXDgaAP1qv0COgrzKJExfLBesEWp2xNAtpWW5bNT+DDhcHM7StoBOR9
xG3fz2Q+mBRMBRXJYf/NWUt9nMaHqk69D5aSuN3KLyckE/MeN581OZ+ASnqO
fd6RjeOnhQH35hLQMzduADOXD3O+G0cd+yuHJsoWbx/K4wO50Komj0FA3ZmO
hqU5fDCe2PWgz4iAhB2lOQG4/z57vjvHhoA4fnO3rrjNB5kAg/NJewlI/95g
wst0Psx749u19CgBaWiupFin8sFKPCbzylkC8jPdP1yTyAeaha6p7GUCeuxJ
1jSI54PjtT2hCQkExO9uuRzkwodf0SZnK9YREf2P6tbOPXyQkHx7dMNmHK/u
zi9Zjnxo0TzhX7WTiOIrSyRO2fOB5KyxhbuPiHZzvlgXb+dDPKv/T7onbu+/
U/EN++e3UlPLLB8i2mJz76r8Zj784P+4vt6PiCze9o2txv511vhk7B9ARHwV
2yixdj5IB+lvF+6RQ6TRX0MFnXxYzFtJ7/4qh6YJazj6X/lwUO9IH3VUDg0U
7Q9zHsT9fZHdFiECsvf4fGjhMLa/IM6uWp6Ahl4G5y4c5cNOZ5Pua9ifwqW9
hWvH+cCNtL8as52ARshZLakTmEfUWhsfHK/rzlxeIT3Jh/CLN4tfphLQzeCf
mtdxe8yNU5eXVRHQ+9esN6tw//GEuX/fD/wnf7EbGuFDokprdO4iIjpzBXq7
vvMhKmpO9zocn79Ebax1sX7SL2Ifn+AT0bxhI2VRrH9F/VjZLisiuiELEwHY
PiWhuV2mdkQktnhvY8MnbO+0HqXBnoju3EHOK9/zoeuFWUzXNszvjtT4s0bs
D4PciLvmRGQTV5ldUMeHlMQg3yx9InpxUSVPv4YPy86tHExSJKKyv5SLHq9w
PL1REwubS0TcZ66PPV/yoe3WnrU3PhNQWf33v59V2KBB2i/fPc5HJcS1MuJK
bNjZp9teOc1HdS7f8nbIs4EuHD3UJ7IaNc+R+7xfgg1h3yzXpomvRi0H/06q
z2bDEo905C61GtFF6sZav+mCnPxslY5lq5HyRWHbDx91IW/DO/FaLHsOHbuR
9EoXkiSuD7Hx9/d8RG+df6wL4o5zxy3xeDFvFC1f5+rCXY3qN/54PuokO8ru
ti68Gk8L2Yj1+SjtoleboTvz/0UJ2g+6Nqw6Ncif6X+RldNv1sWfGV9rlm/Z
8Tb+zPzxlh3VV1r4M/qdl86487uRP6M/be3xqD4sC+xTH303ZY+/F9ife1jN
m972Pz7L7LqrP3f+j98nnzWtc7E+Ar6SxlIJ3WN8VNlVYeUmbDDDG2mSXK/N
NZjh3XjihUj3L84M7w9Lv+uMfOPM8P4Y0GD2oJ0zw1tDLnP9nhrODG+1pI+3
9z7mzPD2mmU5rJ7FmeGdd/7TL6kbnBnece2TN20jOTO8VRZI9Haf58zw/qwK
4dvPcWZ4C9oFvAX9BbwF4wt4C+YX8BboJ+At0F/AW2CfgLfAfgFvAR8BbwE/
AW8BXwHvBReMp3/dYsEyGlH7RAsHBUq/XF9axAKzPaBg9oGDsg1vTYhUs8Cy
ccuHX184KP6bbfepZhb0pFyJGvjGQVEblGOXdLDgbNmorNo0BwlTzrn+7WbB
qNObMF8JAyT+jmv+EcsH1/KP+VAN0GG37T25n1lwxo2yPV/bANH1bu3qbmJB
gu0n3derDdBRo9+ta16yoDb4i8SFjQbIdBPZsuMRC5Ry2A+nrQ1QRUGG4hKs
r3biIqVLWw1Qb8S4FP8qC+rLiyqEbAxQI8tg9scgFmyu3FAQg/v7vyadZPmy
4H72aOBHPL7yneNv93iwYOEbgz8VeP648/kXdFxYUOWh1n4B68eWVDFfhOU9
9fOnw7H+5KES9og7C053Lmo3wPZdq9pSfMaHBQa6bnJ/sP3KV+ZcGz3Lgpw1
j6pFOjlIj5SRrhvNggtd8metML9vWyN//k5nQTtLKfQ/vrsJFKXuFwxQs5zI
SXjIQryoYObdZgY8d391xPERC8kFyZlM9TKgz0h5ifAzFmpdG/nSd5wBp0aM
MwdesZBRmFykzCxtSKlT/qD4gYU+eFdKSAhpQ9ab3U7ugyzU7f9L9/c8bdCd
H0d0m2ahEheDhI/TDLhy6OuZLAldJFQa4UTC4/1yOGz7SkEXqTvXPwvE8/2p
DhaL1tBFtXWGf+hYn00X3t5cqq2LUEHfn21Y3+y2xeq5TF0UxzS1P5fPgA/f
Kn7p4PYQ0WoZ8k0G0A44Ktbj/r+EuuieVxkgPrRlFY2ii2hzNoZcucCA1tcu
qsskdVHakHOa9TkGLPzzVq0N65d3KF5REcsrPq/L+4T1f1lopv0zjAF2FR6r
w7B98Yk6G/2iGZDreyvX6DULCa+LVehJYcCLjNEsY8xHsmypnlIeAy5enwg5
i/n5DZqo9pQxILy4+nQS5it7N0F0+D4D9jbf30VLZaFd6++/H81mwHtlFVrj
DRY68Yg+qprJgMP6dKmd11jIpHus7iK2Z8vF8Z5Hl1nIuM73Kz2JAfFConuH
LrDQwOs/18biGPBY+oj972AWGszbwpiKYUD31IG7XadZqGHT3jHt/0fUmcdD
9b1x3NJCZd9T1uzMjGHGjGU8RCWJ0l6oVLQohZKtRaiE0peIslUoabcU5ggV
RUnWSgolS4nKkuV3NN37+/N53XvPec7nPOecO+/nzLn/0UFGLI6TE8BEwyK/
197eTIcbK7vD9NWYyPuNm4+6Cx029DXZvVZkoqhx6Wmv1tPh6YNtlutlmKiN
Pl0mfw0dZtSK7i0TZSKn1meXm53pUMvv+llSiIlG2c4RrBX4+V+sUjt+JjrN
up72Zjmu/7uF8q5RBsrYdOVm7jI6iIvKax8cZKCRQ05LllTTYXTyvrpvMhN5
2e9I3PKSDjkqd1YExTFRmVI6X2EtHRKY1tsSopnIjCr/2OENHZ6J7TlRFcFE
Sy+liio30qH/2JI30seY6JWr/DT9Fvy88aa9h3H7HizIuunzHuv1om/bqA8T
3Z0vMe1XGx02X3crTfRiopTOs+mNUkagIb1btliaieiLjpw5J2cEqh8vNAXh
9pUFfmo9rmgEiVL03664fbu/L3W5rozvv6a5YbsAE3WZOjycscAIplMEO86N
MVDu7e4L8dpG4HfczePzbwZaKjsZsc7ACPrU7W9sm9q/tffeHHu6EVieK9kp
2stAL9266FLr6JDu7x30BtsR5W/cxLD+BnrjhaoDDLRnldvit1voEC87Vnlx
iIFStM55+u2gw/3H+r8sxhko3Ux05btddNhjr3hIWJCJ/lieShfdRwd709yQ
P1P9sZ4uPNuHDmprCyiSYkwkWayy6NVBOgxaRV+2x/35ffJsu/N1OrhMsNY+
x3ocYms9a8Pxl+u+9LyGLxNtED9gYnyHDlZJJZcuYz1nvj2m6YDHl8BR6X3G
WO8Eakmybj4dTBwrfnfg/uirM7r/vBA/v7FbMRf3l0v9u0RqEa5/S2dxFO5P
mzufolaX0GHYevaDY7i/LQ8baSXZ0OGNmz0fq4WB1n9fqr+STYdLLrkrzbsY
6OhtrZkxuti/wMyKcKzHOi1q81EFOvREqwnbDDOQYrhAS9hMOqxvlF84gW2B
JjkQ+20IVSgy9NpPBlJRt80I/WwIkmaWQ3E9+LrCJrZaiyHsh0QU3orLFz9k
9rXWELjzI4TDahhop+nDY8dqDEFacOxocxEDPTWwHqa9MoRyqYLxb9cZiDm8
TrC+wRA8Fj5wZ1xkoCSveYs6PxpC5mCT6rQzDBSsFRcb0m8ICxzfXg05xkBf
Gq6o+fHTQfrbnLGgQAZyuHUpY48UHf6L/xMQEMBAjsvKNH8uoENTSU1rZAgu
jztRkGGM+2f5sRSXCAaK3T3fmm1Fh4iTyldM/2Og4rHiDXft6PBC0bdy7hUG
2uzhOWOLAx2u3XknUfCAgcZHjLNG7LEerqznWU8ZSGHhfqlEW9xfwgKxQU0M
ZD2e1eTrhuvfVjLr5msG8mLcWHMax1OtyeKDArUMlJWw/+pNLzosYDcmXHjJ
QM5BCiff+dLBp8SwYw/WZ8eEUol0EB2cC8ceHK9mIJtyiWmrQunwbUPG2uYX
DKR9Zal0wmk67BWznPDGtgVfembrOTosbQqvssP2zNmx7TbDdAiYMG/qfc5A
6ldl70bi+f8ZLbBhBr4ef6fc59UMI3h18dTEFmx3fzf/KC5qBMqSb4wmsD0c
E3h/qYwRGO3cYvsW1y99PTo7cJ4RzK361DeM/VORWHYkTd0IZu6vrFvzioH2
2s4YLtQ1Agraeuonbt/n26KnHlkYQdjtBxuTcDwdeD9skm5mBHUxhQbnRxho
3qziV0vZRvDlsLbiIT4mujKySCyPaQT5qROjNjOZKC6y5HGHkRHEUNRujIow
kVjVoupGGn4+UFQiHs8futPy1c/i8a7XETRXBs+fBrOXV4vi+pVnzC7xU2Ui
WFhD0R/C82PypOdKPJ5ufvpgc2CQDq4vX1+LxfPzvJtBA0e/4/kymXXqNp6/
fdnSvut78P2zbDSu4/l9qE9Cbvwz1u+4R1Iwnv8N/X3ZXp/oMIsyW14Hrw9x
kpvtbuD5LvaM8pvreP2gPrxRXoDXS1DOkeHH68vBE/O/V2B/Pvnya02dn2y/
THH/bazX1TT/R9VtDCT+dZVaFNZzZWpXAusTA22fftPSFestqBjt4N7OQCtD
M4U1cX+oq5QFOnQwkG/x/bLPuL9Ohsxr+Y3ts+8D76Xj/hSqOmrk1slAgccW
qGzC/a3Pz/YIx/adg8Ydv3A8jLUcX9+O7bh3t2Ru4XjJzbLZWIlttVf8q3bh
eLrGYRrtxXbNuVOfdXC8rX3aM16Ly0c/lkr143hc6O3a+xP7c6XRRImL43WT
2PuFjdjfBO+AJYk4nvd5/nY5/BHPv+bo5VEc70sUXLLe4vbqLhJQTrUxggT1
dpm4RgZizA4RUuUYwXfN+IkXTxioUEdUMdEcx8dWyvfW+wz0s+2/J1pgBMEZ
wdJmGQzEX2czGbrECC7xxWXan2egZR1nFQRWG0FXcuOHteEM9GyhTUzaNiOI
Pvvx3s5gBmro4z+vetAIau8wTrAOM9B9q6znc08agV166fa5ePzXHmRqzUs0
Ai0BK9PxIwxU0LTK71km7p8FSxZ4nsbtXXtp58BdI7jxUIkdloDHm+CxJ/cL
jeB06dpsejZeT8cj0IlHRvCu8NXk1Pn44Q/WqVgUGIHijdLE53i87Inv4aje
NoJ5L16pv3uHx9Po5cuNGUbwy+hKCX83nj/95M9u+s8IjHeE+VLwelw9w/hX
33Ej+ClS3nYVrzctbXGlP7yNYNE2o2VzsO10Y79Ns5sRtHAOCu3F65luqsIp
wRVGENQv7MP5wkDv85IpabZYX4sN95c3M5BympC3eDKA6qF1DVvEaOjn2cTq
/isAsi/XbvOeQ0NfdcUzP9wE8FJOW31BlIa0Pk1EaeQBzDkle/i6DA09PaKV
Jl8MoCedcFJelYboJq/0dR8DyP2SefWbSkPhi2bMHygH0I8Y55O2oqGAhrI1
JhUALzbsvSXuTEOm2WeW/cT3uxVsOB64jYYOz/bxXlsC0FL7uO6bDw2VlLgF
cPMBsnXvbTY4SkMpGfNe3rsF0Fw9+MjsJA0pqC+40nwN4Pqct/6+kTQ0Q4rJ
/XwJYH6FhnfcKRpasK3mY2wcQMC4i2jFcRpq7Ps4+1Q0gPGiFk7MIdzeH6fK
158CsF2fQm/xpKGW7TbH94UDuH9N+Fq3loY+yterzMC25xuHkWZbGgouV5XW
PAmg1XT4uIsxDSmtTn2YcQbA4v2auIoFNISOL3yvdh77e+bstpXyNJSXJySj
lAQwl2EXLyhOQweSdFurzwL4+DtSro5S0ZdU9Xu/ogBKfRwOJvdTUeTk8QPG
kQBhCYIe1M9U5PLBfeQ0ri9Owcx2y1squtaxZ/5oGABTRd+X8YqKvI2jco6H
AkR99fK9VU5FHh2P9mgcA3iS+/7T6wIqsu0uVGwPAZh2O+hQRg4V1R6Z9qzF
Ddd/P6pqdIKCao1UFe+7AOwvXbM2aICCPvnzc7M3Auy5NPvp3U4KckreubZo
PcCBy6OK6U0U9Htc+EjvWoBr3UV7lz+noJGzy5+argHYVNDX+6iYglbbGBZk
rgJQGm5p/HaLggK2iL0ycgYoqKWG9qRRkGvJ1rNV6wDOHpuO+s9R0NeCnY/S
cX3W4TP9R5IoyHbDrDF3V4CQLSsidlyjIJ8AHT+RLQB72xSyje9QkK6fyorL
7gDVzdoBm4soaLMG32OZHQAHxb8c/vyUgnb61fL7eOL+sD80u6yOgiL31a18
sAtg0q7p4MAHCppsPnmtGPf3Wdun6klRVDSpsce5A+sdy5qIV7hIRd/aIm99
w/1xYZOdVvs1KjparC73Lgbg3MYNrwfvUVHLxtDvN84BuIolHFlcSkWNzziZ
Lri/M608+FtqqChQZlNe/38An/kDZDPfUdGa4eDL2+IBlmlr7L7eTUX8j8/L
xS8EmOUaqSI1i4KSspNdJqxwvF6Mtmz+aYBYG9zLo6fsRV1Bpa0GaNvg8Kpl
1gC1MzuEnz8zQIs18o9RbAByds+8MHjPAO3LnXNKeTFAjGnBR700A3Rp9nPv
8aUA5v8dalx2zgDlxlyOTnIEkFms+0IkzADtOPYnshz3j09ZsPFYkAGKqmXV
mG8A2PHn10K/wwaIXT9bqwLHh+FTl4K0AAPUsG1V7vztOB5kDQR9jxogw1P2
V4Swni41Kp+zThsgy+lPTB32Auw6NRhYlWCA0ns2ajzcD9CxUe8047oBqhRp
ea3lC+B84nSrSokBOnjDnhngBxDpLe5+rc4A+eiPz0rHdk1u7pHqrwYo2Kb5
xCV8/76aJyviJw1Q+xq97f4HAMQq20ymS1NQhmPjAft9AEcKzfUpmhSkt0Fr
k9lugN/2c3dbMijolL2C2CEcD5ymu19P47cKKz+BW/tu0eFDR29MTxkLzU+s
THhyiQ6GlvbmhxALMdetKauKokNmUkA9vYCFri1r3FZ+lA58uV/nP7vBQi88
Lv0oOUSHlROPRJjJLOT0UC/LB7+vf97Ecis6zUImlG0PTPF6t/i339dSfxYq
3dKnOi0A//5W72zM92AhH+6cuetP0EGwvUhkbB0L6dzM8tseS4edS9bLFDuw
kJ3noyKhDPx7b/TN24+LcP0lT5b24ff3za/19IZsWGjihVZeBv79HHEd3BYs
YaFvZnFLUAMdtv3KttB2YqGqI6l6w+10kG+RN3TdxEJXR3QHzProULCxJ+j5
bhbKWdvpUv0D/74Sq19vFMxCEm5Vacux7cLOcKXFsJDWDIuuSvz+Epu3QW9F
KgsdQEuP3/5IB00v/lnMWyz037JXr2rr6DB9++0FNx+ykPfAgvSlZXRYfT9D
5HkpCynB+/V78e+P9KIzaeNYX0fVXyceYb3/23pNSb6ehfhy7X4dxHYuvP6R
08xCXxS7dwhj+1mdYCanlYVqV1HHDuTS4ZVQ6Mvnn1iosMCq4x7+fRM/MG1i
5RcW6l01a+OLHDqMOyo9fd3DQrcUVbKLbuDf74EPSu36Wchc7Y56GP59ZJPu
E5H3E9vq7fsdE+hwpHe05jqdjSz7EgP64+mQ7V40NtuEjTg1IUd2xdHBU4DP
aLMZG3ntqh8tPk8H9VWrZa9ZslHdlt8HevD7z2RYpeO7hWxUZqgRMBhDh/Ke
lVH8S9joxfqtuQ04Xs6Mmh6XXsZGSa/ZhXGRdFBNCP8i5cRGiSuKJ5Lw+9G+
nFXPHzmwUVe5Z3QbtlfXaA9r2rER/9pn85bjeDAzG7KOs2EjOaXQiA5sG83w
nysEbPw+6J2SEUYHr3m/e45i/8bmZ2lHhuPf89x3avzYf/ba2JaLEXSwOG+r
fRq3L8eJf/Prk3Tg7onYOp+CbceXEkJJdDihxqeog/XJDpMX9kjG76c3OH1P
sX7XrxhN68PxnzTnT54P1jdQ6P3JxBQ6tD28WmfQzkIyEkXie9LoMO2U4cUh
3D8aVlHC23B8WqpnbXrdwkLzFJzqj16lwyFp5MFtYCGHVP+q0kw6fDroK4Be
43iPWu13FPtTSQ1O2xSP/Sm6uNwH29FvQ3zU0tioPPtEiCZuTx/TLy/rBhtp
iFeO3TuG7WNzE/wf4PZr6086BOLxtsN8hXoJG+WtS3tsjsdbW89uocUVbPRg
W+HGtzvpoKuSp3a+io3ufFx99zx+f/w8/2bt82o22hX4p755Ff59pZaS96KG
jfqtQj5oLqXDvCPGwafx9TuptYmDlrj/T67bKIWfL4xdTLnHpMPrbZXe0eVs
FPbRXbyGQof98ltFTIvZSGbfxa2XtOkwuyDxh+d9NrqxeXSmB/49KLuakxVy
nY1Ub2jFbFCjw9eYFLWeFDbym79PIQbbMT0FzzTi2MikIn21gAYdGpPkGVmn
2eh7v/XFBB38e/z978auo2ykfOjFfCUaHegCs0pW+7NR0IodlnYsOrzrEstz
3M9GnSc0nhTj35ddi5tma+5hI/vVnAHxZXh+cBEUltrJRk+oFl/3h1NJHnhC
fdYcgetUKP/HA02m0wwTqqgkDyw8qcy80EkleWC0BK3szTCV5IGuA4s+buWn
kTzQc/ywkCO2CR4YXOP3fjO+n+CBokeUPNs6qCQPXF+WseBmJZXkgVdT/ZN+
ZVFJHhi+63Xy+jAqyQPNd5xzub+FSvJAmTnnX30E6v954Iyn/aEaVJIHLptM
uPNCgkryQMemJz1OM6kkD9zdyuj4MoNK8sCEPfEzL4pTSR7IMd1hkapOJXmg
xCnDNh8OleSBWqGaUt9cqSQPnKiP/uFznEryQKO1pncj8PXt/3hgRdSWdTGr
sD//eOCI17JTQ0upJA+Me9q1qMyKCs7/eGB0yjefXywqyQPfxQ+/Pkujkjzw
w9Zr0xO0qdD5jwfmJldGiqhSSR74W/ar04yHFJIHfskoiui9S4H1/3igym/N
bNscCskDn2ye+VzqGoXkgVfzo1vXpVLgFcED92bckk2ikDxw3p4VHcvjKdD5
jwcuvW87JhBLATGCB3ZfMmSep8LIPx744VxlnecFKskDT7Os0uWSqXDhHw88
vN5AwyqNCk//8cAEBqcEv1eRPPBKgUH2eA4VbvzjgXttHMbO3KOSPNCTqZwd
85AKbv94oJq7mI+uOA0W/OOBD8rGN3VI0UgeuGhk8616ORok/OOB3/ZUGowr
0kgeuLvg+en1KjSY9o8HGlJ2en5dQAPffzyw+nzwuhs6NJIHGvUavr9EoQHn
Hw+88rB6xossCmT844GSJ65tLsf6U/7xwLaMR9RNRRSSB9osVT5wtoICD/7x
QPsDCrauNRSSB44FiH1+3EAheeBw7pZ7j1opoP6PB+r6cQwWfaaQPPDTqJKn
gwOV5IEDXvaGHjj+bv3jgQWKH8VEN1JJHihxh++bJR5fBA802nC4ZXQHFVj/
eGBr+jZhiz1UkgcWXc17M20/Hn//eGC0y+MiJz/c3/944EnNGR4fjlEAnZIV
ZLcwkCP3p4zDbgqcVNOItuhioM7ZTqueOFBAYF2h7skpHjjptzdbjwK22Z5h
tsMMFNVS0Hp3JgVevHV8PIltR53c+RUdBrBsyOhH5k8Gso1eveNmhQF4+VrB
hR4G4sZ4ULpzDGBhU82biFYcf8dU+g8lG8DdlOnvp3ign4jSlqw4A+A0C4u0
TPHA8pqNMxMNoP3SGqvv1xnoQE9upuM1A5IHXoy4Ee5dZABzcg51CZ7B/r3O
istoNoDnVnilOIZ/DxsPcM79MYBc+eYjUzzw/km910eVKdB7+e7o4QAGGq43
3nHWmgKXlYf3TvHA9tvHhPu3UEDl+UrnKR7o7Xn0mGIgBUIeDERO8cAvbTZD
ImcoIHft4I8pHiipvXnP7vMUcFgqe2yKB9YcSLmSfBbr4TZ6fOr//DaD4Yvf
hlLgrceLqOAmBjr9a/nKmHwKyQM/bHde/hDH06t/PHCdflsP3xsKyQNvDFLv
uH6ikDzw9ZDp/Jf9FJIHxoSqZDtMUkgeuGphbGW9CJXkgUf/QP/WeVSSB0pJ
qHpSv1JJHmhnqzu9eIhK8kB56kIbdUEayQO9vB7dcZ9FI3lggMjoiUsSNJIH
xmuJBNTI00gemB5d5fhTmQYz/vHA/scnns3RopE8cCclar2oKQ3C//HAXxsO
Cf0yoZE8MCXCLO0SgwZd/3ig1qGKD0JGNCj4xwPlhS3Om9BoJA+MXVxxSdeA
Bm/+8cDcY4yfn/B4J3jg7ZMvLm3RpIHKPx4YdixxYvwzFTb+44FuqEj39Acq
yQMtVv8Oy2ykwpd/PPCbl8apdS+pJA/82aDyMuUJFQL/8UCPnk6po8VUmP2P
B1JUio3G8HxH8ED3fat05fD6bfWPBw7zJ3PlsR4ED6ypTLQSxPPXtX88MHZH
3cAHrCfBA7uO64nfwXoTPLCeT7PFH/cHwQN/mxr9x8b9RfBArbyfM3twfxI8
8M+47UcX3N8ED/Ts2r7zHI4HggfS7296IShKJXmgfRKfXQCOJ4IHpimJ7x3B
8UbwwIjW2KdhOB4JHrj8+p736jheCR5o8u6HYROOZ+9/PDDJJxgycbwTPPBm
2dHvA0AjeWD+ybEmHxwPBA80yzzT08OikTzwoKvUhQBzGskDQ53KXjbY0Ege
WLNFrHvVChrJA+1KH7v93EwjeeC63UfdfQ/QSB7I5Gome52gkTzQ+ef9ob1x
NJIHmq6ps1W8QiN5oHW9oqntLRpc/8cDnxydjJ+ZRyN5oEbgjHON+TSSBwoZ
NfbH3KeRPPCb1C4x3xwayQP3+M/fp5tKI3ngpYH4zbfO0kge6HjibgUcoZE8
cJOrdKyNF43kga+1+6X1N9FIHpgzP2H9GgcayQPdjBUnB61oJA/cW76/8JcY
E76aWxdvvKaGMmWjx9wEmJByISvFN04N9dIfB+0YYsDgp5NDeiFqaMmR0KKy
7wy4oqDnL7JVDQnuVz060sOAyBWh/EPWaihiyIu2pJcB7zvaPg+rqSGNEuX/
rvczwD6N/Y4+TQ1FtydoNwwzQGJYqfVWlyoy22sgDdOYIB5Qfnjha1WkF9/s
oinJhFmZymW7HqsiFc/S6mRVJtQeuCxk9FAVZXenJyUbMoFVvHVAC9vR2Q/b
ZKzw9eWN5kvx/dku6Vf4HZlwqcwgRwyXF5XisdJnAxP+/Epk78H1Vc/S98ra
yoTkk2ta2wXV0Nw72w/LeDDhYYpYTQb29/TCVZb7sP2e88snDbdnZZND5S13
Jqger1Uv3qKG1GbNrJTdxASThzGGn4PVUIPhfBeNFUzY0lovzMF6rXlcEhK3
kAkZdM6QCdaz+u38bAdjJqx/udD/3i015N/86oR5BQe8Z5x7Yuuvguz4lTVK
EQfMXbbNfO+rgsS/O95JKeJAYc0n9Yl9KujX4TfbfhdwoLrsd+mLnSpI93j+
7LYHHAj49cv44FYVdDY9mONzjwN+Rp2GtA0qSDKhvKj0DgcuCG5bZLJCBc17
vKmn8TYH6ELB86sXqyBt//OHi7C9oH5GCpOjgi7OXUTzxvcvaF45VGisghb/
VO/tu8uBL3vi4pL1VNCOn0vKps7nNJt8QFVVV0HrZyqtlsX+tD0WbQlTVEE9
+5nWSY84cGuDhJWAjAry+Vz0LIXLgZnfqiWeiKmgJp+hozPKORDbLXBpaLYK
OhobYnzrGQfsnG6V3BVWQRwdvqpD1RzoH9aTFMJ2m0Atx+I1B5roqf5j2M5U
0c1818CBH9b2v07OUUHKx0sMjN/i9lGz2i6KqyClig2zF3zA10/98paWVUGP
bQP2xXziwNFB9n/V81SQ0NDLhdt2WEPMt4fd4nR5pLaG+VjS1RoGVV6MjmvL
o2eChh/Wr7GGPQfqDa6IyiMv49atTxytoSCspqu9Qw6dp3rTXi21BqcZb1bm
5cqhZT9PFdUutoaqrxUqQ/vkUMwR/WR+bM9xyOQoGcghpVNX0vYusYYD8yXX
f+uWRTpJq2sm7K1BIaRNSilXFtnEp+rvX2ENw+Gm8wQCZVGTpKb31nXWcMHh
gjFntSxafVdUaNVm7N+AeMtxS1kk+N9etQee1tC95ZH5JjNZFHLiwFivtzUk
tDYKydrJomdhK8u2+1uD53ZrwTwPWfRjep7lhRBrcAhe+1YkThZdPTTjlHio
NRy669P3qVoWpQQ0ih0Nswa6qpGqjqgcemdXs6cQ20Jss7vLVsih/yQ0Thfg
+7/O2ZUeFiuH3/8WfEs7gtufpdZBqZZDwTsXqqLD1iCqkTpTcVwOrVJ3cws5
YA3LSuLc25Tk0bSEm8UvH2rBF031D5fszJCyIZorckMLns1TankKZujwn+7A
YylaYJ0fcW0/0wzxPWJMe5igBcVnu1IV9MzQ+GhbrPAFLdjPOOG3VNkM9b11
rjlxUQvs49SP/Sdlhh5tzNHiz9CCVsOVveFCZkhBgK9d9rYWjGxxrs+aMEUF
c/1ma5ZqwXaZLe8O/DZFZonXZF3rtYDDJ73Frt8UVQ0OND/t0YJKF7f8Q72m
6HznyNoVgtrwaSQ/Wr/HFLm+4WtomasNO3bzrstqOiTaGGpD3Vze82vjQ64E
2WpDjhmv/KGkwReRa7RBKZZX/xG9xSfT3LUhfifPv4fnUj7O36MNPbU8/8+u
lZyfuE8bZHx57TMNKr7R5YXrq+G1/5iqkLGqhzbw/eDp86OOHhe3URuaHHn6
Ja6zHXhtj20nnr7v6L9FVHI4sKHCVr5z1AKV/Ej9NZjLARH9a2eVv1qgb9lD
667l4flmqMfnbZMFUpCt0Ut8zAEbnQPlO55boGc3uqQaazkgR698WV9qgVzl
ZOS02jmQ/05qel+RBXI+2/ZA4xcHDpzwMpIotkDCFK99W2ZYAoe/w8fysQXi
T2vd5i9jCYxtYttFXligRpuKR8aqlhBYf+TenWYLNCqd639V2xLmW1dZSndb
oM3fg+sM9SzBr+ZifMcfC2Qxk3e9Yd3uvvsiHHRQl/f8I+6Dw3JKHKQYxCv/
p5bms0d6HHSen1f/4iMrCk8xOOi9G8+/Z9+ejuSbclD1Z+m//qefVNV+h22+
I7z2fdHY4zKI77/TX/23/SNqZZ5b9TmoK5qnT5y9XWEfrs+mnaefsERMcrYo
B8n+0zfK77t0x5gFEhtwKC85x4F1yRpdgQIcNFtxsiLzNAeyxd+JqEzjoMsD
T2ihoRzo0Vb0PjGdg64HfrNyDuLA7yKtlKwZHDSQ42A6148Diss8LM/M5KDJ
C/EuLV4cMH4QJEwV4iCRGyk/4nbg/ol3rTqLbaXFNy0c3TiQtszD/Q62C9oW
NXYNW8ACDZ79MWiVevoPC9Dbybvf7KxLvku3BRw5ziuvIvBay/x2C6iR4tVX
cnN6XcdbC5A7wvPnuolBx/03FnC8c+5ff53Efy0/W20BRU/f/m3POdNrToef
WMCgA6+9mZY8u85MzNbhlwW6Icu7//jTdcrZgxZI3pJXHtxSKLYZsEBz8nj1
MRRFolV+WKDyEzx/xM9U95n3W6D8RJ6/Q2oF6he/W6DscF57vlg1bGVhO6Gb
197TkdWVctiecOLpMfMez66/z9OLbx/v/sA0np45q3nl/XjA09ulnFffcCiv
P6TX8/yZM8rrr+wBnr87VHn9uU98/d/2aAzx+pt1mtfeponxGfI5FvBSkhcP
vy2dlW2yLWBeTvTfeHkSMfboXJoFFLYt+RtPSYqaXy/HWcDn3Md/4603bDb/
lnALkLy2+288rp77YVzczwIO/FH5G69b0qTcJN0tIM+ZF883BCOuNqywgJ4G
p7/xfveszG2utQX89NH4Ox7e91LWC5pYQK4Ab7w8nLcoOZZqAXPid/0dT6us
D1rNMLCA+8K88XZIl3fd+Ujl3/HImUn9+/xeed54TXzAK59xW/TveFal8er/
tK7973hvrOX5t+Xrnr/zwZelPP8jHHnzxf27vPZZ3332dz4RtOK1n/Zg/9/5
5kU6T5//zvDmI+/lPP1Unl79O19dnuTpm7yVN5/tNWucES6uQ+7vdX1+zKR1
lg65v/e0xxvvw3+0yf298Ylaz8+3a5P7exP9BkblKrTJ/b2M9MSfh9K1yf29
tNsC+QEh2uT+3nLvrwsFN2mT+3ttQmesr7fQJvf3Shmyb2zS1Cb39+qc8DAM
lNMm9/emlj4N3CqpTe7vJa4T+3uJ54n9vUT5xP5eon5ify/hH7G/1/if/8T+
XqJ9xP5eov3E/l5CH2J/L6Efsb+X0JfY37vITUCkOB9gluLI8q48JtoKlU9S
EIC558P7U9+nf3m5sbD0GcCSHP/IfaVMxMijfQl8CeD4paJ4azUTpZYc0LN5
AxBnV/I19R0Tzbu61bmgAeBrT7HYjz4mkvvoNnYV28U94Te/T+LyVgukiOL7
/yg6WetJmKByx05vLVyerzRtwErFBGV0zFZZjevLyLPvGtczQfwHjnPVsT/d
ZwZpe42wXSceaYb9DUt1ExllmCCBzHuezrkArfv1jb3w9UXLfpqrXQOokJgm
OIafF0x3tXRKAQi/vcreEpd/y2pF0M6LAPL3Volr4/qZzazE1xcAds0Uovdi
/yYnP5YibIumWMT2Yf/5Rq9tY+D7g+u/3LmE2/d2fI7MxGWAmVK5Iptx+8/u
0L9QcBXgv2ani15YH6drDajlJoClhfv1R1g/+9Sb0cV5AIVZL2FKX7sfLnS3
+wABYh+2/Exholc/bHdk3QPouqG0ujKRiR63dK8RwbaynbJf7HkmOnf3q3H0
XQDPSxn3V0QxUYO0krYetltkIoSFI5ho+704x447AGePqOx5eJSJ+hLDSwux
nf81o8EjgInWmSyJvIHtwR+hNlK+TDQxX19hyjZ9/tNnbC4TXZUxspy63zh8
4cfMKd7aLFbcjm1VptTS1aJMRBfzDtPF9VnxN2bPEGIig0dqx6OwbdlSNlrM
z0RVJsr/zcH+Or0wZAT/YSDR79HnM7Hd/G58+aJfDMRoanZ0xe01uN9rqvid
gTqXaC+b+xBgelrk/CnbdQnI12L7wrRlulP373FL0trzCGCzh/2sqfIuRSTb
9WBbTupp1VR96zQ81ywvArh6sd1vyp/K8H5KHLa/05ZKTflrlTpZxMX2sydP
sqba0yDAGazG9pmSz6ZT7aXN27C9Btu2nX6zp/Q4tcDZEmHbXlfr8pRehzcf
LJ0qzzVgLWNKzzFd2ZGp+ji3ztcLYb35j7iPTfkDDddOTPXHNgGP7il/qR2s
pVP9pWI/1D3Vnmt1e2hT/TmyJYeiiO2VY8E2U/0tWeK+vwjHQ1icF2g1MdCy
FcOpzThelk84DDnXMxA9aLF3Po6nDU3SGunVDPQpxbJ9DMfb/gtLq26VMtDd
Rd8XGF+c0vOUyYG7DDTxeuMBLo7Xya96m9XSGKg31YZdi+0fB1WQegwD9TxP
neOJ7xf95tr0JRjbTZ9Ll+PxwNjnH/lqLwMdF6q4r4LHi1BA20Mp96n9XwXN
K/B4etf7Ynf6RgZiNZeOsPF4c18peUBmPQOlx4fT1PB4vHrrt0Eavl6e03LB
GY9XzpG76yTw89LPdw1q4PFszexgVOPypeOWU0XweJ8YfFvXjuuXlvRMvoLn
A0FHipsy9m/FhybBfGy/Y9wfm4/9d36Y32ON7+e8z9bbi9unen7zgwBcXv9m
hZ05uP1z7/fHIlyfiMnwvRSsT2fT12uXsT+u4ruyVmL9fPcWfH+E/dUTSqFM
6TuoE889+V6c/N6oskXCZfUr4uT3RpuXu3yP9BEnvzdq7uovNrhcnPzeaGHU
SDxiiZPfG+3rzejcSRcnvzd6UO3wxfXm4uT3RrXsbWO7VouT3xsN2iHQ7hks
Tn5vNDlwvaL1bXHye6O/7ir0zOsRJ783+h9tyRpFXQnye6PPrhwsVdgpQX5v
NBgxz/3MkCC/N3o+O6qyukGC/N7oxsilc5dPSJDfG33iLSv5Xk6S/N5ooUvP
kxeqkuT3Rqt94mQOKkqS3xv1dpW9tHC6JPm90TJDw+LrbRLk90a1pX+LSN2W
IL832jxzuPfmQQnye6NHzgiWH6QDeT51II3yao4hkOdThzcev2xkAOT51MJX
5BimWkCeTz1r4yyrJGUgz6c21PS1HJQF8nzq2ztF+wdFgDyf+o3CEqk104E8
n/prkZJh3B9L8nzqWilWS9N3S/J86k0WjvM9uyzJ86nlNh15/LbTkjyfmrhO
nE9NPE+cT02UT5xPTdRPnE9N+EecT034T5xPTbSPOJ+aaD9xPjWhD3E+NaEf
eR74P32J86m95UdGHCI5pN6em5dLBpzkkHqH5A7lPj3KIfU+sVj13RtfDql3
2IMZP+O3c0i96+xb+het4pB6174WXbnEmkPqrWh0PGGOIYfUe2OReMYvVQ6p
90Ip3WVsWQ6pd425VcwzUQ6p96mN+43N53BIvYnrhN7E84TeRPmE3kT9hN6E
f4TehP+E3kT7CL2J9hN6E/oQehP6EXoT+hJ610hMnZegAwOfa8SRAxM58E+d
p6AD5h/Cd0atYqK6fVPnLehA2Nk0l6euTBTbOvlY4asO2G+d/rV0NxNJWEyd
16ADy61qHqXj9cZi2tR5Djqw3iI4dt9pJvLYciR4x4AOHClKylS6yEQZixL5
Uzp1QA6xdLOymOjkfdPm1lodSB89fl7uARPd0BKzOFCgA+zMnvykEiZ6Ppta
Py1JB7RaYsL+K2ei2zUXUsICdeD948KTl54w0bsLfLtmbNKBd6W86zujVQQS
OTpg5s97/ovSr+36GjogVMArX+9evMUeCR2w2surHypul16ZpgM1m3n+1ayc
Ok9DG+reB/31v3Dp1Hkb2J+O6r/tU2mkBf0Q0YEnIrz2f/WaOq9DB+Yv5ekz
/geVnWLpwLkbPP38+abO+9CB3ZU8fZfJZj7Rv0cneQelfkUuXx6d5B2uUVkS
94rpJO84NRLScbWSTvIOVkzii/YmOsk7akYrXhp100neUeZzbi99jE7yjsMS
Stp7RYxI3rH/RMz8sHlGJO9YrH3Q10rbiOQdu4ZdDe9SjUje8eo15QyHbkTy
jpvdvOsE7/gswnue4B2RbrzyCd4h2Dn/b/0E73BYyPOP4B0WVTz/Cd7hvZXX
PoJ3qL7htZ/gHesO8PQheMf9Jzz9CN4RLsPTl+AdR+ongp4n0EneEThxK+T+
OTrJO0QbDn2NOU0necdct5RRt1A6yTu2np0Y0Ayik7xjX+Bi2S++dJJ3BEc7
XU/3opO8I1rX9ffGHXSSd2iVD8X8mjQkeYfT5unvcocNSd5x3UfUe9cPQ5J3
GLutPa/bbUjyDoNzeZE/PhmSvENBsTW59K0hyTu4g1dnXnpjSPIOPqW1wuHV
hiTvkFXn2QTvmDvKu5/gHRFqvPII3hGYyKuP4B1Gnjx/CN6hGczzl+Ad8rt4
7SF4x8waXnsJ3rHXmKcHwTtsE3h6Ebyj5wRPT4J3bEnk6U3wDk8PXn8QvCPo
Pa+/CN7RMO323/4keEdcC6+/Cd6x5FMud8E9Q5J37FCf1uR025DkHczdN30v
ZxmSvGP2ZEPajWRDknds2llU6BVlSPKOivGYvPlBhiTvqD1RLqe8y5DkHYpf
TFzb1xmSvEPN94nnCztDknc4vPogIc4xJHmHLt/QqhSmIck7yjW0RiWNDUne
8UWEd53gHbndvOcJ3iGcyCuf4B3npFh/6yd4x+IHPP8I3rGWcvav/wTvWBDP
ax/BO3wWNP5tP8E7zMN5+hC8o82Qpx/BO0TbefoSvCM/N2THd28KBFjQwv1r
WGhPVbtA6goKVITdMV3XyEJP93QvSaBQYJeoJ+vwWxaq1eo4mTkLX68azAtv
YaEPaRLlt7oMQGL7sM5/b1hIEm0M2PXcAPjLbt9RrGKhaJmqfNoDAxAppTr+
fMRCdozI1qpMA1hw3Pcq3GAhftvw2cuuGMD7lwey1ybi8t9qTR+7bgAjBx8r
Z0ewkE1Q5OEVjwxgh3P9vNRDLPTtMltgvM4AaGv3d4btYqGN2xxmTxs0gNPz
fcI8trBQxMH//L7KUCBsnoEZnwsLbb699E4bmwKV1eEHrmNbjCnGmrmJAhkj
1ifWubPQqq9NlSmHKXBvw8aaOC8W6nIMzVl6lgJi936Kng1koeGuH7uYlymQ
IlVrpX2GhVw+1+raplOgcPuPq8KXWciRteaiejIFFhRmS1bcYqEBpXkpjmco
wA79uusbl4X848fMRX0p0O/8p5ZdzUKZZhHf2bcpcL+h3aqwiYWCKiS4VxEF
fPNGW55gfdWMA+yaXlEgvFotbP4HFoqMKQ140UaBO8ydxkWfWOjuZ9+Vwf0U
YJUvepL2mYWKuJzOzkkKHJT5w1/dzUKbvu535RejgsKVbwnm31nohWEU//P5
VHC+rqj1fZCF7IUf/AnvoYJmo/KPRhM2Ymz5oDE6QoWavmPjz83ZKH/kppbw
NBr8Z3lmdNKKjXa3BoR3zqKBhv61RQcWs5Ghwh2hsxI0oBvn6qs6sJHIQocL
M+Rp4Dw9tGOWMxt5xMTpLVaiQXFA7HmD9Wx0a0/RS8cFNJDdsdchwo2Njsh8
+2mdSIGtJ6inJJ+xkMrh2VdvZ1DAtM1J+NITFvI8+qaemUuBmJo8/zUVLFT8
57Lp6wKsv0mZhWU5C3WPzj16pIwCfMN8t9eWsdCPuy4OZjUUOLVXSD71MQsV
aHyzEWimwPtCz1vy2F5nUje9tp0C5TlxqaWlON483TYKB1FhUceJnQ4lLCQo
Qj3+LpwKh/IqX2pi+7S50vXb56jAfxDyadjWWSGx93gyFWaY18zbjW2+0Jyd
yzOp0Kex4Fs9tu9obDOVuEuFaskK4f24v6tXnTn6tIgKxuriluaIha4VerR5
PaWC6LDjchNcf6jvpjfnFGnw4Gry6oo9bJRIvdC7UYoGvyrCivJ3spHt8NZM
69k0aM91kdyyg43OLeVGLxGkQYGtnPvjrWz0x+K5bdtvKhgWsGvfubLRwDb+
e4e+UGFwR1jcnQ1s5GRWw97URAWnpnMTVmvY6OPA3fjYSirIvt7mHbOCjdwV
I5Mb/lBg4dXN166JsJF/2eYD7n0USIqeSLwrxEZg2LHE/gMF6s1/JocIslGz
x9LI2FoK2Di1OM2ZYKFlA+/DLcopYLLk9S6XYRaKu3x1p1M+BWQPjd/1GWCh
tukyVi+vUyCH/5vgil4WcrJ/OlyMx4+zrOTSoU4W+jNhN3HXlAaoZHVszkE2
2pnwJUfXmgYb9Od9WIbbe4X66mOvAw2GJzs5N9ex0eMNsjpCLjS4Xsq/v3M5
G+kZXXBctJcGZ4IalpbYsVHRjUwb26M04JMcTErD9qh7yNHz53C8mTjfOYfv
L/WnZFWn0qDFWFVTB5e37GO06KMcGiw4UTI9Yzsb6XY8frbjPg1SoyQTuv3Y
6EOuu7NRPg1aFxeevxPBRuXXO42/4OuTyvbfTifi+hWrEu/cpMFVS80FQtfZ
iPtsIFIznQa33x6+3JDPRmGxVZJG52mwq/Pz25ZSNjq8To426zgNtCWEKIuf
slFGwDvLOd40UGT0sXKwfXvd0P3rrjS4ebr8I38ZGwkovT641JEGXOvFvzIL
2ehJfS5oLaRBhMhZf9ccNpq92H25qRkNnoVqWDOTcfwURrlqsmhQeDlYLvA0
G4XwlV/Rxfoar90knujPRk83zdv+g0KDHvVzMX+wvjcrt68e0KOBQGrSQX8c
T+My8drzdGhge6jZ7K0LGw1eXft4nyYNdA+lrNDA43doxGykT50G065PGq5b
xUZ+O/3jL6jSwPHlSlc/RzYSEs1c7aWM9T/DdQ1ZykapA5Ed++bj9vhzS31t
2YipzJHMFaDBptDrSA7Hz+OKs+KtfDTo5ETNHcfxU6f9n7L/BBWu54xMq8Pz
0yzfPo1zf6gwP9xLKekbC62lzZsvhOenIY9Hwmu/stDyI0mv3uP4zwuN8BLq
YKE8GaNvkr+ocE+pbPB2KwtNcNH0rEE8/oS07FY2s5D8txcRK55RoSQ2OVLw
OQsdOn2rsb2YCp+ZgbMPv2Ahaujnay73qHBuiUwyF8/PLTPnWT/OosKxD0KN
DXg9vCmUOiZ9mQoqys+3lbzE49nJhbr+PBUuZJWN+b3C69/7FyaxJ6mw0MV9
+zi2LV98OVgWTIVNu5i+q2pZKD5po2pkJwVa6ItvPMPr43+/I0fzWyiQvVnA
9ju2RZ4mv25/SQHltEiXTmzvvZstKllBgblvx4euY/vCUVGpRQ8pYPQjUxOw
/fn9GuvQW3g8TZs5+2odC1XlUsZeXKFA7+Cj+ubXeD60c07WvEgBSeWgJ624
/m0DA7WCeP6wcbcNaatnoZCw7I8CM2hg8MX0gjtevw3Yh0WbhWjQLTZey4fX
G5PsfN8wPP9MFzcpymtnIePVdRYzRWmg977hbWgXCz3ojE91EadBW37orR19
eL2y8vwYIUkD6h/ZWy54/J/eFLoyTJoGx0XllnkMsdBPau2CxVQa1AnqO5Rz
2MjzVIimnCENli6xG2xdiMenqa1WIZ0GYS3vhITx+NWIk7+ib0wDSf6d3wGP
Xz6TY9r7GTRgKStOC8PrS2hM6fJwJg0OCzqm1uHx7Fj+i7vbhAZBnlJz9fB8
qP+dYqyKx8OfkFvlp9zZqOSxSNKuPtyfy8ZuZeP1I9K+t/P9ayq4Ijf/0AIW
WnHNBRkiKjD/HGOpZuP1osYvvjOPCoX1zW9KLuD5zOnxyoJ8KswNMV5UGsZC
1pkTIomPqRAVnjSU6Ivj47X+rqwGHL+7sxZkb8fr7VfT4KUDeD3IfpiguoGF
9PZl9mUI04Cz1ESqfyULBe9ViwrG87/nQ9WlWU443i90nl9oQIOLERPih51x
f341mH3KggbKTksvaG9kIWHDN28ml9Igk3Z1toIHfr8Rn+9/fhUNhowO26w+
iN+Hjr9efmQ9DeLb9XZdwe9Ld6KX2Ltiu9BGVCwDv09NiHtKGeH7+bZV3Plw
HfffoeVVHrg8jmzp5uFCFmoabT1TYU6D79JaSvl4vf0kIuu0TR+v73TTYl08
Hh6Yue75by4NLB9mmz7E8d9tIZBRhuPF40GUgCG+zo71juH2U+GW1iztMvy8
hfWbN06xkiQPmr9Vh8kfIUnyIL+LNVkmnpIkD4qa8HXZw5IkeVBs3qxi3z8S
JA+qElt/2zhPguRBj/X0GKZ7JUge1JUzvNxeR4LkQV219MPfe8VJHnTSIGH+
RLE4yYPu1f3UMUsVJ3lQ2vIHJcLx4iQPIq4TPCji3/MEDyLKJ3gQUT/Bgwj/
CB5E+E/wIKJ9BA8i2k/wIEIfggcR+hE8iNCX4EH3lG3vPPSjknzZTueJitB6
KsmXNe9q2xUBleTLjWxm8z4KleTL8bW/k9eoU0m+TONfZqOnQiX58s+kPCV1
DSrJlx1uJ1/sNqSSfHnY4s/j67ZUki9HPNN0k3OjknzZuGPG0xP4fYvgy4Lq
l8cE8fsUwZfnuzDooY+oJF8e3iVzsR+/vxB8OfQDMF3weCL4snGW4y1RPJ8R
fDk6zdrrAB5fBF9+/u7Qhm94/iL4stNWtdx1+P2V4MsjyQLiL/D7LcGXkzIk
b9sPUUm+XCPt1zTZSiX58jXR34sd8Hgn+HKwzRyRl8MKZHy7bNuy90ifAhnf
D5JnfHxQo0DGdzXfzbjuywpkfL8usP41sEWBjO9Zkue67s5TIONbgOLuVfBG
noxv7Vu0iMoYeTK+td/suuPlLE/G9zPqq9VBC+TJ+B6s199aOEOejO+PTn2/
I8bkyPgmrhPx/fTf80R8E+UT8U3UT8Q34R8R34T/RHwT7SPim2g/Ed+EPkR8
E/oR8U3oS8S3bN7AnvcfzcGs16lSPIqN15P1IVcHzaFeSDP6TQwb1aj0nu0X
tICxDyG6/hfYKOaTu5S3hAWcjU4pdc1goxHN3mZRRQu473Xk5/m7+H1aPGn9
TBULKNn5KPBD2dT3jGuODipbgN2Vn0at9Wy0f7rYlzdzLeDqnIUXlb6w0UMX
9xxpXJ7In+f7OL/x++Hk1VmBuD5Rjzb1mQKmKGyv+CJl7M9WLb3icGFT5Odc
vGgF9pd7eKe1+hxT5FQ7LzPkpTl8O60qnYmvW1y5tFmGaw6M6UVsW/z87bR8
7x13zEHlVK5dHC6/6ZJK7elMc+jzLIMIXP+G0ybflqWbg1KCnrVTA14/Rfbt
kse2VVDa8xXl+PfUKuWgH9fMYe/WZxvGcftWmM284HvbHMqkBKrycPsffdrj
2VpsDk3WyyvysT5P3L4cU6wxh1TjFWm/sX70U4r7Wz+YQ8oajUTJKX2lZ3jH
upnD59Er8tdvs5Bo5Hw/u1XmcGt45u5c/HuHsWzUMdzWHPbJ8rcO499vImX8
av7G5jCuE6Sah9+XXqnWqwWrmcPuAwc2euP1It+n++QMCXN4t7EzSR6/f9WX
yPUG8JvDgoYEMSH8+yz/PuW4wi8zCH070DR8H5efY3eirdcMagvaVIeusJBS
w5kq/69moHl5daL9efx7uVLaSrvHDBpyJWS3HGOhnvN6y178MIPDraJBmd74
94bw9+h3Y2ZQGE03PbiVhehlHm/9ZpsDs9u4pH8tCyUfOLR7zzxz0Dy1Q/r7
ChYSsPfudaeYwzXD1ed78Xo8rStuX4+lOXSv1x4aX4XL21jLn+RoDtO7W/Jf
urDQ4pn9p2mbzCFR/XBRzi4WOpBwNiN7mzm05lV/PBPAQjKCZo7rPM2hYBlT
V/cM/r0eN/NH/w6sx8i59rmXWaimdeGms5vNQfrKxuvfcvHvwaOe22t/AsQ+
+Nm16uQY97RzcKDQd4DMMb/WT7rjXF97azPdLoDLA3PXUC+OcykvJs9dbQP4
uaao2PjlONfke3bvYBPAGtoc7sUn49wmH270uVoA1w/6i3qPjnObPVY++lUF
cMx9pDhaYJw7+qyJElkBcPvVGbFA5zHu4K2l7tmlAM8rn3woCvnDPWDiNDuG
CyBatUUXnRvl8nmmzXfFdtCPukD/pBHuvv6A2wr4/t4H4of23RjmPlAte3q1
HOBpj0V75ash7rj7NIXKSoB3ii6yzgpD3IFlhVm0VwDtUhp6l8/+5jLGTs3w
awTw/rBU3N7yN9fhfm+dygeAoxWHzQN1f3PVL5bpFXwGeNxY8irE+Tf3DXLz
QX0AnW9L3bn5v7mee27IPhsE8J9t/+Kr0xD3sFb0Xa9hgItM5SWrZIa5Utkv
2Tv+AMxQ2xh1cXiYKyjGuXNsDEArLadve+8Id89KqRz1cYDcTtQmwzfKrVxU
He2Abcfwocv6KSPcO9InI2Ox/cdVy/cYZ4Sr8i79zAC2i5o/5tJbh7kvN03z
9ZoAGM5BR11Dhrlt2xcoCk4CaId/+6mmPMw90C3nfA/bjNJHny+hIe7C/JSO
YD4rOK5iPdy7dYibetjObd0cK/jIutU6beEAVyGifZaFiBWYRkXss/38g+vz
qfWkmagV2Jr8d/6/0z+4CVoHTjmLWUH29nZhMdoP7pMTb+6fELeCYz03jGob
+rnSsP5GjYQV7DruMXsopJ+7KC9quqGUFWyzFpmXrN3P9apcv+qGtBU8Vmrt
z8v8zrWdJuw5oGAFSeEhz29N6+d2iTmGPcP2aOdikcTt/Vw+6/9OhmLbUUSe
ZfOkn3su4HCEOrajY13GYzV/cD+NyKVmyVvBCm6Inkf4D25t/9CwJLbVPjvl
p3f+4FrumVa6Vc4KZG6EVmjZDHD3pgRRE2St4Kn9+L2mtAGuxPvX94tnWYGn
0dlqVDrETXjJEm4WtgKxD/nmR5WGuRxfi8gWISuYxrghbxgwzFWgXj/9eKYV
pM7YlJ73ZpjbW7vY7dwMK3h29Lz/T4MR7iXZMs/F063gw9fG1JqwEe7u1GjR
TkEr6NShn9V5N8K1iXrM3SVgBV2bXhl100a5SnUJ1l24PRqCYzd8rfu4NY4t
gbZYP537d6JYHX3coR9/ftni+tOe6JtHYjuc/twvHfenwrJ0mR0L+7i9QcGu
c3C8MaVGJPNEernCHMNDygN4vBiNbFq5qZsbFKq3Z/U3AN25CayJFV3cfW+3
zxnrxfF7baNxivxn7u+6utlUfP1ObWRT2/t2btask1X1PwAU2f1vT7/8yI0q
Wr/86hAArG2VqZdr4wa9CVykiesX+hijI3z/Pffu+ohLJViPTaHzKihu77hj
dT71xTgeEhz05x1Y9o7bvOI+dTdu38PSrj7n4PdcD8WnIdKqViBru6fErfkD
1+LaN+95WlZQJavCJ5HwkbtRN4kyU88KIht0QsIut3MfUT3sTuhbgWC1z+pD
DZ3ct3NvUv3wddk4myXrJLu4JZ/NUr/j50eM6pzsFnRz72TX9pipWcFr0aao
Zx97uPde6Wu/nGsFIcNO8+Zq9XE9OywkXg/qk/uzQ4Od9op16JP7s98vDnwZ
2qRP7s/eNvPJ2qJafXJ/9pbF+z/PfqVP7s9eod2hGlGnT+7PVs4yDxR8p0/u
zw5efpap8FWf3J89z2O6m/aoPrk/O6WTuWuzqAG5P5sCoQZVCwzI/dlDhqdv
OJsbkPuzH6uc03nvbEDuzw448L530S4Dcn/2o0+iwyEhBuT+7I1doSrRMQbk
/uz2Q41vM5INyP3ZSq1UhspVA3J/9s+MdO+kLANyf/blZw6T3dcMyP3ZnV4J
EeqpBuT+7NUqZV0X/jMg92ePX6m3rT9hQO7Pnik+abvDS4fMV76IWiUj6qND
5iv1J/jfHTiuQ+YrjzXkHlt3UYfMV37g71jxpkCHzFeKNJuv832rQ+Yrf1XV
xe2f1CHzle4z+oS+quqS+Urn3peDsqBL5isnjC6lxazVJfOVNm/2Ku7foUvm
K8VPidae2q1L5iurCnjXiXyl+WTy3+eJfGV4Oq98Il958Gbv3/qJfOWsXTz/
iHxl9yGe/0S+0jGr/W/7iHzlvUhe+4l8pcoznj5EvrLJm6cfka8MFuXpS+Qr
90Xn3s1g6ZD5Ss828Tw/XR0yXxkVkxqpP0+HzFdmpH2/+UJEh8xXMqflXt4w
qU3mKx1bLDtb+rXJfOVuvpUiKz9pk/nKKJbX1fI6bTJfiSe8pqEZ2mS+UvLK
I+9dw1pkvrKiqjrh41ctMl/Zkub2YctbLTJf+Xy60qvvL7TIfOUVBa+BmBIt
Ml/ZXzX2dNFtLTJf6a3s9lw+XYvMVybp8GwiX5neyLufyFcGa/PKI/KVHrK8
+oh85Zt7PH+IfOWj9zx/iXxlSj6vPUS+MvgIr71EvtJ+GU8PIl85LMXTi8hX
2vbx9CTylTRZnt5EvtLyLq8/iHzljsu8/iLylXP7eP1J5CsvJvD6m8hX8meJ
stZ4aZH5SnPdQs9cDy0yX/mucHa63TotMl8Z8dF1zB20yHyldp6OfpeqFpmv
/NP6SmPJpCaZr5TqY3ctfatJ5iuv3lHxqyvQJPOVD55bnL56UZPMV8464f1O
P1STzFeWtV/eau+rSeYrhymTOfR9mmS+0nKSd53IV74o4D1P5CuPy3D+lk/k
K2Nnqf6tn8hXTjiY/vWPyFcqQe1f/4l8ZaGY7t/2EfnK1fpuf9tP5Cu7vvP0
IfKVtMU8/Yh8ZWQ2T18iX0k7+dq8cogDDp9WRns3MNBbzqL0yV4OcNoTlws/
Y6BCW9mo3M8cCFjjdJuaz0D9dil313ZyILm96p7FVQaiCkuel/3KAa3jAQ0Z
5xlohMO1ufyDA9Z1y088D2Wgvg9eKZYTHCiQsJg7epCBYjeI2A2JWILVkHE1
cy8DVXbYhB5XtoS6Ts8oxi4Gek+5L3rY0BLU9+69sGQ3A2UWOInvsraE8gXx
b9fvZ6Bc37DMESdLKGnqe9wbyECUmjP1Yxst4bvwBQPt0wykmTPr8LmtluC0
x/z9l4sMdFdn337aNkvY9Hvm57ocBjIzzvUr2GwJxaKlNkElDCR37xHXe50l
XAlNdj849f/0gyOrBZdZglpzIjXgLQO1nPjisc/cEqqH2DuDOhhoY5lqw09d
SwitpEuXdzFQVffIqVF5S/iWM+Aw8oWBOoRO3/gxE7cnw2aD/tR5f8E7prNG
OKAWvmr1m0YGKur4da7yCwfmUi5f7R5kILdnzYqUdg5EflO+cvoPbi9qkXBs
5cB+I64enyATXfH+PmrQzIEq9uvOJbOYqDmz7MCLOg58Unh0aqsEExWuMNHR
r+HAOvGU90vlmShTrPHj8mccWKmpkD+pxEQfMpf7MB9zoJmv60+IBhNVdI4w
3+7igEHbhZUeR5go5t7R06e24f46umgkN4yJxBZDEp8rB+6WvBQujmSie9se
+Fmvxf44mV+OOcdEKvGzTVY4cWBU1ax9wQUmsjjqM4dqx4F3zffkA5OZyMPI
l95qxYGEVc6xZ9OYCOWY/NxsyoG8PokC92v4/tzmxkgcD5c3bk/92MdAunfh
PzE+S4j9fMZyEuvBZzNuv4nfEmwLtwbojOL+yeLG7xewBCMBxf8R9eXxUH/f
/222VISKJGYoy1hnzDCMmcuUlFDZK5WoFKFERJEkUkihLFkSyhayleqSUkJI
IqVCkaWyFVr8zvvjO6/fn8/Ha+7rnnPuueee1/Pxej1n73//9z566aqMxXwO
Wq1waUESPwNH75NIHAdc2N3j9nERA8f+3dLpuICDOg+JZSiLgz3fF1fGAQ7j
Syj0lmJg1eDMmhE+Dvoqf/fOyqMM/OetBf0b4GpH9cQDvgxsum2+ThHgzZHf
XYpPMbD1j6h3BoArdW/K/Qlh4FAlz02X4H5tqePPOf/F5+DD0lyYn9wm6R4A
8elQVDgYDfZ+sA2SvAPxueD8+B4L/HFYcOhNezIDixVmzmtUZ6P9wfUdCokM
7NFQ7XuQxkYTVZs6Qy4zsOLrqmATXTYSOZljKXKBgVXW5F07aADx87l67SnM
PzHcTnphBPGLK5jIPcnAy9btc3U1YSOl1BdpNT4wPvRJkYk5G6mf3/pMxJOB
vw+bkRyt2CirIPhM9EEGFrqT7lCZw0aWTS2q2SIMzOmWXrikCPa7pkLoHiEG
fmS+cyqunI0aRxK8t0H+SWv1rbZ+BPbsUf8U+Bf230y0g/FTNgqN1Ega+EXH
l5Yph7k0sFFGW+n+K6N0fGCv0t6KVjbq37Fi+BSs75KvzqmMd5C/1Xa1ObBf
wjSjtzSuZqPXyRaT18sZ+GFyuW28Mhu9KTiQyV/LwP02AbhPg42iw7ec/fiG
gRv0LXsMtNho98XQqJavDKyrUGt+Sg3yKzvQ2O03A4uenpqeUGAj4dDdhuuE
dfDOUwoyVpJsdOW4lsoySR38uOK9VJIgGzk9c2p7I6eD60byS0V/GaDawtt7
2xV0sH22IWPlZwMUNtSWWiOvgw9aPTyq3GqAVNRsCopkdPCWjw83JDwxQA80
5tFkxXVw9OD2nPh7Bmjvg1zbngU6uGguKp5/1wDZPrnrLD/OwObV7KP7igzQ
0ns2pjrdDDwSkUfuKjFAv4JkRaOaYD86rgxY+9AA7dGYaxyLGdjtCr/rlToD
9E5Hc+pSMeR3CbdE6a0ByjOb3BV9G9Z3Q/PRG4MG6Dr77f6NsH8uRL8tTf5r
gHwWi3yWyGLgXwZD9plL2CjVfuG57lwGNplLj9stA/VF+SZZv4yBa0nPFrzT
ZqOhne1rPxUysLiRqc5v2I+eiqdqd91h4NRO/qm1sF/1S+6eEC9g4HtRd7c7
bGCj5l/22TN5DLzbqOJgkhkb3WD2ZcoDlnGr0uy2ZKOquTb3A2E+uvGuctXt
bDTitVBKAnBTyg2BE3vYaIX2408fcxg4fzx6s2YFGyl4qZ1PBn/uBhYfPAX5
1C861ZAO+LRT1vYXT9ho3oxmxEfAX3serllWD/VnxYl8GxifO2DSYt/CRuvy
68T44P6VhhoH49vZKJ/ic3oQcPnmKxMvoF4WUNlFQvngn6jn2YleyFfjg6a7
wZ+H+hIHX02w0dnRJSF81xm4WScv12KcjS4d6Ovtg/35++aP8XljbNR1Zent
B7B/ew3Vbw/D+fXD1L46DPa3kJ21vChgPpUeWVOoj64hHTcP/WCjo67RZfxQ
P/cPJe37+52NTHocgx5A/bgy/SHkGeBEk7dHj0B9eXlgQ8Dhb2ykp4K96qH+
zCy5LnwEsOPQ+vBAqE934geE8gC/eRRyn7aYgTOnHJxJMP7AspfzB6G+eVed
/NkA2CwvcHsW1D+TII3zRTD/XN8dpf/p/ZCrn79pBPvW/RwT1hmnY8+zKqFk
8OfpxoVmS77R8Vj31jWycF6fS7Fsq7sH50N14+gMxGv+6zy6WSUDr1QW12qF
eOpuOB589QEDz/He9zIZ4p2+oMUq9yED76jeg3fBejRVr7MJe8TAyVftpiRh
/xdNvzZUhfw9+/D+kUZYz+AwUm884AFnH/JpWO+dz1ykXwBeJBr+vg7ywSL8
39El1QzMf3Y/DoB8iRikaggBZqYdfakB9enI3+kjL6pgfeR2LPgC+VbVW2hu
DXjJymbbNMhHDXPHgUy437/qAewE+fqkqcQfgz3zys9qa+izUc3z4U3pYG/W
+K0MPjobOZdWF24GfxKWNa+P+8NGWg+azRbfBX/az778t5CDVgmKu62/xcDa
l6fUO6Q5SLIwdPvPdFj/tfZWL9Q4KJWmdjMNzq+QR0MPnTkc2B+U1L03GVig
ZlKYZQHnj2MqYwj2g8Gg35jwTg5ad8tDKgrie48TvLsB+o2N/yRebqhj4Evc
Y6H1LlD/p8rOvOqE80m1zqbsAAeRzqz99nyYgWtebVyU4chBS1/8pt/7B/HT
8jsgYgvnU2R4uMliHZykNJrTYsJBpvJzFmyCepa8XoQmpstBPXvHMt+t1sH3
3tVNrlkL9v77fsIP6pvqPusFpyQ46PXAl70zq3TwDv7x7hA4rwq45JoSCR38
xGLb5WDo9xy3M+uNBXXwe8HDjGDIvwM9iXWFkwwstWRrOmuAjdzaZkoYfQwc
LnYrUmiQjQYj6MGs1wzM3n8+oh3yb+rhXmvtGqi/jdPbqL/ZaE7uu0H/EgY+
QX76wP0OC9n1pk84m5DxJ6ETNovusxDrdGjVIsADXvlvjz9hIc/PRrKym8lY
7Ir7DOslCyWb+yS7W5FxwuPYe9/esNDDPFLA9T1k3FuF56t+YCGjx/Vlaz3J
uGsNWySjl4XWpwX/sg8m430Nta+k+lno+zw/6cNxZFxyoaR4/1cWcslZKBmU
Q8Z6MT8pAXDdXkzzXhYm4+exAj7On1morcKr/1crGfux25YZfWShBtbo8MU+
Mq43jbAz72ChDQKhOxN+kbFkDv/rtiYWWna9acWhBfJYt/mbkF4tC1Xu0VZw
XyyPx0rFOT2VLJQlda3bUEweW4fLtq8vYiFm6UGvAsAuhbWb27NYyGbstUjR
Enlc9Db935LrLHTtBonjwy+P+xaZrLWNZaHf8fmfbafJeOciW1GxSLDvnCu3
a4CMbbZHfogOA/vfOSwpbSfjQn3j+UvPstCjeonBWzVkHJV2rWBXOxPRq+Il
BTaRcNzv9CPnepnIcJPx2ihnEj6b94LtP8REa89n0dpDSDjrXdGLuO9MdLRc
28w0m4TfmLuZJAwz0RD9xVnRehK2WN16Kv8LEz2d+Ge/cZiEz+2dc9Gxk4le
mBckmAqRcYHxzKnEeiayqRZb0y5DxkV7Jwoj7jPRlv7rCzYqk/GRicZT0beY
yD4i2LRYhYy/bFGTk77KRNLX7g5MkcjYdU+SREwYE/0kZ/I3iZDx9pt0B+0A
JvrWcu/q7QkSVnqg2DfjxURtqvEh6a9J+ODFSLVkTyZKXhV7bmMRCcevbS/Z
epSJ5kvc9vGOJOFxc0bAtC8TSZxfzs9/mIRntlyvXhIC81c5PL21hYR3LcwR
zIlhIpPtG8Sy9ElY7o2i6Y0bTHQ7uNIuT4OEh3dESiSWMNHlgPzTRWokHDm2
zZNUy0QpnFTtD3QSZguKnmlsYyKxIx2xERtI2PP9iasHC+kEH7QtaU2QwV06
wQcFWwX0fL9PJ/igPLyttLuWTvBBO20OX5d7Qyf4oNGqa2me/XSCD+rT24c8
pukEH5TcPjJ1W5hB8EGxpk7fq1YyCD7I9ftG41NrGQQfFPmIOv+7GoPgg8av
zdvlr8kg+KDmwtnrPD5o4evZ8Tw+qGDt7P15fJBi7uz8PD7oyMJZ+3h8kOOl
Wft5fNAV5Vn/eHzQ+sRZ/3l8UABzNj4EH3RxNn48Puj2u9n48vigG0kt5oLx
dIIPSnlyZstIFJ3gg6jJpvfrw+gEH8Re61WfdJpO8EGhti01TifoBB902Ui6
X96LTvBBadYKAR9c6QQfVDSi9eyqM53ggzZHvHCk/tMm+CBvxY68wZ/aBB/0
Uq/bMOu7NsEH2a+l7DvQr03wQdvszjuof9Im+CB2d6H7vw5tgg/qvefX0dGi
TfBBaz6rdFa/0Cb4IP2BWczjgzhVs7/n8UG5X2fvx+ODUvfMzsfjg+w0Zu3h
8UGm62bt5fFBBlqz/vD4INXYWX95fFDM79l48Pigg7tn48Xjg0Q2z8aTxwed
3TMbbx4fdEF9dj14fFBqxux68fig6Rez68njgyrSZtebxwe53Qq+5FioTfBB
5wfe3LqYr03wQdupp407M7UJPkjj6W2v/gRtgg8K0oyOuB2hTfBBX2ucwraf
0Cb4oAnTq193uGgTfBAnX1hTzlab4IOM9RP0hEy0CT7oSHxxz2aWNsEHmdfW
rX2nrU3wQf1D0y8sqNoEHyT8evY6jw9qKZwdz+OD1PbM3p/HB5W8nZ2fxwe5
Bszax+OD/Cdm7efxQSYOs/7x+KD4wVn/eXzQHrPZ+PD4oAVTs/Hj8UHU27Px
5fFB6q3iifH6CPGZTX1VW4pw5TF2lpoeQjlSz/NEVyKcIXnZ24qB0DRtbSWV
jHBUt+KiHZoIiUr3iA8rIVwev1KyUgmhzDidyBI1hIccQ5ZLyCFkYxgzpqyJ
8NGbq2slViDkd3jfuxWA423sBnyWICSuoVIZBL+XTk7xGORH6OrJK4+vwf00
TVXXLZ6L0Pi6nUm1JIQNnnq8uDXNQTeW6NjESSH8ZjDFU2aSg3yfNarkiyI8
/Wr2+oYz+2eeCCC8x252/O2U4KPKMxwcWTB7f08dMYWzIxzc4jY7v8zHL9Sy
Pg7OezBrX5Kn52hYNwfTT8zaX922vMYZ8Kr8Wf9OMusjzeD33IlZ/11Z3me6
fnCw4trZ+DSKf6da/uPgaf/Z+KlntWaZgj3R/xffwWMZrupg79JEheG2cC7S
8z+9Phfy3ef9go23g7low7nnQ13fDHB+oIxlfAAXkTvyJzN6DXDCJzmdBb5c
pCZkevj2G9gPAkv7Dby5KF0lOOH5MwPsafllqdcxLnqq9urxn3IDTJoOEiyE
68W5d/PNbhlg3cATfd0w3iJzhWpNggFOJ8eMtJzkor0uDdVWkQbYmC9ZUj2E
i+TLna83hRhgrUWxR8MjuCj2NG56c8oAf+6c5hy8zEVRsXENjQGwP2/vWbwx
kYsaLs9e786zO5CRzkWOnbPj+SKcImeyucg6Yfb+bEX/q9/zuOhOz+z8gzeO
HScVcpHvyKx95w1F3HcXcZGr96z9m0N646/A9SOes/6lpbWaNOZz0SWTWf+F
/7xR1b/NRT8WF/wvPnZXfzCUMrhIIH82fo1tTTG/k7hoz6XZ+OoOf02XyEXo
zWd7tyUHBfGFNZtERDMRovx1jN1RKYgpC/0HBq7D+tb679k/LoivrLhVJROP
0Nd7WdyTi4Ww5hqsrRoFv5fy+DHJJ4Tn7svemHQOIbGkbqZdlyB2W7cofjgI
od7rreU61wTx+OH8zmh/hN51WN1foy+IF57WiP54HKFlxZ/2W9cJYOMHaT9W
+iAknKC1mmEugN9sC+l2APza2U3kZyM/Zqpu/5Phi1B+x1aNSSt+7Hp5ZdPz
AIQqzo5WGPfz4c34sldoMEKPOBYXhKP58JOX81edCIf9uOrChhXb+LCriEqg
xiWEFDM+awdS+bBYqkakwjWE1hvddbSj8WFFz98Cr1IRetzbePKKFR/m47Pc
VpGFkPJhwYZ5V/iw8LzABU55CAWFvJf2HubDhlE2lz0LIR7TjRv4d/Bj8iGU
nFyMUM8mp5KTr/mx0oIh1yeAVxuUrnluJYBT1rx9q7BciXi/K6okRPikqBLx
ftf9rW/WSc5VIt7vqj2jkkL9qki831W3e6KxtE6ReL9r/4WkZ8uzFYn3uxwT
+CKkQhSJ97smtg+tSHdUJN7v8j4spHaMq0i837VOmhX4m6JIvN+13f0Q30oZ
ReL9ruacOou5korE+12867z3u3jjee938e7Pe7+LNz/v/S6efbz3u3j2897v
4vnHe7+L5z/v/S5efHjvd/Hix3u/ixdf3vtdh977N/+3/6xG5xUaJlGx/GVF
Nwrsz/p9azOir1GxdKDGCaMrXDRDSzvMvUzFK68O5NpGctHwpWvLH4ZT8asC
w7FnUI+eHRuojj9Jxe8bzmV2hXLhebJ96yUPKk6V+7W49iwX+awzdwnfQ8Xs
0oVBl+G6fYRXuvtWKt5hzLXQgfFhHh21mlwqNma7XA67yEVNXJHhQgYVm+rV
VRtB/WDuKnIvV6XiT6rGowsTYP5vwRnda6j4+KFLvt5pXHSZVi2STKbiiAbz
xEW3oF78LU+VlqfiX30jnbZ3uKhInXHKRpGKi3Zd8OwphXrZvSZ4oQYVy7n1
H9lQCdjrnNMDJhXPsZ7YrI65iJ2abfrEmIrFXxss3V4N9SNw/S5Layqmu1NM
sgFHmTpcDHKG8bkykhJVUA89Vw7v8ILfB7lcKn3ARTLMHRlTQVQ84u0l96Sc
i/aLFV04fYGKc6eT6SuhPrETpj0u51Bx56LYn+GAi6iLy6wKqLj3UHVrP2Cr
Xf5MmWIqVlroUsSA+rZeKq12sJSKk7xWHfcCXKswofHoHszn2iKSAnhPswsn
7iEVb+3vcq8ALM19VuVRTcXCe/5GVAMuWSodvOkpFbe1Kpg+B7xGb39C+B8q
Nmryk68C/NJ8i5PzHBp2ablckQWY9enojMECGh47f2jZScAB3g3MZYI0XGKz
c50hYMvK1V39wjRcsUTFfhzsvaKzvqJMhIaXK464xgHeFJJyLUichs/KKiQo
AvZUdbMwWkHD2kZlPhaSXHRjxvDOaAcVh70qneO6lIvCH2/w7n1FxZk6KWv9
hbmI7vgmML0O8mtLIPk9PxcZ5MhpPAT/HvXt9+6Yz0WDq3I4o3eo+LHfx2Mp
87joYreg7Yp0KnbsznYyguvX2e8qll/+7//eWdxyPi6SVHv3pzME8i201vOt
EBd13zx3ydiXimt/vZnvIsJF8ylHlq5yp+IVpknPhZbD+eK6Q/bPfojPU8Xr
tjJcdGy9f5KNExUncPDLLgUuKmClv3AGrNr/WVFZFeJTJdG45gDkQ2MipYbK
RXaVtMJdcL+1KyRIJrpcZNtKXnQd5nM083fbxeKiNLGMcaOzVPxzeurDUzYX
vdsw9D4U7P0VGZSzg8NF5neOPA0Hf1azLuSLw3UrY5+J3YVUHPLNV2C+Ppz/
rPOeco+oWKMx9o09g4u0DKbXj0G8Pik5WDhqctFARNWL1a1UrPj6xMNbcH7O
c1u5aB3Ef7L6zF8m4MhXAk+CYX2+O9vIduZy0VDWNaN7sH45T+4YXgT8e8jr
7iCsr87OPwFbAPt9kt0sCeuPnY17FQB/1M5lGUJ+BPcxzy4EvObx5nsHIH+e
eUi7zAUcMT41dQHy6+/0WPZ0DuRjff4nM8i/SzPXm+bB9SNlNZJekJ+uf0P0
VgFesCY94Bqs78d1+V3GgGuiNxhVQ36v9qssCAY8vPFn8jfI/5VV3xJeAs5t
fFktC/vjQbZimBr48/O0d7cN7B/zO+P2SYCbOrJVY2F/tSw1OP4W9t/pQFHb
UAYNR861zngM+/Pnv4SAZUY0XGP0LU0S9q+16bynJRY03C78Li0D9rdm4F8U
tYuGK0Ut5SwAq++ujS89TMNX17i5yEB9uPWpOF0/gIZt4eyiQv1YGqlkrBtO
w+I+LVUvoL6Y124v7LpMw28N3wVzoP58CBJbFZpIw1/IfiYT0N8ILj3LLEmh
4Sbtawl7oH6tWVF4TzmVhu99FEueugbx+ck8+C6Jhlcsv5VCh/r34dvda3Pj
aHhfVu/bQKiPo3utvvFdoGGHmPZ6KtTP1cEmyecCaVguaV5KDNTXtzEHb24+
QsOmVNFvz6D+di10vsDYS8MmCw8wuuH6q7xMF21LGn5YvG5JA4y38bWS0F4P
+SFSwtwB9b1R64WXOJOGH+ttOrcO6r+EhlRFjAYNM+qYJv+dD2lbJE6ZKMN+
DhKWSYfzY9ujtCNX19LwlQzzQ5kFugTf4eM0tfVEkS7Bd2RKbylRvadL8B3N
59aGyT7VJfiOIBlDT4fXugTfsTz8sFfeF12C7xCexxTLndQl+I6qlCcv+oSY
BN9RIaZT9U+SSfAdUaUykvcVmATfURTK/5qiyiT4DknHNo1ydSbBd0z4zl7n
8R3qSbPjeXzHq2HG/+7P4ztMvWbn5/Edsc26/7OPx3ectZu1n8d3lP9A//OP
x3cc3DvrP4/vSJ0zGx8e3/HHajZ+PL6j8cZsfHl8R61Tptz6WF2C73h8wZas
HqlL8B02zrIXhc7pEnzH3mHj6x2BugTfcXt1Zlyqry7Bd5QJfa/Yc0SX4Due
rJo0W3VIl+A72sr5El7v1SX4Ds9tKTSPPzoE33HtW26g0oQOwXeMzS0V7x3W
IfiOk8P/GBlfdAi+w0d2l4brBx2C79h76yzSb9ch+A7BYLOc5c06BN+xMfdf
7sxzHYLv2F04i3l8h1PY7O95fEfTndn78fiOGsXZ+Xh8R8DPWXt4fIeH8Ky9
PL7DcXLWHx7fsWXnrL88vqO0ejYePL7j4trZePH4Dpr4bDx5fMctxdl48/iO
OxOz68HjO2pcZ9eLx3esvjy7njy+473L7Hrz+I5oTxun6wU6BN+RX5jjX5er
Q/Adp6asJCVv6hB8h+XFU+vXXNMh+I6MX04OfeE6BN+x+ILO9nhfHYLvkBJ3
u391vw7Bdzh5f5jrYK1D8B2H5rkvMjbWIfiO2F3nSsL1dAi+42jk9UlJmg7B
dyy625h8QVOH4Ds0kmav8/iOn76z43l8x1bF2fvz+I6OtNn5eXxHFHfWPh7f
kVI5az+P73BTcP6ffzy+437RrP88viNEwvp/8eHxHUp4Nn48vsPmyGx8eXyH
0Z8vvofdtZDCXQGHfnMavv6mGuu6aiFa3I2y5D00vFr+2y81Jy2kdrhBqcyT
hheVVRiO2mih3KEdKwdO0rBqoVhz0AYttE62KETxHA2fKNxZvZyhhSzcV+YW
RtDwV7+3OVIKWuhJVq0dBbBb8ei3aTEtFLzg95aUszSsZbVxxcoFWuhp2xP/
QH8aHu0Sy86e1ES3B9Y8TITzSfRyZsKlEU3UkLTCfKkDDbd0Bp/d/10TDVkL
ttBMafjUg2ffLEc10dIIN/JRqO/K26cqZKY1kUXul3e6UM9jlppOy/NroaW7
dNa8lqZhA4srTz2WaaG9KmeG7MVg/iIngdq1Wkh5LK0nfDENf8iOz36iC/45
bn1fCzjmjZzy9EYttDxn4uMS6C/mPT/Knm+vhejH8qJHV9Ew+YIQJddZC62u
CnubpULDhaKywXxuWsiatN9omT4N3/gpvNMX4iuR/tf762Ya3ngsIubeKS0U
SlcqVbCmYeH+p3qLz2ghTm+0gJItDfv1pqqZndNCnU/G8VZ7Gi7bMH+5X4QW
erzunnbaDhrmusjdjIrSQuzHXreWwXkuuehdTNRlLdTwQGp7PqzXFWPq9ePx
Wig92sTnkBMN88skXTRO1EKv6k+TN+6H9RIVE1rbpIX40ps3Xoui4S1P+m6/
faWF5nXhlGsxNCyYh197vdFChYNn8u/F0rD+oSaXH2+1UKrDzxO/r9Jwkp/h
ZosuLRTBnTNnB5znM0MXjkR90kKxfP3q7XD+39J/+aqgVwudWZf1/cgNGlZc
vNK3oE8L7cwwIilm0XDyY/Nph24ttKpUMHYij4Y7LcS3CcP9nARSuaM5NHzY
krn7RYcWql3DOv/sFg1r/GjzSXmthT5k+iz3g/E3Xlb0hTVrIWelB2kLbtJw
I+XfVFiDFnqttmLENZ2Gt41kfUt9roXm7OhvLQB7Pq5kzzQ/0UIvVxcoNYO9
9xSfnRmN1kLJG3fPPe1Fw3FHRz8ZXAT/FnvmBEF+d52XKssI10IjM7lJuyH/
chqEFJRCIT6Rek2rD9HwpodX0fNgLbQiW9P0EcSzb5OZdHigFlr8xWSVEcTb
4M/CCpcALSSbFb4jezcNP1LBEgf9tJDxhm/KY7B+V8ryNBLHYL+UvBcYvUvD
n+bQJ0/xUZHJxi+ac4ppmK9PPouxgooW+93dsrYU8lnNwA2e89AAlfVQ/iGs
f/wBjcvaVKTwzdPFqo6Gy70OyL43oCKVOayZBx00LHBvX6C3ERVF+XgKKAzS
cNv8S2N/Dano9PJjBqS/NJz+oUAsiEVFCzfYG6xboo2Rql6aG5WKlKKm5NVk
tPFAbs3ZGAUqUjTOenZLSRv/YfhrLpGgIh3WJ9NGDW38VfZIHXUeFf0Lqpkn
SNXGeXrr53r80EJjnpV6ynCdZFeerPFRC5UUdfW4KWrjMUklw+oWLZT/OL/t
iLQ2ruBWpevB+oRo71yuvkgb99QPHdlZA/vnw6plndM0vHBqeUYEYAFqW9S7
fhr215f1rIHf50hs58t4Q8NijhJJiZCvZIaC+OVnNCzzcs6KDZB/k0fVJD9U
0vDpLhX1/BEtVCbFdfYtoeHSi/+oXiIUdCbTSUrsNBlfG2ySF59SQSvz195w
9iXj7OWiX8mfVRC5YkpXyJWM5Y/L0a61qqD1X2plbtqT8VHLtylGz1TQJD30
pMh6Ms7V628rwyroTP8U/wZ1MpY8Jqxs81AF1ZdkJO1bTsZhXyMX61epoBM1
pJKYfyRcYVZSYvRcBZ3dEyw+0UfCE4pVtUJtKuimsF1YxisSFrZRUx39ooJ0
1ua7JlXD713yClV+q6Bks/XHC0pImCV9WLliKQVN6O+MP5lHwuczjp8KVaag
xBWCmm63SVi2KZfqZkhBpnoPGGm5JCw14phgZEdBIs63ds69S8Lpt2PXfneD
30vG7NHCcH/dr4uOnqIg3bfdxxOaSHip+MGM0QgK4h+zv3qkl4TneGh2Pb9C
QZopSiZV0yR808je7vxVCrJTkfH3FiPjM36WWXzxFMQMXDzgokLGTqL6V8yj
KYhU5snxMiRjR6GkTceOUNBmfw+DiAQyPqtXwfh3lIKyd/OfeAV4gYTQrrPH
KKjvSqOXciIZW7z6ul7Ih4IuPXwlchEwZ8/DY+HHKaiY26n+D/DDwxJH+fwo
yFDKPS8giYwrWHVPA05Q0KmPPU6CybCeE7S/3/wp6LO1x9o0wP3LN30hgT3C
JRL+jplk/DTP5nzkJQpqcm2WEsgi40/r7ypPxFBQXnPLngrA7YLjltbgr6mP
tqRvNhmf2J+XkB9LQYqXKAu4t8hYvCj10hzw9zCW+ix1m4zdxToaN0E8/kyn
Hv8DuKmiYeDCNQoyKig/NpBDxktrG9YNHYb4bl92sPAy5BN1384L7hS0/WF7
q2wMGYd++XtAz4OCfnlckroSTcZ5MgJaPwHPXN9SvCSKjB3M0gIeeVLQy3WU
VdEX4f5Jd4TjIJ7T78XrJS+QcV3ejwQ/iKfLy7u6t86T8b5ioZ6DXhQUGmz6
2jCcjMffsT7/DKKgyOs/qiq9yTh+qiNh7DQFrdujPONwjIz53mP3P8EU1L74
zyZBLzImJw4sXhoC9iSEi1Yegf1QnEzSOktByf7TZX6eZJxiFG6xM5SCDv5x
yDT0IGOJrZ+YMecoKP3yeQMJdzJeaxAQ2BJGQfXaM50jbmRc+rx0cgn4I845
1L0mlYyHBNdNDANGTX0Og2lkvFKw/Ucl+Pekv2B3+Q0yzveJvO0P/tk66tle
uEnGi5sTvyiDf3nHmwr3w/qkyO5xrwVc1nDvrTGsx4IVvqJW4O8xIU99VYh3
3+X61JeAx/lr9JfnkTH/arsDJMiPzJ7DAeRnZFz7i/IoArD5oapg0Toyzlyj
9KAX8BEb6vjcejJOpe5frwr5Q1Gq1/7ZQMZZf3wN9wI26i/PGnoJ8av0Sg0F
nGd5tKC3mYwvW323uQb4EHss7/0rMtbpWbw7AbDM6q8L3rwmY5uc8jNukB+T
K7avDsknY+qJxPjuOApKoj3+pA+4ONXUcwfkl8O/6b7PYK/Lp0Nhby5DvrdO
mAYD9rWKs7eF/Lxk8U11KeApY7SzE/J5/okd+TG5ZPzv+HkB5ygKelr0+Rc/
4NWP5JpHLlLQboPtdHeIx8vkhf0PYb8wu+5+zEsn4xH+f9xtvhAvxUlDQcBt
7qkZg7Df4qt+TlvDenzI2XMiwpuCplbFcuNhvQzMs2hU2J8y867b1qeQcca8
u6yPEP83LQU+E9fJeGO6/0wsrJfJVaVeMcB906E9lrCe83pF+xRg/xlQWxOX
fYf8n3y5wpAsj98mD2ef+0VBsSu7IqW15DHVQ7d5/A8FDfwR4VoYyuOMr8ZL
lGcoiLz+RhfaJo8ntwWzRf5RkODjNd/NnORx3FD198IpCjrws2+6xUsee7Pl
pvVGKSh4l2mq1hl5bNb8+NtIH9QbZb2Qtmh5/Cq+5iCzk4JuSAy0sZPk8QaH
B3si6iloZe1cvb8Z8njEJPTSsUrI/0Sljge35fG5uk5WVA4FuXffv7gxTx6/
KfTffTKBgoxXRH8/lyuP9RWk07rDKcjqzg92ULY8Tlm6m7YL8idUWFrWPk0e
D0smdIZAfa2b91LeNl4ef7vnu6dzDwV9vdXKeXteHodl8l9qtqWgzvLlatsD
5PHi4gqJh1spaNfSJz8c3eTxWGuWaqc52OcRkHl+hzyeovCdXWcB+6feocZ7
kzxOf9lK+bmNgnyHlojUMiFev++X1ttTkNyu5OOrVeRxflXZgmywN2C3Pfc6
1K+k31qaD/+rRx/OHq2B+hfYdkLiM+Rj+g6fB90ZZLzT/MbEKsBzHDXvT0E+
rBpxEdsP9S3v9Hy+hZAPojRyBoZ83bTeniEB67/EO7dLFfAJj5AhSVjfuqod
P25D/lLzop5KQn1eWOcrxAf5KH4oaterU5B/FkLSsZEUxOct/Lcx4L/6EmOh
A/h+5bu5tSfI2CQuoGYQ8pV1U1C0Es5f1a0+l4oA87kGv8j3IeOIK+7PIgBf
rPzVngL1KsMo0vs4YB2p5PdRR8nY6px2ijdgKf7pU4FQnyxrUsvrEqF+rMuv
FCuBetgi+lwWsNLIld9RpVC/J62SD0B8PFuvzBcoJ+NdWSoe6RAfW/mVu49X
kHH9MaeAJojHhbvZCR/vkXFXSTP/KMRDgD5nvVEl5HsXzUoA8LlbnO+JD8h4
c/rqfFGIR6qWoNrwQ4if8JUIDah/qgWLpJhQH2bMdnDUoD6KBN4IOt1CxjU9
U8myUD+t+cRzMNSLp2qTv/mhvnpSTbV/toL/CVsLe85QUM4bdJ/UBufrEnup
UqjPTeKLuo3ewPlhnBRzCur3nBo+c/t28E/t6SkDqO+u33uynDvIeE7hKrJR
phpS+jFux4bzxKdAgzsWrYaWPkNmY/5kTJJtcKaeVkO77Vr6JJ3IOCYgZ/mP
42rIS8o8T2UDGSevP1RZ4a2GRNS/yL1ShnoXe2p14Qk1FDexxbJlEcRn29b9
50PV0PPbqUo9IyR8Nc8qI/qqGur9sHo49S0JD5/4k3CnQA05il6td39Gwv4p
z5XD69SQkE9l+t5KEl5PKXII6lND3VxpF+0yElbLN/jcuUAdiYo369IqSHiZ
+ODRTjl1lCNyMglB/1O0berEK6Y6CmFfsG1pJuFtDbp3jc3VkXaS1O3pLyS8
ZptX25+d6ih7qd8pnznQD4it0l+2Tx3J673Px6vI+GDIK67EfnUkMlmvr6wH
52u+zL2B3erIpPWH6HcbMt5+507Zz23qaKVAeeN2OO+2LwkS+seB8e+ezLSf
g/O5St+JrKSOzp74rix2Dc4nb48VTYvU0cwvE9MZOK+Mgy2eWUO/hC4Vu9+B
8097RfmdkvMUtFrtxzwjyMfmvbI3BQCf9td52AD3v01Z/s4U6offZl8FSzhv
p3/7RwdDvtzKTL7fDPl9Ltdtbi7ky6nFJcIbIf8vJqoefQb5IrpKIqX8OBmP
xoqrtEO+jLqcnCfnB/2W20dFU6jnA5vbl92EfgBbcI+aQ7+kHZHSPj+SjLe5
7by+Hup76vv6C/bQT9DzqTOaUN9Pb+HU3oT8KIgNHBSF+t7p0Sjbf4mMy/mv
PPgM9V3k+yEtOehXuJP6rwqgvrfZshPMrpCx1qK0ix5Q33NLn//2iCXjb29X
WUhBP9UxtcglA/qBOWnp8vPhvBI/8VH3FPgr89Se8w5w8d/vw7vBX2SutSsD
zjfrSfoPE+hHgnJcDXdAv5X9Zm+mLvh34WBRwRyoJ8ISi73Vwb9IRSXvK4A7
v356qAz52/LW12k57Df53LZe5ZOQvy07NlUmQX373rbZA9anYfMLXdVkCtrS
uz3fC+rRiblGC84DTkgKv+UP9cqK3y7qNWCpuw6JoVDPPE13VS+5Dr//1vPh
MtS7pYL7I+iAnyW5t6TD+k7aG3dtBLwaPW8ogn7EZFnqXVPALEs31cfQjzQ+
2TD2Gur1BVkfg9LtZFw1abfmO42CVr0N+aa8lYyr19hOSqyC8zHhxiZ/6Icd
1tWIZAlSEP02+cwlVTKW3db69vG0ClKydOlLFSdj6eC7y3THVNDzj2XyUpMk
fCeQO3N0VAXt6GiRiO4k4e7dwiOBkyrIKfSay+1HJLxvxfcyPj44v/r0nedn
krC4pnqZ6Qqoxx5y9GXRJOxkseD8OnUKMpvIVpYPJOGze5TPJZtQ0GKhL2KK
x0jYeNFJwxZn6CcVij9Ve5Bw2137L0ZQX55t22apc5SEzRxeaGyG+HKXzNfZ
40/CQlczwnffpSCx/PNnSs+T8IaCk3wrn0G//Gxcxi6FhKv69V/YtVHQGrW+
LolyEi5b0NC+sYuCHC2uLA+C5xuFNMpK3w/QP0pKXOT7QcJaHxwVWzoo6PiS
c8/nQH350aiwPqeBgvr/vDF5vYaMhdINr5XepyDJKnkOP4uMjRJ1/hbD+ZHy
QGAxB/LHxUOtexTw7YGqVXFwflDvKbWIw/lzaWtzxzfIl5SR19XLAUsnJumY
BJKx+aqNxb/h9+nCdsppwWTsJv0vpxpw0DP79Mmz0P/PbXvoCrhJzD3ODPpn
Ob+lAr/gfKE6UKavw/6603HwxX3Yj+9lNM0178P6x6UeVgb8snvTipNQ/9Gn
kng/2J8OpK+smio4DzTrgnKhn57aN1G24AnU10/KB6uhvh9af+SMAfSjcWLM
hPtQ3wU1a5MOv4D+LWnn/qsQ/4tnpBdcaYT52B+V7KG+L69OqiyA80ToCHdm
Nex3kchDG7LgfHilVToPwX7v/jP04hOcHzepZIEjsN8dehXqJOB8Ea1xNSuC
/f7CNaEFwfiig7uWLgDsbb3Adz/0s3LSCeH7Yf+7zkhZhEK/e18+uK8D+uf8
x87fUsGe9kw1212A1Z+Kfit9DvV1VXr0InieCfi6P+829K+TRo266dDvtO4V
z6qE/lNqWYveRsCFPun0F/A8JCt4pWgu4F8ZghNt0I9Isk+XvnCloI+90sEf
oR9ROhVqmwXY22/viX7oR1S/LEy7Arg88pP/d+hHwmyHrl4GzFcwqPAT+tHC
56Kh3SehXv58jBLhPEy5n+p9EZ5f2ze+n7sa4jESuzNtfSAFRe9/P5UJ8cj8
EvpyIcTv1gq76wyIh66UefU7wMdCn+9tgHisbf+gcx/iPcV3tNy1CfwvODlw
E9bD7xJ1iRjEp3wwJjoJ1muP0KEmDPHpD5YpPgn1rjViX+8xWH8+ZDMTCPVt
5H5jgCr0C+h2WepFqG859N3bhqG/YO+pMMqE+hYtqPi8rAziObb74nOoZ9ZO
WkYXoB85HWi35hfUM03F/dKu0K982rAsV/2/fuy4W4HVXfBvz+AjD+hPYk0j
rTcWk/Hec0ZB26HfvPL6oFsV2Msq3pwoDTg8u2DnIbDvqMvWnGno99MNU1OW
wvMNn1bGvV+AJSdbDcufwvMIv1adGPz+0jmpLbsfQzwEAppNARfXrXgjgOF8
l8t4mA7YKWh+TxH0OyG3XHxWwPPMXIZxoCP0R+MmokXbID423oaUJnjebIvo
EPkM2PnO2r1n4Lx0Nqz5fAXi1XYkjMUKgfUbLfjjCPmvpxZQ9TuIjAUMt0hs
hv3x3GzOz2qo30tEDXu2wf6hON1+FwP9YGiozAofOP8yRWy83eA8GO+5ZlUC
56NMc2vlFjgfT+ZcE5iTDc+jAeP34hbKY7R9W9OxCgp6paNebUaSx5K3crl/
aihoqec9z3P68li2t6pi8Dnsrwq/2Ee28njnyniF6VoK+hy43d/qmDyuVPff
uO4R7O9gS9GUKHm8WV9phekdqBfqVTuEob/vFTPRGoL+8aLx4rcalfKYeaVE
1hr8e9b10am7Th4XTKt+GDkA563lcdeNr+Rxe//J17amsB/de6L7W+XxIben
e9Q14HmvQvxV1kt5/O9owc7lyyBfushjrY/lcfPRBYIx/1TQRJXLxOoieexc
fbjg25AKmoxqn3chUR5vKfl0QOuTClrc6oMOnZbHE30iPwXeqaDSqQ0nWfvA
nlG96ofvVdD718WtN0zk8esh5mHWFxVkVHk4eoOaPA78yW8yf0IFKVM+5FdK
yGO52/JXdYUgH2wdfN3nwPPQLUODQhI8r0Q+Pxk+Audx6/SfeQZQv7eE6wz0
Q71sfZR7p42NglhqkyEXmVjVfO1D3342Wmk/74FJNBPzcyqaHk+ykaHmDvuh
eCaunaNlyeXnoNdd/j9abjCx1voKqW4RDpp6sENesJiJn6u7XHsrwUHz78Xf
tqxh4lfMRPwUcOR4095tbUx8S/7d2mz4/cBO2ecxfUw86q851MfHQdtMs68X
/WTiFau9NpnDfJZlldv85+nhBxfenx3tY6Os4wJD00J6OO/I+VAFsHdB3foj
8Yv0cNj3r1+21rARrfOvkfRCPexdfSi1v5iNTlhfdamA8f2PQu4wM9loX8d5
X6FfTCxaOSy6K4mNqBUpHr9h/pjsBepy8Wzk1C9wpAbsS6Wwbg/GsVFo/cnp
J2B/2dGh+zWJbFRclBF+BPwLt29t23CTjQSduyZVMph4bI5edmERG8lcVhmn
XGXifyfvVn2rZqPPIWpNhyB+h7L67xS2slFv5txnoRDfPq0fTWLv2Wjr4MCh
7V5MvJ2Pn6z6gY3mL+q7uteNie+0G4af+cRG30i+Oaf2MbHS17JNkr1sJPs7
7cWdXUysY4viv35how2HT0n/tmXiB5LlF35+hfFyMSW7tzJxetcGBnuYjXLK
5HM/bmLilDd3Ljz6wUalsbGCQeuY+GKKJiVdnoMCZlIdbgzqYrk5sst2KnKQ
X32DrNNnXVxIDz5gRuGgkX8HDNZ/0MX2twY+H9PgoJOXdqaZdujitvEho2Ya
BzlIMSm+r3Rx0qHzco66HFR/ODa/vkEX6zZdF5U34KD1IqdHNz3TxclKlrHL
jDgoPmD8zni1Ln51KH9pqBkHvU8cTD/9XBfvib+K3Uw5iOL//Zhfky5eWLPT
ftlGDkL7du11eKOLY4q/xAcZc5DIBW0jSpcuPrN+l2kBl4P6pOxGP/bq4r9n
vlinIxh/YJ1dAPgj+dAmdzvMf+ZlkePvEV0s/WTYuoPJQb4jiG/npC5W+3u4
7Cfkb9E5+h1diFdCUmADaz4HldwT/OYL8RQ6sMrfdIaNDMLcm+IcmNhxrPiP
/G82Kpzwc4t2YuLerMKU2p9s1Hw4udvpIBOvpkpU64yy0V4pw90iHkwcXD/T
7A3x/3rcWvrSMSaWOWZqdgb2U/zC7p19fpDfc9KzDllx0PclUg7++bqY9ETm
0iDEw1isfn1xsi6+2ZN3w2kzB70zc2Y8idDFHxO0LUYtOKg1sngH6YQuHr7Q
e87cjoPGB+u+aR2CeF/XTK935iBO2GJFtoMuLv7bs8LtGAd99l/x28JKF1dn
pUkPneUgpWTXF6u36OLU3xusPsdzUOrFX7lzturiB5ptBV+yOejUsM/pHhtd
nBEz/jemjIOYoqdczR11ce5Sg9HKag6am2kV5OqhizUfyFkEPuegT7kXf0gG
6eKoMsWNFi84iHaTf8OcGF181GMyW+AZBx2N+/Wx8IYuttsSUTv4iIO8yvhd
q4shf+6yFdOLOWiz7Fu+fqyLBTTKJRUzOChi6/37EnW6uAK/Olkew0GmU1OK
Fxp18dME+qbKIA5Ktjh4eRTyi7VvacMNDw7SVMm1sIL8Wr69YmnjHg561cm5
p/BQFz/3ZJW5WkN8laJ/a9/RxbYrw8I4o/KEvuGwvNDkhdfyhL5hXa6rnOED
eULf0F/b7874bXlC31CvnnmsM0We0Dds/R0pfSdJntA3vBo3NZGVJk/oG47c
/nDEI1+e0DdM0mUnaFTLE/qGlMcHGUmd8oS+YTs8fQhNyRP6hlkyn16FSSoQ
+oZVtr5CgroKhL5h0j67I97WCoS+oeLbM4u73RUIfUNh0256erACoW+IDZ4V
HoxSIPQN9e5SLzheUSD0Ddc9OkdjXFIg9A3jtE1+rQpVIPQNOdetzzV5KRD6
hkdFygtCdigQ+oabhJiyLWwFQt/wfMxaP3lvGpq463rNMoGKxe1/bkr1o6ET
H/4aJ4RTcfTenehEMA19CZV0Lz9BxX2bF9ULRNFQ08ZG0gt3Kk6+b+1nd52G
FB5pd5Tup2JlOZUB4wIaUpFdYrvciYqr1PPqIjENHf1oskzDmYoTpF8t+9xE
Q0MeimJDB2F8tMZb0Q80JNaZsfeDFxW3VQdlzBugQb2cdt10mor5vxx62f+D
hurU7q1VvUTFnDVbaZwxGor6ZbrdKp2Kty18KdQB11d82LfnRDEVL5/ev6H3
Kw1xTx6rtH5MxXMjdSlfumhIg9ZbUNpExaNCycaFML//Ot/xpLdUnNV/8741
2Defa/l100cqjm3d/HER2F97YNdjy09UfM57bz0J/Jt4wi288Z6K/43ZXm6P
pKFtv4RtT7+m4p+FRxfYQHz+XfoVEvaciheND1SFQ/zyQlojr9+j4vbSm9tW
QXyDnsjLf7pFxZIvPzim2tLQwtzwD9qAv5nXj49Z0ND7qcfZU7epuDP6Y4+u
CQ3pMbvd/XKp+NPGy4lHENg/ElNRnEfFLdkaF1J1aSjQ0Gxtdj7cP2mp8jNN
sL/Ww+W/99Gm13zqG1CioZ9pdhsfAt4wXM8RJtHQ3Tif7A+AfbPfY1YRFXW/
TOquAZwn81rZ4TYV1QT4laQA9rarlg5Kp6KGtEoBbcDbfj9enJ1ARVw/pd+n
Yb6tNge838RQkQY5qjYc7Lko0PNENIKKkFzVPVOwd7/tNg+bM1Tk8fOY7jPw
Z1nkyPvb/lS0slfx3kw2Fe/QNdySD9jua4NwJeTb2XKrB9vh92cTLxv9ukrF
V31Q4zK4n9JO74Dj8VQc8+Di8vcwHy2jRssgjorTdo2syQd7eiwXPjGJpeLE
QyLhoWDv7sa+4IQrVOz3iVPnBP64jf1LowJWXWl1lAv+5v/7aLQU8O9d3JGl
pP/W456gKuCnX03DRiBe1yW76FsB/8vfFdcI8YwdS+ipBExa5JCRCfGWXaXx
wx3mIxdWsI7DetC8nskfAHu+zBgMGcB6kb3jNG+CvYvvNBpNwnqOXe8uUrpG
xbv8NFpvwHqbFGpojYC/VhZdh0svU9HR7VErAiB/YrZinfdXqSg8q9k0qZOK
o9rPzqlJoiIr7uP917ohXp18TcYpVDToPTlFHaBC/z8SaJ5KRS2ivuPkUSqe
uWd4qRmuF88pVpKbpuI4dvWZ1mQqWtFD+f5xLg1rGF7NPQjx2lgZ3CAjRMML
Ogwu3omlIiF3T6ErIjT86bxwYWsUFW0P+ykiuIyGH9bXSC8KpyLblsSEDVI0
LPg0yTb2NBWNDA+foqyi4eQ96dolflQk/jZuxTUZGr5ob2t+9wgVPdzBp3cG
8Ak1U/d3B6ko99TLggFpGt5n/LrHey8VKSz31OiSpOHNK92/1uygIrpqequf
BA1ftbmlIWBDRV++smS+LIH5N/pmHNlKRauXf/ayEaTh95MaEermVCTTwmcj
AP5cKf38c8dmKopsJq9lTcH6eqmULAQcHHTtIWuEilnzScUGZlSkF6vZue0r
FXfFr1FbeFiP0BOtXHqB3XJKj9ATjZsnu1UmSo/QE7WtiXuVlKRH6IlWCcom
6GfqEXqi9qMNUto5eoSeqNPfOYZygHl6osw+w6y58HuenmgwJ87NEO7H0xPN
+tRelxWpR+iJmm3h8m8Ge3h6ogb0H/yn3PQIPVHJYosDOdv1CD1RvtAmOaNN
eoSeqO+ZAc3LLD1CTzQ10PJSGVWP0BMlux3K91PTI/RENb+nqawHzNMT3cDY
xloNv+fpiUrJ6Nmm6esReqJnalKUhDfqEXqikYYrjUzs9Qg90elD5lrCrnqE
nugVSsbSZXDd12uRXyz0T++elvVKWoE9OFDfBPqrXwy1v5st9FDI6yDKS3cm
rnH63VkE/uxX3jJHFfqzKotTo6bGeig/1fHUHujfXEznp0sZ6aGXhY0+7tDf
HdTari/D1kOTV2qe2kL/t7XR9Z+tnh5SvP3NZjX0h94Rv/e08uuhB8Pc69eh
fxzeui9gw3w95BZG3btuFPpV/5WLx2eYqGPLQ9sX0H863Fm4uvMPE0m6uYTS
oZ+u39GY9XeKiXqSyv6FQP96vMwueucvJnKLjum4D/2tQGnB7clxJpo8H6/z
Dvpfube3SltGmYh86wjqh/548/thfZ1/THRXvO6K8WNdvMDorQsN5uc8tWm5
DP3P12bnLTMCeii70Lp7EfRLq27GHbm2SA89dQhdfAf6c9kK8R1zluqhU1+O
RflD/+77IDKHukwPObwWiD8M/f3xNzpiGlJ6SHt06YYQsDdKb63F+Co9xPe+
r/QB+ON6Mm7o+BY95HEtxsMAnh/GSlWbF0D88b8bOfHwfNF28Tiys9VDlgzJ
UlGI1xm7cxpHIL8kpN3PZUI8JfIe3zR3gHweWC1iC88vB7cyH3zfDeN/crXl
4PmmY1t3uuVemP8Pu23GlYmxen+cn7MeWtjl3DB2FPbXT13NRwNMQk+2zW0L
3ecDk9CT/aumJlrcxCT0ZF9naHdnPGISerJX5wv23MpjEnqygdYyG2lJTEJP
Njl1U27WBSahJxsY52hkHMQk9GT/XgxYt9iXSejJfil7dP7mMSahJ7suZ8Nc
ax8moSdb7L1r0VQAk9CTlRwkWQiFMQk92emMhMT0OCahJ+tsdZtyLYtJ6MnW
qd7Ija5gEnqy9c+faUi+YBJ6spIGC6pr3zIJPVmRr2RThz4moSerd+KxU9t3
JqEn+773sMjZMSahJ3viuF6hDOQXT082DvusejDIJPRkb0TGPljNGuRUbOU8
ml9DxlSBZe5vqwY4ju7FK5vzyTjE4ExfcMwAp8nsc/SJq2QsMCqQYnRngGMT
Jor5gsl4b4Q45YHUIOfU74W3/NzI+PGfzzTZukHO1TTBrBY7Mo7UTv5lUzHE
2XJgae/PDWSMvHtfHH03zJlO2t2co0fGyxIPbyKt/c7ZfGNq9UUtMvaYE3Yz
k/uDE0namsSnRsa5Os7r+n794EQ83ma9CbDhTyf3y1kjnOV00ho7KhkPJucU
p20a5YSG9r0d0yfjgQNKLkkdo5x998S/524kY+sPjLlTZmMcgQtGt7q3k7HV
gZOFzuljHGuDSydeuJOxvWZV1bxXYxzn1bqMUyFkrDRypv7a+zGO5Jh75Z8E
Mr4cll2XVzXGeXE9J4FTSMbHugXx2aAxzvTUUimjp2RMfhL2ZJXMGEf405Di
kg4yVql5JzuTOMp58/lUWm0/GS9Z3vtbYv4oZ7uv5c7ScTL+oCgmfiNAg/he
7GVZJfe3jwbxvdhvS5GTcQc0iO/FBEL3vrljofH//29yr5oAXUuD+F4sM7J1
TuwSDeJ7sbQkg8fxA+rE92J0B4Utcs/Uie/FSjwM943eUie+FwuROVbmF6NO
fC+W4JlucPWMOvG92NL8eWGBp9SJ78V413nfi/HG874X492f970Yb37e92I8
+3jfi/HsJ/5v8v/8430vxvOf970YLz6878V48eN9L8aLL+97MTPB91UHdfVR
QVJ2t04nHSfU9TjMV9FHq3aGpM/7QsdKCuZIRUofZdu+W2I9RMcZP2R26wro
Ixm/Bpu8YTre9DmGfn1CD80Ytb37/pWOY79X0J981kMJb3sPH/xExwbxPnWj
7XroHdtC8nkrHd9ptTdQb9JDUle1SWJP6Dg/yegqpR7q6c9E3XPFdPxa20Pb
oEEPKWTZx0en0fGfiDBZs1d66KO57sqUaDo2fL+xq+u9HtptVZKzJJiOrzRf
d5Ea0kMlLp07Fh6n46FgzZj2P3rodu96p2OedLxjyYBfzRJ99PTux7+v3OkY
DTFlD8vpo6jhf5c2HaXjMx45Xw5o6qPoY2fnXTpBh+fL8gI3A/CvQtXpbygd
m6jGrvU01kfPXMqvRcfRcU/WWXrFJn10lrS+dWE2He8vOPT++0Z9dJQepMl3
j45jGu6sU1injzSC+M4ueUHHKscLXBuY+uhtT+3fZx10LPayvb/bAu7f6vvS
C+LhbRZQNs9GH92w/3X/ewvEJz5YQWMn3O9kFU5vpuMNiR5o/159FEdmGV9s
omNS+2HJTBd99CFy342Cl3R8q2agdMhdH7Uq3JNZCLhqsbaCrrc+aklY/TWp
kY5Xnl52INRfH60ofanoAljLcrfnplZ9tFvtmrNIAx2XG1VFXnurj6j8JEVx
wCyNDZF9H/XRofatbhaAH4Z9O0bt00cie41JNYB9t+Vt9B3WR10vD5COwP2E
/USXlY3po3G6H8MG5he+1fFpaEoffYrOlvQCe08fS3qwYg4LDW+86V77nz8+
y2+qc/SR3OkHJOYIHW9uT/5bhMC+2geLrH/RcdPKm3vmGOmjeg3Fayf/0vG+
xsx9y7n6aGPn3fY78xn4qJFfyTjg24q1HUNCDPyu/eDCRIj3srszWRqiDNz9
YZum0Hp9tAh1bT6+HH4/mLOAA7iDvqupahUDe/5Obc6C9Tx24Y3TVm8GxuXh
3JuAHfiWNCT5M/BT3ZeWhwAvWP6M3HeagQcKBiV+wfgDWspu6mEMLJ4zJ8cU
MPbcWOgZycDV91+Yuqz7Tx/91e+cKww8dD2WbQb27XFOt+1KYOCKHul304b6
KKLU4RVfGgMfyDoouw7i8eGM0SPt93S8QPnpFoVpfWT/73FLeRcdP+961PML
4nn+7VQD30c6pna21GKI9356oIk07Ce7663fg2A9ZJ5bD04Cbiq03ar3SR8p
0eYeud4N6+mypPcbrKfKg6Sbwj10vHtCNS0V1vtz2uB+BNhEvif+HeRDsgpZ
5Vov5AvttN9FyJe6rQkHYgEbbPjtx/HQRzGBB8n2gO8PW14eh3wbnjh2uBfG
z1WIfZgP+bg6zPKwDmD3v1pjHpCvgmQju20wv3uDy1o9yGfpWjEfOtg3OTdz
k8gWyJ8ly+U+faDj4Po3Py2Xswi9SbUzpjvPC7MIvUnh89IbmHwsQm/SKDLD
rXs+i9CbPG22wixNgEXoTZqeqfmnJMoi9CY5Cl72datYhN5k73Wx+cGqLEJv
Ulp5k8FiNovQm9Twqng2fwuL0Juc+mNdN76HRehNzqk47xjiwSL0JoPEYqLO
nWARepO+P0Roq06zCL3JBe7HKPeDWYTe5EXfYg1uIIvQmzz4C/v99mERepO1
9/6JRB5iEXqTqs+HSNPbWYTeZJ6AYnTgRhahN7lKY4Z7VodF6E0yzKL2Baxl
EXqTZVWuj6pXsAi9ySXKv02t+FmE3mThog+vy+eyCL3JqQUfX3T80Sf0Jn/e
Hb9b/kuf0JukDD1TtR3VJ/QmheNYPaVD+oTe5JTlu8SOL/qE3qTWkKVaFdQP
nt6kpMrMj33h+oTeZPevs+skzugTepN7I9ZbRwToE3qT/LfuaTRAPvL0Jr3e
io50Qn3j6U1G1/g+rTigT+hN3jvuN+SyR5/QmxQfYeUP2v0/oq48rqbmjdOe
UKmE9k0qle7t7uXOvYVWlLUkWSqhRZSypIWSFFpka0OkTckSKlNEaUUqUUJC
irIUSX7zvued+f35fOacmef5znPmfM8zc7+XR/Qmv81a7ZDMROMfvL7AHLV/
Lm3+JsvgASb/uuuMM0y4Jbj2WBWdByJa7Ru/oOf3WdXDuHwaev6NKhLK0PNd
s/gHr9EMrc9defHh6Pl3LxV7r49stvOOu5aRTLi6WKXyFnp/CB4kzxpG60dN
dlV/FLJ3Nium5qH15VFKg4aKKcIj9IyoqhoT7m7vKVBD9uAEz9PNaH3auToj
bTWybQdzraPR+rX0deTLOmT3ttj+no/w1+/1XbgL9RefYnBjDM1PyLNz2a5o
/ORdGVsr0fq4+Gv71SDk70BWs+xRtH5GFDgr1aB4qpYoJXuj9dXzR17Zakce
0Zuskq+hfXfiEb3J3TMfWjxFzyvWm9znc3XZ9zU8ojdpQ+t6sWI9j+hNbj60
RW/Yi0f0Jnc/erTt6TYe0ZsU0pa9+BTII3qTa75fUl70iEf0Jo/P1rp/splH
9Cblk9aXaLXxiN6kb1B/+6tOHtGbnGB9QvlxD4/oTb51MRF++8QjepO3Lhqr
WqP1EutNehhvca1E6ynWm+zYmTLJBb3Psd6k3JtyeW0bHtGb5J6J2B24mEf0
JjXCV6fVoPcz1ps8vLleStqBR/QmN1SPXwtH6zvWmyysMmjrYvKI3qTS+Jun
s/V5RG9SlXkt4IwSj+hN5vUvHLwgyiN6k3dO3pt77SuX6E2e070/Ua+HS/Qm
35h6eGo/5xK9SbGFC3wTnnCJ3mSmhPXcQcSnsN6kVfPVl5tbuERv0uyiBrP4
JZfoTVa0y+hpfOQSvUnrURv/kp9cojfpHdc612QSj+hNdrW8CpijyiN6k7aR
QwpmxjyiN3l6AXdpH49H9CbDFVOVh1LNCH8Pces3VUsxI/w9ITelfku8GeHv
yVZ3f+2KMCP8PaX4gjw30Izw97eLQqb2eZgR/v66Md//02Izwt+NTDVvXLE0
I/x9a2khPGliRvj7Mtkan5faZoS/d7Ff5W9VMSP8/dQqWedXM8wIf8ftmL/j
+zF/x/1j/o7Hx/wd+4f5O/Yf83ccH+bvOH7M3zE+mL9j/DB/x/hi/i6nlJ19
bDud4C21drS8zI9O8FbPO+86yZtO8Na1bohRXkMneOtdvZrx3J5O8N5hE302
lksneG9vuv3n8Bw6wfuOqYn1EmU6wft3adlithSd4P1WtnVkzxiN4O3HGeDK
/KARvA1Wq3WHfaURvHE7xhvfj/HG/WO88fgYb+wfxhv7j/HG8WG8cfwYb4wP
xhvjh/HG+GK8M5VK6PPsGQTvk2ulHNxsGATvwrziD5cBg+B9zfqF0k1zBsH7
+lVoHKrHIHiL2iYbGigyCN4Tm2viDEUYBG/7eRZPPg+aE7zjbj162fbanOC9
Q67noEqrOcF7nPO7JrfRnOB9a7WRn3q9OcEbt2O88f0Yb9w/xhuPj/HG/mG8
sf8YbxwfxhvHj/HG+GC8MX4Yb4wvxnve9MrKJl0WwXuO+/SO31osgvf8/LvB
trNYBG/rBR/Pr5zKIngvKGm8M+Mvk+CdZHuutGaASfA+3tw689ELJsH7xTw7
j4RHTIK3yu32LbvuMAneovJfFe5cYRK8E7jSq+xymARvWxfOWHk2k+CN2zHe
+H6MN+4f443Hx3hj/zDe2H+MN44P443jx3hjfDDeGD+MN8YX422jvPCQ/SMB
ELZm5Md00+A0Fz/OjToB2DN76fqqRhrU8fGYcaxJADabnv8QVkGDetM05Q8/
E4BLdnUsmWIa/OItt9WgUwCeCfpj9lyiwYMz+jMfvxOAaxkqJsnnaLDRq+Zz
82cBOPm888UtZHMGViT7jQiA+9P9cR/R9S6ByRd/jQvAFNXZFaWov5P7CkCb
mBA8O5Iq4X6XBsstjg0mSAnBcPAas8omGlxRburRIi0E8196Vxx/TYMzMiYG
xaP28OGXXeu/0eAVTZHNLej+zY+P1d8TpcOKvvl5P1D/I1IfNL3l6dDFdWaN
Dxo/Ujmmma5Ch68OGVyrQ/7N6KjJ8tCkw2pnu431yP+MrFtLo5C965vUCV0U
32YwR+kUul6S1y8ZjeKXXvjghcQ0Olyk1G0cj/D5sr7K+LgYHcYtjLx8DeG3
rkrZ1+E7DRo7i+z4B991lYsuR7+hQTi9aYn/OJvkd6m77uYzv9kkvxvzG8Q+
fmOT/G5ZMGI2/J5N8vtZyUvb0nY2yW8du6KFmx+ySX5rPe655HOdTfJ7q9nq
z8YX2CS/8273/pyewib5nSQ/4ZxrLJvktzpP+d3HCDbJ7+cuiw6v3c8m+Y3b
cX7j+3F+4/5xfuPxcX5j/3B+Y/9xfuP4cH7j+HF+Y3xwfmP8cH5jfHF+341Y
da4/QIfoWRz4m789OViH6Fn0+Luyfx3UIXoWHBvJrq40HaJnkbrDotC1TIfo
WVTbpVwb7dIhehYFFnO/jojoEj0LlZAFnv56ukTPQsZ9ztI0K12iZ3Ej+8cf
pTW6RM9ibMHDXSM+ukTPombUy1jOX5foWUQaUu1Yz+J7AHU/1rOYr0j1j/Us
TDSo8bGeRdULo3/9w3oW5z4m/+s/1rOQnEXFh/Ustv6R+Dd+rGfRzqHwwXoW
x95Q+GE9C0Y4hS/Ws5g9QVLW0EKH6FloOPtMGzPWIXoW1hN/vb+qoUP0LFwV
bCYtk9chehYDQRK/u0V0iJ6FhMNJwfrv2kTPQjsw16f9nTbRs7DOrZ5o36ZN
9Cx2df40D5ukTfQsHikpNgz+1iJ6FvssZv/wHtAiehaJCqW8D11aRM8ialfw
3OBmLaJn4RZXvXh6lRbRs8ixWKHbUKJF9CzmHL+pn5GtRfQslp2hbKxn4WpL
XY/1LBinqf6wnoXGIWo8rGdxRI/yB+tZ7FhC+Yv1LFYZUPFgPQvGEBUv1rMQ
qaDwwHoWVw5SeGE9izF3Ck+sZ/E+hsIb61kM61DzgfUs1OSo+cJ6Fo/dqfnE
ehZOk6j5xnoWt2Z6J78M0CJ6Ft/PyFebb9UiehbJRpvGm9ZoET0L/rKbq/us
tIieRbd+5CE/PS2iZ1Gy1CCyUUSL6FnUuSdaP+7SJHoWa3VCH7uUaRI9C1/L
E71G6ZpEz6LqRw27JFqT6FnsWTFS8XiXJtGzKMpcJX0rUJPoWYwEUO1Yz+KA
Ye2/92M9C24M1T/Ws7DbS42P9Sxu3KX8w3oWrcWU/1jPYnsEFR/Ws5iSTsWP
9Swy11P4YD2LD6UUfljPwkqFwhfrWVwMXT3A/Mki+/EHvlWMj0uzyX68e4+T
vN0sNtmP17hYm1Srzyb78bF9Tq6bzdhkP16rZUKHB5NN9uONXtEnOiIb78dP
rN3pbYKux/vxdlq1c/1Qf3g/3v+eTFzLTDbZj1eiBT8IQf7g/XhxZZ2HuSMs
sh/fnRyp3/6ORfbjG7xFX/s9Y5H9eOCpNnT3IYvsx29eH+3UU84i+/F9jml+
F0tZZD/+Z3NL33Zk4/142RkHx+zQ9Xg//vX4NuXGByyyH29/8ckHVguL7Mev
1HEUCephkf34KoeIIdYwi+zHu01peyxA7Xg//kJO34UFr1hkP/7uDI/y0A4W
2Y8/ssDk7CsUD96PjzUrvhrymEX24+cZMzcsbGCR/XgzhfjftrUssh8/syi9
4kA1i+zHW/qaaE1MZJH9+Ov0kxY7E1hkP/6Jm2ODZhyL7MfrJVp2SR5ikf34
ZMuJmw0Pssh+PP9U3NLYSBbZj29KfbNFL5xF9uM/3HkZ/Hcfi+zHK97VHNsY
yyL78fU6Uww80Ph4P764JFVubhKL7Mf3RNeaPUhlkf3496cXqhifZZH9eJBR
uXVdJovsx/NvbXmy5gKL7MevUnWR1cphkf14+rra/AsvWGQ//s7JdcfNEP54
Pz7dP3fCwTcssh9vz739JQ3lF96Pf5kw7LnnA4vsx5vRt+1T/cQi+/FZ5kob
wwdYZD/+kJzKqotfWGQ//kD71sFPQSyyH5++OOrHuS0ssh9fLevR/GoNi+zH
p0V7n3tsxyL78R7vuOdb2SyyH7+ItVTaQ59F9uM9I/dta1Fmkf34RSHJIjtk
WGQ/vtr/ihhXlEX24wtPfbV7gr4H8H785PjdlRETWWQ/fs+q4/V6UiyyH99d
v1yWqcAi+/FV0Q1rmtD3Ad6Pn8vs/FRNY5H9+MSprdvKrVlkPz457/cX65Us
sh/frc6K/O7JIvvxbY9WyBwOZJH9eBG3YR3RPSyyH5/9ILOpOIxF9uOFLr7b
7VB+4f1493OXX34MZpH9+JcJl0Rl8gVg4D/93MWf947sLBCARTmUvq6n3RyD
xcUCMKhC6e/uCU9KXHRTAO47Uvq8znWZ0b0V6PtjJaXfqz6RdSjhoQCwJir/
q+97svxsW3yzAHzNofR/d0zeeM3ouQBU6L3/Vx/4S7WK6c1uAbh+iNIP7lA+
6prSKwC/f1H6wv37RW859gnAkhJKf1jDd2tv0icB2P2L0ieeEkq1582n9Itz
J1H3qwVS+sZ7S6j+uRcp/WP28IZ/x+9xovSR12ZT/l2IpfSTn31g/uv/8ZWU
vvLna1R85tmU/vJDXyr+ch1Kn/mtBYWPDJvSb5Z/T+FXPYvSd979H76S/+k/
T/jT42/yDBC+HOh2e+PJVkD48uFSz5TtHYDw5YzPzeNbugHhy8Gcrq/SHwDh
y0L/nd+LBwHhy2VGHVbFvwDhy6m7MzWXiAgIX1YwdznTIS34//8fHqx/UCor
IHxZ7jPQ264gIHzZ6kWO801FAeHLZu+pdsyXG0Ko+zFfztSi+sd82W0TNT7m
yxEKlH+YL/9aSfmP+fI0HSo+zJc/vaDix3xZMo/CB/Nl8xUUfpgvp49R+GK+
fPqlXN2fh4Dw5RnbP9oH3geEL792c5zYDQHhy95ar6VtygHhy5Nvy0Xn3QKE
LyeaXk+VuQEIX55569Z6n6uA8GWtGCj5oBAQvvx5WXxL4h5A+LKYdvLuL7sA
4ctFeSetHXcCwpeDtCxXFgQAwpcDb297IucLCF/evH/CixAfQPjyna2bjvV6
AsKXX0ywlF+zARC+7ClK2Zgvv/ejrsd8WT2K6g/z5ZMV1HiYL3/To/zBfNm3
iPIX8+Xe2VQ8mC93rabixXxZ/giFB+bLv8spvDBfXmJO4Yn58uEKCm/Ml+P1
qPnAfDnVg5ovzJetd1Lzifmy7itqvjFfHn+zeZvhCkD48pGopBC4DBC+vFP/
w8L3SwDhy+uG9nYO2ALClw9d9P+4WAgIXy4LeP7+IgcQviy8tuPkpXmA8GVv
z4I70nMA4cuf8r6DME1A+PIE1wilzFmA8OXPQ5Nvvp8OCF++I5Ydm6UECF9u
+Em1Y75s5k3dj/myewXVP+bL5/ZQ42O+vK+e8g/zZfFYyn/Ml/vLqPgwX1YQ
2/dv/Jgv/zSn8MF8+dFhCj/Mlz3eUvhivuy3Jq5gYxSD8GWHZ0MVRikMwpdn
PzjwODibQfjy+5ixZcNXGYQvO9UfmJVSxiB8+eN1+un4Sgbhy9+gV2UosjFf
rs29pL8GXY/58jTRsf7TqD/Ml1nZ8+0novEwX+5UuBydncwgfLnh54qYtkgG
4cs5wdffi21nEL6cYsvMOuPBIHxZatHS4n5nBuHL86xuycvbMghfvmrabPLU
ikH4MrwqmZeObMyX237dLNtlwyB8+XJ3RtuoE4PwZYVD4pc3rWMQvqwuHl6V
5c8gfPmwybXiTREMwpd1v0gn+qF2zJe3HVbzDNzCIHw5ZjRx30VPBuHLy/XX
u01ezyB82UmhJzDbjUH48s+pPto7VjMIX/71/e6d4OUMwpdfH38cVryUQfiy
+JL1r43VGIQv71OqG8ucySB8+fT88HjH6QzClwd2BKSbKzAIX3bTMJ+zSo5B
+LLkngq5G1MYhC+nhioZOcswCF8uSpNlzZVmEL78MnNZ2TFFBuHLyeLg4xE0
PubLoSmPmlerMwhfzt88NvRVm0H48pW9oS9c9BmEL0tFfDc6YsQgfFnyTFri
IVMG4csa43FNjnQG4cu/wdi2x14Mwpejdic6uSP8MV/2cuqExb4MwpcVVAeu
PApgEL58IcBgds4OBuHLvxQzLG2DGYQv+0y30SkIYRC+vPSro/LT3QzClx1u
pxfNmMggfNlr3o3rTT/MCV+OH0o8Nvm9OeHLnptPbxh/Zk748pyHvhtF75sT
viw7M6r2yFVzwpeNNxXNnXjenPBlWdeHVRknzAlfjnd6c98rwZzw5eA9ejJ/
D5sTvtziVxBReMSc8GUrzv0jzknmhC/nFMY0bUg3J3z58OYJqmP55oQvf1eW
y/9abk74suuglHFfkznhy27xJkXbX5sTvpwzYYtQa8ic8OWM/EN1N/6YE778
yNKgx1SCQfiyb87To10onzBfnsTLNNslxSB8efaBl2enizAIX+54dqFKYq88
aHW+M6NUygLq6D8cnZAmD0Ybn/MVlCxg2tRA9cEieaB0dCRUXscCJjk9X5B5
Qx4sdIg432FmAWvXSKXcKpAH7a+dXQ8DC8hQ/Xmo+oQ8cPBdU2252AK+KnmX
N3uHPGj6Emut5WoB566YbCa6QB7MXnWSsW+jBRRJM67SkZUHdVd3S1X6WECn
9/n7a1rkQH7G4p9x2yzguNzWuuBTcmB1kdybq1stYIJs77sqDzmQsOpDl9Db
AtpNycuegYh+dUZraPg6C1jqKp4RLSYHnl4fO/J2uQV0HVjertYgC3T3rJGQ
s7GAA28CuybkywKz5grReo4FTBQbqrl+SRbEBJ/p+mZoAb+P+HwIg7KgsCay
e5uqBXySzvLs/C4LXL/H+CrLWsDnPtvntmjKgVMtC3dXilrAv1OsGtWd5ID6
snz1Wb95kHdRu2DTITlwuXW7+KUfPHhoJl1q6T05IDtr95qybzzo2xZhIKkr
D3xZ1S5BPahdZetuW015cO9J3RXPbh5cWj6nR01NHhjvYdgsfsmDDpZzPQ/O
kgd3bTZsndfOg34FtQ3hM+RB4PnSjVNaeLDeY/iunLI82FFgua+3iQcHdadf
YUyXB+uNjMXL63jwmmLbqy9K8mCezHHbxIc8eC/I0s4ctS/9wNf4fIQH1bZH
PolCdnRMjN+9QzwYA9xObUb9XXqurnz6AIrHS37VGzRexVFx7x3hPFh92jxl
EPnzcL1X3tK9PPhmoLYwEfk7dNpkHj2EByXDdzc/RPE4SV/kq+7kQY/7rT8T
ULy12yW1pwTwYN+zt4aVQnmgp311hSyym46PPg9biPIjOu+vOrpeYtAiINdW
Hnh2CbyZqD+ZAM4XoYM8eCqnZL0cjffx75noRYvlgeaNCvtdyJ84B//km0vk
gUY+h5aO/PU+tCQ7cak8MDOxy32I4jl/MmFnO7I3LO71/IriTWbNmZSMbOF2
1rETCA+uxdsIa2RPfvIFVCK8mrdJ31mH+vu0f/XJPoSn6qLlf945yoOW2u02
8gjvxGlmd9vsUb6OyImZo/kIvnsmm4H8zaqw2e+E5mup8aeoCSgewdLH/pvR
fP78kLCGg+Ktfe8fvwvN9+e2SXMWVMuB+Ye1X+V68OD6oXR/5mE5kO255kOB
Ow/Onfny5BtnOVDyWslVz4UHp39rtj6vLQcucO1GvZbyoP+vuss1P2VBZ8ZH
p1FrHrwgPtF64L4siPL8uusYiwcnSmQYt6P8trPwWP1rDvKX610yXiwLIg+Y
qinPQvM78c+4XIss2K1+Zm+zDA/+msAN3i8lBz4ufwFF/nLhRZP9IkdocsB+
/tD6nd+5cOq9yFXnPOWA7hTaxNp+LjRQPZOQmy4HfJw6wnd94MIbEaGn53XI
ATmT+Y+r3nPh2rHmxlOK8uBNh9Hb631ceFfyUoWbnTwYD10+rj3Ehb1H7GTZ
IfIgQX5C9MVRNF6V2udNZ+RB8nSdiQUSPLioS0ylqlgeRMCVUnsVeTBghWP/
91sI3222Ry11eNBzlq1DWIk8cP9b3DGZxoM9Dy23VqXLA6uOLhcxwIMir9YV
iuyTBwYd8+LtHXjQWiQUBBj+5pf2//wztZEJW44Iw3Wf/+bPWRd5LLaVCWO0
ljzkbhzjz156nb/yNRPKO0xWkqgc449UZa19McCEp/fuurZkYIxftfEj9PrN
hFbvub5Z78b4ShVi+SxpFnSKfBy3OXeMb1fxJyp2Ogt6Dpk2fpk/xhf+MahI
12ZBtqZ33LzLv/nKRR4+dXNZMG20s2jf0Ch/flBFWZg5C7Yt7lg8RXuUP6jy
Q8eew4KSYgO23gt/8bc2Zq7s57Lgxra/1pVbfvKnTqbaAw6MvVl6ZoTvtpK6
f8PADqn0t8P8/iiq/4T2vOoux2G+1QNq/MX6MlJeb37wD+6n/Ptcem628aUf
fKk9lP8uOt6vwjJ+8PU1qfjSFz8Nq6n7wT8WScX/yeN4fZLBMD9mOoXP4fJ0
hdySYX60KYWf7LvNy9w3jPBLayl869NL3WpPqoAGx1PrNe6zoYMcv9jviApQ
el4gGCtjw3Gf3APZB1WA9IEHKz2vs+FPfdv1eQdUwHkd+aCMAjaccSBVJzZW
Bazcnz1rKBvxnTtvLk9LVgGsM9zBDPT+OiQXtenDeRWgo77V6XMqG/p/DCvd
XaoCzo58/DojkQ0TE98qyT5WAWt6f95ZHs+GpZVFSQ/6VUDwpaze+lg2PP7N
61n2JFUg7CzalRXDhhPsz3xNM1AFtNcrVHuj2VAmo0n2hI0qYPVS7R0PDjoF
eakC2VvU/ZffOTfNjVQFP/9S/ZeH3JxbeVoVrJjR9+/42cyS8GVXVEGzNeXf
rW3LeAZ3VUHIA8r/+ZHplVdrVcGFAiq+J7f7o441qoLVy6j4ny6P8zjRoAqC
Syh8POOG6Q0PVMERicJ/8et6sfdQ4G1VULyLwneK0V6liUlsUCJ5fX1SLQOm
SNsPiSWwQdRwmFxQJQNqRrwUVh5mA6P+sK6IUgaUOquUuyqWDXTHJ48pXWHA
1uDEklZkHzuaszMxmwHDlGuFnCNsoDNz7SKXswzYPnLlgdcxNrho7xpUm8SA
boO1TPMTbHDqjZsp7wgDlov5NHqmsYGtgo3t2EEG7LBx3lmczQZih/bOcIxg
wFdhf65XFrJBwlqTzrVhDPg58zaLU/rP/sLGxw77GFDVb1nwjUo26PY6O6SL
2qfd3VXS9ogNclddjOsMR/5kHO6Z/5QN9L+anXRF/bflOu5J6WCDZEH0C984
BlwwFPD6aDcbvNtwu7I9kQEnvNePGuxhgyONtm8Xn0HXZ/jbHn7PBu3zFGeE
XmBADcmILcIPbDDXXf3XzwIGfD3t7j551O6v/iN/200GfF8mUSOK7t9Qf7wt
EDLg5muLy9mv2MBQin6wsIYBT9JFBLplbPBodG23hAQTJvepTLuL7IMbzwky
pJiwPbQlTljOBpknI7MtZNB6UvbtQCGyf9zR4nZNYcKClowXIhVssDnNeW6U
HBPeqfcO4iO76cvzS4YKTKjQac/fhOxDT4ranioxIX3jPePtyO4+vah33wwm
tI7NNNmP7KFApa9jlkwokp1muRPZoZknpC8BJuzflxDghOx57w2WL7ViwlFT
tyfTkZ3CZY2NLGDC7nXeQfeRP6fvX56bZsOESiGRO1yR7VNCk+fbM+HGYx8H
2lE8s2rjWl86MuEeEfYUgOzQk7dyg5Yy4Quh3+ptN9kgzo0ZsgvZr+KWxzy+
wQbN34amv0LXnxk7M2Uxsq9XyJcIUH8bbu9VfHOdDTzOBKpnovEeZDWXxyN7
4JZg7m/kT+llKV0nZEd73y5ahvz1OKXrOhfZDQfehueieIBCwVYNZAeVOQRO
mM+EpgNNW+SRvaknzCsC4bH98ZM1qsh+eePP4jaEV8zP13P4yNYL2CJmgvAM
Xaj4MBTZUHWt2z/nZ5OmS+vWI/tOYp/RazQf7uMDekzkb//59Yv4aL7keqPz
biKblyAVmYXm8+cO9pGlKN6XFR0FUmi+H2gvanlaxAasy5fs36Uxoc/a22NN
KL/HvM9c3HeRCYca7JoN8tigzXZ3QkwhE5oP9kqIX0T5lvR92bXrTJjXdvpX
UgYbXD7PLyu/w4TMVxXXlU6ywfiEqKLNEPkjVp/09CgbdNZzwmPuMaHOdz8f
9Rg2cFuyNfP3fSZ8L+EYaB/GBvunZbXeQLbW4J0pxUHIH/7c+3eqmLDR0Xn7
eV82KBT1rle7y4Qr/S4EbPdiA8HEzysn3GbCqZ7Foes9UP4sVwhKKWHCi4/C
3xauQfnsWjeiks+E2pKOl2NWs8Fh/WapzvNMeD/CP2fSKja4pBvmbnCGCWXm
WQcuRHZQfJ3eykQmlMw5Xs52YQOpjqPwViwT3tvxcW+jGxt03P+9KyeCCaMy
9E71rGcDDdoJq+27mXDujDc2tpvZYKK37X3XnUy4v7VppNyfDZgbph7P9EfX
P+Tn/drFBsrC7C8B25gwsbux3WG5kNSXxcCF+hsrhKS+rHp2yfhRFyGpL5s9
ue0du05I6stSajVr5ngLSX25xdl9bbO/kNSXF8vez28KEZL6soH74VjfCCGp
L2crW4n9OiQk9eVjPjdM2xKEpL587rFhwtFEIakvP6tIvPMsSUjqy/ceUe24
vrzOjbof15dp4lT/uL78eRE1Pq4vK4zc+9c/XF+O41L+4/ryBQkqPlxf3neX
ih/Xl08lUPjg+vIDNoUfri/P+w9fXF+eC0fpqouEpL6cu/zptWNWQlJf3gFY
W8b5QlJf/iVWF+hlIST15fS00c+1bCGpL+sqZEwwZAhJfTnv7PlHMWZCUl8u
2ZIb0GMsJPXlcNYuy+JRAakvnxAPeztlREDqy8KjkQVbvwlIfVlSXP9u3RcB
qS+Lpa/kmfYLSH15dEOfVeoHAakvOy5Z/EvsnYDUl317Zu8OfS0g9eWRXsrG
9eVQZ+p6XF8u8qL6w/Vlw3PUeLi+fFCa8gfXl/8mUf7i+nLIJCoeXF8OsKDi
xfXl8/4UHuT/RbIovHB9+bUyhSeuL6ueo/DG9WUNaWo+cH3ZwJqaL1xfbl1F
zSeuL9+oouab/L/IA+dnNi0CUl9W9973uuuJgNSXJWSeXBFvEpD68lCL18LJ
tQJSX5512MXZt1JA6suLl99bWl0qIPXlltS1Ex9cEZD68i+bVN05lwSkvrzv
aNflsxkCUl9OtNwaVnFKQOrL4c+GNSROCEh92fFDwte7yQJSX173kmrH9eV7
dtT9uL48mEX1j+vL5uuo8XF9WbaI8g/Xl1O3Uf7j+nJYJhUfri9nv6fix/Xl
wzMofHB92c2Pwg/Xl7/+hy+uL9OPV+ucG7ICcSJaUR9G+XB+p0xe7g8rkPNX
J2nGMB8mJ7qPzBi1AptbrJb//sqH4RtLW++OW4H1iYcOFw3xYXWLSKu/qDU4
7ii9aQFqnxisqPdL0hose7Hna8l3PmwL2RRmPNkaTEov8X77kw+bxcT/vpa1
BjWOF6ddHudDO6npLwenWYNz3wOk34kAyNwj7OEqWQML8fj2cQkA7ST6y3Om
W4OgQH/tEBkAv+WuemakbA2+zflprSMHIHei+1AFas/zP5HVrAigm9fVzV7o
/n2nRaKWzkT95Wb9MFWwBgv8XokGqQEYdEHGkCZnDfQjXr1R0AIw/adRbBzy
b5XvQzMpXQBvL3Bful4Kjb9Hs5E+G8Cojda/O1F8chtOJYfrAxjK3J5o+tcK
cB4/E75Gdo3hy2cHET5eOwvGnZBt2PRkhdywFZjVF7yvXQ/1d7Y5fgzhW/y6
oTZKB0CWxoM9hydYggli9JpgUS2462+A9F8ZS5BxVbksXFoLWpa+PXFwuiWw
5ZcoeChqwY5bb73SNCwBjd7w9KiOFtR71iJom20JVgTMsFzJ1IIPZ0s+6DCy
BDf7lfIb7LVgqOnNzC0mluDy74bjXzZowSanWXu9ka22x+Rv5m4tWPE4K+wx
uv7crgwDeFwLhp/Xta1B/X26scuKdkkLvgiX2BmLxrtV+nN88JYW1HzSluaL
/FHUPTpduVYLPhrfZtqD/K1aKiv49FQLGoYzpf1QPPv0vsl8fK4Fw/y/u6Z+
twCcKmfThx1a6H2jNDT4wQI8+ms2dU+rFuTo59tKd1mAZumlbE6DFmQfO13t
2WIBrF0WvA+8qwVlTRi2e+stwE/apZTmAi24d4rz6YIHFuDrb9evBqe04Lzg
ixDcswDr0+MT90RqwY/9E7LWVVmAPYOruzu2aEGXXa/HFO8j26T4+eZlWjDX
aUS+WV8I1hkstLZpZ8C7zRLxA+pCcMtH1mb7MwbsPBZvUD9dCJ7cn6JQ1sCA
e/+KvpgmJwR+i5d+eoC+X0Ly+6/aywgB3e+ba8xVBkyIv9nQLiUEnXyzMGYW
A3bRtXf2I3th8OA71lEGdA8tmHYQXd+ZfWjaH/R9wf026uKL+qt38mh+78eA
DYmhBxG5AFP6xlqNNzLgCrukgEAN1F7DH7q7hgHlRja0uM5B70fhYD7TBX3P
LNN4KETrL+iZq/4Atf8Wkd+8gyMExQypqxx0/xWXxsPWQAjcXyp7/UT9+xyK
NjdcgNZrL/ep8uh7Jrt+betdtL562sQVOCL/xngO7s3Iniu9ytkB+a/V3RXi
iq5PPLh5zxkUn8aEwPxjqL/h+LrbbSj+KWHX7Z+h8a6Ou7NrED4+iiWJV5E/
QYebanch/MyX2RxrQv7+3t1+9h98+xqLthgYCcGGaBVn1hcGfN7fJ/YK2bRB
7TGPHwwY+KD+Q8hc9H7Zytl04jcDvmQr9w4j+/WsaSefTWTCSF+7Z6vR+ye8
3/GcKuK/DhZXU9ORbVA9I85nKhN21fkr1yD77K6Hq28rMuHHbeGLniG70SFY
booK+j7J2hb3ENmRtuMO0ojfVb4p8C5FNvuT6bc1iP/d6+z6fgTZ78K2HckP
Z8KDpelgAbIrKrrVfkUjvrt+8/rXyB/waqyAH8+E6yPigtcjWyirsCAsiQnT
C7RzqlE8wx4/Bq6eYkL9JxL6U5Ft05d440UG4tf8vO5lekKgarjEuB3ZZVrb
F6brCoEDXBRViK7XsTm6QQzZuxaYqYSi/m49s/aM1hGCtJTV7zloPIUs+WBd
ZI/fU+38ivyxfXK5pEtbCFZ8cvqejfy9KeynX0f2G/b52StQPPlZL0RzkF20
8bufCIrXyffL3X/ax7y20SQQHi1GhW/vI3thNfdICcLrybx9KweRfcps/OsG
hKfcyvJJbDQeHIpdPx3hHVjw7eMZZM9/7Pu4Cc2HeXxziwry1yJrFfc4mq8R
D875m8g+tCTouBuaTz+LFbr+KF7mg7YaOprv3heXOAUoH9KNLs56eIMJ1S/A
/qMoXzy32bWcuYXwUTvfUIzyqXt308jiSoTPxYddW1G+7WpI9xE2oO/B87J/
6SgfP4WVVYW/ZMJPd7XHL6F8/ZL57m/zABMWxlzam4LsryUT0pr+onh+pA3/
sUbxhTnPlJFnwWPhPRemo/7k/rw/raXJgvv2uLCt0XiNZ88u7TRiwa7PggfT
kD/irp/sHeksyJnXGGeI/P0aBVraGSz4ZX6wvxA9j4pLRi7ao/a9zxetkEfP
q6JfyJwOdL+EodcOPnqeR7S85qmh/sM/Dz9djZ735gHNh+Jo/Gc74mZWofUg
pmtDcy3yT0+pYFsRstObBk3r/vH/jyNbD12vcfSR1x4U38UN+ZM/ywrB+m13
vlii+LUnjufmoPVILqjnjj3Cp3rJ495HaL1iOcMZpxF+u2yX3SlA61lRgZzo
P/iWg529EpO54E3SFu01xRpwZNkIY6ckFzADh8CvYQ1ovvfUEtNxDhjQtu9a
MUsTfraFh4YHOeB7R3PbXZom1NRo9njezQE829W8aqEm5Jxi3NZu4oC398Km
qtlqwvcmo0vml3OA2f5g+QULNKHVpteHzuRzwCTJZLMjLE2ocFjv79F0DmAW
nTGfrKUJw2qGZ1okc0BFaqN6kqgmlFFc/2lHAgc0ymYtGqvSgA0G6caF8Rxw
9c9d5rQ9GnC1nEb56HEOMJ25rnwuQwPKRHc4TzzDAQcstNXfD6tDZbMJp6Ry
OODENo3JoFod2qzPlRIv5YB12z7MpF9Qh8ef2q8rrOWAN30Hh7xOqMMP1cxv
p16g/t5d7Rk+qw5bUxMfrernAO7b2XS3m+pwL9iqcWyUA8RTkp+HvFWH609W
f1UX54Krkltl7qlpwJzo8BAjGS6g16V1xK/XgOzxaXs4CN/cP7Ecn8sa0Olq
/p++o3zwx01S0ySRBv90OQz4pvDB12PddydH0CBwFq8+mMEHZdlOT2cH0mDm
gT6rjQV80Nz9fkGhFw1uTbW49rGcD1Qf6pxPWEeDqll5ldVNfFApuG/mupYG
vaOMig+95oMXners+R40mKO5va56iA9q4gNd/3rT4Fkx+XTTv3yQJPJw7fgO
GuyKsV7rIgaA/uzkAesoGjTM/ttbLQHAOuHntaeSaXCJguTFPGTD8n0tqRdp
MH/izuuT0fVdL9OfNt6kwZlrXtRbjvNBKfNI58sHNHhnn35XwiAfuGlNaDry
hAYnFPuc1Ovmg92HFfI+P6fBo4sm/XJu5APdlSYvtrykwY77gb8OlPFBiHfV
qkbUrlszw9wgnw9q5+jCxej+A2Wzjx9N5wOPPzumRKP+p77/vLwpmQ/M9vSx
vdD4bn1bbxUhPOuNtZ/qIf92pjzsOotsi999s/SR/6/0bGyVJ/JB56VbkvNi
aPAG/6nYbxmEd+TftoEjNNj8xevVciU+OBOpHvcFXR9YudW7UJUPrJtLbjSl
06DV4xMHcrX4IOpIu5V8Lg1KjigrTNLlgwm1xzP0btCgXfYa0Ss6fDAYVFrz
z//D8rY1tqZp8sHpV+Ov1zXSYLR5ndefWXxQ8tH0gzOK74tszE9FBT5grP1l
WPWGBn9HLLthI80HzlPSDJh9NLj53uvbiuPzQWFD2t6lX2iw0cNxQOLrfLDF
NSqieYgGA5Ze/33z3XwgrxYXfwLZBUbODfeezweVfffCsj/T4Ovlt+oqG+eD
c+plqdofadC8f6KnZfV88FUl4dI/eoQ3Rq7oXSmfD+7qZ6ecaUPxlDysDC6d
D0xzRvcG1dOgyM2U1a3X5wOP+ofJfpAGT+6cbfoF2YVBT+ga12jQPrFzEkTX
O7U8W6iTQ4OsTxICvYr5QL1q/6lpaTQYfysuIHihCVCWvqyi8c4MivVH3jA1
NAHXQxbLf/tiBiNE5dxEpE3Atc0rDH2HzWCqN495+J0xWK0bICHz0wxKxdZb
Hq8yBvtt+2flfzeD1UoJW9vOGYOanHJBcr8ZPPjy5doXh4yB4G7xRq9uM+iq
cFsrJ9gY/Fg277LyYzMYvN5gWr6vMTg3YwP95V0zaONVKn3WzxjM4t1/PbXQ
DJ7ePcnQM9QY2Jm+kJmeZgab1+asMok3BqWu0ssXJZjBLXuZDj45xuDe8uuP
6iPN4Iz0gPdDNcbAvzw0LH6PGTz65bANp98YzDyi7aQSagbFw7c4hMqagGQH
4/2XUHt23rxN/aYmoPBNMRxH91tfVPcQtzcBA/eynOJR/x9/wrpz7ibg2QL6
sS1ofIfWuMccHxMgo3Jy0VbkX9uV5IU/kJ2+sY7JgWaQqbbH94GHCTDO7Pnl
i+Krn6eq4bXYBHhv57KvoPhrjkyKW6ghIL+vuj+PkfpSTUB+X9XUFuspOktA
fl/lfEF9TFpRQH5ftWyNvNTWyQLy+6rds/dI3BMVkN9X/fJRunlvFJDfV6nN
WtKh9xWQ31eVu59Yd7oPkN9XmU3SMS/rAeT3VSPphc9EXwPy+6rlhQtzyl8B
8vsq3I5/X4Xvx7+vwv3j31fh8fHvq7B/+PdV2H/8+yocH/59FY4f/74K44N/
X4Xxw7+vwvji31eJRXJWpBhyQFSBwLY6lAaNOq6WNM7igOKYXjW/SBoMnjMr
xkKaA7ReVVU5RdOgpWlQ2qIRNhB9Y7RG8yANHtxtX+TRywavnFZ7fQ2jwVld
zMdv2tiAUexas3AnWv/TdJJG6tngVFrs2Z+eNDi/9J3R/gdsYNG14pzxChq8
7G4VMn6fDb6GBRTMt6LBc3crliXXsMGPKwp/zpih9SXzu/pIMxsMZ224ekWL
Bvc93HBpdycbpF30vg8VaZDJWzaiNsAG8zbrPmiXocHl/o5fM8bZQGfY4lSh
JA3q8Z9MPyXHAcI/OVWpUjQ4CsKWn9TiAMfp5xMipqL3xfOAi2AeB2zyKT72
dQYNatjOmObJ44BFL355KOqj9aItuk5TyAHyIW8b77PQeJEpRz9acYDRn279
AlsaXKAwdvs04ABVUb9ra9eg9XzDBW4IG+G3vZ65dSsN9m/snmEwlwOS9nZM
ORKC3i8JmZWlaLyZoj8lsxMQHjr5LlNoHGBR23tjK1qvn9w1+WtM54D8nFeb
LU/ToFnt5VWzzDmg9ki73YxMGoyxEZv5BNmPxt9Fj2bTYJveOekVDA6ghTZa
v8lD6yEreMJ5ZK/cmZ7bUEyDk7Vl391B9oY/Fp230fvFfabssQvIniwzY6e2
DB3OHUl3PYTsGTdfpMrK0+HH+j8KLGTvvqfxeHQ6HZZUXXxWhMbLNX9u/UaV
Di31i2p/IP8+3TeaeV+bDnssKwwlkK24czwofQ4d6r0ctHpjxgEtsUcP+pvQ
odnLuoDDKF6Vl5JBDHM6fP/xQUODHgcYiKrtpCG7avkdRqguB0hYmlRvRdeb
lLKPrdZB/GYtQ+E06q+psJy1TZsDQkMtzO6i8UJNNwZfQ/MXImn64yXyx8C5
+qAZsuXiF7J+IH/twFDCW00O6D8e/FgaxfN9xercR8julmpPV0XxnnNf/fc1
spm/xySvIzxawmvMx5FtuITT8xDhpZzns2cJ6q9G+CP3JcLT8Tr6JEH2ycc8
1g+E972lN6uPIX9WCT5uUEDzocq9vCkc+WuSOF2Cg+brxZlg+wsoHr+9B4e9
0Xw2nTmjPobi1TecInkOzfeVmJqNA0Yc8NXk6lxHOzpkvjAK46B8uXYlIDhg
FR3y4w55rUb59NxjNGS/Nx36pK9yO4/yzbDHbee8UDo8On9OVauAA8bBsNaM
ODqUqZQ+rIzytct3YvuDM3SoUN07f9CUAy6EciR7L6P525f3fgHy/zRT5Pqy
a3Sofd47ZwF6HlRMu8o5txG+wuzTDuh5GV+SLKJxhw5Lfb/X1/WzQeA9J42h
G8ifrMs5huh5Ozxg8068kP7P/xur5aLncbdvVIhiFh3++mPXY4ee144v/IzZ
x+lwtUj5u1L0PCvOjAiI2k+HbznTAi3R8063ildO8aVD1bh691toPZANUn1Y
54byJ6E1+hJaL3qUb80LX0yHRUejQ/TRerJ+5oOuNis6rKnwCJZF603/9t6c
Aks6VH/+abUYWo/0PAWzwy3ocIoOzTsFrVd2ztOjvQGy2Xp9Lmg9S/2kmaFg
S4daD5zoie1cYNgpd+D1M7Q+2VS1+XRxgTDdpXcA8bGsFTNE1vRwwedz2oqm
/+ghT9v2bGMfF1wZvPcxuwHxkeItvpGDXCBlco+2rI4GXW0+d10b5oK3T5Mu
s2ppsKghlf1rjAv0b7mNLHuI+JPk1ihHUR64POleSU41DWpdqTtT5cYD84L6
d5ZdocGnb+pf6G7kgRrDHj27QrQezMyUS/LhATupaL58AQ1WVBgwZQJ4oJj1
SWdaPg167pi3IC6YB+pjpuo4onzUffKXLr+PB9RcSnZXIf7Gmzh55HQUDzwC
zisDkZ31LCVi9mEeyPCWaXJDduamLVF1x7kgP2Pe8xmPaNBkeM5F70NccCHy
ZsL6+4gvii4q9w3ngg+nDUeayxAfEwQ5cXZzwfSutDflJTSos5eVKh+M7nf0
33nsMg1OiYWWs3dygf0hekg54pOak2/bxyP7yvQNepVJNNjwYb+2cBcXcF61
xs+MRf0r65bo7eUCGCs7AvYjPr+v483fSC5IyfnrnhNMg7ERT6ZGxnGBptWG
rVf9aVCxICvRLoULvBdf/lO4hQZtbermfMzggr3hdultiO8/7zf49jaXC7K2
RXxwQPbyTaFDZde5wK1SQ1HJB70/PJZcGrnLBewHZoUqvjS4aWFxkXotFzwZ
uxxFQ98HIQ8txGubuWCsPaFEYQ8N+uzdX5Deiu537G3edAB9L+gEXXPr4AKn
7dsGb6PnlVHySb/9BRd8Sjm2I+MUDRY7rxGfgGwZyVKXlAs0eGLtrD+dbVxQ
8xh2qKP5bfXM7YhH9/vdz9tgjPipqviirlfdXFDl1+wnRPaXsFv6895zwbPG
NsVjyHY7vqhs7wAX7Ov0sZiO+PPEEI9z975xQbj/rjstyN66jfdGZJQLuJ6L
Vta9pcGo1KBo9gQeGN0Ye/dXDw0mCK+c3SDBA3oKfifX9aLvo4bdafdRvtHF
2MUJv2nQP+sb8/UGHih8kBBr9IcGy6v0fD5v5oE57z+8Gh9H7WfWLe7z4wGb
uVVaUhPpcFjDTeLpTh74+7Awb6EoHe5f//zGxd08kJWUUHtLnA7TLY2PbAzn
gZxD1Tc8pND6PdZ2SzKaB/ZuCk3novV1DZ1x2LSCB55GrtoyYSPCO239xPhK
HvANvPTe0o0GH7/frKr2gAd6VvTlcVbS4PYvm/Vu1vHA20o9TwMnxPeFnVoG
T3jANfgh4DrSoO/SQ8c4z3mAZ5i4+qgdDb7pjtxyuZsHNloGhgL0/tVddmwF
8wMPGGzTXeKC7LhQ9e9nv/CA6SylsXZ0/TrBkvlnhtHzYDFT6yrqT/3yzKav
Y+j5+3NneR0a796jX3JbRSzAyvyf4hNW0aDavFrmUwkL0Dxzd5UW+v7sM9P/
IjrJAoC0Cc9+oXhccqzvdctYgNTAfcb26P3+QvW5ostkCyCe0B3Rgr5vFfK8
r25G7fqaZ5Odd9PgnGs5Y8rSFoCZcuxIJPoevpf66MwecQuw51CIre4hGkxc
rfuwZIIF+LlOJnMsHr2vox/ofRrlgW3f3vm0oe/pqr7PTiu+88B39tOVsSdo
8K/w3GTjAR5YeMXSf+gk4k8pp3//PMID2fU3+rqvo/eLguEqrRgeOCLjd6il
FI0v0TJ3XgQPvJbIdk26g/iCTbiL/h4e0LwlelC1AuVnbkSlVBAPPNwjZuGP
vo/8FcaXtKJ86H9Grz5c9Q9fWT58HOVLzuCWXX5ovdi/PCLPEuXT7AyxOzPR
92tOvmZSjRTC1/zFL3H0/TscorHMS4QHJPe/tQnpROuj0EH9528uOJglMC3u
okGZtKqf+39wgXrgS7uiV+j5/HDn49/PXCCqfcs+qJsGs2P7R0M/cMHVpYrf
/yI7wbWbNfiaC8R9gmYsRc/LnOiVBZvQ8zdPWJbhiWzPjEVpSRd4YGVE4MNq
FH9J2Y6xKdk8kLhl8fZGFP/4nGMqvsj+VX3kYweKXzXs0csiZL+K3sfrQ/GL
P+gxfI7swy/itv+upMFKHYtf75DtYxSXMgWt3wdq663akP3OWqxYo4YGv3Pp
sgXITjgX2TAPvQ9Y6ukjp87xgKKBjp7DMOILFUpOy5E9woh0WPOLBlde3rn4
WxYPfAnhxnqP0eCGl7pTdyE7J6Gw1/8vDQryZ918lckDCzp2bd8hgt5fR2tC
jJGd0nKVtR09b4oWcnEeGTww+NrOdjN63p7MNjMJTeeBzycWlK5Cz5vuyayk
/pM8xD8Xe36dRIetu4PMA5HdPTPwzkdJOoyb6qKkgOzQCrpVpxgd+t5SX96U
ygNJf4RDDeh5P7BdTOISsj/kmN8pQ+tBjUIB6zSypV0Yqblo/RD3Ux3IQXY8
v2zPyZ80mDJ2XespsnteW66L+UGDzjPtOb2necB9TZrkNvR+sQh9+sroDA/s
WTy/2w29D+kJO98cQXaUTPT5pSh/9Nfc15Y+i95XP+QX2iC8beIaQzORbZxr
c8cazcfeHM1S5zQe6Lwy5cdCNF9Bv9uzNVC8keeC3i5B83lTrlREEuFxYGD3
Tg8036omjqcc0fuviGHs7YL4X2tCUcrvvTzgFie1xhrZokrzHfLQ+9PWaOL1
YSU6PCFSdNMdvV+zVP3jA5A9pJL6WHkLD6QfXj/1qiIdxuiXHW9H7+ee5OM7
7ijQof9YxMC5tTyge2LJpPhpdLjJyaYtZBXKp94tZvqIX9o92Ns6fSIPfPqR
OeMnwivqq6jlKFqvA+h2YM0oen88fjxp4DsXDE8b/BiD8Iv6mao3hPK9tWF6
ThjKl7EdZ3ylPnKBBs1QHXynwR009XLzt+h94GU3oWEIvd9WPnq/q5MLgrcr
KMz+QoPzUjVuP0Xvm3Mp64wc+mkw3mUw+nYODzxedSFrdD0dFoz+vrD+Mg/4
7Xl6fbsPHU5l3vQ4j9pLLJIyegPo8BE9d3n0RTQfVtPUlUMQH5s6zUbtPA/0
bfBeei+MDr+aSh2KRngb2WgPXDmA8uvvoo4+lD/LxOSccmLp8MpA37S9iTyQ
P+2Tc3g8wudqgcuOOB64t+1OndIxxN9WqZrIHkDvn002D5wQH7RhLLA4jubj
s5aivQGyD5eylSzQeuPgWV+ZdpQO87aeeLUUrTe8u409ZUfocNChUHEKWm+M
zE0XZR6iw/WVju45aL2ZLrZv+7YoOgzXN85xdueBZ0fnpC3ZR4e/V80Jpq1B
4+9qnBkeTId/9KUTNrrwwBKVy1u4/nSYHXp/wvBqHrgm/mHuXcSnk1bfPjOA
2i18Tjxf6kGHq0IHHgjQ+/Jb4p9gMxc0nwvdH3eu44H34yKLM51R/5Pf5mRt
4oE4p66bbQ50KBcv7zx9spDUJyabWbjnTxKS+oRy+7G5TyWEpD5x+oLevecT
hKQ+cWbNjCbur//XJ6pmRzYkDv6/PiHYohqW9F5A6hOes1Zm/egSkPqE+Lq0
2VvaBKQ+ETrJ8HfcYwGpT/Azrp992iAg9YmzhY7+8fUCUp/A7bg+ge/H9Qnc
P65P4PFxfQL7h+sT2H9cn8Dx4foEjh/XJzA+uD6B8SP6Xf/hi+sT4BTtZq8G
C0iPaa4WFKHvl/LnJ3eZsEDAuCy7KBt9zx0VXe3DZ4HtN46LZ2Wg76M7vWIe
TiwgRlM1PpZOh+LPaiv7NrCAaP6y40nn6LBbydUlK5AFNlln167Oo8MjC7g6
gv0sMGNncIVRKfqekQh/9yCGBXKuG6uI16D1eLwwIyqOBfixO30zntPhlpm8
ZMPDLKCa/It//BPiQ7uXB7RFsUD3itwZW8bocNQrVWFyKAs8z5SRbJ5kDgOm
MPUubmGBKVk1G88omUMtq4MODS7ofoMrMZ9VzOEO5oTdLxaxQMwP7aRFaubw
vfctfQGTBYp6v7UfnmkO281E6rxns8Ar2cLp4vLm0ETBrDV5Jgu8bWxw8BQz
h6LHXqU1ybGAWaTl9cLvdFhsnMOpn8wCSze6/tR5S4fuj9SmdU5hgRb2Lnvj
x3RoYXDWul+BBSL9HI/wIB2GcQs27VNngZ7VF3Nzi9H3W/yMmb0//5/fy82s
9PaO/D+/17Wnfjv37f/5/ebC3MOXB/6f32/XaJyY1Csk+T1JPzZ5Q6eQ5Hfs
Fp0FG1uEJL8LZq3dXF0nJPntuO7CAOe+kOR35SSzqjUVQpLfMRllG8/fFpL8
7ilczlx7S0jyG7fj/Mb34/zG/eP8xuPj/Mb+4fzG/uP8xvHh/Mbx4/zG+OD8
xvjh/Mb4En26eI3u6++sCN5nzez67XusCN6X2tNvB3ZbEbwNs+lOoR1WBG8j
t9lrO55YEbyd9Y+toT2yIng/3mI4mV5pRfD+MWuTaUqpFcE7ZV3eNeliK4K3
tAw71ijPiuDdlHHPcMclK4L33Ctr/sy9aEXwxu0Yb3w/xhv3j/HG42O8sX8Y
b+w/xhvHh/HG8WO8MT4Yb4wf0af7D1+Md+lWbYu3BTxyfvG0YYPOzSIeOb/4
6I1OjE8pj5xf/LF41MXtPo+cX7zQoyg8/ZRHzi9ylwoW9PXwyPlF09rJPR/Q
9wY+v/jO61SarpQFOb/Y+XxSEk/ZgpxfLNk39HFE24KcX2x17Li42dCCnF+0
mJM78cdcC3J+cSag2vH5ReeN1P34/OLINap/fH7Rn0uNj88v3jpJ+YfPL17W
oPzH5xdf3qTiw+cX4w2o+PH5xfsPKXzw+UVNVQo/fH7x6xYKX3x+8ZPh7q8R
STxyfvH9MqPvW9D3Cj6/uNvom/vCgzxyfjH62qyA6WE8cn6x8V3o5k7E3/D5
xRfNVXFp/jxyfvHj2zoNF8QX8PnF0f3Pt05bzyPnF5Nn7hDPR3wMn18svx7u
5Im+r/H5ReXa2Hea/VxyfjHr2hOp1z1ccn7xdK/ZxBzEv/D5xegAl2khrVxy
fnGurda+ZU3c/59f3PEkzKKGS84vRoVQNj6/GLOEuh6fX/y+i+oPn1/88Jka
D59fzCyn/MHnF5OeUP7i84sH71Lx4POLO3WoePH5xY5YCg98frF4gMILn19c
1UHhic8vNnym8MbnF1vKqPnA5xc/0Kj5wucXha7UfOLzixPnUfONzy9eYxky
XhRwyfnFJyH7HSXzuOT84jk4p2/5eS45v7hrubPyhlQuOb9YU8Ey1T3EJecX
zZbJzG0J5pLzi5Yd/Phnm7jk/GKMRcnTU8u45PxiQq2gK9KaS84v3tJbE/OA
zSXnF0+sCHy0woxLzi/O23POv9aES84vLttItePzi7MAdT8+vxj0meofn1/8
s5kaH59fLJkE/vUPn1+8F0X5j88vHvtExYfPL74KpeLH5xdzXlD44POLDjEU
fvj84m42hS8+vyjetkGxbAeL6K28T5kydjSYRfRWlBdvWicMYxG9FcFtLo2B
+AzWWxlcsmLWjlMsorcScydC7V4ui+it7DF3LKssYxG9FdqT50F/GlhEb8Vw
gf1WxU4W0VuZ8NGsqvkDi+it6NyatV8wyCJ6K7FJfc8bvrKI3opXHtWO9VYy
Gqn7sd6KtSbVP9ZbKcumxsd6KxJilH9Yb2X4MOU/1lsx0KHiw3orL5Kp+LHe
ijydwgfrrfjGUPhhvRV+K4Uv1ltx/lE/Fm4+wDdS26zaOyyAi78HSYp19PPX
9rG6a/4iPnsz4+zNt5/4+hIpn/skhfBx2xPBWs8+ftwXp4XZU4VwNDV8fua+
D/xpfhehr4IQ3l7/rT1jWS9/purE2W+UhDBIcOBvnUIPv8S+ZWozsgvsBhuW
97/mZ8qd+sxG1+cFVmoES3fzp24QHXZC/dlltB9s1enkFxrVNe5H44mInLe/
tOgFv344+9Bi5M+rotzUYxc6+OrFlmu9kL+i/7UHbH1mFjYgIPcnMIs+ObwT
kP5NJoTc390lgPn/jX/W6U1d0nMB8S92+qW8sVYBvPWf/zoLdyf3IfvXf/EZ
fm/55Y6ux/EXBxrs1Ef9yf6Hj5Jbb93rHgFc8h9+r3ZZdYgifzC+8gsU0nt/
CKBKZvv3rgQhEN586P8qiAcVfFvlIo4IwSMTjZ33fHnw9a16jz+HhUBtYoFR
9yYejFO2XrkR2fPmGnCOreFBP7qK4i1kv6rflkRz5sHFsd9Mf8cJwZsrEuWz
bXmwaUT8mSrqf8iAP1wDeDBIYmyh1HEh8L246pgfhwenRaTezUhG9s79MRvo
PHhbanl6xUkhSLGbHf3GhAdNBX2d3DQhWLtHO0B1Lg+uz3wKe7OEwLXkZsJc
Ix6U/Ft2PvGiEMyNptrfMJa9nZonBNXrqPsHb8tWGV9BfDeJ6n8KLY9bfVUI
ghqo8QMtsvKLrgvBnVWUfyoXS5ye3ET89A3lPxyO81VEfDhCxPff+NhTNhpt
QfapDVT8+z07NJtLhUCbSeEzp6A5wAHd7+hB4RcQ1Hjk8zUhcHhL4et18GiC
bZ0EwPmtV81xyr0mAXB+tzIOMJV3SQCc3xLjzRnhyhIA57ec35j78TRxgPM7
XPPUAnkFcYDz23+15RLVKDGA87vctT1y/i9RgPO7/IJDW3S4KMD5/XuNsuYF
bVGA89s5p5mt/l4E4Pw2SXfacOeJCMD5jdtxfuP7cX6X/dc/zm88Ps5v7B/O
b+w/zm8cH85vHD/Ob4wPzu/Z/+GH8xvji/P7mpLnXq/XSqCKbfRlyzk1OEF7
qXz/JyUwl6H0ZfJ2NZgan36eNXE62Kp1x9XWSg0WCtQUGJrTQdM+yVPbVdRg
XMuyw86LpgPTsk7bw79V4bDEQHvyzulgXSZQMXunCgc+MnWLs6eDs7OWPot5
rgr//s3INGyfDly3NOXrITvW7f6TQGllUKBx8LRsjyrcP+Px9UksZXDw+L1Z
pb9U4e0yr5nn3ZXBrJK1qyVmqsGVKvZJ3DBlMGqq7LUJqEHFxgvhrGRlYN+q
3vjUVw2ueplQvTdDGXClR7dJZqjBFSd+W4YgezA60ybisRqsKLmoa4iuP7Tj
RfdVEXUoWqUip4f6K3Z9v0J9njrUCxo5GI3GGz0bdjN4lTq8OSH3wAemMtDi
rX1eHqwOZz/n33VA/i5LDDR0P6IOfwwHnRRB8cw5X8Tnp6rDB/27TWJRvJqz
VaVaTqhDl8J7v/0QHif1vw5pxanDCzvHYgWr0feRfcQi9SE2vGp6aHKasxX4
btNzSvsvGy44NhzKs7cC17w6J/tKc2Cx/eiGa0IrINy9eqmhLAdO+73x7Q2O
FSiqWny4B9kSF/xO/J5nBbTyKx8dkeHAFFvxGoaBFfCZHTR/rwgHRt+XUxDX
sQI1Rk2Svj9Q/0A9+YO6FZguXb506zs25D7j3zRXswJbP5vV3H3Khh8aowIn
o3aVvwPWzyrZUNNcNsRdywpUmHzKVSlmw/8VdebxVD1tALeWFtlC3FsRrShL
rnvdqzP3HrQvlCWhok2JFi2EaPejaEMpWSqFFCUqy1RaqEhSIZI1Kdllf6dO
M++fz2fumXme7xme5TznzLuWHRcaptFgqGqc2/c4Lny6+BZlNJsGB0wVfm6I
5EJvrfTjKRw0X5mIdj3DhcmhBgsSKRo0Bxo8WXeaC3Wd80Z5LKDBnESpabvO
c2GJas07ixU0WGSa0UBHc2Hh9p0RYbY0qNpt06yRxIWu9x9rvXGggdbIRHnx
R1yY3hzufdURrX9JcXX0ay6UMvYraF2DeCz0UAyt4sLTq1kBEPFd3WlS5vKL
CxM4GS4pG9H6yzutzjZxYZZ1pibPjQbTtfyyvzVyocMRVn6BO9JfW7bar4EL
5+z1NHXZQYOCm5t1ViI+XJNdNkO7aZB41XBwSx0Xzri47fflfTSwsCyLzq3l
QrXRJ8TAARrk9XlZ2CFZO9NoUa0/DWKfZinoIzkoW2eLShoNipt2TS6p4cLw
0R5FD9JpMImdOvEnkovlLfQdHyB9juVaLEC/758jvnkgiwZ7B0cdqEOyREDM
igsQ5durIkIeo/XlZGe9Msijwc70CcZfkH7nocz9vBc0cHIcVjdD9mSVb2xf
8YoGR5Mi35Z/40Lg0/bTFsm8dSYeo7q5UMe5dfZr9PvBkBSJez1ceFL35HFT
NN/N4EnVk3q5MNOUpxKP1nMYkXduYR8X3vbm9I/IpoHPmN4nRv1cmKtiZr8Z
6fvFzVqzEsmF1zVWPEP2rEu/72MxgPbDb68RU5C9h394pLgj2bnD91sL4rHy
eWZMPpKtrpsGLka8RpzzibuNZJUYV42biOfgTHefVUj+EZDQJONFg5Q0TYtM
NH+9voyYO7ofF9ecM6pA+nyK9z9agu7X3T7F4Gykr3XrlYsA3c8XK3Wvrf2N
7Psgcr6H7vcVqbO/HiN71Stqpc0/0cz54S1clN/E+kiV0sz54ZVcWPO66TB4
TzPnh7/iwoMzbpWN/EAz54c/5MJjmtLdxij//3t+eCKaf5aO5B6U//89P/wy
FzaVSeWYf6OZ88PPcWFrSm2uVBvNnB8exoVfPnEcxfto5vxwtP+3dwyOOiRh
zpwfHs6F67VlDT6NMmfOD49F9roa6GyXMwcSf84Pv432Ly9+daGiOXN+OOTC
j/ev295XMmfOD3/HhS8VQ48povG/54ej/cI//Om81Dhz5vzwDi70MU579mWk
OXN+uBgPnm33mDdFzJw5P3w0D257NNC6tYdmzg8fx4O7buh9dG+hmfPDZXnw
1smoyOp6mjk/XIYH1U/8erinimbODx/iwt1KqSfz/vD9c354KxeOjmrdZR8+
j+QDP1ZHOehemEfyAbZie3ZVzDySD1j6vwwrTp5H8oEupdr9clnzSD4QclDO
d+2beSQfCPhdru78ZR7JB0zCN7+/0DqP5ANzRpXl3xmeR/IB6Vu5GtvHUCQf
mOF3o7JSkSL5wCm7/dytyhTJB7Z5MuM4H7h6hrke5wML6z79nR/nA4/dmPVx
PjDmJaMfzgf6lzH643xgdmPNX/twPlBtz9iP8wGVnra/fHA+sGsxww/nA+YX
Gb44H/jZsHaw/ps6qS/trxl9ybhTndSXTJ5unDmsyCL1pa+7c70KRCxSX4ou
mKn85CCL1Jd691doSjxjkfpSvuOoywNj2aS+dK2Ef7jZik3qS0eviK+ef4pN
6kvlsy/d42azSX1piyd1o7+cTepLw5/8lfTq2aS+tIvLjOP6kt2zqL/X4/pS
8xhmflxfeqXJrI/rSx0XZf7qh+tLd++X/9Uf15f8VRn7cH3Joirnr/24vjTZ
juGD60uhNxh+uL5UVsvwxfWlB7U5H9YdVCf1paTjhyulXNVJfamnPu7ELkt1
Ul/SGi18kzZTndSX5hdlpxSOVSf1Je8DX/lFv9RIfSnthXRI9js1Ul/qNBFk
xaWrkfrSmui4KaPYE0h9SVKuzLplSJXUl7Y4DsZ9/qr6/++Vj9bUr8xTJfUl
r3eXFXoTVEl9aXof35YXrErqS1mOa8QTPFRJfSlHWkNmsbUqqS8pqzMyri9p
7WV+j+tLH1UFf+fD9aWkDmY9XF86PpvRB9eXbA4x+uL6EpvD2IPrS+XPGHtx
fWn3WoYHri+9amF44frSpliGJ64vCToY3ri+5KDD3A9cX0qQjP97v3B9STGW
uZ+4viT/m7nfuL70ReXg12ffVEh9aRXrvWhvpcr/v1du6p2enKNC6kvNQZO3
fj2lQupLs43S85usVEh9qeSIZPbNsSqkviQRWyq8nadM6kvTZ8WvgQeVSX1p
vnPl0Q20MqkvtReKZu0er0zqSxtOXeHc6R5P6ktvtNe98v8xntSXHJ4x47i+
tIdL/70e15dq2pj5cX1J4jOzPq4vlbl8+Ksfri+pzZf6qz+uLy1rYOzD9aXj
kzX+2o/rS7euM3xwfcnMhuGH60sdagxfXF9ySFr6dcVzIbim82uUS686nF+T
tvtGoRD4F83e6ValDsMtwepLH4XA/vC2GP5HdTh9Q90jr2ohcO86Je5epw4t
M737DnwTgiPT4x83S7GgzZZ1prK/hGD2ks6gyRwW3P/0SkxshxBo6VuOVPZi
Qcd6Ga2KLiFo+tXVUfKABU9lCZRCkKz5X6d2njgbVkamvnzYLgRJEspbNSzZ
8EeRz6TYn0LwJOL16O2BKH9xNy9KaBACfpWj87cUNtR/+Wacc5UQjFFZv+9H
ARsClousR6kQ0D90ZU1L2NBQR9cq9LUQdK7JiZn2gg1PsNMH9+UJwRrrhzMT
E9iwdVmpSWG2EKx3jzNcvI8NRyuovFN/IATbjW4PfOexoejRrJU594Vg5ou5
7/d0sqCt3WeTJiRXJx3v9UtmQT+lDXKR6Pclotmm+ZtZUGCq8ORsjhDYnQrc
XK7DggH9oQN7ngnB1/CXugGD6nDFnJXfJNezQcgWkcQZWQB9RTYvoqezwRmP
Bhud0QByVqlPGNnDAgGqZWvGSQN4wdWY6/GOBUavXaY7ZZCCKmfv5/KzWOBg
wNHVwhYKLmpfN64+nQXiD3845FVFwZLpnKfvc1kgTCJz+7NCCh5ZIfHItYwF
dAfUm/mQgmXbcsfUibEBlfM28PVdCvYGqJhnG7GB2LgtTiiRgNaZH5QiPZA/
+vg0dPlVCrYZSx8Mv8UG7s0XQizjKDg10ej7uR9skNjEjJc/63jgOX0imGfA
XN+asqh9gcNEYNjKzJ8ZNpLOD5wITvJYf9fX2ltiah81EdjMZ/RTcb3xa/61
iWDBK0b/Wd7W89qiJ4Jlzxn73riWPMs5MRF4RDP2a5i01E/dMBE0GjB8jqrd
5ZwymgjaA//xk01XntnHBld2M3z7xRquydTwgeb+plvLffhQ+vn60KAKPth/
4FL4cTc+DKprixUv54NxGXOPX7Djw7yo/UvDKvlgxO/DyV0WfFh8csaxH/V8
MM0mihrB4UP2Fa+Yre18sLOtcp/iTD6MGJquMlpCAFTrGxdra/Dh9Rv1av8p
CVB8L2B3sPjwyECw9eGpAvCu+8XgezYfxhqopxzhCMAd2/nvMqbw4Ymz3AF9
CwHY5r0sa4oeH4YpBrY6rBAAI7mpxRSfD8fnbFg60U4AlFSchT8X8+HuzG3z
f9oLwMZxHyPeO/Gh7Q5BwjUbAbg6/MLgmCcfCqyKngUtFYBrGh8fhR/kw4fp
h6YCoQD4n0i0zQrhw+Y5AyrPDAQg+2Hw2KbzfHj5saqvrYYA+LkU7F93kQ8T
o7wXOIwTgKJMXt3zC3yoscnmlXCQD1zO+sbMOMeHfQ6Dcu4tfCBtIT+mN4gP
b+0MSB9Vi/ieWbdklC8f2tdd+HhmFQ9I/4uf9k799SvHigeS1Jj4ynJ7ZMjY
RTzQZ8TEX2zxJw/U5vGAPIuJz9y3JRRXzOaB6+FM/PZh2KcweCIP2AqZ+K7m
2O05J8fwgPd2Jv7TaZqy16qPC5TmMPGh0d7UANNmLoj0Y+JHp3cFM/2/cEGn
ORNfmkrUuMt+4oL4cUz8+X66omJgKRfsf8nEpz1yzPj8w0z8mvODuT7xChPf
qkUx8+8wYeLfWGWtv+tPrG74Gx/bZTD6XdrBxM+b9Q/81f/JB5W/8fXcSMY+
Px4Tfx+axti/TcDE50tOMHwKlZj4vdWI4Tc7gYnvJ9UzfJv/xf86RpsETtcA
CBDo/T5ykgdZO9QshCkAsFZLZC8I48Hj31wKN90HQKi/ZvWPCB7ckh8dOi0b
gA9VB1rfxfPg5eaa9q7HAPRmr9GSucuDbuseGv75PrLUw4jElXk82FK/0nIL
kk91vnWx/sCDZQ5evZ/Q7787Ts4/08iDg8cmff6dBYD14hvRad08KP+JGqOL
1luVkWV9QMIUusp1zRi6BUDCvpE/+kaZworAxTNVkb5SBRY7I8aawnxwoEzv
EgBGFYMi1mhTSCXyOb1nAfCxidzyAF3fe2NBjuZJADaW/bd/VA8Pyk73azE6
AYDBgyue/Wj9pZdlBs8dBcD128ideUi/UmftRz5IPvbar+8Z0n/doQG68TgA
d9OuBu1E9uXv2VF8IwQAmQ1Vv2dd5UH/hVoPndB67LOzOnUieVDqRLWlbxQA
9Uf03m5F/B5c8slxugpA3XXxl8cQ3971/stO3QDAqvn7VofdPJi2eFTPxZsA
SI5tjHRx50Fn44TE54kA/NLcn+S/kQcvmLmMUUgGYHJ/7Ks7zjwY43U91Rvx
mL/dn9Vvx4MbbFx0xW6j6zXOpK+14kFb7izxq3cASMrQSq5ehOy555y8IQ2A
jPPnZQLMefBVZHR/6SsA/IZjnOKbuXB8/vnWtDcAeL9+M9m1ngs/u764kFQE
QNvQZjOLL3++f9tvn1uMfn/aMXZxGRd6PvU9/rMEACc1ns7+EpTf+y/ea/wB
gDfbz6e8fsOFGqk2HuGfALCQC2xf9JILV1beviNXAUCEb+edzicov/avbHlR
DUBlVHNcYD4X3jtnbfnoCwA6B355eb/lQpmke2dCqwCgNjq7OH3kwjdxvQYW
lQDIhcwV6VRx4fNt6cGf0XyNavbt1XVcKBHcK29bjq7fbG7vi+yRv2EgSEPr
Hy5KW9/fxoWndQbD2pB++9qAtONvLoyany0MQPs39bjxHS7iZa36fEn8IwDS
H8q07Ec8//M9F5/4AACzEx5vw5148L5oXV14Bvp9l7d7mCsP9rC/pG9JB6B4
++UaVzceHO8i/0LjLgDr1YRr5Tx50HLOiKJcxL9pnw3rtBcPKkkmh1iiv6eI
0TWOjd5ofy/8yDOtA0y9I4ULw3XOp/QhHn/rHZe58JNpZQYHyX/rHcFcuCc8
RnboK2DqHT5c6Bv6e6ZuA2DqHVu5UDNyksm2H4Cpdzhx4Zf5v9tMOwFT71jF
hQ3sjx19A4Cpd6zgwlLLWWE90kKm3mHFha7r28z2jxMy9Q5bLrQ7I7axUFnI
1DvWc2FFsfZaV5aQqXd4cuHlhPCTeZOETL0jAN0f7Yv/JU8WMvWOM1yYE3Do
oQwa/1vviOdCg7ZX+X1qQqbecZcLd8Rf6y1VEjL1DsiFQetcdk0YK2TqHQVc
uH5mq/Z6SSFT7yjkwi0qmmNc+wBT70D7K77/1OsPbYCpd6D9Jd9d07LtO2Dq
HTlc6BZ49fHDP3z/1DvuoP3i+HlGgoopeV6Rc9VAWKJkSp5XvG8vr9QYa0qe
V5QHS42ZLWZKnldU9DZNaW3lkecVM8OyJ8d84ZHnFdNV2wNi3/DI84qd+za+
2JjFI88rUsU6i5fd4pHnFRfsZA+cieWR5xXagdo5mhd55HnFlyurXM9H8Mjz
CjyOn1fg6/HzCjw/fl6B18fPK7B++HkF1h8/r8D24ecV2H78vALzwc8rMD/8
vALzxc8rduwZuPVd+ye1sIod1YH8eb14w6Vnj5ophX06037/x4cWry4eWl3b
RAUn5z4Rofhhj0SfdvDjRqpw0GOiWBQfvkmfPnPKoXrKRt/W4SGS62J9J1iu
rKVKF5sGuUTw4ZK29riC9V+p7pfzP1md4sN3CtMWzE76Qr3WLXUXBfLhxNXm
BxsuVVL8zjF7wE4+PPOyK7rzyWfqhZ78tXNr+bAgbWxXyexKyr3dsezmUj7U
P6Gws/JjFdUa8aj/l4APzx2zvjHwppo6L+YfkDObD/caTo/Ui62hVoV3l3G1
+bB2WbauDKyjTLZ/UTWZxIcmkdbrxIcbqD0dmWfmTuRDX/fGmL45TdR0r6ER
lpp8OIWVXto5tZm6OXl1s+osPuw8G2OTnPmDGjm6V6sLxYMbWN9SS178pGL6
fINKLflQ/dQlySSzFupDNFtttz0flvFOH8+Rb6Fs7omxNmzlw7nCUfdvmP+k
NmS9m8o9wIc5aeapnVQrNflBXtzmPXzoZrzl9JLUVmpNyNJx2bv5cI5boV+g
Vht1+2SlvvUuPnwVv+SGZ3gbNaTI9Z2O+PTlXZXpGNVOVclKLjPbwYeNU4o3
N/q1U963b/46i+JBBc2122a0t1O/XS3CdZDsVfM+5vSmDuq97kkXKSTLhZau
7XrdS0mupHckePBhtv7kBS7CPsrqaKDHYyT/7hl2SUnvoxx+hYaz0e/pysOm
6TP7qZubyl9lIlm9aruH9eV+Kjt7c+V5tH7VwSu56+UHqKuTmo7eRfqFt+5h
5R4aoMKeFW1TQPZ4G6slWHYOUJnj3TRve/Gh1LSTE0Z0DVBb80fmVqL7vzre
jZtyeICa3e2/8sRhPjzrKbnEW2GAKu9s0e84woc9c49qBkf3U8Ge5+onHuPD
l0p6j0fq9FNJXvlKMsf5sCJdzEUpo4+SL5myKxXJqRm7nN+J+qjTk46/UjvB
h8u6B2a4FfZS6TbUMEDy3YUDbtJbOqhjc4LaLiNZ+kZaYGRHO8UdXNRxGMkF
1cWblhxsp+acFbyageSD/UtDLca0U9Ws9vMhaP4bfa5rbkS0Ua/zNhy5jfSp
szccfUG7jap3ra04fZQPdb+tSeGntVK9WQNdRkj/hfGZU+6BVqp4uysIP4T0
EZap3DwzROH8pOf0+ZSMWUMUzk9MfCI+chWHKJyfNP6UCNNaPETh/CRjnASr
8e0QhfMTV62nuS8jhymcn4Se9JVdt1CM5Ccjq9x01pWKkfyk0/dS68yN4iQ/
+TR13Ju5P8VJfqJoLD4vwkWC5CfL9SyqGx5JgLn/8hPPIJcXvW0SJD9xd7wY
4S0mSfKToyyNcEGDBMlPUqdk/Od0TYLkJ9ctrU/I0xIkP9GbMGk894U4yU8y
r/UJnvLFSX4yZe+omK9JYiQ/Kc5vvD9RS4zkJwu/Lsv8Yj9M4fzEa0mA/MM4
xPdffvJj9YdhDZYAGGQXL5W9x4G32MFBQTMFgC2j5G5xkwOPfRz65moqABNS
jzl0x3EgZ5vzONslAhBjpHctNpYDP0i27//lJAD8dJ0Yl2scuFpm6Nnz7QIw
aX0M58ctDgydc/BWuI8AmN/0VAt9yIFjjxxXsz8sAAuHxhfNL+DA2uPewO64
ADj1ZhwuqeDAxh1F8qJjAqB5eFpL/k8OVJmw/PnsAAFQeNVv/HCIAwV7/TUv
7hGAplNBQQtkTWCLe89Gp80CsFhLTGrRBBP4K2j8z0u2AlDr0nH98yQTOFbz
bdodc6Tv0C8fbw0T6H/TIUfGSABKvze4DLNN4K1FvZfktATgNj0lL328CVQ9
Z7dUVkUA1jvwXlvKmMA5S3e1jpUVgM21UQWpvzlwm7Wt4wsZAXD/MJzOaeTA
CtuUBedGCUBzsPEhQSkHhiWGWrjKCUBvjovN3DwOdFEUk81WEwCx5M/NB9I5
UEmr+OS1bzTYOTXcdpeUAhw2XVT7qJ4Gsx+0nbGD8nAgUWnKSiRvmDwvwnO/
PGTP4qXubqTBZS12s7+hPHy/905NWzMNavNoD/qbHNwYY+m1s50GXd3cqalH
5KDkO8Vu9z4a5LofjaBFcjDvjbc/kDQHPiZaRcumycEm274izlhzMLWNLpc3
koP3yl/WRIw3Bx/dInMPb5aDhtvuJ2SwzMHItRmBu3LlYEOcZamkpjnIHlZ8
3KgmD7fcDI2X0zYH4kXySXFO8lDZs/3oJSRbFkSYHLgmD48kHZxzZYo5mCXZ
xUpplod7MyQPgEnmQHd50ZcLsxTg4w1s7XJVc+Chus/X0EkBNhnGn/slZw7u
dhwa3nJQAZY+NHHQGmkOQrwSq/1PKUBRgSN71hAN1ixLWDMvSAHmZtZNyuqi
wTfB0AKlHQqwtpTnc6yFBtOCffZJWChACa4Eb2ITDRI3DZoEjFGABR53fQ26
zUi89OS+zHmnDjMSL32SSjNIajYj8VLV5QrnzC9mJF76MubxXp+3ZiRe0os7
t3tWrhmJl3Rm5r/XuWVG4qU9QQJWa5QZiZfSFV9NLQsxI/HSZbe6QnagGYmX
ZpztV0j2NiPxUm2qTsbkfWYkXsLjOF7C1+N4Cc+P4yW8Po6XsH44XsL643gJ
24fjJWw/jpcwHxwvYX44XsJ8cbx0/MGPmhe5vdTA9FF6+i2GMDHC3F4YgfzP
trdG3zoM4SftcD+BdT/VXEBXpQ8YQqon8+HV+n5KUU7nipKMEfz83PFd9oIB
quaSpoyNshF8L1a36caeAQou8hJP1TKCcTVzFB65DVDXH7+5t9TQCDo9//g4
ceoAddu4ac9SYAQzf3NkAm71UxJhe+orlhjBIcv+r6tl+qmpLtXHTO2MYME5
77vioA/FM+zRr52NYFTE9SLbdb2UwSXt6ImuRrCfM9bx4t7flMnKwpyfSN5B
KZtdD+uhIjPvquivN4JeupO71LO6qYGyZabj1hjBJlrpe5h0N1WfO8eg3soI
ZtSlWpXt66L+u5LSTlkaQXmnxaoOrC6qxDlrZhHXCMZ82ep1qquTiozJzXKe
ZQTD+ab5d2W6qCBbq8x8lhHcUDUxLmEl+r3u9FU/ZdH8A8M/fxd3US5xEz5G
iRvBREpvnY5vN7U1eZJmWI8hfN0Tfb27niL7O4/qzJlSS5H9XX7y8podFRTZ
39XTXpzwK6LI/v56LjmGghTZ33N0Ai7/SqHI/tZLuzfUeoki+3uf4gyL9GCK
7O+MqPvLo30psr+vtBf9/rqDIvt7FruRv9ONIvu73lT1a90miuxvPI73N74e
7288P97feH28v7F+eH9j/fH+xvbh/Y3tx/sb88H7G/PD+xvzxft7M7D4Vony
M8zbtc6zc3cTILw9gvOeXKwHhHeb3erVsV8A4d0+bslGCZTPY95q5emuDkWA
8I6cuGL8mueA8M56E2SSjfJ7zNtRsTjL4D4gvN9mO51eifJzzDvcuskwKhkQ
3h3rA6VtkgDhjccxb3w95o3nx7zx+pg31g/zxvpj3tg+zBvbj3ljPpg35od5
Y76Y96OGLo8H2kqEd9SIxW/d1JQI7455raKYPkXCe0x8eM/7AsX/9+et0bWr
PKlIeC+457Po8gJFwhu8XVIUJ6ZIeG+yUm+6+0iB8N60d5WS/UEFwnvEuwcZ
m1YoEN4G+1Xy4g0VCO/JHR/sd81QILzxOOYt/e96zBvPj3nj9TFvrB/mjfUn
/Xn/7MO8sf2YN+aDeWN+mDfmi3nnjb6qUlirTnhfndW7z/+TOuE94BL9/d4D
dcJ7/AvzK01B6oS32sHyobYl6oS31acZ7akj1QnvhZ19ezNy1Qhvzz0vw176
qBHenhclHrnPUyO8x3VvXntATo3wNr2Uty2zbQLhPUP1qNjxxgmENx7HvPH1
mDeeH/PG62PeWD/MG+uPeWP7MG9sP+aN+WDemB/mjfli3ptUZ67daaVJeNsm
lITmL9YkvA/R0/I3CDQJ71N7vLUOamsS3qetzFdKjtD8f3zi37zEtVaD8J4R
skpuU67G//+fLOFfarmkQXgL1tqnQn8NwnuMbLDkgs0ahLfmugdBm+w1CO/I
y2rvl67UILzxOOaNr8e88fzk/8m/9TFvrB/mrftPf8wb24d5Y/sxb8wH88b8
SP/pP76Y99aZYnf79acS3g4PEmtX6kwlvI/ZDLJ/saYS3meOr9g3Smoq4X3e
lZVwsl6b8DYIexLz84k24a0brePaGq1NeENnxdb9vtqEN9g5R3qxszbhLTfZ
xe6dpTbhPXVXWGWriTbhfel26/RPhtqENx7HvPH1mDeeH/PG62PeWD/MW/+f
/pg3tg/zxvZj3pgP5o35Yd6YL+Z9Rac7XlAlJP2ntxoCp0V+EpL+UzC/9Syn
WEj6T5MlOn1vvxSS/lPZNKfB1Fwh6T8VX7PlTvd9Iek/DRMb/qp/W0j6TwMP
jNYTuykk/aegRzWl9qqQ9J8ah/CK58QLSf9p7VG/kJFoHPefspplzqxOEJL+
0zfXtt79miwk/ac5EgmrZ98Tkv5Tr/KU2JtZQtJ/mmCp43LtmZD0n05XztFy
KxSS/tPCwoof4IOQ9J/ma29LDf4sJP2nztsfmb2sFpL+0ztxYWev1AhJ/+lw
89665q9C0n8aIq988RHii/tP437e8b3ZLCT9pxmj0vhzfwlJ/6kNX7n2WbuQ
9J/O0nNb5dQtJP2nRi3bPHt7haT/VMtqo+KFQSHpPx3/OFCdLy4i/aeTPfU2
VEmJSP/pEa+phxS4ItJ/evrx5qZ7fBHpP339Yt4iO0pE+k+7G/oCekQi0n86
yLm49ZyliPSfjs7TqtddJCL9p2H7JN7mLhWR/tOM02vHLrESkf5TvkHzSGsk
4/7TacrfF7xAv8f9pydqj8Uao/lw/+ndNkP9aLQe7j9N1NdXlqBFpP/04RvO
LhekL+4/zXdS3wqRPbj/NOe2h8ZEZC/uP12duFfiO+KB+0+XOM2NskS8cP+p
gp2T6VXEE/efNprESkr1CUn/aXWjuPpmdD9w/2mJw/4rheh+4f7TpQkX7vHR
/cT9p9NOCvbfRvcb958qn6mcTDmLSP9plFfUuWEHEek/rTxce5mPZNx/6vPl
eoeEo4j0nwZ+GpIzWCci/afTvmpP3LFJRPpP68KGPlIeItJ/2ryxsmx4r4j0
n5aH6u8dOCgi/adbEnu0/E6ISP+pY8WIxSWhItJ/Wq2uY7HlvIj0n8a1Xtqd
Hyki/afvtsfsSL0gIv2nT/NPxMiicdx/yjF9d3v4rIj0n+75kfSl/KSI9J+e
urnFfuIxEek/3bSre/QmPxHpP92+dnrbZi8R6T+9YX4+rWKbiPSfKlNN73ds
EJH+U4+CxITcP3z/9Z+20inXdtyjyfs63+STHyum0eR9nftOcQqhd2jyvs66
R2oju27T5H0d+mNr3iI0jt/X0dLLrw5Jpcn7OlejKo6m3KXJ+zqLEot7Ltyn
yfs6jdrbdxg8pMn7OqHJM5evyKHJ+zpS9bmnXj+hyfs6HPObO/e/oMn7Op/j
zqzSfk2T93Uyymaci3lLk/d1njnX78p9T5P3dWpKA5ptP9HkfZ351XudRBU0
eV+ndWGQxIZKmryvc/7i+knXq2jyvo5sKvdzP5Lx+zqrRt0pXo9k/L7O4Irr
mlWfafK+joXaVbOAcpq8r7NraYqDfKsu8d8ulfbBW77rEv99yjspT7JCl/jv
i0lDkyY91SX++/Lx/GVxV3WJ/+bd27FA4pAu8d9zn5SNlnbWJf775SEYcZKv
S/z3gvOVyWsn6hL/rUrLDzdI6xL/rRc+76h0jw7x31dLoot+tOkQ/43Hsf/G
12P/jefH/huvj/031g/7b+4//bH/xvZh/43tx/4b88H+G/PD/hvzJfnXbZHd
m836hPfdngjP3g36hHe+hXDsfCd9wruoaitvlZU+4f12yQorFZE+4T2pVmvZ
c319wpu91f72i0n6/8+/Cl51BcvqE95LEu6JfR+YQ3izbBqtd9bP+X/+dUO5
LPTDHML7Rv0erX3Fc/6ff/0bx7zx9Zg3np/kX//Wx7yxfpg31h/zxvZh3th+
zBvzwbwxP5J//eOLeedwZweesTMkvO8HHL6Qs8qQ8H5dqMsZu9SQ8H632dZV
TWhIeJeU8g9UGBgS3prucvuDNQwJ78kddFnIOEPC221lxmSrQQPC++Zni1mm
LQaE92mjtSV+NQaEN9tpr4pshQHh/fHA9UcBnwwIbzyOeePrMW88P+aN18e8
sX6YN9Yf88b2Yd7Yfswb88G8MT/MG/PFvOFjtSS7+XMJ78xRnk8Pm88lvAvt
JqwrFswlvN+3Ck9W6c8lvEudp1+L0ZxLeGt19cWukJ9LeGv6zpG0HjIivLd9
jluo8tOI8E7aaLBquNKI8D6btWhQ9M6I8J7UsB68KzAivMukztRbvDQivPE4
5o2vJ++3/psf88brY95YP8wb6495Y/swb2w/5o35YN6YH+aN+WLe35/b99+/
QIORR0ouPbnPgfP1bw1ciEP+QxTud/YBBxqUZ6RlJdJg9eUIFv2YA92mfhq3
H/nDFR/D4o3ecCBbwrVUiPxfg+bq756fOfCDg+a9jEwayPuZqOb+5MDEaWBq
ApKn32l6lD3MgXajHvsqoN9PvjbBrk/eBM6PnPtGB83XXVbYo6hhAo0XtFxz
QOvZKNvFFuuYQFqGLTEL6TM8IWSGhZEJbI5wGSdC+t5cNDLkvbEJjIo9mbQ6
jAam17t4f84LWLrM+un0EzS4axY2/895A7c/OVxaFUiDlUvjaC00P2tVtYO7
Lw0WxNf3yiqYwHSTgScl3jSItj4wpQTp5251RAsiuWAu+7/3SH8zdTc5I/R7
yaVTUg8j+46nu5r1BdDAK37aDHNk/yfL4LC7x2lwuODV6OWIj6TnUPf7UBqE
NNnXXED8vONH+mVE0qDLpKLjD9/X66pbVobTYP2DsttlVzhw2gqHzKjzNIgz
UjuQeoEDuQdkDYfP0SAvfdFqv7McCPaMPemP5Ji3qwR/zsOYOzu5TQ3JZjMo
tT/nZeQt3Xew+Czy/2vPN/45T6NwufbSa0i+xcuPcfThQJ+Np7acR/Is7XPU
aC8037mm0X5Ibu284aHA4sCGxWO9g5DsOXN7S854DtQWl+CkIbkkKnyRxzgO
TFaWNu5B8tO6fj9NGQ5c1L57nT1af8oa6lC5OAeOLfp4ofSPfEp/eVS/MZwH
Wh54IHuyrGaXb+wyhi5H08O0kL1tp4KUBb+M4Yehe9GVUSj+6gkrMkayrxy/
9PwlGnz2tZJyRr/fWnd8jeFlGjzsmzztDJrP5fsJsbtIrvqiTL9F63kYNEWp
RtNAeEJn05/zMqoUJo1bh+RRVqURf87TeC+3E4QguXhvbFUasmdG34ipl5C8
KuQDJY3sdXmVdOgekk89eiw/tJsDs5SCxt9AstzxwbAViJe/81m7g0hOGv9+
bizi2b0wzN4UyY9eeYi3IN722zX1ypA+jjY6g3PR/QgPy+5Y80eeYqrvhe7X
hskJJU+QPU+cBdduovsJyr8MyCL5pOZXtxJ0v2uua5/xQfshuVr915JPxjBs
nc7BCLRfhvU4P31LjaEMqyPSC+2n5T1mrMI3xtDscW9bJtpv3+ezBFWPjaG9
dfOrlgOI5+C27XFpxnDanBsB+9F+HSM2339lrDE8dD8j+gSSPyv1f1wVagwX
f9OumIj2b5au2ICqvzGklo3WlUR/D7vs/KuHPIzh9XHJo96j9VSWSIVQrsZQ
cluevxT6e2rz2W7yag0an+Th8gPp2/T+QqfpajS+bHrp+1gatJy23PwUjT/3
72wegf5eD5RMDdFH11sbeDqWo/jZKvpbXROa/9ub/QNP0mlw5Vfo3SE/Yzh7
touYI/p/UMUuX8hD+tVtSZLfgWT9yPnVJkj/4C12pwfR7ysXXO8+gew7m93z
hIP+P+z33dHzEtlPqRU89EPrUQGbs3MQnwMLko84ov8PTd+zU70QP57Dbnkf
9P/h58cxB//wvT01P3ZnOp/0+77ZNOnh5TQ+6fe9nPLCtjmRT/p9d4vaDv+O
5pN+36fJH6IehvJJv6+eMDFyqz+f9PvyXlb1bnPnk37fQ7Osgf4aPun3/S+j
epHaEj7p972n1NfhCPik3/c0rWDyg8sn/b46bsLPazl80u+7zIoZx/2+yrOZ
63G/747PzPy43/e3LbM+7vdN+c3oh/t9c3Yy+uN+3+Ayxj7c71u2mbEf9/vG
5zN8cL/v/D0MP9zvu2cawxf3+z5ZJF3KNuEQ//3wjMPPBXM5xH+/rZb8L1yX
Q/z3B2+9jHgNDvHfHxsVizYqcIj/nurf8EpZjEP8t5Y0S0+1xZj47+0bT+2u
+GxM/PetFrZ/3htj4r/PW3CmyzwxJv5bw3Pp1oiHxsR/V5z0kxuTaUz8Nx7H
/htfj/03nh/7b7w+9t9YP+y/sf7Yf2P7sP/G9mP/jflg/435Yf+N+WL/3XeQ
y7tmN4J8z+tBbk2/tHAE+Z7XVn29r7skR/z/+4C/vRd9jpcm3/O6uuXaqJ8z
pcn3vMazRK3uV6TI97wkVzb07pOTIt/zsrIJ1Lt4VJJ8z8vqSldgzVhJ8j2v
UFtYMJwiQb7n1RDnXeu9W4J8z+tJZN9Y1bUS5HteeBx/zwtfj7/nteLf/Ph7
Xnh9/D0vrB/+nhfWH3/PC9tHvg/4z378PS/MB3/P6+E/fvh7Xpgv/p7X/wDx
K7zi
    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 
        10}, {3, 11}, {3, 12}, {10, 459}, {10, 460}, {10, 492}, {10, 649, 650,
         651, 652, 653, 654, 655, 656, 657, 658, 659, 660, 661, 662, 663, 664,
         665, 666, 667, 668, 669, 670, 671, 10}, {13, 4}, {13, 5}, {13, 6}, {
        13, 7}, {13, 8}, {13, 9}, {13, 10}, {13, 11}, {13, 12}, {14, 15}, {14,
         16}, {17, 18}, {17, 19}, {17, 20}, {17, 21}, {17, 22}, {17, 23}, {24,
         25}, {24, 26}, {27, 672, 673, 674, 675, 676, 677, 678, 679, 680, 681,
         682, 683, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693, 694, 
        27}, {27, 28}, {27, 29}, {27, 30}, {27, 31}, {30, 463}, {32, 33}, {32,
         34}, {33, 695, 696, 697, 698, 699, 700, 701, 702, 703, 704, 705, 706,
         707, 708, 709, 710, 711, 712, 713, 714, 715, 716, 717, 33}, {33, 
        34}, {35, 718, 719, 720, 721, 722, 723, 724, 725, 726, 727, 728, 729, 
        730, 731, 732, 733, 734, 735, 736, 737, 738, 739, 740, 35}, {35, 741, 
        742, 743, 744, 745, 746, 747, 748, 749, 750, 751, 752, 753, 754, 755, 
        756, 36}, {36, 757, 758, 759, 760, 761, 762, 763, 764, 765, 766, 767, 
        768, 769, 770, 771, 772, 35}, {36, 773, 774, 775, 776, 777, 778, 779, 
        780, 781, 782, 783, 784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 
        794, 795, 36}, {37, 796, 797, 798, 799, 800, 801, 802, 803, 804, 805, 
        806, 807, 808, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818, 
        37}, {38, 39}, {39, 819, 820, 821, 822, 823, 824, 825, 826, 827, 828, 
        829, 830, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 
        39}, {40, 842, 843, 844, 845, 846, 847, 848, 849, 850, 851, 852, 853, 
        854, 855, 856, 857, 858, 859, 860, 861, 862, 863, 864, 40}, {40, 865, 
        866, 867, 868, 869, 870, 871, 872, 873, 874, 875, 876, 877, 878, 879, 
        880, 41}, {40, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890, 891, 
        892, 893, 894, 895, 896, 42}, {40, 897, 898, 899, 900, 901, 902, 903, 
        904, 905, 906, 907, 908, 909, 910, 911, 912, 43}, {41, 913, 914, 915, 
        916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 
        40}, {41, 929, 930, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 
        941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 41}, {41, 952, 
        953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 
        967, 42}, {41, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 
        979, 980, 981, 982, 983, 43}, {42, 984, 985, 986, 987, 988, 989, 990, 
        991, 992, 993, 994, 995, 996, 997, 998, 999, 40}, {42, 1000, 1001, 
        1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 
        1013, 1014, 1015, 41}, {42, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 
        1023, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 
        1034, 1035, 1036, 1037, 1038, 42}, {42, 1039, 1040, 1041, 1042, 1043, 
        1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 
        43}, {43, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 
        1065, 1066, 1067, 1068, 1069, 1070, 40}, {43, 1071, 1072, 1073, 1074, 
        1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 
        1086, 41}, {43, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 
        1096, 1097, 1098, 1099, 1100, 1101, 1102, 42}, {43, 1103, 1104, 1105, 
        1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 
        1117, 1118, 1119, 1120, 1121, 1122, 1123, 1124, 1125, 43}, {44, 40}, {
        44, 41}, {44, 42}, {44, 43}, {45, 1126, 1127, 1128, 1129, 1130, 1131, 
        1132, 1133, 1134, 1135, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 
        1143, 1144, 1145, 1146, 1147, 1148, 45}, {45, 46}, {47, 48}, {49, 
        1149, 1150, 1151, 1152, 1153, 1154, 1155, 1156, 1157, 1158, 1159, 
        1160, 1161, 1162, 1163, 1164, 1165, 1166, 1167, 1168, 1169, 1170, 
        1171, 49}, {49, 50}, {49, 51}, {52, 1172, 1173, 1174, 1175, 1176, 
        1177, 1178, 1179, 1180, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 
        1188, 1189, 1190, 1191, 1192, 1193, 1194, 52}, {52, 53}, {52, 54}, {
        52, 1195, 1196, 1197, 1198, 1199, 1200, 1201, 1202, 1203, 1204, 1205, 
        1206, 1207, 1208, 1209, 1210, 55}, {52, 56}, {55, 1211, 1212, 1213, 
        1214, 1215, 1216, 1217, 1218, 1219, 1220, 1221, 1222, 1223, 1224, 
        1225, 1226, 52}, {55, 53}, {55, 54}, {55, 1227, 1228, 1229, 1230, 
        1231, 1232, 1233, 1234, 1235, 1236, 1237, 1238, 1239, 1240, 1241, 
        1242, 1243, 1244, 1245, 1246, 1247, 1248, 1249, 55}, {55, 56}, {57, 
        1250, 1251, 1252, 1253, 1254, 1255, 1256, 1257, 1258, 1259, 1260, 
        1261, 1262, 1263, 1264, 1265, 1266, 1267, 1268, 1269, 1270, 1271, 
        1272, 57}, {58, 1273, 1274, 1275, 1276, 1277, 1278, 1279, 1280, 1281, 
        1282, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 1290, 1291, 1292, 
        1293, 1294, 1295, 58}, {59, 37}, {60, 61}, {61, 1296, 1297, 1298, 
        1299, 1300, 1301, 1302, 1303, 1304, 1305, 1306, 1307, 1308, 1309, 
        1310, 1311, 1312, 1313, 1314, 1315, 1316, 1317, 1318, 61}, {62, 1319, 
        1320, 1321, 1322, 1323, 1324, 1325, 1326, 1327, 1328, 1329, 1330, 
        1331, 1332, 1333, 1334, 1335, 1336, 1337, 1338, 1339, 1340, 1341, 
        62}, {62, 1342, 1343, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 
        1352, 1353, 1354, 1355, 1356, 1357, 63}, {63, 1358, 1359, 1360, 1361, 
        1362, 1363, 1364, 1365, 1366, 1367, 1368, 1369, 1370, 1371, 1372, 
        1373, 62}, {63, 588}, {63, 254}, {63, 1374, 1375, 1376, 1377, 1378, 
        1379, 1380, 1381, 1382, 1383, 1384, 1385, 1386, 1387, 1388, 1389, 
        1390, 1391, 1392, 1393, 1394, 1395, 1396, 63}, {64, 65}, {64, 66}, {
        67, 1397, 1398, 1399, 1400, 1401, 1402, 1403, 1404, 1405, 1406, 1407, 
        1408, 1409, 1410, 1411, 1412, 1413, 1414, 1415, 1416, 1417, 1418, 
        1419, 67}, {67, 68}, {69, 70}, {69, 71}, {69, 72}, {70, 1420, 1421, 
        1422, 1423, 1424, 1425, 1426, 1427, 1428, 1429, 1430, 1431, 1432, 
        1433, 1434, 1435, 1436, 1437, 1438, 1439, 1440, 1441, 1442, 70}, {70, 
        71}, {70, 72}, {73, 1443, 1444, 1445, 1446, 1447, 1448, 1449, 1450, 
        1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459, 1460, 1461, 
        1462, 1463, 1464, 1465, 73}, {74, 1466, 1467, 1468, 1469, 1470, 1471, 
        1472, 1473, 1474, 1475, 1476, 1477, 1478, 1479, 1480, 1481, 1482, 
        1483, 1484, 1485, 1486, 1487, 1488, 74}, {74, 1489, 1490, 1491, 1492, 
        1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503, 
        1504, 75}, {74, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 
        1514, 1515, 1516, 1517, 1518, 1519, 1520, 76}, {75, 1521, 1522, 1523, 
        1524, 1525, 1526, 1527, 1528, 1529, 1530, 1531, 1532, 1533, 1534, 
        1535, 1536, 74}, {75, 1537, 1538, 1539, 1540, 1541, 1542, 1543, 1544, 
        1545, 1546, 1547, 1548, 1549, 1550, 1551, 1552, 1553, 1554, 1555, 
        1556, 1557, 1558, 1559, 75}, {75, 1560, 1561, 1562, 1563, 1564, 1565, 
        1566, 1567, 1568, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 76}, {76, 
        1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 
        1587, 1588, 1589, 1590, 1591, 74}, {76, 1592, 1593, 1594, 1595, 1596, 
        1597, 1598, 1599, 1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 
        75}, {76, 1608, 1609, 1610, 1611, 1612, 1613, 1614, 1615, 1616, 1617, 
        1618, 1619, 1620, 1621, 1622, 1623, 1624, 1625, 1626, 1627, 1628, 
        1629, 1630, 76}, {77, 1631, 1632, 1633, 1634, 1635, 1636, 1637, 1638, 
        1639, 1640, 1641, 1642, 1643, 1644, 1645, 1646, 1647, 1648, 1649, 
        1650, 1651, 1652, 1653, 77}, {77, 78}, {77, 79}, {77, 1654, 1655, 
        1656, 1657, 1658, 1659, 1660, 1661, 1662, 1663, 1664, 1665, 1666, 
        1667, 1668, 1669, 80}, {80, 1670, 1671, 1672, 1673, 1674, 1675, 1676, 
        1677, 1678, 1679, 1680, 1681, 1682, 1683, 1684, 1685, 77}, {80, 78}, {
        80, 79}, {80, 1686, 1687, 1688, 1689, 1690, 1691, 1692, 1693, 1694, 
        1695, 1696, 1697, 1698, 1699, 1700, 1701, 1702, 1703, 1704, 1705, 
        1706, 1707, 1708, 80}, {81, 1709, 1710, 1711, 1712, 1713, 1714, 1715, 
        1716, 1717, 1718, 1719, 1720, 1721, 1722, 1723, 1724, 1725, 1726, 
        1727, 1728, 1729, 1730, 1731, 81}, {82, 1732, 1733, 1734, 1735, 1736, 
        1737, 1738, 1739, 1740, 1741, 1742, 1743, 1744, 1745, 1746, 1747, 
        1748, 1749, 1750, 1751, 1752, 1753, 1754, 82}, {83, 84}, {83, 85}, {
        83, 86}, {83, 87}, {84, 1755, 1756, 1757, 1758, 1759, 1760, 1761, 
        1762, 1763, 1764, 1765, 1766, 1767, 1768, 1769, 1770, 1771, 1772, 
        1773, 1774, 1775, 1776, 1777, 84}, {84, 1778, 1779, 1780, 1781, 1782, 
        1783, 1784, 1785, 1786, 1787, 1788, 1789, 1790, 1791, 1792, 1793, 
        85}, {84, 1794, 1795, 1796, 1797, 1798, 1799, 1800, 1801, 1802, 1803, 
        1804, 1805, 1806, 1807, 1808, 1809, 86}, {84, 1810, 1811, 1812, 1813, 
        1814, 1815, 1816, 1817, 1818, 1819, 1820, 1821, 1822, 1823, 1824, 
        1825, 87}, {85, 1826, 1827, 1828, 1829, 1830, 1831, 1832, 1833, 1834, 
        1835, 1836, 1837, 1838, 1839, 1840, 1841, 84}, {85, 1842, 1843, 1844, 
        1845, 1846, 1847, 1848, 1849, 1850, 1851, 1852, 1853, 1854, 1855, 
        1856, 1857, 1858, 1859, 1860, 1861, 1862, 1863, 1864, 85}, {85, 1865, 
        1866, 1867, 1868, 1869, 1870, 1871, 1872, 1873, 1874, 1875, 1876, 
        1877, 1878, 1879, 1880, 86}, {85, 1881, 1882, 1883, 1884, 1885, 1886, 
        1887, 1888, 1889, 1890, 1891, 1892, 1893, 1894, 1895, 1896, 87}, {86, 
        1897, 1898, 1899, 1900, 1901, 1902, 1903, 1904, 1905, 1906, 1907, 
        1908, 1909, 1910, 1911, 1912, 84}, {86, 1913, 1914, 1915, 1916, 1917, 
        1918, 1919, 1920, 1921, 1922, 1923, 1924, 1925, 1926, 1927, 1928, 
        85}, {86, 1929, 1930, 1931, 1932, 1933, 1934, 1935, 1936, 1937, 1938, 
        1939, 1940, 1941, 1942, 1943, 1944, 1945, 1946, 1947, 1948, 1949, 
        1950, 1951, 86}, {86, 1952, 1953, 1954, 1955, 1956, 1957, 1958, 1959, 
        1960, 1961, 1962, 1963, 1964, 1965, 1966, 1967, 87}, {87, 1968, 1969, 
        1970, 1971, 1972, 1973, 1974, 1975, 1976, 1977, 1978, 1979, 1980, 
        1981, 1982, 1983, 84}, {87, 1984, 1985, 1986, 1987, 1988, 1989, 1990, 
        1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 85}, {87, 2000, 
        2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 
        2012, 2013, 2014, 2015, 86}, {87, 2016, 2017, 2018, 2019, 2020, 2021, 
        2022, 2023, 2024, 2025, 2026, 2027, 2028, 2029, 2030, 2031, 2032, 
        2033, 2034, 2035, 2036, 2037, 2038, 87}, {88, 2039, 2040, 2041, 2042, 
        2043, 2044, 2045, 2046, 2047, 2048, 2049, 2050, 2051, 2052, 2053, 
        2054, 2055, 2056, 2057, 2058, 2059, 2060, 2061, 88}, {88, 2062, 2063, 
        2064, 2065, 2066, 2067, 2068, 2069, 2070, 2071, 2072, 2073, 2074, 
        2075, 2076, 2077, 89}, {88, 90}, {88, 91}, {88, 92}, {88, 93}, {88, 
        94}, {89, 2078, 2079, 2080, 2081, 2082, 2083, 2084, 2085, 2086, 2087, 
        2088, 2089, 2090, 2091, 2092, 2093, 88}, {89, 2094, 2095, 2096, 2097, 
        2098, 2099, 2100, 2101, 2102, 2103, 2104, 2105, 2106, 2107, 2108, 
        2109, 2110, 2111, 2112, 2113, 2114, 2115, 2116, 89}, {89, 90}, {89, 
        93}, {89, 94}, {93, 297}, {93, 298}, {93, 299}, {93, 300}, {93, 
        301}, {94, 297}, {94, 298}, {94, 299}, {94, 300}, {94, 301}, {95, 
        2117, 2118, 2119, 2120, 2121, 2122, 2123, 2124, 2125, 2126, 2127, 
        2128, 2129, 2130, 2131, 2132, 2133, 2134, 2135, 2136, 2137, 2138, 
        2139, 95}, {95, 96}, {95, 97}, {95, 98}, {95, 99}, {96, 88}, {96, 
        145}, {96, 2140, 2141, 2142, 2143, 2144, 2145, 2146, 2147, 2148, 2149,
         2150, 2151, 2152, 2153, 2154, 2155, 2156, 2157, 2158, 2159, 2160, 
        2161, 2162, 96}, {96, 146}, {96, 147}, {96, 148}, {96, 149}, {100, 
        88}, {101, 102}, {102, 2163, 2164, 2165, 2166, 2167, 2168, 2169, 2170,
         2171, 2172, 2173, 2174, 2175, 2176, 2177, 2178, 2179, 2180, 2181, 
        2182, 2183, 2184, 2185, 102}, {103, 104}, {103, 105}, {103, 106}, {
        103, 107}, {103, 108}, {103, 109}, {108, 2186, 2187, 2188, 2189, 2190,
         2191, 2192, 2193, 2194, 2195, 2196, 2197, 2198, 2199, 2200, 2201, 
        2202, 2203, 2204, 2205, 2206, 2207, 2208, 108}, {108, 109}, {110, 
        111}, {112, 111}, {112, 88}, {112, 91}, {112, 92}, {113, 114}, {113, 
        115}, {115, 114}, {115, 2209, 2210, 2211, 2212, 2213, 2214, 2215, 
        2216, 2217, 2218, 2219, 2220, 2221, 2222, 2223, 2224, 2225, 2226, 
        2227, 2228, 2229, 2230, 2231, 115}, {116, 117}, {116, 118}, {116, 
        119}, {116, 120}, {116, 121}, {116, 122}, {116, 123}, {116, 124}, {
        121, 117}, {121, 118}, {121, 119}, {121, 2232, 2233, 2234, 2235, 2236,
         2237, 2238, 2239, 2240, 2241, 2242, 2243, 2244, 2245, 2246, 2247, 
        2248, 2249, 2250, 2251, 2252, 2253, 2254, 121}, {121, 122}, {121, 
        123}, {121, 124}, {125, 37}, {125, 126}, {125, 127}, {125, 128}, {126,
         2255, 2256, 2257, 2258, 2259, 2260, 2261, 2262, 2263, 2264, 2265, 
        2266, 2267, 2268, 2269, 2270, 2271, 2272, 2273, 2274, 2275, 2276, 
        2277, 126}, {126, 127}, {126, 166}, {126, 2278, 2279, 2280, 2281, 
        2282, 2283, 2284, 2285, 2286, 2287, 2288, 2289, 2290, 2291, 2292, 
        2293, 128}, {128, 2294, 2295, 2296, 2297, 2298, 2299, 2300, 2301, 
        2302, 2303, 2304, 2305, 2306, 2307, 2308, 2309, 126}, {128, 127}, {
        128, 2310, 2311, 2312, 2313, 2314, 2315, 2316, 2317, 2318, 2319, 2320,
         2321, 2322, 2323, 2324, 2325, 2326, 2327, 2328, 2329, 2330, 2331, 
        2332, 128}, {129, 2333, 2334, 2335, 2336, 2337, 2338, 2339, 2340, 
        2341, 2342, 2343, 2344, 2345, 2346, 2347, 2348, 2349, 2350, 2351, 
        2352, 2353, 2354, 2355, 129}, {130, 2356, 2357, 2358, 2359, 2360, 
        2361, 2362, 2363, 2364, 2365, 2366, 2367, 2368, 2369, 2370, 2371, 
        2372, 2373, 2374, 2375, 2376, 2377, 2378, 130}, {131, 2379, 2380, 
        2381, 2382, 2383, 2384, 2385, 2386, 2387, 2388, 2389, 2390, 2391, 
        2392, 2393, 2394, 2395, 2396, 2397, 2398, 2399, 2400, 2401, 131}, {
        131, 132}, {131, 133}, {134, 131}, {134, 132}, {134, 133}, {135, 
        136}, {135, 137}, {135, 138}, {139, 2402, 2403, 2404, 2405, 2406, 
        2407, 2408, 2409, 2410, 2411, 2412, 2413, 2414, 2415, 2416, 2417, 
        2418, 2419, 2420, 2421, 2422, 2423, 2424, 139}, {139, 2425, 2426, 
        2427, 2428, 2429, 2430, 2431, 2432, 2433, 2434, 2435, 2436, 2437, 
        2438, 2439, 2440, 140}, {139, 2441, 2442, 2443, 2444, 2445, 2446, 
        2447, 2448, 2449, 2450, 2451, 2452, 2453, 2454, 2455, 2456, 141}, {
        140, 2457, 2458, 2459, 2460, 2461, 2462, 2463, 2464, 2465, 2466, 2467,
         2468, 2469, 2470, 2471, 2472, 139}, {140, 2473, 2474, 2475, 2476, 
        2477, 2478, 2479, 2480, 2481, 2482, 2483, 2484, 2485, 2486, 2487, 
        2488, 2489, 2490, 2491, 2492, 2493, 2494, 2495, 140}, {140, 2496, 
        2497, 2498, 2499, 2500, 2501, 2502, 2503, 2504, 2505, 2506, 2507, 
        2508, 2509, 2510, 2511, 141}, {141, 2512, 2513, 2514, 2515, 2516, 
        2517, 2518, 2519, 2520, 2521, 2522, 2523, 2524, 2525, 2526, 2527, 
        139}, {141, 2528, 2529, 2530, 2531, 2532, 2533, 2534, 2535, 2536, 
        2537, 2538, 2539, 2540, 2541, 2542, 2543, 140}, {141, 2544, 2545, 
        2546, 2547, 2548, 2549, 2550, 2551, 2552, 2553, 2554, 2555, 2556, 
        2557, 2558, 2559, 2560, 2561, 2562, 2563, 2564, 2565, 2566, 141}, {
        142, 2567, 2568, 2569, 2570, 2571, 2572, 2573, 2574, 2575, 2576, 2577,
         2578, 2579, 2580, 2581, 2582, 2583, 2584, 2585, 2586, 2587, 2588, 
        2589, 142}, {142, 2590, 2591, 2592, 2593, 2594, 2595, 2596, 2597, 
        2598, 2599, 2600, 2601, 2602, 2603, 2604, 2605, 143}, {143, 181}, {
        143, 182}, {143, 74}, {143, 2606, 2607, 2608, 2609, 2610, 2611, 2612, 
        2613, 2614, 2615, 2616, 2617, 2618, 2619, 2620, 2621, 142}, {143, 
        2622, 2623, 2624, 2625, 2626, 2627, 2628, 2629, 2630, 2631, 2632, 
        2633, 2634, 2635, 2636, 2637, 2638, 2639, 2640, 2641, 2642, 2643, 
        2644, 143}, {143, 183}, {143, 184}, {143, 185}, {143, 186}, {143, 
        187}, {143, 188}, {143, 189}, {143, 190}, {143, 191}, {143, 192}, {
        144, 88}, {144, 145}, {144, 96}, {144, 146}, {144, 147}, {144, 148}, {
        144, 149}, {148, 309}, {148, 349}, {148, 350}, {148, 51}, {150, 52}, {
        150, 53}, {150, 54}, {150, 55}, {150, 56}, {151, 152}, {151, 153}, {
        151, 154}, {151, 155}, {151, 156}, {157, 2645, 2646, 2647, 2648, 2649,
         2650, 2651, 2652, 2653, 2654, 2655, 2656, 2657, 2658, 2659, 2660, 
        2661, 2662, 2663, 2664, 2665, 2666, 2667, 157}, {157, 2668, 2669, 
        2670, 2671, 2672, 2673, 2674, 2675, 2676, 2677, 2678, 2679, 2680, 
        2681, 2682, 2683, 158}, {157, 159}, {158, 2684, 2685, 2686, 2687, 
        2688, 2689, 2690, 2691, 2692, 2693, 2694, 2695, 2696, 2697, 2698, 
        2699, 157}, {158, 2700, 2701, 2702, 2703, 2704, 2705, 2706, 2707, 
        2708, 2709, 2710, 2711, 2712, 2713, 2714, 2715, 2716, 2717, 2718, 
        2719, 2720, 2721, 2722, 158}, {158, 159}, {160, 2723, 2724, 2725, 
        2726, 2727, 2728, 2729, 2730, 2731, 2732, 2733, 2734, 2735, 2736, 
        2737, 2738, 2739, 2740, 2741, 2742, 2743, 2744, 2745, 160}, {160, 
        2746, 2747, 2748, 2749, 2750, 2751, 2752, 2753, 2754, 2755, 2756, 
        2757, 2758, 2759, 2760, 2761, 161}, {160, 2762, 2763, 2764, 2765, 
        2766, 2767, 2768, 2769, 2770, 2771, 2772, 2773, 2774, 2775, 2776, 
        2777, 162}, {161, 2778, 2779, 2780, 2781, 2782, 2783, 2784, 2785, 
        2786, 2787, 2788, 2789, 2790, 2791, 2792, 2793, 160}, {161, 2794, 
        2795, 2796, 2797, 2798, 2799, 2800, 2801, 2802, 2803, 2804, 2805, 
        2806, 2807, 2808, 2809, 2810, 2811, 2812, 2813, 2814, 2815, 2816, 
        161}, {161, 2817, 2818, 2819, 2820, 2821, 2822, 2823, 2824, 2825, 
        2826, 2827, 2828, 2829, 2830, 2831, 2832, 162}, {162, 2833, 2834, 
        2835, 2836, 2837, 2838, 2839, 2840, 2841, 2842, 2843, 2844, 2845, 
        2846, 2847, 2848, 160}, {162, 2849, 2850, 2851, 2852, 2853, 2854, 
        2855, 2856, 2857, 2858, 2859, 2860, 2861, 2862, 2863, 2864, 161}, {
        162, 2865, 2866, 2867, 2868, 2869, 2870, 2871, 2872, 2873, 2874, 2875,
         2876, 2877, 2878, 2879, 2880, 2881, 2882, 2883, 2884, 2885, 2886, 
        2887, 162}, {163, 2888, 2889, 2890, 2891, 2892, 2893, 2894, 2895, 
        2896, 2897, 2898, 2899, 2900, 2901, 2902, 2903, 2904, 2905, 2906, 
        2907, 2908, 2909, 2910, 163}, {164, 126}, {164, 127}, {164, 128}, {
        165, 126}, {165, 127}, {165, 128}, {166, 15}, {166, 16}, {166, 2911, 
        2912, 2913, 2914, 2915, 2916, 2917, 2918, 2919, 2920, 2921, 2922, 
        2923, 2924, 2925, 2926, 2927, 2928, 2929, 2930, 2931, 2932, 2933, 
        166}, {167, 127}, {167, 168}, {167, 169}, {169, 127}, {169, 168}, {
        169, 2934, 2935, 2936, 2937, 2938, 2939, 2940, 2941, 2942, 2943, 2944,
         2945, 2946, 2947, 2948, 2949, 2950, 2951, 2952, 2953, 2954, 2955, 
        2956, 169}, {170, 171}, {172, 173}, {172, 2957, 2958, 2959, 2960, 
        2961, 2962, 2963, 2964, 2965, 2966, 2967, 2968, 2969, 2970, 2971, 
        2972, 2973, 2974, 2975, 2976, 2977, 2978, 2979, 172}, {172, 174}, {
        172, 175}, {176, 2980, 2981, 2982, 2983, 2984, 2985, 2986, 2987, 2988,
         2989, 2990, 2991, 2992, 2993, 2994, 2995, 2996, 2997, 2998, 2999, 
        3000, 3001, 3002, 176}, {176, 3003, 3004, 3005, 3006, 3007, 3008, 
        3009, 3010, 3011, 3012, 3013, 3014, 3015, 3016, 3017, 3018, 177}, {
        177, 3019, 3020, 3021, 3022, 3023, 3024, 3025, 3026, 3027, 3028, 3029,
         3030, 3031, 3032, 3033, 3034, 176}, {177, 3035, 3036, 3037, 3038, 
        3039, 3040, 3041, 3042, 3043, 3044, 3045, 3046, 3047, 3048, 3049, 
        3050, 3051, 3052, 3053, 3054, 3055, 3056, 3057, 177}, {178, 179}, {
        178, 166}, {180, 3058, 3059, 3060, 3061, 3062, 3063, 3064, 3065, 3066,
         3067, 3068, 3069, 3070, 3071, 3072, 3073, 3074, 3075, 3076, 3077, 
        3078, 3079, 3080, 180}, {193, 171}, {194, 171}, {195, 62}, {195, 
        63}, {196, 179}, {196, 166}, {197, 198}, {197, 199}, {198, 3081, 3082,
         3083, 3084, 3085, 3086, 3087, 3088, 3089, 3090, 3091, 3092, 3093, 
        3094, 3095, 3096, 3097, 3098, 3099, 3100, 3101, 3102, 3103, 198}, {
        198, 3104, 3105, 3106, 3107, 3108, 3109, 3110, 3111, 3112, 3113, 3114,
         3115, 3116, 3117, 3118, 3119, 199}, {199, 3120, 3121, 3122, 3123, 
        3124, 3125, 3126, 3127, 3128, 3129, 3130, 3131, 3132, 3133, 3134, 
        3135, 198}, {199, 3136, 3137, 3138, 3139, 3140, 3141, 3142, 3143, 
        3144, 3145, 3146, 3147, 3148, 3149, 3150, 3151, 3152, 3153, 3154, 
        3155, 3156, 3157, 3158, 199}, {200, 3159, 3160, 3161, 3162, 3163, 
        3164, 3165, 3166, 3167, 3168, 3169, 3170, 3171, 3172, 3173, 3174, 
        3175, 3176, 3177, 3178, 3179, 3180, 3181, 200}, {201, 3182, 3183, 
        3184, 3185, 3186, 3187, 3188, 3189, 3190, 3191, 3192, 3193, 3194, 
        3195, 3196, 3197, 3198, 3199, 3200, 3201, 3202, 3203, 3204, 201}, {
        202, 3205, 3206, 3207, 3208, 3209, 3210, 3211, 3212, 3213, 3214, 3215,
         3216, 3217, 3218, 3219, 3220, 3221, 3222, 3223, 3224, 3225, 3226, 
        3227, 202}, {203, 204}, {203, 101}, {203, 3228, 3229, 3230, 3231, 
        3232, 3233, 3234, 3235, 3236, 3237, 3238, 3239, 3240, 3241, 3242, 
        3243, 3244, 3245, 3246, 3247, 3248, 3249, 3250, 203}, {205, 3251, 
        3252, 3253, 3254, 3255, 3256, 3257, 3258, 3259, 3260, 3261, 3262, 
        3263, 3264, 3265, 3266, 3267, 3268, 3269, 3270, 3271, 3272, 3273, 
        205}, {205, 3274, 3275, 3276, 3277, 3278, 3279, 3280, 3281, 3282, 
        3283, 3284, 3285, 3286, 3287, 3288, 3289, 206}, {206, 3290, 3291, 
        3292, 3293, 3294, 3295, 3296, 3297, 3298, 3299, 3300, 3301, 3302, 
        3303, 3304, 3305, 205}, {206, 3306, 3307, 3308, 3309, 3310, 3311, 
        3312, 3313, 3314, 3315, 3316, 3317, 3318, 3319, 3320, 3321, 3322, 
        3323, 3324, 3325, 3326, 3327, 3328, 206}, {207, 3329, 3330, 3331, 
        3332, 3333, 3334, 3335, 3336, 3337, 3338, 3339, 3340, 3341, 3342, 
        3343, 3344, 3345, 3346, 3347, 3348, 3349, 3350, 3351, 207}, {207, 
        3352, 3353, 3354, 3355, 3356, 3357, 3358, 3359, 3360, 3361, 3362, 
        3363, 3364, 3365, 3366, 3367, 208}, {207, 3368, 3369, 3370, 3371, 
        3372, 3373, 3374, 3375, 3376, 3377, 3378, 3379, 3380, 3381, 3382, 
        3383, 209}, {207, 210}, {208, 3384, 3385, 3386, 3387, 3388, 3389, 
        3390, 3391, 3392, 3393, 3394, 3395, 3396, 3397, 3398, 3399, 207}, {
        208, 3400, 3401, 3402, 3403, 3404, 3405, 3406, 3407, 3408, 3409, 3410,
         3411, 3412, 3413, 3414, 3415, 3416, 3417, 3418, 3419, 3420, 3421, 
        3422, 208}, {208, 3423, 3424, 3425, 3426, 3427, 3428, 3429, 3430, 
        3431, 3432, 3433, 3434, 3435, 3436, 3437, 3438, 209}, {208, 210}, {
        209, 3439, 3440, 3441, 3442, 3443, 3444, 3445, 3446, 3447, 3448, 3449,
         3450, 3451, 3452, 3453, 3454, 207}, {209, 3455, 3456, 3457, 3458, 
        3459, 3460, 3461, 3462, 3463, 3464, 3465, 3466, 3467, 3468, 3469, 
        3470, 208}, {209, 3471, 3472, 3473, 3474, 3475, 3476, 3477, 3478, 
        3479, 3480, 3481, 3482, 3483, 3484, 3485, 3486, 3487, 3488, 3489, 
        3490, 3491, 3492, 3493, 209}, {209, 210}, {211, 207}, {211, 208}, {
        211, 209}, {211, 210}, {212, 104}, {212, 105}, {212, 106}, {212, 
        107}, {213, 3494, 3495, 3496, 3497, 3498, 3499, 3500, 3501, 3502, 
        3503, 3504, 3505, 3506, 3507, 3508, 3509, 3510, 3511, 3512, 3513, 
        3514, 3515, 3516, 213}, {214, 171}, {215, 3517, 3518, 3519, 3520, 
        3521, 3522, 3523, 3524, 3525, 3526, 3527, 3528, 3529, 3530, 3531, 
        3532, 3533, 3534, 3535, 3536, 3537, 3538, 3539, 215}, {215, 216}, {
        215, 217}, {218, 219}, {220, 3540, 3541, 3542, 3543, 3544, 3545, 3546,
         3547, 3548, 3549, 3550, 3551, 3552, 3553, 3554, 3555, 3556, 3557, 
        3558, 3559, 3560, 3561, 3562, 220}, {221, 3563, 3564, 3565, 3566, 
        3567, 3568, 3569, 3570, 3571, 3572, 3573, 3574, 3575, 3576, 3577, 
        3578, 3579, 3580, 3581, 3582, 3583, 3584, 3585, 221}, {221, 222}, {
        222, 3586, 3587, 3588, 3589, 3590, 3591, 3592, 3593, 3594, 3595, 3596,
         3597, 3598, 3599, 3600, 3601, 3602, 3603, 3604, 3605, 3606, 3607, 
        3608, 222}, {223, 126}, {223, 127}, {223, 128}, {224, 179}, {224, 
        166}, {225, 3609, 3610, 3611, 3612, 3613, 3614, 3615, 3616, 3617, 
        3618, 3619, 3620, 3621, 3622, 3623, 3624, 3625, 3626, 3627, 3628, 
        3629, 3630, 3631, 225}, {225, 3632, 3633, 3634, 3635, 3636, 3637, 
        3638, 3639, 3640, 3641, 3642, 3643, 3644, 3645, 3646, 3647, 226}, {
        225, 227}, {226, 3648, 3649, 3650, 3651, 3652, 3653, 3654, 3655, 3656,
         3657, 3658, 3659, 3660, 3661, 3662, 3663, 225}, {226, 3664, 3665, 
        3666, 3667, 3668, 3669, 3670, 3671, 3672, 3673, 3674, 3675, 3676, 
        3677, 3678, 3679, 3680, 3681, 3682, 3683, 3684, 3685, 3686, 226}, {
        226, 227}, {228, 88}, {228, 91}, {228, 92}, {229, 230}, {229, 231}, {
        229, 3687, 3688, 3689, 3690, 3691, 3692, 3693, 3694, 3695, 3696, 3697,
         3698, 3699, 3700, 3701, 3702, 3703, 3704, 3705, 3706, 3707, 3708, 
        3709, 229}, {229, 232}, {233, 88}, {233, 91}, {233, 92}, {234, 3710, 
        3711, 3712, 3713, 3714, 3715, 3716, 3717, 3718, 3719, 3720, 3721, 
        3722, 3723, 3724, 3725, 3726, 3727, 3728, 3729, 3730, 3731, 3732, 
        234}, {234, 3733, 3734, 3735, 3736, 3737, 3738, 3739, 3740, 3741, 
        3742, 3743, 3744, 3745, 3746, 3747, 3748, 235}, {235, 3749, 3750, 
        3751, 3752, 3753, 3754, 3755, 3756, 3757, 3758, 3759, 3760, 3761, 
        3762, 3763, 3764, 234}, {235, 3765, 3766, 3767, 3768, 3769, 3770, 
        3771, 3772, 3773, 3774, 3775, 3776, 3777, 3778, 3779, 3780, 3781, 
        3782, 3783, 3784, 3785, 3786, 3787, 235}, {236, 126}, {236, 127}, {
        236, 128}, {237, 166}, {238, 239}, {240, 126}, {240, 127}, {240, 
        128}, {241, 126}, {241, 127}, {241, 128}, {242, 243}, {242, 244}, {
        242, 245}, {243, 3788, 3789, 3790, 3791, 3792, 3793, 3794, 3795, 3796,
         3797, 3798, 3799, 3800, 3801, 3802, 3803, 3804, 3805, 3806, 3807, 
        3808, 3809, 3810, 243}, {243, 3811, 3812, 3813, 3814, 3815, 3816, 
        3817, 3818, 3819, 3820, 3821, 3822, 3823, 3824, 3825, 3826, 244}, {
        243, 3827, 3828, 3829, 3830, 3831, 3832, 3833, 3834, 3835, 3836, 3837,
         3838, 3839, 3840, 3841, 3842, 245}, {244, 3843, 3844, 3845, 3846, 
        3847, 3848, 3849, 3850, 3851, 3852, 3853, 3854, 3855, 3856, 3857, 
        3858, 243}, {244, 3859, 3860, 3861, 3862, 3863, 3864, 3865, 3866, 
        3867, 3868, 3869, 3870, 3871, 3872, 3873, 3874, 3875, 3876, 3877, 
        3878, 3879, 3880, 3881, 244}, {244, 3882, 3883, 3884, 3885, 3886, 
        3887, 3888, 3889, 3890, 3891, 3892, 3893, 3894, 3895, 3896, 3897, 
        245}, {245, 3898, 3899, 3900, 3901, 3902, 3903, 3904, 3905, 3906, 
        3907, 3908, 3909, 3910, 3911, 3912, 3913, 243}, {245, 3914, 3915, 
        3916, 3917, 3918, 3919, 3920, 3921, 3922, 3923, 3924, 3925, 3926, 
        3927, 3928, 3929, 244}, {245, 3930, 3931, 3932, 3933, 3934, 3935, 
        3936, 3937, 3938, 3939, 3940, 3941, 3942, 3943, 3944, 3945, 3946, 
        3947, 3948, 3949, 3950, 3951, 3952, 245}, {246, 88}, {246, 91}, {246, 
        92}, {247, 248}, {247, 249}, {247, 250}, {247, 251}, {249, 4}, {249, 
        5}, {249, 254}, {249, 6}, {249, 7}, {249, 8}, {249, 402}, {249, 
        166}, {249, 9}, {249, 10}, {249, 11}, {249, 625}, {249, 12}, {249, 
        403}, {249, 3953, 3954, 3955, 3956, 3957, 3958, 3959, 3960, 3961, 
        3962, 3963, 3964, 3965, 3966, 3967, 3968, 3969, 3970, 3971, 3972, 
        3973, 3974, 3975, 249}, {252, 253}, {252, 254}, {253, 3976, 3977, 
        3978, 3979, 3980, 3981, 3982, 3983, 3984, 3985, 3986, 3987, 3988, 
        3989, 3990, 3991, 3992, 3993, 3994, 3995, 3996, 3997, 3998, 253}, {
        253, 254}, {255, 256}, {255, 257}, {258, 259}, {258, 260}, {258, 
        261}, {258, 262}, {263, 104}, {263, 105}, {263, 106}, {263, 107}, {
        264, 248}, {264, 249}, {264, 250}, {264, 251}, {265, 3999, 4000, 4001,
         4002, 4003, 4004, 4005, 4006, 4007, 4008, 4009, 4010, 4011, 4012, 
        4013, 4014, 4015, 4016, 4017, 4018, 4019, 4020, 4021, 265}, {265, 
        4022, 4023, 4024, 4025, 4026, 4027, 4028, 4029, 4030, 4031, 4032, 
        4033, 4034, 4035, 4036, 4037, 266}, {266, 4038, 4039, 4040, 4041, 
        4042, 4043, 4044, 4045, 4046, 4047, 4048, 4049, 4050, 4051, 4052, 
        4053, 265}, {266, 4054, 4055, 4056, 4057, 4058, 4059, 4060, 4061, 
        4062, 4063, 4064, 4065, 4066, 4067, 4068, 4069, 4070, 4071, 4072, 
        4073, 4074, 4075, 4076, 266}, {267, 4}, {267, 5}, {267, 6}, {267, 
        7}, {267, 8}, {267, 9}, {267, 10}, {267, 11}, {267, 12}, {268, 4}, {
        268, 5}, {268, 6}, {268, 7}, {268, 8}, {268, 9}, {268, 10}, {268, 
        11}, {268, 12}, {269, 270}, {269, 271}, {270, 352}, {272, 117}, {272, 
        118}, {272, 119}, {272, 121}, {272, 122}, {272, 123}, {272, 124}, {
        273, 274}, {274, 4077, 4078, 4079, 4080, 4081, 4082, 4083, 4084, 4085,
         4086, 4087, 4088, 4089, 4090, 4091, 4092, 4093, 4094, 4095, 4096, 
        4097, 4098, 4099, 274}, {275, 4100, 4101, 4102, 4103, 4104, 4105, 
        4106, 4107, 4108, 4109, 4110, 4111, 4112, 4113, 4114, 4115, 4116, 
        4117, 4118, 4119, 4120, 4121, 4122, 275}, {276, 2}, {277, 49}, {277, 
        50}, {277, 51}, {278, 225}, {278, 4123, 4124, 4125, 4126, 4127, 4128, 
        4129, 4130, 4131, 4132, 4133, 4134, 4135, 4136, 4137, 4138, 4139, 
        4140, 4141, 4142, 4143, 4144, 4145, 278}, {279, 4146, 4147, 4148, 
        4149, 4150, 4151, 4152, 4153, 4154, 4155, 4156, 4157, 4158, 4159, 
        4160, 4161, 4162, 4163, 4164, 4165, 4166, 4167, 4168, 279}, {280, 
        281}, {282, 283}, {282, 4169, 4170, 4171, 4172, 4173, 4174, 4175, 
        4176, 4177, 4178, 4179, 4180, 4181, 4182, 4183, 4184, 4185, 4186, 
        4187, 4188, 4189, 4190, 4191, 282}, {282, 284}, {282, 285}, {282, 
        4192, 4193, 4194, 4195, 4196, 4197, 4198, 4199, 4200, 4201, 4202, 
        4203, 4204, 4205, 4206, 4207, 286}, {285, 594}, {285, 4208, 4209, 
        4210, 4211, 4212, 4213, 4214, 4215, 4216, 4217, 4218, 4219, 4220, 
        4221, 4222, 4223, 4224, 4225, 4226, 4227, 4228, 4229, 4230, 285}, {
        286, 283}, {286, 4231, 4232, 4233, 4234, 4235, 4236, 4237, 4238, 4239,
         4240, 4241, 4242, 4243, 4244, 4245, 4246, 282}, {286, 284}, {286, 
        285}, {286, 4247, 4248, 4249, 4250, 4251, 4252, 4253, 4254, 4255, 
        4256, 4257, 4258, 4259, 4260, 4261, 4262, 4263, 4264, 4265, 4266, 
        4267, 4268, 4269, 286}, {287, 288}, {289, 2}, {290, 166}, {291, 4270, 
        4271, 4272, 4273, 4274, 4275, 4276, 4277, 4278, 4279, 4280, 4281, 
        4282, 4283, 4284, 4285, 4286, 4287, 4288, 4289, 4290, 4291, 4292, 
        291}, {291, 4293, 4294, 4295, 4296, 4297, 4298, 4299, 4300, 4301, 
        4302, 4303, 4304, 4305, 4306, 4307, 4308, 292}, {292, 4309, 4310, 
        4311, 4312, 4313, 4314, 4315, 4316, 4317, 4318, 4319, 4320, 4321, 
        4322, 4323, 4324, 291}, {292, 4325, 4326, 4327, 4328, 4329, 4330, 
        4331, 4332, 4333, 4334, 4335, 4336, 4337, 4338, 4339, 4340, 4341, 
        4342, 4343, 4344, 4345, 4346, 4347, 292}, {293, 4348, 4349, 4350, 
        4351, 4352, 4353, 4354, 4355, 4356, 4357, 4358, 4359, 4360, 4361, 
        4362, 4363, 4364, 4365, 4366, 4367, 4368, 4369, 4370, 293}, {293, 
        4371, 4372, 4373, 4374, 4375, 4376, 4377, 4378, 4379, 4380, 4381, 
        4382, 4383, 4384, 4385, 4386, 294}, {294, 4387, 4388, 4389, 4390, 
        4391, 4392, 4393, 4394, 4395, 4396, 4397, 4398, 4399, 4400, 4401, 
        4402, 293}, {294, 4403, 4404, 4405, 4406, 4407, 4408, 4409, 4410, 
        4411, 4412, 4413, 4414, 4415, 4416, 4417, 4418, 4419, 4420, 4421, 
        4422, 4423, 4424, 4425, 294}, {295, 88}, {295, 91}, {295, 92}, {296, 
        297}, {296, 298}, {296, 299}, {296, 300}, {296, 301}, {297, 4426, 
        4427, 4428, 4429, 4430, 4431, 4432, 4433, 4434, 4435, 4436, 4437, 
        4438, 4439, 4440, 4441, 4442, 4443, 4444, 4445, 4446, 4447, 4448, 
        297}, {297, 4449, 4450, 4451, 4452, 4453, 4454, 4455, 4456, 4457, 
        4458, 4459, 4460, 4461, 4462, 4463, 4464, 298}, {297, 299}, {297, 
        4465, 4466, 4467, 4468, 4469, 4470, 4471, 4472, 4473, 4474, 4475, 
        4476, 4477, 4478, 4479, 4480, 300}, {297, 4481, 4482, 4483, 4484, 
        4485, 4486, 4487, 4488, 4489, 4490, 4491, 4492, 4493, 4494, 4495, 
        4496, 301}, {298, 4497, 4498, 4499, 4500, 4501, 4502, 4503, 4504, 
        4505, 4506, 4507, 4508, 4509, 4510, 4511, 4512, 297}, {298, 4513, 
        4514, 4515, 4516, 4517, 4518, 4519, 4520, 4521, 4522, 4523, 4524, 
        4525, 4526, 4527, 4528, 4529, 4530, 4531, 4532, 4533, 4534, 4535, 
        298}, {298, 299}, {298, 4536, 4537, 4538, 4539, 4540, 4541, 4542, 
        4543, 4544, 4545, 4546, 4547, 4548, 4549, 4550, 4551, 300}, {298, 
        4552, 4553, 4554, 4555, 4556, 4557, 4558, 4559, 4560, 4561, 4562, 
        4563, 4564, 4565, 4566, 4567, 301}, {299, 489}, {299, 419}, {299, 
        4568, 4569, 4570, 4571, 4572, 4573, 4574, 4575, 4576, 4577, 4578, 
        4579, 4580, 4581, 4582, 4583, 4584, 4585, 4586, 4587, 4588, 4589, 
        4590, 299}, {300, 4591, 4592, 4593, 4594, 4595, 4596, 4597, 4598, 
        4599, 4600, 4601, 4602, 4603, 4604, 4605, 4606, 297}, {300, 4607, 
        4608, 4609, 4610, 4611, 4612, 4613, 4614, 4615, 4616, 4617, 4618, 
        4619, 4620, 4621, 4622, 298}, {300, 299}, {300, 4623, 4624, 4625, 
        4626, 4627, 4628, 4629, 4630, 4631, 4632, 4633, 4634, 4635, 4636, 
        4637, 4638, 4639, 4640, 4641, 4642, 4643, 4644, 4645, 300}, {300, 
        4646, 4647, 4648, 4649, 4650, 4651, 4652, 4653, 4654, 4655, 4656, 
        4657, 4658, 4659, 4660, 4661, 301}, {301, 4662, 4663, 4664, 4665, 
        4666, 4667, 4668, 4669, 4670, 4671, 4672, 4673, 4674, 4675, 4676, 
        4677, 297}, {301, 4678, 4679, 4680, 4681, 4682, 4683, 4684, 4685, 
        4686, 4687, 4688, 4689, 4690, 4691, 4692, 4693, 298}, {301, 299}, {
        301, 4694, 4695, 4696, 4697, 4698, 4699, 4700, 4701, 4702, 4703, 4704,
         4705, 4706, 4707, 4708, 4709, 300}, {301, 4710, 4711, 4712, 4713, 
        4714, 4715, 4716, 4717, 4718, 4719, 4720, 4721, 4722, 4723, 4724, 
        4725, 4726, 4727, 4728, 4729, 4730, 4731, 4732, 301}, {302, 297}, {
        302, 298}, {302, 299}, {302, 300}, {302, 301}, {303, 171}, {304, 4733,
         4734, 4735, 4736, 4737, 4738, 4739, 4740, 4741, 4742, 4743, 4744, 
        4745, 4746, 4747, 4748, 4749, 4750, 4751, 4752, 4753, 4754, 4755, 
        304}, {304, 305}, {304, 4756, 4757, 4758, 4759, 4760, 4761, 4762, 
        4763, 4764, 4765, 4766, 4767, 4768, 4769, 4770, 4771, 306}, {306, 
        4772, 4773, 4774, 4775, 4776, 4777, 4778, 4779, 4780, 4781, 4782, 
        4783, 4784, 4785, 4786, 4787, 304}, {306, 305}, {306, 4788, 4789, 
        4790, 4791, 4792, 4793, 4794, 4795, 4796, 4797, 4798, 4799, 4800, 
        4801, 4802, 4803, 4804, 4805, 4806, 4807, 4808, 4809, 4810, 306}, {
        307, 4811, 4812, 4813, 4814, 4815, 4816, 4817, 4818, 4819, 4820, 4821,
         4822, 4823, 4824, 4825, 4826, 4827, 4828, 4829, 4830, 4831, 4832, 
        4833, 307}, {308, 309}, {310, 104}, {310, 105}, {310, 106}, {310, 
        107}, {311, 4834, 4835, 4836, 4837, 4838, 4839, 4840, 4841, 4842, 
        4843, 4844, 4845, 4846, 4847, 4848, 4849, 4850, 4851, 4852, 4853, 
        4854, 4855, 4856, 311}, {311, 312}, {311, 313}, {311, 4857, 4858, 
        4859, 4860, 4861, 4862, 4863, 4864, 4865, 4866, 4867, 4868, 4869, 
        4870, 4871, 4872, 314}, {314, 527}, {314, 293}, {314, 4873, 4874, 
        4875, 4876, 4877, 4878, 4879, 4880, 4881, 4882, 4883, 4884, 4885, 
        4886, 4887, 4888, 311}, {314, 312}, {314, 313}, {314, 4889, 4890, 
        4891, 4892, 4893, 4894, 4895, 4896, 4897, 4898, 4899, 4900, 4901, 
        4902, 4903, 4904, 4905, 4906, 4907, 4908, 4909, 4910, 4911, 314}, {
        314, 294}, {315, 4912, 4913, 4914, 4915, 4916, 4917, 4918, 4919, 4920,
         4921, 4922, 4923, 4924, 4925, 4926, 4927, 4928, 4929, 4930, 4931, 
        4932, 4933, 4934, 315}, {315, 4935, 4936, 4937, 4938, 4939, 4940, 
        4941, 4942, 4943, 4944, 4945, 4946, 4947, 4948, 4949, 4950, 316}, {
        316, 4951, 4952, 4953, 4954, 4955, 4956, 4957, 4958, 4959, 4960, 4961,
         4962, 4963, 4964, 4965, 4966, 315}, {316, 4967, 4968, 4969, 4970, 
        4971, 4972, 4973, 4974, 4975, 4976, 4977, 4978, 4979, 4980, 4981, 
        4982, 4983, 4984, 4985, 4986, 4987, 4988, 4989, 316}, {317, 307}, {
        318, 319}, {318, 320}, {318, 321}, {322, 319}, {322, 320}, {322, 
        321}, {323, 324}, {323, 308}, {323, 4990, 4991, 4992, 4993, 4994, 
        4995, 4996, 4997, 4998, 4999, 5000, 5001, 5002, 5003, 5004, 5005, 
        5006, 5007, 5008, 5009, 5010, 5011, 5012, 323}, {323, 325}, {326, 
        324}, {326, 308}, {326, 323}, {326, 325}, {327, 5013, 5014, 5015, 
        5016, 5017, 5018, 5019, 5020, 5021, 5022, 5023, 5024, 5025, 5026, 
        5027, 5028, 5029, 5030, 5031, 5032, 5033, 5034, 5035, 327}, {328, 
        329}, {328, 330}, {328, 331}, {328, 332}, {333, 5036, 5037, 5038, 
        5039, 5040, 5041, 5042, 5043, 5044, 5045, 5046, 5047, 5048, 5049, 
        5050, 5051, 5052, 5053, 5054, 5055, 5056, 5057, 5058, 333}, {333, 
        5059, 5060, 5061, 5062, 5063, 5064, 5065, 5066, 5067, 5068, 5069, 
        5070, 5071, 5072, 5073, 5074, 334}, {333, 5075, 5076, 5077, 5078, 
        5079, 5080, 5081, 5082, 5083, 5084, 5085, 5086, 5087, 5088, 5089, 
        5090, 335}, {334, 5091, 5092, 5093, 5094, 5095, 5096, 5097, 5098, 
        5099, 5100, 5101, 5102, 5103, 5104, 5105, 5106, 333}, {334, 5107, 
        5108, 5109, 5110, 5111, 5112, 5113, 5114, 5115, 5116, 5117, 5118, 
        5119, 5120, 5121, 5122, 5123, 5124, 5125, 5126, 5127, 5128, 5129, 
        334}, {334, 5130, 5131, 5132, 5133, 5134, 5135, 5136, 5137, 5138, 
        5139, 5140, 5141, 5142, 5143, 5144, 5145, 335}, {335, 5146, 5147, 
        5148, 5149, 5150, 5151, 5152, 5153, 5154, 5155, 5156, 5157, 5158, 
        5159, 5160, 5161, 333}, {335, 5162, 5163, 5164, 5165, 5166, 5167, 
        5168, 5169, 5170, 5171, 5172, 5173, 5174, 5175, 5176, 5177, 334}, {
        335, 5178, 5179, 5180, 5181, 5182, 5183, 5184, 5185, 5186, 5187, 5188,
         5189, 5190, 5191, 5192, 5193, 5194, 5195, 5196, 5197, 5198, 5199, 
        5200, 335}, {336, 5201, 5202, 5203, 5204, 5205, 5206, 5207, 5208, 
        5209, 5210, 5211, 5212, 5213, 5214, 5215, 5216, 5217, 5218, 5219, 
        5220, 5221, 5222, 5223, 336}, {337, 179}, {337, 166}, {338, 61}, {339,
         5224, 5225, 5226, 5227, 5228, 5229, 5230, 5231, 5232, 5233, 5234, 
        5235, 5236, 5237, 5238, 5239, 5240, 5241, 5242, 5243, 5244, 5245, 
        5246, 339}, {340, 5247, 5248, 5249, 5250, 5251, 5252, 5253, 5254, 
        5255, 5256, 5257, 5258, 5259, 5260, 5261, 5262, 5263, 5264, 5265, 
        5266, 5267, 5268, 5269, 340}, {341, 25}, {341, 26}, {342, 25}, {342, 
        26}, {343, 5270, 5271, 5272, 5273, 5274, 5275, 5276, 5277, 5278, 5279,
         5280, 5281, 5282, 5283, 5284, 5285, 5286, 5287, 5288, 5289, 5290, 
        5291, 5292, 343}, {344, 171}, {345, 104}, {345, 105}, {345, 106}, {
        345, 107}, {346, 171}, {347, 52}, {347, 53}, {347, 54}, {347, 55}, {
        347, 56}, {348, 117}, {348, 118}, {348, 119}, {348, 121}, {348, 
        122}, {348, 123}, {348, 124}, {351, 88}, {351, 91}, {351, 92}, {352, 
        5293, 5294, 5295, 5296, 5297, 5298, 5299, 5300, 5301, 5302, 5303, 
        5304, 5305, 5306, 5307, 5308, 5309, 5310, 5311, 5312, 5313, 5314, 
        5315, 352}, {353, 5316, 5317, 5318, 5319, 5320, 5321, 5322, 5323, 
        5324, 5325, 5326, 5327, 5328, 5329, 5330, 5331, 5332, 5333, 5334, 
        5335, 5336, 5337, 5338, 353}, {354, 5339, 5340, 5341, 5342, 5343, 
        5344, 5345, 5346, 5347, 5348, 5349, 5350, 5351, 5352, 5353, 5354, 
        5355, 5356, 5357, 5358, 5359, 5360, 5361, 354}, {354, 5362, 5363, 
        5364, 5365, 5366, 5367, 5368, 5369, 5370, 5371, 5372, 5373, 5374, 
        5375, 5376, 5377, 355}, {355, 5378, 5379, 5380, 5381, 5382, 5383, 
        5384, 5385, 5386, 5387, 5388, 5389, 5390, 5391, 5392, 5393, 354}, {
        355, 5394, 5395, 5396, 5397, 5398, 5399, 5400, 5401, 5402, 5403, 5404,
         5405, 5406, 5407, 5408, 5409, 5410, 5411, 5412, 5413, 5414, 5415, 
        5416, 355}, {356, 5417, 5418, 5419, 5420, 5421, 5422, 5423, 5424, 
        5425, 5426, 5427, 5428, 5429, 5430, 5431, 5432, 5433, 5434, 5435, 
        5436, 5437, 5438, 5439, 356}, {356, 5440, 5441, 5442, 5443, 5444, 
        5445, 5446, 5447, 5448, 5449, 5450, 5451, 5452, 5453, 5454, 5455, 
        357}, {357, 5456, 5457, 5458, 5459, 5460, 5461, 5462, 5463, 5464, 
        5465, 5466, 5467, 5468, 5469, 5470, 5471, 356}, {357, 5472, 5473, 
        5474, 5475, 5476, 5477, 5478, 5479, 5480, 5481, 5482, 5483, 5484, 
        5485, 5486, 5487, 5488, 5489, 5490, 5491, 5492, 5493, 5494, 357}, {
        358, 179}, {358, 166}, {359, 5495, 5496, 5497, 5498, 5499, 5500, 5501,
         5502, 5503, 5504, 5505, 5506, 5507, 5508, 5509, 5510, 5511, 5512, 
        5513, 5514, 5515, 5516, 5517, 359}, {360, 359}, {361, 5518, 5519, 
        5520, 5521, 5522, 5523, 5524, 5525, 5526, 5527, 5528, 5529, 5530, 
        5531, 5532, 5533, 5534, 5535, 5536, 5537, 5538, 5539, 5540, 361}, {
        361, 5541, 5542, 5543, 5544, 5545, 5546, 5547, 5548, 5549, 5550, 5551,
         5552, 5553, 5554, 5555, 5556, 362}, {362, 5557, 5558, 5559, 5560, 
        5561, 5562, 5563, 5564, 5565, 5566, 5567, 5568, 5569, 5570, 5571, 
        5572, 361}, {362, 5573, 5574, 5575, 5576, 5577, 5578, 5579, 5580, 
        5581, 5582, 5583, 5584, 5585, 5586, 5587, 5588, 5589, 5590, 5591, 
        5592, 5593, 5594, 5595, 362}, {363, 5596, 5597, 5598, 5599, 5600, 
        5601, 5602, 5603, 5604, 5605, 5606, 5607, 5608, 5609, 5610, 5611, 
        5612, 5613, 5614, 5615, 5616, 5617, 5618, 363}, {363, 5619, 5620, 
        5621, 5622, 5623, 5624, 5625, 5626, 5627, 5628, 5629, 5630, 5631, 
        5632, 5633, 5634, 364}, {363, 365}, {364, 5635, 5636, 5637, 5638, 
        5639, 5640, 5641, 5642, 5643, 5644, 5645, 5646, 5647, 5648, 5649, 
        5650, 363}, {364, 5651, 5652, 5653, 5654, 5655, 5656, 5657, 5658, 
        5659, 5660, 5661, 5662, 5663, 5664, 5665, 5666, 5667, 5668, 5669, 
        5670, 5671, 5672, 5673, 364}, {364, 365}, {366, 198}, {366, 199}, {
        367, 368}, {367, 369}, {367, 5674, 5675, 5676, 5677, 5678, 5679, 5680,
         5681, 5682, 5683, 5684, 5685, 5686, 5687, 5688, 5689, 5690, 5691, 
        5692, 5693, 5694, 5695, 5696, 367}, {367, 370}, {367, 5697, 5698, 
        5699, 5700, 5701, 5702, 5703, 5704, 5705, 5706, 5707, 5708, 5709, 
        5710, 5711, 5712, 371}, {371, 368}, {371, 369}, {371, 5713, 5714, 
        5715, 5716, 5717, 5718, 5719, 5720, 5721, 5722, 5723, 5724, 5725, 
        5726, 5727, 5728, 367}, {371, 370}, {371, 5729, 5730, 5731, 5732, 
        5733, 5734, 5735, 5736, 5737, 5738, 5739, 5740, 5741, 5742, 5743, 
        5744, 5745, 5746, 5747, 5748, 5749, 5750, 5751, 371}, {372, 373}, {
        372, 5752, 5753, 5754, 5755, 5756, 5757, 5758, 5759, 5760, 5761, 5762,
         5763, 5764, 5765, 5766, 5767, 5768, 5769, 5770, 5771, 5772, 5773, 
        5774, 372}, {372, 374}, {372, 48}, {375, 5775, 5776, 5777, 5778, 5779,
         5780, 5781, 5782, 5783, 5784, 5785, 5786, 5787, 5788, 5789, 5790, 
        5791, 5792, 5793, 5794, 5795, 5796, 5797, 375}, {376, 375}, {377, 
        378}, {377, 379}, {380, 378}, {380, 379}, {381, 142}, {381, 143}, {
        382, 383}, {382, 384}, {382, 385}, {382, 5798, 5799, 5800, 5801, 5802,
         5803, 5804, 5805, 5806, 5807, 5808, 5809, 5810, 5811, 5812, 5813, 
        5814, 5815, 5816, 5817, 5818, 5819, 5820, 382}, {382, 5821, 5822, 
        5823, 5824, 5825, 5826, 5827, 5828, 5829, 5830, 5831, 5832, 5833, 
        5834, 5835, 5836, 386}, {382, 387}, {382, 388}, {386, 383}, {386, 
        384}, {386, 385}, {386, 5837, 5838, 5839, 5840, 5841, 5842, 5843, 
        5844, 5845, 5846, 5847, 5848, 5849, 5850, 5851, 5852, 382}, {386, 
        5853, 5854, 5855, 5856, 5857, 5858, 5859, 5860, 5861, 5862, 5863, 
        5864, 5865, 5866, 5867, 5868, 5869, 5870, 5871, 5872, 5873, 5874, 
        5875, 386}, {386, 387}, {386, 388}, {389, 15}, {389, 16}, {390, 
        179}, {390, 166}, {391, 5876, 5877, 5878, 5879, 5880, 5881, 5882, 
        5883, 5884, 5885, 5886, 5887, 5888, 5889, 5890, 5891, 5892, 5893, 
        5894, 5895, 5896, 5897, 5898, 391}, {391, 5899, 5900, 5901, 5902, 
        5903, 5904, 5905, 5906, 5907, 5908, 5909, 5910, 5911, 5912, 5913, 
        5914, 392}, {392, 5915, 5916, 5917, 5918, 5919, 5920, 5921, 5922, 
        5923, 5924, 5925, 5926, 5927, 5928, 5929, 5930, 391}, {392, 5931, 
        5932, 5933, 5934, 5935, 5936, 5937, 5938, 5939, 5940, 5941, 5942, 
        5943, 5944, 5945, 5946, 5947, 5948, 5949, 5950, 5951, 5952, 5953, 
        392}, {393, 179}, {393, 166}, {394, 395}, {394, 396}, {394, 397}, {
        397, 395}, {397, 396}, {397, 5954, 5955, 5956, 5957, 5958, 5959, 5960,
         5961, 5962, 5963, 5964, 5965, 5966, 5967, 5968, 5969, 5970, 5971, 
        5972, 5973, 5974, 5975, 5976, 397}, {398, 270}, {398, 271}, {399, 
        200}, {400, 200}, {401, 254}, {401, 402}, {401, 166}, {401, 403}, {
        403, 254}, {403, 402}, {403, 166}, {403, 5977, 5978, 5979, 5980, 5981,
         5982, 5983, 5984, 5985, 5986, 5987, 5988, 5989, 5990, 5991, 5992, 
        5993, 5994, 5995, 5996, 5997, 5998, 5999, 403}, {404, 157}, {404, 
        158}, {404, 159}, {405, 157}, {405, 158}, {405, 159}, {406, 407}, {
        406, 6000, 6001, 6002, 6003, 6004, 6005, 6006, 6007, 6008, 6009, 6010,
         6011, 6012, 6013, 6014, 6015, 6016, 6017, 6018, 6019, 6020, 6021, 
        6022, 406}, {406, 6023, 6024, 6025, 6026, 6027, 6028, 6029, 6030, 
        6031, 6032, 6033, 6034, 6035, 6036, 6037, 6038, 408}, {406, 409}, {
        408, 407}, {408, 6039, 6040, 6041, 6042, 6043, 6044, 6045, 6046, 6047,
         6048, 6049, 6050, 6051, 6052, 6053, 6054, 406}, {408, 6055, 6056, 
        6057, 6058, 6059, 6060, 6061, 6062, 6063, 6064, 6065, 6066, 6067, 
        6068, 6069, 6070, 6071, 6072, 6073, 6074, 6075, 6076, 6077, 408}, {
        408, 409}, {410, 411}, {410, 412}, {413, 414}, {413, 415}, {413, 
        163}, {413, 416}, {413, 417}, {413, 418}, {413, 419}, {413, 420}, {
        413, 421}, {413, 422}, {413, 423}, {413, 254}, {413, 424}, {413, 
        10}, {413, 425}, {413, 426}, {413, 427}, {413, 428}, {429, 254}, {429,
         430}, {430, 254}, {430, 6078, 6079, 6080, 6081, 6082, 6083, 6084, 
        6085, 6086, 6087, 6088, 6089, 6090, 6091, 6092, 6093, 6094, 6095, 
        6096, 6097, 6098, 6099, 6100, 430}, {431, 84}, {431, 85}, {431, 86}, {
        431, 87}, {432, 433}, {434, 6101, 6102, 6103, 6104, 6105, 6106, 6107, 
        6108, 6109, 6110, 6111, 6112, 6113, 6114, 6115, 6116, 6117, 6118, 
        6119, 6120, 6121, 6122, 6123, 434}, {434, 435}, {435, 502}, {435, 
        6124, 6125, 6126, 6127, 6128, 6129, 6130, 6131, 6132, 6133, 6134, 
        6135, 6136, 6137, 6138, 6139, 6140, 6141, 6142, 6143, 6144, 6145, 
        6146, 435}, {435, 503}, {435, 504}, {436, 62}, {436, 63}, {437, 88}, {
        437, 91}, {437, 92}, {438, 439}, {438, 123}, {439, 6147, 6148, 6149, 
        6150, 6151, 6152, 6153, 6154, 6155, 6156, 6157, 6158, 6159, 6160, 
        6161, 6162, 6163, 6164, 6165, 6166, 6167, 6168, 6169, 439}, {439, 
        123}, {440, 6170, 6171, 6172, 6173, 6174, 6175, 6176, 6177, 6178, 
        6179, 6180, 6181, 6182, 6183, 6184, 6185, 6186, 6187, 6188, 6189, 
        6190, 6191, 6192, 440}, {441, 104}, {441, 105}, {441, 106}, {441, 
        107}, {442, 88}, {442, 91}, {442, 92}, {443, 88}, {443, 91}, {443, 
        92}, {444, 270}, {444, 271}, {445, 142}, {445, 143}, {446, 6193, 6194,
         6195, 6196, 6197, 6198, 6199, 6200, 6201, 6202, 6203, 6204, 6205, 
        6206, 6207, 6208, 6209, 6210, 6211, 6212, 6213, 6214, 6215, 446}, {
        446, 6216, 6217, 6218, 6219, 6220, 6221, 6222, 6223, 6224, 6225, 6226,
         6227, 6228, 6229, 6230, 6231, 447}, {446, 448}, {447, 6232, 6233, 
        6234, 6235, 6236, 6237, 6238, 6239, 6240, 6241, 6242, 6243, 6244, 
        6245, 6246, 6247, 446}, {447, 6248, 6249, 6250, 6251, 6252, 6253, 
        6254, 6255, 6256, 6257, 6258, 6259, 6260, 6261, 6262, 6263, 6264, 
        6265, 6266, 6267, 6268, 6269, 6270, 447}, {447, 448}, {448, 450}, {
        448, 6271, 6272, 6273, 6274, 6275, 6276, 6277, 6278, 6279, 6280, 6281,
         6282, 6283, 6284, 6285, 6286, 449}, {448, 6287, 6288, 6289, 6290, 
        6291, 6292, 6293, 6294, 6295, 6296, 6297, 6298, 6299, 6300, 6301, 
        6302, 6303, 6304, 6305, 6306, 6307, 6308, 6309, 448}, {448, 451}, {
        448, 452}, {448, 6310, 6311, 6312, 6313, 6314, 6315, 6316, 6317, 6318,
         6319, 6320, 6321, 6322, 6323, 6324, 6325, 453}, {449, 450}, {449, 
        6326, 6327, 6328, 6329, 6330, 6331, 6332, 6333, 6334, 6335, 6336, 
        6337, 6338, 6339, 6340, 6341, 6342, 6343, 6344, 6345, 6346, 6347, 
        6348, 449}, {449, 6349, 6350, 6351, 6352, 6353, 6354, 6355, 6356, 
        6357, 6358, 6359, 6360, 6361, 6362, 6363, 6364, 448}, {449, 451}, {
        449, 452}, {449, 6365, 6366, 6367, 6368, 6369, 6370, 6371, 6372, 6373,
         6374, 6375, 6376, 6377, 6378, 6379, 6380, 453}, {453, 450}, {453, 
        6381, 6382, 6383, 6384, 6385, 6386, 6387, 6388, 6389, 6390, 6391, 
        6392, 6393, 6394, 6395, 6396, 449}, {453, 6397, 6398, 6399, 6400, 
        6401, 6402, 6403, 6404, 6405, 6406, 6407, 6408, 6409, 6410, 6411, 
        6412, 448}, {453, 451}, {453, 452}, {453, 6413, 6414, 6415, 6416, 
        6417, 6418, 6419, 6420, 6421, 6422, 6423, 6424, 6425, 6426, 6427, 
        6428, 6429, 6430, 6431, 6432, 6433, 6434, 6435, 453}, {454, 104}, {
        454, 105}, {454, 106}, {454, 107}, {455, 275}, {456, 315}, {456, 
        316}, {457, 221}, {457, 222}, {458, 459}, {458, 460}, {458, 10}, {461,
         450}, {461, 449}, {461, 448}, {461, 451}, {461, 452}, {461, 453}, {
        462, 6436, 6437, 6438, 6439, 6440, 6441, 6442, 6443, 6444, 6445, 6446,
         6447, 6448, 6449, 6450, 6451, 6452, 6453, 6454, 6455, 6456, 6457, 
        6458, 462}, {463, 6459, 6460, 6461, 6462, 6463, 6464, 6465, 6466, 
        6467, 6468, 6469, 6470, 6471, 6472, 6473, 6474, 6475, 6476, 6477, 
        6478, 6479, 6480, 6481, 463}, {464, 6482, 6483, 6484, 6485, 6486, 
        6487, 6488, 6489, 6490, 6491, 6492, 6493, 6494, 6495, 6496, 6497, 
        6498, 6499, 6500, 6501, 6502, 6503, 6504, 464}, {465, 166}, {466, 
        166}, {467, 39}, {468, 6505, 6506, 6507, 6508, 6509, 6510, 6511, 6512,
         6513, 6514, 6515, 6516, 6517, 6518, 6519, 6520, 6521, 6522, 6523, 
        6524, 6525, 6526, 6527, 468}, {469, 166}, {470, 120}, {471, 179}, {
        471, 166}, {472, 179}, {472, 166}, {473, 474}, {475, 474}, {476, 2}, {
        477, 6528, 6529, 6530, 6531, 6532, 6533, 6534, 6535, 6536, 6537, 6538,
         6539, 6540, 6541, 6542, 6543, 6544, 6545, 6546, 6547, 6548, 6549, 
        6550, 477}, {477, 6551, 6552, 6553, 6554, 6555, 6556, 6557, 6558, 
        6559, 6560, 6561, 6562, 6563, 6564, 6565, 6566, 478}, {478, 6567, 
        6568, 6569, 6570, 6571, 6572, 6573, 6574, 6575, 6576, 6577, 6578, 
        6579, 6580, 6581, 6582, 477}, {478, 6583, 6584, 6585, 6586, 6587, 
        6588, 6589, 6590, 6591, 6592, 6593, 6594, 6595, 6596, 6597, 6598, 
        6599, 6600, 6601, 6602, 6603, 6604, 6605, 478}, {479, 6606, 6607, 
        6608, 6609, 6610, 6611, 6612, 6613, 6614, 6615, 6616, 6617, 6618, 
        6619, 6620, 6621, 6622, 6623, 6624, 6625, 6626, 6627, 6628, 479}, {
        479, 480}, {481, 297}, {481, 298}, {481, 299}, {481, 300}, {481, 
        301}, {482, 6629, 6630, 6631, 6632, 6633, 6634, 6635, 6636, 6637, 
        6638, 6639, 6640, 6641, 6642, 6643, 6644, 6645, 6646, 6647, 6648, 
        6649, 6650, 6651, 482}, {483, 484}, {483, 485}, {483, 6652, 6653, 
        6654, 6655, 6656, 6657, 6658, 6659, 6660, 6661, 6662, 6663, 6664, 
        6665, 6666, 6667, 6668, 6669, 6670, 6671, 6672, 6673, 6674, 483}, {
        483, 486}, {483, 487}, {488, 48}, {490, 6675, 6676, 6677, 6678, 6679, 
        6680, 6681, 6682, 6683, 6684, 6685, 6686, 6687, 6688, 6689, 6690, 
        6691, 6692, 6693, 6694, 6695, 6696, 6697, 490}, {491, 120}, {493, 
        126}, {493, 127}, {493, 128}, {494, 495}, {494, 496}, {494, 497}, {
        498, 495}, {498, 496}, {498, 497}, {499, 171}, {500, 501}, {501, 
        551}, {501, 148}, {501, 149}, {501, 552}, {501, 6698, 6699, 6700, 
        6701, 6702, 6703, 6704, 6705, 6706, 6707, 6708, 6709, 6710, 6711, 
        6712, 6713, 6714, 6715, 6716, 6717, 6718, 6719, 6720, 501}, {501, 
        553}, {504, 171}, {505, 270}, {505, 271}, {506, 2}, {507, 508}, {507, 
        509}, {508, 6721, 6722, 6723, 6724, 6725, 6726, 6727, 6728, 6729, 
        6730, 6731, 6732, 6733, 6734, 6735, 6736, 6737, 6738, 6739, 6740, 
        6741, 6742, 6743, 508}, {508, 6744, 6745, 6746, 6747, 6748, 6749, 
        6750, 6751, 6752, 6753, 6754, 6755, 6756, 6757, 6758, 6759, 509}, {
        509, 6760, 6761, 6762, 6763, 6764, 6765, 6766, 6767, 6768, 6769, 6770,
         6771, 6772, 6773, 6774, 6775, 508}, {509, 6776, 6777, 6778, 6779, 
        6780, 6781, 6782, 6783, 6784, 6785, 6786, 6787, 6788, 6789, 6790, 
        6791, 6792, 6793, 6794, 6795, 6796, 6797, 6798, 509}, {510, 219}, {
        511, 512}, {511, 6799, 6800, 6801, 6802, 6803, 6804, 6805, 6806, 6807,
         6808, 6809, 6810, 6811, 6812, 6813, 6814, 6815, 6816, 6817, 6818, 
        6819, 6820, 6821, 511}, {513, 6822, 6823, 6824, 6825, 6826, 6827, 
        6828, 6829, 6830, 6831, 6832, 6833, 6834, 6835, 6836, 6837, 6838, 
        6839, 6840, 6841, 6842, 6843, 6844, 513}, {513, 6845, 6846, 6847, 
        6848, 6849, 6850, 6851, 6852, 6853, 6854, 6855, 6856, 6857, 6858, 
        6859, 6860, 514}, {514, 6861, 6862, 6863, 6864, 6865, 6866, 6867, 
        6868, 6869, 6870, 6871, 6872, 6873, 6874, 6875, 6876, 513}, {514, 
        6877, 6878, 6879, 6880, 6881, 6882, 6883, 6884, 6885, 6886, 6887, 
        6888, 6889, 6890, 6891, 6892, 6893, 6894, 6895, 6896, 6897, 6898, 
        6899, 514}, {515, 324}, {515, 308}, {515, 323}, {515, 325}, {516, 
        179}, {516, 166}, {517, 111}, {518, 111}, {519, 126}, {519, 127}, {
        519, 6900, 6901, 6902, 6903, 6904, 6905, 6906, 6907, 6908, 6909, 6910,
         6911, 6912, 6913, 6914, 6915, 6916, 6917, 6918, 6919, 6920, 6921, 
        6922, 519}, {519, 128}, {520, 521}, {520, 6923, 6924, 6925, 6926, 
        6927, 6928, 6929, 6930, 6931, 6932, 6933, 6934, 6935, 6936, 6937, 
        6938, 6939, 6940, 6941, 6942, 6943, 6944, 6945, 520}, {520, 522}, {
        523, 278}, {523, 290}, {523, 524}, {525, 108}, {525, 433}, {525, 
        109}, {526, 527}, {526, 314}, {528, 375}, {529, 117}, {529, 118}, {
        529, 119}, {529, 120}, {529, 121}, {529, 122}, {529, 439}, {529, 
        123}, {529, 124}, {530, 120}, {531, 532}, {531, 533}, {533, 532}, {
        533, 6946, 6947, 6948, 6949, 6950, 6951, 6952, 6953, 6954, 6955, 6956,
         6957, 6958, 6959, 6960, 6961, 6962, 6963, 6964, 6965, 6966, 6967, 
        6968, 533}, {534, 535}, {534, 536}, {534, 537}, {534, 538}, {534, 
        539}, {534, 540}, {534, 541}, {542, 543}, {543, 6969, 6970, 6971, 
        6972, 6973, 6974, 6975, 6976, 6977, 6978, 6979, 6980, 6981, 6982, 
        6983, 6984, 6985, 6986, 6987, 6988, 6989, 6990, 6991, 543}, {544, 
        166}, {545, 433}, {546, 102}, {547, 171}, {548, 549}, {548, 6992, 
        6993, 6994, 6995, 6996, 6997, 6998, 6999, 7000, 7001, 7002, 7003, 
        7004, 7005, 7006, 7007, 7008, 7009, 7010, 7011, 7012, 7013, 7014, 
        548}, {548, 7015, 7016, 7017, 7018, 7019, 7020, 7021, 7022, 7023, 
        7024, 7025, 7026, 7027, 7028, 7029, 7030, 550}, {550, 549}, {550, 
        7031, 7032, 7033, 7034, 7035, 7036, 7037, 7038, 7039, 7040, 7041, 
        7042, 7043, 7044, 7045, 7046, 548}, {550, 7047, 7048, 7049, 7050, 
        7051, 7052, 7053, 7054, 7055, 7056, 7057, 7058, 7059, 7060, 7061, 
        7062, 7063, 7064, 7065, 7066, 7067, 7068, 7069, 550}, {554, 88}, {554,
         91}, {554, 92}, {555, 254}, {555, 430}, {556, 7070, 7071, 7072, 7073,
         7074, 7075, 7076, 7077, 7078, 7079, 7080, 7081, 7082, 7083, 7084, 
        7085, 7086, 7087, 7088, 7089, 7090, 7091, 7092, 556}, {557, 25}, {557,
         26}, {558, 474}, {559, 319}, {559, 320}, {559, 321}, {560, 561}, {
        560, 562}, {561, 7093, 7094, 7095, 7096, 7097, 7098, 7099, 7100, 7101,
         7102, 7103, 7104, 7105, 7106, 7107, 7108, 7109, 7110, 7111, 7112, 
        7113, 7114, 7115, 561}, {561, 7116, 7117, 7118, 7119, 7120, 7121, 
        7122, 7123, 7124, 7125, 7126, 7127, 7128, 7129, 7130, 7131, 562}, {
        562, 7132, 7133, 7134, 7135, 7136, 7137, 7138, 7139, 7140, 7141, 7142,
         7143, 7144, 7145, 7146, 7147, 561}, {562, 7148, 7149, 7150, 7151, 
        7152, 7153, 7154, 7155, 7156, 7157, 7158, 7159, 7160, 7161, 7162, 
        7163, 7164, 7165, 7166, 7167, 7168, 7169, 7170, 562}, {563, 307}, {
        564, 37}, {565, 16}, {565, 566}, {567, 16}, {567, 566}, {568, 179}, {
        568, 74}, {568, 4}, {568, 75}, {568, 76}, {568, 5}, {568, 6}, {568, 
        7}, {568, 8}, {568, 166}, {568, 9}, {568, 10}, {568, 11}, {568, 12}, {
        569, 4}, {569, 5}, {569, 6}, {569, 7}, {569, 8}, {569, 9}, {569, 
        10}, {569, 11}, {569, 12}, {570, 333}, {570, 334}, {570, 335}, {570, 
        7171, 7172, 7173, 7174, 7175, 7176, 7177, 7178, 7179, 7180, 7181, 
        7182, 7183, 7184, 7185, 7186, 7187, 7188, 7189, 7190, 7191, 7192, 
        7193, 570}, {571, 59}, {571, 7194, 7195, 7196, 7197, 7198, 7199, 7200,
         7201, 7202, 7203, 7204, 7205, 7206, 7207, 7208, 7209, 7210, 7211, 
        7212, 7213, 7214, 7215, 7216, 571}, {572, 7217, 7218, 7219, 7220, 
        7221, 7222, 7223, 7224, 7225, 7226, 7227, 7228, 7229, 7230, 7231, 
        7232, 7233, 7234, 7235, 7236, 7237, 7238, 7239, 572}, {573, 574}, {
        575, 375}, {576, 375}, {577, 107}, {577, 578}, {577, 579}, {577, 7240,
         7241, 7242, 7243, 7244, 7245, 7246, 7247, 7248, 7249, 7250, 7251, 
        7252, 7253, 7254, 7255, 7256, 7257, 7258, 7259, 7260, 7261, 7262, 
        577}, {580, 7263, 7264, 7265, 7266, 7267, 7268, 7269, 7270, 7271, 
        7272, 7273, 7274, 7275, 7276, 7277, 7278, 7279, 7280, 7281, 7282, 
        7283, 7284, 7285, 580}, {581, 7286, 7287, 7288, 7289, 7290, 7291, 
        7292, 7293, 7294, 7295, 7296, 7297, 7298, 7299, 7300, 7301, 7302, 
        7303, 7304, 7305, 7306, 7307, 7308, 581}, {582, 7309, 7310, 7311, 
        7312, 7313, 7314, 7315, 7316, 7317, 7318, 7319, 7320, 7321, 7322, 
        7323, 7324, 7325, 7326, 7327, 7328, 7329, 7330, 7331, 582}, {583, 
        7332, 7333, 7334, 7335, 7336, 7337, 7338, 7339, 7340, 7341, 7342, 
        7343, 7344, 7345, 7346, 7347, 7348, 7349, 7350, 7351, 7352, 7353, 
        7354, 583}, {584, 4}, {584, 5}, {584, 6}, {584, 7}, {584, 8}, {584, 
        9}, {584, 10}, {584, 11}, {584, 12}, {585, 4}, {585, 5}, {585, 6}, {
        585, 7}, {585, 8}, {585, 9}, {585, 10}, {585, 11}, {585, 12}, {586, 
        179}, {586, 166}, {587, 7355, 7356, 7357, 7358, 7359, 7360, 7361, 
        7362, 7363, 7364, 7365, 7366, 7367, 7368, 7369, 7370, 7371, 7372, 
        7373, 7374, 7375, 7376, 7377, 587}, {589, 588}, {589, 254}, {589, 
        63}, {590, 18}, {590, 19}, {590, 20}, {590, 21}, {590, 22}, {590, 
        23}, {591, 7378, 7379, 7380, 7381, 7382, 7383, 7384, 7385, 7386, 7387,
         7388, 7389, 7390, 7391, 7392, 7393, 7394, 7395, 7396, 7397, 7398, 
        7399, 7400, 591}, {592, 375}, {593, 179}, {593, 166}, {595, 596}, {
        595, 597}, {596, 7401, 7402, 7403, 7404, 7405, 7406, 7407, 7408, 7409,
         7410, 7411, 7412, 7413, 7414, 7415, 7416, 7417, 7418, 7419, 7420, 
        7421, 7422, 7423, 596}, {596, 7424, 7425, 7426, 7427, 7428, 7429, 
        7430, 7431, 7432, 7433, 7434, 7435, 7436, 7437, 7438, 7439, 597}, {
        597, 7440, 7441, 7442, 7443, 7444, 7445, 7446, 7447, 7448, 7449, 7450,
         7451, 7452, 7453, 7454, 7455, 596}, {597, 7456, 7457, 7458, 7459, 
        7460, 7461, 7462, 7463, 7464, 7465, 7466, 7467, 7468, 7469, 7470, 
        7471, 7472, 7473, 7474, 7475, 7476, 7477, 7478, 597}, {598, 356}, {
        598, 357}, {599, 163}, {600, 15}, {600, 16}, {601, 104}, {601, 105}, {
        601, 106}, {601, 107}, {602, 551}, {602, 148}, {602, 149}, {602, 
        552}, {602, 553}, {603, 15}, {603, 460}, {603, 574}, {604, 605}, {606,
         607}, {606, 7479, 7480, 7481, 7482, 7483, 7484, 7485, 7486, 7487, 
        7488, 7489, 7490, 7491, 7492, 7493, 7494, 7495, 7496, 7497, 7498, 
        7499, 7500, 7501, 606}, {606, 608}, {606, 609}, {606, 610}, {611, 
        104}, {611, 105}, {611, 106}, {611, 107}, {612, 166}, {613, 395}, {
        613, 396}, {613, 397}, {614, 7502, 7503, 7504, 7505, 7506, 7507, 7508,
         7509, 7510, 7511, 7512, 7513, 7514, 7515, 7516, 7517, 7518, 7519, 
        7520, 7521, 7522, 7523, 7524, 614}, {615, 7525, 7526, 7527, 7528, 
        7529, 7530, 7531, 7532, 7533, 7534, 7535, 7536, 7537, 7538, 7539, 
        7540, 7541, 7542, 7543, 7544, 7545, 7546, 7547, 615}, {616, 297}, {
        616, 298}, {616, 299}, {616, 300}, {616, 301}, {617, 4}, {617, 5}, {
        617, 6}, {617, 7}, {617, 8}, {617, 9}, {617, 10}, {617, 11}, {617, 
        12}, {618, 619}, {618, 620}, {621, 7548, 7549, 7550, 7551, 7552, 7553,
         7554, 7555, 7556, 7557, 7558, 7559, 7560, 7561, 7562, 7563, 7564, 
        7565, 7566, 7567, 7568, 7569, 7570, 621}, {622, 37}, {623, 4}, {623, 
        5}, {623, 6}, {623, 7}, {623, 8}, {623, 9}, {623, 10}, {623, 11}, {
        623, 12}, {624, 4}, {624, 5}, {624, 6}, {624, 7}, {624, 8}, {624, 
        9}, {624, 10}, {624, 11}, {624, 12}, {626, 625}, {626, 249}, {627, 
        7571, 7572, 7573, 7574, 7575, 7576, 7577, 7578, 7579, 7580, 7581, 
        7582, 7583, 7584, 7585, 7586, 7587, 7588, 7589, 7590, 7591, 7592, 
        7593, 627}, {628, 629}, {628, 630}, {628, 7594, 7595, 7596, 7597, 
        7598, 7599, 7600, 7601, 7602, 7603, 7604, 7605, 7606, 7607, 7608, 
        7609, 7610, 7611, 7612, 7613, 7614, 7615, 7616, 628}, {628, 7617, 
        7618, 7619, 7620, 7621, 7622, 7623, 7624, 7625, 7626, 7627, 7628, 
        7629, 7630, 7631, 7632, 631}, {631, 629}, {631, 630}, {631, 7633, 
        7634, 7635, 7636, 7637, 7638, 7639, 7640, 7641, 7642, 7643, 7644, 
        7645, 7646, 7647, 7648, 628}, {631, 7649, 7650, 7651, 7652, 7653, 
        7654, 7655, 7656, 7657, 7658, 7659, 7660, 7661, 7662, 7663, 7664, 
        7665, 7666, 7667, 7668, 7669, 7670, 7671, 631}, {632, 450}, {632, 
        449}, {632, 448}, {632, 451}, {632, 452}, {632, 453}, {633, 450}, {
        633, 449}, {633, 448}, {633, 451}, {633, 452}, {633, 453}, {634, 
        635}, {636, 88}, {636, 91}, {636, 92}, {637, 270}, {637, 271}, {638, 
        84}, {638, 85}, {638, 86}, {638, 87}, {639, 49}, {639, 50}, {639, 
        51}, {640, 49}, {640, 50}, {640, 51}, {641, 49}, {641, 50}, {641, 
        51}, {642, 643}, {643, 7672, 7673, 7674, 7675, 7676, 7677, 7678, 7679,
         7680, 7681, 7682, 7683, 7684, 7685, 7686, 7687, 7688, 7689, 7690, 
        7691, 7692, 7693, 7694, 643}, {644, 275}, {645, 7695, 7696, 7697, 
        7698, 7699, 7700, 7701, 7702, 7703, 7704, 7705, 7706, 7707, 7708, 
        7709, 7710, 7711, 7712, 7713, 7714, 7715, 7716, 7717, 645}, {646, 
        297}, {646, 298}, {646, 299}, {646, 300}, {646, 301}, {647, 297}, {
        647, 298}, {647, 299}, {647, 300}, {647, 301}, {648, 7718, 7719, 7720,
         7721, 7722, 7723, 7724, 7725, 7726, 7727, 7728, 7729, 7730, 7731, 
        7732, 7733, 7734, 7735, 7736, 7737, 7738, 7739, 7740, 648}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "\"acerbate\""],
       Annotation[#, "acerbate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "\"resent\""],
       Annotation[#, "resent", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "\"activate\""],
       Annotation[#, "activate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "\"come about\""],
       Annotation[#, "come about", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "\"fall out\""],
       Annotation[#, "fall out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "\"go on\""],
       Annotation[#, "go on", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "\"hap\""],
       Annotation[#, "hap", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "\"happen\""],
       Annotation[#, "happen", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "\"occur\""],
       Annotation[#, "occur", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "\"pass\""],
       Annotation[#, "pass", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "\"pass off\""],
       Annotation[#, "pass off", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "\"take place\""],
       Annotation[#, "take place", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "\"actuate\""],
       Annotation[#, "actuate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "\"affect\""],
       Annotation[#, "affect", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "\"experience\""],
       Annotation[#, "experience", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "\"feel\""],
       Annotation[#, "feel", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "\"affix\""],
       Annotation[#, "affix", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "\"adhere\""],
       Annotation[#, "adhere", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "\"bind\""],
       Annotation[#, "bind", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "\"bond\""],
       Annotation[#, "bond", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "\"hold fast\""],
       Annotation[#, "hold fast", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "\"stick\""],
       Annotation[#, "stick", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "\"stick to\""],
       Annotation[#, "stick to", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "\"affright\""],
       Annotation[#, "affright", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "\"dread\""],
       Annotation[#, "dread", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "\"fear\""],
       Annotation[#, "fear", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "\"age\""],
       Annotation[#, "age", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "\"get on\""],
       Annotation[#, "get on", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "\"maturate\""],
       Annotation[#, "maturate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "\"mature\""],
       Annotation[#, "mature", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "\"senesce\""],
       Annotation[#, "senesce", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "\"aggrieve\""],
       Annotation[#, "aggrieve", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "\"grieve\""],
       Annotation[#, "grieve", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "\"sorrow\""],
       Annotation[#, "sorrow", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "\"agonise\""],
       Annotation[#, "agonise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "\"agonize\""],
       Annotation[#, "agonize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "\"air\""],
       Annotation[#, "air", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "\"alter\""],
       Annotation[#, "alter", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "\"change\""],
       Annotation[#, "change", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "\"ameliorate\""],
       Annotation[#, "ameliorate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "\"better\""],
       Annotation[#, "better", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "\"improve\""],
       Annotation[#, "improve", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "\"meliorate\""],
       Annotation[#, "meliorate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "\"amend\""],
       Annotation[#, "amend", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "\"anger\""],
       Annotation[#, "anger", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "\"see red\""],
       Annotation[#, "see red", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "\"anguish\""],
       Annotation[#, "anguish", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "\"suffer\""],
       Annotation[#, "suffer", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "\"apply\""],
       Annotation[#, "apply", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "\"go for\""],
       Annotation[#, "go for", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "\"hold\""],
       Annotation[#, "hold", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "\"assemble\""],
       Annotation[#, "assemble", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "\"foregather\""],
       Annotation[#, "foregather", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "\"forgather\""],
       Annotation[#, "forgather", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "\"gather\""],
       Annotation[#, "gather", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "\"meet\""],
       Annotation[#, "meet", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "\"attach\""],
       Annotation[#, "attach", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "\"back\""],
       Annotation[#, "back", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "\"beam\""],
       Annotation[#, "beam", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "\"beef up\""],
       Annotation[#, "beef up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "\"strengthen\""],
       Annotation[#, "strengthen", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "\"begin\""],
       Annotation[#, "begin", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "\"start\""],
       Annotation[#, "start", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "\"bethink\""],
       Annotation[#, "bethink", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        "\"consider\""],
       Annotation[#, "consider", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        "\"study\""],
       Annotation[#, "study", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        "\"bilge\""],
       Annotation[#, "bilge", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        "\"take in water\""],
       Annotation[#, "take in water", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        "\"blear\""],
       Annotation[#, "blear", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        "\"blur\""],
       Annotation[#, "blur", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        "\"dim\""],
       Annotation[#, "dim", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[72],
        "\"slur\""],
       Annotation[#, "slur", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        "\"bloat\""],
       Annotation[#, "bloat", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[74],
        "\"blow up\""],
       Annotation[#, "blow up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        "\"detonate\""],
       Annotation[#, "detonate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        "\"explode\""],
       Annotation[#, "explode", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        "\"bog down\""],
       Annotation[#, "bog down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        "\"get stuck\""],
       Annotation[#, "get stuck", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        "\"grind to a halt\""],
       Annotation[#, "grind to a halt", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        "\"mire\""],
       Annotation[#, "mire", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        "\"boil\""],
       Annotation[#, "boil", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        "\"bounce\""],
       Annotation[#, "bounce", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        "\"bowl over\""],
       Annotation[#, "bowl over", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        "\"overturn\""],
       Annotation[#, "overturn", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        "\"tip over\""],
       Annotation[#, "tip over", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        "\"tump over\""],
       Annotation[#, "tump over", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        "\"turn over\""],
       Annotation[#, "turn over", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[88],
        "\"break\""],
       Annotation[#, "break", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[89],
        "\"bust\""],
       Annotation[#, "bust", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[90],
        "\"fall apart\""],
       Annotation[#, "fall apart", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[91],
        "\"get around\""],
       Annotation[#, "get around", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[92],
        "\"get out\""],
       Annotation[#, "get out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[93],
        "\"wear\""],
       Annotation[#, "wear", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[94],
        "\"wear out\""],
       Annotation[#, "wear out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[95],
        "\"break down\""],
       Annotation[#, "break down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[96],
        "\"collapse\""],
       Annotation[#, "collapse", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[97],
        "\"crumble\""],
       Annotation[#, "crumble", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[98],
        "\"crumple\""],
       Annotation[#, "crumple", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[99],
        "\"tumble\""],
       Annotation[#, "tumble", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[100],
        "\"break in\""],
       Annotation[#, "break in", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[101],
        "\"break up\""],
       Annotation[#, "break up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[102],
        "\"dissolve\""],
       Annotation[#, "dissolve", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[103],
        "\"bring down\""],
       Annotation[#, "bring down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[104],
        "\"come down\""],
       Annotation[#, "come down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[105],
        "\"descend\""],
       Annotation[#, "descend", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[106],
        "\"fall\""],
       Annotation[#, "fall", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[107],
        "\"go down\""],
       Annotation[#, "go down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[108],
        "\"land\""],
       Annotation[#, "land", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[109],
        "\"set down\""],
       Annotation[#, "set down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[110],
        "\"bring on\""],
       Annotation[#, "bring on", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[111],
        "\"appear\""],
       Annotation[#, "appear", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[112],
        "\"bring out\""],
       Annotation[#, "bring out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[113],
        "\"bring together\""],
       Annotation[#, "bring together", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[114],
        "\"conjoin\""],
       Annotation[#, "conjoin", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[115],
        "\"join\""],
       Annotation[#, "join", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[116],
        "\"bring up\""],
       Annotation[#, "bring up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[117],
        "\"arise\""],
       Annotation[#, "arise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[118],
        "\"come up\""],
       Annotation[#, "come up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[119],
        "\"go up\""],
       Annotation[#, "go up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[120],
        "\"grow up\""],
       Annotation[#, "grow up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[121],
        "\"lift\""],
       Annotation[#, "lift", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[122],
        "\"move up\""],
       Annotation[#, "move up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[123],
        "\"rise\""],
       Annotation[#, "rise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[124],
        "\"uprise\""],
       Annotation[#, "uprise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[125],
        "\"broadcast\""],
       Annotation[#, "broadcast", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[126],
        "\"circulate\""],
       Annotation[#, "circulate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[127],
        "\"go around\""],
       Annotation[#, "go around", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[128],
        "\"spread\""],
       Annotation[#, "spread", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[129],
        "\"broaden\""],
       Annotation[#, "broaden", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[130],
        "\"bubble\""],
       Annotation[#, "bubble", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[131],
        "\"bulge\""],
       Annotation[#, "bulge", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[132],
        "\"pouch\""],
       Annotation[#, "pouch", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[133],
        "\"protrude\""],
       Annotation[#, "protrude", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[134],
        "\"bulk\""],
       Annotation[#, "bulk", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[135],
        "\"bundle off\""],
       Annotation[#, "bundle off", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[136],
        "\"go away\""],
       Annotation[#, "go away", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[137],
        "\"go forth\""],
       Annotation[#, "go forth", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[138],
        "\"leave\""],
       Annotation[#, "leave", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[139],
        "\"buoy up\""],
       Annotation[#, "buoy up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[140],
        "\"lighten\""],
       Annotation[#, "lighten", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[141],
        "\"lighten up\""],
       Annotation[#, "lighten up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[142],
        "\"burn\""],
       Annotation[#, "burn", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[143],
        "\"combust\""],
       Annotation[#, "combust", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[144],
        "\"burst\""],
       Annotation[#, "burst", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[145],
        "\"cave in\""],
       Annotation[#, "cave in", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[146],
        "\"fall in\""],
       Annotation[#, "fall in", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[147],
        "\"founder\""],
       Annotation[#, "founder", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[148],
        "\"give\""],
       Annotation[#, "give", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[149],
        "\"give way\""],
       Annotation[#, "give way", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[150],
        "\"call\""],
       Annotation[#, "call", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[151],
        "\"cause to sleep\""],
       Annotation[#, "cause to sleep", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[152],
        "\"catch some Z's\""],
       Annotation[#, "catch some Z's", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[153],
        "\"kip\""],
       Annotation[#, "kip", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[154],
        "\"log Z's\""],
       Annotation[#, "log Z's", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[155],
        "\"sleep\""],
       Annotation[#, "sleep", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[156],
        "\"slumber\""],
       Annotation[#, "slumber", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[157],
        "\"cheer\""],
       Annotation[#, "cheer", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[158],
        "\"cheer up\""],
       Annotation[#, "cheer up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[159],
        "\"chirk up\""],
       Annotation[#, "chirk up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[160],
        "\"chill\""],
       Annotation[#, "chill", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[161],
        "\"cool\""],
       Annotation[#, "cool", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[162],
        "\"cool down\""],
       Annotation[#, "cool down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[163],
        "\"choke\""],
       Annotation[#, "choke", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[164],
        "\"circularise\""],
       Annotation[#, "circularise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[165],
        "\"circularize\""],
       Annotation[#, "circularize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[166],
        "\"move\""],
       Annotation[#, "move", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[167],
        "\"circumvolve\""],
       Annotation[#, "circumvolve", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[168],
        "\"revolve\""],
       Annotation[#, "revolve", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[169],
        "\"rotate\""],
       Annotation[#, "rotate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[170],
        "\"click\""],
       Annotation[#, "click", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[171],
        "\"understand\""],
       Annotation[#, "understand", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[172],
        "\"clink\""],
       Annotation[#, "clink", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[173],
        "\"chink\""],
       Annotation[#, "chink", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[174],
        "\"tink\""],
       Annotation[#, "tink", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[175],
        "\"tinkle\""],
       Annotation[#, "tinkle", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[176],
        "\"close\""],
       Annotation[#, "close", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[177],
        "\"shut\""],
       Annotation[#, "shut", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[178],
        "\"coerce\""],
       Annotation[#, "coerce", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[179],
        "\"act\""],
       Annotation[#, "act", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[180],
        "\"cohere\""],
       Annotation[#, "cohere", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[181],
        "\"blow a fuse\""],
       Annotation[#, "blow a fuse", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[182],
        "\"blow one's stack\""],
       Annotation[#, "blow one's stack", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[183],
        "\"flip one's lid\""],
       Annotation[#, "flip one's lid", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[184],
        "\"flip one's wig\""],
       Annotation[#, "flip one's wig", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[185],
        "\"fly off the handle\""],
       Annotation[#, "fly off the handle", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[186],
        "\"go ballistic\""],
       Annotation[#, "go ballistic", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[187],
        "\"have a fit\""],
       Annotation[#, "have a fit", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[188],
        "\"have kittens\""],
       Annotation[#, "have kittens", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[189],
        "\"hit the ceiling\""],
       Annotation[#, "hit the ceiling", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[190],
        "\"hit the roof\""],
       Annotation[#, "hit the roof", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[191],
        "\"lose one's temper\""],
       Annotation[#, "lose one's temper", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[192],
        "\"throw a fit\""],
       Annotation[#, "throw a fit", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[193],
        "\"come across\""],
       Annotation[#, "come across", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[194],
        "\"come home\""],
       Annotation[#, "come home", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[195],
        "\"commence\""],
       Annotation[#, "commence", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[196],
        "\"compel\""],
       Annotation[#, "compel", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[197],
        "\"compound\""],
       Annotation[#, "compound", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[198],
        "\"deepen\""],
       Annotation[#, "deepen", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[199],
        "\"intensify\""],
       Annotation[#, "intensify", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[200],
        "\"convert\""],
       Annotation[#, "convert", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[201],
        "\"convulse\""],
       Annotation[#, "convulse", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[202],
        "\"crack\""],
       Annotation[#, "crack", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[203],
        "\"crash\""],
       Annotation[#, "crash", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[204],
        "\"break apart\""],
       Annotation[#, "break apart", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[205],
        "\"cross-fertilise\""],
       Annotation[#, "cross-fertilise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[206],
        "\"cross-fertilize\""],
       Annotation[#, "cross-fertilize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[207],
        "\"crystalise\""],
       Annotation[#, "crystalise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[208],
        "\"crystalize\""],
       Annotation[#, "crystalize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[209],
        "\"crystallize\""],
       Annotation[#, "crystallize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[210],
        "\"effloresce\""],
       Annotation[#, "effloresce", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[211],
        "\"crystallise\""],
       Annotation[#, "crystallise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[212],
        "\"cut down\""],
       Annotation[#, "cut down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[213],
        "\"darken\""],
       Annotation[#, "darken", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[214],
        "\"dawn\""],
       Annotation[#, "dawn", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[215],
        "\"decide\""],
       Annotation[#, "decide", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[216],
        "\"determine\""],
       Annotation[#, "determine", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[217],
        "\"make up one's mind\""],
       Annotation[#, "make up one's mind", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[218],
        "\"delight\""],
       Annotation[#, "delight", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[219],
        "\"like\""],
       Annotation[#, "like", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[220],
        "\"demulsify\""],
       Annotation[#, "demulsify", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[221],
        "\"develop\""],
       Annotation[#, "develop", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[222],
        "\"grow\""],
       Annotation[#, "grow", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[223],
        "\"diffuse\""],
       Annotation[#, "diffuse", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[224],
        "\"direct\""],
       Annotation[#, "direct", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[225],
        "\"discharge\""],
       Annotation[#, "discharge", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[226],
        "\"fire\""],
       Annotation[#, "fire", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[227],
        "\"go off\""],
       Annotation[#, "go off", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[228],
        "\"disclose\""],
       Annotation[#, "disclose", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[229],
        "\"discolor\""],
       Annotation[#, "discolor", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[230],
        "\"color\""],
       Annotation[#, "color", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[231],
        "\"colour\""],
       Annotation[#, "colour", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[232],
        "\"discolour\""],
       Annotation[#, "discolour", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[233],
        "\"discover\""],
       Annotation[#, "discover", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[234],
        "\"disjoin\""],
       Annotation[#, "disjoin", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[235],
        "\"disjoint\""],
       Annotation[#, "disjoint", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[236],
        "\"disperse\""],
       Annotation[#, "disperse", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[237],
        "\"displace\""],
       Annotation[#, "displace", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[238],
        "\"displease\""],
       Annotation[#, "displease", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[239],
        "\"dislike\""],
       Annotation[#, "dislike", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[240],
        "\"disseminate\""],
       Annotation[#, "disseminate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[241],
        "\"distribute\""],
       Annotation[#, "distribute", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[242],
        "\"disunite\""],
       Annotation[#, "disunite", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[243],
        "\"divide\""],
       Annotation[#, "divide", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[244],
        "\"part\""],
       Annotation[#, "part", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[245],
        "\"separate\""],
       Annotation[#, "separate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[246],
        "\"divulge\""],
       Annotation[#, "divulge", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[247],
        "\"do drugs\""],
       Annotation[#, "do drugs", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[248],
        "\"get off\""],
       Annotation[#, "get off", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[249],
        "\"trip\""],
       Annotation[#, "trip", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[250],
        "\"trip out\""],
       Annotation[#, "trip out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[251],
        "\"turn on\""],
       Annotation[#, "turn on", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[252],
        "\"dovetail\""],
       Annotation[#, "dovetail", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[253],
        "\"fit\""],
       Annotation[#, "fit", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[254],
        "\"go\""],
       Annotation[#, "go", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[255],
        "\"drench\""],
       Annotation[#, "drench", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[256],
        "\"drink\""],
       Annotation[#, "drink", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[257],
        "\"imbibe\""],
       Annotation[#, "imbibe", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[258],
        "\"drive in\""],
       Annotation[#, "drive in", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[259],
        "\"hit\""],
       Annotation[#, "hit", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[260],
        "\"rack up\""],
       Annotation[#, "rack up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[261],
        "\"score\""],
       Annotation[#, "score", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[262],
        "\"tally\""],
       Annotation[#, "tally", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[263],
        "\"drop\""],
       Annotation[#, "drop", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[264],
        "\"drug\""],
       Annotation[#, "drug", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[265],
        "\"dry\""],
       Annotation[#, "dry", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[266],
        "\"dry out\""],
       Annotation[#, "dry out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[267],
        "\"effect\""],
       Annotation[#, "effect", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[268],
        "\"effectuate\""],
       Annotation[#, "effectuate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[269],
        "\"elate\""],
       Annotation[#, "elate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[270],
        "\"joy\""],
       Annotation[#, "joy", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[271],
        "\"rejoice\""],
       Annotation[#, "rejoice", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[272],
        "\"elevate\""],
       Annotation[#, "elevate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[273],
        "\"elongate\""],
       Annotation[#, "elongate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[274],
        "\"stretch\""],
       Annotation[#, "stretch", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[275],
        "\"emaciate\""],
       Annotation[#, "emaciate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[276],
        "\"embitter\""],
       Annotation[#, "embitter", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[277],
        "\"employ\""],
       Annotation[#, "employ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[278],
        "\"empty\""],
       Annotation[#, "empty", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[279],
        "\"emulsify\""],
       Annotation[#, "emulsify", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[280],
        "\"encourage\""],
       Annotation[#, "encourage", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[281],
        "\"hope\""],
       Annotation[#, "hope", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[282],
        "\"end\""],
       Annotation[#, "end", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[283],
        "\"cease\""],
       Annotation[#, "cease", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[284],
        "\"finish\""],
       Annotation[#, "finish", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[285],
        "\"stop\""],
       Annotation[#, "stop", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[286],
        "\"terminate\""],
       Annotation[#, "terminate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[287],
        "\"enrage\""],
       Annotation[#, "enrage", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[288],
        "\"rage\""],
       Annotation[#, "rage", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[289],
        "\"envenom\""],
       Annotation[#, "envenom", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[290],
        "\"evacuate\""],
       Annotation[#, "evacuate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[291],
        "\"even\""],
       Annotation[#, "even", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[292],
        "\"even out\""],
       Annotation[#, "even out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[293],
        "\"exercise\""],
       Annotation[#, "exercise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[294],
        "\"work out\""],
       Annotation[#, "work out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[295],
        "\"expose\""],
       Annotation[#, "expose", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[296],
        "\"fag\""],
       Annotation[#, "fag", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[297],
        "\"fatigue\""],
       Annotation[#, "fatigue", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[298],
        "\"jade\""],
       Annotation[#, "jade", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[299],
        "\"pall\""],
       Annotation[#, "pall", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[300],
        "\"tire\""],
       Annotation[#, "tire", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[301],
        "\"weary\""],
       Annotation[#, "weary", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[302],
        "\"fag out\""],
       Annotation[#, "fag out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[303],
        "\"fall into place\""],
       Annotation[#, "fall into place", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[304],
        "\"famish\""],
       Annotation[#, "famish", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[305],
        "\"hunger\""],
       Annotation[#, "hunger", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[306],
        "\"starve\""],
       Annotation[#, "starve", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[307],
        "\"fasten\""],
       Annotation[#, "fasten", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[308],
        "\"feed\""],
       Annotation[#, "feed", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[309],
        "\"eat\""],
       Annotation[#, "eat", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[310],
        "\"fell\""],
       Annotation[#, "fell", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[311],
        "\"ferment\""],
       Annotation[#, "ferment", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[312],
        "\"sour\""],
       Annotation[#, "sour", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[313],
        "\"turn\""],
       Annotation[#, "turn", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[314],
        "\"work\""],
       Annotation[#, "work", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[315],
        "\"fill\""],
       Annotation[#, "fill", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[316],
        "\"fill up\""],
       Annotation[#, "fill up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[317],
        "\"fix\""],
       Annotation[#, "fix", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[318],
        "\"flavor\""],
       Annotation[#, "flavor", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[319],
        "\"savor\""],
       Annotation[#, "savor", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[320],
        "\"savour\""],
       Annotation[#, "savour", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[321],
        "\"taste\""],
       Annotation[#, "taste", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[322],
        "\"flavour\""],
       Annotation[#, "flavour", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[323],
        "\"flow\""],
       Annotation[#, "flow", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[324],
        "\"course\""],
       Annotation[#, "course", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[325],
        "\"run\""],
       Annotation[#, "run", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[326],
        "\"flush\""],
       Annotation[#, "flush", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[327],
        "\"fluster\""],
       Annotation[#, "fluster", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[328],
        "\"fly\""],
       Annotation[#, "fly", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[329],
        "\"be adrift\""],
       Annotation[#, "be adrift", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[330],
        "\"blow\""],
       Annotation[#, "blow", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[331],
        "\"drift\""],
       Annotation[#, "drift", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[332],
        "\"float\""],
       Annotation[#, "float", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[333],
        "\"focalise\""],
       Annotation[#, "focalise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[334],
        "\"focalize\""],
       Annotation[#, "focalize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[335],
        "\"focus\""],
       Annotation[#, "focus", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[336],
        "\"follow\""],
       Annotation[#, "follow", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[337],
        "\"force\""],
       Annotation[#, "force", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[338],
        "\"fortify\""],
       Annotation[#, "fortify", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[339],
        "\"freeze\""],
       Annotation[#, "freeze", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[340],
        "\"fret\""],
       Annotation[#, "fret", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[341],
        "\"fright\""],
       Annotation[#, "fright", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[342],
        "\"frighten\""],
       Annotation[#, "frighten", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[343],
        "\"fruit\""],
       Annotation[#, "fruit", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[344],
        "\"get across\""],
       Annotation[#, "get across", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[345],
        "\"get down\""],
       Annotation[#, "get down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[346],
        "\"get through\""],
       Annotation[#, "get through", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[347],
        "\"get together\""],
       Annotation[#, "get together", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[348],
        "\"get up\""],
       Annotation[#, "get up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[349],
        "\"have\""],
       Annotation[#, "have", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[350],
        "\"have got\""],
       Annotation[#, "have got", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[351],
        "\"give away\""],
       Annotation[#, "give away", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[352],
        "\"gladden\""],
       Annotation[#, "gladden", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[353],
        "\"graduate\""],
       Annotation[#, "graduate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[354],
        "\"grain\""],
       Annotation[#, "grain", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[355],
        "\"granulate\""],
       Annotation[#, "granulate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[356],
        "\"ground\""],
       Annotation[#, "ground", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[357],
        "\"run aground\""],
       Annotation[#, "run aground", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[358],
        "\"hale\""],
       Annotation[#, "hale", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[359],
        "\"hang\""],
       Annotation[#, "hang", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[360],
        "\"hang up\""],
       Annotation[#, "hang up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[361],
        "\"harden\""],
       Annotation[#, "harden", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[362],
        "\"indurate\""],
       Annotation[#, "indurate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[363],
        "\"heat\""],
       Annotation[#, "heat", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[364],
        "\"heat up\""],
       Annotation[#, "heat up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[365],
        "\"hot up\""],
       Annotation[#, "hot up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[366],
        "\"heighten\""],
       Annotation[#, "heighten", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[367],
        "\"hurry\""],
       Annotation[#, "hurry", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[368],
        "\"festinate\""],
       Annotation[#, "festinate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[369],
        "\"hasten\""],
       Annotation[#, "hasten", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[370],
        "\"look sharp\""],
       Annotation[#, "look sharp", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[371],
        "\"rush\""],
       Annotation[#, "rush", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[372],
        "\"hurt\""],
       Annotation[#, "hurt", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[373],
        "\"ache\""],
       Annotation[#, "ache", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[374],
        "\"smart\""],
       Annotation[#, "smart", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[375],
        "\"hush\""],
       Annotation[#, "hush", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[376],
        "\"hush up\""],
       Annotation[#, "hush up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[377],
        "\"hydrolise\""],
       Annotation[#, "hydrolise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[378],
        "\"hydrolyse\""],
       Annotation[#, "hydrolyse", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[379],
        "\"hydrolyze\""],
       Annotation[#, "hydrolyze", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[380],
        "\"hydrolize\""],
       Annotation[#, "hydrolize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[381],
        "\"ignite\""],
       Annotation[#, "ignite", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[382],
        "\"immerse\""],
       Annotation[#, "immerse", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[383],
        "\"absorb\""],
       Annotation[#, "absorb", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[384],
        "\"engross\""],
       Annotation[#, "engross", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[385],
        "\"engulf\""],
       Annotation[#, "engulf", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[386],
        "\"plunge\""],
       Annotation[#, "plunge", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[387],
        "\"soak up\""],
       Annotation[#, "soak up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[388],
        "\"steep\""],
       Annotation[#, "steep", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[389],
        "\"impress\""],
       Annotation[#, "impress", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[390],
        "\"incite\""],
       Annotation[#, "incite", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[391],
        "\"inspissate\""],
       Annotation[#, "inspissate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[392],
        "\"thicken\""],
       Annotation[#, "thicken", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[393],
        "\"instigate\""],
       Annotation[#, "instigate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[394],
        "\"instruct\""],
       Annotation[#, "instruct", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[395],
        "\"acquire\""],
       Annotation[#, "acquire", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[396],
        "\"larn\""],
       Annotation[#, "larn", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[397],
        "\"learn\""],
       Annotation[#, "learn", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[398],
        "\"intoxicate\""],
       Annotation[#, "intoxicate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[399],
        "\"Islamise\""],
       Annotation[#, "Islamise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[400],
        "\"Islamize\""],
       Annotation[#, "Islamize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[401],
        "\"jaunt\""],
       Annotation[#, "jaunt", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[402],
        "\"locomote\""],
       Annotation[#, "locomote", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[403],
        "\"travel\""],
       Annotation[#, "travel", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[404],
        "\"jolly along\""],
       Annotation[#, "jolly along", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[405],
        "\"jolly up\""],
       Annotation[#, "jolly up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[406],
        "\"jump\""],
       Annotation[#, "jump", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[407],
        "\"bound\""],
       Annotation[#, "bound", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[408],
        "\"leap\""],
       Annotation[#, "leap", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[409],
        "\"spring\""],
       Annotation[#, "spring", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[410],
        "\"keep up\""],
       Annotation[#, "keep up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[411],
        "\"sit up\""],
       Annotation[#, "sit up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[412],
        "\"stay up\""],
       Annotation[#, "stay up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[413],
        "\"kill\""],
       Annotation[#, "kill", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[414],
        "\"buy the farm\""],
       Annotation[#, "buy the farm", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[415],
        "\"cash in one's chips\""],
       Annotation[#, "cash in one's chips", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[416],
        "\"conk\""],
       Annotation[#, "conk", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[417],
        "\"croak\""],
       Annotation[#, "croak", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[418],
        "\"decease\""],
       Annotation[#, "decease", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[419],
        "\"die\""],
       Annotation[#, "die", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[420],
        "\"drop dead\""],
       Annotation[#, "drop dead", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[421],
        "\"exit\""],
       Annotation[#, "exit", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[422],
        "\"expire\""],
       Annotation[#, "expire", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[423],
        "\"give-up the ghost\""],
       Annotation[#, "give-up the ghost", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[424],
        "\"kick the bucket\""],
       Annotation[#, "kick the bucket", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[425],
        "\"pass away\""],
       Annotation[#, "pass away", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[426],
        "\"perish\""],
       Annotation[#, "perish", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[427],
        "\"pop off\""],
       Annotation[#, "pop off", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[428],
        "\"snuff it\""],
       Annotation[#, "snuff it", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[429],
        "\"knell\""],
       Annotation[#, "knell", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[430],
        "\"sound\""],
       Annotation[#, "sound", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[431],
        "\"knock over\""],
       Annotation[#, "knock over", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[432],
        "\"lay\""],
       Annotation[#, "lay", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[433],
        "\"lie\""],
       Annotation[#, "lie", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[434],
        "\"leach\""],
       Annotation[#, "leach", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[435],
        "\"percolate\""],
       Annotation[#, "percolate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[436],
        "\"lead off\""],
       Annotation[#, "lead off", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[437],
        "\"leak\""],
       Annotation[#, "leak", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[438],
        "\"leaven\""],
       Annotation[#, "leaven", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[439],
        "\"prove\""],
       Annotation[#, "prove", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[440],
        "\"lengthen\""],
       Annotation[#, "lengthen", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[441],
        "\"let down\""],
       Annotation[#, "let down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[442],
        "\"let on\""],
       Annotation[#, "let on", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[443],
        "\"let out\""],
       Annotation[#, "let out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[444],
        "\"lift up\""],
       Annotation[#, "lift up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[445],
        "\"light\""],
       Annotation[#, "light", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[446],
        "\"loose\""],
       Annotation[#, "loose", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[447],
        "\"loosen\""],
       Annotation[#, "loosen", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[448],
        "\"relax\""],
       Annotation[#, "relax", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[449],
        "\"loosen up\""],
       Annotation[#, "loosen up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[450],
        "\"decompress\""],
       Annotation[#, "decompress", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[451],
        "\"slow down\""],
       Annotation[#, "slow down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[452],
        "\"unbend\""],
       Annotation[#, "unbend", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[453],
        "\"unwind\""],
       Annotation[#, "unwind", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[454],
        "\"lower\""],
       Annotation[#, "lower", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[455],
        "\"macerate\""],
       Annotation[#, "macerate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[456],
        "\"make full\""],
       Annotation[#, "make full", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[457],
        "\"make grow\""],
       Annotation[#, "make grow", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[458],
        "\"make pass\""],
       Annotation[#, "make pass", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[459],
        "\"go across\""],
       Annotation[#, "go across", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[460],
        "\"go through\""],
       Annotation[#, "go through", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[461],
        "\"make relaxed\""],
       Annotation[#, "make relaxed", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[462],
        "\"march\""],
       Annotation[#, "march", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[463],
        "\"ripen\""],
       Annotation[#, "ripen", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[464],
        "\"mellow\""],
       Annotation[#, "mellow", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[465],
        "\"mobilise\""],
       Annotation[#, "mobilise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[466],
        "\"mobilize\""],
       Annotation[#, "mobilize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[467],
        "\"modify\""],
       Annotation[#, "modify", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[468],
        "\"morph\""],
       Annotation[#, "morph", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[469],
        "\"move out\""],
       Annotation[#, "move out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[470],
        "\"nurture\""],
       Annotation[#, "nurture", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[471],
        "\"obligate\""],
       Annotation[#, "obligate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[472],
        "\"oblige\""],
       Annotation[#, "oblige", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[473],
        "\"odorize\""],
       Annotation[#, "odorize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[474],
        "\"smell\""],
       Annotation[#, "smell", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[475],
        "\"odourise\""],
       Annotation[#, "odourise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[476],
        "\"offend\""],
       Annotation[#, "offend", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[477],
        "\"open\""],
       Annotation[#, "open", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[478],
        "\"open up\""],
       Annotation[#, "open up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[479],
        "\"orient\""],
       Annotation[#, "orient", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[480],
        "\"point\""],
       Annotation[#, "point", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[481],
        "\"outwear\""],
       Annotation[#, "outwear", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[482],
        "\"overheat\""],
       Annotation[#, "overheat", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[483],
        "\"pack\""],
       Annotation[#, "pack", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[484],
        "\"jam\""],
       Annotation[#, "jam", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[485],
        "\"mob\""],
       Annotation[#, "mob", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[486],
        "\"pile\""],
       Annotation[#, "pile", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[487],
        "\"throng\""],
       Annotation[#, "throng", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[488],
        "\"pain\""],
       Annotation[#, "pain", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[489],
        "\"become flat\""],
       Annotation[#, "become flat", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[490],
        "\"panic\""],
       Annotation[#, "panic", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[491],
        "\"parent\""],
       Annotation[#, "parent", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[492],
        "\"make it\""],
       Annotation[#, "make it", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[493],
        "\"pass around\""],
       Annotation[#, "pass around", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[494],
        "\"pasteurise\""],
       Annotation[#, "pasteurise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[495],
        "\"condense\""],
       Annotation[#, "condense", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[496],
        "\"distil\""],
       Annotation[#, "distil", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[497],
        "\"distill\""],
       Annotation[#, "distill", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[498],
        "\"pasteurize\""],
       Annotation[#, "pasteurize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[499],
        "\"penetrate\""],
       Annotation[#, "penetrate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[500],
        "\"pension off\""],
       Annotation[#, "pension off", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[501],
        "\"retire\""],
       Annotation[#, "retire", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[502],
        "\"filter\""],
       Annotation[#, "filter", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[503],
        "\"permeate\""],
       Annotation[#, "permeate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[504],
        "\"sink in\""],
       Annotation[#, "sink in", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[505],
        "\"pick up\""],
       Annotation[#, "pick up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[506],
        "\"pique\""],
       Annotation[#, "pique", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[507],
        "\"place upright\""],
       Annotation[#, "place upright", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[508],
        "\"stand\""],
       Annotation[#, "stand", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[509],
        "\"stand up\""],
       Annotation[#, "stand up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[510],
        "\"please\""],
       Annotation[#, "please", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[511],
        "\"poise\""],
       Annotation[#, "poise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[512],
        "\"balance\""],
       Annotation[#, "balance", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[513],
        "\"polymerise\""],
       Annotation[#, "polymerise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[514],
        "\"polymerize\""],
       Annotation[#, "polymerize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[515],
        "\"pour\""],
       Annotation[#, "pour", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[516],
        "\"pressure\""],
       Annotation[#, "pressure", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[517],
        "\"produce\""],
       Annotation[#, "produce", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[518],
        "\"project\""],
       Annotation[#, "project", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[519],
        "\"propagate\""],
       Annotation[#, "propagate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[520],
        "\"pulse\""],
       Annotation[#, "pulse", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[521],
        "\"pulsate\""],
       Annotation[#, "pulsate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[522],
        "\"throb\""],
       Annotation[#, "throb", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[523],
        "\"purge\""],
       Annotation[#, "purge", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[524],
        "\"void\""],
       Annotation[#, "void", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[525],
        "\"put down\""],
       Annotation[#, "put down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[526],
        "\"put to work\""],
       Annotation[#, "put to work", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[527],
        "\"do work\""],
       Annotation[#, "do work", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[528],
        "\"quieten\""],
       Annotation[#, "quieten", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[529],
        "\"raise\""],
       Annotation[#, "raise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[530],
        "\"rear\""],
       Annotation[#, "rear", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[531],
        "\"reduce\""],
       Annotation[#, "reduce", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[532],
        "\"contract\""],
       Annotation[#, "contract", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[533],
        "\"shrink\""],
       Annotation[#, "shrink", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[534],
        "\"remind\""],
       Annotation[#, "remind", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[535],
        "\"call back\""],
       Annotation[#, "call back", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[536],
        "\"call up\""],
       Annotation[#, "call up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[537],
        "\"recall\""],
       Annotation[#, "recall", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[538],
        "\"recollect\""],
       Annotation[#, "recollect", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[539],
        "\"remember\""],
       Annotation[#, "remember", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[540],
        "\"retrieve\""],
       Annotation[#, "retrieve", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[541],
        "\"think\""],
       Annotation[#, "think", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[542],
        "\"remit\""],
       Annotation[#, "remit", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[543],
        "\"slacken\""],
       Annotation[#, "slacken", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[544],
        "\"remove\""],
       Annotation[#, "remove", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[545],
        "\"repose\""],
       Annotation[#, "repose", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[546],
        "\"resolve\""],
       Annotation[#, "resolve", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[547],
        "\"resonate\""],
       Annotation[#, "resonate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[548],
        "\"resuscitate\""],
       Annotation[#, "resuscitate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[549],
        "\"come to\""],
       Annotation[#, "come to", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[550],
        "\"revive\""],
       Annotation[#, "revive", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[551],
        "\"ease up\""],
       Annotation[#, "ease up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[552],
        "\"move over\""],
       Annotation[#, "move over", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[553],
        "\"yield\""],
       Annotation[#, "yield", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[554],
        "\"reveal\""],
       Annotation[#, "reveal", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[555],
        "\"ring\""],
       Annotation[#, "ring", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[556],
        "\"sadden\""],
       Annotation[#, "sadden", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[557],
        "\"scare\""],
       Annotation[#, "scare", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[558],
        "\"scent\""],
       Annotation[#, "scent", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[559],
        "\"season\""],
       Annotation[#, "season", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[560],
        "\"seat\""],
       Annotation[#, "seat", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[561],
        "\"sit\""],
       Annotation[#, "sit", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[562],
        "\"sit down\""],
       Annotation[#, "sit down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[563],
        "\"secure\""],
       Annotation[#, "secure", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[564],
        "\"send\""],
       Annotation[#, "send", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[565],
        "\"sensitise\""],
       Annotation[#, "sensitise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[566],
        "\"sense\""],
       Annotation[#, "sense", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[567],
        "\"sensitize\""],
       Annotation[#, "sensitize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[568],
        "\"set off\""],
       Annotation[#, "set off", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[569],
        "\"set up\""],
       Annotation[#, "set up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[570],
        "\"sharpen\""],
       Annotation[#, "sharpen", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[571],
        "\"shine\""],
       Annotation[#, "shine", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[572],
        "\"shorten\""],
       Annotation[#, "shorten", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[573],
        "\"show\""],
       Annotation[#, "show", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[574],
        "\"see\""],
       Annotation[#, "see", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[575],
        "\"shut up\""],
       Annotation[#, "shut up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[576],
        "\"silence\""],
       Annotation[#, "silence", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[577],
        "\"sink\""],
       Annotation[#, "sink", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[578],
        "\"go under\""],
       Annotation[#, "go under", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[579],
        "\"settle\""],
       Annotation[#, "settle", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[580],
        "\"slip\""],
       Annotation[#, "slip", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[581],
        "\"soften\""],
       Annotation[#, "soften", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[582],
        "\"solidify\""],
       Annotation[#, "solidify", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[583],
        "\"solvate\""],
       Annotation[#, "solvate", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[584],
        "\"spark\""],
       Annotation[#, "spark", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[585],
        "\"spark off\""],
       Annotation[#, "spark off", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[586],
        "\"squeeze\""],
       Annotation[#, "squeeze", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[587],
        "\"stampede\""],
       Annotation[#, "stampede", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[588],
        "\"get going\""],
       Annotation[#, "get going", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[589],
        "\"start up\""],
       Annotation[#, "start up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[590],
        "\"stick on\""],
       Annotation[#, "stick on", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[591],
        "\"stiffen\""],
       Annotation[#, "stiffen", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[592],
        "\"still\""],
       Annotation[#, "still", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[593],
        "\"stir up\""],
       Annotation[#, "stir up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[594],
        "\"halt\""],
       Annotation[#, "halt", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[595],
        "\"strain\""],
       Annotation[#, "strain", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[596],
        "\"tense\""],
       Annotation[#, "tense", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[597],
        "\"tense up\""],
       Annotation[#, "tense up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[598],
        "\"strand\""],
       Annotation[#, "strand", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[599],
        "\"strangle\""],
       Annotation[#, "strangle", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[600],
        "\"strike\""],
       Annotation[#, "strike", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[601],
        "\"strike down\""],
       Annotation[#, "strike down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[602],
        "\"strike out\""],
       Annotation[#, "strike out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[603],
        "\"subject\""],
       Annotation[#, "subject", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[604],
        "\"suborn\""],
       Annotation[#, "suborn", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[605],
        "\"perjure\""],
       Annotation[#, "perjure", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[606],
        "\"swell\""],
       Annotation[#, "swell", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[607],
        "\"intumesce\""],
       Annotation[#, "intumesce", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[608],
        "\"swell up\""],
       Annotation[#, "swell up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[609],
        "\"tumefy\""],
       Annotation[#, "tumefy", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[610],
        "\"tumesce\""],
       Annotation[#, "tumesce", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[611],
        "\"take down\""],
       Annotation[#, "take down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[612],
        "\"take out\""],
       Annotation[#, "take out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[613],
        "\"teach\""],
       Annotation[#, "teach", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[614],
        "\"thin\""],
       Annotation[#, "thin", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[615],
        "\"tide\""],
       Annotation[#, "tide", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[616],
        "\"tire out\""],
       Annotation[#, "tire out", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[617],
        "\"touch off\""],
       Annotation[#, "touch off", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[618],
        "\"transfer\""],
       Annotation[#, "transfer", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[619],
        "\"change hands\""],
       Annotation[#, "change hands", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[620],
        "\"change owners\""],
       Annotation[#, "change owners", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[621],
        "\"transition\""],
       Annotation[#, "transition", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[622],
        "\"transmit\""],
       Annotation[#, "transmit", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[623],
        "\"trigger\""],
       Annotation[#, "trigger", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[624],
        "\"trigger off\""],
       Annotation[#, "trigger off", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[625],
        "\"stumble\""],
       Annotation[#, "stumble", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[626],
        "\"trip up\""],
       Annotation[#, "trip up", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[627],
        "\"unfasten\""],
       Annotation[#, "unfasten", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[628],
        "\"unionise\""],
       Annotation[#, "unionise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[629],
        "\"organise\""],
       Annotation[#, "organise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[630],
        "\"organize\""],
       Annotation[#, "organize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[631],
        "\"unionize\""],
       Annotation[#, "unionize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[632],
        "\"unlax\""],
       Annotation[#, "unlax", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[633],
        "\"unstrain\""],
       Annotation[#, "unstrain", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[634],
        "\"unteach\""],
       Annotation[#, "unteach", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[635],
        "\"unlearn\""],
       Annotation[#, "unlearn", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[636],
        "\"unwrap\""],
       Annotation[#, "unwrap", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[637],
        "\"uplift\""],
       Annotation[#, "uplift", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[638],
        "\"upset\""],
       Annotation[#, "upset", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[639],
        "\"use\""],
       Annotation[#, "use", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[640],
        "\"utilise\""],
       Annotation[#, "utilise", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[641],
        "\"utilize\""],
       Annotation[#, "utilize", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[642],
        "\"vex\""],
       Annotation[#, "vex", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[643],
        "\"worry\""],
       Annotation[#, "worry", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[644],
        "\"waste\""],
       Annotation[#, "waste", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[645],
        "\"weaken\""],
       Annotation[#, "weaken", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[646],
        "\"wear down\""],
       Annotation[#, "wear down", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[647],
        "\"wear upon\""],
       Annotation[#, "wear upon", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[648],
        "\"widen\""],
       Annotation[#, "widen", "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxVmnlczNv/x1tIJdK+bzPTvs80U7PUvKdSoU0SEhGpyBIhZIsSJUsbqbgp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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{367., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{371, 339},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->670986055]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23179572]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DictionaryLookup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DictionaryLookup"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"],
  FontSlant->"Italic"],
 ButtonBox[" Internet Connectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[ButtonBox["Word Data Source Information",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
WordDataSourceInformation.html"], None}]], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Integrated Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataCollections"]], "MoreAbout",
 CellID->535999155],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->556530645]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WordData - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 55.2592620}", "context" -> "System`", 
    "keywords" -> {
     "animacy level", "antonyms", "artificial intelligence", "base adjective",
       "base form", "base noun", "broader terms", "causes terms", 
      "composite terms", "computational linguistics", "concept weight", 
      "consequences terms", "definitions", "derived adjective", 
      "derived adverb", "dictionary", "English", "entailed terms", 
      "etymology", "examples", "first use year", "geographic domain", 
      "glossary", "grammar", "human language", "hypernym", "hyphenation", 
      "hyponym", "inflected forms", "knowledge representation", "language", 
      "lexicography", "lexicology", "lexicon", "linguistics", 
      "material terms", "morphological derivatives", "morphological source", 
      "narrower terms", "natural language", "natural language processing", 
      "NLP", "parsing", "participle adjectives", "part of speech", 
      "parts of speech", "part terms", "philology", "phonetic form", 
      "phonetics", "phrasal verbs", "phrase structure", "plural", 
      "porter stem", "pronunciation", "related terms", "semantics", 
      "semantic tagging", "semiology", "semiotics", "sentence frames", 
      "sentence structure", "sentence terms", "similar adjectives", 
      "similar terms", "similar verbs", "similar words", "singular", "sound", 
      "spoken language", "stemmer", "stemming", "stop words", "subset terms", 
      "superset terms", "syllables", "symbolic AI", "synonyms", "syntax", 
      "thesaurus", "usage area", "usage field", "usage type", "whole terms", 
      "word frequency", "word net", "word stemming", "word tagging", 
      "written language"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WordData[\"word\", \" property\"] gives the specified property for the \
English word \" word\". WordData[\"word\"] gives a list of full word \
specifications representing possible uses and senses of \" word\". \
WordData[wordspec, \" property\"] gives a property for a particular word \
specification.", "synonyms" -> {"word data"}, "title" -> "WordData", "type" -> 
    "Symbol", "uri" -> "ref/WordData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[21628, 646, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->602984239]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 458506, 10631}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2012, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2635, 78, 1573, 37, 70, "ObjectNameGrid"],
Cell[4211, 117, 1530, 44, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5778, 166, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6256, 183, 592, 17, 70, "Notes",
 CellID->241374237],
Cell[6851, 202, 467, 15, 70, "Notes",
 CellID->883755962],
Cell[7321, 219, 375, 13, 70, "Notes",
 CellID->343754239],
Cell[7699, 234, 190, 5, 70, "Notes",
 CellID->44245654],
Cell[7892, 241, 444, 15, 70, "Notes",
 CellID->376181716],
Cell[8339, 258, 145, 6, 70, "Notes",
 CellID->250883811],
Cell[8487, 266, 398, 14, 70, "Notes",
 CellID->398173972],
Cell[8888, 282, 510, 16, 70, "Notes",
 CellID->81793370],
Cell[9401, 300, 391, 12, 70, "Notes",
 CellID->243664958],
Cell[9795, 314, 690, 14, 70, "2ColumnTableMod",
 CellID->302202177],
Cell[10488, 330, 84, 1, 70, "Notes",
 CellID->332621726],
Cell[10575, 333, 374, 9, 70, "2ColumnTableMod",
 CellID->19778572],
Cell[10952, 344, 1043, 36, 70, "Notes",
 CellID->305083431],
Cell[11998, 382, 396, 14, 70, "Notes",
 CellID->76948272],
Cell[12397, 398, 87, 1, 70, "Notes",
 CellID->848570680],
Cell[12487, 401, 1140, 23, 70, "2ColumnTableMod",
 CellID->109859610],
Cell[13630, 426, 107, 3, 70, "Notes",
 CellID->311647375],
Cell[13740, 431, 1106, 26, 70, "2ColumnTableMod",
 CellID->147057298],
Cell[14849, 459, 73, 1, 70, "Notes",
 CellID->126617740],
Cell[14925, 462, 488, 11, 70, "2ColumnTableMod",
 CellID->69550753],
Cell[15416, 475, 81, 1, 70, "Notes",
 CellID->1296392266],
Cell[15500, 478, 1006, 18, 70, "2ColumnTableMod",
 CellID->95732200],
Cell[16509, 498, 74, 1, 70, "Notes",
 CellID->149970660],
Cell[16586, 501, 689, 13, 70, "2ColumnTableMod",
 CellID->4152491],
Cell[17278, 516, 74, 1, 70, "Notes",
 CellID->465231541],
Cell[17355, 519, 1006, 18, 70, "2ColumnTableMod",
 CellID->118151164],
Cell[18364, 539, 78, 1, 70, "Notes",
 CellID->45732549],
Cell[18445, 542, 538, 11, 70, "2ColumnTableMod",
 CellID->68931504],
Cell[18986, 555, 76, 1, 70, "Notes",
 CellID->104078661],
Cell[19065, 558, 412, 10, 70, "2ColumnTableMod",
 CellID->744250446],
Cell[19480, 570, 69, 1, 70, "Notes",
 CellID->25807126],
Cell[19552, 573, 364, 9, 70, "2ColumnTableMod",
 CellID->52495961],
Cell[19919, 584, 460, 14, 70, "Notes",
 CellID->271849171],
Cell[20382, 600, 505, 11, 70, "2ColumnTableMod",
 CellID->469751789],
Cell[20890, 613, 482, 18, 70, "Notes",
 CellID->83363415],
Cell[21375, 633, 216, 8, 70, "Notes",
 CellID->94188222]
}, Closed]],
Cell[CellGroupData[{
Cell[21628, 646, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->602984239],
Cell[CellGroupData[{
Cell[22013, 660, 148, 5, 70, "ExampleSection",
 CellID->793912571],
Cell[22164, 667, 83, 1, 70, "ExampleText",
 CellID->227427165],
Cell[CellGroupData[{
Cell[22272, 672, 115, 3, 28, "Input",
 CellID->231146461],
Cell[22390, 677, 627, 19, 54, "Output",
 CellID->1351945338]
}, Open  ]],
Cell[23032, 699, 125, 3, 70, "ExampleDelimiter",
 CellID->689363353],
Cell[23160, 704, 59, 1, 70, "ExampleText",
 CellID->156939200],
Cell[CellGroupData[{
Cell[23244, 709, 158, 4, 70, "Input",
 CellID->353693390],
Cell[23405, 715, 226, 7, 36, "Output",
 CellID->1768310506]
}, Open  ]],
Cell[23646, 725, 124, 3, 70, "ExampleDelimiter",
 CellID->23357404],
Cell[23773, 730, 55, 1, 70, "ExampleText",
 CellID->175295229],
Cell[CellGroupData[{
Cell[23853, 735, 156, 4, 70, "Input",
 CellID->332739535],
Cell[24012, 741, 989, 26, 122, "Output",
 CellID->1346455575]
}, Open  ]],
Cell[25016, 770, 125, 3, 70, "ExampleDelimiter",
 CellID->529209393],
Cell[25144, 775, 52, 1, 70, "ExampleText",
 CellID->169022019],
Cell[CellGroupData[{
Cell[25221, 780, 153, 4, 70, "Input",
 CellID->621585352],
Cell[25377, 786, 858, 27, 54, "Output",
 CellID->1843660586]
}, Open  ]],
Cell[26250, 816, 125, 3, 70, "ExampleDelimiter",
 CellID->645541958],
Cell[26378, 821, 57, 1, 70, "ExampleText",
 CellID->130645779],
Cell[CellGroupData[{
Cell[26460, 826, 157, 4, 70, "Input",
 CellID->410216586],
Cell[26620, 832, 1105, 32, 88, "Output",
 CellID->220790881]
}, Open  ]],
Cell[27740, 867, 125, 3, 70, "ExampleDelimiter",
 CellID->628425659],
Cell[27868, 872, 59, 1, 70, "ExampleText",
 CellID->273690426],
Cell[CellGroupData[{
Cell[27952, 877, 158, 4, 70, "Input",
 CellID->52156434],
Cell[28113, 883, 1049, 31, 71, "Output",
 CellID->1665868005]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29211, 920, 222, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[29458, 931, 240, 7, 70, "ExampleSubsection",
 CellID->112956214],
Cell[29701, 940, 77, 1, 70, "ExampleText",
 CellID->217083626],
Cell[CellGroupData[{
Cell[29803, 945, 117, 3, 70, "Input",
 CellID->977589140],
Cell[29923, 950, 399, 13, 36, "Output",
 CellID->845358822]
}, Open  ]],
Cell[30337, 966, 125, 3, 70, "ExampleDelimiter",
 CellID->295155159],
Cell[30465, 971, 71, 1, 70, "ExampleText",
 CellID->381824890],
Cell[CellGroupData[{
Cell[30561, 976, 114, 3, 70, "Input",
 CellID->19087200],
Cell[30678, 981, 626, 19, 54, "Output",
 CellID->193912802]
}, Open  ]],
Cell[31319, 1003, 125, 3, 70, "ExampleDelimiter",
 CellID->467061439],
Cell[31447, 1008, 77, 1, 70, "ExampleText",
 CellID->150386046],
Cell[CellGroupData[{
Cell[31549, 1013, 173, 5, 70, "Input",
 CellID->579550009],
Cell[31725, 1020, 413, 13, 36, "Output",
 CellID->1359770715]
}, Open  ]],
Cell[32153, 1036, 123, 3, 70, "ExampleDelimiter",
 CellID->6963866],
Cell[32279, 1041, 81, 1, 70, "ExampleText",
 CellID->446615292],
Cell[CellGroupData[{
Cell[32385, 1046, 240, 7, 70, "Input",
 CellID->196602],
Cell[32628, 1055, 774, 18, 71, "Output",
 CellID->739851261]
}, Open  ]],
Cell[33417, 1076, 124, 3, 70, "ExampleDelimiter",
 CellID->71433135],
Cell[33544, 1081, 83, 1, 70, "ExampleText",
 CellID->750826949],
Cell[CellGroupData[{
Cell[33652, 1086, 181, 6, 70, "Input",
 CellID->75357635],
Cell[33836, 1094, 453, 11, 54, "Output",
 CellID->1499254096]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34338, 1111, 241, 7, 70, "ExampleSubsection",
 CellID->252741441],
Cell[34582, 1120, 91, 1, 70, "ExampleText",
 CellID->465474833],
Cell[CellGroupData[{
Cell[34698, 1125, 153, 4, 70, "Input",
 CellID->68272425],
Cell[34854, 1131, 1144, 34, 71, "Output",
 CellID->1537961221]
}, Open  ]],
Cell[36013, 1168, 125, 3, 70, "ExampleDelimiter",
 CellID->661029803],
Cell[36141, 1173, 115, 3, 70, "ExampleText",
 CellID->877392509],
Cell[CellGroupData[{
Cell[36281, 1180, 178, 5, 70, "Input",
 CellID->354356773],
Cell[36462, 1187, 332, 9, 36, "Output",
 CellID->1401066055]
}, Open  ]],
Cell[36809, 1199, 125, 3, 70, "ExampleDelimiter",
 CellID->628340166],
Cell[36937, 1204, 75, 1, 70, "ExampleText",
 CellID->714497797],
Cell[CellGroupData[{
Cell[37037, 1209, 178, 5, 70, "Input",
 CellID->25899539],
Cell[37218, 1216, 1619, 48, 88, "Output",
 CellID->558997030]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38886, 1270, 247, 7, 70, "ExampleSubsection",
 CellID->537525481],
Cell[CellGroupData[{
Cell[39158, 1281, 160, 4, 70, "Input",
 CellID->459442105],
Cell[39321, 1287, 574, 17, 54, "Output",
 CellID->1969611232]
}, Open  ]],
Cell[39910, 1307, 124, 3, 70, "ExampleDelimiter",
 CellID->46338052],
Cell[40037, 1312, 58, 1, 70, "ExampleText",
 CellID->316019794],
Cell[CellGroupData[{
Cell[40120, 1317, 157, 4, 70, "Input",
 CellID->136673703],
Cell[40280, 1323, 607, 18, 54, "Output",
 CellID->1943041366]
}, Open  ]],
Cell[40902, 1344, 125, 3, 70, "ExampleDelimiter",
 CellID->966160966],
Cell[CellGroupData[{
Cell[41052, 1351, 157, 4, 70, "Input",
 CellID->470208393],
Cell[41212, 1357, 553, 17, 36, "Output",
 CellID->2059902080]
}, Open  ]],
Cell[41780, 1377, 125, 3, 70, "ExampleDelimiter",
 CellID->863234405],
Cell[CellGroupData[{
Cell[41930, 1384, 157, 4, 70, "Input",
 CellID->544919711],
Cell[42090, 1390, 555, 17, 54, "Output",
 CellID->1822395662]
}, Open  ]],
Cell[42660, 1410, 125, 3, 70, "ExampleDelimiter",
 CellID->125218664],
Cell[CellGroupData[{
Cell[42810, 1417, 160, 4, 70, "Input",
 CellID->111183368],
Cell[42973, 1423, 944, 26, 71, "Output",
 CellID->1592117720]
}, Open  ]],
Cell[43932, 1452, 124, 3, 70, "ExampleDelimiter",
 CellID->75432370],
Cell[CellGroupData[{
Cell[44081, 1459, 159, 4, 70, "Input",
 CellID->814515032],
Cell[44243, 1465, 1021, 28, 88, "Output",
 CellID->1076278420]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45313, 1499, 242, 7, 70, "ExampleSubsection",
 CellID->390865844],
Cell[45558, 1508, 181, 6, 70, "ExampleText",
 CellID->98520218],
Cell[CellGroupData[{
Cell[45764, 1518, 158, 4, 70, "Input",
 CellID->340093129],
Cell[45925, 1524, 836, 24, 54, "Output",
 CellID->685823727]
}, Open  ]],
Cell[46776, 1551, 125, 3, 70, "ExampleDelimiter",
 CellID->221307100],
Cell[46904, 1556, 80, 1, 70, "ExampleText",
 CellID->308081907],
Cell[CellGroupData[{
Cell[47009, 1561, 161, 4, 70, "Input",
 CellID->412831473],
Cell[47173, 1567, 171, 5, 36, "Output",
 CellID->448466545]
}, Open  ]],
Cell[CellGroupData[{
Cell[47381, 1577, 149, 4, 70, "Input",
 CellID->43709220],
Cell[47533, 1583, 170, 5, 36, "Output",
 CellID->490524709]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47752, 1594, 255, 7, 70, "ExampleSubsection",
 CellID->117310012],
Cell[48010, 1603, 74, 1, 70, "ExampleText",
 CellID->261208603],
Cell[CellGroupData[{
Cell[48109, 1608, 168, 5, 70, "Input",
 CellID->676416153],
Cell[48280, 1615, 287, 8, 36, "Output",
 CellID->1693440997]
}, Open  ]],
Cell[48582, 1626, 125, 3, 70, "ExampleDelimiter",
 CellID->615010760],
Cell[48710, 1631, 69, 1, 70, "ExampleText",
 CellID->721919778],
Cell[CellGroupData[{
Cell[48804, 1636, 160, 4, 70, "Input",
 CellID->10890902],
Cell[48967, 1642, 199, 5, 36, "Output",
 CellID->336002371]
}, Open  ]],
Cell[49181, 1650, 125, 3, 70, "ExampleDelimiter",
 CellID->240531738],
Cell[49309, 1655, 55, 1, 70, "ExampleText",
 CellID->512821730],
Cell[CellGroupData[{
Cell[49389, 1660, 158, 4, 70, "Input",
 CellID->206613040],
Cell[49550, 1666, 169, 5, 36, "Output",
 CellID->1457341434]
}, Open  ]],
Cell[49734, 1674, 125, 3, 70, "ExampleDelimiter",
 CellID->381277181],
Cell[49862, 1679, 70, 1, 70, "ExampleText",
 CellID->1404964286],
Cell[CellGroupData[{
Cell[49957, 1684, 182, 5, 70, "Input",
 CellID->1289741796],
Cell[50142, 1691, 335, 9, 36, "Output",
 CellID->1486487203]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[50526, 1706, 245, 7, 70, "ExampleSubsection",
 CellID->73280521],
Cell[50774, 1715, 71, 1, 70, "ExampleText",
 CellID->1821926092],
Cell[CellGroupData[{
Cell[50870, 1720, 179, 5, 70, "Input",
 CellID->142505671],
Cell[51052, 1727, 377, 9, 36, "Output",
 CellID->2065039092]
}, Open  ]],
Cell[51444, 1739, 125, 3, 70, "ExampleDelimiter",
 CellID->811076316],
Cell[51572, 1744, 59, 1, 70, "ExampleText",
 CellID->271077820],
Cell[CellGroupData[{
Cell[51656, 1749, 178, 5, 70, "Input",
 CellID->884169519],
Cell[51837, 1756, 352, 10, 36, "Output",
 CellID->979250100]
}, Open  ]],
Cell[52204, 1769, 124, 3, 70, "ExampleDelimiter",
 CellID->13126146],
Cell[52331, 1774, 93, 1, 70, "ExampleText",
 CellID->465369],
Cell[CellGroupData[{
Cell[52449, 1779, 189, 6, 70, "Input",
 CellID->141898184],
Cell[52641, 1787, 193, 6, 36, "Output",
 CellID->687234511]
}, Open  ]],
Cell[52849, 1796, 123, 3, 70, "ExampleDelimiter",
 CellID->8627192],
Cell[52975, 1801, 74, 1, 70, "ExampleText",
 CellID->31463713],
Cell[CellGroupData[{
Cell[53074, 1806, 185, 6, 70, "Input",
 CellID->92751508],
Cell[53262, 1814, 385, 10, 36, "Output",
 CellID->231286365]
}, Open  ]],
Cell[53662, 1827, 124, 3, 70, "ExampleDelimiter",
 CellID->51701123],
Cell[53789, 1832, 75, 1, 70, "ExampleText",
 CellID->12784552],
Cell[CellGroupData[{
Cell[53889, 1837, 187, 6, 70, "Input",
 CellID->399866883],
Cell[54079, 1845, 505, 12, 54, "Output",
 CellID->741189069]
}, Open  ]],
Cell[CellGroupData[{
Cell[54621, 1862, 188, 6, 70, "Input",
 CellID->37095554],
Cell[54812, 1870, 315, 9, 36, "Output",
 CellID->621013002]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55176, 1885, 235, 7, 70, "ExampleSubsection",
 CellID->7947778],
Cell[55414, 1894, 220, 8, 70, "ExampleText",
 CellID->175571998],
Cell[CellGroupData[{
Cell[55659, 1906, 139, 4, 70, "Input",
 CellID->261017046],
Cell[55801, 1912, 164, 5, 36, "Output",
 CellID->1484400126]
}, Open  ]],
Cell[55980, 1920, 124, 3, 70, "ExampleDelimiter",
 CellID->56986158],
Cell[56107, 1925, 71, 1, 70, "ExampleText",
 CellID->7718816],
Cell[CellGroupData[{
Cell[56203, 1930, 149, 4, 70, "Input",
 CellID->223737561],
Cell[56355, 1936, 425, 11, 54, "Output",
 CellID->995390483]
}, Open  ]],
Cell[56795, 1950, 125, 3, 70, "ExampleDelimiter",
 CellID->520710420],
Cell[56923, 1955, 202, 8, 70, "ExampleText",
 CellID->157205259],
Cell[CellGroupData[{
Cell[57150, 1967, 174, 5, 70, "Input",
 CellID->703838843],
Cell[57327, 1974, 162, 5, 36, "Output",
 CellID->630237651]
}, Open  ]],
Cell[57504, 1982, 124, 3, 70, "ExampleDelimiter",
 CellID->35835138],
Cell[57631, 1987, 206, 8, 70, "ExampleText",
 CellID->30822464],
Cell[CellGroupData[{
Cell[57862, 1999, 180, 6, 70, "Input",
 CellID->2053792804],
Cell[58045, 2007, 498, 13, 36, "Output",
 CellID->1014853353]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[58604, 2027, 244, 7, 70, "ExampleSection",
 CellID->1020263627],
Cell[58851, 2036, 125, 3, 70, "ExampleText",
 CellID->976019072],
Cell[CellGroupData[{
Cell[59001, 2043, 165, 5, 70, "Input",
 CellID->551074242],
Cell[59169, 2050, 174, 5, 36, "Output",
 CellID->595000194]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59392, 2061, 228, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[59623, 2070, 69, 1, 70, "ExampleText",
 CellID->194427009],
Cell[CellGroupData[{
Cell[59717, 2075, 294, 9, 70, "Input",
 CellID->123070782],
Cell[60014, 2086, 1292, 36, 88, "Output",
 CellID->1325179397]
}, Open  ]],
Cell[61321, 2125, 124, 3, 70, "ExampleDelimiter",
 CellID->90525123],
Cell[61448, 2130, 96, 1, 70, "ExampleText",
 CellID->41652639],
Cell[CellGroupData[{
Cell[61569, 2135, 262, 8, 70, "Input",
 CellID->624687263],
Cell[61834, 2145, 567, 16, 54, "Output",
 CellID->737222342]
}, Open  ]],
Cell[62416, 2164, 124, 3, 70, "ExampleDelimiter",
 CellID->92542013],
Cell[62543, 2169, 95, 1, 70, "ExampleText",
 CellID->203334483],
Cell[CellGroupData[{
Cell[62663, 2174, 178, 5, 70, "Input",
 CellID->17944289],
Cell[62844, 2181, 811, 16, 71, "Output",
 CellID->1662742451]
}, Open  ]],
Cell[63670, 2200, 125, 3, 70, "ExampleDelimiter",
 CellID->217327565],
Cell[63798, 2205, 133, 4, 70, "ExampleText",
 CellID->318841992],
Cell[CellGroupData[{
Cell[63956, 2213, 428, 13, 70, "Input",
 CellID->80363179],
Cell[64387, 2228, 453, 13, 36, "Output",
 CellID->507675546]
}, Open  ]],
Cell[64855, 2244, 93, 1, 70, "ExampleText",
 CellID->266302749],
Cell[CellGroupData[{
Cell[64973, 2249, 468, 14, 70, "Input",
 CellID->63024582],
Cell[65444, 2265, 328, 10, 36, "Output",
 CellID->550372091]
}, Open  ]],
Cell[CellGroupData[{
Cell[65809, 2280, 107, 3, 70, "Input",
 CellID->385655446],
Cell[65919, 2285, 1014, 21, 70, "Output",
 Evaluatable->False,
 CellID->427341516]
}, Open  ]],
Cell[66948, 2309, 72, 1, 70, "ExampleText",
 CellID->98299757],
Cell[CellGroupData[{
Cell[67045, 2314, 468, 14, 70, "Input",
 CellID->70110596],
Cell[67516, 2330, 302, 9, 36, "Output",
 CellID->1086346290]
}, Open  ]],
Cell[67833, 2342, 123, 3, 70, "ExampleDelimiter",
 CellID->2800472],
Cell[67959, 2347, 88, 1, 70, "ExampleText",
 CellID->55751679],
Cell[CellGroupData[{
Cell[68072, 2352, 393, 12, 70, "Input",
 CellID->27097597],
Cell[68468, 2366, 526, 14, 54, "Output",
 CellID->316129236]
}, Open  ]],
Cell[69009, 2383, 99, 1, 70, "ExampleText",
 CellID->217005960],
Cell[CellGroupData[{
Cell[69133, 2388, 474, 14, 70, "Input",
 CellID->966833327],
Cell[69610, 2404, 325, 9, 36, "Output",
 CellID->309526774]
}, Open  ]],
Cell[69950, 2416, 125, 3, 70, "ExampleDelimiter",
 CellID->174557673],
Cell[70078, 2421, 75, 1, 70, "ExampleText",
 CellID->537995249],
Cell[CellGroupData[{
Cell[70178, 2426, 176, 5, 70, "Input",
 CellID->39400112],
Cell[70357, 2433, 461, 13, 36, "Output",
 CellID->1011097584]
}, Open  ]],
Cell[70833, 2449, 69, 1, 70, "ExampleText",
 CellID->285303750],
Cell[CellGroupData[{
Cell[70927, 2454, 225, 8, 70, "Input",
 CellID->912250640],
Cell[71155, 2464, 601, 14, 36, "Output",
 CellID->478995577]
}, Open  ]],
Cell[71771, 2481, 125, 3, 70, "ExampleDelimiter",
 CellID->473362358],
Cell[71899, 2486, 149, 4, 70, "ExampleText",
 CellID->472929186],
Cell[CellGroupData[{
Cell[72073, 2494, 496, 16, 70, "Input",
 CellID->67030175],
Cell[72572, 2512, 739, 25, 54, "Output",
 CellID->1634840794]
}, Open  ]],
Cell[CellGroupData[{
Cell[73348, 2542, 217, 6, 70, "Input",
 CellID->930418894],
Cell[73568, 2550, 2340, 42, 70, "Output",
 Evaluatable->False,
 CellID->415685]
}, Open  ]],
Cell[75923, 2595, 124, 3, 70, "ExampleDelimiter",
 CellID->21729540],
Cell[76050, 2600, 81, 1, 70, "ExampleText",
 CellID->71655157],
Cell[CellGroupData[{
Cell[76156, 2605, 529, 15, 70, "Input",
 CellID->138762527],
Cell[76688, 2622, 1329, 36, 176, "Output",
 CellID->19279432]
}, Open  ]],
Cell[78032, 2661, 124, 3, 70, "ExampleDelimiter",
 CellID->35856993],
Cell[78159, 2666, 95, 1, 70, "ExampleText",
 CellID->354227258],
Cell[CellGroupData[{
Cell[78279, 2671, 870, 24, 70, "Input",
 CellID->505445604],
Cell[79152, 2697, 4803, 83, 70, "Output",
 Evaluatable->False,
 CellID->94949212]
}, Open  ]],
Cell[83970, 2783, 124, 3, 70, "ExampleDelimiter",
 CellID->24446713],
Cell[84097, 2788, 85, 1, 70, "ExampleText",
 CellID->48984376],
Cell[CellGroupData[{
Cell[84207, 2793, 728, 21, 70, "Input",
 CellID->137799795],
Cell[84938, 2816, 47137, 777, 70, "Output",
 Evaluatable->False,
 CellID->84017153]
}, Open  ]],
Cell[132090, 3596, 125, 3, 70, "ExampleDelimiter",
 CellID->129863368],
Cell[132218, 3601, 136, 4, 70, "ExampleText",
 CellID->378883310],
Cell[CellGroupData[{
Cell[132379, 3609, 155, 4, 70, "Input",
 CellID->119514828],
Cell[132537, 3615, 275, 8, 36, "Output",
 CellID->919331809]
}, Open  ]],
Cell[CellGroupData[{
Cell[132849, 3628, 573, 18, 70, "Input",
 CellID->28317143],
Cell[133425, 3648, 359, 10, 54, "Output",
 CellID->64873698]
}, Open  ]],
Cell[133799, 3661, 124, 3, 70, "ExampleDelimiter",
 CellID->60587660],
Cell[133926, 3666, 95, 1, 70, "ExampleText",
 CellID->44473490],
Cell[CellGroupData[{
Cell[134046, 3671, 398, 11, 70, "Input",
 CellID->765290704],
Cell[134447, 3684, 214, 6, 36, "Output",
 CellID->1558033257]
}, Open  ]],
Cell[134676, 3693, 125, 3, 70, "ExampleDelimiter",
 CellID->398596440],
Cell[134804, 3698, 133, 4, 70, "ExampleText",
 CellID->465761161],
Cell[CellGroupData[{
Cell[134962, 3706, 1091, 35, 70, "Input",
 CellID->60579176],
Cell[136056, 3743, 1365, 37, 71, "Output",
 CellID->1596842528]
}, Open  ]],
Cell[137436, 3783, 125, 3, 70, "ExampleDelimiter",
 CellID->260333284],
Cell[137564, 3788, 79, 1, 70, "ExampleText",
 CellID->42703846],
Cell[CellGroupData[{
Cell[137668, 3793, 212, 7, 70, "Input",
 CellID->5999479],
Cell[137883, 3802, 478, 11, 54, "Output",
 CellID->1029231537]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[138410, 3819, 238, 7, 70, "ExampleSection",
 CellID->1865233658],
Cell[138651, 3828, 235, 8, 70, "ExampleText",
 CellID->80449310],
Cell[CellGroupData[{
Cell[138911, 3840, 131, 4, 70, "Input",
 CellID->39619825],
Cell[139045, 3846, 163, 5, 36, "Output",
 CellID->313665774]
}, Open  ]],
Cell[139223, 3854, 124, 3, 70, "ExampleDelimiter",
 CellID->88162903],
Cell[139350, 3859, 91, 1, 70, "ExampleText",
 CellID->213782465],
Cell[CellGroupData[{
Cell[139466, 3864, 156, 4, 70, "Input",
 CellID->172279774],
Cell[139625, 3870, 358, 11, 36, "Output",
 CellID->1855793880]
}, Open  ]],
Cell[CellGroupData[{
Cell[140020, 3886, 157, 4, 70, "Input",
 CellID->21268095],
Cell[140180, 3892, 551, 17, 36, "Output",
 CellID->275252132]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[140780, 3915, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[141014, 3924, 360, 12, 70, "ExampleText",
 CellID->103252936],
Cell[CellGroupData[{
Cell[141399, 3940, 121, 3, 70, "Input",
 CellID->501756862],
Cell[141523, 3945, 286, 9, 36, "Output",
 CellID->482806886]
}, Open  ]],
Cell[CellGroupData[{
Cell[141846, 3959, 129, 3, 70, "Input",
 CellID->633052197],
Cell[141978, 3964, 176, 6, 36, "Output",
 CellID->1342114636]
}, Open  ]],
Cell[142169, 3973, 125, 3, 70, "ExampleDelimiter",
 CellID->174456079],
Cell[142297, 3978, 369, 13, 70, "ExampleText",
 CellID->659707307],
Cell[CellGroupData[{
Cell[142691, 3995, 155, 4, 70, "Input",
 CellID->281988465],
Cell[142849, 4001, 416, 11, 71, "Output",
 CellID->1899942811]
}, Open  ]],
Cell[CellGroupData[{
Cell[143302, 4017, 122, 3, 70, "Input",
 CellID->228158085],
Cell[143427, 4022, 176, 6, 36, "Output",
 CellID->1404477234]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[143652, 4034, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[143883, 4043, 260, 8, 70, "ExampleText",
 CellID->31339309],
Cell[CellGroupData[{
Cell[144168, 4055, 327, 10, 70, "Input",
 CellID->86206902],
Cell[144498, 4067, 1636, 31, 70, "Output",
 Evaluatable->False,
 CellID->476686480]
}, Open  ]],
Cell[146149, 4101, 125, 3, 70, "ExampleDelimiter",
 CellID->166862061],
Cell[146277, 4106, 115, 3, 70, "ExampleText",
 CellID->73247082],
Cell[CellGroupData[{
Cell[146417, 4113, 149, 4, 70, "Input",
 CellID->331653800],
Cell[146569, 4119, 677, 13, 36, "Output",
 CellID->1842094550]
}, Open  ]],
Cell[CellGroupData[{
Cell[147283, 4137, 212, 8, 70, "Input",
 CellID->842004076],
Cell[147498, 4147, 1434, 33, 54, "Output",
 CellID->1958846698]
}, Open  ]],
Cell[CellGroupData[{
Cell[148969, 4185, 292, 9, 70, "Input",
 CellID->294404571],
Cell[149264, 4196, 1442, 30, 142, "Output",
 CellID->1412144776]
}, Open  ]],
Cell[150721, 4229, 125, 3, 70, "ExampleDelimiter",
 CellID->394492769],
Cell[150849, 4234, 250, 8, 70, "ExampleText",
 CellID->395599705],
Cell[CellGroupData[{
Cell[151124, 4246, 394, 13, 70, "Input",
 CellID->97984396],
Cell[151521, 4261, 408, 10, 36, "Output",
 CellID->2075467235]
}, Open  ]],
Cell[151944, 4274, 83, 1, 70, "ExampleText",
 CellID->12015132],
Cell[CellGroupData[{
Cell[152052, 4279, 180, 6, 70, "Input",
 CellID->9138742],
Cell[152235, 4287, 301, 9, 36, "Output",
 CellID->800940424]
}, Open  ]],
Cell[152551, 4299, 125, 3, 70, "ExampleDelimiter",
 CellID->313371167],
Cell[152679, 4304, 261, 8, 70, "ExampleText",
 CellID->81200459],
Cell[CellGroupData[{
Cell[152965, 4316, 345, 11, 70, "Input",
 CellID->23527315],
Cell[153313, 4329, 877, 25, 71, "Output",
 CellID->978206772]
}, Open  ]],
Cell[154205, 4357, 124, 3, 70, "ExampleDelimiter",
 CellID->72866180],
Cell[154332, 4362, 125, 3, 70, "ExampleText",
 CellID->47970571],
Cell[CellGroupData[{
Cell[154482, 4369, 451, 15, 70, "Input",
 CellID->203934446],
Cell[154936, 4386, 293, 8, 36, "Output",
 CellID->1733899219]
}, Open  ]],
Cell[CellGroupData[{
Cell[155266, 4399, 222, 8, 70, "Input",
 CellID->314072167],
Cell[155491, 4409, 1317, 30, 105, "Output",
 CellID->291083943]
}, Open  ]],
Cell[156823, 4442, 125, 3, 70, "ExampleDelimiter",
 CellID->514367062],
Cell[156951, 4447, 141, 4, 70, "ExampleText",
 CellID->742720665],
Cell[CellGroupData[{
Cell[157117, 4455, 951, 27, 70, "Input",
 CellID->63748116],
Cell[158071, 4484, 7361, 125, 70, "Output",
 Evaluatable->False,
 CellID->36084856]
}, Open  ]],
Cell[165447, 4612, 125, 3, 70, "ExampleDelimiter",
 CellID->170180374],
Cell[165575, 4617, 98, 1, 70, "ExampleText",
 CellID->477122470],
Cell[CellGroupData[{
Cell[165698, 4622, 579, 17, 70, "Input",
 CellID->825506999],
Cell[166280, 4641, 286679, 5835, 70, "Output",
 CellID->670986055]
}, Open  ]],
Cell[452974, 10479, 124, 3, 70, "ExampleDelimiter",
 CellID->23179572]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[453147, 10488, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[453466, 10499, 216, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[453719, 10510, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[454040, 10521, 299, 9, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[454376, 10535, 326, 9, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[454705, 10546, 231, 5, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[454973, 10556, 299, 8, 70, "MoreAboutSection"],
Cell[455275, 10566, 150, 3, 70, "MoreAbout",
 CellID->535999155],
Cell[455428, 10571, 185, 3, 70, "MoreAbout",
 CellID->556530645]
}, Open  ]],
Cell[455628, 10577, 27, 0, 70, "History"],
Cell[455658, 10579, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

