(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     76325,       2279]
NotebookOptionsPosition[     67196,       1961]
NotebookOutlinePosition[     68713,       2002]
CellTagsIndexPosition[     68627,       1997]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Integration" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalIntegration"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Numerical Integration\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PrecisionGoal" :> 
          Documentation`HelpLookup["paclet:ref/PrecisionGoal"], 
          "AccuracyGoal" :> 
          Documentation`HelpLookup["paclet:ref/AccuracyGoal"], "Precision" :> 
          Documentation`HelpLookup["paclet:ref/Precision"], "Accuracy" :> 
          Documentation`HelpLookup["paclet:ref/Accuracy"], "N" :> 
          Documentation`HelpLookup["paclet:ref/N"], "Tolerance" :> 
          Documentation`HelpLookup["paclet:ref/Tolerance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PrecisionGoal\"\>", 
       2->"\<\"AccuracyGoal\"\>", 3->"\<\"Precision\"\>", 
       4->"\<\"Accuracy\"\>", 5->"\<\"N\"\>", 
       6->"\<\"Tolerance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Differential Equations" :> 
          Documentation`HelpLookup["paclet:guide/DifferentialEquations"], 
          "Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"], 
          "Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Differential Equations\"\>", 
       2->"\<\"Precision & Accuracy Control\"\>", 
       3->"\<\"Time Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WorkingPrecision", "ObjectName",
 CellID->23588],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WorkingPrecision",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
     "\[LineSeparator]is an option for various numerical operations which \
specifies how many digits of precision should be maintained in internal \
computations. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12558]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " is an option for such functions as ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31053],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{"WorkingPrecision", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " causes all internal computations to be done to at most ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]digit precision. "
}], "Notes",
 CellID->15945],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{"WorkingPrecision", "->", 
   ButtonBox["MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MachinePrecision"]}]], "InlineFormula"],
 " causes all internal computations to be done with machine numbers. "
}], "Notes",
 CellID->32283],

Cell[TextData[{
 "Even if internal computations are done to ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]digit precision, the final results you get may have much lower \
precision. "
}], "Notes",
 CellID->6792]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->93549178],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->256768543],

Cell["Find a root using 60-digit precision arithmetic:", "ExampleText",
 CellID->355726784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "60"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153300602],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", "\[Rule]", 
   "1.414213562373095048801688724209698078569671875376948073176679737990732478\
46211`60."}], "}"}]], "Output",
 ImageSize->{468, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->334120070]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->68337929],

Cell["\<\
Solve a differential equation using 24-digit precision arithmetic:\
\>", "ExampleText",
 CellID->96603029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"t", "^", "2"}]}], ")"}]}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "50"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "24"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62310160],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0", ",", "50.`24."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{463, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->455014605]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], "/.", "%"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->67446159],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->462502856]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4314],

Cell["Evaluate the function using 24-digit precision arithmetic:", \
"ExampleText",
 CellID->638103999],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "?", "NumberQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "/", "2"}], "+", 
   RowBox[{"Cos", "[", "x", "]"}], "-", "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132060302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.0001"}], ",", "0.0001"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "24"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->388952760],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw11GdUU2ccBvAQISAbZCQXRSAxggLBMALc17wKRVYFkqsItA5AUwfIARXQ
oowqKUNxV1BCtCwHRURRVt7AwYH2WERaZClSo9gIsiRYJPT2nPbD//zP78vz
7XlsYxKEO6gUCiWEvH//Vbl9z5AHhtg3Oo/Z8giASR317nMxRHtQd8Z0JQFy
011WVzhjKGFNdOjCpQSI43te3sPGkPTh20fa2gRwafLfNWWOoTXDz04HdAtB
3V3RZ61PDPTUhzrVnSoErb+UMhxqGYh7UJhjKxeA3ks2UQkcBmrcvK97bksY
sB6vetVpQkcmTJ39J8KCgasgqpapbYm4F04JI4fWgd68K03VGhZIT/QyxdnC
F5zlZzw2fWuGWtylvc76ECydS2PHDixCimr3QI8IL9DsaiTOlZmisLR3G89Z
uoEPX61eMlJqgpxqJedL8zngQ3SuxmqJMaoPOVyU9NweqEd6uh5SjRAe1EaR
d9iBB5wBn7FRfSSI5BOaRxeDGjZ9cYFCF0mV59xKgs1Bq8ERdV+1DuooX+g5
72UIDujbHV4gpaG6Uwd4BoQWCJkd0+yJ1URxLV/zrO2+4EElKhWLS0UatO9l
x7rH8eEoIA5mU9CpcG7FftZbPNwgAq7pn5Wlp2/VevPDC9zmbG2l5K5KpnzM
fjmP2nGP2e2sSO9J2fqjZVAI63BWod4IpXREFj8+/DpuZwm+vciP2rBbIfsz
q1/KXJqJp94LTw2n9MgmOtOcmp+E4nETyy5Z3ZbLEqs/17A2vfdu3/frQush
xA/c69JuRlN4K2su59yo6uGr66+Nz90U4Mq2hE1qhoJvfd8rWWKXgQeMxfjt
NRzlF/Q1uOYXSfHjP+O+WXGTfKckrUC9lXfxWyWBK+nZKv7mIumOHOUjPK9R
Q0M4M8uPxnZf9Hv3Ajfusg7dY0SB/r45nTqVCpxnfozLo1NhSmxm2/WkcdxT
JNffuF4T7n/+fKqifBb/qaQ56MK3NLiC5y0KiNQEHcMF6U4XdGCK2s3h2gMD
8B3Gog9X6UKrogp2erEZ6Duf4edYrw+ZrRtNv7llBRyYt3a1jhlCQsMy36HM
DiifdM7wM40hUawSTy+3B86GvHt+UhO4N7HsyM49HDB4YH6tSYMprOSgunhN
N9DyrPLwR/kiqC0rFHs98gQFd5puTw+YwZYttfcZ/XyQf7ym2HjYHI6+6h1V
NPsAVa6u4OMHC3g2yz978NA6EGr8dH5amw594sVR75nB4I+cpG0mxgzIGlj+
hWYYBoLyMps2OGNw+52ZMLo1AWzsp6aSSaceFPulkf7UJnIqJE1dJcEHSUvV
wZIB0j/mxjpWkv2bTrTIEHEwGLMpxMbTlgBXIq77prpgcOxFhSCCRYC/l/3+
+CIXg+WZ2b2FKwjQ0eq/QEY6LdmKoiZdtrUBHySteOm5PIbsd1hhyQ2WKwaz
MYNDKxwJUK6/+0QVabMqK26jEwGEk2oBcsNgsbxL2e9CAPuTibmvSYt/m3BY
u4oAc45vWhe4Y9DqdOGuMtKVonbXANLhPpkj8VwCqHvOmD8jzUP12vOuBOhK
poVMkm7qWyKMdSPA1UUHs809MDjzRFfykPSG9VtUkaSreOneJ90J4PBXByeN
9LJGWt4UaXW2704J6W12lgMRHmQes04qJx2deNOlmfR/ewb/37N/AHyvIvw=

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.0001, 0.0001}, {0., 4.166665985005712*^-18}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->593061569]
}, Open  ]],

Cell["\<\
Without higher precision you see mainly numerical roundoff error:\
\>", "ExampleText",
 CellID->610669315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "0.0001"}], ",", "0.0001"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->350069900],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw11H8w22ccB/Cv0DL1I6EhtNN0wskVUVmx9sE2czVayvxq6toqTVtyyzCq
HRo/I5EIt94aXRep2RpbM0OH2lPSnFqZrupsa5gbbtbc/KiRih/XdHm+X/vj
ued53fvz+fzx/PHZe4afcJaEYVis+aC7ReOjmwly7zM/yTMPRNBd6bvjQSBu
wXxePhRfCQi95U9Y8jgJ8sJCbmZ748byC/gwAB6+YKDiVgUdEYHOLu76thdu
+DzXwVyg/a7ZjdmB22D4oA6M36Bz+Czca1VVFdDjX/WfoxQa8lSRSQjZ8ZwO
T2tXfL5N2SUwXtMEWy1c8H6WZSm4GiYYcvp7J/LHiQlisOdlkXfGpDMyPXGE
A+6xHYXiXie8P5LHhfPvhb6+0ExBzhzeL4Xz6WKLUAUZmfeoTgJNC7qxn0iO
yB9dLq0AA6zJd5cW7ZAvP9otgW3etN2yWVtkWj2nBGrtS0wTrTbI2o0kCcy3
e6PYUrkdecN+VgpiN5esdBlWyNLH1WIY3Wg0MgJJyM/SjlUCPQcIY7wxZO6A
Jhcm26eGv/3HZi/6zu4GAaRf7VApuoxmC/b67BGDoM1MxvGDKygvpn4jA4yG
HQtY8wLKb6XXZ4PM65GknqxZ5H1N5SmgsDu5MBnTma2ZHU/nQd6y141ddzRm
c+kxHCkczBt+zWOmLwwTtDfFkirgXNtN0W21LgzD5CetFbVwrp+fYnKbNft7
7S5SLYhaOhP5ocOi2RjzbrEQSr88FFHGWzFbMJx3TQDaG9/fR6syorwl7kQF
qPnRwiJhbRP5fsuBckge84jLdsTCzQbMdS4MplYGBtNIyItZFtUghKuxSzpq
hezip6mB1xrvRcvTtiNvu5hTCUf0sit+chvkg0MqGTjnzqDp1bbItE/kWWDi
M0Gk7107ZMF5jzTA9Gy/oF1yQB5lrkvB3M+ja2GlZOQj3joh9HcI7o5UUpCL
FBPlcCr/1TuUHifkpXPhQnD/iar4ucYZWT/NLoGyH+Cd1cmdyGTbaD6QSNu+
IOupyNiylAWNYtv45/MuuIueJYE48i+vVq1pyE8BFIHfRLmnKWQ3PK/UARBd
UwoT/d2R6/KWcyHdx2AoIKxPGSiFL/q5fg2ElUuDQqg0xSgmCXfXGyRwNcdF
wGXhpnu1XoRNqd9GFAYQ9f3q02DD69ehzwNx02qTasCI9rBlL+EQj7ck4KtT
PYemCGvYXBk41tB4m8HG/ZScUQ6/tsuqVRNWpZZLYcKKKb7vTdwC199PQZ+6
HPE0YUaZpg689P1La3kA99S0JBeouIPsKMLycbUMmHSfUp8Q7iZTquFYwfbY
FcI0UpcMtDhfqqIG4Y66/lAEEo+eNB4nTD7xsAIw/xlhFRGWl3dWAlNVxHnF
lvcvVoMxz06lZqv+LL8WbO2z8P/32X/ludxV
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.0001, 0.0001}, {-5.311254899385537*^-17, 
   5.812012603254499*^-17}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->111129789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->613266022],

Cell["Approximate an integral using 24digit precision arithmetic:", \
"ExampleText",
 CellID->265521470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "24"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->268941417],

Cell[BoxData["2.03480531920756973795707344832202333729`24."], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->565572049]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " is automatically increased to be 10 less than the working precision:"
}], "ExampleText",
 CellID->560572263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "24"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "14"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->275445510],

Cell[BoxData["2.03480531920756973795707344832202333729`24."], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->432552991]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146720858],

Cell["\<\
Find a minimum of a function adaptively increasing the precision up to 50 \
digits:\
\>", "ExampleText",
 CellID->141021113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", "y"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "1."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "1."}], "}"}]}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "50"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->823118436],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "-", "1.9999999999999999999999999999999999999999999999999999999951168474085\
`50."}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
     "x", "\[Rule]", 
      "2.3850641559995650445220109084795087966220096363348647427340596051426`\
50."}], ",", 
     RowBox[{
     "y", "\[Rule]", 
      "1.9329373845356352289736251799019560942857173972983799119230567638872`\
50."}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{412, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153178253]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AccuracyGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AccuracyGoal"], " "}]], "InlineFormula"],
 "are automatically set to be half the final precision:"
}], "ExampleText",
 CellID->344383014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", "y"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "1."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "1."}], "}"}]}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "50"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "25"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "25"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->526706080],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "-", "1.9999999999999999999999999999999999999999999999999999999951168474085\
`50."}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
     "x", "\[Rule]", 
      "2.3850641559995650445220109084795087966220096363348647427340596051426`\
50."}], ",", 
     RowBox[{
     "y", "\[Rule]", 
      "1.9329373845356352289736251799019560942857173972983799119230567638872`\
50."}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{412, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->262226395]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41448738],

Cell["\<\
Solve a differential equation with 32-digit precision arithmetic:\
\>", "ExampleText",
 CellID->339165064],

Cell[BoxData[
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",",
      "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "32"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->150026921],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " are set to be half of the working precision:"
}], "ExampleText",
 CellID->158725439],

Cell[BoxData[
 RowBox[{
  RowBox[{"sap", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",",
      "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "32"}], ",", 
     RowBox[{"PrecisionGoal", "\[Rule]", "16"}], ",", 
     RowBox[{"AccuracyGoal", "\[Rule]", "16"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->335953770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "[", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "/.", "sol"}], "]"}], ",", 
       RowBox[{"First", "[", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "/.", "sap"}], "]"}]}], "}"}], "-", 
     RowBox[{"Cos", "[", "t", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "24"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->74313144],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->232774045]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InterpolationOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolationOrder"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " will reduce the errors between steps:"
}], "ExampleText",
 CellID->750622894],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sall", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",",
      "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "32"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"First", "[", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "/.", "sall"}], "]"}], "-", 
     RowBox[{"Cos", "[", "t", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "24"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->913918394],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzns0lGkAx/FBrMbUGrnUiDEzKiRTnVNx9sn7RMtKWpF1W8pMO5VIbGPc
wsEeNE0cY3OrJpdIQrOHLebBYIhxfbPKhBRmHUVraUr3ffeP3/mdz39fBifK
5xdtEon0I7H//3oyR2/XSaHzX/plWyqyr6GI/fzId/QizNQxpjTJvwmNfDyd
v0SvxhaWVx1L8u6hb8anty3SmzAbFUl3ZX09KlVKol/RezFxfLm43LUa1dVn
j0c4PMXMih96z3XWoVMYXrQQM4O1JDg3s+dr0Dm17UxD3TzWC82UgefLEJmR
sW3KcQlTjPEV8fNCdMWwz670xAr2rUN0+HZhIeCMH2vT6X+L7ZpcjKGe/wNE
d2VworZ9wJ54ZspSM9qA9DzFd6PHZyxsh0N4ub4clCaefbnTnwRpsem3a/rk
IE3y6eibBS3YKFVUk7TbAWnkOUQJOnCTQHXT+4ocbL3AiztmpwuvR6bkHAhs
BbOagp8MWvSgS7bZomtAMzikDr+YF60Py9nJAai6ARyZzd1uaUmGO23umKDd
teBlJye1p9YA0l5zZC19N4ED9bGF6/F18Mzaq9MG6hhAxjRhEyvr4a0EsfVz
9wLkvhj0julnCGd3U0altXVorOOkVpA9Fd7fLUhnT7agxixFqJWGCnXJ9LV7
Nncjni7/+eCgEdSEXpAfjB9A3JjERkrxBlhye0XAzBpC7FPbBw+HGcPFyQ9d
I5JBNGRkb8B3MoGrM3rxhr4DSFaXVmKvYwrLXAwiHFqUKFHLzrt/0hQ6uTV7
5VV0I/JEwg/nGszgVPf3NcUX25G6kpEvSdoInwWijlHFfZRvs2lNk98m6J7I
pj27UYFyi3kPw6xo0GZea1b2cyIIyg8ZpMzRIOVZCsS8a8DqwVvvJa3mMIXX
uo/u3wxm1C5xHZmbocbr17behg5Qtn+X+UCYBbQtUGmol5Wg9jc+9dQOS1hD
E7d/8sVBph/XU0djCYPlArdU8ijYM1FanTlAh+HCL4Xul8dAoW1J7YCnFQxJ
1w41GX0KUuSiQs8mK6jjtu94JWUCeJn73VJaM2D6nzSmhXgcHDj3MJiazYAj
vBRhyF0VkGzmWPdrGDDpkoWW09AomP4nI0Rkw4QU+b2oKu4IsO6sunokmAlN
pn3E4t+HQdBqwwlDERNqjhZxKW+UIHdHh92jViY8SVmSqjYogN6Uj/Gwignr
l4u4WaZykJg783ngDRNSk2R8o4n7gLeyBu+1Y8HbgtabHqwiwJEuW2XnsOAL
2WsG16MF9Sj109EnFjQ/RD/NicVRhOuL3F7CfPVwyJQAR4ao6cZjwnM7H7wN
jsdRQG148xLhdQ8SVn2TcDSX0/+v9WcWHLVMTXNOw5GeX+4JEWEv/9c570Q4
cp0ycw79woI9V8JUHRU4+tt/yfMsYbPIJ91bKnF0abgnMI6wR6OjX2YVjh61
x/PzCHdSE+zd7uCIUzF+t5twowiVS+txlHpGYs7+yoLyRqHT3mYcWU8LbAHh
BxlRe5NlOOoJ8t7nQfijJYelQET/YS1fLuE4I3jNow1HEgfupQLCbKFetZMC
Ry5V3xVWENYX5XRHdRF9dONKKeGJ/f2R5d04cqB2tfcRJvMxlk4v0Zd9fWiM
sI/xVxO2Ekex2rGTasJ5C+nBAX04oiUeebVMmKe4o07ux1Hrytb3XwmHuW+t
LBvA0X/Ozm7M
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 10}, {-9.882796290834129*^-16, 1.5570552422014544`*^-15}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->107899107]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15843],

Cell["\<\
Check the quality of a solution to Duffing's equation by using a sequence of \
solution precisions:\
\>", "ExampleText",
 CellID->115706850],

Cell[BoxData[
 RowBox[{
  RowBox[{"deqn", "=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Gamma]", "=", 
        RowBox[{"15", "/", "100"}]}], ",", 
       RowBox[{"\[Epsilon]", "=", 
        RowBox[{"3", "/", "10"}]}], ",", 
       RowBox[{"\[Omega]", "=", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"\[Gamma]", " ", 
          RowBox[{
           RowBox[{"x", "'"}], "[", "t", "]"}]}], "-", 
         RowBox[{"x", "[", "t", "]"}], "+", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], "^", "3"}]}], "\[Equal]", 
        RowBox[{"\[Epsilon]", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"\[Omega]", " ", "t"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193117231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"smp", "=", 
  RowBox[{"First", "[", 
   RowBox[{"x", "/.", 
    RowBox[{"NDSolve", "[", 
     RowBox[{"deqn", ",", "x", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
      RowBox[{"Method", "\[Rule]", "Extrapolation"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19160583],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "100.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  
  False,
  Editable->False]], "Output",
 ImageSize->{272, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->320698471]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"smp", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->386929820],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->222665403]
}, Open  ]],

Cell["\<\
Make a sequence of solutions at successively higher working precision:\
\>", "ExampleText",
 CellID->322185176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sols", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"First", "[", 
     RowBox[{"x", "/.", 
      RowBox[{"NDSolve", "[", 
       RowBox[{"deqn", ",", "x", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
        RowBox[{"Method", "\[Rule]", "Extrapolation"}], ",", 
        RowBox[{"WorkingPrecision", "\[Rule]", "wp"}]}], "]"}]}], "]"}], ",", 
    
    RowBox[{"{", 
     RowBox[{"wp", ",", "18", ",", "36", ",", "3"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->30039503],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0", ",", "100.`18."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0", ",", "100.`21."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0", ",", "100.`24."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0", ",", "100.`27."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0", ",", "100.`30."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0", ",", "100.`33."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0", ",", "100.`36."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{510, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->30428351]
}, Open  ]],

Cell["\<\
A plot shows that some of the solutions deviate toward the end:\
\>", "ExampleText",
 CellID->6131567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", "t", "]"}], "&"}], ",", "sols"}], "]"}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"t", ",", "80", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->133030607],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->174385005]
}, Open  ]],

Cell[TextData[{
 "Plot the solution ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "[", 
   StyleBox["100", "TR"], "]"}]], "InlineFormula"],
 " as a function of working precision:"
}], "ExampleText",
 CellID->268116485],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"s100", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", "100", "]"}], "&"}], ",", "sols"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"s100", ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"18", ",", "36"}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[6]:=",
 CellID->208208795],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{18., 0.4866550832047172}, {21., -0.7873282175942883}, {
     24., -1.0879986044857852`}, {27., -1.1403778455286333`}, {
     30., -1.140335446095899}, {33., -1.1403363054987983`}, {
     36., -1.1403364526570516`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{20., -1.1},
  PlotRange->{{18., 36.}, {-1.1403778455286333`, -0.8403507695082592}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->341902024]
}, Open  ]],

Cell["\<\
Convergence to solution at highest precision indicates about 6 digits can be \
trusted:\
\>", "ExampleText",
 CellID->594885706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"best", "=", 
   RowBox[{"s100", "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}]}], ";", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"10", ",", 
      RowBox[{"Abs", "[", 
       RowBox[{
        RowBox[{"Drop", "[", 
         RowBox[{"s100", ",", 
          RowBox[{"-", "1"}]}], "]"}], "-", "best"}], "]"}]}], "]"}], ",", 
    RowBox[{"DataRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"18", ",", "33"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->366362810],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{18., 0.21138529360183142`}, {21., -0.45221516316571886`}, {
     24., -1.2811841369990784`}, {27., -4.383074443887906}, {
     30., -5.997159834803891}, {33., -6.832215375011337}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{18., 0},
  PlotRange->{{18., 33.}, {-6.832215375011337, 0.21138529360183142`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->23559285]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->309507646],

Cell["\<\
Low-precision parameters in functions may invalidate the use of \
higher-precision arithmetic:\
\>", "ExampleText",
 CellID->199673307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"two", "=", 
  RowBox[{"Total", "[", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{".00001", ",", "200000"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77387223],

Cell[BoxData["2.000000000000004`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74899263]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sqrt2", "=", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "two"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "100"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28257561],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"precw\"\>"}], ":", 
  " ", "\<\"The precision of the argument function \
(\\!\\(\\(\\(-2.000000000000004`\\)\\) + x\\^2\\)) is less than \
WorkingPrecision (\\!\\(100.`\\)). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/precw\\\", \
ButtonNote -> \\\"FindRoot::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->129676765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", "\[Rule]", 
   "1.414213562373096461884901539606545555730446118292307415229356954103550503\
5954936300081343727918351490861196122549701`100."}], "}"}]], "Output",
 ImageSize->{585, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->151113448]
}, Open  ]],

Cell[TextData[{
 "The result is a poor approximation to ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->170718466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "-", "x"}], "/.", "%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10819965],

Cell[BoxData[
 RowBox[{"-", 
  "1.4130832128153968474771607742429153593420526772161128180251333865911577468\
384641935763511057660240578`84.99965273924832*^-15"}]], "Output",
 ImageSize->{586, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->218775237]
}, Open  ]],

Cell["\<\
Use of exact parameters allows comparison at different precisions:\
\>", "ExampleText",
 CellID->1980792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"etwo", "=", 
  RowBox[{"SetPrecision", "[", 
   RowBox[{"two", ",", "Infinity"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->313675036],

Cell[BoxData[
 FractionBox["4503599627370505", "2251799813685248"]], "Output",
 ImageSize->{131, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->633322249]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"wp", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", "etwo", "]"}], "-", "x"}], "/.", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "-", "etwo"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "1"}], "}"}], ",", 
        RowBox[{"WorkingPrecision", "\[Rule]", "wp"}]}], "]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"wp", ",", "20", ",", "100", ",", "10"}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->188748545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "0``19.84948500216801"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "0``29.84948500216801"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "0``39.84948500216801"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", 
     RowBox[{"-", "2.859283843334471062`1.3057422724175811*^-49"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "0``59.84948500216801"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"70", ",", "0``69.84948500216801"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"80", ",", "0``79.84948500216801"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"90", ",", "0``89.849485002168"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100", ",", "0``99.84948500216801"}], "}"}]}], "}"}]], "Output",
 ImageSize->{545, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->287562377]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70282811],

Cell["\<\
Expect solution times to increase exponentially as a function of working \
precision:\
\>", "ExampleText",
 CellID->67826875],

Cell[BoxData[
 RowBox[{
  RowBox[{"deqn", "=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Gamma]", "=", 
        RowBox[{"15", "/", "100"}]}], ",", 
       RowBox[{"\[Epsilon]", "=", 
        RowBox[{"3", "/", "10"}]}], ",", 
       RowBox[{"\[Omega]", "=", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"\[Gamma]", " ", 
          RowBox[{
           RowBox[{"x", "'"}], "[", "t", "]"}]}], "-", 
         RowBox[{"x", "[", "t", "]"}], "+", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], "^", "3"}]}], "\[Equal]", 
        RowBox[{"\[Epsilon]", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"\[Omega]", " ", "t"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53856008],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"times", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"wp", ",", 
       RowBox[{"First", "[", 
        RowBox[{"Timing", "[", 
         RowBox[{"First", "[", 
          RowBox[{"x", "/.", 
           RowBox[{"NDSolve", "[", 
            RowBox[{"deqn", ",", "x", ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
             RowBox[{"WorkingPrecision", "\[Rule]", "wp"}], ",", 
             RowBox[{"Method", "\[Rule]", "Extrapolation"}]}], "]"}]}], "]"}],
          "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"wp", ",", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", "MachinePrecision", "}"}], ",", 
         RowBox[{"Range", "[", 
          RowBox[{"20", ",", "50", ",", "5"}], "]"}]}], "]"}]}], "}"}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{"TableForm", "[", 
  RowBox[{"times", ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Precision\>\"", ",", "\"\<Timing\>\""}], "}"}]}], 
     "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->208529888],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWs1y0zAQdiwnaZsCPUJP5Tk6cOAAXHiITKczLTRtCX0FXoMZhmMe0li2
N1mvPlmSpbSOZ2pXsqRdrXa//XG+LZ9urlfLp9ur5cWX9fLx5vbq18Xnh3XV
pSZZlm2qv99vs+r/svqv/tuUZfWc6rvS7frK/gX0quqmm0X7XFXPafXU/Xn1
nFnGq3bcEVw117fptl2PySy9d7DXRh+vUYhRmKt6rWLXbqjwET9E+5WVN4On
BNTvRPs0IXV+buaaD2L0AtDQTbmqnZbRNmg+Ipq98vHfqZs61rpj2Bujc5p6
0e5Fd9+3z5NyZ2dkf3nbH2fRz9s7bfknDZH4UbRtei/teaitfIdnwqmab12a
YseyGZgtsULazNxBbW6lZnIupSaRQtImrZOrY5oKSlvZbNSJSH475faDVvmJ
aPfqhLTI2SC6K7jHEGTAvVi7dDtvuSha+9GvF2XXL/f72zEgwTB8oPczsV+s
M+E+tB8RpF35aRAhQkO8USTpmyQfdv3hK+mrsO4+RNvuvenH6a+JHX78aD9H
5w1OtNODKUs7jpGDXEu2x8oBRw+KLnT7tNxZFVlZfoDoMTQ7ofHHcNUYOwrL
S0IsyYVFw7IDP0R7SdoU+dKZyVzEPwvKrSc+g2vICKPO9hJEGPjU5Vpyn/tE
aLIJijC0pHSEITMQu82MAQ2GYQTPQPh+Dw4bguIelBH0ZSc9uBBFF1qMNybg
3F3KXdJEZ2o/8fg9YnRZQGox+oWqMm6cwbuWVsMjBx6XE2ocWuQgrZ3qLqRZ
fH+KjcP1l3T1TJyH4JUCsvcey8aVEuxthuVDLhsP5qDgvXbts9k5zuB5xkEn
HoS/uGrquS+/qmRINT2mbhHDDYonVNatWPCK56HFE6HIkS7XSIccwRm8Uxcw
b6kiZjkqRD6peJhape/GMsIWXnd1ZCMDqtsnYhSsXw/MTkIkLvmQ8h2KJtza
Fq0kpX8+CDTp+C89pBERXYQw5K/o2Uymi4Ro9tKcgs2lLEd+b1KMVsHaStLu
cMh9Jcc8OTse80J6/VBCVmJdWAPRYiDtAA6xVQWivx+9+G/0UqYx3CQ5n55o
E2bfSc/EXcG18tV7Ctv71opTy13We6Scp4CmrcYao08vJddQnc+BPFB7O870
6phax0OERnepsQjt8giO9jsht3fIScmz5pI5BZdRd4QCs3kkbn6L8qFF+izb
yrIG/g7uLx13fQZRPRNjzo39ftoPX4545nXJvi6xFc5aiZ6LflnHeleaGSRF
HcNqT5uar/Qx3p9ypxPm27/VTf9Qb2I90fSR2qWYzfVFtnGMyaNJzLnLA48l
gvrg4BP7hBiKCeX1TBHNmGT00lHImGRhRg5jjAouk0kMR0z0xldO+/LvHwHH
iq0tf/nTF5nQfmrPUPe697WGO+Vz3kMJEY67PO7X6jYnVnvGvampNL8yzyb/
AfjiLOo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{171, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->743998616]
}, Open  ]],

Cell["\<\
A log plot of the computation time as a function of working precision:\
\>", "ExampleText",
 CellID->228891026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", "times", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->151041372],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWb1uE0EQXvvunILYjnGQEFVEMH1qhCgQpKKxhOiQrAjJKSAoWLR5gEAJ
EpIjUQRegAgegAYqWmpe5Ni/u937du929+wzRool33pnZ76d+WZu7lZ+NJlN
nz2fzA4PJjv7x5OX08ODVzsPj46pKGoRQi7o9/V1Qn+n9Bf/XqQpHc3rTXqN
qUKbjm069uScxHxZfvp0EtEx0rQiacXGAVNmZmn2YVpbTBrlUv4TkSK+zS67
JkIzv3J03X5Tm+cuaut9WEf7Hsyt6yoKC0IXI/LwgCWkxUYuu9XIHiFRbmYZ
TnKyJVJXrvjwWoxqtKBPbOd2ZldgpydXEksUxo4Fyy5oIEIDUZl3Qll+rfdK
NQORU5NL+B1NOrrc7scVp6cDn/gLCAOvKIwsJDob9lzsAgt9OcZpsSNhh8rW
t0pZx7pEjlWX0vvmNbCcc+k2l346/0UX3r75Ts649Cq9fszzI3R+/vhDJd++
/hbYBgPxpbRCilXUDkXE/mrksw/zbZgPA9dd+nYv5g4pE7p0LqX5DUystUPU
eww+I6R1oZPx+jElFU+3f42iqsRlnfW7ejygx+iLmYtOWuzidovQ/DOks1qW
YZUTBTLWcTLmk3M/lLKcr9KHxlAsFZQ99+15WI9uw+eBNcN1nCej1eVsA+IJ
qT0fW6+u4/F2+39WzvrUqZuZ5ed2VRhl9ZmkZacXfC6Jkx99z7939wN7zz8t
QbOfbKpiEshPHn+myA/uzzNkLVMbafFsgtkRCPR8cfTiCztfnC6pWqqft7eB
kZnVZgTRzTR6s4/BUEUljiBWgYcInLzaPWMRNFVpy/LpDvD8tAF0lZ8m0FW2
BPr69uQxcL3PtWJbpBU+j4HTIaDupfo9oE1qMDwGhoew995S8zmF3QS69Wwe
fL8sgqLPT4DtG5Jgo7vXxlbsSuyAej4BBgWCX3W+g8jiCi3lo9Ji/ryH/e0Y
Yv+yfxDElbT+Akmeixk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->185767284]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13094],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrecisionGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrecisionGoal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AccuracyGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AccuracyGoal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tolerance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tolerance"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15991]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22791],

Cell[TextData[ButtonBox["Numerical Integration",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalIntegration"]], "Tutorials",
 CellID->11237]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->14315342],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DifferentialEquations"]], "MoreAbout",
 CellID->796378480],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->131879398],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->771228031]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WorkingPrecision - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 58.8531040}", "context" -> "System`", 
    "keywords" -> {
     "algorithm precision", "algorithm digits", "floating point precision", 
      "arbitrary precision solver", "arbitrary precision", "fixed precision", 
      "fixed precision solver"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WorkingPrecision is an option for various numerical operations which \
specifies how many digits of precision should be maintained in internal \
computations. ", "synonyms" -> {"working precision"}, "title" -> 
    "WorkingPrecision", "type" -> "Symbol", "uri" -> 
    "ref/WorkingPrecision"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5761, 183, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->93549178]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 68485, 1990}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2658, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3281, 89, 54, 1, 70, "ObjectName",
 CellID->23588],
Cell[3338, 92, 541, 15, 70, "Usage",
 CellID->12558]
}, Open  ]],
Cell[CellGroupData[{
Cell[3916, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4394, 129, 478, 17, 70, "Notes",
 CellID->31053],
Cell[4875, 148, 302, 10, 70, "Notes",
 CellID->15945],
Cell[5180, 160, 305, 9, 70, "Notes",
 CellID->32283],
Cell[5488, 171, 236, 7, 70, "Notes",
 CellID->6792]
}, Closed]],
Cell[CellGroupData[{
Cell[5761, 183, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->93549178],
Cell[CellGroupData[{
Cell[6145, 197, 148, 5, 70, "ExampleSection",
 CellID->256768543],
Cell[6296, 204, 91, 1, 70, "ExampleText",
 CellID->355726784],
Cell[CellGroupData[{
Cell[6412, 209, 281, 9, 28, "Input",
 CellID->153300602],
Cell[6696, 220, 301, 10, 36, "Output",
 CellID->334120070]
}, Open  ]],
Cell[7012, 233, 124, 3, 70, "ExampleDelimiter",
 CellID->68337929],
Cell[7139, 238, 116, 3, 70, "ExampleText",
 CellID->96603029],
Cell[CellGroupData[{
Cell[7280, 245, 737, 24, 70, "Input",
 CellID->62310160],
Cell[8020, 271, 468, 17, 36, "Output",
 CellID->455014605]
}, Open  ]],
Cell[CellGroupData[{
Cell[8525, 293, 272, 9, 28, "Input",
 CellID->67446159],
Cell[8800, 304, 2421, 44, 133, "Output",
 Evaluatable->False,
 CellID->462502856]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11270, 354, 215, 7, 70, "ExampleSection",
 CellID->4314],
Cell[11488, 363, 103, 2, 70, "ExampleText",
 CellID->638103999],
Cell[11594, 367, 265, 9, 70, "Input",
 CellID->132060302],
Cell[CellGroupData[{
Cell[11884, 380, 298, 9, 70, "Input",
 CellID->388952760],
Cell[12185, 391, 2201, 45, 132, "Output",
 CellID->593061569]
}, Open  ]],
Cell[14401, 439, 116, 3, 70, "ExampleText",
 CellID->610669315],
Cell[CellGroupData[{
Cell[14542, 446, 242, 8, 70, "Input",
 CellID->350069900],
Cell[14787, 456, 1957, 41, 124, "Output",
 CellID->111129789]
}, Open  ]],
Cell[16759, 500, 125, 3, 70, "ExampleDelimiter",
 CellID->613266022],
Cell[16887, 505, 104, 2, 70, "ExampleText",
 CellID->265521470],
Cell[CellGroupData[{
Cell[17016, 511, 334, 10, 70, "Input",
 CellID->268941417],
Cell[17353, 523, 202, 5, 36, "Output",
 CellID->565572049]
}, Open  ]],
Cell[17570, 531, 265, 8, 70, "ExampleText",
 CellID->560572263],
Cell[CellGroupData[{
Cell[17860, 543, 387, 11, 70, "Input",
 CellID->275445510],
Cell[18250, 556, 202, 5, 36, "Output",
 CellID->432552991]
}, Open  ]],
Cell[18467, 564, 125, 3, 70, "ExampleDelimiter",
 CellID->146720858],
Cell[18595, 569, 134, 4, 70, "ExampleText",
 CellID->141021113],
Cell[CellGroupData[{
Cell[18754, 577, 564, 19, 70, "Input",
 CellID->823118436],
Cell[19321, 598, 588, 20, 71, "Output",
 CellID->153178253]
}, Open  ]],
Cell[19924, 621, 407, 14, 70, "ExampleText",
 CellID->344383014],
Cell[CellGroupData[{
Cell[20356, 639, 669, 21, 70, "Input",
 CellID->526706080],
Cell[21028, 662, 588, 20, 71, "Output",
 CellID->262226395]
}, Open  ]],
Cell[21631, 685, 124, 3, 70, "ExampleDelimiter",
 CellID->41448738],
Cell[21758, 690, 116, 3, 70, "ExampleText",
 CellID->339165064],
Cell[21877, 695, 699, 23, 70, "Input",
 CellID->150026921],
Cell[22579, 720, 378, 13, 70, "ExampleText",
 CellID->158725439],
Cell[22960, 735, 806, 24, 70, "Input",
 CellID->335953770],
Cell[CellGroupData[{
Cell[23791, 763, 593, 18, 70, "Input",
 CellID->74313144],
Cell[24387, 783, 3237, 57, 70, "Output",
 Evaluatable->False,
 CellID->232774045]
}, Open  ]],
Cell[27639, 843, 347, 12, 70, "ExampleText",
 CellID->750622894],
Cell[CellGroupData[{
Cell[28011, 859, 1154, 35, 70, "Input",
 CellID->913918394],
Cell[29168, 896, 2225, 45, 109, "Output",
 CellID->107899107]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31442, 947, 223, 7, 70, "ExampleSection",
 CellID->15843],
Cell[31668, 956, 150, 4, 70, "ExampleText",
 CellID->115706850],
Cell[31821, 962, 1094, 34, 70, "Input",
 CellID->193117231],
Cell[CellGroupData[{
Cell[32940, 1000, 356, 11, 70, "Input",
 CellID->19160583],
Cell[33299, 1013, 365, 14, 36, "Output",
 CellID->320698471]
}, Open  ]],
Cell[CellGroupData[{
Cell[33701, 1032, 215, 7, 70, "Input",
 CellID->386929820],
Cell[33919, 1041, 6906, 117, 70, "Output",
 Evaluatable->False,
 CellID->222665403]
}, Open  ]],
Cell[40840, 1161, 121, 3, 70, "ExampleText",
 CellID->322185176],
Cell[CellGroupData[{
Cell[40986, 1168, 567, 17, 70, "Input",
 CellID->30039503],
Cell[41556, 1187, 1836, 70, 139, "Output",
 CellID->30428351]
}, Open  ]],
Cell[43407, 1260, 112, 3, 70, "ExampleText",
 CellID->6131567],
Cell[CellGroupData[{
Cell[43544, 1267, 341, 12, 70, "Input",
 CellID->133030607],
Cell[43888, 1281, 6670, 113, 70, "Output",
 Evaluatable->False,
 CellID->174385005]
}, Open  ]],
Cell[50573, 1397, 225, 8, 70, "ExampleText",
 CellID->268116485],
Cell[CellGroupData[{
Cell[50823, 1409, 411, 14, 70, "Input",
 CellID->208208795],
Cell[51237, 1425, 701, 19, 129, "Output",
 CellID->341902024]
}, Open  ]],
Cell[51953, 1447, 138, 4, 70, "ExampleText",
 CellID->594885706],
Cell[CellGroupData[{
Cell[52116, 1455, 569, 19, 70, "Input",
 CellID->366362810],
Cell[52688, 1476, 661, 18, 126, "Output",
 CellID->23559285]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53398, 1500, 230, 7, 70, "ExampleSection",
 CellID->309507646],
Cell[53631, 1509, 145, 4, 70, "ExampleText",
 CellID->199673307],
Cell[CellGroupData[{
Cell[53801, 1517, 201, 6, 70, "Input",
 CellID->77387223],
Cell[54005, 1525, 174, 5, 36, "Output",
 CellID->74899263]
}, Open  ]],
Cell[CellGroupData[{
Cell[54216, 1535, 316, 10, 70, "Input",
 CellID->28257561],
Cell[54535, 1547, 470, 9, 70, "Message",
 CellID->129676765],
Cell[55008, 1558, 340, 10, 71, "Output",
 CellID->151113448]
}, Open  ]],
Cell[55363, 1571, 179, 7, 70, "ExampleText",
 CellID->170718466],
Cell[CellGroupData[{
Cell[55567, 1582, 147, 5, 70, "Input",
 CellID->10819965],
Cell[55717, 1589, 305, 8, 54, "Output",
 CellID->218775237]
}, Open  ]],
Cell[56037, 1600, 115, 3, 70, "ExampleText",
 CellID->1980792],
Cell[CellGroupData[{
Cell[56177, 1607, 167, 5, 70, "Input",
 CellID->313675036],
Cell[56347, 1614, 209, 6, 51, "Output",
 CellID->633322249]
}, Open  ]],
Cell[CellGroupData[{
Cell[56593, 1625, 596, 20, 70, "Input",
 CellID->188748545],
Cell[57192, 1647, 943, 27, 58, "Output",
 CellID->287562377]
}, Open  ]],
Cell[58150, 1677, 124, 3, 70, "ExampleDelimiter",
 CellID->70282811],
Cell[58277, 1682, 135, 4, 70, "ExampleText",
 CellID->67826875],
Cell[58415, 1688, 1093, 34, 70, "Input",
 CellID->53856008],
Cell[CellGroupData[{
Cell[59533, 1726, 1217, 36, 70, "Input",
 CellID->208529888],
Cell[60753, 1764, 1685, 32, 70, "Output",
 Evaluatable->False,
 CellID->743998616]
}, Open  ]],
Cell[62453, 1799, 121, 3, 70, "ExampleText",
 CellID->228891026],
Cell[CellGroupData[{
Cell[62599, 1806, 111, 3, 70, "Input",
 CellID->151041372],
Cell[62713, 1811, 1209, 24, 70, "Output",
 Evaluatable->False,
 CellID->185767284]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63983, 1842, 311, 9, 70, "SeeAlsoSection",
 CellID->13094],
Cell[64297, 1853, 1439, 53, 70, "SeeAlso",
 CellID->15991]
}, Open  ]],
Cell[CellGroupData[{
Cell[65773, 1911, 314, 9, 70, "TutorialsSection",
 CellID->22791],
Cell[66090, 1922, 152, 3, 70, "Tutorials",
 CellID->11237]
}, Open  ]],
Cell[CellGroupData[{
Cell[66279, 1930, 318, 9, 70, "MoreAboutSection",
 CellID->14315342],
Cell[66600, 1941, 155, 3, 70, "MoreAbout",
 CellID->796378480],
Cell[66758, 1946, 167, 3, 70, "MoreAbout",
 CellID->131879398],
Cell[66928, 1951, 173, 3, 70, "MoreAbout",
 CellID->771228031]
}, Open  ]],
Cell[67116, 1957, 50, 0, 70, "History"],
Cell[67169, 1959, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

