(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17653,        612]
NotebookOptionsPosition[     14046,        490]
NotebookOutlinePosition[     15323,        527]
CellTagsIndexPosition[     15238,        522]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Print" :> Documentation`HelpLookup["paclet:ref/Print"], 
          "Export" :> Documentation`HelpLookup["paclet:ref/Export"], 
          "BinaryWrite" :> Documentation`HelpLookup["paclet:ref/BinaryWrite"],
           "Message" :> Documentation`HelpLookup["paclet:ref/Message"], 
          "Read" :> Documentation`HelpLookup["paclet:ref/Read"], "LinkWrite" :> 
          Documentation`HelpLookup["paclet:ref/LinkWrite"], "PutAppend" :> 
          Documentation`HelpLookup["paclet:ref/PutAppend"], "WriteString" :> 
          Documentation`HelpLookup["paclet:ref/WriteString"], "RunThrough" :> 
          Documentation`HelpLookup["paclet:ref/RunThrough"], "Splice" :> 
          Documentation`HelpLookup["paclet:ref/Splice"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Print\"\>", 2->"\<\"Export\"\>", 
       3->"\<\"BinaryWrite\"\>", 4->"\<\"Message\"\>", 5->"\<\"Read\"\>", 
       6->"\<\"LinkWrite\"\>", 7->"\<\"PutAppend\"\>", 
       8->"\<\"WriteString\"\>", 9->"\<\"RunThrough\"\>", 
       10->"\<\"Splice\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Files" :> Documentation`HelpLookup["paclet:guide/Files"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Basic Input & Output in Programs\"\>", 
       2->"\<\"External Operations\"\>", 3->"\<\"Files\"\>", 
       4->"\<\"Importing & Exporting\"\>", 
       5->"\<\"Low-Level File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Write", "ObjectName",
 CellID->18697],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Write",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Write"], "[", 
       RowBox[{
        StyleBox["channel", "TI"], ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes the expressions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in sequence, followed by a newline, to the specified output channel. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21241]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The output channel can be a single file or pipe, or list of them, each \
specified by a string giving their name, or by an ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->13487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " is the lowest-level ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output function. Functions like ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 " are defined in terms of it. "
}], "Notes",
 CellID->22511],

Cell[TextData[{
 "If any of the specified files or pipes are not already open, ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " calls ",
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite"]], "InlineFormula"],
 " to open them. "
}], "Notes",
 CellID->59],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " does not close files and pipes after it finishes writing to them. "
}], "Notes",
 CellID->20383],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " generates output in the form specified by the setting of the ",
 Cell[BoxData[
  ButtonBox["FormatType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FormatType"]], "InlineFormula"],
 " option for the output stream used. "
}], "Notes",
 CellID->19785]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->428702023],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->524710707],

Cell["Open a stream:", "ExampleText",
 CellID->303099536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", " ", 
  RowBox[{"OpenWrite", "[", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362690868],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\000003a04372\"\>", ",", "71"}], "]"}]], "Output",
 ImageSize->{576, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->846393855]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " to the stream:"
}], "ExampleText",
 CellID->1194956694],

Cell[BoxData[
 RowBox[{"Write", "[", 
  RowBox[{"str", ",", 
   RowBox[{"a", "^", "2"}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"b", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->370089314],

Cell["Close the stream:", "ExampleText",
 CellID->978458686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1672850523],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\000003a04372\"\>"], "Output",
 ImageSize->{452, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->597292030]
}, Open  ]],

Cell["Read the file:", "ExampleText",
 CellID->133490023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1593889093],

Cell["a^21 + b^2", "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->87287695]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12764],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Message",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Message"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Read",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Read"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PutAppend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PutAppend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WriteString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WriteString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RunThrough",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RunThrough"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Splice",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Splice"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29016]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->702],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->11451]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->718708157],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->570322251],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->511851510],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->132569862],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout",
 CellID->182619520],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->373427188]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Write - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 59.9781328}", "context" -> "System`", 
    "keywords" -> {"expressions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Write[channel, expr_1, expr_2, ...] writes the expressions expr_i in \
sequence, followed by a newline, to the specified output channel. ", 
    "synonyms" -> {"fwrite"}, "title" -> "Write", "type" -> "Symbol", "uri" -> 
    "ref/Write"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7309, 225, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->428702023]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15095, 515}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3304, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3927, 97, 43, 1, 70, "ObjectName",
 CellID->18697],
Cell[3973, 100, 913, 28, 70, "Usage",
 CellID->21241]
}, Open  ]],
Cell[CellGroupData[{
Cell[4923, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5401, 150, 312, 9, 70, "Notes",
 CellID->13487],
Cell[5716, 161, 543, 20, 70, "Notes",
 CellID->22511],
Cell[6262, 183, 372, 13, 70, "Notes",
 CellID->59],
Cell[6637, 198, 228, 7, 70, "Notes",
 CellID->20383],
Cell[6868, 207, 404, 13, 70, "Notes",
 CellID->19785]
}, Closed]],
Cell[CellGroupData[{
Cell[7309, 225, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->428702023],
Cell[CellGroupData[{
Cell[7694, 239, 148, 5, 70, "ExampleSection",
 CellID->524710707],
Cell[7845, 246, 57, 1, 70, "ExampleText",
 CellID->303099536],
Cell[CellGroupData[{
Cell[7927, 251, 130, 4, 28, "Input",
 CellID->362690868],
Cell[8060, 257, 309, 8, 36, "Output",
 CellID->846393855]
}, Open  ]],
Cell[8384, 268, 187, 7, 70, "ExampleText",
 CellID->1194956694],
Cell[8574, 277, 209, 7, 70, "Input",
 CellID->370089314],
Cell[8786, 286, 60, 1, 70, "ExampleText",
 CellID->978458686],
Cell[CellGroupData[{
Cell[8871, 291, 104, 3, 70, "Input",
 CellID->1672850523],
Cell[8978, 296, 247, 6, 36, "Output",
 CellID->597292030]
}, Open  ]],
Cell[9240, 305, 57, 1, 70, "ExampleText",
 CellID->133490023],
Cell[CellGroupData[{
Cell[9322, 310, 106, 3, 70, "Input",
 CellID->1593889093],
Cell[9431, 315, 90, 2, 70, "Print",
 CellID->87287695]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9582, 324, 311, 9, 70, "SeeAlsoSection",
 CellID->12764],
Cell[9896, 335, 2407, 89, 70, "SeeAlso",
 CellID->29016]
}, Open  ]],
Cell[CellGroupData[{
Cell[12340, 429, 312, 9, 70, "TutorialsSection",
 CellID->702],
Cell[12655, 440, 191, 4, 70, "Tutorials",
 CellID->11451]
}, Open  ]],
Cell[CellGroupData[{
Cell[12883, 449, 319, 9, 70, "MoreAboutSection",
 CellID->718708157],
Cell[13205, 460, 173, 3, 70, "MoreAbout",
 CellID->570322251],
Cell[13381, 465, 149, 3, 70, "MoreAbout",
 CellID->511851510],
Cell[13533, 470, 122, 3, 70, "MoreAbout",
 CellID->132569862],
Cell[13658, 475, 154, 3, 70, "MoreAbout",
 CellID->182619520],
Cell[13815, 480, 159, 3, 70, "MoreAbout",
 CellID->373427188]
}, Open  ]],
Cell[13989, 486, 27, 0, 70, "History"],
Cell[14019, 488, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

