(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11942,        429]
NotebookOptionsPosition[      8643,        319]
NotebookOutlinePosition[      9973,        356]
CellTagsIndexPosition[      9889,        351]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BinaryWrite" :> 
          Documentation`HelpLookup["paclet:ref/BinaryWrite"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"BinaryWrite\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files" :> Documentation`HelpLookup["paclet:guide/Files"], 
          "Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Files\"\>", 
       2->"\<\"Low-Level File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WriteString", "ObjectName",
 CellID->17405],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["WriteString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WriteString"], "[", 
       RowBox[{
        StyleBox["channel", "TI"], ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]converts the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to strings, and then writes them in sequence to the specified output \
channel. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7041]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WriteString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WriteString"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12104],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WriteString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WriteString"]], "InlineFormula"],
 " does not put a newline at the end of the output it generates. "
}], "Notes",
 CellID->27243]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3468093],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->250351861],

Cell["Open a stream:", "ExampleText",
 CellID->303099536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", " ", 
  RowBox[{"OpenWrite", "[", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362690868],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\000004a04372\"\>", ",", "72"}], "]"}]], "Output",
 ImageSize->{576, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->534667928]
}, Open  ]],

Cell["Write to the stream:", "ExampleText",
 CellID->1194956694],

Cell[BoxData[
 RowBox[{"WriteString", "[", 
  RowBox[{"str", ",", "\"\<abc\>\"", ",", "\"\<def\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->370089314],

Cell["Close the stream:", "ExampleText",
 CellID->978458686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1672850523],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\000004a04372\"\>"], "Output",
 ImageSize->{452, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->172192720]
}, Open  ]],

Cell["Read the file:", "ExampleText",
 CellID->133490023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1593889093],

Cell["abcdef", "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->382933334]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24428],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->23103]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17738],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->11451]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->479762815],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->220652587],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->364176395]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WriteString - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 0.2281392}", "context" -> "System`", 
    "keywords" -> {"output", "raw output", "verbatim output"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "WriteString[channel, expr_1, expr_2, ...] converts the expr_i to \
strings, and then writes them in sequence to the specified output channel. ", 
    "synonyms" -> {"write string"}, "title" -> "WriteString", "type" -> 
    "Symbol", "uri" -> "ref/WriteString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4746, 161, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3468093]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9748, 344}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1926, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2549, 76, 49, 1, 70, "ObjectName",
 CellID->17405],
Cell[2601, 79, 925, 29, 70, "Usage",
 CellID->7041]
}, Open  ]],
Cell[CellGroupData[{
Cell[3563, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4041, 130, 429, 17, 70, "Notes",
 CellID->12104],
Cell[4473, 149, 236, 7, 70, "Notes",
 CellID->27243]
}, Closed]],
Cell[CellGroupData[{
Cell[4746, 161, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3468093],
Cell[CellGroupData[{
Cell[5129, 175, 148, 5, 70, "ExampleSection",
 CellID->250351861],
Cell[5280, 182, 57, 1, 70, "ExampleText",
 CellID->303099536],
Cell[CellGroupData[{
Cell[5362, 187, 130, 4, 28, "Input",
 CellID->362690868],
Cell[5495, 193, 309, 8, 36, "Output",
 CellID->534667928]
}, Open  ]],
Cell[5819, 204, 64, 1, 70, "ExampleText",
 CellID->1194956694],
Cell[5886, 207, 162, 4, 70, "Input",
 CellID->370089314],
Cell[6051, 213, 60, 1, 70, "ExampleText",
 CellID->978458686],
Cell[CellGroupData[{
Cell[6136, 218, 104, 3, 70, "Input",
 CellID->1672850523],
Cell[6243, 223, 247, 6, 36, "Output",
 CellID->172192720]
}, Open  ]],
Cell[6505, 232, 57, 1, 70, "ExampleText",
 CellID->133490023],
Cell[CellGroupData[{
Cell[6587, 237, 106, 3, 70, "Input",
 CellID->1593889093],
Cell[6696, 242, 87, 2, 70, "Print",
 CellID->382933334]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6844, 251, 311, 9, 70, "SeeAlsoSection",
 CellID->24428],
Cell[7158, 262, 202, 6, 70, "SeeAlso",
 CellID->23103]
}, Open  ]],
Cell[CellGroupData[{
Cell[7397, 273, 314, 9, 70, "TutorialsSection",
 CellID->17738],
Cell[7714, 284, 191, 4, 70, "Tutorials",
 CellID->11451]
}, Open  ]],
Cell[CellGroupData[{
Cell[7942, 293, 319, 9, 70, "MoreAboutSection",
 CellID->479762815],
Cell[8264, 304, 122, 3, 70, "MoreAbout",
 CellID->220652587],
Cell[8389, 309, 159, 3, 70, "MoreAbout",
 CellID->364176395]
}, Open  ]],
Cell[8563, 315, 50, 0, 70, "History"],
Cell[8616, 317, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

