(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14799,        525]
NotebookOptionsPosition[     11604,        418]
NotebookOutlinePosition[     12862,        454]
CellTagsIndexPosition[     12777,        449]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exchanging Material with the Web" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExchangingMaterialWithTheWeb"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Exchanging Material with the Web\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XMLObject" :> Documentation`HelpLookup["paclet:ref/XMLObject"],
           "Import" :> Documentation`HelpLookup["paclet:ref/Import"], 
          "Export" :> Documentation`HelpLookup["paclet:ref/Export"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"XMLObject\"\>", 
       2->"\<\"Import\"\>", 3->"\<\"Export\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Operations" :> 
          Documentation`HelpLookup["paclet:guide/WebOperations"], 
          "XML Formats" :> 
          Documentation`HelpLookup["paclet:guide/XMLFormats"], 
          "XML Import & Export" :> 
          Documentation`HelpLookup["paclet:guide/XMLImportAndExport"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Web Operations\"\>", 
       2->"\<\"XML Formats\"\>", 
       3->"\<\"XML Import & Export\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["XMLElement", "ObjectName",
 CellID->9375],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["XMLElement",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/XMLElement"], "[", 
       RowBox[{
        StyleBox["tag", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["attr", "TI"], 
            StyleBox["1", "TR"]], "->", 
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["data", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an element in symbolic XML."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10564]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLElement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLElement"], "[", 
   RowBox[{
    StyleBox["tag", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["attr", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["val", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["data", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " corresponds to XML of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"<", 
    RowBox[{"tag", " ", 
     SubscriptBox["attr", "1"]}]}], "=", 
   RowBox[{
    RowBox[{"'", 
     RowBox[{
      SubscriptBox["val", "1"], "'"}], 
     StyleBox["\[Ellipsis]", "TR"]}], ">", 
    RowBox[{
     SubscriptBox["data", "1"], " ", 
     StyleBox["\[Ellipsis]", "TR"]}], "<", 
    RowBox[{"/", "tag"}], ">"}]}]], "InlineFormula"]
}], "Notes",
 CellID->234988933],

Cell[TextData[{
 "Both ",
 Cell[BoxData[
  StyleBox["tag", "TI"]], "InlineFormula"],
 " and the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["attr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can either be strings, or pairs of strings, with the first string \
specifying a namespace."
}], "Notes",
 CellID->232792091],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["data", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can consist of strings or ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["XMLObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLObject"]], "InlineFormula"],
 " expressions."
}], "Notes",
 CellID->352627206]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->779861841],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->106147273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<tag\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<attr\>\"", "\[Rule]", "\"\<value\>\""}], "}"}], ",", 
     RowBox[{"{", "\"\<data\>\"", "}"}]}], "]"}], ",", "\"\<XML\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->247329482],

Cell[BoxData["\<\"<tag attr='value'>data</tag>\"\>"], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90843300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->514307603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<tag\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<attr\>\"", "\[Rule]", "\"\<value\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<data\>\"", ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\"\<tag2\>\"", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "\"\<data2\>\"", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124081200],

Cell[BoxData["\<\"<tag attr='value'>data<tag2>data2</tag2></tag>\"\>"], \
"Output",
 ImageSize->{326, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51155433]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->404051373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"\"\<<tag>data</tag>\>\"", ",", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11852509],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"tag\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "\<\"data\"\>", "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{385, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->529657980]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18700],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22764]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2386],

Cell[TextData[ButtonBox["Exchanging Material with the Web",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExchangingMaterialWithTheWeb"]], "Tutorials",
 CellID->1590]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->492812454],

Cell[TextData[ButtonBox["Web Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebOperations"]], "MoreAbout",
 CellID->541202418],

Cell[TextData[ButtonBox["XML Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLFormats"]], "MoreAbout",
 CellID->844061690],

Cell[TextData[ButtonBox["XML Import & Export",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLImportAndExport"]], "MoreAbout",
 CellID->584237675]
}, Open  ]],

Cell["New in 4.2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XMLElement - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 0.5250218}", "context" -> "System`", 
    "keywords" -> {"SymbolicXML", "XML", "xml element"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "XMLElement[tag, {attr_1 -> val_1, ...}, {data_1, ...}] represents an \
element in symbolic XML.", "synonyms" -> {}, "title" -> "XMLElement", "type" -> 
    "Symbol", "uri" -> "ref/XMLElement"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6363, 216, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->779861841]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12634, 442}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2204, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2827, 80, 47, 1, 70, "ObjectName",
 CellID->9375],
Cell[2877, 83, 1022, 32, 70, "Usage",
 CellID->10564]
}, Open  ]],
Cell[CellGroupData[{
Cell[3936, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4414, 137, 1114, 40, 70, "Notes",
 CellID->234988933],
Cell[5531, 179, 330, 12, 70, "Notes",
 CellID->232792091],
Cell[5864, 193, 462, 18, 70, "Notes",
 CellID->352627206]
}, Closed]],
Cell[CellGroupData[{
Cell[6363, 216, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->779861841],
Cell[CellGroupData[{
Cell[6748, 230, 148, 5, 70, "ExampleSection",
 CellID->106147273],
Cell[CellGroupData[{
Cell[6921, 239, 346, 10, 28, "Input",
 CellID->247329482],
Cell[7270, 251, 193, 5, 36, "Output",
 CellID->90843300]
}, Open  ]],
Cell[7478, 259, 125, 3, 70, "ExampleDelimiter",
 CellID->514307603],
Cell[CellGroupData[{
Cell[7628, 266, 533, 15, 47, "Input",
 CellID->124081200],
Cell[8164, 283, 213, 6, 36, "Output",
 CellID->51155433]
}, Open  ]],
Cell[8392, 292, 125, 3, 70, "ExampleDelimiter",
 CellID->404051373],
Cell[CellGroupData[{
Cell[8542, 299, 162, 4, 70, "Input",
 CellID->11852509],
Cell[8707, 305, 449, 14, 36, "Output",
 CellID->529657980]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9217, 326, 311, 9, 70, "SeeAlsoSection",
 CellID->18700],
Cell[9531, 337, 690, 26, 70, "SeeAlso",
 CellID->22764]
}, Open  ]],
Cell[CellGroupData[{
Cell[10258, 368, 313, 9, 70, "TutorialsSection",
 CellID->2386],
Cell[10574, 379, 170, 3, 70, "Tutorials",
 CellID->1590]
}, Open  ]],
Cell[CellGroupData[{
Cell[10781, 387, 319, 9, 70, "MoreAboutSection",
 CellID->492812454],
Cell[11103, 398, 139, 3, 70, "MoreAbout",
 CellID->541202418],
Cell[11245, 403, 133, 3, 70, "MoreAbout",
 CellID->844061690],
Cell[11381, 408, 149, 3, 70, "MoreAbout",
 CellID->584237675]
}, Open  ]],
Cell[11545, 414, 29, 0, 70, "History"],
Cell[11577, 416, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

