(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     69831,       2056]
NotebookOptionsPosition[     61467,       1764]
NotebookOutlinePosition[     62920,       1804]
CellTagsIndexPosition[     62834,       1799]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Relational and Logical Operators\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LogicalExpand" :> 
          Documentation`HelpLookup["paclet:ref/LogicalExpand"], "Mod" :> 
          Documentation`HelpLookup["paclet:ref/Mod"], "BitXor" :> 
          Documentation`HelpLookup["paclet:ref/BitXor"], "Nor" :> 
          Documentation`HelpLookup["paclet:ref/Nor"], "Or" :> 
          Documentation`HelpLookup["paclet:ref/Or"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LogicalExpand\"\>", 2->"\<\"Mod\"\>", 
       3->"\<\"BitXor\"\>", 4->"\<\"Nor\"\>", 
       5->"\<\"Or\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Logic & Boolean Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Xor", "ObjectName",
 CellID->2151],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Xor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Xor"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the logical XOR (exclusive OR) function. It gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if an odd number of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
     " are ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", and the rest are ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ". It gives ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " if an even number of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
     " are ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", and the rest are ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15184]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Xor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Xor"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " can be input in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["e", "1"], "\[Xor]", 
    SubscriptBox["e", "2"], "\[Xor]", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 ". The character ",
 Cell[BoxData["\[Xor]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]xor\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Xor]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Xor"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->19865],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 " gives symbolic results when necessary, applying various simplification \
rules to them. "
}], "Notes",
 CellID->18340],

Cell[TextData[{
 "Unlike ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 " must always test all its arguments, and so is not a control structure, and \
does not have attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28931]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->205221982],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->84648852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Xor", "[", 
  RowBox[{"True", ",", "False"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->717270011],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->614960918]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Xor", "[", 
  RowBox[{"True", ",", "True"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->189141290],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->611227302]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37477389],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]xor\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->8119997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "\[Xor]", "q"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162312622],

Cell[BoxData[
 RowBox[{"p", "\[Xor]", "q"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207813998]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22677],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 " is associative and commutative:"
}], "ExampleText",
 CellID->32334864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Xor", "[", 
  RowBox[{
   RowBox[{"Xor", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288541159],

Cell[BoxData[
 RowBox[{"x", "\[Xor]", "y", "\[Xor]", "z"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->345631283]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Xor", "[", 
  RowBox[{"y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->255847075],

Cell[BoxData[
 RowBox[{"x", "\[Xor]", "y"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->127661112]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->973712246],

Cell["Do symbolic simplification:", "ExampleText",
 CellID->622451923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Xor", "[", 
   RowBox[{"True", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111864162],

Cell[BoxData[
 RowBox[{"!", "x"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4989459]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Xor", "[", 
   RowBox[{"x", ",", "x", ",", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->103600375],

Cell[BoxData["y"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100694412]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53075448],

Cell[TextData[{
 "Expand in terms of ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->88102604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"Xor", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83103378],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "&&", 
    RowBox[{"!", "y"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"y", "&&", 
    RowBox[{"!", "x"}]}], ")"}]}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85008942]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140100760],

Cell["TraditionalForm formatting:", "ExampleText",
 CellID->114870376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Xor", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51401474],

Cell[BoxData[
 FormBox[
  RowBox[{"x", "\[Xor]", "y", "\[Xor]", "z"}], TraditionalForm]], "Output",
 ImageSize->{50, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->405159770]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30223],

Cell[TextData[{
 "Find the ",
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 " of two regions in 2D:"
}], "ExampleText",
 CellID->37965020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"Xor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], ">", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->958192352],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->555788754]
}, Open  ]],

Cell[TextData[{
 "Find the ",
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 " of three regions in 3D:"
}], "ExampleText",
 CellID->109331457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{"Xor", "[", 
    RowBox[{
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"y", ">", "0"}], ",", 
     RowBox[{"z", ">", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4035505],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28544762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->150766724],

Cell[TextData[{
 "A cellular automaton based on ",
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12039839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Boole", "[", 
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Xor", "@@", "#"}], "&"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "True", "}"}], ",", "False"}], "}"}], ",", "40"}], "]"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->368008395],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJytVtsRwjAMs9mET8aBEboA+/9RoDQvK7Idci2JI6PodCLHdXs+touI3Pb3
vr+i39HPCvY5LsfzW/UjjovKcYIM52sKl/MEqz+DS/Wa3wjjb3rLnzwuwJ88
jvzJ4/P+DH4GCTwENs+Q6SfrMBirLFnrGYZ96LNZr2cYYJTy4659QTXLZ8lT
nytUs3xq4421z/osje3c77M+S6OdO1TzgXKHagcjyB2qPRp9OfTy4dyh2qPR
l8MAozOHEY2x2sHYBY/ff1xjmz1+/3GNbfb6vYxG679Lxr+iUQcPc/4VjaOH
K3zjvZf3r2i05wXG8P1HGcP3H2UM33+UUVfzNzAu529g/Jt/J+Nf9X0YvY0v
OikM+w==
   "], {{0, 0}, {81, 41}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->Small]], "Output",
 ImageSize->{184, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->795835665]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->645569545],

Cell["\<\
Find the area of the symmetric difference of sets given by algebraic \
conditions:\
\>", "ExampleText",
 CellID->100096229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{"Xor", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310451651],

Cell[BoxData[
 RowBox[{"2", "+", "\[Pi]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->578151334]
}, Open  ]],

Cell["This shows the set:", "ExampleText",
 CellID->2908850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"Xor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "2.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167686269],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->474692293]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->36597777],

Cell[TextData[{
 "Truth table for ",
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->470387246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"Xor", ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->95768180],

Cell[BoxData[
 TagBox[GridBox[{
    {"False", "True"},
    {"True", "False"}
   }],
  "Grid"]], "Output",
 ImageSize->{82, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40738707]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6559803],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to expand in terms of ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->392725173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"Xor", "[", 
   RowBox[{"p", ",", "q", ",", "r"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164328352],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"p", "&&", "q", "&&", "r"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"p", "&&", 
    RowBox[{"!", "q"}], "&&", 
    RowBox[{"!", "r"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"q", "&&", 
    RowBox[{"!", "p"}], "&&", 
    RowBox[{"!", "r"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"r", "&&", 
    RowBox[{"!", "p"}], "&&", 
    RowBox[{"!", "q"}]}], ")"}]}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40176866]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->244189076],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 " of conditions in ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->49269247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Boole", "[", 
   RowBox[{"Xor", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}], "-", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Boole", "[", "a", "]"}], "+", 
     RowBox[{"Boole", "[", "b", "]"}], "+", 
     RowBox[{"Boole", "[", "c", "]"}]}], ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6973890],

Cell[BoxData[
 RowBox[{
  RowBox[{"Boole", "[", 
   RowBox[{"a", "\[Xor]", "b", "\[Xor]", "c"}], "]"}], "-", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Boole", "[", "a", "]"}], "+", 
     RowBox[{"Boole", "[", "b", "]"}], "+", 
     RowBox[{"Boole", "[", "c", "]"}]}], ",", "2"}], "]"}]}]], "Output",
 ImageSize->{363, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->587061510]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->465995412],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->277410020]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3378],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 " of disks on a circle:"
}], "ExampleText",
 CellID->406738173],

Cell[BoxData[
 RowBox[{
  RowBox[{"disk", "[", 
   RowBox[{"m_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x0", "=", 
       RowBox[{
        RowBox[{"1", "/", "2"}], 
        RowBox[{"Cos", "[", 
         RowBox[{"m", " ", "2", 
          RowBox[{"Pi", "/", "n"}]}], "]"}]}]}], ",", 
      RowBox[{"y0", "=", 
       RowBox[{
        RowBox[{"1", "/", "2"}], 
        RowBox[{"Sin", "[", 
         RowBox[{"m", " ", "2", 
          RowBox[{"Pi", "/", "n"}]}], "]"}]}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "x0"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "y0"}], ")"}], "^", "2"}]}], "<", "1"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229769265],

Cell[BoxData[
 RowBox[{
  RowBox[{"disk", "[", "n_", "]"}], ":=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Xor", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"disk", "[", 
       RowBox[{"m", ",", "n"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", "0", ",", 
        RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->699561132],

Cell["Generate three disks on a circle:", "ExampleText",
 CellID->396409145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"disk", "[", "3", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17650938],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", "x"}], ")"}], "2"], "+", 
    SuperscriptBox["y", "2"]}], "<", "1"}], "\[Xor]", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "4"], "+", "x"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         SqrtBox["3"], "4"]}], "+", "y"}], ")"}], "2"]}], "<", "1"}], 
  "\[Xor]", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "4"], "+", "x"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        SqrtBox["3"], "4"], "+", "y"}], ")"}], "2"]}], "<", "1"}]}]], "Output",\

 ImageSize->{459, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->408016294]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{"disk", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->734481706],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[4]=",
 CellID->413619396]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157084079],

Cell[TextData[{
 "A truth table for a 12 variable ",
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->435892611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Xor", "@@", "x"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Tuples", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"False", ",", "True"}], "}"}], ",", "12"}], "]"}]}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"2", "^", "6"}]}], "]"}], ",", 
   RowBox[{"ColorRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"False", "\[Rule]", "White"}], ",", 
      RowBox[{"True", "\[Rule]", "Black"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->429366088],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlNFKwzAYRtN07TN4uafRKx+iDGG7EGXuwXqx94uJjSKjYhEh+b+cQZcm
Ke058OV7nC7Hp+fpcjpM+4fz9Ho8Hd729y/nuNR3zrlruu5cvA/xbrn6ENJN
+s3x6pZpn/Y+fm6Of93ywL+upg+PcerjmJaHPB/yPO0PefRxHPP4uT6u7A8b
n/M371/7vs/zEfoa6Hdf9BuY+pV3/eTqv823POdv3v+b6w4HHHBYc7DdSNCX
o1dIv4KD7RRBDz301ugVehMHHHAIIo0EPfQt0is0Dw51ONg+CdCXo1dIPw44
4BBEGgn6cvQK6VdwsJ0i6KGH3hq9Qm8qONhOEfTl6BXSjwMOOGg52G5V6KFv
kV6heXDAAYcg0kjQl6NXSD8OdTjYPgnQQ98ivULz4IADDkGkkaCHHnpr9Aq9
qeBgO0XQl6NXSD8OOOAQRBoJeuiht0av0Js44IBDEGkk6MvRK6QfhzocbJ8E
6KFvkV6heXCow8H2SbBNr5AfHHDAQcvBdqvaplfIDw51ONg+CdBD3yK9QvPg
gAMOWg62WxV66FukV2geHOpwsH0SbNMr5AcHHHDQcrDdqjL0859Wr8te9w6x
4brS\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111829803]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3780],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogicalExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogicalExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitXor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitXor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Or",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Or"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22721]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28624],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->32345],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->400354195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->358325186],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->93405392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Xor"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 4.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Xor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 1.1969140}", "context" -> "System`", 
    "keywords" -> {
     "exclusive Or", "exclusive disjunction", "inequivalent", "unequivalent", 
      "unequal", "modulo 2", "ring sum"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Xor[e_1, e_2, ...] is the logical XOR (exclusive OR) function. It gives \
True if an odd number of the e_i are True, and the rest are False. It gives \
False if an even number of the e_i are True, and the rest are False. ", 
    "synonyms" -> {}, "title" -> "Xor", "type" -> "Symbol", "uri" -> 
    "ref/Xor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7623, 260, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->205221982]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 62691, 1792}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2260, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2883, 81, 40, 1, 70, "ObjectName",
 CellID->2151],
Cell[2926, 84, 1844, 60, 70, "Usage",
 CellID->15184]
}, Open  ]],
Cell[CellGroupData[{
Cell[4807, 149, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5285, 166, 1187, 43, 70, "Notes",
 CellID->19865],
Cell[6475, 211, 246, 8, 70, "Notes",
 CellID->18340],
Cell[6724, 221, 862, 34, 70, "Notes",
 CellID->28931]
}, Closed]],
Cell[CellGroupData[{
Cell[7623, 260, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->205221982],
Cell[CellGroupData[{
Cell[8008, 274, 147, 5, 70, "ExampleSection",
 CellID->84648852],
Cell[CellGroupData[{
Cell[8180, 283, 129, 4, 28, "Input",
 CellID->717270011],
Cell[8312, 289, 161, 5, 36, "Output",
 CellID->614960918]
}, Open  ]],
Cell[CellGroupData[{
Cell[8510, 299, 128, 4, 28, "Input",
 CellID->189141290],
Cell[8641, 305, 162, 5, 36, "Output",
 CellID->611227302]
}, Open  ]],
Cell[8818, 313, 124, 3, 70, "ExampleDelimiter",
 CellID->37477389],
Cell[8945, 318, 190, 7, 70, "ExampleText",
 CellID->8119997],
Cell[CellGroupData[{
Cell[9160, 329, 97, 3, 70, "Input",
 CellID->162312622],
Cell[9260, 334, 185, 6, 36, "Output",
 CellID->207813998]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9494, 346, 216, 7, 70, "ExampleSection",
 CellID->22677],
Cell[9713, 355, 198, 7, 70, "ExampleText",
 CellID->32334864],
Cell[CellGroupData[{
Cell[9936, 366, 178, 6, 70, "Input",
 CellID->288541159],
Cell[10117, 374, 200, 6, 36, "Output",
 CellID->345631283]
}, Open  ]],
Cell[CellGroupData[{
Cell[10354, 385, 122, 4, 70, "Input",
 CellID->255847075],
Cell[10479, 391, 185, 6, 36, "Output",
 CellID->127661112]
}, Open  ]],
Cell[10679, 400, 125, 3, 70, "ExampleDelimiter",
 CellID->973712246],
Cell[10807, 405, 70, 1, 70, "ExampleText",
 CellID->622451923],
Cell[CellGroupData[{
Cell[10902, 410, 161, 5, 70, "Input",
 CellID->111864162],
Cell[11066, 417, 173, 6, 36, "Output",
 CellID->4989459]
}, Open  ]],
Cell[CellGroupData[{
Cell[11276, 428, 168, 5, 70, "Input",
 CellID->103600375],
Cell[11447, 435, 158, 5, 36, "Output",
 CellID->100694412]
}, Open  ]],
Cell[11620, 443, 124, 3, 70, "ExampleDelimiter",
 CellID->53075448],
Cell[11747, 448, 424, 18, 70, "ExampleText",
 CellID->88102604],
Cell[CellGroupData[{
Cell[12196, 470, 162, 5, 70, "Input",
 CellID->83103378],
Cell[12361, 477, 317, 12, 36, "Output",
 CellID->85008942]
}, Open  ]],
Cell[12693, 492, 125, 3, 70, "ExampleDelimiter",
 CellID->140100760],
Cell[12821, 497, 70, 1, 70, "ExampleText",
 CellID->114870376],
Cell[CellGroupData[{
Cell[12916, 502, 173, 6, 70, "Input",
 CellID->51401474],
Cell[13092, 510, 246, 7, 50, "Output",
 CellID->405159770]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13387, 523, 223, 7, 70, "ExampleSection",
 CellID->30223],
Cell[13613, 532, 202, 8, 70, "ExampleText",
 CellID->37965020],
Cell[CellGroupData[{
Cell[13840, 544, 517, 18, 70, "Input",
 CellID->958192352],
Cell[14360, 564, 3718, 65, 70, "Output",
 Evaluatable->False,
 CellID->555788754]
}, Open  ]],
Cell[18093, 632, 205, 8, 70, "ExampleText",
 CellID->109331457],
Cell[CellGroupData[{
Cell[18323, 644, 533, 18, 70, "Input",
 CellID->4035505],
Cell[18859, 664, 10545, 177, 70, "Output",
 Evaluatable->False,
 CellID->28544762]
}, Open  ]],
Cell[29419, 844, 125, 3, 70, "ExampleDelimiter",
 CellID->150766724],
Cell[29547, 849, 202, 8, 70, "ExampleText",
 CellID->12039839],
Cell[CellGroupData[{
Cell[29774, 861, 441, 15, 70, "Input",
 CellID->368008395],
Cell[30218, 878, 697, 18, 116, "Output",
 CellID->795835665]
}, Open  ]],
Cell[30930, 899, 125, 3, 70, "ExampleDelimiter",
 CellID->645569545],
Cell[31058, 904, 133, 4, 70, "ExampleText",
 CellID->100096229],
Cell[CellGroupData[{
Cell[31216, 912, 762, 25, 70, "Input",
 CellID->310451651],
Cell[31981, 939, 184, 6, 36, "Output",
 CellID->578151334]
}, Open  ]],
Cell[32180, 948, 60, 1, 70, "ExampleText",
 CellID->2908850],
Cell[CellGroupData[{
Cell[32265, 953, 636, 22, 70, "Input",
 CellID->167686269],
Cell[32904, 977, 4470, 77, 70, "Output",
 Evaluatable->False,
 CellID->474692293]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37423, 1060, 236, 7, 70, "ExampleSection",
 CellID->36597777],
Cell[37662, 1069, 189, 8, 70, "ExampleText",
 CellID->470387246],
Cell[CellGroupData[{
Cell[37876, 1081, 281, 10, 70, "Input",
 CellID->95768180],
Cell[38160, 1093, 234, 10, 48, "Output",
 CellID->40738707]
}, Open  ]],
Cell[38409, 1106, 123, 3, 70, "ExampleDelimiter",
 CellID->6559803],
Cell[38535, 1111, 567, 23, 70, "ExampleText",
 CellID->392725173],
Cell[CellGroupData[{
Cell[39127, 1138, 173, 5, 70, "Input",
 CellID->164328352],
Cell[39303, 1145, 559, 20, 36, "Output",
 CellID->40176866]
}, Open  ]],
Cell[39877, 1168, 125, 3, 70, "ExampleDelimiter",
 CellID->244189076],
Cell[40005, 1173, 313, 12, 70, "ExampleText",
 CellID->49269247],
Cell[CellGroupData[{
Cell[40343, 1189, 382, 12, 70, "Input",
 CellID->6973890],
Cell[40728, 1203, 451, 14, 36, "Output",
 CellID->587061510]
}, Open  ]],
Cell[CellGroupData[{
Cell[41216, 1222, 104, 3, 70, "Input",
 CellID->465995412],
Cell[41323, 1227, 158, 5, 36, "Output",
 CellID->277410020]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41530, 1238, 223, 7, 70, "ExampleSection",
 CellID->3378],
Cell[41756, 1247, 198, 8, 70, "ExampleText",
 CellID->406738173],
Cell[41957, 1257, 848, 30, 70, "Input",
 CellID->229769265],
Cell[42808, 1289, 400, 13, 70, "Input",
 CellID->699561132],
Cell[43211, 1304, 76, 1, 70, "ExampleText",
 CellID->396409145],
Cell[CellGroupData[{
Cell[43312, 1309, 99, 3, 70, "Input",
 CellID->17650938],
Cell[43414, 1314, 983, 39, 62, "Output",
 CellID->408016294]
}, Open  ]],
Cell[CellGroupData[{
Cell[44434, 1358, 516, 16, 70, "Input",
 CellID->734481706],
Cell[44953, 1376, 11078, 186, 70, "Output",
 Evaluatable->False,
 CellID->413619396]
}, Open  ]],
Cell[56046, 1565, 125, 3, 70, "ExampleDelimiter",
 CellID->157084079],
Cell[56174, 1570, 214, 8, 70, "ExampleText",
 CellID->435892611],
Cell[CellGroupData[{
Cell[56413, 1582, 690, 22, 70, "Input",
 CellID->429366088],
Cell[57106, 1606, 827, 18, 70, "Output",
 Evaluatable->False,
 CellID->111829803]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57994, 1631, 310, 9, 70, "SeeAlsoSection",
 CellID->3780],
Cell[58307, 1642, 1160, 44, 70, "SeeAlso",
 CellID->22721]
}, Open  ]],
Cell[CellGroupData[{
Cell[59504, 1691, 314, 9, 70, "TutorialsSection",
 CellID->28624],
Cell[59821, 1702, 172, 3, 70, "Tutorials",
 CellID->32345],
Cell[59996, 1707, 133, 3, 70, "Tutorials",
 CellID->400354195]
}, Open  ]],
Cell[CellGroupData[{
Cell[60166, 1715, 319, 9, 70, "MoreAboutSection",
 CellID->358325186],
Cell[60488, 1726, 156, 3, 70, "MoreAbout",
 CellID->93405392]
}, Open  ]],
Cell[CellGroupData[{
Cell[60681, 1734, 305, 8, 70, "RelatedLinksSection"],
Cell[60989, 1744, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[61385, 1760, 52, 0, 70, "History"],
Cell[61440, 1762, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

