(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24868,        903]
NotebookOptionsPosition[     20139,        740]
NotebookOutlinePosition[     21420,        777]
CellTagsIndexPosition[     21335,        772]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MatchingDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/MatchingDissimilarity"], 
          "DiceDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/DiceDissimilarity"], 
          "SokalSneathDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/SokalSneathDissimilarity"], 
          "JaccardDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/JaccardDissimilarity"], 
          "RussellRaoDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/RussellRaoDissimilarity"], 
          "RogersTanimotoDissimilarity" :> 
          Documentation`HelpLookup[
           "paclet:ref/RogersTanimotoDissimilarity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MatchingDissimilarity\"\>", 
       2->"\<\"DiceDissimilarity\"\>", 3->"\<\"SokalSneathDissimilarity\"\>", 
       4->"\<\"JaccardDissimilarity\"\>", 
       5->"\<\"RussellRaoDissimilarity\"\>", 
       6->"\<\"RogersTanimotoDissimilarity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Distance and Dissimilarity Measures" :> 
          Documentation`HelpLookup[
           "paclet:guide/DistanceAndDissimilarityMeasures"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Distance and Dissimilarity Measures\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["YuleDissimilarity", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["YuleDissimilarity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/YuleDissimilarity"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Yule dissimilarity between Boolean vectors ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24350]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["YuleDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/YuleDissimilarity"]], "InlineFormula"],
 " works for both ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " vectors and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", "1"}], TraditionalForm]], "InlineMath"],
 " vectors."
}], "Notes",
 CellID->38632218],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["YuleDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/YuleDissimilarity"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    SubscriptBox["n", "10"], " ", 
    RowBox[{
     SubscriptBox["n", "01"], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["n", "11"], " ", 
        SubscriptBox["n", "00"]}], "+", 
       RowBox[{
        SubscriptBox["n", "10"], " ", 
        SubscriptBox["n", "01"]}]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " is the number of corresponding pairs of elements in ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " respectively equal to ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->72507031]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->145397774],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->181997524],

Cell["Yule dissimilarity between two Boolean vectors:", "ExampleText",
 CellID->235641551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"YuleDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "1", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9645324],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129489700]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->829874330],

Cell[TextData[{
 "The elements can also be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->127306229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"YuleDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "False", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "False"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279206382],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144842502]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10168],

Cell[TextData[{
 "Compute dissimilarity between any ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", "1"}], TraditionalForm]], "InlineMath"],
 " vectors of equal length:"
}], "ExampleText",
 CellID->86273121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"YuleDissimilarity", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}], ",", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488208944],

Cell[BoxData[
 FractionBox["208", "249"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52432118]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204991544],

Cell[TextData[{
 "Compute dissimilarity between any ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " vectors of equal length:"
}], "ExampleText",
 CellID->14044010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"YuleDissimilarity", "[", 
  RowBox[{
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], ",", "1000"}], "]"}], ",", 
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], ",", "1000"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323525768],

Cell[BoxData[
 FractionBox["62419", "62459"]], "Output",
 ImageSize->{46, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249358839]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6748],

Cell[TextData[{
 "Cluster ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", "1"}], TraditionalForm]], "InlineMath"],
 " data using Yule dissimilarity:"
}], "ExampleText",
 CellID->245478961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "YuleDissimilarity"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108189764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102395048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->478877783],

Cell[TextData[{
 "Cluster",
 " ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " ",
 "data using Yule dissimilarity:"
}], "ExampleText",
 CellID->68571327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "YuleDissimilarity"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174963025],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"False", ",", "True"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{433, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43883250]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5651],

Cell["Yule dissimilarity is bounded by 0 and 2:", "ExampleText",
 CellID->482006564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"YuleDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107213585],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18761115]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"YuleDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->582164693],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->222893922]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3093],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatchingDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatchingDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiceDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiceDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SokalSneathDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SokalSneathDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JaccardDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JaccardDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RussellRaoDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RussellRaoDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RogersTanimotoDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RogersTanimotoDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13985]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27753],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with YuleDissimilarity",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
YuleDissimilarity"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->636469],

Cell[TextData[ButtonBox["Distance and Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], "MoreAbout",
 CellID->116164631]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"YuleDissimilarity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 3.5719748}", "context" -> "System`", 
    "keywords" -> {"Yule dissimilarity"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "YuleDissimilarity[u, v] gives the Yule dissimilarity between Boolean \
vectors u and v.", "synonyms" -> {"yule dissimilarity"}, "title" -> 
    "YuleDissimilarity", "type" -> "Symbol", "uri" -> 
    "ref/YuleDissimilarity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7914, 247, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->145397774]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21192, 765}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2662, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3285, 90, 1582, 37, 70, "ObjectNameGrid"],
Cell[4870, 129, 721, 23, 70, "Usage",
 CellID->24350]
}, Open  ]],
Cell[CellGroupData[{
Cell[5628, 157, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6106, 174, 555, 21, 70, "Notes",
 CellID->38632218],
Cell[6664, 197, 1213, 45, 70, "Notes",
 CellID->72507031]
}, Closed]],
Cell[CellGroupData[{
Cell[7914, 247, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->145397774],
Cell[CellGroupData[{
Cell[8299, 261, 148, 5, 70, "ExampleSection",
 CellID->181997524],
Cell[8450, 268, 90, 1, 70, "ExampleText",
 CellID->235641551],
Cell[CellGroupData[{
Cell[8565, 273, 295, 9, 28, "Input",
 CellID->9645324],
Cell[8863, 284, 158, 5, 36, "Output",
 CellID->129489700]
}, Open  ]],
Cell[9036, 292, 125, 3, 70, "ExampleDelimiter",
 CellID->829874330],
Cell[9164, 297, 323, 13, 70, "ExampleText",
 CellID->127306229],
Cell[CellGroupData[{
Cell[9512, 314, 274, 8, 70, "Input",
 CellID->279206382],
Cell[9789, 324, 158, 5, 36, "Output",
 CellID->144842502]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9996, 335, 216, 7, 70, "ExampleSection",
 CellID->10168],
Cell[10215, 344, 209, 7, 70, "ExampleText",
 CellID->86273121],
Cell[CellGroupData[{
Cell[10449, 355, 272, 8, 70, "Input",
 CellID->488208944],
Cell[10724, 365, 181, 6, 51, "Output",
 CellID->52432118]
}, Open  ]],
Cell[10920, 374, 125, 3, 70, "ExampleDelimiter",
 CellID->204991544],
Cell[11048, 379, 352, 13, 70, "ExampleText",
 CellID->14044010],
Cell[CellGroupData[{
Cell[11425, 396, 395, 13, 70, "Input",
 CellID->323525768],
Cell[11823, 411, 186, 6, 51, "Output",
 CellID->249358839]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12058, 423, 222, 7, 70, "ExampleSection",
 CellID->6748],
Cell[12283, 432, 190, 7, 70, "ExampleText",
 CellID->245478961],
Cell[CellGroupData[{
Cell[12498, 443, 476, 16, 70, "Input",
 CellID->108189764],
Cell[12977, 461, 497, 18, 36, "Output",
 CellID->102395048]
}, Open  ]],
Cell[13489, 482, 125, 3, 70, "ExampleDelimiter",
 CellID->478877783],
Cell[13617, 487, 342, 15, 70, "ExampleText",
 CellID->68571327],
Cell[CellGroupData[{
Cell[13984, 506, 504, 16, 70, "Input",
 CellID->174963025],
Cell[14491, 524, 524, 18, 36, "Output",
 CellID->43883250]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15064, 548, 232, 7, 70, "ExampleSection",
 CellID->5651],
Cell[15299, 557, 84, 1, 70, "ExampleText",
 CellID->482006564],
Cell[CellGroupData[{
Cell[15408, 562, 274, 8, 70, "Input",
 CellID->107213585],
Cell[15685, 572, 157, 5, 36, "Output",
 CellID->18761115]
}, Open  ]],
Cell[CellGroupData[{
Cell[15879, 582, 274, 8, 70, "Input",
 CellID->582164693],
Cell[16156, 592, 158, 5, 36, "Output",
 CellID->222893922]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16375, 604, 310, 9, 70, "SeeAlsoSection",
 CellID->3093],
Cell[16688, 615, 1599, 53, 70, "SeeAlso",
 CellID->13985]
}, Open  ]],
Cell[CellGroupData[{
Cell[18324, 673, 314, 9, 70, "TutorialsSection",
 CellID->27753],
Cell[18641, 684, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[18848, 692, 305, 8, 70, "RelatedLinksSection"],
Cell[19156, 702, 376, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19569, 719, 316, 9, 70, "MoreAboutSection",
 CellID->636469],
Cell[19888, 730, 179, 3, 70, "MoreAbout",
 CellID->116164631]
}, Open  ]],
Cell[20082, 736, 27, 0, 70, "History"],
Cell[20112, 738, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

