(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55862,       2139]
NotebookOptionsPosition[     44813,       1739]
NotebookOutlinePosition[     46221,       1779]
CellTagsIndexPosition[     46135,       1774]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms and Related Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegralTransformsAndRelatedOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Integral Transforms and Related Operations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseZTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseZTransform"], 
          "LaplaceTransform" :> 
          Documentation`HelpLookup["paclet:ref/LaplaceTransform"], "Sum" :> 
          Documentation`HelpLookup["paclet:ref/Sum"], "Series" :> 
          Documentation`HelpLookup["paclet:ref/Series"], "RSolve" :> 
          Documentation`HelpLookup["paclet:ref/RSolve"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"InverseZTransform\"\>", 
       2->"\<\"LaplaceTransform\"\>", 3->"\<\"Sum\"\>", 4->"\<\"Series\"\>", 
       5->"\<\"RSolve\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Integral Transforms" :> 
          Documentation`HelpLookup["paclet:guide/IntegralTransforms"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Discrete Mathematics\"\>", 
       2->"\<\"Integral Transforms\"\>", 
       3->"\<\"Signal Processing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ZTransform", "ObjectName",
 CellID->7856],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ZTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ZTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Z transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31448]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The Z transform of a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
 " is defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "\[Infinity]",
     LimitsPositioning->True], 
    RowBox[{
     RowBox[{"f", "(", "n", ")"}], 
     SuperscriptBox["z", 
      RowBox[{"-", "n"}]]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->18764]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->570448461],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->384024909],

Cell["Transform a sequence: ", "ExampleText",
 CellID->104740162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "^", "2"}], " ", 
    RowBox[{"2", "^", 
     RowBox[{"(", 
      RowBox[{"-", "n"}], ")"}]}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288857379],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "z", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "z"}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "z"}]}], ")"}], "3"]]], "Output",
 ImageSize->{79, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65525579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134657624],

Cell["Transform an unknown sequence: ", "ExampleText",
 CellID->13943179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"n", "+", "1"}], "]"}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317050959],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "z"}], " ", 
   RowBox[{"f", "[", "0", "]"}]}], "+", 
  RowBox[{"z", " ", 
   RowBox[{"ZTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}]}]], "Output",\

 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->426255861]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4529],

Cell["The following classes all result in rational transform:", "ExampleText",
 CellID->352989390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"a", "^", "n"}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->434907548],

Cell[BoxData[
 FractionBox["z", 
  RowBox[{
   RowBox[{"-", "a"}], "+", "z"}]]], "Output",
 ImageSize->{43, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18725996]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "^", "3"}], "+", "1"}], ")"}], 
    RowBox[{"a", "^", "n"}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->605542198],

Cell[BoxData[
 RowBox[{
  FractionBox["z", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "z"}]], "+", 
  FractionBox[
   RowBox[{"a", " ", "z", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{"4", " ", "a", " ", "z"}], "+", 
      SuperscriptBox["z", "2"]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "-", "z"}], ")"}], "4"]]}]], "Output",
 ImageSize->{171, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->85164064]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"a", " ", "n"}], "]"}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->107547796],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "a"}]]}], ")"}], " ", "z"}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"z", "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "a"}]], " ", "z"}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "a"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["z", "2"]}], ")"}]}]}], ")"}]}]]], "Output",
 ImageSize->{170, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->490145902]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"n", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"a", " ", "n"}], "]"}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->8043162],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "a"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "a"}]]}], ")"}], " ", "z", " ",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["z", "2"]}], ")"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "a"}]], " ", "z"}], "-", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "a"}]], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["z", "2"]}], ")"}]}]}], ")"}], "2"]}]]}]], "Output",
 ImageSize->{184, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->367522736]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "n"}], " ", 
    RowBox[{"UnitStep", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->15176741],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SuperscriptBox["a", "2"], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "z"}], ")"}], " ", "z"}]]}]], "Output",
 ImageSize->{67, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->185105744]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "n"}], " ", 
    RowBox[{"DiscreteDelta", "[", 
     RowBox[{"n", "-", "4"}], "]"}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->46316786],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["a", "4"], 
  SuperscriptBox["z", "4"]]], "Output",
 ImageSize->{21, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->31877664]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->593730630],

Cell["Elementary function results:", "ExampleText",
 CellID->70516747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", "n"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}], "!"}]}], ",", "n", ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6313372],

Cell[BoxData[
 RowBox[{
  SqrtBox["z"], " ", 
  RowBox[{"Sin", "[", 
   FractionBox["1", 
    SqrtBox["z"]], "]"}]}]], "Output",
 ImageSize->{94, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305924044]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", "n"}], "]"}], 
    RowBox[{"3", "^", "n"}]}], " ", ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52080330],

Cell[BoxData[
 SqrtBox[
  FractionBox[
   RowBox[{"3", "+", "z"}], "z"]]], "Output",
 ImageSize->{55, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->436774652]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BernoulliB", "[", 
     RowBox[{"n", ",", "x"}], "]"}], "/", 
    RowBox[{"n", "!"}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->126363023],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"x", "/", "z"}]], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox["1", "z"]]}], ")"}], " ", "z"}]]], "Output",
 ImageSize->{75, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->568494590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38559627],

Cell["In general special functions are needed: ", "ExampleText",
 CellID->34939042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "a"}], ")"}], "^", "2"}]}], ",", "n", ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3714903],

Cell[BoxData[
 RowBox[{"LerchPhi", "[", 
  RowBox[{
   FractionBox["1", "z"], ",", "2", ",", "a"}], "]"}]], "Output",
 ImageSize->{122, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36818776]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", "n"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], "^", "2"}]}], ",", "n", ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12893803],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "z", " ", 
  RowBox[{"PolyLog", "[", 
   RowBox[{"2", ",", 
    FractionBox["2", "z"]}], "]"}]}]], "Output",
 ImageSize->{121, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->234736011]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"n", "!"}], "^", "2"}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->51340894],

Cell[BoxData[
 RowBox[{"BesselI", "[", 
  RowBox[{"0", ",", 
   FractionBox["2", 
    SqrtBox["z"]]}], "]"}]], "Output",
 ImageSize->{114, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->684901497]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "!"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "n"}], "+", "1"}], ")"}], "!"}]}], ")"}]}], ",", "n", 
   ",", "z"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->271789648],

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", "3"], ",", "1", ",", 
     FractionBox["4", "3"]}], "}"}], ",", 
   FractionBox["1", 
    RowBox[{"27", " ", "z"}]]}], "]"}]], "Output",
 ImageSize->{268, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->201027576]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32127],

Cell["Compute the generating function:", "ExampleText",
 CellID->557312344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"n", "!"}]}], ",", "n", ",", 
   RowBox[{"1", "/", "z"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48873316],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", "z"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64384651]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesCoefficient", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->295257941],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"n", "!"}]]], "Output",
 ImageSize->{24, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->167563340]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20915],

Cell["Solving difference equations:", "ExampleText",
 CellID->82227714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", 
      RowBox[{"n", "+", "2"}], "]"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"y", "[", 
       RowBox[{"n", "+", "1"}], "]"}]}], "-", 
     RowBox[{"3", " ", 
      RowBox[{"y", "[", "n", "]"}]}]}], "\[Equal]", "0"}], ",", "n", ",", 
   "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121364303],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["z", "2"]}], " ", 
    RowBox[{"y", "[", "0", "]"}]}], "-", 
   RowBox[{"z", " ", 
    RowBox[{"y", "[", "1", "]"}]}], "-", 
   RowBox[{"3", " ", 
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["z", "2"], " ", 
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "z"}], " ", 
       RowBox[{"y", "[", "0", "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"ZTransform", "[", 
        RowBox[{
         RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}]}], 
     ")"}]}]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{460, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212500414]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"%", ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "\[Equal]", "2"}]}], "}"}], ",", 
   RowBox[{"ZTransform", "[", 
    RowBox[{
     RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->801988935],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{"2", " ", "z"}], 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"2", " ", "z"}], "+", 
      SuperscriptBox["z", "2"]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{270, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->624622492]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}], "/.", 
    RowBox[{"First", "[", "%", "]"}]}], ",", "z", ",", "n"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->187986390],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "3"}], ")"}], "n"]}], ")"}]}]], "Output",
 ImageSize->{86, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->570641513]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"n", "+", "2"}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"y", "[", 
         RowBox[{"n", "+", "1"}], "]"}]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"y", "[", "n", "]"}]}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "\[Equal]", "2"}]}], "}"}], ",", 
   RowBox[{"y", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->147578292],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "3"}], ")"}], "n"]}], ")"}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{158, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->336776233]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->308867498],

Cell["Compute the spectrum of a sequence:", "ExampleText",
 CellID->16493420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"n", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"n", "/", "5"}], "]"}]}], ",", "n", ",", 
   RowBox[{"Exp", "[", 
    RowBox[{"I", " ", "\[Omega]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38111579],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]"}], "5"]]}], ")"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      FractionBox["\[ImaginaryI]", "5"], "+", 
      RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Omega]"}]]}], ")"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox["\[ImaginaryI]", "5"]], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", "\[ImaginaryI]"}], "5"], "+", 
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]}]], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         FractionBox["\[ImaginaryI]", "5"], "+", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Omega]"}]}]], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}], ")"}], 
     "2"]}]]}]], "Output",
 ImageSize->{198, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->350499680]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "%", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->413049254],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->514329928]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6852],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["InverseZTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseZTransform"]], "InlineFormula"],
 " to get the sequence from its transform:"
}], "ExampleText",
 CellID->558104711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"ZTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}], ",", "z", ",",
    "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87244332],

Cell[BoxData[
 RowBox[{"f", "[", "n", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120373906]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"InverseZTransform", "[", 
    RowBox[{
     RowBox[{"F", "[", "z", "]"}], ",", "z", ",", "n"}], "]"}], ",", "n", ",",
    "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->75159072],

Cell[BoxData[
 RowBox[{"F", "[", "z", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->473024391]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "n"}], " ", 
    RowBox[{"Sin", "[", "n", "]"}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10323952],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", "a", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]"}]]}], ")"}], " ", "z"}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"]}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]"}]]}], ")"}], " ", "z"}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"], " ", 
      SuperscriptBox["z", "2"]}]}], ")"}]}]]], "Output",
 ImageSize->{195, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->519936547]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseZTransform", "[", 
   RowBox[{"%", ",", "z", ",", "n"}], "]"}], "//", "FullSimplify"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->628545852],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "n"], " ", 
  RowBox[{"Sin", "[", "n", "]"}]}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->286476881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->82517522],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ZTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZTransform"]], "InlineFormula"],
 " effectively computes an infinite sum:"
}], "ExampleText",
 CellID->21957313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"n", "^", "2"}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155876232],

Cell[BoxData[
 FractionBox[
  RowBox[{"z", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "z"}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "z"}], ")"}], "3"]]], "Output",
 ImageSize->{62, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->651565683]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "^", "2"}], " ", 
    RowBox[{"z", "^", 
     RowBox[{"(", 
      RowBox[{"-", "n"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33969181],

Cell[BoxData[
 FractionBox[
  RowBox[{"z", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "z"}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "z"}], ")"}], "3"]]], "Output",
 ImageSize->{62, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->718124461]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->719859389],

Cell["Linearity:", "ExampleText",
 CellID->480868680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"f", "[", "n", "]"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"g", "[", "n", "]"}]}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->562621399],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", 
   RowBox[{"ZTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}], "+", 
  RowBox[{"b", " ", 
   RowBox[{"ZTransform", "[", 
    RowBox[{
     RowBox[{"g", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}]}]], "Output",\

 ImageSize->{334, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14884900]
}, Open  ]],

Cell["Shifting:", "ExampleText",
 CellID->264432954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"n", "+", "2"}], "]"}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10343846],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["z", "2"]}], " ", 
   RowBox[{"f", "[", "0", "]"}]}], "-", 
  RowBox[{"z", " ", 
   RowBox[{"f", "[", "1", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["z", "2"], " ", 
   RowBox[{"ZTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}]}]], "Output",\

 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45466556]
}, Open  ]],

Cell["Convolution:", "ExampleText",
 CellID->167095519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "k", "]"}], 
      RowBox[{"g", "[", 
       RowBox[{"k", "-", "n"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "n", ",", "z"}],
   "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->148100890],

Cell[BoxData[
 RowBox[{
  RowBox[{"ZTransform", "[", 
   RowBox[{
    RowBox[{"f", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}], " ", 
  RowBox[{"ZTransform", "[", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"-", "n"}], "]"}], ",", "n", ",", "z"}], "]"}]}]], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1094763]
}, Open  ]],

Cell["Derivative:", "ExampleText",
 CellID->330163820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"n", " ", 
    RowBox[{"f", "[", "n", "]"}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->447704795],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "z"}], " ", 
  RowBox[{
   SuperscriptBox["ZTransform", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "0", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{
    RowBox[{"f", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}]], "Output",
 ImageSize->{206, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->74662734]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292983636],

Cell["Initial value property:", "ExampleText",
 CellID->211477879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "^", "2"}], "+", "1"}], ")"}], 
    RowBox[{"2", "^", 
     RowBox[{"(", 
      RowBox[{"-", "n"}], ")"}]}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408035895],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", "z"}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", "z"}]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "z", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "z"}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "z"}]}], ")"}], "3"]]}]], "Output",
 ImageSize->{140, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->607686046]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", "^", "2"}], "+", "1"}], ")"}], 
     RowBox[{"2", "^", 
      RowBox[{"(", 
       RowBox[{"-", "n"}], ")"}]}]}], ",", 
    RowBox[{"n", "\[Rule]", "0"}]}], "]"}], "\[Equal]", 
  RowBox[{"Limit", "[", 
   RowBox[{"%", ",", 
    RowBox[{"z", "\[Rule]", "Infinity"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->434021329],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->271469731]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->98470980],

Cell["Final value property:", "ExampleText",
 CellID->50217804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "^", "2"}], "+", "1"}], ")"}], 
    RowBox[{"2", "^", 
     RowBox[{"(", 
      RowBox[{"-", "n"}], ")"}]}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->435034005],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", "z"}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", "z"}]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "z", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "z"}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "z"}]}], ")"}], "3"]]}]], "Output",
 ImageSize->{140, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159072649]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", "^", "2"}], "+", "1"}], ")"}], 
     RowBox[{"2", "^", 
      RowBox[{"(", 
       RowBox[{"-", "n"}], ")"}]}]}], ",", 
    RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}], "\[Equal]", 
  RowBox[{"Limit", "[", 
   RowBox[{"%", ",", 
    RowBox[{"z", "\[Rule]", "0"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->282504525],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9826167]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26532],

Cell[TextData[{
 "The region of convergence is ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Abs",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Abs"], "[", 
    StyleBox["a", "TI"], "]"}], "<", 
   RowBox[{
    ButtonBox["Abs",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Abs"], "[", 
    StyleBox["z", "TI"], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->292175271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"a", "^", "n"}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->273157867],

Cell[BoxData[
 FractionBox["z", 
  RowBox[{
   RowBox[{"-", "a"}], "+", "z"}]]], "Output",
 ImageSize->{43, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29039076]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92722465],

Cell["Use simplification to get a desired form:", "ExampleText",
 CellID->46486646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320167132],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]"}]]}], ")"}], " ", "z"}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"z", "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]"}]], " ", "z"}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["z", "2"]}], ")"}]}]}], ")"}]}]]], "Output",
 ImageSize->{156, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96153964]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "ExpToTrig"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->845348196],

Cell[BoxData[
 FractionBox[
  RowBox[{"z", " ", 
   RowBox[{"Sin", "[", "1", "]"}]}], 
  RowBox[{"1", "+", 
   SuperscriptBox["z", "2"], "-", 
   RowBox[{"2", " ", "z", " ", 
    RowBox[{"Cos", "[", "1", "]"}]}]}]]], "Output",
 ImageSize->{115, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23311813]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28930],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseZTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseZTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LaplaceTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LaplaceTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Series",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Series"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RSolve"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19291]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8536],

Cell[TextData[ButtonBox["Integral Transforms and Related Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegralTransformsAndRelatedOperations"]], "Tutorials",
 CellID->19052]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->522914233],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->769337420],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "MoreAbout",
 CellID->217715334],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->388321550]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ZTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 10.9940398}", "context" -> "System`", 
    "keywords" -> {
     "chirp Z transform", "control theory", "Dirichlet series", 
      "discrete Laplace transform", "formal power series", 
      "generating functions", "Laplace transform", "power series", 
      "signal processing"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ZTransform[expr, n, z] gives the Z transform of expr. ", 
    "synonyms" -> {}, "title" -> "ZTransform", "type" -> "Symbol", "uri" -> 
    "ref/ZTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4886, 155, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->570448461]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45992, 1767}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2529, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3152, 86, 47, 1, 70, "ObjectName",
 CellID->7856],
Cell[3202, 89, 642, 21, 70, "Usage",
 CellID->31448]
}, Open  ]],
Cell[CellGroupData[{
Cell[3881, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4359, 132, 490, 18, 70, "Notes",
 CellID->18764]
}, Closed]],
Cell[CellGroupData[{
Cell[4886, 155, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->570448461],
Cell[CellGroupData[{
Cell[5271, 169, 148, 5, 70, "ExampleSection",
 CellID->384024909],
Cell[5422, 176, 65, 1, 70, "ExampleText",
 CellID->104740162],
Cell[CellGroupData[{
Cell[5512, 181, 261, 9, 28, "Input",
 CellID->288857379],
Cell[5776, 192, 405, 15, 54, "Output",
 CellID->65525579]
}, Open  ]],
Cell[6196, 210, 125, 3, 70, "ExampleDelimiter",
 CellID->134657624],
Cell[6324, 215, 73, 1, 70, "ExampleText",
 CellID->13943179],
Cell[CellGroupData[{
Cell[6422, 220, 193, 6, 70, "Input",
 CellID->317050959],
Cell[6618, 228, 381, 14, 36, "Output",
 CellID->426255861]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7048, 248, 215, 7, 70, "ExampleSection",
 CellID->4529],
Cell[7266, 257, 98, 1, 70, "ExampleText",
 CellID->352989390],
Cell[CellGroupData[{
Cell[7389, 262, 163, 5, 70, "Input",
 CellID->434907548],
Cell[7555, 269, 219, 8, 49, "Output",
 CellID->18725996]
}, Open  ]],
Cell[CellGroupData[{
Cell[7811, 282, 261, 9, 70, "Input",
 CellID->605542198],
Cell[8075, 293, 530, 19, 59, "Output",
 CellID->85164064]
}, Open  ]],
Cell[CellGroupData[{
Cell[8642, 317, 195, 6, 70, "Input",
 CellID->107547796],
Cell[8840, 325, 777, 24, 64, "Output",
 CellID->490145902]
}, Open  ]],
Cell[CellGroupData[{
Cell[9654, 354, 219, 7, 70, "Input",
 CellID->8043162],
Cell[9876, 363, 1054, 33, 65, "Output",
 CellID->367522736]
}, Open  ]],
Cell[CellGroupData[{
Cell[10967, 401, 250, 8, 70, "Input",
 CellID->15176741],
Cell[11220, 411, 296, 11, 56, "Output",
 CellID->185105744]
}, Open  ]],
Cell[CellGroupData[{
Cell[11553, 427, 255, 8, 70, "Input",
 CellID->46316786],
Cell[11811, 437, 225, 8, 55, "Output",
 CellID->31877664]
}, Open  ]],
Cell[12051, 448, 125, 3, 70, "ExampleDelimiter",
 CellID->593730630],
Cell[12179, 453, 70, 1, 70, "ExampleText",
 CellID->70516747],
Cell[CellGroupData[{
Cell[12274, 458, 333, 13, 70, "Input",
 CellID->6313372],
Cell[12610, 473, 258, 10, 55, "Output",
 CellID->305924044]
}, Open  ]],
Cell[CellGroupData[{
Cell[12905, 488, 277, 9, 70, "Input",
 CellID->52080330],
Cell[13185, 499, 214, 8, 60, "Output",
 CellID->436774652]
}, Open  ]],
Cell[CellGroupData[{
Cell[13436, 512, 248, 8, 70, "Input",
 CellID->126363023],
Cell[13687, 522, 399, 14, 73, "Output",
 CellID->568494590]
}, Open  ]],
Cell[14101, 539, 124, 3, 70, "ExampleDelimiter",
 CellID->38559627],
Cell[14228, 544, 83, 1, 70, "ExampleText",
 CellID->34939042],
Cell[CellGroupData[{
Cell[14336, 549, 242, 9, 70, "Input",
 CellID->3714903],
Cell[14581, 560, 247, 8, 51, "Output",
 CellID->36818776]
}, Open  ]],
Cell[CellGroupData[{
Cell[14865, 573, 268, 10, 70, "Input",
 CellID->12893803],
Cell[15136, 585, 293, 10, 51, "Output",
 CellID->234736011]
}, Open  ]],
Cell[CellGroupData[{
Cell[15466, 600, 208, 7, 70, "Input",
 CellID->51340894],
Cell[15677, 609, 251, 9, 55, "Output",
 CellID->684901497]
}, Open  ]],
Cell[CellGroupData[{
Cell[15965, 623, 339, 13, 70, "Input",
 CellID->271789648],
Cell[16307, 638, 409, 14, 52, "Output",
 CellID->201027576]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16765, 658, 239, 7, 70, "ExampleSection",
 CellID->32127],
Cell[17007, 667, 75, 1, 70, "ExampleText",
 CellID->557312344],
Cell[CellGroupData[{
Cell[17107, 672, 206, 7, 70, "Input",
 CellID->48873316],
Cell[17316, 681, 194, 6, 36, "Output",
 CellID->64384651]
}, Open  ]],
Cell[CellGroupData[{
Cell[17547, 692, 195, 6, 70, "Input",
 CellID->295257941],
Cell[17745, 700, 196, 7, 51, "Output",
 CellID->167563340]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17990, 713, 223, 7, 70, "ExampleSection",
 CellID->20915],
Cell[18216, 722, 71, 1, 70, "ExampleText",
 CellID->82227714],
Cell[CellGroupData[{
Cell[18312, 727, 411, 14, 70, "Input",
 CellID->121364303],
Cell[18726, 743, 991, 33, 54, "Output",
 CellID->212500414]
}, Open  ]],
Cell[CellGroupData[{
Cell[19754, 781, 420, 14, 70, "Input",
 CellID->801988935],
Cell[20177, 797, 503, 17, 53, "Output",
 CellID->624622492]
}, Open  ]],
Cell[CellGroupData[{
Cell[20717, 819, 314, 10, 70, "Input",
 CellID->187986390],
Cell[21034, 831, 322, 12, 51, "Output",
 CellID->570641513]
}, Open  ]],
Cell[CellGroupData[{
Cell[21393, 848, 639, 20, 70, "Input",
 CellID->147578292],
Cell[22035, 870, 451, 17, 51, "Output",
 CellID->336776233]
}, Open  ]],
Cell[22501, 890, 125, 3, 70, "ExampleDelimiter",
 CellID->308867498],
Cell[22629, 895, 77, 1, 70, "ExampleText",
 CellID->16493420],
Cell[CellGroupData[{
Cell[22731, 900, 283, 9, 70, "Input",
 CellID->38111579],
Cell[23017, 911, 1421, 41, 91, "Output",
 CellID->350499680]
}, Open  ]],
Cell[CellGroupData[{
Cell[24475, 957, 320, 10, 70, "Input",
 CellID->413049254],
Cell[24798, 969, 2742, 49, 70, "Output",
 Evaluatable->False,
 CellID->514329928]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27589, 1024, 232, 7, 70, "ExampleSection",
 CellID->6852],
Cell[27824, 1033, 244, 8, 70, "ExampleText",
 CellID->558104711],
Cell[CellGroupData[{
Cell[28093, 1045, 253, 8, 70, "Input",
 CellID->87244332],
Cell[28349, 1055, 185, 6, 36, "Output",
 CellID->120373906]
}, Open  ]],
Cell[CellGroupData[{
Cell[28571, 1066, 253, 8, 70, "Input",
 CellID->75159072],
Cell[28827, 1076, 185, 6, 36, "Output",
 CellID->473024391]
}, Open  ]],
Cell[CellGroupData[{
Cell[29049, 1087, 219, 7, 70, "Input",
 CellID->10323952],
Cell[29271, 1096, 882, 27, 64, "Output",
 CellID->519936547]
}, Open  ]],
Cell[CellGroupData[{
Cell[30190, 1128, 184, 6, 70, "Input",
 CellID->628545852],
Cell[30377, 1136, 234, 8, 36, "Output",
 CellID->286476881]
}, Open  ]],
Cell[30626, 1147, 124, 3, 70, "ExampleDelimiter",
 CellID->82517522],
Cell[30753, 1152, 218, 7, 70, "ExampleText",
 CellID->21957313],
Cell[CellGroupData[{
Cell[30996, 1163, 163, 5, 70, "Input",
 CellID->155876232],
Cell[31162, 1170, 344, 13, 54, "Output",
 CellID->651565683]
}, Open  ]],
Cell[CellGroupData[{
Cell[31543, 1188, 309, 11, 70, "Input",
 CellID->33969181],
Cell[31855, 1201, 344, 13, 54, "Output",
 CellID->718124461]
}, Open  ]],
Cell[32214, 1217, 125, 3, 70, "ExampleDelimiter",
 CellID->719859389],
Cell[32342, 1222, 53, 1, 70, "ExampleText",
 CellID->480868680],
Cell[CellGroupData[{
Cell[32420, 1227, 275, 9, 70, "Input",
 CellID->562621399],
Cell[32698, 1238, 436, 15, 36, "Output",
 CellID->14884900]
}, Open  ]],
Cell[33149, 1256, 52, 1, 70, "ExampleText",
 CellID->264432954],
Cell[CellGroupData[{
Cell[33226, 1261, 192, 6, 70, "Input",
 CellID->10343846],
Cell[33421, 1269, 493, 18, 36, "Output",
 CellID->45466556]
}, Open  ]],
Cell[33929, 1290, 55, 1, 70, "ExampleText",
 CellID->167095519],
Cell[CellGroupData[{
Cell[34009, 1295, 374, 13, 70, "Input",
 CellID->148100890],
Cell[34386, 1310, 402, 13, 36, "Output",
 CellID->1094763]
}, Open  ]],
Cell[34803, 1326, 54, 1, 70, "ExampleText",
 CellID->330163820],
Cell[CellGroupData[{
Cell[34882, 1331, 193, 6, 70, "Input",
 CellID->447704795],
Cell[35078, 1339, 446, 16, 36, "Output",
 CellID->74662734]
}, Open  ]],
Cell[35539, 1358, 125, 3, 70, "ExampleDelimiter",
 CellID->292983636],
Cell[35667, 1363, 66, 1, 70, "ExampleText",
 CellID->211477879],
Cell[CellGroupData[{
Cell[35758, 1368, 309, 11, 70, "Input",
 CellID->408035895],
Cell[36070, 1381, 553, 21, 54, "Output",
 CellID->607686046]
}, Open  ]],
Cell[CellGroupData[{
Cell[36660, 1407, 457, 16, 70, "Input",
 CellID->434021329],
Cell[37120, 1425, 161, 5, 36, "Output",
 CellID->271469731]
}, Open  ]],
Cell[37296, 1433, 124, 3, 70, "ExampleDelimiter",
 CellID->98470980],
Cell[37423, 1438, 63, 1, 70, "ExampleText",
 CellID->50217804],
Cell[CellGroupData[{
Cell[37511, 1443, 309, 11, 70, "Input",
 CellID->435034005],
Cell[37823, 1456, 553, 21, 54, "Output",
 CellID->159072649]
}, Open  ]],
Cell[CellGroupData[{
Cell[38413, 1482, 457, 16, 70, "Input",
 CellID->282504525],
Cell[38873, 1500, 159, 5, 36, "Output",
 CellID->9826167]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39081, 1511, 226, 7, 70, "ExampleSection",
 CellID->26532],
Cell[39310, 1520, 408, 16, 70, "ExampleText",
 CellID->292175271],
Cell[CellGroupData[{
Cell[39743, 1540, 163, 5, 70, "Input",
 CellID->273157867],
Cell[39909, 1547, 219, 8, 49, "Output",
 CellID->29039076]
}, Open  ]],
Cell[40143, 1558, 124, 3, 70, "ExampleDelimiter",
 CellID->92722465],
Cell[40270, 1563, 83, 1, 70, "ExampleText",
 CellID->46486646],
Cell[CellGroupData[{
Cell[40378, 1568, 170, 5, 70, "Input",
 CellID->320167132],
Cell[40551, 1575, 728, 23, 64, "Output",
 CellID->96153964]
}, Open  ]],
Cell[CellGroupData[{
Cell[41316, 1603, 132, 4, 70, "Input",
 CellID->845348196],
Cell[41451, 1609, 356, 12, 54, "Output",
 CellID->23311813]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41868, 1628, 311, 9, 70, "SeeAlsoSection",
 CellID->28930],
Cell[42182, 1639, 1202, 44, 70, "SeeAlso",
 CellID->19291]
}, Open  ]],
Cell[CellGroupData[{
Cell[43421, 1688, 313, 9, 70, "TutorialsSection",
 CellID->8536],
Cell[43737, 1699, 194, 4, 70, "Tutorials",
 CellID->19052]
}, Open  ]],
Cell[CellGroupData[{
Cell[43968, 1708, 319, 9, 70, "MoreAboutSection",
 CellID->522914233],
Cell[44290, 1719, 151, 3, 70, "MoreAbout",
 CellID->769337420],
Cell[44444, 1724, 149, 3, 70, "MoreAbout",
 CellID->217715334],
Cell[44596, 1729, 145, 3, 70, "MoreAbout",
 CellID->388321550]
}, Open  ]],
Cell[44756, 1735, 27, 0, 70, "History"],
Cell[44786, 1737, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

