(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21951,        822]
NotebookOptionsPosition[     16254,        637]
NotebookOutlinePosition[     18995,        709]
CellTagsIndexPosition[     18904,        703]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsOverview"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], "Append" :> 
          Documentation`HelpLookup["paclet:ref/Append"], "Delete" :> 
          Documentation`HelpLookup["paclet:ref/Delete"], "Insert" :> 
          Documentation`HelpLookup["paclet:ref/Insert"], "Prepend" :> 
          Documentation`HelpLookup["paclet:ref/Prepend"], "ReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/ReplacePart"], "Riffle" :> 
          Documentation`HelpLookup["paclet:ref/Riffle"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"All\"\>", 2->"\<\"Append\"\>", 
       3->"\<\"Delete\"\>", 4->"\<\"Insert\"\>", 5->"\<\"Prepend\"\>", 
       6->"\<\"ReplacePart\"\>", 7->"\<\"Riffle\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Adding, Removing and Modifying List Elements", "Title",
 CellTags->{"S1.8.6", "6.1"},
 CellID->288],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Prepend",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Prepend"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["element", "TI"], "]"}], Cell[TextData[{
     "add ",
     Cell[BoxData[
      StyleBox["element", "TI"]], "InlineFormula"],
     " at the beginning of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Append",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Append"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["element", "TI"], "]"}], Cell[TextData[{
     "add ",
     Cell[BoxData[
      StyleBox["element", "TI"]], "InlineFormula"],
     " at the end of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Insert",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Insert"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["element", "TI"], ",", 
     StyleBox["i", "TI"], "]"}], Cell[TextData[{
     "insert ",
     Cell[BoxData[
      StyleBox["element", "TI"]], "InlineFormula"],
     " at position ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Insert",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Insert"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["element", "TI"], ",", "-", 
     StyleBox["i", "TI"], "]"}], Cell[TextData[{
     "insert at position ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " counting from the end of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Riffle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Riffle"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      StyleBox["element", "TI"]}], "]"}], Cell[TextData[{
     "interleave ",
     Cell[BoxData[
      StyleBox["element", "TI"]], "InlineFormula"],
     " between the entries of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Delete",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Delete"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["i", "TI"], "]"}], Cell[TextData[{
     "delete the element at position ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ReplacePart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReplacePart"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{
       StyleBox["i", "TI"], "->", 
       StyleBox["new", "TI"]}]}], "]"}], Cell[TextData[{
     "replace the element at position ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["new", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ReplacePart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReplacePart"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox["i", "TI"], ",", 
         StyleBox["j", "TI"]}], "}"}], "->", 
       StyleBox["new", "TI"]}]}], "]"}], Cell[TextData[{
     "replace ",
     Cell[BoxData[
      RowBox[{
       StyleBox["list", "TI"], "[", "[", 
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"], "]", "]"}]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["new", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, True, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellID->30106],

Cell["Functions for manipulating elements in explicit lists. ", "Caption",
 CellID->9040],

Cell[TextData[{
 "This gives a list with ",
 Cell[BoxData["x"], "InlineFormula"],
 " prepended. "
}], "MathCaption",
 CellID->8942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prepend", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->19264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->22648]
}, Open  ]],

Cell[TextData[{
 "This inserts ",
 Cell[BoxData["x"], "InlineFormula"],
 " so that it becomes element number 2. "
}], "MathCaption",
 CellID->27446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Insert", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x", ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->23805],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "x", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->15890]
}, Open  ]],

Cell[TextData[{
 "This interleaves ",
 Cell[BoxData["x"], "InlineFormula"],
 " between the entries of the list. "
}], "MathCaption",
 CellID->2738295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120674919],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "x", ",", "b", ",", "x", ",", "c"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177961828]
}, Open  ]],

Cell[TextData[{
 "This replaces the third element in the list with ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"3", "->", "x"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->24370],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "x", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->15350]
}, Open  ]],

Cell["\<\
This replaces the 1, 2 element in a 2\[Times]2 matrix. \
\>", "MathCaption",
 CellID->15006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "->", "x"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->31101],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->24393]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["ReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]], "InlineFormula"],
 " take explicit lists and give you new lists. Sometimes, however, you may \
want to modify a list \[OpenCurlyDoubleQuote]in \
place\[CloseCurlyDoubleQuote], without explicitly generating a new list. "
}], "Text",
 CellID->3548],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["v", "TI"], "=", "{", 
     SubscriptBox[
      StyleBox["e", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "assign a variable to be a list", "TableText"]},
   {
    RowBox[{
     StyleBox["v", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]", "=", 
     StyleBox["new", "TI"]}], Cell[TextData[{
     "assign a new value to the ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->19629],

Cell["Resetting list elements. ", "Caption",
 CellID->12623],

Cell[TextData[{
 "This defines ",
 Cell[BoxData["v"], "InlineFormula"],
 " to be a list. "
}], "MathCaption",
 CellID->24084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->19954],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->18756]
}, Open  ]],

Cell[TextData[{
 "This sets the third element to be ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"[", "3", "]"}], "]"}], "=", "x"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->4966],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->7376]
}, Open  ]],

Cell[TextData[{
 "Now ",
 Cell[BoxData["v"], "InlineFormula"],
 " has been changed. "
}], "MathCaption",
 CellID->13931],

Cell[CellGroupData[{

Cell[BoxData["v"], "Input",
 CellLabel->"In[7]:= ",
 CellID->26308],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "x", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->16944]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], "]", "]", "=", 
     StyleBox["new", "TI"]}], Cell[TextData[{
     "replace the ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], ")"}]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element of a matrix"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]", "=", 
     StyleBox["new", "TI"]}], Cell[TextData[{
     "replace the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " row"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["i", "TI"], "]", "]", "=", 
     StyleBox["new", "TI"]}], Cell[TextData[{
     "replace the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " column"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->32439],

Cell["Resetting pieces of matrices. ", "Caption",
 CellID->24626],

Cell[TextData[{
 "This defines ",
 Cell[BoxData["m"], "InlineFormula"],
 " to be a matrix. "
}], "MathCaption",
 CellID->11323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->5537],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->21538]
}, Open  ]],

Cell["This sets the first column of the matrix. ", "MathCaption",
 CellID->16118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";", "m"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->2082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->22929]
}, Open  ]],

Cell[TextData[{
 "This sets every element in the first column to be ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", "0"}], ";", "m"}]], "Input",\

 CellLabel->"In[10]:= ",
 CellID->4833],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->31115]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->266735773],

Cell[TextData[ButtonBox["Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsOverview"]], "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Adding, Removing and Modifying List Elements - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Lists", "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ListsOverview"]], "Text", FontFamily -> "Verdana"], 
    "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TestingAndSearchingListElements"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/CombiningLists"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 25.1693496}", "context" -> "", 
    "keywords" -> {
     "addition", "all", "Append", "appending", "changing parts", "columns", 
      "Delete", "deleting elements", "Insert", "lists", "matrices", "parts", 
      "Prepend", "removing elements from lists", "replacements", 
      "ReplacePart", "rows", "shortening lists"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Functions for manipulating elements in explicit lists. This gives a list \
with x prepended. This inserts x so that it becomes element number 2. ", 
    "synonyms" -> {"1.8.6"}, "title" -> 
    "Adding, Removing and Modifying List Elements", "type" -> "Tutorial", 
    "uri" -> "tutorial/AddingRemovingAndModifyingListElements"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.8.6"->{
  Cell[2306, 64, 105, 2, 70, "Title",
   CellTags->{"S1.8.6", "6.1"},
   CellID->288]},
 "6.1"->{
  Cell[2306, 64, 105, 2, 70, "Title",
   CellTags->{"S1.8.6", "6.1"},
   CellID->288]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.8.6", 18695, 692},
 {"6.1", 18793, 696}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1681, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2306, 64, 105, 2, 70, "Title",
 CellTags->{"S1.8.6", "6.1"},
 CellID->288],
Cell[2414, 68, 4104, 140, 70, "DefinitionBox",
 CellID->30106],
Cell[6521, 210, 89, 1, 70, "Caption",
 CellID->9040],
Cell[6613, 213, 131, 5, 70, "MathCaption",
 CellID->8942],
Cell[CellGroupData[{
Cell[6769, 222, 182, 6, 28, "Input",
 CellID->19264],
Cell[6954, 230, 220, 7, 36, "Output",
 CellID->22648]
}, Open  ]],
Cell[7189, 240, 148, 5, 70, "MathCaption",
 CellID->27446],
Cell[CellGroupData[{
Cell[7362, 249, 194, 7, 28, "Input",
 CellID->23805],
Cell[7559, 258, 220, 7, 36, "Output",
 CellID->15890]
}, Open  ]],
Cell[7794, 268, 150, 5, 70, "MathCaption",
 CellID->2738295],
Cell[CellGroupData[{
Cell[7969, 277, 184, 6, 28, "Input",
 CellID->120674919],
Cell[8156, 285, 233, 7, 36, "Output",
 CellID->177961828]
}, Open  ]],
Cell[8404, 295, 147, 5, 70, "MathCaption",
 CellID->6729],
Cell[CellGroupData[{
Cell[8576, 304, 221, 7, 70, "Input",
 CellID->24370],
Cell[8800, 313, 220, 7, 36, "Output",
 CellID->15350]
}, Open  ]],
Cell[9035, 323, 102, 3, 70, "MathCaption",
 CellID->15006],
Cell[CellGroupData[{
Cell[9162, 330, 358, 13, 70, "Input",
 CellID->31101],
Cell[9523, 345, 299, 11, 36, "Output",
 CellID->24393]
}, Open  ]],
Cell[9837, 359, 389, 10, 70, "Text",
 CellID->3548],
Cell[10229, 371, 717, 24, 70, "DefinitionBox",
 CellID->19629],
Cell[10949, 397, 60, 1, 70, "Caption",
 CellID->12623],
Cell[11012, 400, 125, 5, 70, "MathCaption",
 CellID->24084],
Cell[CellGroupData[{
Cell[11162, 409, 156, 5, 70, "Input",
 CellID->19954],
Cell[11321, 416, 220, 7, 36, "Output",
 CellID->18756]
}, Open  ]],
Cell[11556, 426, 133, 5, 70, "MathCaption",
 CellID->11840],
Cell[CellGroupData[{
Cell[11714, 435, 140, 5, 70, "Input",
 CellID->4966],
Cell[11857, 442, 154, 5, 36, "Output",
 CellID->7376]
}, Open  ]],
Cell[12026, 450, 120, 5, 70, "MathCaption",
 CellID->13931],
Cell[CellGroupData[{
Cell[12171, 459, 67, 2, 70, "Input",
 CellID->26308],
Cell[12241, 463, 220, 7, 36, "Output",
 CellID->16944]
}, Open  ]],
Cell[12476, 473, 1358, 48, 70, "DefinitionBox",
 CellID->32439],
Cell[13837, 523, 65, 1, 70, "Caption",
 CellID->24626],
Cell[13905, 526, 127, 5, 70, "MathCaption",
 CellID->11323],
Cell[CellGroupData[{
Cell[14057, 535, 237, 9, 70, "Input",
 CellID->5537],
Cell[14297, 546, 299, 11, 36, "Output",
 CellID->21538]
}, Open  ]],
Cell[14611, 560, 81, 1, 70, "MathCaption",
 CellID->16118],
Cell[CellGroupData[{
Cell[14717, 565, 242, 9, 70, "Input",
 CellID->2082],
Cell[14962, 576, 299, 11, 36, "Output",
 CellID->22929]
}, Open  ]],
Cell[15276, 590, 149, 5, 70, "MathCaption",
 CellID->16541],
Cell[CellGroupData[{
Cell[15450, 599, 196, 8, 70, "Input",
 CellID->4833],
Cell[15649, 609, 300, 11, 36, "Output",
 CellID->31115]
}, Open  ]],
Cell[CellGroupData[{
Cell[15986, 625, 72, 1, 70, "RelatedTutorialsSection",
 CellID->266735773],
Cell[16061, 628, 139, 3, 70, "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],
Cell[16227, 635, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

