(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    135518,       3774]
NotebookOptionsPosition[    126442,       3514]
NotebookOutlinePosition[    128432,       3559]
CellTagsIndexPosition[    128389,       3556]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Manipulate" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntroductionToManipulate"], 
          "Introduction to Dynamic" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntroductionToDynamic"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Introduction to Manipulate\"\>", 
       2->"\<\"Introduction to Dynamic\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Dynamic Interactivity Language\"\>", 
       2->"\<\"Dynamic Visualization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Advanced Manipulate Functionality", "Title"],

Cell[TextData[{
 "This tutorial covers advanced features of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " command. It assumes that you have read ",
 ButtonBox["Introduction to Manipulate",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToManipulate"],
 " and thus have a good idea what the command is for and how it works \
overall."
}], "Text"],

Cell[TextData[{
 "This tutorial also, in places, assumes a familiarity with the lower level \
dynamic mechanism covered in ",
 ButtonBox["Introduction to Dynamic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToDynamic"],
 " and ",
 ButtonBox["Advanced Dynamic Functionality",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"],
 "."
}], "Text"],

Cell[TextData[{
 "Please note that this is a ",
 StyleBox["hands-on",
  FontSlant->"Italic"],
 " tutorial. You are expected to actually evaluate each input line as you \
reach it in your reading, and watch what happens. The accompanying text will \
not make sense without evaluating as you read."
}], "TextEmphasisNote",
 CellID->244159640],

Cell[CellGroupData[{

Cell["Controlling Automatic Reevaluation", "Section"],

Cell[TextData[{
 "Some ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " examples \"spin,\" continually reevaluating their contents even when no \
sliders are being moved. Sometimes this is in fact exactly what you intend. \
For example, here is a droopy triangle, which always sags down in the middle. \
You can drag it back up using the slider, but as soon as you stop moving, it \
starts falling down again."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "=", 
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"y", "-", "0.05"}]}], "]"}]}], ";", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y", ",", "1"}], "}"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`y$$ = -1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`y$$], 1}, -1, 1}}, Typeset`size$$ = {
    180., {88., 92.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`y$59015$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`y$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`y$$, $CellContext`y$59015$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`y$$ = Max[-1, $CellContext`y$$ - 0.05]; 
       Graphics[
         Polygon[{{-1, 1}, {0, $CellContext`y$$}, {1, 1}}], PlotRange -> 1]), 
      "Specifications" :> {{{$CellContext`y$$, 1}, -1, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {131., 136.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 269},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "This happens because the variable ",
 Cell[BoxData["y"], "InlineFormula"],
 " is being changed by the code in the first argument, and the system, \
correctly and helpfully, notices that since the value of ",
 Cell[BoxData["y"], "InlineFormula"],
 " has changed, the contents need to be evaluated and displayed again, which \
in turn causes the value of ",
 Cell[BoxData["y"], "InlineFormula"],
 " to change again, and so on, until, in this case, we reach a stable point \
at ",
 Cell[BoxData["y"], "InlineFormula"],
 Cell[BoxData[
  RowBox[{"=", 
   RowBox[{"-", "1"}]}]], "InlineFormula"],
 ". After that the value of ",
 Cell[BoxData["y"], "InlineFormula"],
 " no longer changes, and the contents are no longer continually redrawn, \
until you touch the slider again. (If you have a CPU activity monitor on your \
system you can verify that while the triangle is drooping, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is using CPU time, but once it reaches the bottom, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s CPU usage stops.)"
}], "Text",
 CellID->595448231],

Cell[TextData[{
 "Of course it is possible to construct examples that ",
 StyleBox["do not",
  FontSlant->"Italic"],
 " stop. Here we declare two variables, both initialized to zero, and include \
code in the body of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " to continuously update the value of one of them based on the value of the \
other."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"total", "=", 
     RowBox[{"total", "+", "step"}]}], ";", 
    RowBox[{"{", 
     RowBox[{"step", ",", "total"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"total", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "1000"}], ",", "1000", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"step", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "10"}], ",", "10", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`step$$ = 0, $CellContext`total$$ = 0, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`total$$], 0}, -1000, 1000, 1}, {{
       Hold[$CellContext`step$$], 0}, -10, 10, 1}}, Typeset`size$$ = {
    39.1875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`total$4067$$ = 
    0, $CellContext`step$4068$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`step$$ = 0, $CellContext`total$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`total$$, $CellContext`total$4067$$, 0], 
        Hold[$CellContext`step$$, $CellContext`step$4068$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`total$$ = $CellContext`total$$ + \
$CellContext`step$$; {$CellContext`step$$, $CellContext`total$$}), 
      "Specifications" :> {{{$CellContext`total$$, 0}, -1000, 1000, 
         1}, {{$CellContext`step$$, 0}, -10, 10, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{263., {62., 67.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{267, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Any time the step size is moved away from zero, the content area will \
continually update, and a CPU monitor will indicate that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is using CPU time. This will go on for as long as you let it. (Fortunately \
it does not totally consume the CPU, and other activities in the front end \
are not hindered by this activity; you can keep editing, evaluating, etc., \
while it is running. You may think of it sort of like an animated image or \
applet running in a web browser.)"
}], "Text"],

Cell["\<\
In some cases, however, the continual reevaluation is pointless and \
undesirable. Consider this somewhat contrived example: any time it is present \
on screen (i.e. in an open window and not scrolled offscreen to the point \
where no part of it is visible), it will constantly re-evaluate itself, \
consuming CPU time even though nothing is changing.\
\>", "Text"],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"temp", "=", "n"}], ";", "\[IndentingNewLine]", 
    RowBox[{"temp", "=", 
     RowBox[{"temp", "^", "3"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "temp"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "This happens because the variable ",
 Cell[BoxData["temp"], "InlineFormula"],
 " has its value changed during the evaluation, even if the value of ",
 Cell[BoxData["n"], "InlineFormula"],
 " has not changed (i.e. it is reset to two different values each time \
through). The spinning is pointless because the value of ",
 Cell[BoxData["temp"], "InlineFormula"],
 " is set before it is ever used."
}], "Text"],

Cell[TextData[{
 "Another way to get inadvertent and pointless spinning is to make a function \
definition or other complex assignment in the body of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", as in this example."
}], "Text"],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ":=", 
     RowBox[{"x", "^", "3"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", 
             RowBox[{"f", "[", "n", "]"}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
      ",", 
      RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "In both these cases, the problem can be solved by making the offending \
variables be local variables inside a ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 ". (This is good programming practice in any case, quite aside from any \
desire to avoid pointless updating.)"
}], "Text"],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "temp", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"temp", "=", "n"}], ";", "\[IndentingNewLine]", 
      RowBox[{"temp", "=", 
       RowBox[{"temp", "^", "3"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"n", ",", "temp"}], "}"}]}], "}"}], "]"}]}], "}"}], ",",
         
        RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "f", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x_", "]"}], ":=", 
       RowBox[{"x", "^", "3"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"n", ",", 
               RowBox[{"f", "[", "n", "]"}]}], "}"}]}], "}"}], "]"}]}], "}"}],
         ",", 
        RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "Nothing you do to local ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " variables will cause retriggering, because it is part of the definition of \
",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " that values do not survive from one invocation to the next (therefore the \
result will not be any different the next time around just because of \
anything done to the value of a local variable during the current cycle)."
}], "Text"],

Cell[TextData[{
 "Another solution is to use the ",
 Cell[BoxData[
  ButtonBox["TrackedSymbols",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrackedSymbols"]], "InlineFormula"],
 " option to ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " to control which variables are allowed to cause updating behavior. The \
default value, ",
 Cell[BoxData[
  ButtonBox["Full",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Full"]], "InlineFormula"],
 ", means that any symbols that appear explicitly (lexically) in the first \
argument will be tracked. (This means, among other things, that temporary \
variables and other such problems inside the definitions of functions you use \
in your ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " example will ",
 StyleBox["not",
  FontSlant->"Italic"],
 " cause infinite reevaluation problems, because they do not occur explicitly \
in the first argument, only indirectly through functions you call.)"
}], "Text"],

Cell[TextData[{
 "Taking the second example, if for some reason you do not want ",
 Cell[BoxData["f"], "InlineFormula"],
 " to be a local ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " variable, and you cannot move its definition outside the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " (there are sometime good reasons for both those conditions, in more \
complicated cases), you can use ",
 Cell[BoxData[
  ButtonBox["TrackedSymbols",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrackedSymbols"]], "InlineFormula"],
 " to disable updating triggered by ",
 Cell[BoxData["f"], "InlineFormula"],
 ":"
}], "Text"],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ":=", 
     RowBox[{"x", "^", "3"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", 
             RowBox[{"f", "[", "n", "]"}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
      ",", 
      RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
   RowBox[{"TrackedSymbols", ":>", 
    RowBox[{"{", "n", "}"}]}]}], "]"}]], "Input"],

Cell[TextData[{
 "This example updates the content area ",
 StyleBox["only",
  FontSlant->"Italic"],
 " when ",
 Cell[BoxData["n"], "InlineFormula"],
 " changes its value as a result of moving the slider."
}], "Text"],

Cell[TextData[{
 "The subject of when exactly a given dynamic expression will be updated is \
complex, and is addressed in ",
 ButtonBox["Introduction to Dynamic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToDynamic"],
 " and ",
 ButtonBox["Advanced Dynamic Functionality",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"],
 ". In reading those, keep in mind that ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " simply wraps its first argument in ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " and passes the value of its ",
 Cell[BoxData[
  ButtonBox["TrackedSymbols",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrackedSymbols"]], "InlineFormula"],
 " option to a ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " inside that. Everything to do with updating is handled by that ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nesting Manipulate", "Section"],

Cell[TextData[{
 "You can put one ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " inside another. For example, here we use a slider in an outer ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " to control the ",
 StyleBox["number",
  FontSlant->"Italic"],
 " of sliders in the inner ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"value", " ", "=", " ", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"c", "[", "i", "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"i", ",", " ", "1", ",", " ", "n"}], "}"}]}], "]"}]}], ",",
        " ", 
       RowBox[{"controls", " ", "=", " ", 
        RowBox[{"Sequence", " ", "@@", " ", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"c", "[", "i", "]"}], ",", " ", "0", ",", " ", "1"}], 
            "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"i", ",", " ", "1", ",", " ", "n"}], "}"}]}], "]"}]}]}]}],
       "}"}], ",", " ", 
     RowBox[{"Manipulate", "[", 
      RowBox[{"value", ",", " ", "controls"}], "]"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "1", ",", " ", "10", ",", " ", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->626161559],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 10, 1}}, Typeset`size$$ = {260., {48., 53.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$417039$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$417039$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> With[{$CellContext`value = Table[
           $CellContext`c[$CellContext`i], {$CellContext`i, 
            1, $CellContext`n$$}], $CellContext`controls = Apply[Sequence, 
           Table[{
             $CellContext`c[$CellContext`i], 0, 1}, {$CellContext`i, 
             1, $CellContext`n$$}]]}, 
        Manipulate[$CellContext`value, $CellContext`controls]], 
      "Specifications" :> {{$CellContext`n$$, 1, 10, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{306., {92., 97.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{310, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->1227451813]
}, Open  ]],

Cell[TextData[{
 "While nesting ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " many levels deep is possible, and will work, ",
 "it is",
 " probably not the most useful feature in the world. But by nesting once, \
you have in effect created a parameterized user interface construction \
interface. The outer ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " allows you to control parameters that determine the user interface \
presented by the inner ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". With some slightly more complex programming than in the example above, \
remarkable things can be done."
}], "Text",
 CellID->1888697762]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interdependent Controls", "Section"],

Cell[TextData[{
 "It is possible to make the range of one slider in a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " depend on the position of another slider. For example, the function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Binomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Binomial"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " makes sense only when ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "<=", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ", so you might want to make an ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 "-slider whose range is from ",
 Cell[BoxData["1"], "InlineFormula"],
 " to the current value of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". You can do this simply by using ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " in the variable specification for ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", like this."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<(\>\"", ",", 
      RowBox[{"Column", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"n", ",", "m"}], "}"}], ",", "Center"}], "]"}], ",", 
      "\"\<) = \>\"", ",", 
      RowBox[{"Binomial", "[", 
       RowBox[{"n", ",", "m"}], "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "1", ",", "n", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`m$$ = 7, $CellContext`n$$ = 7, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 10, 1}, {
      Hold[$CellContext`m$$], 1, 
      Dynamic[$CellContext`n$$], 1}}, Typeset`size$$ = {54.625, {10., 15.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$1025$$ = 0, $CellContext`m$1026$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`m$$ = 1, $CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1025$$, 0], 
        Hold[$CellContext`m$$, $CellContext`m$1026$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Row[{"(", 
         Column[{$CellContext`n$$, $CellContext`m$$}, Center], ") = ", 
         Binomial[$CellContext`n$$, $CellContext`m$$]}], 
      "Specifications" :> {{$CellContext`n$$, 1, 10, 1}, {$CellContext`m$$, 1,
          
         Dynamic[$CellContext`n$$], 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{252., {68., 73.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{256, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Note that if you first move both sliders part way towards the right, then \
move the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "-slider left, the ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 "-slider will automatically move to the right, because its maximum is \
getting smaller. If you move ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " far enough to the left, to the point where it becomes smaller than the \
current value of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 "-slider will display a red \"out of range\" indicator, because ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is now larger than its maximum allowed value."
}], "Text"],

Cell[TextData[{
 "You might wonder why ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is not automatically reset to the current maximum, when the maximum is set \
lower than its current value. The reason is that sometimes it is preferable \
to leave the value alone, and if you want to have it reset automatically, it \
is easy to do manually. For example, you can add an ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " statement to the code in the first argument."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"m", ">", "n"}], ",", 
      RowBox[{"m", "=", "n"}]}], "]"}], ";", 
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<(\>\"", ",", 
       RowBox[{"Column", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"n", ",", "m"}], "}"}], ",", "Center"}], "]"}], ",", 
       "\"\<) = \>\"", ",", 
       RowBox[{"Binomial", "[", 
        RowBox[{"n", ",", "m"}], "]"}]}], "}"}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "1", ",", "n", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`m$$ = 1, $CellContext`n$$ = 3, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 10, 1}, {
      Hold[$CellContext`m$$], 1, 
      Dynamic[$CellContext`n$$], 1}}, Typeset`size$$ = {54.625, {10., 15.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$1068$$ = 0, $CellContext`m$1069$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`m$$ = 1, $CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1068$$, 0], 
        Hold[$CellContext`m$$, $CellContext`m$1069$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (
       If[$CellContext`m$$ > $CellContext`n$$, $CellContext`m$$ = \
$CellContext`n$$]; Row[{"(", 
          Column[{$CellContext`n$$, $CellContext`m$$}, Center], ") = ", 
          Binomial[$CellContext`n$$, $CellContext`m$$]}]), 
      "Specifications" :> {{$CellContext`n$$, 1, 10, 1}, {$CellContext`m$$, 1,
          
         Dynamic[$CellContext`n$$], 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{252., {68., 73.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{256, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Generally speaking, you can use ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " variables in the definition of other variables without restriction, though \
it is certainly possible in this way to create peculiar interactions that are \
more confusing than helpful. "
}], "Text"],

Cell["\<\
This example shows another variation, using a check box to control the range \
of a slider: something like this can be useful in cases where you want to \
provide fine and coarse ranges, for example.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"n", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", 
     RowBox[{"If", "[", 
      RowBox[{"wide", ",", "100", ",", "10"}], "]"}], ",", "1"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"wide", ",", "False", ",", "\"\<Wide Range\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 4, $CellContext`wide$$ = False, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 
      Dynamic[
       If[$CellContext`wide$$, 100, 10]], 1}, {{
       Hold[$CellContext`wide$$], False, "Wide Range"}, {False, True}}}, 
    Typeset`size$$ = {7., {0., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$,
     Typeset`skipInitDone$$ = True, $CellContext`n$18018$$ = 
    0, $CellContext`wide$18019$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`n$$ = 1, $CellContext`wide$$ = False}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$18018$$, 0], 
        Hold[$CellContext`wide$$, $CellContext`wide$18019$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`n$$, 
      "Specifications" :> {{$CellContext`n$$, 1, 
         Dynamic[
          If[$CellContext`wide$$, 100, 10]], 
         1}, {{$CellContext`wide$$, False, "Wide Range"}, {False, True}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{298., {57., 62.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{302, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dealing with Slow Evaluations", "Section",
 CellID->1234],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " does not precompute all the possible output values you could reach by \
moving its sliders: that would be completely impractical for all but the most \
trivial cases. That means it has to calculate, format, and display the \
current value in real time as each slider is being dragged. Obviously no \
matter how fast your computer, there is a limit to how much computation can \
be done in a finite amount of time, and if the expression you use in the \
first argument to ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " takes more than about a second to evaluate, you will not have a very \
satisfactory experience using the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 "."
}], "Text"],

Cell[TextData[{
 "Many very interesting and powerful computations can be done in under a \
second, and as computers get faster the range will only increase (people are \
not getting any faster, so the amount of time available before the example \
seems too sluggish should remain unchanged for quite a while). But some \
computations just ",
 "cannot",
 " be done that fast, and some alternative is necessary if you want to use \
them within ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". Fortunately there are several good ways of dealing with slow evaluations. \
"
}], "Text"],

Cell[TextData[{
 "For purposes of this section we are going to use ",
 Cell[BoxData[
  ButtonBox["Pause",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pause"]], "InlineFormula"],
 " to simulate a slow evaluation. The main reason for this is that any actual \
computation would run at such widely differing speeds on different users' \
computers that it would be hard to illustrate the point with any one example. \
So where you see a ",
 Cell[BoxData[
  ButtonBox["Pause",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pause"]], "InlineFormula"],
 " command, please imagine that something terribly complex and interesting is \
being done, resulting in a fantastically detailed and enlightening output."
}], "Text"],

Cell[TextData[{
 "To get a feel for the problem, try dragging the slider below. While this \
example is not unacceptable, it is on the borderline of something not worth \
playing with. If the delay is increased to several seconds, it becomes quite \
pointless. (And beyond 5 seconds you will start seeing ",
 Cell[BoxData[
  ButtonBox["$Aborted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Aborted"]], "InlineFormula"],
 " instead of the number, because the system is protecting itself from \
unreasonably long evaluations, which block other activity in the front end in \
this situation.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Pause", "[", "1", "]"}], ";", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 4.88, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 10}}, Typeset`size$$ = {28., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$378$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$378$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> (Pause[1]; $CellContext`x$$), 
      "Specifications" :> {{$CellContext`x$$, 0, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {48., 53.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "The simplest improvement is to add the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContinuousAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuousAction"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " to the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Pause", "[", "1", "]"}], ";", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"ContinuousAction", "\[Rule]", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 2.9, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 10}}, Typeset`size$$ = {21., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$417$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$417$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> (Pause[1]; $CellContext`x$$), 
      "Specifications" :> {{$CellContext`x$$, 0, 10}}, 
      "Options" :> {ContinuousAction -> False}, "DefaultOptions" :> {}],
     ImageSizeCache->{249., {48., 53.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
In this example the slider moves smoothly and instantaneously as it is \
dragged, but the value in the output area does not attempt to track in real \
time. Instead it updates only when the slider is released.\
\>", "Text"],

Cell[TextData[{
 "A more subtle difference is that when the value updates in this example, it \
does so without blocking other activity in the front end. You can see this by \
the fact that the cell bracket becomes outlined for a second each time the \
slider is released, and you can continue typing or doing other work in the \
front end during that second. There is no 5-second limit to such nonblocking \
evaluations, so by using the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContinuousAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuousAction"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " option, arbitrarily long evaluations can be used. (Though something that \
takes a minute is still probably better done as a normal Shift-Return \
evaluation than inside ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ".)"
}], "Text"],

Cell[TextData[{
 "A more sophisticated alternative is to use the ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " function to present an alternative, simpler and faster display while the \
slider is being dragged, and do the long computation only when it is \
released",
 ". "
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " takes two arguments: the first is returned if the expression is evaluated \
while a control (e.g. a slider) is currently being dragged with the mouse, \
and the second if no control is currently active. (See the documentation for \
",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " for some fine print about exactly when which argument is returned.)"
}], "Text"],

Cell[TextData[{
 "In this example we use just ",
 Cell[BoxData["x"], "InlineFormula"],
 " as the preview to be displayed while the slider is being dragged, and ",
 Cell[BoxData["x"], "InlineFormula"],
 " with a box around it, plus a second of delay, as the final display to be \
presented when the slider is released. Note that we have removed the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContinuousAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuousAction"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " option from the example above."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ControlActive", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"Pause", "[", "1", "]"}], ";", 
      RowBox[{"Framed", "[", "x", "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 7.0200000000000005`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 10}}, Typeset`size$$ = {28., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$488$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$488$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ControlActive[$CellContext`x$$, Pause[1]; Framed[$CellContext`x$$]], 
      "Specifications" :> {{$CellContext`x$$, 0, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {48., 53.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
Note that the cell bracket is outlined, indicating a nonblocking evaluation, \
only when the slider is released. While the slider is being dragged, \
evaluations are done in a blocking way for maximum interactive performance.\
\>", "Text"],

Cell[TextData[{
 "Here is a slightly more realistic example of where ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " can be useful. This example shows how the default behavior of ",
 Cell[BoxData[
  ButtonBox["DensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DensityPlot"]], "InlineFormula"],
 " is to use fewer sample points while the slider is being dragged."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"DensityPlot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"n", " ", 
       RowBox[{"x", "/", "y"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 3.72, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 10}}, Typeset`size$$ = {180., {89., 94.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$1266$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1266$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> DensityPlot[
        Sin[$CellContext`n$$ ($CellContext`x/$CellContext`y)], \
{$CellContext`x, -2, 2}, {$CellContext`y, -2, 2}], 
      "Specifications" :> {{$CellContext`n$$, 1, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {132., 137.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
But even the higher number used after the slider is released is not enough to \
produce a satisfactory plot. If we just set a fixed, larger number of plot \
points, the result is pretty, but interactive performance is not good enough.\
\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"DensityPlot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"n", " ", 
       RowBox[{"x", "/", "y"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "150"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 5.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 10}}, Typeset`size$$ = {180., {89., 94.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$1481$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1481$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> DensityPlot[
        Sin[$CellContext`n$$ ($CellContext`x/$CellContext`y)], \
{$CellContext`x, -2, 2}, {$CellContext`y, -2, 2}, PlotPoints -> 150], 
      "Specifications" :> {{$CellContext`n$$, 1, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {132., 137.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "(There is still a difference between the active and inactive forms, because \
by default several different options, not just ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 ", depend on ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 ".)"
}], "Text"],

Cell[TextData[{
 "The optimal combination of speed and quality can be achieved by using ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " explicitly in the value of the ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " option."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"DensityPlot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"n", " ", 
       RowBox[{"x", "/", "y"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", 
      RowBox[{"ControlActive", "[", 
       RowBox[{"30", ",", "150"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 7.53, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 10}}, Typeset`size$$ = {180., {89., 94.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$1609$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1609$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> DensityPlot[
        Sin[$CellContext`n$$ ($CellContext`x/$CellContext`y)], \
{$CellContext`x, -2, 2}, {$CellContext`y, -2, 2}, PlotPoints -> 
        ControlActive[30, 150]], 
      "Specifications" :> {{$CellContext`n$$, 1, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {132., 137.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
The result is an example that displays a crude, but virtually instantaneous, \
preview of the graphic, then spends many seconds constructing a \
high-resolution version when the slider is released.\
\>", "Text"],

Cell["\<\
The next section explains a more complex solution that works in cases where \
some changes to the parameters require a slow evaluation while others could \
update the display much more rapidly.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Dynamic inside Manipulate", "Section"],

Cell[TextData[{
 "You might want to read ",
 ButtonBox["Introduction to Dynamic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToDynamic"],
 " before finishing this section, as we refer to the use of explicit ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions, which are not explained in this tutorial."
}], "Text"],

Cell[TextData[{
 "When you move the sliders (or other controls) in a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", the expression given in the first argument is re-evaluated from scratch \
for each new parameter value. The section above discusses a number of general \
things that can be done if evaluation of this first argument is too slow to \
allow smooth interactive performance of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". But in some cases it is possible to separate the evaluation into slower \
and faster parts, and thereby achieve much better performance."
}], "Text"],

Cell["\<\
Consider this example where one slider controls the contents of a 3D plot, \
while the other controls its viewpoint.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"n", " ", "x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "v", ",", "2"}], "}"}]}], ",", 
     RowBox[{"SphericalRegion", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 3.005, $CellContext`v$$ = 
    0.20000000000000018`, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 4}, {
      Hold[$CellContext`v$$], -2, 2}}, Typeset`size$$ = {180., {88., 92.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$59340$$ = 0, $CellContext`v$59341$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`n$$ = 1, $CellContext`v$$ = -2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$59340$$, 0], 
        Hold[$CellContext`v$$, $CellContext`v$59341$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot3D[
        Sin[($CellContext`n$$ $CellContext`x) $CellContext`y], \
{$CellContext`x, 0, 3}, {$CellContext`y, 0, 3}, 
        ViewPoint -> {2, $CellContext`v$$, 2}, SphericalRegion -> True, Ticks -> 
        None], "Specifications" :> {{$CellContext`n$$, 1, 
         4}, {$CellContext`v$$, -2, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {145., 150.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 297},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "When the ",
 Cell[BoxData["n"], "InlineFormula"],
 "-slider is moved, it is obviously necessary to recompute the 3D plot, \
because it actually changes shape. The plot becomes jagged while the slider \
is being dragged, then improves shortly after you release it, which is \
correct and as expected. When you move the ",
 Cell[BoxData["v"], "InlineFormula"],
 "-slider, on the other hand, there is no point in recomputing the function, \
because only the viewpoint has changed. But ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " has no way of knowing this (and in more complex cases it is genuinely \
impossible for this kind of distinction to be made in any automatic way), so \
the whole plot is regenerated from scratch each time ",
 Cell[BoxData["v"], "InlineFormula"],
 " is changed. "
}], "Text"],

Cell[TextData[{
 "To improve this example, we can tell ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " that the ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " option should be updated separately from the rest of the output, which we \
can do by wrapping ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " around the right hand side of the option."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"n", " ", "x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "v", ",", "2"}], "}"}], "]"}]}], ",", 
     RowBox[{"SphericalRegion", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 2.075, $CellContext`v$$ = 
    0.4700000000000002, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 4}, {
      Hold[$CellContext`v$$], -2, 2}}, Typeset`size$$ = {180., {88., 92.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$58627$$ = 0, $CellContext`v$58628$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`n$$ = 1, $CellContext`v$$ = -2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$58627$$, 0], 
        Hold[$CellContext`v$$, $CellContext`v$58628$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot3D[
        Sin[($CellContext`n$$ $CellContext`x) $CellContext`y], \
{$CellContext`x, 0, 3}, {$CellContext`y, 0, 3}, ViewPoint -> 
        Dynamic[{2, $CellContext`v$$, 2}], SphericalRegion -> True, Ticks -> 
        None], "Specifications" :> {{$CellContext`n$$, 1, 
         4}, {$CellContext`v$$, -2, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {145., 150.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 297},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Notice that now when the ",
 Cell[BoxData["v"], "InlineFormula"],
 "-slider is moved, the plot does not revert to the jagged appearance, and \
actually rotates faster than before. This is because the plot is no longer \
being regenerated with each movement."
}], "Text"],

Cell[TextData[{
 "To explain exactly why this works requires an understanding of the \
internals of the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " mechanism explained in ",
 ButtonBox["Introduction to Dynamic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToDynamic"],
 " and ",
 ButtonBox["Advanced Dynamic Functionality",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"],
 ". In short, ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " always wraps ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " around the expression given in its first argument, and normally any \
changes to variables used in the first argument will trigger updates of that \
",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ". But when a variable occurs ",
 StyleBox["only",
  FontSlant->"Italic"],
 " inside an explicit ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " nested inside the one implicitly created by ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", an update of the outer ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " will not be triggered, only an update of the inner ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " in which it resides."
}], "Text"],

Cell[TextData[{
 "Explaining the full range of what is possible by using ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " explicitly inside ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is beyond the scope of this document, but another common case worth \
looking at involves a situation where the slow part of some computation \
involves only some of the input variables."
}], "Text"],

Cell[TextData[{
 "In the next example we construct a large table of numbers (using ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " in this case, but in a real-world example it might be a much more \
complicated, slower computation, or even one involving reading external data \
from the network). After constructing the data, we display it using a fairly \
simple, fast function (illustrated here by just raising the coordinate values \
to a power)."
}], "Text"],

Cell[TextData[{
 "Note that when the ",
 Cell[BoxData["n"], "InlineFormula"],
 "-slider is moved, the number of points changes, and they jump around \
because a new random set is generated each time. But when the ",
 Cell[BoxData["p"], "InlineFormula"],
 "-slider is moved, updates are smoother, and the points do not jump around. \
This is because the inner ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " wrapped around the use of ",
 Cell[BoxData["p"], "InlineFormula"],
 " prevents the first argument as a whole from being re-evaluated. Thus no \
new random points are generated, only the presentation of the existing ones \
is updated."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "2"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Point", "[", 
        RowBox[{"Dynamic", "[", 
         RowBox[{"data", "^", "p"}], "]"}], "]"}], "}"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "100", ",", "5000", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0.1", ",", "10"}], "}"}], ",", 
   RowBox[{"SynchronousUpdating", "\[Rule]", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 2410, $CellContext`p$$ = 0.4, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 100, 5000, 1}, {
      Hold[$CellContext`p$$], 0.1, 10}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$1151$$ = 
    0, $CellContext`p$1152$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`n$$ = 100, $CellContext`p$$ = 0.1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1151$$, 0], 
        Hold[$CellContext`p$$, $CellContext`p$1152$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`data = 
        RandomReal[{0, 1}, {$CellContext`n$$, 2}]; Graphics[{
          Point[
           Dynamic[$CellContext`data^$CellContext`p$$]]}, AspectRatio -> 1]), 
      "Specifications" :> {{$CellContext`n$$, 100, 5000, 
         1}, {$CellContext`p$$, 0.1, 10}}, 
      "Options" :> {SynchronousUpdating -> False}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {236., 241.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 479},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SynchronousUpdating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SynchronousUpdating"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is used to cause the outer ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " (the one implicitly created by ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ") to update asynchronously (visible by the fact that the cell bracket \
becomes outlined when the ",
 Cell[BoxData["n"], "InlineFormula"],
 "-slider is moved). Asynchronous updating doesn't give quite as smooth \
updating, but if the evaluation takes a long time, it does not block other \
activity in the front end. "
}], "Text"],

Cell[TextData[{
 "The inner ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " uses the default synchronous updating, so when the ",
 Cell[BoxData["p"], "InlineFormula"],
 "-slider is moved, updating is smooth and rapid."
}], "Text"],

Cell["\<\
It is thus practical, using the technique illustrated here, to make an \
example that takes many seconds, even minutes, to respond when one slider is \
changed, yet preserve rapid interactive performance when other controls, \
which do not require the long computation to be repeated, are changed.\
\>", "Text"],

Cell[TextData[{
 "You can also use ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " inside ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " to make the output dynamically respond to things other than the values of \
the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 "'s control variables. For example, here is an example taken from an earlier \
section, except that we have made it respond dynamically to the current mouse \
position."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"pt", "=", 
           RowBox[{"MousePosition", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<Graphics\>\"", ",", "Graphics"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", "t", "]"}], ",", 
                RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", "pt"}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", 
              RowBox[{"2.", 
               RowBox[{"Pi", "/", "n"}]}], ",", 
              RowBox[{"2.", "Pi"}], ",", 
              RowBox[{"2.", 
               RowBox[{"Pi", "/", "n"}]}]}], "}"}]}], "]"}], "]"}]}], "]"}], 
       "]"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "30"}], "}"}], ",", "1", ",", "200", ",", "1"}], 
    "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 59, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n$$], 30}, 1, 200, 1}}, Typeset`size$$ = {
    180., {88., 92.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$5800$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 30}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$5800$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Dynamic[
          
          With[{$CellContext`pt$ = 
            MousePosition[{"Graphics", Graphics}, {0, 0}]}, 
           Line[
            Table[{{
               Cos[$CellContext`t], 
               Sin[$CellContext`t]}, $CellContext`pt$}, {$CellContext`t, 
              2. (Pi/$CellContext`n$$), 2. Pi, 2. (Pi/$CellContext`n$$)}]]]]},
         PlotRange -> 1], 
      "Specifications" :> {{{$CellContext`n$$, 30}, 1, 200, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {131., 136.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 269},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Any time the mouse is over the area of the plot, the center of the lines \
will follow it (without a click). Consult the documentation for ",
 Cell[BoxData[
  ButtonBox["MousePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MousePosition"]], "InlineFormula"],
 " for further detail."
}], "Text"],

Cell[TextData[{
 "It is important to remember also that ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is not the only way of creating interactive user interfaces in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is intended to be a simple, yet powerful, tool for defining user \
interfaces at a very high level. But when you reach the limits of what it is \
capable of doing, either in terms of control layout, updating behavior, or \
interaction with external systems, it is always possible (and often not \
terribly difficult) to drop to a lower level of interface programming using \
functions such as ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dynamic Objects in the Control Area", "Section"],

Cell[TextData[{
 "We saw in ",
 ButtonBox["Introduction to Manipulate",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToManipulate"],
 " that it is possible to add a variety of elements to the control area of a \
",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", for example titles and delimiters, as in this example."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n1", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"a2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Horizontal\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n1", ",", "1", ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", "\[IndentingNewLine]", "Delimiter", 
   ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Vertical\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n2", ",", 
       RowBox[{"5", "/", "4"}], ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a2", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p2", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 1, $CellContext`a2$$ = 
    1, $CellContext`n1$$ = 1, $CellContext`n2$$ = Rational[
    5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Style["Horizontal", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`n1$$], 1, "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a1$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p1$$], 0, "Phase"}, 0, 2 Pi}, {
      Hold[
       Style["Vertical", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`n2$$], 
       Rational[5, 4], "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a2$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p2$$], 0, "Phase"}, 0, 2 Pi}}, Typeset`size$$ = {
    180., {86., 90.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$4088$$ = 
    0, $CellContext`a1$4089$$ = 0, $CellContext`p1$4090$$ = 
    0, $CellContext`n2$4091$$ = 0, $CellContext`a2$4092$$ = 
    0, $CellContext`p2$4093$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 1, $CellContext`a2$$ = 
        1, $CellContext`n1$$ = 1, $CellContext`n2$$ = 
        Rational[5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$4088$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$4089$$, 0], 
        Hold[$CellContext`p1$$, $CellContext`p1$4090$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$4091$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$4092$$, 0], 
        Hold[$CellContext`p2$$, $CellContext`p2$4093$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{$CellContext`a1$$ 
         Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`a2$$ 
         Cos[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)]}, \
{$CellContext`x, 0, 20 Pi}, PlotRange -> 1, PerformanceGoal -> "Quality"], 
      "Specifications" :> {
        Style[
        "Horizontal", 12, Bold], {{$CellContext`n1$$, 1, "Frequency"}, 1, 
         4}, {{$CellContext`a1$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p1$$, 0, "Phase"}, 0, 2 Pi}, Delimiter, 
        Style["Vertical", 12, Bold], {{$CellContext`n2$$, 
          Rational[5, 4], "Frequency"}, 1, 
         4}, {{$CellContext`a2$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p2$$, 0, "Phase"}, 0, 2 Pi}}, 
      "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
     ImageSizeCache->{496., {116., 121.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{500, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "There is in fact virtually no limit to what can be put into the controls \
area, including arbitrary formatting constructs and dynamic objects, even \
controls that are not part of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 "'s control specifications. Anything placed in the variables sequence that \
is either a string or has head ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["ExpressionCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpressionCell"]], "InlineFormula"],
 " will automatically be interpreted as an annotation to be inserted in the \
controls area."
}], "Text"],

Cell[TextData[{
 "You might want to read ",
 ButtonBox["Introduction to Dynamic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToDynamic"],
 " before finishing this section, as we refer to the use of explicit ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions, which are not explained in this tutorial."
}], "Text"],

Cell[TextData[{
 "Suppose you want to show plots of the individual ",
 StyleBox["x",
  FontSlant->"Italic"],
 " and ",
 StyleBox["y",
  FontSlant->"Italic"],
 " sine functions that combine to form the Lissajous figure. You could do \
this by putting all three functions into the output area, using ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " to lay them out."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"a2", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"n2", " ", 
             RowBox[{"(", 
              RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", 
            RowBox[{"2", "Pi"}]}], "}"}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"a1", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"n1", " ", 
               RowBox[{"(", 
                RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", 
            RowBox[{"a2", " ", 
             RowBox[{"Cos", "[", 
              RowBox[{"n2", " ", 
               RowBox[{"(", 
                RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", 
            RowBox[{"20", "Pi"}]}], "}"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
          RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], 
         "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"Null", ",", 
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"a1", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"n1", " ", 
               RowBox[{"(", 
                RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", "x"}], "}"}],
           ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", 
            RowBox[{"2", "Pi"}]}], "}"}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"2", "Pi"}]}], "}"}]}], "}"}]}]}], "]"}]}], "}"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n1", ",", "1", ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", "\[IndentingNewLine]", "Delimiter", 
   ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n2", ",", 
       RowBox[{"5", "/", "4"}], ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a2", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p2", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 1, $CellContext`a2$$ = 
    1, $CellContext`n1$$ = 1, $CellContext`n2$$ = Rational[
    5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n1$$], 1, "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a1$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p1$$], 0, "Phase"}, 0, 2 Pi}, {{
       Hold[$CellContext`n2$$], 
       Rational[5, 4], "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a2$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p2$$], 0, "Phase"}, 0, 2 Pi}}, Typeset`size$$ = {
    368., {177.5, 182.5}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$4151$$ = 
    0, $CellContext`a1$4152$$ = 0, $CellContext`p1$4153$$ = 
    0, $CellContext`n2$4154$$ = 0, $CellContext`a2$4155$$ = 
    0, $CellContext`p2$4156$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 1, $CellContext`a2$$ = 
        1, $CellContext`n1$$ = 1, $CellContext`n2$$ = 
        Rational[5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$4151$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$4152$$, 0], 
        Hold[$CellContext`p1$$, $CellContext`p1$4153$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$4154$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$4155$$, 0], 
        Hold[$CellContext`p2$$, $CellContext`p2$4156$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Grid[{{
          
          Plot[$CellContext`a2$$ 
           Sin[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)], \
{$CellContext`x, 0, 2 Pi}, AspectRatio -> 1, PlotRange -> 1], 
          
          ParametricPlot[{$CellContext`a1$$ 
            Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`a2$$ 
            Cos[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)]}, \
{$CellContext`x, 0, 20 Pi}, PlotRange -> 1, PerformanceGoal -> "Quality"]}, {
         Null, 
          
          ParametricPlot[{$CellContext`a1$$ 
            Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`x}, {$CellContext`x, 0, 2 Pi}, AspectRatio -> 1, 
           PlotRange -> {{-1, 1}, {0, 2 Pi}}]}}], 
      "Specifications" :> {{{$CellContext`n1$$, 1, "Frequency"}, 1, 
         4}, {{$CellContext`a1$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p1$$, 0, "Phase"}, 0, 2 Pi}, 
        Delimiter, {{$CellContext`n2$$, 
          Rational[5, 4], "Frequency"}, 1, 
         4}, {{$CellContext`a2$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p2$$, 0, "Phase"}, 0, 2 Pi}}, 
      "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
     ImageSizeCache->{684., {206., 211.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{688, 419},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
There is in fact a lot to be said for this presentation. But suppose you \
instead want to leave the main output area as it is, with a large, prominent \
presentation of the Lissajous figure itself, and show the individual sine \
functions only much smaller, in association with the controls for each \
direction. You can do this by placing a dynamic plot object into the controls \
area, as follows.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n1", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"a2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n1", ",", "1", ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a1", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"n1", " ", 
           RowBox[{"(", 
            RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", "x"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"2", "Pi"}]}], "}"}]}], "}"}]}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n2", ",", 
       RowBox[{"5", "/", "4"}], ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a2", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p2", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"a2", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"n2", " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], "]"}], ",", " ", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 1, $CellContext`a2$$ = 
    1, $CellContext`n1$$ = 1, $CellContext`n2$$ = Rational[
    5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n1$$], 1, "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a1$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p1$$], 0, "Phase"}, 0, 2 Pi}, {
      Hold[
       Dynamic[
        ParametricPlot[{$CellContext`a1$$ 
          Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`x}, {$CellContext`x, 0, 2 Pi}, ImageSize -> 100, AspectRatio -> 
         1, PlotRange -> {{-1, 1}, {0, 2 Pi}}]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`n2$$], 
       Rational[5, 4], "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a2$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p2$$], 0, "Phase"}, 0, 2 Pi}, {
      Hold[
       Dynamic[
        Plot[$CellContext`a2$$ 
         Sin[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)], \
{$CellContext`x, 0, 2 Pi}, ImageSize -> 100, AspectRatio -> 1, PlotRange -> 
         1]]], Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    180., {86., 90.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$18411$$ = 
    0, $CellContext`a1$18412$$ = 0, $CellContext`p1$18413$$ = 
    0, $CellContext`n2$18414$$ = 0, $CellContext`a2$18415$$ = 
    0, $CellContext`p2$18416$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 1, $CellContext`a2$$ = 
        1, $CellContext`n1$$ = 1, $CellContext`n2$$ = 
        Rational[5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$18411$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$18412$$, 0], 
        Hold[$CellContext`p1$$, $CellContext`p1$18413$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$18414$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$18415$$, 0], 
        Hold[$CellContext`p2$$, $CellContext`p2$18416$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{$CellContext`a1$$ 
         Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`a2$$ 
         Cos[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)]}, \
{$CellContext`x, 0, 20 Pi}, PlotRange -> 1, PerformanceGoal -> "Quality"], 
      "Specifications" :> {{{$CellContext`n1$$, 1, "Frequency"}, 1, 
         4}, {{$CellContext`a1$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p1$$, 0, "Phase"}, 0, 2 Pi}, 
        Dynamic[
         ParametricPlot[{$CellContext`a1$$ 
           Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`x}, {$CellContext`x, 0, 2 Pi}, ImageSize -> 100, AspectRatio -> 
          1, PlotRange -> {{-1, 1}, {0, 2 Pi}}]], 
        Delimiter, {{$CellContext`n2$$, 
          Rational[5, 4], "Frequency"}, 1, 
         4}, {{$CellContext`a2$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p2$$, 0, "Phase"}, 0, 2 Pi}, 
        Dynamic[
         Plot[$CellContext`a2$$ 
          Sin[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)], \
{$CellContext`x, 0, 2 Pi}, ImageSize -> 100, AspectRatio -> 1, PlotRange -> 
          1]]}, "Options" :> {ControlPlacement -> Left}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{496., {201., 206.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{500, 409},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Just as the headings in the example at the start of this section were mixed \
in with the controls simply by listing them in the variable specifications \
sequence, here we have placed dynamically updated plots in the variable \
specification sequence. ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " is used explicitly in these subplots so that they will update when the \
controls are moved. (The main output area does not need an explicit ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " because ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " automatically wraps ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " around its first argument.)"
}], "Text"],

Cell[TextData[{
 "It is worth briefly discussing here why it is that an example like this can \
just work. The reason is that the output of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is not a special, fixed object that just connects a set of controls with a \
single output area. Instead, the output of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is built up using the same formatting, layout, user interface, and dynamic \
interactivity features that can be accessed at a lower level using the \
techniques discussed in ",
 ButtonBox["Introduction to Dynamic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToDynamic"],
 " (which in fact includes an example of how to build up a simple version of \
",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " by hand). In some ways the relationship between ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " and the lower level interactive features is like the relationship between \
",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ". The result of evaluating a high-level ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " command is a low-level ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object, and if ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " is not able to generate the specific graphic you want, you are always free \
to use ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " directly. You can use the ",
 Cell[BoxData[
  ButtonBox["Prolog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prolog"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Epilog"]], "InlineFormula"],
 " options to add arbitrary graphical elements to a ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ". Furthermore there is no graphical output you can get using ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " that you cannot get using ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " has no special access to any features in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " unavailable at the lower level."
}], "Text"],

Cell[TextData[{
 "Likewise, ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " does not have any special access to features unavailable with lower level \
functions: there is nothing you can do with ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " that you cannot do with ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", it is just a higher-level, more convenient function for building a \
certain style of interface."
}], "Text"],

Cell[TextData[{
 "So when you use dynamic objects in the control labels, as in the example \
above, you're just adding a couple more ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects to the already fairly complex set of ",
 Cell[BoxData[
  ButtonBox["Panel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Panel"]], "InlineFormula"],
 " objects, ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " objects, ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects, and ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " objects that constitutes the output of a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " command. There is nothing really different there, just more of it, so it \
should come as no surprise that the new dynamic elements interoperate \
smoothly with the others."
}], "Text"],

Cell[TextData[{
 "Although ",
 "it is",
 " not always sensible to do so, it is possible to build completely arbitrary \
interactive dynamic user interfaces entirely in the controls area of a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Custom Control Appearances", "Section"],

Cell[TextData[{
 "You might want to read ",
 ButtonBox["Introduction to Dynamic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToDynamic"],
 " before reading this section, as we refer to the use of explicit ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions, which are not explained in this tutorial."
}], "Text"],

Cell[TextData[{
 "Suppose you want to use a type of control that is not supported by ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", for example one you have built yourself using graphics and dynamics. Here \
is a block of code that defines a custom style of slider, one that shows its \
value at the thumb position. Do not worry about understanding the details of \
how this code works, though it is not overly complicated beyond the details \
of drawing the desired elements in the right places."
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ValueThumbSlider", "[", "v_", "]"}], ":=", 
   RowBox[{"ValueThumbSlider", "[", 
    RowBox[{"v", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ValueThumbSlider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "var_", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"min_", ",", "max_"}], "}"}], ",", "options___"}], "]"}], ":=", 
   
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"NumberQ", "[", "var", "]"}]}], ",", 
          RowBox[{"var", "=", "min"}]}], "]"}], ";", 
        RowBox[{"{", 
         RowBox[{"var", ",", "0"}], "}"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"var", "=", 
          RowBox[{"First", "[", "#", "]"}]}], ")"}], "&"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "1.5", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"min", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"max", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Dynamic", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Text", "[", 
             RowBox[{"var", ",", 
              RowBox[{"{", 
               RowBox[{"var", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
            RowBox[{"Polygon", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Offset", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"-", "1"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"var", ",", "0"}], "}"}]}], "]"}], ",", 
               RowBox[{"Offset", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "5"}], ",", 
                   RowBox[{"-", "8"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"var", ",", "0"}], "}"}]}], "]"}], ",", 
               RowBox[{"Offset", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"5", ",", 
                   RowBox[{"-", "8"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"var", ",", "0"}], "}"}]}], "]"}]}], "}"}], "]"}]}],
            "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"300", ",", "30"}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"min", ",", "max"}], "}"}], "+", 
           RowBox[{"0.1", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "1"}], "}"}], 
            RowBox[{"(", 
             RowBox[{"max", "-", "min"}], ")"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", 
        RowBox[{"1", "/", "10"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"min", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"max", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[48]:="],

Cell["\<\
Here is an example of what this new control looks like: click anywhere to \
move the thumb around, just like with a normal slider:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ValueThumbSlider", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "xx", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[50]:="],

Cell[BoxData[
 LocatorPaneBox[Dynamic[If[
     Not[
      NumberQ[$CellContext`xx]], $CellContext`xx = 0]; {$CellContext`xx, 
     0}, ($CellContext`xx = First[#])& ], 
  GraphicsBox[
   {AbsoluteThickness[1.5], LineBox[{{0, 0}, {10, 0}}], 
    DynamicBox[Typeset`ToBoxes[{
       Text[$CellContext`xx, {$CellContext`xx, 0}, {0, -1}], 
       Polygon[{
         Offset[{0, -1}, {$CellContext`xx, 0}], 
         Offset[{-5, -8}, {$CellContext`xx, 0}], 
         Offset[{5, -8}, {$CellContext`xx, 0}]}]}, StandardForm, Graphics],
     ImageSizeCache->{{20., 30.}, {-14., 6.}}]},
   AspectRatio->NCache[
     Rational[1, 10], 0.1],
   ImageSize->{300, 30},
   PlotRange->{{-1., 11.}, {-1, 1}}], {{0, 0}, {10, 0}},
  Appearance->None]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{304, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]=",
 CellID->252460168]
}, Open  ]],

Cell[TextData[{
 "To use a custom control in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", you include a pure function that is used to generate the control object \
as part of the variable specification. As long as your function conforms to \
the convention used by all the built-in control functions, with the variable \
(inside ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ") as the first argument and the range as the second argument, you can \
simply use the function name and the appropriate arguments will be passed to \
it automatically by ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". Here we see our custom control used in a simple ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 "."
}], "Text"],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1", ",", 
     RowBox[{
      RowBox[{"ValueThumbSlider", "[", "##", "]"}], "&"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[51]:="],

Cell[TextData[{
 "(The notation ",
 Cell[BoxData["##"], "InlineFormula"],
 " means that all the arguments will be passed in to the function, not just \
the first one.)"
}], "Text"],

Cell["\<\
Note that if you supply the necessary information in the pure function, you \
do not have to specify the min and max as part of the variable specification:\
\
\>", "Text"],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"ValueThumbSlider", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "&"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[52]:="],

Cell[TextData[{
 "However, if you do that, then ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is not aware of the range you chose to use in the slider, which means that \
the very nice Autorun feature (as described in the documentation for ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ") ",
 "cannot",
 " work. So generally it is a good idea to include the range in the variable \
specification, and let the control function inherit it."
}], "Text"],

Cell[TextData[{
 "Naturally it is possible to combine standard and custom controls freely; \
here we use two of our new sliders together with a ",
 Cell[BoxData[
  ButtonBox["SetterBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetterBar"]], "InlineFormula"],
 " supplied automatically by ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 "."
}], "Text"],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n1", " ", "x"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"n2", " ", "x"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "filling"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "20", ",", 
     RowBox[{
      RowBox[{"ValueThumbSlider", "[", "##", "]"}], "&"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "20", ",", 
     RowBox[{
      RowBox[{"ValueThumbSlider", "[", "##", "]"}], "&"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"filling", ",", 
     RowBox[{"{", 
      RowBox[{"None", ",", "Axis", ",", "Top", ",", "Bottom"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[53]:="],

Cell["\<\
It is also possible to combine custom controls with other dynamic elements in \
the controls area (discussed in the previous section).\
\>", "Text"],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n1", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"a2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n1", ",", "1"}], "}"}], ",", "1", ",", "4", ",", 
     RowBox[{
      RowBox[{"ValueThumbSlider", "[", "##", "]"}], "&"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "1"}], "}"}], ",", "0", ",", "1", ",", 
     RowBox[{
      RowBox[{"ValueThumbSlider", "[", "##", "]"}], "&"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "0"}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}], ",", 
     RowBox[{
      RowBox[{"ValueThumbSlider", "[", "##", "]"}], "&"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a1", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"n1", " ", 
           RowBox[{"(", 
            RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", "x"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"2", "Pi"}]}], "}"}]}], "}"}]}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n2", ",", 
       RowBox[{"5", "/", "4."}]}], "}"}], ",", "1", ",", "4", ",", 
     RowBox[{
      RowBox[{"ValueThumbSlider", "[", "##", "]"}], "&"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a2", ",", "1"}], "}"}], ",", "0", ",", "1", ",", 
     RowBox[{
      RowBox[{"ValueThumbSlider", "[", "##", "]"}], "&"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p2", ",", "0"}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}], ",", 
     RowBox[{
      RowBox[{"ValueThumbSlider", "[", "##", "]"}], "&"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"a2", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"n2", " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], "]"}], ",", " ", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input",
 CellLabel->"In[54]:="],

Cell[TextData[{
 "This example should give some idea of how far ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " can be pushed to create complex interfaces. However, it is important to \
remember that ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is not the only way to create interfaces in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 ButtonBox["Introduction to Dynamic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToDynamic"],
 " provides further information and examples for how to create free-form \
interfaces not restricted to the model provided by ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 "."
}], "Text"],

Cell[TextData[{
 "One of the nice things about building an interface like this inside ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is that it lets you use ",
 StyleBox["Autorun", "DialogElementName"],
 " (click the plus icon in the top right corner of the panel and choose ",
 StyleBox["Autorun", "DialogElementName"],
 ") to put the example through its paces, varying each variable according to \
a sensible interpolating pattern."
}], "Text"],

Cell[TextData[{
 "On the other hand, ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " restricts you to a certain set of layouts and behaviors, which while very \
flexible and expandable, are still fixed compared to what is possible using \
the lower level features described in ",
 ButtonBox["Introduction to Dynamic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToDynamic"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DynamicInteractivityLanguage"]], "TutorialMoreAbout",
 CellID->346793833],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "TutorialMoreAbout",
 CellID->116159589]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Introduction to Manipulate",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToManipulate"]], "RelatedTutorials",\

 CellID->894362159],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "RelatedTutorials",
 CellID->546467600]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Advanced Manipulate Functionality - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 26.6225118}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "", "status" -> "None", "summary" -> 
    "This tutorial covers advanced features of the Manipulate command. It \
assumes that you have read Introduction to Manipulate and thus have a good \
idea what the command is for and how it works overall. This tutorial also, in \
places, assumes a familiarity with the lower level dynamic mechanism covered \
in Introduction to Dynamic and Advanced Dynamic Functionality. Some \
Manipulate examples \"spin,\" continually reevaluating their contents even \
when no sliders are being moved. Sometimes this is in fact exactly what you \
intend. For example, here is a droopy triangle, which always sags down in the \
middle. You can drag it back up using the slider, but as soon as you stop \
moving, it starts falling down again.", "synonyms" -> {}, "title" -> 
    "Advanced Manipulate Functionality", "type" -> "Tutorial", "uri" -> 
    "tutorial/AdvancedManipulateFunctionality"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1605, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2230, 66, 50, 0, 70, "Title"],
Cell[2283, 68, 449, 12, 70, "Text"],
Cell[2735, 82, 396, 11, 70, "Text"],
Cell[3134, 95, 340, 8, 70, "TextEmphasisNote",
 CellID->244159640],
Cell[CellGroupData[{
Cell[3499, 107, 53, 0, 70, "Section"],
Cell[3555, 109, 502, 11, 70, "Text"],
Cell[CellGroupData[{
Cell[4082, 124, 851, 27, 65, "Input"],
Cell[4936, 153, 1673, 36, 290, "Output"]
}, Open  ]],
Cell[6624, 192, 1106, 27, 70, "Text",
 CellID->595448231],
Cell[7733, 221, 445, 12, 70, "Text"],
Cell[CellGroupData[{
Cell[8203, 237, 541, 17, 70, "Input"],
Cell[8747, 256, 1942, 40, 70, "Output"]
}, Open  ]],
Cell[10704, 299, 556, 10, 70, "Text"],
Cell[11263, 311, 375, 6, 70, "Text"],
Cell[11641, 319, 816, 23, 70, "Input"],
Cell[12460, 344, 426, 9, 70, "Text"],
Cell[12889, 355, 316, 8, 70, "Text"],
Cell[13208, 365, 825, 25, 70, "Input"],
Cell[14036, 392, 371, 9, 70, "Text"],
Cell[14410, 403, 947, 27, 70, "Input"],
Cell[15360, 432, 948, 28, 70, "Input"],
Cell[16311, 462, 595, 15, 70, "Text"],
Cell[16909, 479, 1114, 30, 70, "Text"],
Cell[18026, 511, 774, 22, 70, "Text"],
Cell[18803, 535, 903, 27, 70, "Input"],
Cell[19709, 564, 217, 7, 70, "Text"],
Cell[19929, 573, 1333, 41, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21299, 619, 37, 0, 70, "Section"],
Cell[21339, 621, 585, 20, 70, "Text"],
Cell[CellGroupData[{
Cell[21949, 645, 1064, 31, 70, "Input",
 CellID->626161559],
Cell[23016, 678, 1918, 41, 70, "Output",
 CellID->1227451813]
}, Open  ]],
Cell[24949, 722, 878, 24, 70, "Text",
 CellID->1888697762]
}, Open  ]],
Cell[CellGroupData[{
Cell[25864, 751, 42, 0, 70, "Section"],
Cell[25909, 753, 1087, 35, 70, "Text"],
Cell[CellGroupData[{
Cell[27021, 792, 586, 17, 70, "Input"],
Cell[27610, 811, 1931, 41, 70, "Output"]
}, Open  ]],
Cell[29556, 855, 812, 23, 70, "Text"],
Cell[30371, 880, 558, 13, 70, "Text"],
Cell[CellGroupData[{
Cell[30954, 897, 731, 22, 70, "Input"],
Cell[31688, 921, 2030, 44, 70, "Output"]
}, Open  ]],
Cell[33733, 968, 378, 9, 70, "Text"],
Cell[34114, 979, 223, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[34362, 987, 463, 13, 70, "Input"],
Cell[34828, 1002, 1957, 42, 70, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36834, 1050, 63, 1, 70, "Section",
 CellID->1234],
Cell[36900, 1053, 989, 23, 70, "Text"],
Cell[37892, 1078, 661, 15, 70, "Text"],
Cell[38556, 1095, 721, 16, 70, "Text"],
Cell[39280, 1113, 609, 12, 70, "Text"],
Cell[CellGroupData[{
Cell[39914, 1129, 204, 6, 70, "Input"],
Cell[40121, 1137, 1499, 32, 70, "Output"]
}, Open  ]],
Cell[41635, 1172, 459, 16, 70, "Text"],
Cell[CellGroupData[{
Cell[42119, 1192, 263, 7, 70, "Input"],
Cell[42385, 1201, 1523, 32, 70, "Output"]
}, Open  ]],
Cell[43923, 1236, 233, 4, 70, "Text"],
Cell[44159, 1242, 997, 23, 70, "Text"],
Cell[45159, 1267, 374, 10, 70, "Text"],
Cell[45536, 1279, 595, 14, 70, "Text"],
Cell[46134, 1295, 637, 16, 70, "Text"],
Cell[CellGroupData[{
Cell[46796, 1315, 311, 9, 70, "Input"],
Cell[47110, 1326, 1560, 33, 70, "Output"]
}, Open  ]],
Cell[48685, 1362, 249, 4, 70, "Text"],
Cell[48937, 1368, 474, 12, 70, "Text"],
Cell[CellGroupData[{
Cell[49436, 1384, 480, 15, 70, "Input"],
Cell[49919, 1401, 1605, 34, 70, "Output"]
}, Open  ]],
Cell[51539, 1438, 260, 5, 70, "Text"],
Cell[CellGroupData[{
Cell[51824, 1447, 533, 16, 70, "Input"],
Cell[52360, 1465, 1623, 34, 70, "Output"]
}, Open  ]],
Cell[53998, 1502, 432, 13, 70, "Text"],
Cell[54433, 1517, 403, 12, 70, "Text"],
Cell[CellGroupData[{
Cell[54861, 1533, 606, 18, 70, "Input"],
Cell[55470, 1553, 1652, 35, 70, "Output"]
}, Open  ]],
Cell[57137, 1591, 221, 4, 70, "Text"],
Cell[57361, 1597, 217, 4, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57615, 1606, 50, 0, 70, "Section"],
Cell[57668, 1608, 418, 11, 70, "Text"],
Cell[58089, 1621, 754, 16, 70, "Text"],
Cell[58846, 1639, 140, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[59011, 1646, 723, 20, 70, "Input"],
Cell[59737, 1668, 1925, 39, 70, "Output"]
}, Open  ]],
Cell[61677, 1710, 902, 19, 70, "Text"],
Cell[62582, 1731, 592, 18, 70, "Text"],
Cell[CellGroupData[{
Cell[63199, 1753, 763, 21, 70, "Input"],
Cell[63965, 1776, 1932, 39, 70, "Output"]
}, Open  ]],
Cell[65912, 1818, 288, 6, 70, "Text"],
Cell[66203, 1826, 1803, 56, 70, "Text"],
Cell[68009, 1884, 542, 14, 70, "Text"],
Cell[68554, 1900, 543, 11, 70, "Text"],
Cell[69100, 1913, 728, 17, 70, "Text"],
Cell[CellGroupData[{
Cell[69853, 1934, 821, 23, 70, "Input"],
Cell[70677, 1959, 1964, 42, 70, "Output"]
}, Open  ]],
Cell[72656, 2004, 920, 26, 70, "Text"],
Cell[73579, 2032, 305, 9, 70, "Text"],
Cell[73887, 2043, 321, 5, 70, "Text"],
Cell[74211, 2050, 682, 20, 70, "Text"],
Cell[CellGroupData[{
Cell[74918, 2074, 1363, 40, 70, "Input"],
Cell[76284, 2116, 1916, 43, 70, "Output"]
}, Open  ]],
Cell[78215, 2162, 324, 8, 70, "Text"],
Cell[78542, 2172, 1099, 30, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79678, 2207, 54, 0, 70, "Section"],
Cell[79735, 2209, 428, 12, 70, "Text"],
Cell[CellGroupData[{
Cell[80188, 2225, 2037, 59, 70, "Input"],
Cell[82228, 2286, 3475, 69, 70, "Output"]
}, Open  ]],
Cell[85718, 2358, 924, 26, 70, "Text"],
Cell[86645, 2386, 418, 11, 70, "Text"],
Cell[87066, 2399, 444, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[87535, 2417, 3655, 99, 70, "Input"],
Cell[91193, 2518, 3698, 74, 70, "Output"]
}, Open  ]],
Cell[94906, 2595, 424, 7, 70, "Text"],
Cell[CellGroupData[{
Cell[95355, 2606, 3353, 94, 70, "Input"],
Cell[98711, 2702, 4292, 86, 70, "Output"]
}, Open  ]],
Cell[103018, 2791, 978, 26, 70, "Text"],
Cell[103999, 2819, 3186, 96, 70, "Text"],
Cell[107188, 2917, 663, 19, 70, "Text"],
Cell[107854, 2938, 1181, 35, 70, "Text"],
Cell[109038, 2975, 333, 10, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109408, 2990, 45, 0, 70, "Section"],
Cell[109456, 2992, 416, 11, 70, "Text"],
Cell[109875, 3005, 592, 11, 70, "Text"],
Cell[110470, 3018, 3854, 110, 70, "Input"],
Cell[114327, 3130, 154, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[114506, 3137, 202, 6, 70, "Input"],
Cell[114711, 3145, 924, 25, 70, "Output",
 CellID->252460168]
}, Open  ]],
Cell[115650, 3173, 1027, 27, 70, "Text"],
Cell[116680, 3202, 251, 8, 70, "Input"],
Cell[116934, 3212, 180, 5, 70, "Text"],
Cell[117117, 3219, 181, 4, 70, "Text"],
Cell[117301, 3225, 317, 11, 70, "Input"],
Cell[117621, 3238, 614, 16, 70, "Text"],
Cell[118238, 3256, 439, 13, 70, "Text"],
Cell[118680, 3271, 1010, 30, 70, "Input"],
Cell[119693, 3303, 158, 3, 70, "Text"],
Cell[119854, 3308, 3704, 109, 70, "Input"],
Cell[123561, 3419, 896, 26, 70, "Text"],
Cell[124460, 3447, 528, 12, 70, "Text"],
Cell[124991, 3461, 492, 13, 70, "Text"],
Cell[CellGroupData[{
Cell[125508, 3478, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->23220180],
Cell[125576, 3481, 181, 4, 70, "TutorialMoreAbout",
 CellID->346793833],
Cell[125760, 3487, 161, 3, 70, "TutorialMoreAbout",
 CellID->116159589]
}, Open  ]],
Cell[CellGroupData[{
Cell[125958, 3495, 72, 1, 70, "RelatedTutorialsSection",
 CellID->415694126],
Cell[126033, 3498, 174, 4, 70, "RelatedTutorials",
 CellID->894362159],
Cell[126210, 3504, 166, 3, 70, "RelatedTutorials",
 CellID->546467600]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[126415, 3512, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

