(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32772,       1193]
NotebookOptionsPosition[     25484,        952]
NotebookOutlinePosition[     28361,       1025]
CellTagsIndexPosition[     28268,       1019]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Equations and Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Equations and Inequalities\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Normal" :> Documentation`HelpLookup["paclet:ref/Normal"], 
          "Root" :> Documentation`HelpLookup["paclet:ref/Root"], 
          "RootApproximant" :> 
          Documentation`HelpLookup["paclet:ref/RootApproximant"], 
          "RootReduce" :> Documentation`HelpLookup["paclet:ref/RootReduce"], 
          "RootSum" :> Documentation`HelpLookup["paclet:ref/RootSum"], 
          "ToRadicals" :> 
          Documentation`HelpLookup["paclet:ref/ToRadicals"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Normal\"\>", 2->"\<\"Root\"\>", 
       3->"\<\"RootApproximant\"\>", 4->"\<\"RootReduce\"\>", 
       5->"\<\"RootSum\"\>", 6->"\<\"ToRadicals\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Algebraic Numbers", "Title",
 CellTags->{"S3.4.3", "3.1"},
 CellID->28070],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Root",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Root"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " root of the polynomial equation ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["f", "TI"], "[", 
        StyleBox["x", "TI"], "]"}], "==", "0"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->7487],

Cell["The representation of algebraic numbers. ", "Caption",
 CellID->28297],

Cell[TextData[{
 "When you enter a ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object, the polynomial that appears in it is automatically reduced to a \
minimal form. "
}], "MathCaption",
 CellID->7518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"24", "-", 
     RowBox[{"2", "#"}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"#", "^", "5"}]}]}], "&"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->8177],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"12", "-", "#1", "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{158, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->17773]
}, Open  ]],

Cell[TextData[{
 "This extracts the pure function which represents the polynomial, and \
applies it to ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"First", "[", "%", "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->1763],

Cell[BoxData[
 RowBox[{"12", "-", "x", "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "5"]}]}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->2668]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects are the way that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents ",
 StyleBox["algebraic numbers",
  FontSlant->"Italic"],
 ". Algebraic numbers have the property that when you perform algebraic \
operations on them, you always get a single algebraic number as the result. "
}], "Text",
 CellID->17192],

Cell["Here is the square root of an algebraic number. ", "MathCaption",
 CellID->13985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "-", "#", "+", 
      RowBox[{"#", "^", "5"}]}], "&"}], ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->3102],

Cell[BoxData[
 SqrtBox[
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "-", "#1", "+", 
      SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]]], "Output",
 ImageSize->{160, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->8480]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " reduces this to a single ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->29213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->7627],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "-", 
     SuperscriptBox["#1", "2"], "+", 
     SuperscriptBox["#1", "10"]}], "&"}], ",", "6"}], "]"}]], "Output",
 ImageSize->{151, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->4802]
}, Open  ]],

Cell["\<\
Here is a more complicated expression involving an algebraic number. \
\>", "MathCaption",
 CellID->4099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", "2", "]"}], "+", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "-", "#", "+", 
       RowBox[{"#", "^", "5"}]}], "&"}], ",", "1"}], "]"}], "^", 
   "2"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->30527],

Cell[BoxData[
 RowBox[{
  SqrtBox["2"], "+", 
  SuperscriptBox[
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "-", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}], 
   "2"]}]], "Output",
 ImageSize->{183, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->2625]
}, Open  ]],

Cell[TextData[{
 "Again this can be reduced to a single ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object, albeit a fairly complicated one. "
}], "MathCaption",
 CellID->1543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->1924],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"14", "-", 
     RowBox[{"72", " ", "#1"}], "+", 
     RowBox[{"25", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"144", " ", 
      SuperscriptBox["#1", "3"]}], "-", 
     RowBox[{"88", " ", 
      SuperscriptBox["#1", "4"]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["#1", "5"]}], "+", 
     RowBox[{"62", " ", 
      SuperscriptBox["#1", "6"]}], "-", 
     RowBox[{"14", " ", 
      SuperscriptBox["#1", "8"]}], "+", 
     SuperscriptBox["#1", "10"]}], "&"}], ",", "2"}], "]"}]], "Output",
 ImageSize->{465, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->11023]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RootReduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RootReduce"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "attempt to reduce ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to a single ",
     Cell[BoxData[
      ButtonBox["Root",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Root"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ToRadicals",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToRadicals"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "attempt to transform ",
     Cell[BoxData[
      ButtonBox["Root",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Root"]], "InlineFormula"],
     " objects to explicit radicals"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29972],

Cell["Operations on algebraic numbers. ", "Caption",
 CellID->13061],

Cell[TextData[{
 "In this simple case the ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object is automatically expressed in terms of radicals. "
}], "MathCaption",
 CellID->14181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "2"}], "-", "#", "-", "1"}], "&"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->31003],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    SqrtBox["5"]}], ")"}]}]], "Output",
 ImageSize->{76, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->27432]
}, Open  ]],

Cell[TextData[{
 "When cubic polynomials are involved, ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects are not automatically expressed in terms of radicals. "
}], "MathCaption",
 CellID->17505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "3"}], "-", "2"}], "&"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->27593],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{122, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->22725]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " attempts to express all ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects in terms of radicals. "
}], "MathCaption",
 CellID->13031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", "%", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->8492],

Cell[BoxData[
 SuperscriptBox["2", 
  RowBox[{"1", "/", "3"}]]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->142]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " do not succeed in expressing the solution to a particular polynomial \
equation in terms of radicals, then it is a good guess that this \
fundamentally cannot be done. However, you should realize that there are some \
special cases in which a reduction to radicals is in principle possible, but \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot find it. The simplest example is the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "5"], "+", "20", "x", "+", "32", "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 ", but here the solution in terms of radicals is very complicated. The \
equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "6"], "-", "9", 
    SuperscriptBox["x", "4"], "-", "4", 
    SuperscriptBox["x", "3"], "+", "27", 
    SuperscriptBox["x", "2"], "-", "36", "x", "-", "23"}], TraditionalForm]], 
  "InlineMath"],
 " is another example, where now ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    SuperscriptBox["2", 
     FractionBox["1", "3"]], "+", 
    SuperscriptBox["3", 
     FractionBox["1", "2"]]}], TraditionalForm]], "InlineMath"],
 " is a solution. "
}], "Text",
 CellID->17222],

Cell[TextData[{
 "This gives a ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object involving a degree six polynomial. "
}], "MathCaption",
 CellID->31286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"2", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "3"}], ")"}]}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->13064],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "23"}], "-", 
     RowBox[{"36", " ", "#1"}], "+", 
     RowBox[{"27", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["#1", "3"]}], "-", 
     RowBox[{"9", " ", 
      SuperscriptBox["#1", "4"]}], "+", 
     SuperscriptBox["#1", "6"]}], "&"}], ",", "2"}], "]"}]], "Output",
 ImageSize->{306, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->7900]
}, Open  ]],

Cell[TextData[{
 "Even though a simple form in terms of radicals does exist, ",
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " does not find it. "
}], "MathCaption",
 CellID->19187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", "%", "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->8360],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "23"}], "-", 
     RowBox[{"36", " ", "#1"}], "+", 
     RowBox[{"27", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["#1", "3"]}], "-", 
     RowBox[{"9", " ", 
      SuperscriptBox["#1", "4"]}], "+", 
     SuperscriptBox["#1", "6"]}], "&"}], ",", "2"}], "]"}]], "Output",
 ImageSize->{306, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->22413]
}, Open  ]],

Cell["\<\
Beyond degree four, most polynomials do not have roots that can be expressed \
at all in terms of radicals. However, for degree five it turns out that the \
roots can always be expressed in terms of elliptic or hypergeometric \
functions. The results, however, are typically much too complicated to be \
useful in practice. \
\>", "Text",
 CellID->30974],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RootSum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RootSum"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "the sum of ",
     Cell[BoxData[
      RowBox[{
       StyleBox["form", "TI"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " for all ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " satisfying the polynomial equation ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["f", "TI"], "[", 
        StyleBox["x", "TI"], "]"}], "==", "0"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Normal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Normal"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "the form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      ButtonBox["RootSum",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
     " replaced by explicit sums of ",
     Cell[BoxData[
      ButtonBox["Root",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Root"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->14270],

Cell["Sums of roots. ", "Caption",
 CellID->29170],

Cell[TextData[{
 "This computes the sum of the reciprocals of the roots of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "+", "2", "x", "+", 
    SuperscriptBox["x", "5"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", "#"}], "+", 
      RowBox[{"#", "^", "5"}]}], ")"}], "&"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "#"}], ")"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->30833],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->19711]
}, Open  ]],

Cell["Now no explicit result can be given in terms of radicals. ", \
"MathCaption",
 CellID->25760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", "#"}], "+", 
      RowBox[{"#", "^", "5"}]}], ")"}], "&"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "#"}], "]"}]}], ")"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->18896],

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "#1"}], "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "#1"}], "]"}], " ", "#1"}], "&"}]}], "]"}]], "Output",\

 ImageSize->{261, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->4667]
}, Open  ]],

Cell[TextData[{
 "This expands the ",
 Cell[BoxData[
  ButtonBox["RootSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
 " into an explicit sum involving ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects. "
}], "MathCaption",
 CellID->7285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->12550],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnOlu00AQx904V6+kB6hpQWoA8R0JJN6AS+IB+IIUVUit1Iq29GXgE2/q
2t7dZDueyazPONmplDi72WNm9u89fnL6ffZw+etm9nB1MZt+vp/dXl5d/Jl+
+n0fZ4VbQbB1GwTBz0kQf47iT+kr+buLX0FwHr934qwP+nqjrz19fauv1/o6
mtcKQtNSFLwH6RuQ7oL0G5C+Bum9Bns5id9D7fGy3n6A9GHO3mH9A9SaM5Db
cbAqGZejAtYk9aAXyoph/N6LM0Mdm6S1rr5C65JyfaT3UNe3801bJt7hkjYH
IL+n89Nx6i7yVS9YjS5Zck97rwxMC2RsHUa4LqC9VfgK45ffV7qki68Dwlel
hu1M26kqe/MclUnkYvGy05jvrm3juSGdu8QONKKoN33EK1g7JMrtZmJpZtph
oeitKlpuo+YaLaocHa2BU7Sa0G+Spu/VXKMA48mMOzZz9NGIYTWzsyMsuWtZ
On/PrDRwhUIV2lhczGgUj0vWXre4wJUUxsXSIpgn6pxJuzXHG97J/LoEW+RX
bXRVstLHTOQxRdYdFzgW5ePC14Bx4e7U3Iq02yqoxwrWqhLqHGLla1Znss93
2Uc2Hx04PuWjk1+jYyI6uDbNfjq52ntazHvo7YiMmb1TN7tmTttwzglZz0ds
iX3tFTwZFlNOUc/grMF7Nnb2bMx4ho86jLXbyML1mIviGG2F2pnuE/lQhac5
rcDHMq8veEQoX0aOvkwYKxbsIMl8hrRmNJCYBkmH+f5I18/u2Mxdf0B+Y3sQ
6D4wbkHtGimbDlmbDp1tOiVscmNe30B6yngGuQ+sD/tzs+KL9g22zvVu6r0m
e7VZ5FdQ6lWEs0lYbhrZrPK/Hrt/+vouzU0K3oFPsH9hoVRvwkL9YqE7hA+b
yEK3CR9gL6kahY0Cb+pho/DU4MScPKSiu0ycVqFh3/io2U1zWvGFi5qTEmZx
z/gnXLQG8kSfaDld+kBH6TOy44zppla7bkGt+slMs6fpBlb8EhpeFT1dHic3
/frBVe3znetMuB5c1T4/Y55tHle12UDxsWwHV7UZMT16beKqL5F8LF5NctUX
hE3CVc8j4arCVRfWCFdtC1eVZ0yFq/J21MdV5ZnT6p85FcYqz6C29RlUYa7y
LGo7n0UVzroKzprMFx2knNDV5OMBER1hqgvyWGS+Ww+mWuzp+XVmqhOy1fwj
2g6yeuLkUfv46lnkzgWafG4Vs0n46nkkfFX46sIa4att4auDyG0fsQl8tU/4
KnyVs0P4qkoLX+X2Wb7wVe53er7y1RFjqfDVJogVp42m49IGvgp3ojlmTTeF
2nUL6tM/voryqfpX/hLaXQVnhfd0jl9eIXt44a28ooS35rtLhLcKbzVp4a3u
Vmwmb51E+Xjr83mtZbEqS0KPG+yF+p9GTfNWZQ23JtbNW5UVT/YbgXBX4a5P
0+nORWlTuGvN3HWHsU+Iq4oTdoZatYZ9Y60cufGVtUIGTY2YpUl4MhHWunRF
F9bqVqMsa82tUHuXU1Cf/rHWImr1j7VWo10/WGs1imoja+VUoE60cNTXmbVC
YrfOlBX+T1l89FS2+WsLZe0EOPHA9pxNUVbMJjeaVjdldbOiasq66LVKyqoo
6N/oKWX9qMZh6xEf5Tq0\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{368, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->386371707]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RootApproximant",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RootApproximant"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "converts the number ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " to one of the \"simplest\" algebraic numbers that approximates it \
well"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RootApproximant",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RootApproximant"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "finds an algebraic number of degree at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " that approximates ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->42580593],

Cell[TextData[{
 "This recovers ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 " from a numerical approximation."
}], "MathCaption",
 CellID->186890815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootApproximant", "[", 
  RowBox[{"N", "[", 
   RowBox[{"Sqrt", "[", "2", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->312882027],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->300609831]
}, Open  ]],

Cell["In this case, the result has degree at most 4.", "MathCaption",
 CellID->198867802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootApproximant", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->520816800],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{163, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->416859724]
}, Open  ]],

Cell[TextData[{
 "This confirms that the ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " expression does correspond to ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 " + ",
 Cell[BoxData[
  FormBox[
   SqrtBox["3"], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->25129329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->102880460],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{163, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->642675827]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->687941341],

Cell[TextData[ButtonBox["Manipulating Equations and Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], \
"RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Algebraic Numbers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Manipulating Equations and Inequalities", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/EquationsInOneVariable"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SimultaneousEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 33.5289386}", "context" -> "", 
    "keywords" -> {
     "algebraic numbers", "combining radicals", "elliptic functions", 
      "Galois theory", "hypergeometric functions", "minimal polynomial", 
      "normal", "numbers", "polynomial", "reducing radicals", "RootReduce", 
      "roots", "RootSum", "simplifying radicals", "sums", "ToRadicals", 
      "Vieta's formulas"}, "index" -> True, "label" -> "Mathematica Tutorial",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The representation of algebraic numbers. When you enter a Root object, \
the polynomial that appears in it is automatically reduced to a minimal form. \
This extracts the pure function which represents the polynomial, and applies \
it to x. ", "synonyms" -> {"3.4.3"}, "title" -> "Algebraic Numbers", "type" -> 
    "Tutorial", "uri" -> "tutorial/AlgebraicNumbers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.4.3"->{
  Cell[2382, 67, 80, 2, 70, "Title",
   CellTags->{"S3.4.3", "3.1"},
   CellID->28070]},
 "3.1"->{
  Cell[2382, 67, 80, 2, 70, "Title",
   CellTags->{"S3.4.3", "3.1"},
   CellID->28070]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.4.3", 28057, 1008},
 {"3.1", 28156, 1012}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1757, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2382, 67, 80, 2, 70, "Title",
 CellTags->{"S3.4.3", "3.1"},
 CellID->28070],
Cell[2465, 71, 951, 30, 70, "DefinitionBox",
 CellID->7487],
Cell[3419, 103, 76, 1, 70, "Caption",
 CellID->28297],
Cell[3498, 106, 275, 9, 70, "MathCaption",
 CellID->7518],
Cell[CellGroupData[{
Cell[3798, 119, 248, 9, 28, "Input",
 CellID->8177],
Cell[4049, 130, 320, 11, 39, "Output",
 CellID->17773]
}, Open  ]],
Cell[4384, 144, 184, 6, 70, "MathCaption",
 CellID->32270],
Cell[CellGroupData[{
Cell[4593, 154, 125, 4, 28, "Input",
 CellID->1763],
Cell[4721, 160, 235, 8, 36, "Output",
 CellID->2668]
}, Open  ]],
Cell[4971, 171, 458, 14, 70, "Text",
 CellID->17192],
Cell[5432, 187, 87, 1, 70, "MathCaption",
 CellID->13985],
Cell[CellGroupData[{
Cell[5544, 192, 234, 8, 70, "Input",
 CellID->3102],
Cell[5781, 202, 307, 11, 45, "Output",
 CellID->8480]
}, Open  ]],
Cell[6103, 216, 328, 12, 70, "MathCaption",
 CellID->29213],
Cell[CellGroupData[{
Cell[6456, 232, 102, 3, 70, "Input",
 CellID->7627],
Cell[6561, 237, 319, 11, 39, "Output",
 CellID->4802]
}, Open  ]],
Cell[6895, 251, 115, 3, 70, "MathCaption",
 CellID->4099],
Cell[CellGroupData[{
Cell[7035, 258, 290, 11, 70, "Input",
 CellID->30527],
Cell[7328, 271, 363, 14, 41, "Output",
 CellID->2625]
}, Open  ]],
Cell[7706, 288, 249, 8, 70, "MathCaption",
 CellID->1543],
Cell[CellGroupData[{
Cell[7980, 300, 102, 3, 70, "Input",
 CellID->1924],
Cell[8085, 305, 717, 23, 39, "Output",
 CellID->11023]
}, Open  ]],
Cell[8817, 331, 1182, 38, 70, "DefinitionBox",
 CellID->29972],
Cell[10002, 371, 68, 1, 70, "Caption",
 CellID->13061],
Cell[10073, 374, 251, 8, 70, "MathCaption",
 CellID->14181],
Cell[CellGroupData[{
Cell[10349, 386, 203, 8, 70, "Input",
 CellID->31003],
Cell[10555, 396, 259, 10, 51, "Output",
 CellID->27432]
}, Open  ]],
Cell[10829, 409, 270, 8, 70, "MathCaption",
 CellID->17505],
Cell[CellGroupData[{
Cell[11124, 421, 190, 7, 70, "Input",
 CellID->27593],
Cell[11317, 430, 302, 11, 39, "Output",
 CellID->22725]
}, Open  ]],
Cell[11634, 444, 349, 12, 70, "MathCaption",
 CellID->13031],
Cell[CellGroupData[{
Cell[12008, 460, 102, 3, 70, "Input",
 CellID->8492],
Cell[12113, 465, 199, 7, 36, "Output",
 CellID->142]
}, Open  ]],
Cell[12327, 475, 1451, 44, 70, "Text",
 CellID->17222],
Cell[13781, 521, 226, 8, 70, "MathCaption",
 CellID->31286],
Cell[CellGroupData[{
Cell[14032, 533, 234, 8, 70, "Input",
 CellID->13064],
Cell[14269, 543, 537, 18, 39, "Output",
 CellID->7900]
}, Open  ]],
Cell[14821, 564, 260, 8, 70, "MathCaption",
 CellID->19187],
Cell[CellGroupData[{
Cell[15106, 576, 103, 3, 70, "Input",
 CellID->8360],
Cell[15212, 581, 538, 18, 39, "Output",
 CellID->22413]
}, Open  ]],
Cell[15765, 602, 364, 7, 70, "Text",
 CellID->30974],
Cell[16132, 611, 1630, 53, 70, "DefinitionBox",
 CellID->14270],
Cell[17765, 666, 50, 1, 70, "Caption",
 CellID->29170],
Cell[17818, 669, 245, 8, 70, "MathCaption",
 CellID->235],
Cell[CellGroupData[{
Cell[18088, 681, 323, 12, 70, "Input",
 CellID->30833],
Cell[18414, 695, 173, 6, 36, "Output",
 CellID->19711]
}, Open  ]],
Cell[18602, 704, 99, 2, 70, "MathCaption",
 CellID->25760],
Cell[CellGroupData[{
Cell[18726, 710, 380, 14, 70, "Input",
 CellID->18896],
Cell[19109, 726, 429, 16, 39, "Output",
 CellID->4667]
}, Open  ]],
Cell[19553, 745, 350, 13, 70, "MathCaption",
 CellID->7285],
Cell[CellGroupData[{
Cell[19928, 762, 100, 3, 28, "Input",
 CellID->12550],
Cell[20031, 767, 1881, 35, 115, "Output",
 Evaluatable->False,
 CellID->386371707]
}, Open  ]],
Cell[21927, 805, 907, 29, 70, "DefinitionBox",
 CellID->42580593],
Cell[22837, 836, 186, 7, 70, "MathCaption",
 CellID->186890815],
Cell[CellGroupData[{
Cell[23048, 847, 171, 5, 70, "Input",
 CellID->312882027],
Cell[23222, 854, 169, 6, 38, "Output",
 CellID->300609831]
}, Open  ]],
Cell[23406, 863, 89, 1, 70, "MathCaption",
 CellID->198867802],
Cell[CellGroupData[{
Cell[23520, 868, 256, 8, 70, "Input",
 CellID->520816800],
Cell[23779, 878, 350, 12, 39, "Output",
 CellID->416859724]
}, Open  ]],
Cell[24144, 893, 395, 16, 70, "MathCaption",
 CellID->25129329],
Cell[CellGroupData[{
Cell[24564, 913, 193, 6, 70, "Input",
 CellID->102880460],
Cell[24760, 921, 350, 12, 39, "Output",
 CellID->642675827]
}, Open  ]],
Cell[CellGroupData[{
Cell[25147, 938, 72, 1, 70, "RelatedTutorialsSection",
 CellID->687941341],
Cell[25222, 941, 208, 5, 70, "RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],
Cell[25457, 950, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

