(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17477,        635]
NotebookOptionsPosition[     12342,        477]
NotebookOutlinePosition[     15206,        550]
CellTagsIndexPosition[     15115,        544]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functional Operations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Apply" :> Documentation`HelpLookup["paclet:ref/Apply"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Apply\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Applying Functions to Lists and Other Expressions", "Title",
 CellTags->{"S2.2.3", "3.1"},
 CellID->3829],

Cell[TextData[{
 "In an expression like ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "InlineFormula"],
 " you are giving a list as the argument to a function. Often you need \
instead to apply a function directly to the elements of a list, rather than \
to the list as a whole. You can do this in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->23775],

Cell[TextData[{
 "This makes each element of the list an argument of the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29292],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89267012]
}, Open  ]],

Cell[TextData[{
 "This gives ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Times",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Times"], "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "InlineFormula"],
 " which yields the product of the elements in the list. "
}], "MathCaption",
 CellID->17549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29556],

Cell[BoxData[
 RowBox[{"a", " ", "b", " ", "c"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->186530753]
}, Open  ]],

Cell[TextData[{
 "Here is a definition of a function that works like the built-in function ",
 Cell[BoxData[
  ButtonBox["GeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricMean"]], "InlineFormula"],
 ", written using ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31627],

Cell[BoxData[
 RowBox[{
  RowBox[{"geom", "[", "list_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Apply", "[", 
    RowBox[{"Times", ",", "list"}], "]"}], "^", 
   RowBox[{"(", 
    RowBox[{"1", "/", 
     RowBox[{"Length", "[", "list", "]"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6467],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Apply",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Apply"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to a list, giving ",
     Cell[BoxData[
      FormBox[
       RowBox[{"f", "[", 
        RowBox[{"a", ",", "b", ",", "\[Ellipsis]"}], "]"}], TraditionalForm]],
       "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Apply",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Apply"], "[", 
      RowBox[{
       StyleBox["f", "TI"], ",", 
       StyleBox["expr", "TI"]}], "]"}], 
     StyleBox["   ", "TableText"], 
     StyleBox["or", "TableText"], 
     StyleBox["   ", "TableText"], 
     RowBox[{
      StyleBox["f", "TI"], "@@", 
      StyleBox["expr", "TI"]}]}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to the top level of an expression"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Apply",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Apply"], "[", 
      RowBox[{
       StyleBox["f", "TI"], ",", 
       StyleBox["expr", "TI"], ",", 
       RowBox[{"{", "1", "}"}]}], "]"}], 
     StyleBox["   ", "TableText"], 
     StyleBox["or", "TableText"], 
     StyleBox["   ", "TableText"], 
     RowBox[{
      StyleBox["f", "TI"], "@@@", 
      StyleBox["expr", "TI"]}]}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " at the first level in an expression"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Apply",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Apply"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["lev", "TI"], "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " at the specified levels in an expression"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29541],

Cell["Applying functions to lists and other expressions. ", "Caption",
 CellID->26129],

Cell[TextData[{
 "What ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " does in general is to replace the head of an expression with the function \
you specify. Here it replaces ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " by ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"List", ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->27813],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->29174]
}, Open  ]],

Cell["Here is a matrix. ", "MathCaption",
 CellID->20601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "c", ",", "d"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->6077],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->20215]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " without an explicit level specification replaces the top\[Hyphen]level \
list with ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", "m"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->8213],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->23992]
}, Open  ]],

Cell[TextData[{
 "This applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " only to parts of ",
 Cell[BoxData["m"], "InlineFormula"],
 " at level 1. "
}], "MathCaption",
 CellID->25824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", "m", ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->5601],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "c", ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->23392]
}, Open  ]],

Cell[TextData[{
 "This applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " at levels 0 through 1. "
}], "MathCaption",
 CellID->15759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", "m", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->2670],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "c", ",", "d"}], "]"}]}], "]"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->26428]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->17976529],

Cell[TextData[ButtonBox["Functional Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionalOperationsOverview"]], "RelatedTutorials",
 CellID->222363673]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->68515862],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->118447652],

Cell[TextData[{
 ButtonBox["M221: Introduction to Programming in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->551506586]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Applying Functions to Lists and Other Expressions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functional Operations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionalOperationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ApplyingFunctionsRepeatedly"],
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 45.4823696}", "context" -> "", 
    "keywords" -> {
     "apply", "applying functions", "matrices", "reduce in APL"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "In an expression like f[{a,b,c}] you are giving a list as the argument \
to a function. Often you need instead to apply a function directly to the \
elements of a list, rather than to the list as a whole. You can do this in \
Mathematica using Apply. This makes each element of the list an argument of \
the function f. This gives Times[a,b,c] which yields the product of the \
elements in the list. ", "synonyms" -> {"2.2.3"}, "title" -> 
    "Applying Functions to Lists and Other Expressions", "type" -> "Tutorial",
     "uri" -> "tutorial/ApplyingFunctionsToListsAndOtherExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.2.3"->{
  Cell[1800, 58, 111, 2, 70, "Title",
   CellTags->{"S2.2.3", "3.1"},
   CellID->3829]},
 "3.1"->{
  Cell[1800, 58, 111, 2, 70, "Title",
   CellTags->{"S2.2.3", "3.1"},
   CellID->3829]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.2.3", 14904, 533},
 {"3.1", 15003, 537}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1175, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1800, 58, 111, 2, 70, "Title",
 CellTags->{"S2.2.3", "3.1"},
 CellID->3829],
Cell[1914, 62, 572, 18, 70, "Text",
 CellID->23775],
Cell[2489, 82, 163, 5, 70, "MathCaption",
 CellID->20608],
Cell[CellGroupData[{
Cell[2677, 91, 179, 6, 28, "Input",
 CellID->29292],
Cell[2859, 99, 217, 7, 36, "Output",
 CellID->89267012]
}, Open  ]],
Cell[3091, 109, 303, 10, 70, "MathCaption",
 CellID->17549],
Cell[CellGroupData[{
Cell[3419, 123, 183, 6, 28, "Input",
 CellID->29556],
Cell[3605, 131, 190, 6, 36, "Output",
 CellID->186530753]
}, Open  ]],
Cell[3810, 140, 397, 13, 70, "MathCaption",
 CellID->31627],
Cell[4210, 155, 299, 10, 70, "Input",
 CellID->6467],
Cell[4512, 167, 2631, 86, 70, "DefinitionBox",
 CellID->29541],
Cell[7146, 255, 86, 1, 70, "Caption",
 CellID->26129],
Cell[7235, 258, 522, 19, 70, "MathCaption",
 CellID->31240],
Cell[CellGroupData[{
Cell[7782, 281, 158, 5, 70, "Input",
 CellID->27813],
Cell[7943, 288, 210, 7, 36, "Output",
 CellID->29174]
}, Open  ]],
Cell[8168, 298, 57, 1, 70, "MathCaption",
 CellID->20601],
Cell[CellGroupData[{
Cell[8250, 303, 257, 9, 70, "Input",
 CellID->6077],
Cell[8510, 314, 319, 11, 36, "Output",
 CellID->20215]
}, Open  ]],
Cell[8844, 328, 306, 11, 70, "MathCaption",
 CellID->8683],
Cell[CellGroupData[{
Cell[9175, 343, 120, 4, 70, "Input",
 CellID->8213],
Cell[9298, 349, 324, 11, 36, "Output",
 CellID->23992]
}, Open  ]],
Cell[9637, 363, 184, 7, 70, "MathCaption",
 CellID->25824],
Cell[CellGroupData[{
Cell[9846, 374, 154, 5, 70, "Input",
 CellID->5601],
Cell[10003, 381, 329, 11, 36, "Output",
 CellID->23392]
}, Open  ]],
Cell[10347, 395, 134, 5, 70, "MathCaption",
 CellID->15759],
Cell[CellGroupData[{
Cell[10506, 404, 179, 6, 70, "Input",
 CellID->2670],
Cell[10688, 412, 334, 11, 36, "Output",
 CellID->26428]
}, Open  ]],
Cell[CellGroupData[{
Cell[11059, 428, 71, 1, 70, "RelatedTutorialsSection",
 CellID->17976529],
Cell[11133, 431, 174, 4, 70, "RelatedTutorials",
 CellID->222363673]
}, Open  ]],
Cell[CellGroupData[{
Cell[11344, 440, 97, 1, 70, "TutorialRelatedLinksSection",
 CellID->68515862],
Cell[11444, 443, 414, 13, 70, "TutorialRelatedLinks",
 CellID->118447652],
Cell[11861, 458, 427, 13, 70, "TutorialRelatedLinks",
 CellID->551506586]
}, Open  ]]
}, Open  ]],
Cell[12315, 475, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

