(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58400,       1975]
NotebookOptionsPosition[     46402,       1592]
NotebookOutlinePosition[     50618,       1683]
CellTagsIndexPosition[     50525,       1677]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Data" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnDataOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Operations on Data\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FunctionInterpolation" :> 
          Documentation`HelpLookup["paclet:ref/FunctionInterpolation"], 
          "Interpolation" :> 
          Documentation`HelpLookup["paclet:ref/Interpolation"], 
          "ListInterpolation" :> 
          Documentation`HelpLookup["paclet:ref/ListInterpolation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FunctionInterpolation\"\>", 
       2->"\<\"Interpolation\"\>", 
       3->"\<\"ListInterpolation\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Approximate Functions and Interpolation", "Title",
 CellTags->{"S3.8.3", "3.1"},
 CellID->24050],

Cell[TextData[{
 "In many kinds of numerical computations, it is convenient to introduce ",
 StyleBox["approximate functions",
  FontSlant->"Italic"],
 ". Approximate functions can be thought of as generalizations of ordinary \
approximate real numbers. While an approximate real number gives the value to \
a certain precision of a single numerical quantity, an approximate function \
gives the value to a certain precision of a quantity which depends on one or \
more parameters. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses approximate functions, for example, to represent numerical solutions \
to differential equations obtained with ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ", as discussed in \"",
 ButtonBox["Numerical Differential Equations\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NumericalDifferentialEquations"],
 ". "
}], "Text",
 CellID->24155],

Cell[TextData[{
 "Approximate functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are represented by ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects. These objects work like the pure functions discussed in \"",
 ButtonBox["Pure Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PureFunctions"],
 ". The basic idea is that when given a particular argument, an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object finds the approximate function value that corresponds to that \
argument. "
}], "Text",
 CellID->31361],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object contains a representation of the approximate function based on \
interpolation. Typically it contains values and possibly derivatives at a \
sequence of points. It effectively assumes that the function varies smoothly \
between these points. As a result, when you ask for the value of the function \
with a particular argument, the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object can interpolate to find an approximation to the value you want. "
}], "Text",
 CellID->15264],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Interpolation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Interpolation"], "[", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "construct an approximate function with values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at successive integers"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Interpolation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Interpolation"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "construct an approximate function with values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at points ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11903],

Cell["Constructing approximate functions. ", "Caption",
 CellID->3676],

Cell["Here is a table of the values of the sine function. ", "MathCaption",
 CellID->29643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2", ",", "0.25"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26909],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.25`", ",", "0.24740395925452294`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "0.479425538604203`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.75`", ",", "0.6816387600233341`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.8414709848078965`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.25`", ",", "0.9489846193555862`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "0.9974949866040544`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.75`", ",", "0.9839859468739369`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "0.9092974268256817`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{532, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->234779472]
}, Open  ]],

Cell["\<\
This constructs an approximate function which represents these values. \
\>", "MathCaption",
 CellID->3561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sin", "=", 
  RowBox[{"Interpolation", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28489],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8489091]
}, Open  ]],

Cell["\<\
The approximate function reproduces each of the values in the original table. \
\
\>", "MathCaption",
 CellID->1282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sin", "[", "0.25", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13653],

Cell[BoxData["0.24740395925452294`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->148085629]
}, Open  ]],

Cell["\<\
It also allows you to get approximate values at other points. \
\>", "MathCaption",
 CellID->2220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sin", "[", "0.3", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5402],

Cell[BoxData["0.29550049681366897`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->79547437]
}, Open  ]],

Cell["\<\
In this case the interpolation is a fairly good approximation to the true \
sine function. \
\>", "MathCaption",
 CellID->3831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "0.3", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->19369],

Cell[BoxData["0.29552020666133955`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->59348543]
}, Open  ]],

Cell[TextData[{
 "You can work with approximate functions much as you would with any other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions. You can plot approximate functions, or perform numerical \
operations such as integration or root finding. "
}], "Text",
 CellID->20259],

Cell["\<\
If you give a non\[Hyphen]numerical argument, the approximate function is \
left in symbolic form. \
\>", "MathCaption",
 CellID->19008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sin", "[", "x", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->22619],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"InterpolatingFunction", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
   False,
   Editable->False], "[", "x", "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->214787982]
}, Open  ]],

Cell["Here is a numerical integral of the approximate function. ", \
"MathCaption",
 CellID->30003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"sin", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->21945],

Cell[BoxData["0.7853101018645829`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->150179995]
}, Open  ]],

Cell["\<\
Here is the same numerical integral for the true sine function. \
\>", "MathCaption",
 CellID->26504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->12392],

Cell[BoxData["0.7853981633974492`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->137737915]
}, Open  ]],

Cell["\<\
A plot of the approximate function is essentially indistinguishable from the \
true sine function. \
\>", "MathCaption",
 CellID->25313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->6698],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->330872765]
}, Open  ]],

Cell[TextData[{
 "If you differentiate an approximate function, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will return another approximate function that represents the derivative. "
}], "Text",
 CellID->12722],

Cell[TextData[{
 "This finds the derivative of the approximate sine function, and evaluates \
it at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "6"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->5938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sin", "'"}], "[", 
  RowBox[{"Pi", "/", "6"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->19037],

Cell[BoxData["0.8653722533086783`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->241760024]
}, Open  ]],

Cell["The result is close to the exact one. ", "MathCaption",
 CellID->31461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"Pi", "/", "6"}], "]"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->6234],

Cell[BoxData["0.8660254037844386`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->385543604]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects contain all the information ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " needs about approximate functions. In standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output format, however, only the part that gives the domain of the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object is printed explicitly. The lists of actual parameters used in the \
",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object are shown only in iconic form. "
}], "Text",
 CellID->9961],

Cell[TextData[{
 "In standard output format, the only part of an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object printed explicitly is its domain. "
}], "MathCaption",
 CellID->3959],

Cell[CellGroupData[{

Cell[BoxData["sin"], "Input",
 CellLabel->"In[12]:=",
 CellID->6493],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->52513737]
}, Open  ]],

Cell[TextData[{
 "If you ask for a value outside of the domain, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints a warning, then uses extrapolation to find a result."
}], "MathCaption",
 CellID->25269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sin", "[", "3", "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->24937],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunction", "::", "\<\"dmval\"\>"}], ":", 
  " ", "\<\"Input value \\!\\({3}\\) lies outside the range of data in the \
interpolating function. Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellLabel->"During evaluation of In[13]:=",
 CellID->77594541],

Cell[BoxData["0.015547076660245462`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->57989402]
}, Open  ]],

Cell[TextData[{
 "The more information you give about the function you are trying to \
approximate, the better the approximation ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " constructs can be. You can, for example, specify not only values of the \
function at a sequence of points, but also derivatives. "
}], "Text",
 CellID->14700],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Interpolation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Interpolation"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], "}"}], ",", 
         SubscriptBox[
          StyleBox["f", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["df", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["ddf", "TI"], 
          StyleBox["1", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "construct an approximate function with specified derivatives at points \
",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13971],

Cell["\<\
Constructing approximate functions with specified derivatives. \
\>", "Caption",
 CellID->26264],

Cell["\<\
This interpolates through the values of the sine function and its first \
derivative.\
\>", "MathCaption",
 CellID->104428578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sind", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "2", ",", "0.25"}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[14]:=",
 CellID->224781264],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->173431074]
}, Open  ]],

Cell["\<\
This finds a better approximation to the derivative than the previous \
interpolation.\
\>", "MathCaption",
 CellID->274287925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sind", "'"}], "[", 
  RowBox[{"Pi", "/", "6"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->394062372],

Cell[BoxData["0.8659739321903082`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->292083173]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Interpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpolation"]], "InlineFormula"],
 " works by fitting polynomial curves between the points you specify. You can \
use the option ",
 Cell[BoxData[
  ButtonBox["InterpolationOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFormula"],
 " to specify the degree of these polynomial curves. The default setting is \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InterpolationOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolationOrder"], "->", "3"}]], 
  "InlineFormula"],
 ", yielding cubic curves. "
}], "Text",
 CellID->15117],

Cell["This makes a table of values of the cosine function. ", "MathCaption",
 CellID->16215],

Cell[BoxData[
 RowBox[{
  RowBox[{"tab", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->24555],

Cell["\<\
This creates an approximate function using linear interpolation between the \
values in the table. \
\>", "MathCaption",
 CellID->7815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", 
  RowBox[{"tab", ",", 
   RowBox[{"InterpolationOrder", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->18330],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "6"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->37159040]
}, Open  ]],

Cell["\<\
The approximate function consists of a collection of straight\[Hyphen]line \
segments. \
\>", "MathCaption",
 CellID->30212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"%", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->29288],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->511217596]
}, Open  ]],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InterpolationOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolationOrder"], "->", "3"}]], 
  "InlineFormula"],
 ", cubic curves are used, and the function looks smooth. "
}], "MathCaption",
 CellID->1954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Interpolation", "[", "tab", "]"}], "]"}], "[", "x", "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->16085],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->10247961]
}, Open  ]],

Cell[TextData[{
 "Increasing the setting for ",
 Cell[BoxData[
  ButtonBox["InterpolationOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFormula"],
 " typically leads to smoother approximate functions. However, if you \
increase the setting too much, spurious wiggles may develop. "
}], "Text",
 CellID->24484],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      ButtonBox["ListInterpolation",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ListInterpolation"], "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["11", "TR"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["12", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["21", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], " "}], 
    "\[SpanFromLeft]"},
   {"", Cell["\<\
construct an approximate function from a two\[Hyphen]dimensional grid of \
values at integer points\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ListInterpolation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListInterpolation"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "}"}]}], "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell["\<\
assume the values are from an evenly spaced grid with the specified domain\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ListInterpolation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListInterpolation"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell["\<\
assume the values are from a grid with the specified grid lines\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24774],

Cell["Interpolating multidimensional arrays of data. ", "Caption",
 CellID->8380],

Cell["\<\
This interpolates an array of values from integer grid points. \
\>", "MathCaption",
 CellID->29815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListInterpolation", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"1.5", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "3"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "15"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->25951],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.`", ",", "10.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", "15.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->107833850]
}, Open  ]],

Cell["Here is the value at a particular position. ", "MathCaption",
 CellID->18115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"6.5", ",", "7.2"}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->1679],

Cell[BoxData["0.0036075869356459443`"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->541949473]
}, Open  ]],

Cell["Here is another array of values. ", "MathCaption",
 CellID->25898],

Cell[BoxData[
 RowBox[{
  RowBox[{"tab", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"1.5", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "3"}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "5.5", ",", "7.2", ",", ".2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2.3", ",", "8.9", ",", ".1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->23073],

Cell[TextData[{
 "To interpolate this array you explicitly have to tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " the domain it covers. "
}], "MathCaption",
 CellID->788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListInterpolation", "[", 
  RowBox[{"tab", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5.5", ",", "7.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.3", ",", "8.9"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->23977],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5.5`", ",", "7.2`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.3`", ",", "8.9`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->38309847]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListInterpolation"]], "InlineFormula"],
 " works for arrays of any dimension, and in each case it produces an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object which takes the appropriate number of arguments."
}], "Text",
 CellID->29956],

Cell["\<\
This interpolates a three\[Hyphen]dimensional array. \
\>", "MathCaption",
 CellID->28689],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListInterpolation", "[", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#1", "^", "2"}], "+", 
       RowBox[{"#2", "^", "2"}], "-", 
       RowBox[{"#3", "^", "2"}]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10", ",", "10"}], "}"}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->26113],

Cell[TextData[{
 "The resulting ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object takes three arguments. "
}], "MathCaption",
 CellID->10008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"3.4", ",", "7.8", ",", "2.6"}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->12941],

Cell[BoxData["65.63999999999999`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->106048623]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can handle not only purely numerical approximate functions, but also ones \
which involve symbolic parameters. "
}], "Text",
 CellID->1723],

Cell[TextData[{
 "This generates an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " that depends on the parameters ",
 Cell[BoxData["a"], "InlineFormula"],
 " and ",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sfun", "=", 
  RowBox[{"ListInterpolation", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "a"}], ",", "2", ",", "3", ",", 
     RowBox[{"4", "+", "b"}], ",", "5"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[26]:=",
 CellID->28],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->57655233]
}, Open  ]],

Cell["\<\
This shows how the interpolated value at 2.2 depends on the parameters. \
\>", "MathCaption",
 CellID->24778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sfun", "[", "2.2", "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->7200],

Cell[BoxData[
 RowBox[{"2.2`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.04800000000000002`", " ", "a"}], "-", 
  RowBox[{"0.032000000000000035`", " ", "b"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->425584721]
}, Open  ]],

Cell[TextData[{
 "With the default setting for ",
 Cell[BoxData[
  ButtonBox["InterpolationOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFormula"],
 " used, the value at this point no longer depends on ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sfun", "[", "3.8", "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->21974],

Cell[BoxData[
 RowBox[{"3.8`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.8639999999999999`", " ", "b"}]}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->150359362]
}, Open  ]],

Cell[TextData[{
 "In working with approximate functions, you can quite often end up with \
complicated combinations of ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects. You can always tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to produce a single ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object valid over a particular domain by using ",
 Cell[BoxData[
  ButtonBox["FunctionInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionInterpolation"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->11333],

Cell[TextData[{
 "This generates a new ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object valid in the domain 0 to 1. "
}], "MathCaption",
 CellID->22867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionInterpolation", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"sin", "[", 
     RowBox[{"x", "^", "2"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->26153],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->214754231]
}, Open  ]],

Cell[TextData[{
 "This generates a nested ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->32168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListInterpolation", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "4", ",", "5", ",", 
    RowBox[{"sin", "[", "a", "]"}], ",", "6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->20825],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->224220010]
}, Open  ]],

Cell[TextData[{
 "This produces a pure two\[Hyphen]dimensional ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->15629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionInterpolation", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "2"}], "+", 
    RowBox[{"%", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->28650],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.`", ",", "3.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1.5000000000000002`"}], "}"}]}], "}"}], 
    ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->23114285]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FunctionInterpolation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FunctionInterpolation"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "construct an approximate function by evaluating ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ranging from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FunctionInterpolation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FunctionInterpolation"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["max", "TI"]], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
construct a higher\[Hyphen]dimensional approximate function\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3309],

Cell["\<\
Constructing approximate functions by evaluating expressions. \
\>", "Caption",
 CellID->4693],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->187248265],

Cell[TextData[ButtonBox["Numerical Operations on Data",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnDataOverview"]], "RelatedTutorials",
 CellID->618122]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Approximate Functions and Interpolation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Data", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnDataOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/CurveFitting"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FourierTransforms"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 47.6855510}", "context" -> "", 
    "keywords" -> {
     "approximate functions", "approximation of functions", "arrays", 
      "derivatives", "differentation", "extrapolation", 
      "FunctionInterpolation", "functions", "grids", "InterpolatingFunction", 
      "Interpolation", "InterpolationOrder", "ListInterpolation", "NDSolve", 
      "numerical functions", "piecewise linear functions", "reinterpolation", 
      "resampling", "Runge's phenomenon", "smoothing", "splines", "tables", 
      "tensors"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "In many kinds of numerical computations, it is convenient to introduce \
approximate functions. Approximate functions can be thought of as \
generalizations of ordinary approximate real numbers. While an approximate \
real number gives the value to a certain precision of a single numerical \
quantity, an approximate function gives the value to a certain precision of a \
quantity which depends on one or more parameters. Mathematica uses \
approximate functions, for example, to represent numerical solutions to \
differential equations obtained with NDSolve, as discussed in \"Numerical \
Differential Equations\". Approximate functions in Mathematica are \
represented by InterpolatingFunction objects. These objects work like the \
pure functions discussed in \"Pure Functions\". The basic idea is that when \
given a particular argument, an InterpolatingFunction object finds the \
approximate function value that corresponds to that argument. The \
InterpolatingFunction object contains a representation of the approximate \
function based on interpolation. Typically it contains values and possibly \
derivatives at a sequence of points. It effectively assumes that the function \
varies smoothly between these points. As a result, when you ask for the value \
of the function with a particular argument, the InterpolatingFunction object \
can interpolate to find an approximation to the value you want. ", 
    "synonyms" -> {"3.8.3"}, "title" -> 
    "Approximate Functions and Interpolation", "type" -> "Tutorial", "uri" -> 
    "tutorial/ApproximateFunctionsAndInterpolation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.8.3"->{
  Cell[2145, 65, 102, 2, 70, "Title",
   CellTags->{"S3.8.3", "3.1"},
   CellID->24050]},
 "3.1"->{
  Cell[2145, 65, 102, 2, 70, "Title",
   CellTags->{"S3.8.3", "3.1"},
   CellID->24050]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.8.3", 50312, 1666},
 {"3.1", 50412, 1670}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1520, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2145, 65, 102, 2, 70, "Title",
 CellTags->{"S3.8.3", "3.1"},
 CellID->24050],
Cell[2250, 69, 966, 23, 70, "Text",
 CellID->24155],
Cell[3219, 94, 763, 21, 70, "Text",
 CellID->31361],
Cell[3985, 117, 763, 17, 70, "Text",
 CellID->15264],
Cell[4751, 136, 1679, 52, 70, "DefinitionBox",
 CellID->11903],
Cell[6433, 190, 70, 1, 70, "Caption",
 CellID->3676],
Cell[6506, 193, 91, 1, 70, "MathCaption",
 CellID->29643],
Cell[CellGroupData[{
Cell[6622, 198, 274, 9, 28, "Input",
 CellID->26909],
Cell[6899, 209, 889, 25, 54, "Output",
 CellID->234779472]
}, Open  ]],
Cell[7803, 237, 117, 3, 70, "MathCaption",
 CellID->3561],
Cell[CellGroupData[{
Cell[7945, 244, 130, 4, 70, "Input",
 CellID->28489],
Cell[8078, 250, 358, 13, 36, "Output",
 CellID->8489091]
}, Open  ]],
Cell[8451, 266, 126, 4, 70, "MathCaption",
 CellID->1282],
Cell[CellGroupData[{
Cell[8602, 274, 98, 3, 70, "Input",
 CellID->13653],
Cell[8703, 279, 177, 5, 36, "Output",
 CellID->148085629]
}, Open  ]],
Cell[8895, 287, 108, 3, 70, "MathCaption",
 CellID->2220],
Cell[CellGroupData[{
Cell[9028, 294, 96, 3, 70, "Input",
 CellID->5402],
Cell[9127, 299, 176, 5, 36, "Output",
 CellID->79547437]
}, Open  ]],
Cell[9318, 307, 137, 4, 70, "MathCaption",
 CellID->3831],
Cell[CellGroupData[{
Cell[9480, 315, 97, 3, 70, "Input",
 CellID->19369],
Cell[9580, 320, 176, 5, 36, "Output",
 CellID->59348543]
}, Open  ]],
Cell[9771, 328, 293, 7, 70, "Text",
 CellID->20259],
Cell[10067, 337, 146, 4, 70, "MathCaption",
 CellID->19008],
Cell[CellGroupData[{
Cell[10238, 345, 95, 3, 70, "Input",
 CellID->22619],
Cell[10336, 350, 395, 14, 36, "Output",
 CellID->214787982]
}, Open  ]],
Cell[10746, 367, 99, 2, 70, "MathCaption",
 CellID->30003],
Cell[CellGroupData[{
Cell[10870, 373, 267, 9, 70, "Input",
 CellID->21945],
Cell[11140, 384, 176, 5, 36, "Output",
 CellID->150179995]
}, Open  ]],
Cell[11331, 392, 111, 3, 70, "MathCaption",
 CellID->26504],
Cell[CellGroupData[{
Cell[11467, 399, 267, 9, 70, "Input",
 CellID->12392],
Cell[11737, 410, 176, 5, 36, "Output",
 CellID->137737915]
}, Open  ]],
Cell[11928, 418, 146, 4, 70, "MathCaption",
 CellID->25313],
Cell[CellGroupData[{
Cell[12099, 426, 208, 7, 28, "Input",
 CellID->6698],
Cell[12310, 435, 2303, 42, 140, "Output",
 Evaluatable->False,
 CellID->330872765]
}, Open  ]],
Cell[14628, 480, 221, 6, 70, "Text",
 CellID->12722],
Cell[14852, 488, 233, 8, 70, "MathCaption",
 CellID->5938],
Cell[CellGroupData[{
Cell[15110, 500, 138, 5, 70, "Input",
 CellID->19037],
Cell[15251, 507, 177, 5, 36, "Output",
 CellID->241760024]
}, Open  ]],
Cell[15443, 515, 77, 1, 70, "MathCaption",
 CellID->31461],
Cell[CellGroupData[{
Cell[15545, 520, 148, 5, 70, "Input",
 CellID->6234],
Cell[15696, 527, 177, 5, 36, "Output",
 CellID->385543604]
}, Open  ]],
Cell[15888, 535, 867, 24, 70, "Text",
 CellID->9961],
Cell[16758, 561, 292, 8, 70, "MathCaption",
 CellID->3959],
Cell[CellGroupData[{
Cell[17075, 573, 68, 2, 70, "Input",
 CellID->6493],
Cell[17146, 577, 360, 13, 36, "Output",
 CellID->52513737]
}, Open  ]],
Cell[17521, 593, 214, 6, 70, "MathCaption",
 CellID->25269],
Cell[CellGroupData[{
Cell[17760, 603, 96, 3, 70, "Input",
 CellID->24937],
Cell[17859, 608, 531, 10, 70, "Message",
 CellID->77594541],
Cell[18393, 620, 178, 5, 36, "Output",
 CellID->57989402]
}, Open  ]],
Cell[18586, 628, 343, 8, 70, "Text",
 CellID->14700],
Cell[18932, 638, 1321, 41, 70, "DefinitionBox",
 CellID->13971],
Cell[20256, 681, 106, 3, 70, "Caption",
 CellID->26264],
Cell[20365, 686, 136, 4, 70, "MathCaption",
 CellID->104428578],
Cell[CellGroupData[{
Cell[20526, 694, 435, 14, 70, "Input",
 CellID->224781264],
Cell[20964, 710, 361, 13, 36, "Output",
 CellID->173431074]
}, Open  ]],
Cell[21340, 726, 137, 4, 70, "MathCaption",
 CellID->274287925],
Cell[CellGroupData[{
Cell[21502, 734, 143, 5, 70, "Input",
 CellID->394062372],
Cell[21648, 741, 177, 5, 36, "Output",
 CellID->292083173]
}, Open  ]],
Cell[21840, 749, 688, 21, 70, "Text",
 CellID->15117],
Cell[22531, 772, 92, 1, 70, "MathCaption",
 CellID->16215],
Cell[22626, 775, 318, 11, 70, "Input",
 CellID->24555],
Cell[22947, 788, 145, 4, 70, "MathCaption",
 CellID->7815],
Cell[CellGroupData[{
Cell[23117, 796, 173, 5, 70, "Input",
 CellID->18330],
Cell[23293, 803, 356, 13, 36, "Output",
 CellID->37159040]
}, Open  ]],
Cell[23664, 819, 134, 4, 70, "MathCaption",
 CellID->30212],
Cell[CellGroupData[{
Cell[23823, 827, 208, 7, 28, "Input",
 CellID->29288],
Cell[24034, 836, 2483, 45, 129, "Output",
 Evaluatable->False,
 CellID->511217596]
}, Open  ]],
Cell[26532, 884, 308, 10, 70, "MathCaption",
 CellID->1954],
Cell[CellGroupData[{
Cell[26865, 898, 294, 10, 28, "Input",
 CellID->16085],
Cell[27162, 910, 2490, 45, 129, "Output",
 Evaluatable->False,
 CellID->10247961]
}, Open  ]],
Cell[29667, 958, 349, 9, 70, "Text",
 CellID->24484],
Cell[30019, 969, 3055, 98, 70, "DefinitionBox",
 CellID->24774],
Cell[33077, 1069, 81, 1, 70, "Caption",
 CellID->8380],
Cell[33161, 1072, 110, 3, 70, "MathCaption",
 CellID->29815],
Cell[CellGroupData[{
Cell[33296, 1079, 416, 14, 70, "Input",
 CellID->25951],
Cell[33715, 1095, 454, 17, 36, "Output",
 CellID->107833850]
}, Open  ]],
Cell[34184, 1115, 83, 1, 70, "MathCaption",
 CellID->18115],
Cell[CellGroupData[{
Cell[34292, 1120, 120, 4, 70, "Input",
 CellID->1679],
Cell[34415, 1126, 180, 5, 36, "Output",
 CellID->541949473]
}, Open  ]],
Cell[34610, 1134, 72, 1, 70, "MathCaption",
 CellID->25898],
Cell[34685, 1137, 477, 16, 70, "Input",
 CellID->23073],
Cell[35165, 1155, 183, 6, 70, "MathCaption",
 CellID->788],
Cell[CellGroupData[{
Cell[35373, 1165, 298, 10, 70, "Input",
 CellID->23977],
Cell[35674, 1177, 455, 17, 36, "Output",
 CellID->38309847]
}, Open  ]],
Cell[36144, 1197, 458, 12, 70, "Text",
 CellID->29956],
Cell[36605, 1211, 100, 3, 70, "MathCaption",
 CellID->28689],
Cell[36708, 1216, 400, 14, 70, "Input",
 CellID->26113],
Cell[37111, 1232, 249, 8, 70, "MathCaption",
 CellID->10008],
Cell[CellGroupData[{
Cell[37385, 1244, 133, 4, 70, "Input",
 CellID->12941],
Cell[37521, 1250, 176, 5, 36, "Output",
 CellID->106048623]
}, Open  ]],
Cell[37712, 1258, 207, 6, 70, "Text",
 CellID->1723],
Cell[37922, 1266, 347, 12, 70, "MathCaption",
 CellID->21363],
Cell[CellGroupData[{
Cell[38294, 1282, 264, 8, 70, "Input",
 CellID->28],
Cell[38561, 1292, 356, 13, 36, "Output",
 CellID->57655233]
}, Open  ]],
Cell[38932, 1308, 119, 3, 70, "MathCaption",
 CellID->24778],
Cell[CellGroupData[{
Cell[39076, 1315, 129, 4, 70, "Input",
 CellID->7200],
Cell[39208, 1321, 301, 8, 36, "Output",
 CellID->425584721]
}, Open  ]],
Cell[39524, 1332, 323, 10, 70, "MathCaption",
 CellID->1885],
Cell[CellGroupData[{
Cell[39872, 1346, 130, 4, 70, "Input",
 CellID->21974],
Cell[40005, 1352, 246, 7, 36, "Output",
 CellID->150359362]
}, Open  ]],
Cell[40266, 1362, 753, 22, 70, "Text",
 CellID->11333],
Cell[41022, 1386, 261, 8, 70, "MathCaption",
 CellID->22867],
Cell[CellGroupData[{
Cell[41308, 1398, 278, 9, 70, "Input",
 CellID->26153],
Cell[41589, 1409, 361, 13, 36, "Output",
 CellID->214754231]
}, Open  ]],
Cell[41965, 1425, 237, 8, 70, "MathCaption",
 CellID->32168],
Cell[CellGroupData[{
Cell[42227, 1437, 219, 6, 70, "Input",
 CellID->20825],
Cell[42449, 1445, 357, 13, 36, "Output",
 CellID->224220010]
}, Open  ]],
Cell[42821, 1461, 258, 8, 70, "MathCaption",
 CellID->15629],
Cell[CellGroupData[{
Cell[43104, 1473, 346, 11, 70, "Input",
 CellID->28650],
Cell[43453, 1486, 468, 17, 36, "Output",
 CellID->23114285]
}, Open  ]],
Cell[43936, 1506, 2022, 64, 70, "DefinitionBox",
 CellID->3309],
Cell[45961, 1572, 104, 3, 70, "Caption",
 CellID->4693],
Cell[CellGroupData[{
Cell[46090, 1579, 72, 1, 70, "RelatedTutorialsSection",
 CellID->187248265],
Cell[46165, 1582, 183, 4, 70, "RelatedTutorials",
 CellID->618122]
}, Open  ]]
}, Open  ]],
Cell[46375, 1590, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

