(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14584,        494]
NotebookOptionsPosition[      9695,        352]
NotebookOutlinePosition[     12740,        427]
CellTagsIndexPosition[     12649,        421]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalCalculationsOverview"], 
          "Arbitrary\[Hyphen]Precision Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ArbitraryPrecisionNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Numerical Calculations\"\>", 
       2->"\<\"Arbitrary\[Hyphen]Precision Numbers\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Evaluation & Precision\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"N" :> Documentation`HelpLookup["paclet:ref/N"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"N\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Arbitrary\[Hyphen]Precision Calculations\
\>", "Title",
 CellTags->{"S1.1.4", "4.1"},
 CellID->4686],

Cell[TextData[{
 "When you use ",
 Cell[BoxData[
  RowBox[{"//", 
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"]}]], "InlineFormula"],
 " to get a numerical result, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does what a standard calculator would do: it gives you a result to a fixed \
number of significant figures. You can also tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " exactly how many significant figures to keep in a particular calculation. \
This allows you to get numerical results in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to any degree of precision. "
}], "Text",
 CellID->30080],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], "//", 
     ButtonBox["N",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/N"], Cell["  or  ", "TableText"], 
     ButtonBox["N",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/N"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "approximate numerical value of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["N",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/N"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "numerical value of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " calculated with ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     "\[Hyphen]digit precision"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10116],

Cell["Numerical evaluation functions. ", "Caption",
 CellID->12249],

Cell[TextData[{
 "This gives the numerical value of ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 " to a fixed number of significant digits. Typing ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   ButtonBox["Pi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pi"], "]"}]], "InlineFormula"],
 " is exactly equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Pi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pi"], "//", 
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"]}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1528],

Cell[BoxData["3.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->715113991]
}, Open  ]],

Cell[TextData[{
 "This gives ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 " to 40 digits. "
}], "MathCaption",
 CellID->7864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", ",", "40"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29421],

Cell[BoxData["3.1415926535897932384626433832795028841971676788548462879281`40.\
"], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7035684]
}, Open  ]],

Cell[TextData[{
 "Here is ",
 Cell[BoxData[
  FormBox[
   SqrtBox["7"], TraditionalForm]], "InlineMath"],
 " to 30 digits. "
}], "MathCaption",
 CellID->8826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "7", "]"}], ",", "30"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6816],

Cell[BoxData["2.645751311064590590501615753639260425710259183082`30."], \
"Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->112419568]
}, Open  ]],

Cell["\<\
Doing any kind of numerical calculation can introduce small roundoff errors \
into your results. When you increase the numerical precision, these errors \
typically become correspondingly smaller. Making sure that you get the same \
answer when you increase numerical precision is often a good way to check \
your results. \
\>", "Text",
 CellID->27726],

Cell[TextData[{
 "The quantity ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["e", 
    RowBox[{"\[Pi]", 
     SqrtBox["163"]}]], TraditionalForm]], "InlineMath"],
 " turns out to be very close to an integer. To check that the result is not, \
in fact, an integer, you have to use sufficient numerical precision. "
}], "MathCaption",
 CellID->28666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Pi", " ", 
     RowBox[{"Sqrt", "[", "163", "]"}]}], "]"}], ",", "40"}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->29087],

Cell[BoxData["2.6253741264076874399999999999925007259719241875736454579`40.*^\
17"], "Output",
 ImageSize->{327, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->100080587]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->57209610],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumericalEvaluationAndPrecision"]], "TutorialMoreAbout",
 CellID->171830946]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->411062804],

Cell[TextData[ButtonBox["Numerical Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalCalculationsOverview"]], "RelatedTutorials",
 CellID->21356267],

Cell[TextData[ButtonBox["Arbitrary\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ArbitraryPrecisionNumbers"]], "RelatedTutorials",\

 CellID->43529248]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->116138464],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->463407413],

Cell[TextData[{
 ButtonBox["M185: Numerical Computation in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m185.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m185.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->8054999]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Arbitrary-Precision Calculations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/NumericalCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SomeMathematicalFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ComplexNumbers"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 49.6231006}", "context" -> "", 
    "keywords" -> {
     "accuracy", "arbitrary precision", "big numbers", "decimal places", 
      "digits", "long numbers", "N", "number precision", "roundoff errors", 
      "significant digits", "significant figures"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "When you use //N to get a numerical result, Mathematica does what a \
standard calculator would do: it gives you a result to a fixed number of \
significant figures. You can also tell Mathematica exactly how many \
significant figures to keep in a particular calculation. This allows you to \
get numerical results in Mathematica to any degree of precision. Numerical \
evaluation functions. This gives the numerical value of \\[Pi] to a fixed \
number of significant digits. Typing N[Pi] is exactly equivalent to Pi//N. ", 
    "synonyms" -> {"1.1.4"}, "title" -> "Arbitrary-Precision Calculations", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/ArbitraryPrecisionCalculations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.1.4"->{
  Cell[2602, 77, 110, 4, 70, "Title",
   CellTags->{"S1.1.4", "4.1"},
   CellID->4686]},
 "4.1"->{
  Cell[2602, 77, 110, 4, 70, "Title",
   CellTags->{"S1.1.4", "4.1"},
   CellID->4686]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.1.4", 12438, 410},
 {"4.1", 12537, 414}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1977, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2602, 77, 110, 4, 70, "Title",
 CellTags->{"S1.1.4", "4.1"},
 CellID->4686],
Cell[2715, 83, 659, 20, 70, "Text",
 CellID->30080],
Cell[3377, 105, 1204, 38, 70, "DefinitionBox",
 CellID->10116],
Cell[4584, 145, 67, 1, 70, "Caption",
 CellID->12249],
Cell[4654, 148, 660, 24, 70, "MathCaption",
 CellID->26667],
Cell[CellGroupData[{
Cell[5339, 176, 93, 3, 28, "Input",
 CellID->1528],
Cell[5435, 181, 175, 5, 36, "Output",
 CellID->715113991]
}, Open  ]],
Cell[5625, 189, 152, 6, 70, "MathCaption",
 CellID->7864],
Cell[CellGroupData[{
Cell[5802, 199, 118, 4, 28, "Input",
 CellID->29421],
Cell[5923, 205, 222, 6, 36, "Output",
 CellID->7035684]
}, Open  ]],
Cell[6160, 214, 158, 7, 70, "MathCaption",
 CellID->8826],
Cell[CellGroupData[{
Cell[6343, 225, 148, 5, 70, "Input",
 CellID->6816],
Cell[6494, 232, 214, 6, 36, "Output",
 CellID->112419568]
}, Open  ]],
Cell[6723, 241, 363, 7, 70, "Text",
 CellID->27726],
Cell[7089, 250, 349, 10, 70, "MathCaption",
 CellID->28666],
Cell[CellGroupData[{
Cell[7463, 264, 212, 8, 70, "Input",
 CellID->29087],
Cell[7678, 274, 225, 6, 36, "Output",
 CellID->100080587]
}, Open  ]],
Cell[CellGroupData[{
Cell[7940, 285, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->57209610],
Cell[8008, 288, 186, 4, 70, "TutorialMoreAbout",
 CellID->171830946]
}, Open  ]],
Cell[CellGroupData[{
Cell[8231, 297, 72, 1, 70, "RelatedTutorialsSection",
 CellID->411062804],
Cell[8306, 300, 175, 4, 70, "RelatedTutorials",
 CellID->21356267],
Cell[8484, 306, 183, 4, 70, "RelatedTutorials",
 CellID->43529248]
}, Open  ]],
Cell[CellGroupData[{
Cell[8704, 315, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->116138464],
Cell[8805, 318, 414, 13, 70, "TutorialRelatedLinks",
 CellID->463407413],
Cell[9222, 333, 419, 13, 70, "TutorialRelatedLinks",
 CellID->8054999]
}, Open  ]]
}, Open  ]],
Cell[9668, 350, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

