(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12496,        405]
NotebookOptionsPosition[      8299,        288]
NotebookOutlinePosition[     11385,        364]
CellTagsIndexPosition[     11292,        358]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modularity and the Naming of Things" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"], 
          "Mathematica Packages" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaPackages"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Modularity and the Naming of Things\"\>", 
       2->"\<\"Mathematica Packages\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeclarePackage" :> 
          Documentation`HelpLookup["paclet:ref/DeclarePackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"DeclarePackage\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Automatic Loading of Packages", "Title",
 CellTags->{"S2.7.11", "11.1"},
 CellID->7833],

Cell[TextData[{
 "Previous sections have discussed explicit loading of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages using ",
 Cell[BoxData[
  RowBox[{"<<", 
   StyleBox["package", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Needs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Needs"], "[", 
   StyleBox["package", "TI"], "]"}]], "InlineFormula"],
 ". Sometimes, however, you may want to set ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " up so that it automatically loads a particular package when the package is \
needed. "
}], "Text",
 CellID->8360],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["DeclarePackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeclarePackage"]], "InlineFormula"],
 " to give the names of symbols which are defined in a particular package. \
Then, when one of these symbols is actually used, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically load the package where the symbol is defined. "
}], "Text",
 CellID->13330],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DeclarePackage",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DeclarePackage"], "[", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"context`\", \"TI\"]\)\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"name\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"name\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "declare that a package should automatically be loaded if a symbol with \
any of the names ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["name", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is used "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->110948108],

Cell["Arranging for automatic loading of packages. ", "Caption",
 CellID->8928],

Cell[TextData[{
 "This specifies that the symbols ",
 Cell[BoxData[
  ButtonBox["Div",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Div"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Grad",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Grad"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Curl",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Curl"]], "InlineFormula"],
 " are defined in ",
 Cell[BoxData[
  ButtonBox["VectorAnalysis`",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/guide/VectorAnalysisPackage"]], 
  "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclarePackage", "[", 
  RowBox[{"\"\<VectorAnalysis`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Div\>\"", ",", "\"\<Grad\>\"", ",", "\"\<Curl\>\""}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12433],

Cell[BoxData["\<\"VectorAnalysis`\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->402072398]
}, Open  ]],

Cell[TextData[{
 "When you first use ",
 Cell[BoxData[
  ButtonBox["Grad",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Grad"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically loads the package that defines it. "
}], "MathCaption",
 CellID->6766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grad", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"Cartesian", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1735],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "x"}], ",", 
   RowBox[{"2", " ", "y"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->152214016]
}, Open  ]],

Cell[TextData[{
 "When you set up a large collection of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages, it is often a good idea to create an additional \
\[OpenCurlyDoubleQuote]names file\[CloseCurlyDoubleQuote] which contains a \
sequence of ",
 Cell[BoxData[
  ButtonBox["DeclarePackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeclarePackage"]], "InlineFormula"],
 " commands, specifying packages to load when particular names are used. \
Within a particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you then need to load explicitly only the names file. When you \
have done this, all the other packages will automatically be loaded if and \
when they are needed. "
}], "Text",
 CellID->11599],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DeclarePackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeclarePackage"]], "InlineFormula"],
 " works by immediately creating symbols with the names you specify, but \
giving each of these symbols the special attribute ",
 Cell[BoxData[
  ButtonBox["Stub",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stub"]], "InlineFormula"],
 ". Whenever ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " finds a symbol with the ",
 Cell[BoxData[
  ButtonBox["Stub",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stub"]], "InlineFormula"],
 " attribute, it automatically loads the package corresponding to the context \
of the symbol, in an attempt to find the definition of the symbol."
}], "Text",
 CellID->11837],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->5805711],

Cell[TextData[ButtonBox["Modularity and the Naming of Things",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], \
"RelatedTutorials",
 CellID->405226890],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"]
}], "RelatedTutorials",
 CellID->369732296]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Automatic Loading of Packages - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Modularity and the Naming of Things", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SettingUpMathematicaPackages"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 54.1857174}", "context" -> "", 
    "keywords" -> {
     "autoloading", "DeclarePackage", "declare package", "files", 
      "index files", "InstallWizard", "loading of packages", "names files", 
      "Stub", "package symbols"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Previous sections have discussed explicit loading of Mathematica \
packages using <<package and Needs[package]. Sometimes, however, you may want \
to set Mathematica up so that it automatically loads a particular package \
when the package is needed. You can use DeclarePackage to give the names of \
symbols which are defined in a particular package. Then, when one of these \
symbols is actually used, Mathematica will automatically load the package \
where the symbol is defined. Arranging for automatic loading of packages. ", 
    "synonyms" -> {"2.7.11"}, "title" -> "Automatic Loading of Packages", 
    "type" -> "Tutorial", "uri" -> "tutorial/AutomaticLoadingOfPackages"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.7.11"->{
  Cell[2032, 62, 93, 2, 70, "Title",
   CellTags->{"S2.7.11", "11.1"},
   CellID->7833]},
 "11.1"->{
  Cell[2032, 62, 93, 2, 70, "Title",
   CellTags->{"S2.7.11", "11.1"},
   CellID->7833]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.7.11", 11078, 347},
 {"11.1", 11179, 351}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1407, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2032, 62, 93, 2, 70, "Title",
 CellTags->{"S2.7.11", "11.1"},
 CellID->7833],
Cell[2128, 66, 619, 21, 70, "Text",
 CellID->8360],
Cell[2750, 89, 440, 12, 70, "Text",
 CellID->13330],
Cell[3193, 103, 844, 25, 70, "DefinitionBox",
 CellID->110948108],
Cell[4040, 130, 79, 1, 70, "Caption",
 CellID->8928],
Cell[4122, 133, 666, 24, 70, "MathCaption",
 CellID->29492],
Cell[CellGroupData[{
Cell[4813, 161, 247, 7, 28, "Input",
 CellID->12433],
Cell[5063, 170, 181, 5, 36, "Output",
 CellID->402072398]
}, Open  ]],
Cell[5259, 178, 309, 11, 70, "MathCaption",
 CellID->6766],
Cell[CellGroupData[{
Cell[5593, 193, 264, 9, 28, "Input",
 CellID->1735],
Cell[5860, 204, 261, 9, 36, "Output",
 CellID->152214016]
}, Open  ]],
Cell[6136, 216, 746, 19, 70, "Text",
 CellID->11599],
Cell[6885, 237, 768, 22, 70, "Text",
 CellID->11837],
Cell[CellGroupData[{
Cell[7678, 263, 70, 1, 70, "RelatedTutorialsSection",
 CellID->5805711],
Cell[7751, 266, 200, 5, 70, "RelatedTutorials",
 CellID->405226890],
Cell[7954, 273, 291, 9, 70, "RelatedTutorials",
 CellID->369732296]
}, Open  ]]
}, Open  ]],
Cell[8272, 286, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

