(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32152,        833]
NotebookOptionsPosition[     27753,        694]
NotebookOutlinePosition[     30129,        758]
CellTagsIndexPosition[     30038,        752]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Graphics and Sound\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plot" :> Documentation`HelpLookup["paclet:ref/Plot"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Plot\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Basic Plotting", "Title",
 CellTags->{"S1.9.1", "1.1"},
 CellID->20136],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Plot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plot"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[TextData[{
     "plot ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " as a function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Plot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plot"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["0", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["k", "TI"]]}], "}"}]}], "]"}], Cell[TextData[{
     "plot ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " over a series of segments, potentially breaking the curve at each of \
the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Plot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plot"], "[", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell["plot several functions together", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4680],

Cell["Basic plotting functions. ", "Caption",
 CellID->9198],

Cell[TextData[{
 "This plots a graph of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " as a function of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " from 0 to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->27032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14387],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244173267]
}, Open  ]],

Cell[TextData[{
 "You can plot functions that have singularities. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will try to choose appropriate scales. "
}], "MathCaption",
 CellID->7240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3517],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56392096]
}, Open  ]],

Cell["\<\
The singularities can be omitted from the plot by specifying them in the \
plot's range. \
\>", "MathCaption",
 CellID->508645102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}], ",", 
     RowBox[{"Pi", "/", "2"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->5640261],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->102858840]
}, Open  ]],

Cell["\<\
You can give a list of functions to plot. A different color will \
automatically be used for each function.\
\>", "MathCaption",
 CellID->8670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "x"}], "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->241],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->4972641]
}, Open  ]],

Cell[TextData[{
 "This finds the numerical solution to a differential equation, as discussed \
in ",
 ButtonBox["Numerical Differential Equations",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NumericalDifferentialEquations"],
 ". "
}], "MathCaption",
 CellID->9916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"Sin", "[", 
       RowBox[{"y", "[", "x", "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->15678],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "4.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->445499047]
}, Open  ]],

Cell["Here is a plot of the solution.", "MathCaption",
 CellID->13579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", "%"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->25058],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzHdQ03cYBvAkZPwEIQaNGBQ5IFYoeKByiCh9X0VPC4oF5KolYJWhaNko
iCOyLMiykgItKiP2HGyTWKqACHGcWIZaJxDLMWRUohAiM/36x3vPfe6e57U4
EOEdzKDRaJ7kvqR78PuOxsGj3wxGRRrTaGpguplGqgS7QcIvH3BhqmFtUcFF
mSAIcuv+Cj9GqcHj75c3LwliobRvV+noAjV8H6StvyBIgRZX6cUhCzV02f/s
liWQQP6lhBrGFjUU83edPSe4Au5i82W309SQSMlWpgvkYPhrTJTLoo+wZ29J
lfqjEmA8qaHa4xMY6BJF25a3AfOj20hR/Bis8PrwvjnjOZTK/OVtV8chrnU9
FIy/hsBk11UmnzVgIud10+kqeMWL22qwTgu3etyetG3sgUevn9LmSz5D0+FL
S/eO9MJoSW6yfHgSNF+5civCBmBW2bRc33YaGJNlC5auGIKXFas9ahJnwEn3
4y2fyhFob7UT2tfNwpMUx9YHX49CsDWzoXZwDszPD09e/6CGxo5b7W0LaTis
VXX/4/AJuguDEkylNLwydOexUfYY+ESkjfk609HI7Opob+84mPyhanBU0jEz
VBFSLJwAv/Wy0xHIwAks6z0k1oJB7bu3jo0MjF2jlC9u/gwSz9vWbxz0UFWp
zOiwmIKYlurs21I9nD78vNAmYRrqOfs9/AyZaLuJMxdyZwYkzc6mN0KZuK3U
4mCNyRzUt9S+tXvIxDizfZb/inTQkdAgzV7CQrsRX4OXO2nY8ig/Z14gCxdy
1ZRyioa12XyrNZUsZN4trLK6SMdFDjM13qMsPOJ45/U8DwbSPE/o3XdgY9m3
B4obJhiYLFa9Ev7ERs2w6YL+PD18MVZOjylio8Jnm55kCxNPa6NF6qdsFG9P
LZL3M1EV9q4jQMdGiy73V9JUFvru13rcW8lBl3UpEsEasjvWmLn1Ow6KlrdN
0p+x8ZR595LVMRzUPM7qiUzkIL95e6tlHgcLmAGx3kIKH1stCdkg5+DCbkUp
Q0lhsejByfQ2DrJOJe5eHzUPdVrPCdUQB2nXA6p6jPVR4yvAQwwKo3+vyjJu
0seg1OL4IQGF9bZpFC/cAG37nGIt7SnkuUfbJRnNx1+OOroEb6Kwc1X7s+N1
87Fv+h7vqg+F1ZdB2BtgiIED41aiQAr9q5x4ZnOGeNlemfdbFIVnUksSO28Y
oY9npOCNmMKK92aFRju4qCi8oFyWSaEXz8j54RQXc7wjFH4FFJ5jMZZ2EvM3
xi3zJ1ZOambVxPXiE8kBxE49Xc2m01zM5x/32k9sKqvYFU5ccHL7fyHEPbt3
HuTPcLEInYXRxLEFmXmBs6Q/4JeTRlyReeZ4PHGn9agmnbj/TKwoi/js/dOi
DOI9oSLLP4lX83JtsoldXewq9ee4qPuU05xLzO5suV9D7D34ZuIyMbTfvfaA
WNq31r+YOF4py3hLPOWa3lxCPFRe6MXScbGfYXP+CnHrqSNde4ifdG+0uUHM
id7XGEYcXhefU0aMIT7SJOKDE9WacuKbnhtCy4nPiRc3VREPb7bfcY/4Yaub
dQ2xcJ2V/QvilISw7JvEAbYmxsNf/ifljsuI880NNDriawOKHxTE/wOELzmk

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  PlotRange->{{0, 4}, {1.000000068691515, 3.0745646559489224`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->198270694]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->423443257],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "RelatedTutorials",\

 CellID->151800574]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->225221541],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->8535635],

Cell[TextData[ButtonBox["M205: Visualization and Dynamic Interactivity",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://www.wolfram.com/services/education/minicourses/m205.html"], 
   None}]], "TutorialRelatedLinks",
 CellID->1618417]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Basic Plotting - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Graphics and Sound", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/GraphicsAndSoundOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Options"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 57.1857942}", "context" -> "", 
    "keywords" -> {
     "curves", "differential equations", "Evaluate", "evaluation", 
      "functions", "graphics", "lists of functions", "multiple functions", 
      "output", "phase plots", "plot", "plots", "singularities"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Basic plotting functions. This plots a graph of sin(x) as a function of \
x from 0 to 2\\[Pi]. You can plot functions that have singularities. \
Mathematica will try to choose appropriate scales. ", "synonyms" -> {"1.9.1"},
     "title" -> "Basic Plotting", "type" -> "Tutorial", "uri" -> 
    "tutorial/BasicPlotting"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.9.1"->{
  Cell[1778, 57, 77, 2, 70, "Title",
   CellTags->{"S1.9.1", "1.1"},
   CellID->20136]},
 "1.1"->{
  Cell[1778, 57, 77, 2, 70, "Title",
   CellTags->{"S1.9.1", "1.1"},
   CellID->20136]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.9.1", 29827, 741},
 {"1.1", 29926, 745}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1153, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1778, 57, 77, 2, 70, "Title",
 CellTags->{"S1.9.1", "1.1"},
 CellID->20136],
Cell[1858, 61, 2750, 90, 70, "DefinitionBox",
 CellID->4680],
Cell[4611, 153, 60, 1, 70, "Caption",
 CellID->9198],
Cell[4674, 156, 367, 14, 70, "MathCaption",
 CellID->27032],
Cell[CellGroupData[{
Cell[5066, 174, 231, 8, 28, "Input",
 CellID->14387],
Cell[5300, 184, 2494, 45, 128, "Output",
 Evaluatable->False,
 CellID->244173267]
}, Open  ]],
Cell[7809, 232, 195, 6, 70, "MathCaption",
 CellID->7240],
Cell[CellGroupData[{
Cell[8029, 242, 229, 8, 28, "Input",
 CellID->3517],
Cell[8261, 252, 3107, 55, 131, "Output",
 Evaluatable->False,
 CellID->56392096]
}, Open  ]],
Cell[11383, 310, 140, 4, 70, "MathCaption",
 CellID->508645102],
Cell[CellGroupData[{
Cell[11548, 318, 329, 11, 28, "Input",
 CellID->5640261],
Cell[11880, 331, 2816, 50, 131, "Output",
 Evaluatable->False,
 CellID->102858840]
}, Open  ]],
Cell[14711, 384, 153, 4, 70, "MathCaption",
 CellID->8670],
Cell[CellGroupData[{
Cell[14889, 392, 400, 14, 28, "Input",
 CellID->241],
Cell[15292, 408, 7612, 129, 128, "Output",
 Evaluatable->False,
 CellID->4972641]
}, Open  ]],
Cell[22919, 540, 273, 8, 70, "MathCaption",
 CellID->9916],
Cell[CellGroupData[{
Cell[23217, 552, 449, 15, 70, "Input",
 CellID->15678],
Cell[23669, 569, 467, 17, 36, "Output",
 CellID->445499047]
}, Open  ]],
Cell[24151, 589, 70, 1, 70, "MathCaption",
 CellID->13579],
Cell[CellGroupData[{
Cell[24246, 594, 234, 8, 70, "Input",
 CellID->25058],
Cell[24483, 604, 2143, 44, 138, "Output",
 CellID->198270694]
}, Open  ]],
Cell[CellGroupData[{
Cell[26663, 653, 72, 1, 70, "RelatedTutorialsSection",
 CellID->423443257],
Cell[26738, 656, 166, 4, 70, "RelatedTutorials",
 CellID->151800574]
}, Open  ]],
Cell[CellGroupData[{
Cell[26941, 665, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->225221541],
Cell[27042, 668, 412, 13, 70, "TutorialRelatedLinks",
 CellID->8535635],
Cell[27457, 683, 242, 5, 70, "TutorialRelatedLinks",
 CellID->1618417]
}, Open  ]]
}, Open  ]],
Cell[27726, 692, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

