(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26033,        887]
NotebookOptionsPosition[     21371,        751]
NotebookOutlinePosition[     24281,        824]
CellTagsIndexPosition[     24190,        818]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Data" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnDataOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Operations on Data\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Max" :> Documentation`HelpLookup["paclet:ref/Max"], "Mean" :> 
          Documentation`HelpLookup["paclet:ref/Mean"], "Median" :> 
          Documentation`HelpLookup["paclet:ref/Median"], "Quantile" :> 
          Documentation`HelpLookup["paclet:ref/Quantile"], 
          "StandardDeviation" :> 
          Documentation`HelpLookup["paclet:ref/StandardDeviation"], "Total" :> 
          Documentation`HelpLookup["paclet:ref/Total"], "Variance" :> 
          Documentation`HelpLookup["paclet:ref/Variance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Max\"\>", 2->"\<\"Mean\"\>", 
       3->"\<\"Median\"\>", 4->"\<\"Quantile\"\>", 
       5->"\<\"StandardDeviation\"\>", 6->"\<\"Total\"\>", 
       7->"\<\"Variance\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Basic Statistics", "Title",
 CellTags->{"S3.8.1", "1.1"},
 CellID->23729],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Mean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mean"], "[", 
     StyleBox["list", "TI"], "]"}], Cell["mean (average)", "TableText"]},
   {
    RowBox[{
     ButtonBox["Median",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Median"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "median (central value)", "TableText"]},
   {
    RowBox[{
     ButtonBox["Max",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Max"], "[", 
     StyleBox["list", "TI"], "]"}], Cell["maximum value", "TableText"]},
   {
    RowBox[{
     ButtonBox["Variance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Variance"], "[", 
     StyleBox["list", "TI"], "]"}], Cell["variance", "TableText"]},
   {
    RowBox[{
     ButtonBox["StandardDeviation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StandardDeviation"], "[", 
     StyleBox["list", "TI"], "]"}], Cell["standard deviation", "TableText"]},
   {
    RowBox[{
     ButtonBox["Quantile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quantile"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["q", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " quantile"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Total",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Total"], "[", 
     StyleBox["list", "TI"], "]"}], Cell["total", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, False, False, {True}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24081],

Cell["Basic descriptive statistics operations. ", "Caption",
 CellID->2995],

Cell[TextData[{
 "Given a list with ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " elements ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 ", the ",
 StyleBox["mean",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Mu]", "(", "x", ")"}], "=", 
    RowBox[{
     OverscriptBox["x", "_"], "=", 
     RowBox[{"\[Sum]", 
      RowBox[{
       SubscriptBox["x", "i"], "/", "n"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->2678],

Cell[TextData[{
 "The ",
 StyleBox["variance",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"var", "(", "x", ")"}], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Sigma]", "2"], "(", "x", ")"}], "=", 
     RowBox[{"\[Sum]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["x", "i"], "-", 
          RowBox[{"\[Mu]", "(", "x", ")"}]}], ")"}], "2"], "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", for real data. (For complex data ",
 Cell[BoxData[
  FormBox[
   RowBox[{"var", 
    RowBox[{
     RowBox[{"(", "x", ")"}], "=", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Sigma]", "2"], "(", "x", ")"}], "=", 
      RowBox[{"\[Sum]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["x", "i"], "-", 
          RowBox[{"\[Mu]", "(", "x", ")"}]}], ")"}], 
        RowBox[{
         RowBox[{"(", 
          OverscriptBox[
           RowBox[{
            SubscriptBox["x", "i"], "-", 
            RowBox[{"\[Mu]", "(", "x", ")"}]}], "_"], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ".) "
}], "Text",
 CellID->24676],

Cell[TextData[{
 "The ",
 StyleBox["standard deviation",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StandardDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardDeviation"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Sigma]", "(", "x", ")"}], "=", 
    SqrtBox[
     RowBox[{"var", "(", "x", ")"}]]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->27753],

Cell[TextData[{
 "If the elements in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " are thought of as being selected at random according to some probability \
distribution, then the mean gives an estimate of where the center of the \
distribution is located, while the standard deviation gives an estimate of \
how wide the dispersion in the distribution is. "
}], "Text",
 CellID->20899],

Cell[TextData[{
 "The ",
 StyleBox["median",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " effectively gives the value at the halfway point in the sorted version of \
",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". It is often considered a more robust measure of the center of a \
distribution than the mean, since it depends less on outlying values."
}], "Text",
 CellID->11784],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " ",
 StyleBox["quantile",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " effectively gives the value that is ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " of the way through the sorted version of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15565],

Cell[TextData[{
 "For a list of length ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " defines ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " to be ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     ButtonBox["Ceiling",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ceiling"], "[", 
     RowBox[{
      StyleBox["n", "TI"], " ", 
      StyleBox["q", "TI"]}], "]"}], "]"}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    ButtonBox["Less",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Less"]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->3093],

Cell[TextData[{
 "There are, however, about ten other definitions of quantile in use, all \
potentially giving slightly different results. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " covers the common cases by introducing four ",
 StyleBox["quantile parameters",
  FontSlant->"Italic"],
 " in the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["q", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["d", "TI"]}], "}"}]}], "}"}]}], "]"}]], "InlineFormula"],
 ". The parameters ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " in effect define where in the list should be considered a fraction ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " of the way through. If this corresponds to an integer position, then the \
element at that position is taken to be the ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile. If it is not an integer position, then a linear combination of \
the elements on either side is used, as specified by ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->13608],

Cell[TextData[{
 "The position in a sorted list ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 " for the ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile is taken to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "=", "a", "+", 
    RowBox[{"(", 
     RowBox[{"n", "+", "b"}], ")"}], " ", "q"}], TraditionalForm]], 
  "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " is an integer, then the quantile is ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["s", "k"], TraditionalForm]], "InlineMath"],
 ". Otherwise, it is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["s", 
     RowBox[{"\[LeftFloor]", "k", "\[RightFloor]"}]], "+", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["s", 
       RowBox[{"\[LeftCeiling]", "k", "\[RightCeiling]"}]], "-", 
      SubscriptBox["s", 
       RowBox[{"\[LeftFloor]", "k", "\[RightFloor]"}]]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"c", "+", "d", 
      RowBox[{"(", 
       RowBox[{"k", "-", "\[LeftFloor]", "k", "\[RightFloor]"}], ")"}]}], 
     ")"}]}], TraditionalForm]], "InlineMath"],
 ", with the indices taken to be ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " if they are out of range. "
}], "Text",
 CellID->6172],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", "{", "0", ",", "0", "}", ",", "{", "1", ",", "0", "}", "}"}],
     Cell["inverse empirical CDF (default)", "TableText"]},
   {
    RowBox[{"{", "{", "0", ",", "0", "}", ",", "{", "0", ",", "1", "}", "}"}],
     Cell["linear interpolation (California method)", "TableText"]},
   {
    RowBox[{
    "{", "{", "1", "/", "2", ",", "0", "}", ",", "{", "0", ",", "0", "}", 
     "}"}], Cell[TextData[{
     "element numbered closest to ",
     Cell[BoxData[
      StyleBox["qn", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
    "{", "{", "1", "/", "2", ",", "0", "}", ",", "{", "0", ",", "1", "}", 
     "}"}], Cell["linear interpolation (hydrologist method)", "TableText"]},
   {
    RowBox[{"{", "{", "0", ",", "1", "}", ",", "{", "0", ",", "1", "}", "}"}],
     Cell["\<\
mean\[Hyphen]based estimate (Weibull method)\
\>", "TableText"]},
   {
    RowBox[{
    "{", "{", "1", ",", "-", "1", "}", ",", "{", "0", ",", "1", "}", "}"}], 
    Cell["mode\[Hyphen]based estimate", "TableText"]},
   {
    RowBox[{
    "{", "{", "1", "/", "3", ",", "1", "/", "3", "}", ",", "{", "0", ",", "1",
      "}", "}"}], Cell["median\[Hyphen]based estimate", "TableText"]},
   {
    RowBox[{
    "{", "{", "3", "/", "8", ",", "1", "/", "4", "}", ",", "{", "0", ",", "1",
      "}", "}"}], Cell["normal distribution estimate", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11243],

Cell["Common choices for quantile parameters. ", "Caption",
 CellID->29929],

Cell[TextData[{
 "Whenever ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", the value of the ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile is always equal to some actual element in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ", so that the result changes discontinuously as ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " varies. For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "=", "1"}], TraditionalForm]], "InlineMath"],
 ", the ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile interpolates linearly between successive elements in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 " is defined to use such an interpolation. "
}], "Text",
 CellID->7514],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " yields ",
 StyleBox["quartiles",
  FontWeight->"Bold"],
 " when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "=", "m", "/", "4"}], TraditionalForm]], "InlineMath"],
 " and ",
 StyleBox["percentiles",
  FontWeight->"Bold"],
 " when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "=", "m", "/", "100"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->10168],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Mean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mean"], "[", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "the mean of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Mean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mean"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["1", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["2", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "a list of the means of the ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["i", "TI"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5055],

Cell["Handling multidimensional data. ", "Caption",
 CellID->11191],

Cell[TextData[{
 "Sometimes each item in your data may involve a list of values. The basic \
statistics functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically apply to all corresponding elements in these lists. "
}], "Text",
 CellID->5973],

Cell["\<\
This separately finds the mean of each \[OpenCurlyDoubleQuote]column\
\[CloseCurlyDoubleQuote] of data. \
\>", "MathCaption",
 CellID->8922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x1", ",", "y1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x2", ",", "y2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x3", ",", "y3"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->6748],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"x1", "+", "x2", "+", "x3"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"y1", "+", "y2", "+", "y3"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{220, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->5651]
}, Open  ]],

Cell[TextData[{
 "Note that you can extract the elements in the ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " \[OpenCurlyDoubleQuote]column\[CloseCurlyDoubleQuote] of a \
multidimensional list using ",
 Cell[BoxData[
  RowBox[{
   StyleBox["list", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["i", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->10986],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->410023976],

Cell[TextData[ButtonBox["Numerical Operations on Data",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnDataOverview"]], "RelatedTutorials",
 CellID->618122]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->90610441],

Cell[TextData[{
 ButtonBox["M215: Applied Statistical Analysis with ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m215.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m215.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->437201265]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Basic Statistics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Data", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnDataOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/CurveFitting"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 57.9826896}", "context" -> "", 
    "keywords" -> {
     "Accumulate", "average", "CDF", "central value", "data", "deciles", 
      "dispersion", "Differences", "empirical distribution", "error", 
      "Interpolation", "InterquartileRange", "inverseCDF", "location", "Mean",
       "median", "numerical data", "order statistics", "percentiles", 
      "Quantile", "Quartiles", "robust statistics", "spread", 
      "StandardDeviation", "statistics", "sum of list", "Total", "Variance", 
      "Weibull quantile method"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Basic descriptive statistics operations. Given a list with n elements \
x_i, the mean Mean[list] is defined to be \\[Mu](x)=OverscriptBox[x, \
_]=\\[Sum]x_i/n. The variance Variance[list] is defined to be \
var(x)=\\[Sigma]^2(x)=\\[Sum](x_i-\\[Mu](x))^2/(n-1), for real data. (For \
complex data \
var(x)=\\[Sigma]^2(x)=\\[Sum](x_i-\\[Mu](x))(OverscriptBox[RowBox[{\
SubscriptBox[x, i], -, RowBox[{\\[Mu], (, x, )}]}], _])/(n-1).) ", 
    "synonyms" -> {"3.8.1"}, "title" -> "Basic Statistics", "type" -> 
    "Tutorial", "uri" -> "tutorial/BasicStatistics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.8.1"->{
  Cell[2423, 68, 79, 2, 70, "Title",
   CellTags->{"S3.8.1", "1.1"},
   CellID->23729]},
 "1.1"->{
  Cell[2423, 68, 79, 2, 70, "Title",
   CellTags->{"S3.8.1", "1.1"},
   CellID->23729]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.8.1", 23979, 807},
 {"1.1", 24078, 811}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1798, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2423, 68, 79, 2, 70, "Title",
 CellTags->{"S3.8.1", "1.1"},
 CellID->23729],
Cell[2505, 72, 1930, 61, 70, "DefinitionBox",
 CellID->24081],
Cell[4438, 135, 75, 1, 70, "Caption",
 CellID->2995],
Cell[4516, 138, 739, 31, 70, "Text",
 CellID->2678],
Cell[5258, 171, 1497, 55, 70, "Text",
 CellID->24676],
Cell[6758, 228, 505, 20, 70, "Text",
 CellID->27753],
Cell[7266, 250, 407, 9, 70, "Text",
 CellID->20899],
Cell[7676, 261, 553, 18, 70, "Text",
 CellID->11784],
Cell[8232, 281, 693, 27, 70, "Text",
 CellID->15565],
Cell[8928, 310, 1094, 44, 70, "Text",
 CellID->3093],
Cell[10025, 356, 1679, 52, 70, "Text",
 CellID->13608],
Cell[11707, 410, 1449, 49, 70, "Text",
 CellID->6172],
Cell[13159, 461, 1756, 45, 70, "DefinitionBox",
 CellID->11243],
Cell[14918, 508, 75, 1, 70, "Caption",
 CellID->29929],
Cell[14996, 511, 1107, 37, 70, "Text",
 CellID->7514],
Cell[16106, 550, 619, 26, 70, "Text",
 CellID->10168],
Cell[16728, 578, 1889, 62, 70, "DefinitionBox",
 CellID->5055],
Cell[18620, 642, 67, 1, 70, "Caption",
 CellID->11191],
Cell[18690, 645, 266, 7, 70, "Text",
 CellID->5973],
Cell[18959, 654, 150, 4, 70, "MathCaption",
 CellID->8922],
Cell[CellGroupData[{
Cell[19134, 662, 312, 11, 70, "Input",
 CellID->6748],
Cell[19449, 675, 422, 15, 51, "Output",
 CellID->5651]
}, Open  ]],
Cell[19886, 693, 581, 20, 70, "Text",
 CellID->10986],
Cell[CellGroupData[{
Cell[20492, 717, 72, 1, 70, "RelatedTutorialsSection",
 CellID->410023976],
Cell[20567, 720, 183, 4, 70, "RelatedTutorials",
 CellID->618122]
}, Open  ]],
Cell[CellGroupData[{
Cell[20787, 729, 97, 1, 70, "TutorialRelatedLinksSection",
 CellID->90610441],
Cell[20887, 732, 430, 13, 70, "TutorialRelatedLinks",
 CellID->437201265]
}, Open  ]]
}, Open  ]],
Cell[21344, 749, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

