(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25719,        886]
NotebookOptionsPosition[     20331,        710]
NotebookOutlinePosition[     22703,        771]
CellTagsIndexPosition[     22609,        765]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BinaryRead" :> 
         Documentation`HelpLookup["paclet:ref/BinaryRead"], "BinaryReadList" :> 
         Documentation`HelpLookup["paclet:ref/BinaryReadList"], "BinaryWrite" :> 
         Documentation`HelpLookup["paclet:ref/BinaryWrite"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"BinaryRead\"\>", 
      2->"\<\"BinaryReadList\"\>", 
      3->"\<\"BinaryWrite\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Binary Files", "Title",
 CellTags->{"S2.12.11", "11.1"},
 CellID->28162],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " handle ordinary printable text. But in dealing with external data files or \
devices it is sometimes necessary to go to a lower level, and work directly \
with raw binary data. You can do this using ",
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16955],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BinaryRead",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BinaryRead"], "[", 
     StyleBox["stream", "TI"], "]"}], Cell["read one byte", "TableText"]},
   {
    RowBox[{
     ButtonBox["BinaryRead",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BinaryRead"], "[", 
     StyleBox["stream", "TI"], ",", 
     StyleBox["type", "TI"], "]"}], Cell[
    "read an object of the specified type", "TableText"]},
   {
    RowBox[{
     ButtonBox["BinaryRead",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BinaryRead"], "[", 
     StyleBox["stream", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["type", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["type", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "read a list of objects", "TableText"]},
   {
    RowBox[{
     ButtonBox["BinaryWrite",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BinaryWrite"], "[", 
     StyleBox["stream", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell["write one byte", "TableText"]},
   {
    RowBox[{
     ButtonBox["BinaryWrite",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BinaryWrite"], "[", 
     StyleBox["stream", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["b", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["b", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "write a sequence of bytes", "TableText"]},
   {
    RowBox[{
     ButtonBox["BinaryWrite",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BinaryWrite"], "[", 
     StyleBox["stream", "TI"], ",", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}], Cell[
    "write the characters in a string", "TableText"]},
   {
    RowBox[{
     ButtonBox["BinaryWrite",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BinaryWrite"], "[", 
     StyleBox["stream", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["type", "TI"], "]"}], Cell[
    "write an object of the specified type", "TableText"]},
   {
    RowBox[{
     ButtonBox["BinaryWrite",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BinaryWrite"], "[", 
     StyleBox["stream", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["type", "TI"], "]"}], Cell[
    "write a sequence of objects", "TableText"]},
   {
    RowBox[{
     ButtonBox["BinaryWrite",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BinaryWrite"], "[", 
     RowBox[{
      StyleBox["stream", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["type", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["type", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["write objects of different types", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, True, False, False, False, False, False, False, 
     False, False, {False}, False}, "RowsIndexed" -> {}}},
 CellID->23183],

Cell["Reading and writing binary data. ", "Caption",
 CellID->8394],

Cell[BoxData[GridBox[{
   {"\"\<Byte\>\"", Cell["8\[Hyphen]bit unsigned integer", "TableText"]},
   {"\"\<Character8\>\"", Cell["8\[Hyphen]bit character", "TableText"]},
   {"\"\<Character16\>\"", Cell["16\[Hyphen]bit character", "TableText"]},
   {"\"\<Complex64\>\"", Cell["\<\
IEEE single\[Hyphen]precision complex number\
\>", "TableText"]},
   {"\"\<Complex128\>\"", Cell["\<\
IEEE double\[Hyphen]precision complex number\
\>", "TableText"]},
   {"\"\<Complex256\>\"", Cell["\<\
IEEE quad\[Hyphen]precision complex number\
\>", "TableText"]},
   {"\"\<Integer8\>\"", Cell["8\[Hyphen]bit signed integer", "TableText"]},
   {"\"\<Integer16\>\"", Cell["16\[Hyphen]bit signed integer", "TableText"]},
   {"\"\<Integer32\>\"", Cell["32\[Hyphen]bit signed integer", "TableText"]},
   {"\"\<Integer64\>\"", Cell["64\[Hyphen]bit signed integer", "TableText"]},
   {"\"\<Integer128\>\"", Cell[
    "128\[Hyphen]bit signed integer", "TableText"]},
   {"\"\<Real32\>\"", Cell["\<\
IEEE single\[Hyphen]precision real number\
\>", "TableText"]},
   {"\"\<Real64\>\"", Cell["\<\
IEEE double\[Hyphen]precision real number\
\>", "TableText"]},
   {"\"\<Real128\>\"", Cell["\<\
IEEE quad\[Hyphen]precision real number\
\>", "TableText"]},
   {"\"\<TerminatedString\>\"", Cell["\<\
null\[Hyphen]terminated string of 8\[Hyphen]bit characters\
\>", "TableText"]},
   {"\"\<UnsignedInteger8\>\"", Cell[
    "8\[Hyphen]bit unsigned integer", "TableText"]},
   {"\"\<UnsignedInteger16\>\"", Cell[
    "16\[Hyphen]bit unsigned integer", "TableText"]},
   {"\"\<UnsignedInteger32\>\"", Cell[
    "32\[Hyphen]bit unsigned integer", "TableText"]},
   {"\"\<UnsignedInteger64\>\"", Cell[
    "64\[Hyphen]bit unsigned integer", "TableText"]},
   {"\"\<UnsignedInteger128\>\"", Cell[
    "128\[Hyphen]bit unsigned integer", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}}},
 CellID->30180],

Cell[TextData[{
 "Types supported in ",
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->16097],

Cell["This writes a sequence of bytes to a file. ", "MathCaption",
 CellID->3065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryWrite", "[", 
  RowBox[{"\"\<tmp\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"97", ",", "98", ",", "99", ",", "100", ",", "101"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->27065],

Cell[BoxData["\<\"tmp\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->2513]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 " automatically opens a stream for the file. This closes it. "
}], "MathCaption",
 CellID->9261],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "\"\<tmp\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->12578],

Cell["\<\
This reads the first byte from the file, returning it as an integer. \
\>", "MathCaption",
 CellID->21078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryRead", "[", "\"\<tmp\>\"", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->16878],

Cell[BoxData["97"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->14140]
}, Open  ]],

Cell["This reads the second 8 bits in the file as character. ", "MathCaption",
 CellID->4611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryRead", "[", 
  RowBox[{"\"\<tmp\>\"", ",", "\"\<Character8\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->31947],

Cell[BoxData["\<\"b\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->2445]
}, Open  ]],

Cell["\<\
This reads the next 32 bits as a 32\[Hyphen]bit integer. \
\>", "MathCaption",
 CellID->170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryRead", "[", 
  RowBox[{"\"\<tmp\>\"", ",", "\"\<Integer32\>\""}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->29975],

Cell[BoxData["EndOfFile"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->13489]
}, Open  ]],

Cell[TextData[{
 "Like ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 " work with streams. But if you give a file name, they automatically open \
the specified file as a stream. To create a stream directly you can use ",
 Cell[BoxData[
  ButtonBox["OpenRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenRead"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite"]], "InlineFormula"],
 ". On some computer systems, the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinaryFormat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryFormat"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is required for any stream to be used with ",
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 ", in order to prevent possible corruption from such issues as newline \
translation."
}], "Text",
 CellID->24750],

Cell[TextData[{
 "In using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " you are normally completely insulated from the raw representation of data \
inside your computer. But with ",
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 " this is no longer so. One of the subtleties that then arises is that \
different computers may take the bytes that make up numbers to be in \
different orders, as specified by their setting for ",
 Cell[BoxData[
  ButtonBox["$ByteOrdering",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ByteOrdering"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->6149],

Cell["\<\
This writes a 32\[Hyphen]bit integer to a file. \
\>", "MathCaption",
 CellID->3333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryWrite", "[", 
  RowBox[{"\"\<tmp2\>\"", ",", "45671", ",", "\"\<Integer32\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->13865],

Cell[BoxData["\<\"tmp2\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->22214]
}, Open  ]],

Cell["This closes the file. ", "MathCaption",
 CellID->17282],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "\"\<tmp2\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->27007],

Cell["\<\
This reads the integer back, but assuming an opposite byte ordering. \
\>", "MathCaption",
 CellID->27432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryRead", "[", 
  RowBox[{"\"\<tmp2\>\"", ",", "\"\<Integer32\>\"", ",", 
   RowBox[{"ByteOrdering", "->", 
    RowBox[{"-", "$ByteOrdering"}]}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->8896],

Cell[BoxData["1739718656"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->16367]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BinaryReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BinaryReadList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[
    "read all the bytes in a file", "TableText"]},
   {
    RowBox[{
     ButtonBox["BinaryReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BinaryReadList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["type", "TI"], "]"}], Cell[
    "read all the data, treating it as objects of a certain type", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["BinaryReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BinaryReadList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "{", 
     SubscriptBox[
      StyleBox["type", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["type", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "treat the data as objects of a sequence of types", "TableText"]},
   {
    RowBox[{
     ButtonBox["BinaryReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BinaryReadList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["types", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "read only the first ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " objects"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellID->28522],

Cell["Reading complete binary files. ", "Caption",
 CellID->4882],

Cell["\<\
This writes out a 128\[Hyphen]bit real number. \
\>", "MathCaption",
 CellID->31810],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryWrite", "[", 
  RowBox[{"\"\<tmp3\>\"", ",", "5.67891", ",", "\"\<Real128\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17641],

Cell[BoxData["\<\"tmp3\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->267417593]
}, Open  ]],

Cell["This reads back the bytes in the number. ", "MathCaption",
 CellID->2187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryReadList", "[", 
  RowBox[{"\"\<tmp3\>\"", ",", "\"\<Byte\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "224",
    ",", "89", ",", "187", ",", "237", ",", "66", ",", "115", ",", "107", ",",
    "1", ",", "64"}], "}"}]], "Output",
 ImageSize->{389, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->112860674]
}, Open  ]],

Cell["\<\
This reads back the bytes as a sequence of 32\[Hyphen]bit real numbers. \
\>", "MathCaption",
 CellID->6321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryReadList", "[", 
  RowBox[{"\"\<tmp3\>\"", ",", "\"\<Real32\>\""}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->6538],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"-", "2.4178516392292583`*^24"}], ",", "118.86591339111328`", ",", 
   "2.0221831798553467`"}], "}"}]], "Output",
 ImageSize->{256, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->31351]
}, Open  ]],

Cell["\<\
This treats the data as pairs containing a byte and a 32\[Hyphen]bit real. \
\>", "MathCaption",
 CellID->19447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryReadList", "[", 
  RowBox[{"\"\<tmp3\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Byte\>\"", ",", "\"\<Real32\>\""}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[12]:= ",
 CellID->24208],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "0.0033249855041503906`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"237", ",", "4.3245376619232606`*^-38"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"64", ",", "EndOfFile"}], "}"}]}], "}"}]], "Output",
 ImageSize->{446, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->9646]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 " allow complete flexibility in reading and writing raw binary data. But in \
many practical applications one instead wants to work only with particular \
predefined formats. You can do this using ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->22276],

Cell[TextData[{
 "In addition to many complex formats, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support files containing sequences of identical data elements, of the same \
types as in ",
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 ". They also support the ",
 Cell[BoxData["\"\<Bit\>\""], "InlineFormula"],
 " format, consisting of individual binary bits, represented as ",
 Cell[BoxData["0"], "InlineFormula"],
 " or ",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "Text",
 CellID->25759]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Binary Files - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 58.5452040}", "context" -> "", 
    "keywords" -> {
     "BinaryFormat", "binary format", "BinaryRead", "read binary", 
      "BinaryReadList", "BinaryWrite", "write binary", "bits", "byte format", 
      "ByteOrdering", "characters", "complex numbers", "data input", 
      "devices", "DOS files", "double binary format", "IEEE numbers", 
      "int binary format", "lowlevel data", "newline translation", "numbers", 
      "quad precision binary format", "raw data", "reading files", 
      "REAL binary format", "real numbers", "strings", 
      "unsigned integer binary format", "writing"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Functions like Read and Write handle ordinary printable text. But in \
dealing with external data files or devices it is sometimes necessary to go \
to a lower level, and work directly with raw binary data. You can do this \
using BinaryRead and BinaryWrite. Reading and writing binary data. Types \
supported in BinaryRead and BinaryWrite. ", "synonyms" -> {"2.12.11"}, 
    "title" -> "Binary Files", "type" -> "Tutorial", "uri" -> 
    "tutorial/BinaryFiles"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.12.11"->{
  Cell[1417, 45, 78, 2, 70, "Title",
   CellTags->{"S2.12.11", "11.1"},
   CellID->28162]},
 "11.1"->{
  Cell[1417, 45, 78, 2, 70, "Title",
   CellTags->{"S2.12.11", "11.1"},
   CellID->28162]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.12.11", 22391, 754},
 {"11.1", 22494, 758}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 792, 18, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1417, 45, 78, 2, 70, "Title",
 CellTags->{"S2.12.11", "11.1"},
 CellID->28162],
Cell[1498, 49, 766, 25, 70, "Text",
 CellID->16955],
Cell[2267, 76, 3559, 109, 70, "DefinitionBox",
 CellID->23183],
Cell[5829, 187, 67, 1, 70, "Caption",
 CellID->8394],
Cell[5899, 190, 2146, 49, 70, "DefinitionBox",
 CellID->30180],
Cell[8048, 241, 334, 13, 70, "Caption",
 CellID->16097],
Cell[8385, 256, 81, 1, 70, "MathCaption",
 CellID->3065],
Cell[CellGroupData[{
Cell[8491, 261, 226, 7, 28, "Input",
 CellID->27065],
Cell[8720, 270, 164, 5, 36, "Output",
 CellID->2513]
}, Open  ]],
Cell[8899, 278, 238, 7, 70, "MathCaption",
 CellID->9261],
Cell[9140, 287, 126, 4, 70, "Input",
 CellID->12578],
Cell[9269, 293, 116, 3, 70, "MathCaption",
 CellID->21078],
Cell[CellGroupData[{
Cell[9410, 300, 113, 3, 70, "Input",
 CellID->16878],
Cell[9526, 305, 156, 5, 36, "Output",
 CellID->14140]
}, Open  ]],
Cell[9697, 313, 93, 1, 70, "MathCaption",
 CellID->4611],
Cell[CellGroupData[{
Cell[9815, 318, 153, 4, 70, "Input",
 CellID->31947],
Cell[9971, 324, 162, 5, 36, "Output",
 CellID->2445]
}, Open  ]],
Cell[10148, 332, 102, 3, 70, "MathCaption",
 CellID->170],
Cell[CellGroupData[{
Cell[10275, 339, 152, 4, 70, "Input",
 CellID->29975],
Cell[10430, 345, 163, 5, 36, "Output",
 CellID->13489]
}, Open  ]],
Cell[10608, 353, 1630, 54, 70, "Text",
 CellID->24750],
Cell[12241, 409, 811, 24, 70, "Text",
 CellID->6149],
Cell[13055, 435, 94, 3, 70, "MathCaption",
 CellID->3333],
Cell[CellGroupData[{
Cell[13174, 442, 171, 5, 70, "Input",
 CellID->13865],
Cell[13348, 449, 166, 5, 36, "Output",
 CellID->22214]
}, Open  ]],
Cell[13529, 457, 61, 1, 70, "MathCaption",
 CellID->17282],
Cell[13593, 460, 127, 4, 70, "Input",
 CellID->27007],
Cell[13723, 466, 116, 3, 70, "MathCaption",
 CellID->27432],
Cell[CellGroupData[{
Cell[13864, 473, 230, 6, 70, "Input",
 CellID->8896],
Cell[14097, 481, 164, 5, 36, "Output",
 CellID->16367]
}, Open  ]],
Cell[14276, 489, 1665, 49, 70, "DefinitionBox",
 CellID->28522],
Cell[15944, 540, 65, 1, 70, "Caption",
 CellID->4882],
Cell[16012, 543, 94, 3, 70, "MathCaption",
 CellID->31810],
Cell[CellGroupData[{
Cell[16131, 550, 170, 5, 70, "Input",
 CellID->17641],
Cell[16304, 557, 169, 5, 36, "Output",
 CellID->267417593]
}, Open  ]],
Cell[16488, 565, 79, 1, 70, "MathCaption",
 CellID->2187],
Cell[CellGroupData[{
Cell[16592, 570, 150, 4, 70, "Input",
 CellID->6705],
Cell[16745, 576, 368, 10, 36, "Output",
 CellID->112860674]
}, Open  ]],
Cell[17128, 589, 118, 3, 70, "MathCaption",
 CellID->6321],
Cell[CellGroupData[{
Cell[17271, 596, 154, 4, 70, "Input",
 CellID->6538],
Cell[17428, 602, 305, 9, 39, "Output",
 CellID->31351]
}, Open  ]],
Cell[17748, 614, 122, 3, 70, "MathCaption",
 CellID->19447],
Cell[CellGroupData[{
Cell[17895, 621, 217, 7, 70, "Input",
 CellID->24208],
Cell[18115, 630, 495, 16, 39, "Output",
 CellID->9646]
}, Open  ]],
Cell[18625, 649, 748, 24, 70, "Text",
 CellID->22276],
Cell[19376, 675, 913, 30, 70, "Text",
 CellID->25759]
}, Open  ]],
Cell[20304, 708, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

